/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.oms_control;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ACREvent;
import com.spss.java_client.ui.controls.ACRWidget;
import com.spss.java_client.ui.controls.IACRListener;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.uitools.controls.ContextEnabledTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;

public class OmsLabelSubDialog
extends BaseSubDialog
implements IACRListener,
CaretListener {
    private StringTextField mLabelText;
    private ACRWidget mACRWidget;

    public OmsLabelSubDialog(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_OMS_LABEL_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_oms_table_labels";
    }

    @Override
    public boolean continuePressed() {
        if (this.mLabelText.getText().length() > 0 && (this.mACRWidget.isAddEnabled() || this.mACRWidget.isChangeEnabled() || this.mACRWidget.isRemoveEnabled())) {
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_OMS_LABEL_PENDING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            return n == 0;
        }
        return super.continuePressed();
    }

    @Override
    public void listChanged(ACREvent aCREvent) {
        ACREvent.EventType eventType = aCREvent.getEventType();
        if (eventType.equals((Object)ACREvent.EventType.listItemAdd)) {
            this.updateContinueButton();
        }
        if (eventType.equals((Object)ACREvent.EventType.listItemRemove)) {
            this.updateContinueButton(true);
        }
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource() == this.mLabelText && this.mACRWidget.isAddEnabled()) {
            String string = this.mACRWidget.trimQuotes(this.mLabelText.getText());
            if (string.length() > 255) {
                string = string.substring(0, 255);
            }
            if (this.mACRWidget.isDuplicate(string)) {
                this.mACRWidget.setAddEnabled(false);
            }
        }
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        String string = dialogDataModel.getString("IDS_LABEL_TEXT");
        dialogDataModel.putArray("LIST_ACTION", null);
        DefaultListModel defaultListModel = (DefaultListModel)this.mACRWidget.getList().getModel();
        defaultListModel.clear();
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = ((String)stringTokenizer.nextElement()).trim();
                if ((string2 = this.mACRWidget.trimQuotes(string2)).length() > 255) {
                    string2 = string2.substring(0, 255);
                }
                if (string2.length() <= 0 || this.mACRWidget.isDuplicate(string2)) continue;
                defaultListModel.addElement(string2);
            }
        }
        this.enableContinue(false);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupUI(jPanel);
        this.pack();
    }

    private void initVars() {
        this.mLabelText = new StringTextField();
        this.mLabelText.setDocument((Document)ContextEnabledTextField.createLimitBytesDocument((int)255));
        this.mLabelText.addCaretListener(this);
        this.mACRWidget = new ACRWidget((JTextField)((Object)this.mLabelText));
        this.mACRWidget.setTrimQuotes(true);
        this.mACRWidget.addACRListener(this);
        this.enableContinue(false);
    }

    private JPanel setupUI(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_OMS_LABELS_LABEL_COLON");
        jLabel.setLabelFor((Component)((Object)this.mLabelText));
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_OMS_LABELS_SELECTED_LABELS_COLON");
        jLabel2.setLabelFor(this.mACRWidget);
        this.mACRWidget.setMinimumSize(this.mACRWidget.getPreferredSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mLabelText), gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mACRWidget, gridBagConstraints, 0, 3, 1, 1, n, insets);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_OMS_LABELS_NOTE"));
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setDisabledTextColor(jTextArea.getForeground());
        jTextArea.setEnabled(false);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 4, 1, 1, n, insets);
        this.pack();
        return jPanel2;
    }

    private void updateContinueButton() {
        this.enableContinue(this.mACRWidget.getList().getModel().getSize() > 0);
    }

    private void updateContinueButton(boolean bl) {
        this.enableContinue(bl);
    }
}

