/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.oms_control;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.documents.output.OMS.IOmsEventListener;
import com.spss.java_client.core.documents.output.OMS.OmParsedColumn;
import com.spss.java_client.core.documents.output.OMS.OmsColumns;
import com.spss.java_client.core.documents.output.OMS.OmsDestinationFormat;
import com.spss.java_client.core.documents.output.OMS.OmsManager;
import com.spss.java_client.core.documents.output.OMS.OmsObjectSelector;
import com.spss.java_client.core.documents.output.OMS.OmsOutputSpecification;
import com.spss.java_client.core.documents.output.OMS.OmsViewerSelectType;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.utilities.oms_control.Destination;
import com.spss.java_client.ui.dialogs.base.utilities.oms_control.OmsLabelSubDialog;
import com.spss.java_client.ui.dialogs.base.utilities.oms_control.OmsLoggingSubDialog;
import com.spss.java_client.ui.dialogs.base.utilities.oms_control.OmsOptionSubDialog;
import com.spss.java_client.ui.dialogs.base.utilities.oms_control.OmsRequest;
import com.spss.java_client.ui.dialogs.base.utilities.oms_control.OmsTableModel;
import com.spss.java_client.ui.dialogs.base.utilities.oms_control.OmsToolTipHeader;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FocusableLabel;
import com.spss.uitools.util.CharacterUtil;
import com.spss.uitools.util.IniHandler;
import com.spss.uitools.util.TraceSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class OmsCtrlPanelDlg
extends BaseProcedureDialog
implements ListSelectionListener,
ItemListener,
DocumentListener,
TableModelListener,
KeyListener,
FocusListener,
IOmsEventListener {
    private static final String LABEL_BUTTON = "IDS_LABELS_BUTTON";
    private static final String IDENTIFIER_LIST = "IDENTIFIER_LIST";
    private static final String OUTPUT_TYPE_LIST = "OUTPUT_TYPE_LIST";
    private static final String EXCLUDE_VIEWER_CHECK = "IDS_OMS_EXCLUDE_VIEWER_CHECK";
    private static final String FOLDER_BROWSE_BUTTON = "IDS_OMS_FOLDER_BROWSE_BUTTON";
    private static final String FILE_BROWSE_BUTTON = "IDS_OMS_FILE_BROWSE_BUTTON";
    private static final String IDS_OMS_OBJECT_NAME_RADIO = "IDS_OMS_OBJECT_NAME_RADIO";
    private static final String IDS_OMS_FILE_RADIO = "IDS_OMS_FILE_RADIO";
    private static final String ADD_BUTTON = "IDS_OMS_ADD_BUTTON";
    private static final String LOGGING_BUTTON = "IDS_OMS_LOGGING_BUTTON";
    private static final String DELETE_BUTTON = "IDS_OMS_DELETE_BUTTON";
    private static final String END_ALL_BUTTON = "IDS_OMS_END_ALL_BUTTON";
    private static final String END_BUTTON = "IDS_OMS_END_BUTTON";
    private static final String IDS_OMS_OPTION_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    static final String IDS_OMS_DATASET_RADIO = "IDS_OMS_DATASET_RADIO";
    static final String LABEL_TEXT = "IDS_LABEL_TEXT";
    static boolean isNewRowAdded = false;
    private String IDS_ALL;
    private String IDS_MODELS;
    private String IDS_TREES;
    private String IDS_WARNINGS;
    private String IDS_HEADINGS;
    private String IDS_TEXTS;
    private String IDS_TABLES;
    private String IDS_LOGS;
    private String IDS_CHARTS;
    public String[] mComboArray;
    private PlainList mOutputTypeList;
    private PlainList mIdentifierList;
    private JList mSubTypeList;
    private StringTextField mIdField;
    private JButton mLabelButton;
    private StringTextField mLabelField;
    private JRadioButton mNoneRadio;
    private JRadioButton mFileRadio;
    private JRadioButton mObjectNameRadio;
    private JRadioButton mDataSetRadio;
    private JLabel mFolderLabel;
    private JScrollPane mSubTypeScrollPane;
    private FileTextField mFileText;
    private FileTextField mFolderText;
    private StringTextField mDatasetText;
    private JCheckBox mExcludeCheck;
    private JButton mFileBrowseButton;
    private JButton mFolderBrowseButton;
    private PlainTable mRequestTable;
    private ArrayList<String> mOutputList;
    private JButton mAddButton;
    private JButton mEndButton;
    private JButton mEndAllButton;
    private JButton mDelButton;
    private JButton mLoggingButton;
    private JButton mOptionButton;
    private OmsTableModel mRequestTableModel;
    private DefaultListModel mSubTypeListModel;
    private Comparator<Object> mComparator;
    private boolean mAllIdentifiersSelected = false;
    private String ACTIVE_STATUS_TEXT = "active";
    private String NEW_STATUS_TEXT = "new";
    private String END_STATUS_TEXT = "end";
    private Timer mTimer;

    public OmsCtrlPanelDlg(JFrame jFrame) {
        super(jFrame, false, UtilitiesResBundle.getDefaultResourceBundleName(), UtilitiesResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_OMS_CONTROL_TITLE"));
        OutputManager.getOutputManager().getOmsManager().addOmsListener((IOmsEventListener)this);
        this.mTimer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!OmsCtrlPanelDlg.this.isVisible()) {
                    OmsCtrlPanelDlg.this.mTimer.stop();
                    OmsCtrlPanelDlg.this.mTimer = null;
                    OutputManager.getOutputManager().getOmsManager().removeOmsListener((IOmsEventListener)OmsCtrlPanelDlg.this);
                }
            }
        });
        this.mTimer.start();
    }

    @Override
    public boolean okPastePressed() {
        List<OmsRequest> list = this.mRequestTableModel.getRequestObjects();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (OmsRequest omsRequest : list) {
            if (omsRequest.getStatus().equals(this.ACTIVE_STATUS_TEXT)) {
                ++n;
                continue;
            }
            if (omsRequest.getStatus().equals(this.NEW_STATUS_TEXT)) {
                ++n2;
                continue;
            }
            if (!omsRequest.getStatus().equals(this.END_STATUS_TEXT)) continue;
            ++n3;
            ++n;
        }
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        boolean bl = false;
        if (dialogDataModel.getBoolean("IDS_OMS_LOG_ACTIVITY_CHECK") != null) {
            bl = dialogDataModel.getBoolean("IDS_OMS_LOG_ACTIVITY_CHECK");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getResString("IDS_OMS_SUMMARY_LABEL"));
        stringBuilder.append("\n\n");
        stringBuilder.append(this.getResString("IDS_OMS_ACTIVE_SUMMARY_LABEL")).append(n);
        stringBuilder.append("\n");
        stringBuilder.append(this.getResString("IDS_OMS_END_SUMMARY_LABEL")).append(n3);
        stringBuilder.append("\n");
        stringBuilder.append(this.getResString("IDS_OMS_CREATE_SUMMARY_LABEL")).append(n2);
        stringBuilder.append("\n");
        if (bl) {
            stringBuilder.append(this.getResString("IDS_OMS_LOGGING_SUMMARY_LABEL")).append(this.getResString("IDS_OMS_LOGGING_ENABLED"));
        } else {
            stringBuilder.append(this.getResString("IDS_OMS_LOGGING_SUMMARY_LABEL")).append(this.getResString("IDS_OMS_LOGGING_DISABLED"));
        }
        stringBuilder.append("\n");
        stringBuilder.append("\n");
        stringBuilder.append(this.getResString("IDS_OMS_SUMMARY_NOTE_LABEL"));
        boolean bl2 = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), stringBuilder.toString(), this.getResString("IDS_OMS_SUMMARY_TITLE"), SpssAlertOptionPane.IconType.eNone, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) == 0;
        return bl2;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_full_oms_gui";
    }

    @Override
    public String getIActionKey() {
        return "utilities_oms_control_panel";
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Object object = listSelectionEvent.getSource();
        if (object.equals(this.mOutputTypeList) || object.equals(this.mSubTypeList)) {
            this.enableAddButton();
            this.mLabelButton.setEnabled(!this.mIdentifierList.isSelectionEmpty());
            this.mLabelField.setEnabled(!this.mIdentifierList.isSelectionEmpty());
            this.mLabelField.setOpaque(!this.mIdentifierList.isSelectionEmpty());
        } else if (object.equals(this.mIdentifierList)) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.mAllIdentifiersSelected = this.mIdentifierList.getModel().getSize() == this.mIdentifierList.getSelectedIndices().length;
            }
            this.enableLabelFields();
        } else if (object.equals(this.mRequestTable.getSelectionModel()) && !listSelectionEvent.getValueIsAdjusting() && (n = this.mRequestTable.getSelectedRow()) > -1) {
            OmsRequest omsRequest = this.mRequestTableModel.getRow(n);
            String string = omsRequest.getStatus();
            if (string.equals(this.END_STATUS_TEXT)) {
                this.mEndButton.setText(this.getResString("IDS_OMS_RESTORE_BUTTON"));
                this.mEndButton.setEnabled(true);
                this.mDelButton.setEnabled(false);
            } else if (string.equals(this.ACTIVE_STATUS_TEXT)) {
                this.mEndButton.setText(this.getResString(END_BUTTON));
                this.mEndButton.setEnabled(true);
                this.mDelButton.setEnabled(false);
            } else if (string.equals(this.NEW_STATUS_TEXT)) {
                this.mEndButton.setText(this.getResString(END_BUTTON));
                this.mEndButton.setEnabled(false);
                this.mDelButton.setEnabled(true);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    private void enableLabelFields() {
        this.mLabelButton.setEnabled(!this.mIdentifierList.isSelectionEmpty());
        this.mLabelField.setEnabled(!this.mIdentifierList.isSelectionEmpty());
        this.mLabelField.setOpaque(!this.mIdentifierList.isSelectionEmpty());
        this.enableAddButton();
        Object[][] objectArray = this.getCellData();
        Object[] objectArray2 = this.mIdentifierList.getSelectedValues();
        this.mSubTypeListModel.clear();
        TreeSet<Object> treeSet = new TreeSet<Object>(this.mComparator);
        for (Object object : objectArray2) {
            String string = object.toString();
            Vector<String> vector = null;
            for (Object[] objectArray3 : objectArray) {
                String string2 = objectArray3[1].toString().trim();
                if (!string2.equalsIgnoreCase(string)) continue;
                vector = this.getSubTypes(objectArray3[0].toString());
            }
            if (vector == null) continue;
            for (String string3 : vector) {
                treeSet.add(string3);
            }
        }
        for (String string : treeSet) {
            this.mSubTypeListModel.addElement(string);
        }
        this.mSubTypeList.setModel(this.mSubTypeListModel);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableAddButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableAddButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableAddButton();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.mEndAllButton.setEnabled(false);
        List<OmsRequest> list = this.mRequestTableModel.getRequestObjects();
        for (OmsRequest omsRequest : list) {
            if (omsRequest.getStatus().equals(this.ACTIVE_STATUS_TEXT)) {
                this.mEndAllButton.setEnabled(true);
                continue;
            }
            if (omsRequest.getStatus().equals(this.NEW_STATUS_TEXT)) {
                this.enableOkPaste(true);
                this.mDelButton.setEnabled(true);
                this.mEndButton.setEnabled(false);
                continue;
            }
            if (!omsRequest.getStatus().equals(this.END_STATUS_TEXT)) continue;
            this.enableOkPaste(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableAddButton();
        boolean bl = this.mFileRadio.isSelected();
        boolean bl2 = this.mObjectNameRadio.isSelected();
        boolean bl3 = this.mDataSetRadio.isSelected();
        this.mOptionButton.setEnabled(bl || bl2 || bl3);
        this.mFileText.setEnabled(bl);
        this.mFileText.setOpaque(bl);
        this.mFileBrowseButton.setEnabled(bl);
        this.mFolderLabel.setEnabled(bl2);
        this.mFolderText.setEnabled(bl2);
        this.mFolderText.setOpaque(bl2);
        this.mFolderBrowseButton.setEnabled(bl2);
        this.mDatasetText.setEnabled(bl3);
        this.mDatasetText.setOpaque(bl3);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n;
        if (keyEvent.getKeyChar() == '\t') {
            Component component = this.getFocusTraversalPolicy().getComponentAfter((Container)((Object)this), (Component)keyEvent.getSource());
            component.requestFocus();
        } else if (keyEvent.getKeyCode() == 127 && (n = this.mRequestTable.getSelectedRow()) > -1) {
            this.mRequestTableModel.removeRequest(n);
            this.mDelButton.setEnabled(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public void notifyOmsEvent(OmsViewerSelectType omsViewerSelectType, int n) {
        if (!this.isVisible()) {
            return;
        }
        if (omsViewerSelectType == OmsViewerSelectType.kSelect || omsViewerSelectType == OmsViewerSelectType.kUnselect) {
            for (int i = this.mRequestTableModel.getRowCount() - 1; i >= 0; --i) {
                OmsRequest omsRequest = this.mRequestTableModel.getRow(i);
                if (!omsRequest.getStatus().equals(this.ACTIVE_STATUS_TEXT) && !omsRequest.getStatus().equals(this.END_STATUS_TEXT)) continue;
                this.mRequestTableModel.removeRequest(i);
            }
            this.loadRequestObjects();
        } else if (omsViewerSelectType == OmsViewerSelectType.kLog) {
            this.updateLogState();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.mRequestTableModel.clear();
        this.loadRequestObjects();
        this.mOutputTypeList.clearSelection();
        this.mIdentifierList.clearSelection();
        this.mSubTypeList.clearSelection();
        this.mEndButton.setText(this.getResString(END_BUTTON));
        this.mEndButton.setEnabled(false);
    }

    public String generateGraphicsImagesSyntax(OmsRequest omsRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        Destination destination = omsRequest.getDestinationFormat();
        if (omsRequest.isImage()) {
            String string = omsRequest.getImages();
            stringBuilder.append(" IMAGES=YES IMAGEFORMAT=");
            if (string.contains("JPG")) {
                stringBuilder.append("JPG");
            } else if (string.contains("PNG")) {
                stringBuilder.append("PNG");
            } else if (string.contains("BMP")) {
                stringBuilder.append("BMP");
            } else if (string.contains("EMF")) {
                stringBuilder.append("EMF");
            } else if (string.contains("VML")) {
                stringBuilder.append("VML");
            }
            stringBuilder.append(" CHARTSIZE=").append(omsRequest.getChartSize());
            if (omsRequest.isImageMaps()) {
                stringBuilder.append(" IMAGEMAP=YES");
            }
            if (destination.getFileFormat() == Destination.FileFormat.eOXML) {
                stringBuilder.append("\n   CHARTFORMAT=IMAGE TREEFORMAT=IMAGE MODELFORMAT=IMAGE");
            }
        } else {
            stringBuilder.append(" IMAGES=NO");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        List<OmsRequest> list = this.mRequestTableModel.getRequestObjects();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_OMS_LOG_ACTIVITY_CHECK");
        if (bl != null && this.logChanged()) {
            if (bl.booleanValue()) {
                stringBuffer.append("* ").append(this.getResString("IDS_OMS_IDENTIFIERS_SYNTAX_TITLE")).append(".");
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getMainCommand("OMSLOG "));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters("FILE="));
                stringBuffer.append(CharacterUtil.smartQuote((String)dialogDataModel.getString("LOGGING_FILE_TEXT")));
                stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/FORMAT="));
                if (dialogDataModel.getBoolean("IDS_OMS_LOGGING_XML_RADIO").booleanValue()) {
                    stringBuffer.append("XML");
                } else {
                    stringBuffer.append("TEXT");
                }
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            } else {
                stringBuffer.append("* OMSEND.\nOMSEND LOG.\n");
            }
        }
        for (OmsRequest omsRequest : list) {
            if (omsRequest.getStatus().equals(this.END_STATUS_TEXT)) {
                stringBuffer.append("* ").append(this.getResString("IDS_OMS_IDENTIFIERS_OMSEND_SYNTAX_TITLE")).append(".");
                stringBuffer.append("\n").append(SyntaxUtil.getMainCommand("OMSEND"));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters("TAG=["));
                stringBuffer.append(CharacterUtil.smartQuote((String)omsRequest.getId())).append("]");
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            }
            if (omsRequest.getStatus().equals(this.NEW_STATUS_TEXT)) {
                String string;
                String string22;
                String string32;
                String[] stringArray;
                Destination destination = omsRequest.getDestinationFormat();
                stringBuffer.append("* ").append(this.getResString("IDS_OMS_IDENTIFIERS_OMS_SYNTAX_TITLE")).append(".");
                stringBuffer.append("\n");
                if (destination.getFormatType() == Destination.DestFormat.eDataSet) {
                    stringBuffer.append(SyntaxUtil.getMainCommand("DATASET DECLARE "));
                    stringBuffer.append(SyntaxUtil.getMainCommandParamters(destination.toString()));
                    stringBuffer.append(SyntaxUtil.terminateSyntax());
                }
                stringBuffer.append(SyntaxUtil.getMainCommand("OMS"));
                stringBuffer.append("\n").append(SyntaxUtil.getSingleParameterSubCommand("SELECT", this.getSyntaxSelectType(omsRequest.getTypes()), true));
                StringBuffer stringBuffer2 = new StringBuffer();
                StringBuffer stringBuffer3 = new StringBuffer();
                String string4 = omsRequest.getCommands();
                if (string4.length() > 0 && !string4.equals(this.IDS_ALL)) {
                    stringArray = string4.trim().split(",");
                    stringBuffer2.append(" COMMANDS=[");
                    for (String string32 : stringArray) {
                        stringBuffer2.append(CharacterUtil.smartQuote((String)string32.trim())).append(" ");
                    }
                    stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
                    stringBuffer2.append(']');
                }
                if ((stringArray = omsRequest.getSubtypes()).length() > 0 && !stringArray.equals(this.IDS_ALL)) {
                    String[] stringArray2 = stringArray.trim().split(",");
                    stringBuffer3.append(" SUBTYPES=[");
                    for (String string22 : stringArray2) {
                        stringBuffer3.append(CharacterUtil.smartQuote((String)string22)).append(" ");
                    }
                    stringBuffer3.deleteCharAt(stringBuffer3.length() - 1);
                    stringBuffer3.append(']');
                }
                String string5 = omsRequest.getLabels();
                int n = string5.length();
                stringBuffer2.append(stringBuffer3);
                if (stringBuffer2.length() > 0 || n > 0) {
                    stringBuffer.append(SyntaxUtil.getSubCommand("/IF"));
                    stringBuffer.append(stringBuffer2);
                }
                if (n > 0) {
                    void object;
                    stringBuffer.append(" LABELS=[");
                    if (!(string5.charAt(0) == '\"' && string5.charAt(n - 1) == '\"' || string5.charAt(0) != '\'' && string5.charAt(n - 1) == '\'')) {
                        String string6 = CharacterUtil.smartQuote((String)string5);
                    }
                    stringBuffer.append((String)object).append("]");
                }
                if (stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
                    stringBuffer.append("").append(SyntaxUtil.getSubCommand("/DESTINATION"));
                } else {
                    stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/DESTINATION"));
                }
                String string7 = "TableNumber_";
                if (omsRequest.getNumber() != null) {
                    string7 = omsRequest.getNumber();
                }
                string32 = destination.getDestPath();
                if (destination.getFormatType() != Destination.DestFormat.eNone && string32 != null && string32.length() > 0) {
                    if (destination.getFileFormat() == Destination.FileFormat.eOXML) {
                        stringBuffer.append(" FORMAT=OXML");
                        stringBuffer.append(this.generateGraphicsImagesSyntax(omsRequest));
                    } else if (destination.getFileFormat() == Destination.FileFormat.eHTML) {
                        stringBuffer.append(" FORMAT=HTML");
                        stringBuffer.append(this.generateGraphicsImagesSyntax(omsRequest));
                    } else if (destination.getFileFormat() == Destination.FileFormat.eSAV) {
                        stringBuffer.append(" FORMAT=SAV NUMBERED=").append(string7);
                    } else if (destination.getFileFormat() == Destination.FileFormat.eSVWSOXML) {
                        stringBuffer.append(" FORMAT=SVWSOXML");
                    } else if (destination.getFileFormat() == Destination.FileFormat.eTEXT) {
                        stringBuffer.append(" FORMAT=TEXT");
                    } else if (destination.getFileFormat() == Destination.FileFormat.eTABTEXT) {
                        stringBuffer.append(" FORMAT=TABTEXT");
                    } else if (destination.getFileFormat() == Destination.FileFormat.eSPV) {
                        stringBuffer.append(" FORMAT=SPV");
                        if (omsRequest.isStaticTables()) {
                            stringBuffer.append(" TABLES=STATIC");
                        } else {
                            stringBuffer.append(" TABLES=PIVOTTABLE");
                        }
                    } else if (destination.getFileFormat() == Destination.FileFormat.eXLS) {
                        stringBuffer.append(" FORMAT=XLS");
                    } else if (destination.getFileFormat() == Destination.FileFormat.eXLSX || destination.getFileFormat() == Destination.FileFormat.eXLSM) {
                        stringBuffer.append(" FORMAT=XLSX");
                    } else if (destination.getFileFormat() == Destination.FileFormat.ePDF) {
                        stringBuffer.append(" FORMAT=PDF");
                    } else if (destination.getFileFormat() == Destination.FileFormat.eSPW) {
                        stringBuffer.append(" FORMAT=SPW");
                    } else if (destination.getFileFormat() == Destination.FileFormat.eDOC) {
                        stringBuffer.append(" FORMAT=DOC");
                    } else if (destination.getFileFormat() == Destination.FileFormat.eREPORTHTML) {
                        stringBuffer.append(" FORMAT=REPORTHTML");
                    } else if (destination.getFileFormat() == Destination.FileFormat.eREPORTMHT) {
                        stringBuffer.append(" FORMAT=REPORTMHT");
                    }
                }
                if (string32 != null && string32.length() > 0) {
                    stringBuffer.append("\n  ");
                    if (destination.getFormatType() == Destination.DestFormat.eFile) {
                        stringBuffer.append(" OUTFILE=").append(CharacterUtil.smartQuote((String)string32));
                    }
                    if (destination.getFormatType() == Destination.DestFormat.eFolder) {
                        stringBuffer.append(" OUTPUTSET=SUBTYPES FOLDER=").append(CharacterUtil.smartQuote((String)string32));
                    }
                    if (destination.getFormatType() == Destination.DestFormat.eDataSet) {
                        stringBuffer.append(" OUTFILE=").append(CharacterUtil.smartQuote((String)string32));
                    }
                }
                if ((string22 = omsRequest.getViewer()).contains("No")) {
                    stringBuffer.append(" VIEWER=NO");
                } else if (string22.contains("Yes")) {
                    stringBuffer.append(" VIEWER=YES");
                }
                if (omsRequest.getColumnForm() == OmsRequest.ColumnForm.eSEQUENCE) {
                    stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/COLUMNS SEQUENCE=[")).append(omsRequest.getColumns()).append("]");
                }
                if (omsRequest.getColumnForm() == OmsRequest.ColumnForm.eDIMNAMES) {
                    if (omsRequest.getColumns().contains("\"")) {
                        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/COLUMNS DIMNAMES=[")).append(omsRequest.getColumns()).append("]");
                    } else {
                        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/COLUMNS DIMNAMES=[")).append(CharacterUtil.smartQuote((String)omsRequest.getColumns())).append("]");
                    }
                }
                if ((string = omsRequest.getId()).trim().length() > 0 && !string.startsWith("$")) {
                    stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/TAG=")).append(CharacterUtil.smartQuote((String)string));
                }
                stringBuffer.append(SyntaxUtil.terminateSyntax());
                continue;
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private String getSyntaxSelectType(String string) {
        String string2 = string.trim();
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(this.getResString("IDS_OMS_OUTPUT_ALL"))) {
                stringBuilder.append("ALL ");
                continue;
            }
            if (string3.equals(this.getResString("IDS_OMS_OUTPUT_CHART"))) {
                stringBuilder.append("CHARTS ");
                continue;
            }
            if (string3.equals(this.getResString("IDS_OMS_OUTPUT_LOG"))) {
                stringBuilder.append("LOGS ");
                continue;
            }
            if (string3.equals(this.getResString("IDS_OMS_OUTPUT_TABLE"))) {
                stringBuilder.append("TABLES ");
                continue;
            }
            if (string3.equals(this.getResString("IDS_OMS_OUTPUT_TEXT"))) {
                stringBuilder.append("TEXTS ");
                continue;
            }
            if (string3.equals(this.getResString("IDS_OMS_OUTPUT_HEADING"))) {
                stringBuilder.append("HEADINGS ");
                continue;
            }
            if (string3.equals(this.getResString("IDS_OMS_OUTPUT_WARNING"))) {
                stringBuilder.append("WARNINGS ");
                continue;
            }
            if (string3.equals(this.getResString("IDS_OMS_OUTPUT_TREE"))) {
                stringBuilder.append("TREES ");
                continue;
            }
            if (string3.equals(this.getResString("IDS_OMS_OUTPUT_MODEL"))) {
                stringBuilder.append("MODELS ");
                continue;
            }
            TraceSettings.trace1((String)("Unknown OMS type: (" + string3 + ")"), (int)15);
        }
        return stringBuilder.toString().trim();
    }

    private boolean isSelectedType(int n, String string) {
        String string2 = (String)this.mOutputTypeList.getModel().getElementAt(n);
        if (string.equals("TABLES")) {
            return string2.equals(this.IDS_TABLES);
        }
        if (string.equals("MODELS")) {
            return string2.equals(this.IDS_MODELS);
        }
        if (string.equals("LOGS")) {
            return string2.equals(this.IDS_LOGS);
        }
        return string.equals("CHARTS") && string2.equals(this.IDS_CHARTS);
    }

    private boolean onlyGraphSelected() {
        int[] nArray;
        for (int n : nArray = this.mOutputTypeList.getSelectedIndices()) {
            String string = (String)this.mOutputTypeList.getModel().getElementAt(n);
            if (!string.equals(this.IDS_TABLES) && !string.equals(this.IDS_TEXTS) && !string.equals(this.IDS_WARNINGS) && !string.equals(this.IDS_HEADINGS) && !string.equals(this.IDS_LOGS)) continue;
            return false;
        }
        return true;
    }

    private boolean logChanged() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_OMS_LOG_ACTIVITY_CHECK");
        boolean bl2 = bl != null && bl != false;
        String string = bl2 ? dialogDataModel.getString("LOGGING_FILE_TEXT") : "";
        boolean bl3 = dialogDataModel.getBoolean("IDS_OMS_LOGGING_XML_RADIO");
        OmsManager omsManager = OutputManager.getOutputManager().getOmsManager();
        String string2 = omsManager.getLogPath();
        boolean bl4 = string2 != null && string2.length() > 0;
        boolean bl5 = omsManager.isXmlLogFormat();
        return bl2 != bl4 || !string.equals(string2) || bl3 != bl5;
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.setDefaults();
        this.getDialogDataModel().clear();
        this.mLabelField.setText("");
        this.enableOkPaste(false);
        this.loadRequestObjects();
        this.updateLogState();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupRequestPanel();
        JPanel jPanel3 = this.setupAddPanel();
        JPanel jPanel4 = this.setupListPanel();
        JPanel jPanel5 = this.setupDestinationPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 1, 2, n, insets);
        JLabel jLabel = new JLabel(this.getResString("IDS_OMS_OUTPUT_DESTINATION"));
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 1, 3, 1, 1, n, insets);
        this.setDefaults();
        this.initOutputList();
        this.loadAllList();
        this.setTabTraversalOrder();
        this.pack();
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRequestTable);
        vector.add(this.mEndButton);
        vector.add(this.mEndAllButton);
        vector.add(this.mDelButton);
        vector.add(this.mLoggingButton);
        vector.add(this.mAddButton);
        vector.add(this.mOutputTypeList);
        vector.add(this.mIdentifierList);
        vector.add(this.mSubTypeList);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mNoneRadio);
        spssButtonGroup.add(this.mFileRadio);
        spssButtonGroup.add(this.mObjectNameRadio);
        spssButtonGroup.add(this.mDataSetRadio);
        vector.add(spssButtonGroup);
        vector.add(this.mFileText);
        vector.add(this.mFileBrowseButton);
        vector.add(this.mFolderText);
        vector.add(this.mFolderBrowseButton);
        vector.add(this.mDatasetText);
        vector.add(this.mOptionButton);
        vector.add(this.mExcludeCheck);
        vector.add(this.mIdField);
        vector.add(this.mLabelButton);
        vector.add(this.mLabelField);
        Component[] componentArray = this.mCmdButtonPanel.getComponents();
        vector.addAll(Arrays.asList(componentArray));
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void loadRequestObjects() {
        boolean bl = OutputManager.getOutputManager().getOmsManager().isOmsActive();
        this.mEndAllButton.setEnabled(bl);
        Vector vector = OutputManager.getOutputManager().getOmsManager().getSelectors();
        for (OmsObjectSelector omsObjectSelector : vector) {
            this.addSelectorToTable(omsObjectSelector);
        }
        this.mEndButton.setEnabled(bl && this.mRequestTable.getSelectedRow() > -1);
    }

    /*
     * WARNING - void declaration
     */
    private void addSelectorToTable(OmsObjectSelector omsObjectSelector) {
        Object object;
        Object object2;
        void var6_24;
        void var6_21;
        void var6_19;
        void var6_17;
        void var6_14;
        void var6_12;
        void var6_8;
        String string;
        OmsRequest omsRequest = new OmsRequest();
        omsRequest.setStatus(this.ACTIVE_STATUS_TEXT);
        omsRequest.setId(omsObjectSelector.getOmsTag());
        List<OmsObjectSelector.SelectOption> list = this.getSelectedTypes(omsObjectSelector.getSelectedTypes());
        StringBuilder stringBuilder = new StringBuilder();
        if (list.size() == this.mOutputList.size()) {
            stringBuilder.append(this.IDS_ALL);
        } else {
            for (OmsObjectSelector.SelectOption object32 : list) {
                stringBuilder.append(this.getSelectType(object32)).append(" ");
            }
        }
        omsRequest.setTypes(stringBuilder.toString());
        Object object4 = omsObjectSelector.getIfOptions().getCommands();
        String string2 = "";
        Object object3 = ((Vector)object4).iterator();
        while (object3.hasNext()) {
            string = (String)object3.next();
            String string3 = (String)var6_8 + string + ",";
        }
        if (var6_8.length() > 0) {
            String string4 = this.removeLastCharacter((String)var6_8);
        } else {
            String string5 = this.IDS_ALL;
        }
        omsRequest.setCommands((String)var6_12);
        object4 = omsObjectSelector.getIfOptions().getSubtypes();
        String string6 = "";
        object3 = ((Vector)object4).iterator();
        while (object3.hasNext()) {
            string = (String)object3.next();
            String string7 = (String)var6_14 + string + ",";
        }
        if (var6_14.length() > 0) {
            String string8 = this.removeLastCharacter((String)var6_14);
        }
        if (stringBuilder.toString().trim().equals(this.IDS_TABLES) && var6_17.length() == 0) {
            String string9 = this.IDS_ALL;
        }
        omsRequest.setSubtypes((String)var6_19);
        object4 = omsObjectSelector.getIfOptions().getNames();
        String string10 = "";
        object3 = ((Vector)object4).iterator();
        while (object3.hasNext()) {
            string = (String)object3.next();
            String string11 = (String)var6_21 + string + ",";
        }
        if (var6_21.length() > 0) {
            String string12 = this.removeLastCharacter((String)var6_21);
        }
        omsRequest.setLabels(var6_24.trim());
        if (omsObjectSelector.getOutputSpec().getOutputType() == OmsOutputSpecification.OutputType.kOUTFILE) {
            object3 = omsObjectSelector.getOutputSpec().getDestOutFileExpression();
            omsRequest.setDestination((String)object3);
        }
        if (omsObjectSelector.getOutputSpec().getOutputType() == OmsOutputSpecification.OutputType.kOUTPUTSET) {
            object3 = omsObjectSelector.getOutputSpec().getDestFolder();
            omsRequest.setDestination((String)object3);
        }
        if (omsObjectSelector.getOutputSpec().getOutputType() == OmsOutputSpecification.OutputType.kOUTPUTTYPENONE) {
            omsRequest.setDestination(omsObjectSelector.getOmsTag());
        }
        object3 = this.getFormat(omsObjectSelector.getDestFormat());
        omsRequest.setFormat((String)object3);
        string = omsObjectSelector.getColumns().getColumnsForm();
        if (string == OmsColumns.COLUMNSFORM.kDIMNAMES) {
            void var6_26;
            object4 = omsObjectSelector.getColumns().getColDimName();
            String string13 = "";
            object2 = ((Vector)object4).iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                String string14 = (String)var6_26 + "\"" + (String)object + "\" ";
            }
            omsRequest.setColumns((String)var6_26);
        }
        if (string == OmsColumns.COLUMNSFORM.kSEQUENCE) {
            void var6_30;
            object2 = omsObjectSelector.getColumns().getColSequence();
            String string15 = "";
            object = ((Vector)object2).iterator();
            while (object.hasNext()) {
                OmParsedColumn omParsedColumn = (OmParsedColumn)object.next();
                String string16 = (String)var6_30 + omParsedColumn.getColumnToken() + " ";
            }
            omsRequest.setColumns((String)var6_30);
        }
        omsRequest.setViewer(omsObjectSelector.getDestIsViewer() ? "Yes" : "No");
        omsRequest.setNumber(omsObjectSelector.getNumColName());
        if (omsObjectSelector.getImageFormatSpecified()) {
            object = omsObjectSelector.getImageFormat();
            object2 = this.getImgFormat((OmsObjectSelector.ImageFormat)object);
            omsRequest.setImages("Included. Format=" + (String)object2 + ". size=" + omsObjectSelector.getChartSizeString() + "%");
            omsRequest.setImagesDe("image");
        }
        this.mRequestTableModel.addRequest(omsRequest);
    }

    private void initVars() {
        Object object;
        this.ACTIVE_STATUS_TEXT = this.getResString("IDS_ACTIVE");
        this.NEW_STATUS_TEXT = this.getResString("IDS_NEW");
        this.END_STATUS_TEXT = this.getResString("IDS_END");
        this.IDS_ALL = this.getResString("IDS_OMS_OUTPUT_ALL");
        this.IDS_MODELS = this.getResString("IDS_OMS_OUTPUT_MODEL");
        this.IDS_TREES = this.getResString("IDS_OMS_OUTPUT_TREE");
        this.IDS_WARNINGS = this.getResString("IDS_OMS_OUTPUT_WARNING");
        this.IDS_HEADINGS = this.getResString("IDS_OMS_OUTPUT_HEADING");
        this.IDS_TEXTS = this.getResString("IDS_OMS_OUTPUT_TEXT");
        this.IDS_TABLES = this.getResString("IDS_OMS_OUTPUT_TABLE");
        this.IDS_LOGS = this.getResString("IDS_OMS_OUTPUT_LOG");
        this.IDS_CHARTS = this.getResString("IDS_OMS_OUTPUT_CHART");
        this.initOutputList();
        this.mOutputTypeList = new PlainList(OUTPUT_TYPE_LIST);
        this.mOutputTypeList.addListSelectionListener(this);
        this.mIdentifierList = new PlainList(IDENTIFIER_LIST);
        this.mIdentifierList.addListSelectionListener(this);
        this.mIdentifierList.addFocusListener(this);
        Vector<String> vector = this.getAllSubTypes();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            object = vector.elementAt(i);
            object = ((String)object).substring(((String)object).indexOf("=") + 2, ((String)object).length());
            vector2.addElement((String)object);
            this.mComparator = new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    if (object instanceof String && object2 instanceof String) {
                        return object.toString().compareToIgnoreCase(object2.toString());
                    }
                    return 0;
                }
            };
            Collections.sort(vector2, this.mComparator);
        }
        this.mSubTypeList = new JList(vector2);
        this.mSubTypeListModel = new DefaultListModel();
        this.mSubTypeList.addListSelectionListener(this);
        this.mSubTypeScrollPane = new JScrollPane(this.mSubTypeList);
        this.mSubTypeScrollPane.setHorizontalScrollBarPolicy(31);
        this.mIdField = new StringTextField();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, LABEL_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OmsCtrlPanelDlg.this.runLabelsubDialog();
                Object[] objectArray = OmsCtrlPanelDlg.this.getDialogDataModel().getArray("LIST_ACTION");
                StringBuilder stringBuilder = new StringBuilder();
                if (objectArray != null) {
                    for (Object object : objectArray) {
                        String string = object.toString();
                        if (string.length() > 0 && (string.charAt(0) == '\'' || string.charAt(0) == '\"')) {
                            string = CharacterUtil.unSmartQuote((String)string);
                        }
                        stringBuilder.append("\"").append(string).append("\" ");
                    }
                    OmsCtrlPanelDlg.this.mLabelField.setText(stringBuilder.toString().trim());
                }
            }
        };
        this.mLabelButton = new JButton(toggleButtonAction);
        this.mFolderLabel = new JLabel(this.getResString("IDS_OMS_FOLDER"));
        this.mLabelField = new StringTextField();
        this.mLabelField.setDocument(new FixedLengthDocument(30000));
        this.mLabelField.setAction(new TextFieldAction(this, LABEL_TEXT));
        this.mLabelField.getDocument().addDocumentListener(this);
        this.mNoneRadio = new JRadioButton(this.getResString("IDS_OMS_NONE_RADIO"));
        this.mNoneRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, IDS_OMS_FILE_RADIO);
        this.mFileRadio = new JRadioButton(toggleButtonAction);
        this.mFileRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, IDS_OMS_OBJECT_NAME_RADIO);
        this.mObjectNameRadio = new JRadioButton(toggleButtonAction);
        this.mObjectNameRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, IDS_OMS_DATASET_RADIO);
        this.mDataSetRadio = new JRadioButton(toggleButtonAction);
        this.mDataSetRadio.addItemListener(this);
        this.mFileText = new FileTextField();
        this.mFileText.setColumns(10);
        this.mFileText.setFocusable(true);
        this.mFileText.getDocument().addDocumentListener(this);
        this.mFolderText = new FileTextField();
        this.mFolderText.setColumns(10);
        this.mFolderText.setFocusable(true);
        this.mFolderText.getDocument().addDocumentListener(this);
        this.mDatasetText = new StringTextField(10);
        this.mDatasetText.getDocument().addDocumentListener(this);
        toggleButtonAction = new ToggleButtonAction(this, EXCLUDE_VIEWER_CHECK);
        this.mExcludeCheck = new JCheckBox(toggleButtonAction);
        this.mExcludeCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, FILE_BROWSE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OmsCtrlPanelDlg.this.showBrowseFileDialog();
            }
        };
        this.mFileBrowseButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, FOLDER_BROWSE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OmsCtrlPanelDlg.this.showBrowseFolderDialog();
            }
        };
        this.mFolderBrowseButton = new JButton(toggleButtonAction);
        object = new ArrayList();
        String string = this.getResString("IDS_OMS_TABLE_HEADER_STATUS");
        String string2 = this.getResString("IDS_OMS_TABLE_HEADER_ID");
        String string3 = this.getResString("IDS_OMS_TABLE_HEADER_TYPES");
        String string4 = this.getResString("IDS_OMS_TABLE_HEADER_COMMANDS");
        String string5 = this.getResString("IDS_OMS_TABLE_HEADER_SUBTYPES");
        String string6 = this.getResString("IDS_OMS_TABLE_HEADER_LABELS");
        String string7 = this.getResString("IDS_OMS_TABLE_HEADER_DEST");
        String string8 = this.getResString("IDS_OMS_TABLE_HEADER_FORMAT");
        String string9 = this.getResString("IDS_OMS_TABLE_HEADER_COLUMN");
        String string10 = this.getResString("IDS_OMS_TABLE_HEADER_VIEWER");
        String string11 = this.getResString("IDS_OMS_TABLE_HEADER_NUMBER");
        String string12 = this.getResString("IDS_OMS_TABLE_HEADER_IMAGES");
        String string13 = this.getResString("IDS_OMS_TABLE_HEADER_IMAGEDE");
        object.add(" ");
        object.add("<HTML><B>" + string + "</B></HTML>");
        object.add("<HTML><B>" + string2 + "</B></HTML>");
        object.add("<HTML><B>" + string3 + "</B></HTML>");
        object.add("<HTML><B>" + string4 + "</B></HTML>");
        object.add("<HTML><B>" + string5 + "</B></HTML>");
        object.add("<HTML><B>" + string6 + "</B></HTML>");
        object.add("<HTML><B>" + string7 + "</B></HTML>");
        object.add("<HTML><B>" + string8 + "</B></HTML>");
        object.add("<HTML><B>" + string9 + "</B></HTML>");
        object.add("<HTML><B>" + string10 + "</B></HTML>");
        object.add("<HTML><B>" + string11 + "</B></HTML>");
        object.add("<HTML><B>" + string12 + "</B></HTML>");
        object.add("<HTML><B>" + string13 + "</B></HTML>");
        this.mRequestTableModel = new OmsTableModel();
        this.mRequestTableModel.setColumnNames((List<String>)object);
        this.mRequestTable = new PlainTable(this.mRequestTableModel);
        this.mRequestTable.addKeyListener(this);
        this.mRequestTable.setSelectionMode(0);
        this.mRequestTable.setAutoResizeMode(0);
        this.mRequestTableModel.addTableModelListener(this);
        this.mRequestTable.getSelectionModel().addListSelectionListener(this);
        String[] stringArray = this.getResStringArray("IDS_OMS_TOOLTIP_LIST");
        OmsToolTipHeader omsToolTipHeader = new OmsToolTipHeader(this.mRequestTable.getColumnModel());
        omsToolTipHeader.setToolTipStrings(stringArray);
        omsToolTipHeader.setReorderingAllowed(false);
        this.mRequestTable.setTableHeader(omsToolTipHeader);
        ImageColumnRenderer imageColumnRenderer = new ImageColumnRenderer();
        TableColumn tableColumn = this.mRequestTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(imageColumnRenderer);
        ((DefaultTableCellRenderer)imageColumnRenderer).setHorizontalAlignment(0);
        TableColumnModel tableColumnModel = this.mRequestTable.getColumnModel();
        block12: for (int i = 0; i < this.mRequestTableModel.getColumnCount(); ++i) {
            tableColumn = tableColumnModel.getColumn(i);
            switch (i) {
                case 0: {
                    tableColumn.setPreferredWidth(25);
                    continue block12;
                }
                case 1: {
                    tableColumn.setPreferredWidth(50);
                    continue block12;
                }
                case 2: {
                    tableColumn.setPreferredWidth(40);
                    continue block12;
                }
                case 3: {
                    tableColumn.setPreferredWidth(60);
                    continue block12;
                }
                case 4: {
                    tableColumn.setPreferredWidth(110);
                    continue block12;
                }
                case 5: {
                    tableColumn.setPreferredWidth(110);
                    continue block12;
                }
                case 6: {
                    tableColumn.setPreferredWidth(110);
                    continue block12;
                }
                case 7: {
                    tableColumn.setPreferredWidth(110);
                    continue block12;
                }
                case 13: {
                    tableColumn.setPreferredWidth(140);
                    continue block12;
                }
                default: {
                    tableColumn.setPreferredWidth(80);
                }
            }
        }
        toggleButtonAction = new ToggleButtonAction(this, ADD_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (OmsCtrlPanelDlg.this.validateData()) {
                    int n = OmsCtrlPanelDlg.this.mRequestTable.getSelectedRow();
                    OmsCtrlPanelDlg.this.mRequestTableModel.addRequest(OmsCtrlPanelDlg.this.createRequestObject());
                    OmsCtrlPanelDlg.this.setDefaults();
                    isNewRowAdded = true;
                    int n2 = OmsCtrlPanelDlg.this.mRequestTable.getRowCount() - 1;
                    OmsCtrlPanelDlg.this.mRequestTable.setColumnSelectionInterval(1, 1);
                    if (n2 == 0) {
                        OmsCtrlPanelDlg.this.mRequestTable.setRowSelectionInterval(n2, n2);
                    } else {
                        OmsCtrlPanelDlg.this.mRequestTable.setRowSelectionInterval(n + 1, n + 1);
                    }
                    OmsCtrlPanelDlg.this.mRequestTable.requestFocus();
                }
            }
        };
        this.mAddButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, END_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = OmsCtrlPanelDlg.this.mRequestTable.getSelectedRow();
                if (n > -1) {
                    OmsRequest omsRequest = OmsCtrlPanelDlg.this.mRequestTableModel.getRow(n);
                    String string = OmsCtrlPanelDlg.this.mEndButton.getText();
                    if (string.equals(OmsCtrlPanelDlg.this.getResString(OmsCtrlPanelDlg.END_BUTTON))) {
                        omsRequest.setStatus(OmsCtrlPanelDlg.this.END_STATUS_TEXT);
                        OmsCtrlPanelDlg.this.mEndButton.setText(OmsCtrlPanelDlg.this.getResString("IDS_OMS_RESTORE_BUTTON"));
                    } else {
                        omsRequest.setStatus(OmsCtrlPanelDlg.this.ACTIVE_STATUS_TEXT);
                        OmsCtrlPanelDlg.this.mEndButton.setText(OmsCtrlPanelDlg.this.getResString(OmsCtrlPanelDlg.END_BUTTON));
                    }
                    OmsCtrlPanelDlg.this.mRequestTableModel.fireTableRowsUpdated(n, n);
                }
            }
        };
        this.mEndButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, END_ALL_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List<OmsRequest> list = OmsCtrlPanelDlg.this.mRequestTableModel.getRequestObjects();
                for (OmsRequest omsRequest : list) {
                    if (omsRequest.getStatus().equals(OmsCtrlPanelDlg.this.NEW_STATUS_TEXT)) continue;
                    omsRequest.setStatus(OmsCtrlPanelDlg.this.END_STATUS_TEXT);
                }
                OmsCtrlPanelDlg.this.mRequestTableModel.fireTableDataChanged();
                OmsCtrlPanelDlg.this.mEndAllButton.setEnabled(false);
                OmsCtrlPanelDlg.this.mEndButton.setText(OmsCtrlPanelDlg.this.getResString("IDS_OMS_RESTORE_BUTTON"));
                OmsCtrlPanelDlg.this.mEndButton.setEnabled(false);
            }
        };
        this.mEndAllButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, DELETE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = OmsCtrlPanelDlg.this.mRequestTable.getSelectedRow();
                if (n >= 0) {
                    OmsCtrlPanelDlg.this.mRequestTableModel.removeRequest(n);
                    OmsCtrlPanelDlg.this.mDelButton.setEnabled(false);
                }
            }
        };
        this.mDelButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, LOGGING_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OmsCtrlPanelDlg.this.runLoggingSubDialog();
            }
        };
        this.mLoggingButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(IDS_OMS_OPTION_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OmsCtrlPanelDlg.this.runOptionSubDialog();
            }
        };
        this.mOptionButton = new JButton(toggleButtonAction);
        this.enableOkPaste(false);
        this.mDelButton.setEnabled(false);
        this.mComboArray = new String[13];
        this.mComboArray[0] = this.getResString("IDS_OMS_FORMAT_XLS");
        this.mComboArray[1] = this.getResString("IDS_OMS_FORMAT_XLSX");
        this.mComboArray[2] = this.getResString("IDS_OMS_FORMAT_OXML");
        this.mComboArray[3] = this.getResString("IDS_OMS_FORMAT_HTML");
        this.mComboArray[4] = this.getResString("IDS_OMS_FORMAT_SPSS");
        this.mComboArray[5] = this.getResString("IDS_OMS_FORMAT_TXT");
        this.mComboArray[6] = this.getResString("IDS_OMS_FORMAT_TAB");
        this.mComboArray[7] = this.getResString("IDS_OMS_FORMAT_SPV");
        this.mComboArray[8] = this.getResString("IDS_OMS_FORMAT_PDF");
        this.mComboArray[9] = this.getResString("IDS_OMS_FORMAT_SPW");
        this.mComboArray[10] = this.getResString("IDS_OMS_FORMAT_DOC");
        this.mComboArray[11] = this.getResString("IDS_OMS_FORMAT_REPORTHTML");
        this.mComboArray[12] = this.getResString("IDS_OMS_FORMAT_REPORTMHT");
        Arrays.sort(this.mComboArray, 2, 13);
    }

    private void updateLogState() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        OmsManager omsManager = OutputManager.getOutputManager().getOmsManager();
        String string = omsManager.getLogPath();
        dialogDataModel.putBoolean("IDS_OMS_LOG_ACTIVITY_CHECK", string != null && string.length() > 0);
        dialogDataModel.putBoolean("IDS_OMS_LOGGING_XML_RADIO", omsManager.isXmlLogFormat());
        dialogDataModel.putBoolean("IDS_OMS_LOGGING_TEXT_RADIO", !omsManager.isXmlLogFormat());
        dialogDataModel.putString("LOGGING_FILE_TEXT", string);
    }

    private String getFormat(OmsDestinationFormat omsDestinationFormat) {
        String string = "";
        if (omsDestinationFormat == OmsDestinationFormat.kOXML) {
            string = "OXML";
        } else if (omsDestinationFormat == OmsDestinationFormat.kHTML) {
            string = "HTML";
        } else if (omsDestinationFormat == OmsDestinationFormat.kSAV) {
            string = "SAV";
        } else if (omsDestinationFormat == OmsDestinationFormat.kSVWSOXML) {
            string = "SVWSOXML";
        } else if (omsDestinationFormat == OmsDestinationFormat.kTEXT) {
            string = "TEXT";
        } else if (omsDestinationFormat == OmsDestinationFormat.kTABTEXT) {
            string = "TABTEXT";
        }
        return string;
    }

    private String getImgFormat(OmsObjectSelector.ImageFormat imageFormat) {
        String string = "";
        if (imageFormat == OmsObjectSelector.ImageFormat.kJPG) {
            string = "JPG";
        } else if (imageFormat == OmsObjectSelector.ImageFormat.kPNG) {
            string = "PNG";
        } else if (imageFormat == OmsObjectSelector.ImageFormat.kBMP) {
            string = "BMP";
        } else if (imageFormat == OmsObjectSelector.ImageFormat.kEMF) {
            string = "EMF";
        }
        return string;
    }

    private String removeLastCharacter(String string) {
        int n = string.length();
        if (n != 0) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private JPanel setupAddPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_OMS_REQUEST_LABEL"));
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setDisabledTextColor(jTextArea.getForeground());
        jTextArea.setEnabled(false);
        FocusableLabel focusableLabel = OSInfo.getOSType() == OSInfo.OSType.MAC ? new FocusableLabel(this.getResString("IDS_OMS_REQUEST_TIP_MAC")) : new FocusableLabel(this.getResString("IDS_OMS_REQUEST_TIP"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel2 = this.setupNewRequestPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 1, 1, 2, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)focusableLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(0, 3, 6, 3);
        DialogUtil.addUsingGBL(jPanel, this.mAddButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupNewRequestPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JSeparator jSeparator = new JSeparator(0);
        JSeparator jSeparator2 = new JSeparator(0);
        JLabel jLabel = new JLabel(this.getResString("IDS_OMS_NEW_REQUEST"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 10;
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jSeparator2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void setDefaults() {
        this.mSubTypeList.setEnabled(false);
        this.mNoneRadio.setSelected(true);
        this.mFileText.setEnabled(false);
        this.mFileText.setOpaque(false);
        this.mFolderText.setEnabled(false);
        this.mFolderText.setOpaque(false);
        this.mFileBrowseButton.setEnabled(false);
        this.mFolderBrowseButton.setEnabled(false);
        this.mDatasetText.setEnabled(false);
        this.mDatasetText.setOpaque(false);
        this.mFolderLabel.setEnabled(false);
        this.mAddButton.setEnabled(false);
        this.mExcludeCheck.setSelected(false);
        this.mLabelButton.setEnabled(false);
        this.mLabelField.setEnabled(false);
        this.mLabelField.setOpaque(false);
        this.mFileText.setText("");
        this.mFolderText.setText("");
        this.mDatasetText.setText("");
        this.mIdField.setText("");
        this.mLabelField.setText("");
    }

    private List<OmsObjectSelector.SelectOption> getSelectedTypes(int n) {
        ArrayList<OmsObjectSelector.SelectOption> arrayList = new ArrayList<OmsObjectSelector.SelectOption>();
        if ((n & OmsObjectSelector.SelectOption.kCHARTS.value()) == OmsObjectSelector.SelectOption.kCHARTS.value()) {
            arrayList.add(OmsObjectSelector.SelectOption.kCHARTS);
        }
        if ((n & OmsObjectSelector.SelectOption.kTEXTS.value()) == OmsObjectSelector.SelectOption.kTEXTS.value()) {
            arrayList.add(OmsObjectSelector.SelectOption.kTEXTS);
        }
        if ((n & OmsObjectSelector.SelectOption.kLOGS.value()) == OmsObjectSelector.SelectOption.kLOGS.value()) {
            arrayList.add(OmsObjectSelector.SelectOption.kLOGS);
        }
        if ((n & OmsObjectSelector.SelectOption.kWARNINGS.value()) == OmsObjectSelector.SelectOption.kWARNINGS.value()) {
            arrayList.add(OmsObjectSelector.SelectOption.kWARNINGS);
        }
        if ((n & OmsObjectSelector.SelectOption.kTABLES.value()) == OmsObjectSelector.SelectOption.kTABLES.value()) {
            arrayList.add(OmsObjectSelector.SelectOption.kTABLES);
        }
        if ((n & OmsObjectSelector.SelectOption.kHEADINGS.value()) == OmsObjectSelector.SelectOption.kHEADINGS.value()) {
            arrayList.add(OmsObjectSelector.SelectOption.kHEADINGS);
        }
        if ((n & OmsObjectSelector.SelectOption.kANSWERTREES.value()) == OmsObjectSelector.SelectOption.kANSWERTREES.value()) {
            arrayList.add(OmsObjectSelector.SelectOption.kANSWERTREES);
        }
        if ((n & OmsObjectSelector.SelectOption.kMODELS.value()) == OmsObjectSelector.SelectOption.kMODELS.value()) {
            arrayList.add(OmsObjectSelector.SelectOption.kMODELS);
        }
        return arrayList;
    }

    private JPanel setupRequestPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_OMS_REQUEST_LABEL_COLON");
        jLabel.setLabelFor(this.mRequestTable);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(n2 / 2, insets.left, insets.bottom, insets.right);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mRequestTable);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 4, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mEndButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mEndAllButton, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mDelButton, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2.top = n2 * 2;
        DialogUtil.addUsingGBL(jPanel, this.mLoggingButton, gridBagConstraints, 1, 4, 1, 1, n, insets2);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private JPanel setupDestinationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Border border = BorderFactory.createLineBorder(Color.GRAY);
        jPanel.setBorder(border);
        this.mFolderLabel.setLabelFor((Component)((Object)this.mFolderText));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mNoneRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mFileRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileText), gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFileBrowseButton, gridBagConstraints, 2, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mObjectNameRadio, gridBagConstraints, 0, 2, 3, 1, n, insets);
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(insets.top, n2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mFolderLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFolderText), gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFolderBrowseButton, gridBagConstraints, 2, 3, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel2, this.mDataSetRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)((Object)this.mDatasetText), gridBagConstraints, 1, 0, 1, 1, n, insets);
        Insets insets3 = new Insets(n2, 0, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 4, 3, 1, n, insets3);
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        jPanel3.add(this.mOptionButton);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 5, 3, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        insets2.left /= 2;
        DialogUtil.addUsingGBL(jPanel, this.mExcludeCheck, gridBagConstraints, 0, 6, 2, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_OMS_OUTPUT_TYPES");
        jLabel.setLabelFor(this.mOutputTypeList);
        DefaultListModel defaultListModel = (DefaultListModel)this.mOutputTypeList.getModel();
        for (String object2 : this.mOutputList) {
            defaultListModel.addElement(object2);
        }
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mOutputTypeList);
        jScrollPane.setPreferredSize(new Dimension(50, 150));
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_OMS_COMMAND_IDENTIFIERS");
        jLabel2.setLabelFor(this.mIdentifierList);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane2 = new JScrollPane(this.mIdentifierList);
        jScrollPane2.setPreferredSize(new Dimension(70, 150));
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_OMS_TABLE_SUBTYPE");
        jLabel3.setLabelFor(this.mSubTypeList);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mSubTypeScrollPane.setPreferredSize(new Dimension(100, 150));
        DialogUtil.addUsingGBL(jPanel, this.mSubTypeScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_OMS_ID");
        jLabel4.setLabelFor((Component)((Object)this.mIdField));
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mIdField), gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mLabelButton, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mLabelField), gridBagConstraints, 2, 3, 1, 1, n, insets);
        return jPanel;
    }

    private Vector<String> getAllSubTypes() {
        Vector<String> vector = new Vector<String>();
        String string = "omsgui.ini";
        String string2 = VersionInfo.getStatisticsHome() + File.separatorChar + string;
        IniHandler iniHandler = IniHandler.loadIniFile((String)string2, (boolean)true, (String)"");
        if (iniHandler != null) {
            HashMap hashMap = iniHandler.getPrivateProfileSection("Command_Subtypes");
            if (hashMap == null) {
                return vector;
            }
            hashMap = iniHandler.getPrivateProfileSection("Subtypes");
            if (hashMap == null) {
                return vector;
            }
            for (String string3 : hashMap.keySet()) {
                vector.add(((IniHandler.KeyValuePair)hashMap.get(string3)).toString());
            }
            Collections.sort(vector);
        }
        return vector;
    }

    private Object[][] getCellData() {
        LinkedList linkedList;
        IniHandler iniHandler;
        String string = "omsgui.ini";
        String string2 = VersionInfo.getStatisticsHome() + File.separatorChar + string;
        Object[][] objectArray = null;
        File file = new File(string2);
        if (file.exists() && (iniHandler = IniHandler.loadIniFile((String)string2, (boolean)true, (String)"")) != null && (linkedList = iniHandler.getPrivateProfileSectionNames()) != null) {
            HashMap hashMap = iniHandler.getPrivateProfileSection("Subtypes");
            if (hashMap == null) {
                return null;
            }
            hashMap = iniHandler.getPrivateProfileSection("Command_Subtypes");
            if (hashMap == null) {
                return null;
            }
            hashMap = iniHandler.getPrivateProfileSection("Commands");
            if (hashMap == null) {
                return null;
            }
            Iterator iterator = hashMap.keySet().iterator();
            objectArray = new Object[hashMap.size()][2];
            int n = 0;
            int n2 = 0;
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                objectArray[n][n2] = string3.trim();
                objectArray[n][++n2] = hashMap.get(string3);
                ++n;
                n2 = 0;
            }
        }
        objectArray = this.refineData(objectArray);
        return objectArray;
    }

    private Object[][] refineData(Object[][] objectArray) {
        int n = objectArray.length;
        Object[][] objectArray2 = new Object[n][2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = objectArray[i][1].toString();
            String[] stringArray = string.split("=");
            if (stringArray.length == 3) {
                objectArray2[i][n2] = stringArray[0] + stringArray[1];
                objectArray2[i][++n2] = stringArray[2];
            }
            if (stringArray.length == 2) {
                objectArray2[i][n2] = stringArray[0];
                objectArray2[i][++n2] = stringArray[1];
            }
            n2 = 0;
        }
        return objectArray2;
    }

    private Vector<String> getSubTypes(String string) {
        HashMap hashMap;
        IniHandler iniHandler;
        String string2 = "omsgui.ini";
        String string3 = VersionInfo.getStatisticsHome() + File.separatorChar + string2;
        Vector<String> vector = new Vector<String>();
        File file = new File(string3);
        if (file.exists() && (iniHandler = IniHandler.loadIniFile((String)string3, (boolean)true, (String)"")) != null && (hashMap = iniHandler.getPrivateProfileSection("Command_Subtypes")) != null) {
            LinkedList linkedList = iniHandler.getPrivateProfileString("Command_Subtypes", string);
            String string4 = linkedList.toString();
            String string5 = string4.substring(1, string4.length() - 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string5, ";");
            HashMap hashMap2 = iniHandler.getPrivateProfileSection("Subtypes");
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = ((IniHandler.KeyValuePair)hashMap2.get(stringTokenizer.nextToken())).toString();
                String string7 = string6.substring(string6.indexOf("=") + 1, string6.length());
                vector.add(string7.trim());
            }
        }
        return vector;
    }

    private void loadAllList() {
        DefaultListModel defaultListModel = (DefaultListModel)this.mIdentifierList.getModel();
        this.mIdentifierList.removeListSelectionListener(this);
        this.mIdentifierList.removeFocusListener(this);
        defaultListModel.clear();
        Object[][] objectArray = this.getCellData();
        TreeSet<Object> treeSet = new TreeSet<Object>(this.mComparator);
        for (Object[] objectArray2 : objectArray) {
            String string = objectArray2[1].toString();
            treeSet.add(string.trim());
        }
        for (String string : treeSet) {
            defaultListModel.addElement(string);
        }
        if (this.mAllIdentifiersSelected) {
            this.mIdentifierList.setSelectionInterval(0, defaultListModel.getSize());
        }
        this.mIdentifierList.addFocusListener(this);
        this.mIdentifierList.addListSelectionListener(this);
    }

    private void runLabelsubDialog() {
        this.runSubDialog(new OmsLabelSubDialog(this));
    }

    private void runOptionSubDialog() {
        this.runSubDialog(new OmsOptionSubDialog(this));
    }

    private void runLoggingSubDialog() {
        Boolean bl;
        if (this.runSubDialog(new OmsLoggingSubDialog(this)) && (bl = this.getDialogDataModel().getBoolean("IDS_OMS_LOG_ACTIVITY_CHECK")) != null && this.logChanged()) {
            this.enableOkPaste(true);
        }
    }

    private void showBrowseFileDialog() {
        String string;
        String string2;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        int n = dialogDataModel.getInteger("FILE_FORMAT_COMBO") != null ? dialogDataModel.getInteger("FILE_FORMAT_COMBO") : (this.mDataSetRadio.isSelected() ? this.getFormatComboIndex("SPSS") : this.getFormatComboIndex("OXML"));
        if (isNewRowAdded) {
            n = this.getFormatComboIndex("OXML");
        }
        if (this.isSelectedFormat("OXML", n)) {
            string2 = this.getResString("IDS_OMS_OXML_FILE_FILTER");
            string = this.getResString("IDS_OMS_OXML_FILE_EXTENSION");
        } else if (this.isSelectedFormat("HTML", n)) {
            string2 = this.getResString("IDS_OMS_HTML_FILE_FILTER");
            string = this.getResString("IDS_OMS_HTML_FILE_EXTENSION");
        } else if (this.isSelectedFormat("SPSS", n)) {
            string2 = this.getResString("IDS_OMS_SAV_FILE_FILTER");
            string = this.getResString("IDS_OMS_SAV_FILE_EXTENSION");
        } else if (this.isSelectedFormat("TXT", n)) {
            string2 = this.getResString("IDS_OMS_TEXT_FILE_FILTER");
            string = this.getResString("IDS_OMS_TEXT_FILE_EXTENSION");
        } else if (this.isSelectedFormat("TAB", n)) {
            string2 = this.getResString("IDS_OMS_TAB_FILE_FILTER");
            string = this.getResString("IDS_OMS_TAB_FILE_EXTENSION");
        } else if (this.isSelectedFormat("SPV", n)) {
            string2 = CoreResUtil.getString((String)"IDS_OUTPUT_FILE_FILTER");
            string = CoreResUtil.getString((String)"IDS_OUTPUT_FILE_FILTER_EXTENSION");
        } else if (this.isSelectedFormat("XLS", n)) {
            string2 = this.getResString("IDS_OMS_XLS_FILES_FILTER");
            string = this.getResString("IDS_OMS_XLS_FILES_EXTENSION");
        } else if (this.isSelectedFormat("XLSX", n)) {
            string2 = this.getResString("IDS_OMS_XLSX_FILES_FILTER");
            string = this.getResString("IDS_OMS_XLSX_FILES_EXTENSION");
        } else if (this.isSelectedFormat("XLSM", n)) {
            string2 = this.getResString("IDS_OMS_XLSM_FILES_FILTER");
            string = this.getResString("IDS_OMS_XLSM_FILES_EXTENSION");
        } else if (this.isSelectedFormat("PDF", n)) {
            string2 = this.getResString("IDS_OMS_PDF_FILES_FILTER");
            string = this.getResString("IDS_OMS_PDF_FILES_EXTENSION");
        } else if (this.isSelectedFormat("SPW", n)) {
            string2 = this.getResString("IDS_OMS_SPW_FILES_FILTER");
            string = this.getResString("IDS_OMS_SPW_FILES_EXTENSION");
        } else if (this.isSelectedFormat("DOC", n)) {
            string2 = this.getResString("IDS_OMS_DOC_FILES_FILTER");
            string = this.getResString("IDS_OMS_DOC_FILES_EXTENSION");
        } else if (this.isSelectedFormat("REPORTHTML", n)) {
            string2 = this.getResString("IDS_OMS_REPORTHTML_FILES_FILTER");
            string = this.getResString("IDS_OMS_REPORTHTML_FILES_EXTENSION");
        } else if (this.isSelectedFormat("REPORTMHT", n)) {
            string2 = this.getResString("IDS_OMS_REPORTMHT_FILES_FILTER");
            string = this.getResString("IDS_OMS_REPORTMHT_FILES_EXTENSION");
        } else {
            string2 = "";
            string = "";
        }
        this.getFileChooser(string2, string);
    }

    private void showBrowseFolderDialog() {
        int n;
        boolean bl = DataServerProxy.getDataProxy().isRemoteConnection();
        OpenFolderChooser openFolderChooser = new OpenFolderChooser(RemoteFileChooser.ChooserType.OpenFolder, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), bl);
        openFolderChooser.setDialogTitle(this.getResString("IDS_OMS_FOLDER_BROWSE_TITLE"));
        openFolderChooser.setSelectedFile(openFolderChooser.getCurrentDirectory());
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            openFolderChooser.setApproveButtonMnemonic(this.getDlgAccessKey("IDK_OMS_BROWSE_FOLDER_APPROVE_BUTTON_KEY"));
        }
        if ((n = openFolderChooser.showDialog((Component)((Object)this), this.getResString("IDS_OMS_BROWSE_FOLDER_APPROVE_BUTTON_TEXT"))) == 0) {
            String string = openFolderChooser.getSelectedFilePath();
            this.mFolderText.setText(string);
        } else {
            TraceSettings.trace1((String)"No Selection", (int)15);
        }
        UIManager.getDefaults().put("FileChooser.lookInLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_LOOK_IN_LABEL_TEXT"));
        UIManager.getDefaults().put("FileChooser.filesOfTypeLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_FILES_OF_TYPE_LABEL_TEXT"));
        UIManager.getDefaults().put("FileChooser.fileNameLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_FOLDER_LABEL_TEXT"));
    }

    private int getFormatComboIndex(String string) {
        List<String> list = Arrays.asList(this.mComboArray);
        if (string.equals("OXML")) {
            return list.indexOf(this.getResString("IDS_OMS_FORMAT_OXML"));
        }
        if (string.equals("HTML")) {
            return list.indexOf(this.getResString("IDS_OMS_FORMAT_HTML"));
        }
        if (string.equals("SPSS")) {
            return list.indexOf(this.getResString("IDS_OMS_FORMAT_SPSS"));
        }
        if (string.equals("TXT")) {
            return list.indexOf(this.getResString("IDS_OMS_FORMAT_TXT"));
        }
        if (string.equals("TAB")) {
            return list.indexOf(this.getResString("IDS_OMS_FORMAT_TAB"));
        }
        if (string.equals("SPV")) {
            return list.indexOf(this.getResString("IDS_OMS_FORMAT_SPV"));
        }
        if (string.equals("XLS")) {
            return list.indexOf(this.getResString("IDS_OMS_FORMAT_XLS"));
        }
        if (string.equals("XLSX")) {
            return list.indexOf(this.getResString("IDS_OMS_FORMAT_XLSX"));
        }
        if (string.equals("XLSM")) {
            return list.indexOf(this.getResString("IDS_OMS_FORMAT_XLSM"));
        }
        if (string.equals("PDF")) {
            return list.indexOf(this.getResString("IDS_OMS_FORMAT_PDF"));
        }
        if (string.equals("SPW")) {
            return list.indexOf(this.getResString("IDS_OMS_FORMAT_SPW"));
        }
        if (string.equals("DOC")) {
            return list.indexOf(this.getResString("IDS_OMS_FORMAT_DOC"));
        }
        return 0;
    }

    private boolean isTextFormat(int n) {
        List<String> list = Arrays.asList(this.mComboArray);
        if (n == list.indexOf(this.getResString("IDS_OMS_FORMAT_TXT"))) {
            return true;
        }
        return n == list.indexOf(this.getResString("IDS_OMS_FORMAT_TAB"));
    }

    private boolean isSelectedFormat(String string, int n) {
        String string2 = this.mComboArray[n];
        if (string.equals("OXML")) {
            return string2.equals(this.getResString("IDS_OMS_FORMAT_OXML"));
        }
        if (string.equals("HTML")) {
            return string2.equals(this.getResString("IDS_OMS_FORMAT_HTML"));
        }
        if (string.equals("SPSS")) {
            return string2.equals(this.getResString("IDS_OMS_FORMAT_SPSS"));
        }
        if (string.equals("TXT")) {
            return string2.equals(this.getResString("IDS_OMS_FORMAT_TXT"));
        }
        if (string.equals("TAB")) {
            return string2.equals(this.getResString("IDS_OMS_FORMAT_TAB"));
        }
        if (string.equals("SPV")) {
            return string2.equals(this.getResString("IDS_OMS_FORMAT_SPV"));
        }
        if (string.equals("XLS")) {
            return string2.equals(this.getResString("IDS_OMS_FORMAT_XLS"));
        }
        if (string.equals("XLSX")) {
            return string2.equals(this.getResString("IDS_OMS_FORMAT_XLSX"));
        }
        if (string.equals("XLSM")) {
            return string2.equals(this.getResString("IDS_OMS_FORMAT_XLSM"));
        }
        if (string.equals("PDF")) {
            return string2.equals(this.getResString("IDS_OMS_FORMAT_PDF"));
        }
        if (string.equals("SPW")) {
            return string2.equals(this.getResString("IDS_OMS_FORMAT_SPW"));
        }
        if (string.equals("REPORTHTML")) {
            return string2.equals(this.getResString("IDS_OMS_FORMAT_REPORTHTML"));
        }
        if (string.equals("REPORTMHT")) {
            return string2.equals(this.getResString("IDS_OMS_FORMAT_REPORTMHT"));
        }
        return string.equals("DOC") && string2.equals(this.getResString("IDS_OMS_FORMAT_DOC"));
    }

    private void getFileChooser(String string, String string2) {
        boolean bl = DataServerProxy.getDataProxy().isRemoteConnection();
        String string3 = this.getResString("IDS_OMS_SAV_FILE_EXTENSION").equalsIgnoreCase(string2) ? FileLocationsUtil.getDataFilesDirectoryPath() : FileLocationsUtil.getDataFilesDirectoryPath();
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, string3, bl);
        remoteFileChooser.getAcceptAllFileFilter();
        remoteFileChooser.setDialogTitle(this.getResString("IDS_OMS_FILE_BROWSE_TITLE"));
        remoteFileChooser.setSelectedFile(null);
        RefFileFilter refFileFilter = new RefFileFilter(string, string2);
        remoteFileChooser.resetChoosableFileFilters();
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(OSInfo.getOSType() == OSInfo.OSType.MAC);
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        int n = remoteFileChooser.showSaveDialog((Component)((Object)this));
        if (n == 0) {
            if (this.getResString("IDS_OMS_SAV_FILE_EXTENSION").equalsIgnoreCase(string2)) {
                FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            } else {
                FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            }
            String string4 = remoteFileChooser.getSelectedFilePath();
            if (!string2.regionMatches(true, 0, string4, string4.length() - string2.length(), string2.length())) {
                string4 = string4 + string2;
            }
            this.mFileText.setText(string4);
        } else {
            TraceSettings.trace1((String)"No Selection", (int)15);
        }
    }

    private OmsRequest createRequestObject() {
        Object object;
        Object object22;
        String string;
        boolean bl;
        Object object32;
        StringBuilder stringBuilder;
        OmsRequest omsRequest = new OmsRequest();
        Destination destination = new Destination(Destination.DestFormat.eNone, Destination.FileFormat.eOXML, null, null);
        omsRequest.setStatus(this.NEW_STATUS_TEXT);
        if (this.mIdField.getText().length() == 0) {
            omsRequest.setId("");
        } else {
            omsRequest.setId(this.mIdField.getText());
        }
        Object[] objectArray = this.mOutputTypeList.getSelectedValues();
        StringBuilder stringBuilder2 = new StringBuilder();
        if (objectArray.length == this.mOutputList.size()) {
            stringBuilder2.append(this.IDS_ALL);
        } else {
            for (Object string2 : objectArray) {
                stringBuilder2.append(string2).append(" ");
            }
        }
        omsRequest.setTypes(stringBuilder2.toString());
        if (this.mAllIdentifiersSelected) {
            omsRequest.setCommands(this.IDS_ALL);
        } else {
            objectArray = this.mIdentifierList.getSelectedValues();
            stringBuilder = new StringBuilder();
            for (Object dialogDataModel : objectArray) {
                stringBuilder.append(dialogDataModel).append(", ");
            }
            String string3 = this.removeLastCharacter(stringBuilder.toString().trim());
            omsRequest.setCommands(string3);
        }
        stringBuilder = (StringBuilder)this.mOutputTypeList.getSelectedIndices();
        boolean bl2 = false;
        for (Object object32 : stringBuilder) {
            if (!this.isSelectedType((int)object32, "TABLES") || this.mIdentifierList.getSelectedIndices().length <= 0) continue;
            bl = true;
        }
        objectArray = this.mSubTypeList.getSelectedValues();
        StringBuilder stringBuilder3 = new StringBuilder();
        if (bl && objectArray.length == this.mSubTypeList.getModel().getSize()) {
            string = this.IDS_ALL;
        } else {
            for (Object object22 : objectArray) {
                stringBuilder3.append(object22).append(", ");
            }
            string = stringBuilder3.toString().trim();
            if (string.length() > 0) {
                string = this.removeLastCharacter(string);
            }
        }
        omsRequest.setSubtypes(string);
        omsRequest.setLabels(this.mLabelField.getText());
        if (this.mNoneRadio.isSelected()) {
            destination.setFormatType(Destination.DestFormat.eNone);
            if (this.mIdField.getText().length() > 0) {
                omsRequest.setDestination(this.mIdField.getText());
            } else {
                omsRequest.setDestination(" ");
            }
        } else if (this.mFileRadio.isSelected()) {
            destination.setFormatType(Destination.DestFormat.eFile);
            destination.setDestPath(this.mFileText.getText());
            omsRequest.setDestination(destination.toString());
        } else if (this.mObjectNameRadio.isSelected()) {
            destination.setFormatType(Destination.DestFormat.eFolder);
            destination.setDestPath(this.mFolderText.getText());
            omsRequest.setDestination(destination.toString());
        } else if (this.mDataSetRadio.isSelected()) {
            destination.setFormatType(Destination.DestFormat.eDataSet);
            destination.setDestPath(this.mDatasetText.getText());
            omsRequest.setDestination(destination.toString());
        }
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        object32 = this.getFormatComboIndex("OXML");
        Integer n = dialogDataModel.getInteger("FILE_FORMAT_COMBO");
        if (n != null) {
            object32 = n;
        }
        if (this.mDataSetRadio.isSelected()) {
            object32 = this.getFormatComboIndex("SPSS");
        }
        object22 = "";
        if (this.isSelectedFormat("OXML", (int)object32)) {
            object22 = this.getResString("IDS_OMS_FORMAT_OXML");
            destination.setFileFormat(Destination.FileFormat.eOXML);
        } else if (this.isSelectedFormat("HTML", (int)object32)) {
            object22 = this.getResString("IDS_OMS_FORMAT_HTML");
            destination.setFileFormat(Destination.FileFormat.eHTML);
        } else if (this.isSelectedFormat("SPSS", (int)object32)) {
            object22 = this.getResString("IDS_OMS_FORMAT_SPSS");
            destination.setFileFormat(Destination.FileFormat.eSAV);
        } else if (this.isSelectedFormat("TXT", (int)object32)) {
            object22 = this.getResString("IDS_OMS_FORMAT_TXT");
            destination.setFileFormat(Destination.FileFormat.eTEXT);
        } else if (this.isSelectedFormat("TAB", (int)object32)) {
            object22 = this.getResString("IDS_OMS_FORMAT_TAB");
            destination.setFileFormat(Destination.FileFormat.eTABTEXT);
        } else if (this.isSelectedFormat("SPV", (int)object32)) {
            object22 = this.getResString("IDS_OMS_FORMAT_SPV");
            destination.setFileFormat(Destination.FileFormat.eSPV);
        } else if (this.isSelectedFormat("XLS", (int)object32)) {
            object22 = this.getResString("IDS_OMS_FORMAT_XLS");
            destination.setFileFormat(Destination.FileFormat.eXLS);
        } else if (this.isSelectedFormat("XLSX", (int)object32)) {
            object22 = this.getResString("IDS_OMS_FORMAT_XLSX");
            destination.setFileFormat(Destination.FileFormat.eXLSX);
        } else if (this.isSelectedFormat("XLSM", (int)object32)) {
            object22 = this.getResString("IDS_OMS_FORMAT_XLSM");
            destination.setFileFormat(Destination.FileFormat.eXLSM);
        } else if (this.isSelectedFormat("PDF", (int)object32)) {
            object22 = this.getResString("IDS_OMS_FORMAT_PDF");
            destination.setFileFormat(Destination.FileFormat.ePDF);
        } else if (this.isSelectedFormat("SPW", (int)object32)) {
            object22 = this.getResString("IDS_OMS_FORMAT_SPW");
            destination.setFileFormat(Destination.FileFormat.eSPW);
        } else if (this.isSelectedFormat("DOC", (int)object32)) {
            object22 = this.getResString("IDS_OMS_FORMAT_DOC");
            destination.setFileFormat(Destination.FileFormat.eDOC);
        } else if (this.isSelectedFormat("REPORTHTML", (int)object32)) {
            object22 = this.getResString("IDS_OMS_FORMAT_REPORTHTML");
            destination.setFileFormat(Destination.FileFormat.eREPORTHTML);
        } else if (this.isSelectedFormat("REPORTMHT", (int)object32)) {
            object22 = this.getResString("IDS_OMS_FORMAT_REPORTMHT");
            destination.setFileFormat(Destination.FileFormat.eREPORTMHT);
        }
        omsRequest.setFormat((String)object22);
        omsRequest.setDestinationFormat(destination);
        Boolean bl3 = dialogDataModel.getBoolean("IDS_OMS_TABLE_NONE_RADIO");
        Boolean bl4 = dialogDataModel.getBoolean("IDS_OMS_ALL_DIMENSION_RADIO");
        Boolean bl5 = dialogDataModel.getBoolean("IDS_OMS_LIST_POSITION_RADIO");
        Boolean bl6 = dialogDataModel.getBoolean("IDS_OMS_LIST_DIMENSION_RADIO");
        if (bl3 != null || bl4 != null || bl5 != null || bl6 != null) {
            if (bl3.booleanValue()) {
                omsRequest.setColumnForm(OmsRequest.ColumnForm.eCOLUMNS);
                omsRequest.setColumns(" ");
            } else if (bl4.booleanValue()) {
                object = this.mOutputTypeList.getSelectedIndices();
                for (int n2 : object) {
                    if (!this.isSelectedType(n2, "TABLES")) continue;
                    omsRequest.setColumnForm(OmsRequest.ColumnForm.eSEQUENCE);
                    omsRequest.setColumns("RALL CALL LALL");
                }
            } else if (bl5.booleanValue()) {
                object = this.mOutputTypeList.getSelectedIndices();
                for (int n2 : object) {
                    if (!this.isSelectedType(n2, "TABLES")) continue;
                    omsRequest.setColumnForm(OmsRequest.ColumnForm.eSEQUENCE);
                    omsRequest.setColumns(dialogDataModel.getString("IDS_LIST_POS_TEXT"));
                }
            } else if (bl6.booleanValue()) {
                object = this.mOutputTypeList.getSelectedIndices();
                for (int n2 : object) {
                    if (!this.isSelectedType(n2, "TABLES")) continue;
                    omsRequest.setColumnForm(OmsRequest.ColumnForm.eDIMNAMES);
                    omsRequest.setColumns(dialogDataModel.getString("IDS_LIST_DIMENSION_TEXT"));
                }
            }
        } else {
            omsRequest.setColumns(" ");
        }
        if (this.mExcludeCheck.isSelected()) {
            omsRequest.setViewer("No");
        } else {
            omsRequest.setViewer("Yes");
        }
        if (object32 == this.getFormatComboIndex("SPSS")) {
            omsRequest.setNumber(dialogDataModel.getString("TABLE_NUMBER_ACTION"));
        } else {
            omsRequest.setNumber(" ");
        }
        object = dialogDataModel.getBoolean("IDS_OMS_STATIC_TABLES_CHECK");
        if (object != null && ((Boolean)object).booleanValue()) {
            omsRequest.setStaticTables(true);
        } else {
            omsRequest.setStaticTables(false);
        }
        bl3 = dialogDataModel.getBoolean("IDS_OMS_INCLUDE_IMAGES_CHECK");
        if (bl3 != null && bl3.booleanValue()) {
            String string4;
            omsRequest.setImage(true);
            int n3 = 0;
            Integer n4 = dialogDataModel.getInteger("IMAGE_FORMAT_COMBO");
            if (n4 != null) {
                n3 = n4;
            }
            switch (n3) {
                case 1: {
                    string4 = "PNG";
                    break;
                }
                case 2: {
                    string4 = "BMP";
                    break;
                }
                default: {
                    string4 = "JPG";
                }
            }
            Boolean bl7 = dialogDataModel.getBoolean("IDS_OMS_INCLUDE_IMAGEMAPS_CHECK");
            if (bl7 != null && bl7.booleanValue()) {
                omsRequest.setImageMaps(true);
            } else {
                omsRequest.setImageMaps(false);
            }
            String string5 = dialogDataModel.getString("IDS_OMS_IMAGE_SIZE_TEXT");
            omsRequest.setChartSize(Integer.parseInt(string5));
            omsRequest.setImages("Included. Format=" + string4 + ". size=" + string5 + "%");
        } else {
            omsRequest.setImages(" ");
        }
        if (bl3 != null && bl3.booleanValue()) {
            omsRequest.setImagesDe("Image");
        } else {
            omsRequest.setImagesDe(" ");
        }
        return omsRequest;
    }

    private void enableAddButton() {
        int[] nArray = this.mOutputTypeList.getSelectedIndices();
        boolean bl = false;
        boolean bl2 = false;
        for (int n : nArray) {
            if (this.isSelectedType(n, "TABLES") && !this.mIdentifierList.isSelectionEmpty()) {
                bl2 = true;
                continue;
            }
            if (!this.isSelectedType(n, "LOGS")) continue;
            bl = true;
        }
        boolean bl3 = false;
        this.mSubTypeList.setEnabled(bl2);
        if (!this.mOutputTypeList.isSelectionEmpty() && !this.mIdentifierList.isSelectionEmpty()) {
            if (this.mExcludeCheck.isSelected()) {
                bl3 = !bl2 || !this.mSubTypeList.isSelectionEmpty() || this.mLabelField.getText().length() > 0;
            } else if (!bl2 || !this.mSubTypeList.isSelectionEmpty() || this.mLabelField.getText().length() > 0) {
                bl3 = this.mFileRadio.isSelected() ? this.mFileText.getText().length() > 0 : (this.mObjectNameRadio.isSelected() ? this.mFolderText.getText().length() > 0 : (this.mDataSetRadio.isSelected() ? this.mDatasetText.getText().length() > 0 : true));
            }
        } else if (bl && this.mOutputTypeList.getSelectedIndices().length == 1) {
            if (this.mFileRadio.isSelected()) {
                bl3 = this.mFileText.getText().length() > 0;
            } else if (this.mObjectNameRadio.isSelected()) {
                bl3 = this.mFolderText.getText().length() > 0;
            } else if (this.mDataSetRadio.isSelected()) {
                bl3 = this.mDatasetText.getText().length() > 0;
            }
            bl3 |= this.mExcludeCheck.isSelected();
        }
        this.mAddButton.setEnabled(bl3);
    }

    private boolean validateData() {
        boolean bl = true;
        if (this.mDataSetRadio.isSelected()) {
            int n = DatasetNameValidator.validateDatasetName((String)this.mDatasetText.getText(), (Component)((Object)this));
            if (n == 0) {
                this.mDatasetText.requestFocus();
                this.mDatasetText.selectAll();
                return false;
            }
            if (!this.isSelectedType(this.mOutputTypeList.getSelectedIndex(), "TABLES")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OMS_DATASET"), VersionInfo.getAppVersionString());
                bl = false;
            }
        } else if (this.mFileRadio.isSelected()) {
            boolean bl2;
            if (this.mFileText.getText() != null && this.mFileText.getText().length() > 0 && !(bl2 = FileValidator.validatePath((Component)((Object)this), this.mFileText.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection()))) {
                this.mFileText.requestFocus();
                return false;
            }
        } else if (this.mObjectNameRadio.isSelected() && this.mFolderText.getText() != null && this.mFolderText.getText().length() > 0) {
            String string = this.mFolderText.getText();
            char c = string.indexOf(47) == -1 ? (char)'\\' : '/';
            string = string + c;
            boolean bl3 = FileValidator.validatePath((Component)((Object)this), string = string + "xxx", true, DataServerProxy.getDataProxy().isRemoteConnection());
            if (!bl3) {
                this.mFolderText.requestFocus();
                return false;
            }
        }
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (bl && dialogDataModel.getInteger("FILE_FORMAT_COMBO") != null) {
            Boolean bl4 = dialogDataModel.getInteger("FILE_FORMAT_COMBO").intValue() == this.getFormatComboIndex("SPSS");
            if (!this.isSelectedType(this.mOutputTypeList.getSelectedIndex(), "TABLES") && bl4.booleanValue()) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OMS_DATASET"), VersionInfo.getAppVersionString());
                bl = false;
            }
            if (this.onlyGraphSelected() && this.isTextFormat(dialogDataModel.getInteger("FILE_FORMAT_COMBO"))) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OMS_COMBINATION"), VersionInfo.getAppVersionString());
                bl = false;
            }
        }
        List<OmsRequest> list = this.mRequestTableModel.getRequestObjects();
        String string = this.mIdField.getText();
        if (bl && string.trim().length() != 0) {
            for (OmsRequest omsRequest : list) {
                if (!omsRequest.getId().equals(string)) continue;
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OMS_ID"), VersionInfo.getAppVersionString());
                bl = false;
                this.mIdField.selectAll();
                this.mIdField.requestFocus();
                break;
            }
        }
        return bl;
    }

    private void initOutputList() {
        this.mOutputList = new ArrayList();
        this.mOutputList.add(this.getResString("IDS_OMS_OUTPUT_CHART"));
        this.mOutputList.add(this.getResString("IDS_OMS_OUTPUT_LOG"));
        this.mOutputList.add(this.getResString("IDS_OMS_OUTPUT_TABLE"));
        this.mOutputList.add(this.getResString("IDS_OMS_OUTPUT_TEXT"));
        this.mOutputList.add(this.getResString("IDS_OMS_OUTPUT_HEADING"));
        this.mOutputList.add(this.getResString("IDS_OMS_OUTPUT_WARNING"));
        this.mOutputList.add(this.getResString("IDS_OMS_OUTPUT_TREE"));
        this.mOutputList.add(this.getResString("IDS_OMS_OUTPUT_MODEL"));
        Collections.sort(this.mOutputList);
    }

    private String getSelectType(OmsObjectSelector.SelectOption selectOption) {
        String string = "";
        if (selectOption == OmsObjectSelector.SelectOption.kCHARTS) {
            string = this.IDS_CHARTS;
        }
        if (selectOption == OmsObjectSelector.SelectOption.kLOGS) {
            string = this.IDS_LOGS;
        }
        if (selectOption == OmsObjectSelector.SelectOption.kTABLES) {
            string = this.IDS_TABLES;
        }
        if (selectOption == OmsObjectSelector.SelectOption.kTEXTS) {
            string = this.IDS_TEXTS;
        }
        if (selectOption == OmsObjectSelector.SelectOption.kHEADINGS) {
            string = this.IDS_HEADINGS;
        }
        if (selectOption == OmsObjectSelector.SelectOption.kWARNINGS) {
            string = this.IDS_WARNINGS;
        }
        if (selectOption == OmsObjectSelector.SelectOption.kANSWERTREES) {
            string = this.IDS_TREES;
        }
        if (selectOption == OmsObjectSelector.SelectOption.kMODELS) {
            string = this.IDS_MODELS;
        }
        return string;
    }

    class OpenFolderChooser
    extends RemoteFileChooser {
        public OpenFolderChooser(RemoteFileChooser.ChooserType chooserType, RemoteFileChooser.ChooserOption chooserOption, String string, boolean bl) {
            super(chooserType, chooserOption, string, bl, false, false, false);
        }

        @Override
        protected void installStrings() {
            super.installStrings();
            UIManager.getDefaults().put("FileChooser.lookInLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_IN_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.filesOfTypeLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_FILES_OF_TYPE_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.fileNameLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_OPEN_FOLDER_LABEL_TEXT"));
        }
    }

    private class ImageColumnRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        private ImageColumnRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = new JLabel();
            jLabel.setBorder(BorderFactory.createEtchedBorder());
            jLabel.setOpaque(true);
            if (bl) {
                jLabel.setIcon((ImageIcon)object);
            }
            return jLabel;
        }
    }
}

