/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.manage_extensions;

import com.pasw.framework.common.PaswException;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.ExecStartupPreferences;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.core.documents.output.header.HeaderItem;
import com.spss.java_client.core.documents.output.text.LogItem;
import com.spss.java_client.core.documents.output.text.TextItem;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.command.executor.CommandExecutor;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_from_internet.ExtensionBundleInstaller;
import com.spss.java_client.ui.dialogs.base.utilities.manage_extensions.ExtensionBundleRemover;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.app.ExtensionHubAppInfo;
import com.spss.shared.custom_gui.ui_builder.app.LicenseOption;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.shared.extensionmanager.utilities.ExtensionMgr;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.ui_builder.definition.AddOnType;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.util.IniHandler;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class StatsAppInfo
implements ExtensionHubAppInfo {
    static final String extensionDownloadPath_KEY = "EXTENSION_DOWNLOAD_PATH";
    private HashMap<String, String> mFailMsg = new HashMap();
    private HashMap<String, String> mSuccessMsg = new HashMap();
    private Vector<String> mSelectedExtensionNames = new Vector();

    public Charset getCurrentCharset() {
        return Charset.defaultCharset();
    }

    public String getAppVersionString() {
        return VersionInfo.getVersionString();
    }

    public String getAppNameString() {
        return VersionInfo.getAppVersionString();
    }

    public Locale getAppLocale() {
        return Locale.getDefault();
    }

    public LookAndFeel getLookAndFeel() {
        return UIManager.getLookAndFeel();
    }

    public AppType getAppType() {
        return AppType.STATS;
    }

    public String getExtensionPackageSuffix() {
        return ".spe";
    }

    public String getRecentFilesDirectoryPath() {
        return "";
    }

    public void setRecentFilesDirectoryPath(String string) {
    }

    public AddOnType[] getAddOnType() {
        ArrayList<AddOnType> arrayList = new ArrayList<AddOnType>();
        if (this.isRPlugInstalled()) {
            arrayList.add(AddOnType.R);
        }
        if (this.isPythonPlugInstalled()) {
            arrayList.add(AddOnType.Python);
        }
        AddOnType[] addOnTypeArray = new AddOnType[arrayList.size()];
        return arrayList.toArray(addOnTypeArray);
    }

    private boolean isPythonPlugInstalled() {
        File file = new File(System.getProperty("application.home") + File.separatorChar + "pythoncfg.jar");
        return file.exists();
    }

    private boolean isRPlugInstalled() {
        String string = "";
        boolean bl = false;
        IniHandler iniHandler = StatsAppInfo.getSpssReaderFromSpssHomeDir("spssdxcfg.ini");
        string = StatsAppInfo.getProfileValue(iniHandler, AddOnType.R.toString(), "HOME");
        if (string.isEmpty()) {
            String string2 = VersionInfo.getMajorMinorVersionString();
            String string3 = "/com/ibm/SPSS/externalr/" + string2;
            try {
                if (Preferences.userRoot().nodeExists(string3)) {
                    Preferences preferences = Preferences.userRoot().node(string3);
                    string = preferences.get("r_path", string);
                    if (string.length() > 0) {
                        File file = new File(string);
                        if (!file.exists() || !file.isDirectory()) {
                            string = "";
                        }
                    } else {
                        string = "";
                    }
                }
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
            }
        }
        if (!string.isEmpty()) {
            bl = true;
        }
        return bl;
    }

    private static String getProfileValue(IniHandler iniHandler, String string, String string2) {
        LinkedList linkedList;
        String string3 = "";
        if (iniHandler != null && (linkedList = iniHandler.getPrivateProfileString(string, string2)) != null && !linkedList.isEmpty()) {
            string3 = (String)linkedList.getFirst();
        }
        return string3;
    }

    private static IniHandler getSpssReaderFromSpssHomeDir(String string) {
        IniHandler iniHandler = null;
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("application.home"));
        stringBuffer.append(File.separatorChar).append(string);
        File file = new File(stringBuffer.toString());
        if (file.exists()) {
            iniHandler = IniHandler.loadIniFile((String)stringBuffer.toString(), (boolean)true, (String)"UTF-8");
        }
        return iniHandler;
    }

    public void showHelp(String string) {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, string);
    }

    public File getTempDir() {
        return new File(ExecStartupPreferences.getTempDirectoryRootPath());
    }

    public LicenseOption getLicenseOption() {
        return null;
    }

    public String[] getMenuOrNodeLocation(String string, String string2) {
        Vector<String> vector;
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        String[] stringArray = new String[]{"", ""};
        String string3 = string2;
        SpssAction spssAction = ActionCatalog.getActionCatalog().getSpssAction(string3);
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame();
        if (spssAction != null && (vector = CommandExecutor.get().getMenuLabelHierarchy(spssFrame.getJMenuBar(), spssAction.getActionId())) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string4 : vector) {
                if (string4.endsWith("...")) {
                    string4 = string4.substring(0, string4.lastIndexOf("..."));
                }
                if (stringBuilder.length() == 0) {
                    stringBuilder.append(string4);
                    continue;
                }
                stringBuilder.append(">").append(string4);
            }
            Object object = vector.get(vector.size() - 1);
            if (((String)object).endsWith("...")) {
                object = ((String)object).substring(0, ((String)object).lastIndexOf("..."));
            }
            stringArray[0] = object;
            stringArray[1] = stringBuilder.toString();
        }
        return stringArray;
    }

    public String getExtensionDownloadPath() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        return preferences.get(extensionDownloadPath_KEY, "");
    }

    public void setExtensionDownloadPath(String string) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        preferences.put(extensionDownloadPath_KEY, string);
    }

    public boolean loadExtension(String string, boolean bl) throws PaswException, IOException {
        ResourceBundle resourceBundle = ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        this.mSelectedExtensionNames.add(string);
        if (bl) {
            String string2 = this.getExtensionDownloadPath();
            String string3 = ExtensionMgr.getExtensionMgr().downloadExtensionPackageToSpecifiedPath(string, string2);
            if (string3 == null) {
                String string4 = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_EXTENSION_BUNDLE_FAIL_TO_DOWNLOAD");
                String string5 = string4.replace("{0}", string);
                this.mSuccessMsg.put(string, string5);
                return false;
            }
            String string6 = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_EXTENSION_BUNDLE_SUCCESSFULLY_DOWNLOADED_TO");
            String string7 = string6.replace("{0}", string) + "\n    " + string3;
            this.mSuccessMsg.put(string, string7);
            return true;
        }
        String string8 = this.getTempDir().getAbsolutePath();
        String string9 = null;
        File file = new File(string8 = string8.endsWith(File.separator) ? string8 + Calendar.getInstance().getTimeInMillis() : string8 + File.separator + Calendar.getInstance().getTimeInMillis());
        if (file.mkdirs()) {
            string9 = string8;
        }
        if (string9 == null) {
            String string10 = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_EXTENSION_BUNDLE_NO_PERMISSIONS_MSG");
            String string11 = string10.replace("{0}", string);
            this.mFailMsg.put(string, string11);
            return false;
        }
        String string12 = ExtensionMgr.getExtensionMgr().downloadExtensionPackageToSpecifiedPath(string, string9);
        if (string12 == null) {
            String string13 = UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_EXTENSION_BUNDLE_FAIL_TO_DOWNLOAD");
            String string14 = string13.replace("{0}", string);
            this.mFailMsg.put(string, string14);
            File file2 = new File(string9);
            BuilderUtil.getInstance().deleteFolder(file2);
            return false;
        }
        ExtensionBundleInstaller extensionBundleInstaller = new ExtensionBundleInstaller();
        File file3 = new File(string12);
        boolean bl2 = extensionBundleInstaller.doInstall(file3);
        File file4 = new File(string9);
        BuilderUtil.getInstance().deleteFolder(file4);
        if (bl2) {
            String string15 = extensionBundleInstaller.getSuccessMsg();
            this.mSuccessMsg.put(string, string15);
            ExtensionMgr.getExtensionMgr().setInstalledExtensionFilesPath(extensionBundleInstaller.getInstalledExtensionFilesPath());
            ExtensionMgr.getExtensionMgr().setInstalledCDBFilesPath(extensionBundleInstaller.getInstalledCDBFilesPath());
            return true;
        }
        String string16 = extensionBundleInstaller.getErrorMsg();
        this.mFailMsg.put(string, string16);
        return false;
    }

    public boolean unloadExtension(String string) throws PaswException {
        this.mSelectedExtensionNames.add(string);
        ExtensionBundleRemover extensionBundleRemover = new ExtensionBundleRemover();
        boolean bl = extensionBundleRemover.doRemove(string);
        if (bl) {
            String string2 = extensionBundleRemover.getSuccessMsg();
            this.mSuccessMsg.put(string, string2);
            return true;
        }
        String string3 = extensionBundleRemover.getErrorMsg();
        this.mFailMsg.put(string, string3);
        return false;
    }

    public void showResultMessages() {
        String string3;
        ResourceBundle resourceBundle = ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        String string2 = "";
        for (String string3 : this.mSelectedExtensionNames) {
            if (this.mSuccessMsg.get(string3) != null) {
                string2 = string2 + this.mSuccessMsg.get(string3) + "\n\n";
                continue;
            }
            if (this.mFailMsg.get(string3) == null) continue;
            string2 = string2 + this.mFailMsg.get(string3) + "\n\n";
        }
        String string4 = ExtensionMgr.getExtensionMgr().getInstalledExtensionFilesPath();
        if (string4 != "") {
            string3 = MessageFormat.format(BuilderResUtil.getString((String)"IDS_EXTENSION_FILES_INSTALLED_TO"), string4);
            string2 = string2 + "\n";
            string2 = string2 + string3;
        }
        if ((string3 = ExtensionMgr.getExtensionMgr().getInstalledCDBFilesPath()) != "") {
            String string5 = MessageFormat.format(BuilderResUtil.getString((String)"IDS_DIALOG_FILES_INSTALLED_TO"), string3);
            string2 = string2 + "\n";
            string2 = string2 + string5;
        }
        this.addMessageToOutputViewer(resourceBundle.getString("IDS_EXTENSION_BUNDLE_OUTPUT_ITEM_DESCRIPITION"), string2);
        this.mFailMsg.clear();
        this.mSuccessMsg.clear();
        this.mSelectedExtensionNames.clear();
    }

    public void showResultMessages(String string) {
        ResourceBundle resourceBundle = ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        this.addMessageToOutputViewer(resourceBundle.getString("IDS_EXTENSION_BUNDLE_OUTPUT_ITEM_DESCRIPITION"), string);
    }

    public String getSuccessMessages() {
        String string = "";
        for (String string2 : this.mSelectedExtensionNames) {
            if (this.mSuccessMsg.get(string2) == null) continue;
            string = string + this.mSuccessMsg.get(string2);
        }
        return string;
    }

    private void addMessageToOutputViewer(String string, String string2) {
        ViewerFrame viewerFrame;
        OutputManager outputManager = OutputManager.getOutputManager();
        IOutputDocument iOutputDocument = outputManager.getDesignatedDocument();
        IOutputItem iOutputItem = null;
        for (long i = iOutputDocument.getItemCount() - 1L; !(i < 0L || (iOutputItem = iOutputDocument.getItemAtIndex(i)) instanceof HeaderItem || iOutputItem instanceof LogItem || iOutputItem.getDescription().equals(string)); --i) {
        }
        TextItem textItem = new TextItem();
        textItem.setDescription(string);
        textItem.setContents(string2);
        iOutputDocument.insertItem((IOutputItem)textItem, iOutputItem, true);
        if (SpssFrameMgr.getSpssFrameMgr().openDocumentCount(DocType.OUTPUT_DOC) > 0 && (viewerFrame = (ViewerFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.OUTPUT_DOC)) != null) {
            if (viewerFrame.getExtendedState() != 6) {
                viewerFrame.setExtendedState(0);
            }
            viewerFrame.toFront();
        }
    }
}

