/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.manage_extensions;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_install_utility.ExtensionBundleManifestHelper;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer.ExtensionBundleHelper;
import com.spss.java_client.ui.doc_types.actions.InstallDlgAction;
import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.extensionmanager.utilities.ExtensionInfoMgr;
import com.spss.uitools.ui_builder.SpecificationWriter;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public class ExtensionBundleRemover {
    private String mErrorMsg;
    private String mSuccessMsg;
    private boolean mNeedRemoveCDB;
    private Vector<String> mPathsNeedToBeDeleted;
    private Vector<String> mCDBInstalledFolderPath;
    private Vector<String> mExtBundleInstalledFilesAndFolders;
    private ExtensionBundleManifestHelper mManifestHelper;
    private File mSpeFile;
    private Vector<String> mExtPaths;
    private String mCDBPaths;
    private Set<String> mCommandSpecSet;
    private Set<String> mDialogSpecSet;
    private Set<String> mCodeSpecSet;
    private Set<String> mCommandPath;

    private void init() {
        this.mNeedRemoveCDB = false;
        this.mPathsNeedToBeDeleted = new Vector();
        this.mCDBInstalledFolderPath = new Vector();
        this.mExtBundleInstalledFilesAndFolders = new Vector();
        this.mCommandPath = new HashSet<String>();
        this.mCDBPaths = "";
        this.mExtPaths = new Vector();
        this.mManifestHelper = null;
        this.mCommandSpecSet = new HashSet<String>();
        this.mDialogSpecSet = new HashSet<String>();
        this.mSpeFile = null;
        this.mErrorMsg = "";
        this.mSuccessMsg = "";
    }

    private boolean deleteExtFolders() {
        for (String string : this.mExtBundleInstalledFilesAndFolders) {
            boolean bl;
            File file = new File(string);
            if (!(file.isDirectory() ? !(bl = BuilderUtil.getInstance().deleteFolder(file)) : !(bl = BuilderUtil.getInstance().deleteFile(file)))) continue;
            return false;
        }
        return true;
    }

    private boolean canBeDeleted(Vector<String> vector) {
        for (String string : vector) {
            File file = new File(string);
            String string2 = file.getParent() + File.separator;
            File file2 = new File(string2);
            if (file2.canWrite()) continue;
            return false;
        }
        return true;
    }

    private void loadPathsNeedToBeDeleted(String string) {
        this.mCDBPaths = SpecificationWriter.getDeploymentFolder();
        this.mExtPaths = FileLocationsUtil.getExtensionsPathes();
        this.mPathsNeedToBeDeleted.clear();
        this.loadExtBundleInstalledFilesAndFolderPath(string);
        for (String string2 : this.mExtBundleInstalledFilesAndFolders) {
            this.mPathsNeedToBeDeleted.add(string2);
        }
        if (this.mNeedRemoveCDB) {
            this.loadCDBInstalledFolderPath();
            for (String string2 : this.mCDBInstalledFolderPath) {
                this.mPathsNeedToBeDeleted.add(string2);
            }
        }
    }

    private File unJarSpdToTempDir() throws IOException {
        String string = PrefsMgr.getPrefsMgr().getTempPath().endsWith(File.separator) ? PrefsMgr.getPrefsMgr().getTempPath() : PrefsMgr.getPrefsMgr().getTempPath() + File.separatorChar;
        File file = new File(string = string + Calendar.getInstance().getTimeInMillis());
        if (!file.mkdir()) {
            return null;
        }
        ZipInputStream zipInputStream = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        JarEntry jarEntry = null;
        try {
            fileInputStream = new FileInputStream(this.mSpeFile);
            zipInputStream = new JarInputStream(fileInputStream);
            jarEntry = ((JarInputStream)zipInputStream).getNextJarEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (jarEntry != null) {
            for (String string2 : this.mDialogSpecSet) {
                if (!jarEntry.getName().equals(string2)) continue;
                ByteBuffer byteBuffer = ExtensionBundleHelper.readEntry((JarInputStream)zipInputStream);
                String string3 = string + File.separator + string2;
                File file2 = new File(string3);
                fileOutputStream = new FileOutputStream(file2.getAbsolutePath());
                try {
                    fileOutputStream.write(byteBuffer.array());
                }
                catch (IOException iOException) {
                    fileOutputStream.close();
                }
                break;
            }
            zipInputStream.closeEntry();
            jarEntry = ((JarInputStream)zipInputStream).getNextJarEntry();
        }
        zipInputStream.close();
        return file;
    }

    private void loadCDBInstalledFolderPath() {
        Object object;
        File file;
        Vector<String> vector = new Vector<String>();
        try {
            file = this.unJarSpdToTempDir();
        }
        catch (IOException iOException) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (File object22 : fileArray) {
            if (!object22.getName().endsWith(".spd")) continue;
            object = (File[])ActionCatalog.getActionCatalog().getSpssAction("utilities_install_dialog");
            try {
                DialogDefinition dialogDefinition = ((InstallDlgAction)object).readPackageFile(object22);
                vector.add(dialogDefinition.getDialogId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        File file2 = new File(this.mCDBPaths);
        File[] fileArray2 = file2.listFiles();
        for (String string : vector) {
            for (File file3 : fileArray2) {
                if (!file3.isDirectory() || !file3.getName().toString().equals(string)) continue;
                this.mCDBInstalledFolderPath.add(file3.getAbsolutePath());
            }
        }
        Set<String> set = this.mManifestHelper.getDialogSpecsSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (!((String)object).endsWith(".cfe")) continue;
            if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                this.mCDBInstalledFolderPath.add(BuilderUtil.getInstance().getExtensionPath() + File.separator + (String)object);
                continue;
            }
            if (BuilderUtil.getInstance().getAppType() != AppType.MODELER) continue;
            this.mCDBInstalledFolderPath.add(BuilderUtil.getInstance().getExtensionPath() + File.separator + this.mManifestHelper.getBundleName() + File.separator + (String)object);
        }
    }

    private void loadExtBundleInstalledFilesAndFolderPath(String string) {
        for (String string2 : this.mExtPaths) {
            File[] object;
            Iterator<String> iterator = new File(string2);
            for (File file : object = ((File)((Object)iterator)).listFiles()) {
                if (!file.isDirectory() || !file.getName().toString().equals(string)) continue;
                this.mExtBundleInstalledFilesAndFolders.add(file.getAbsolutePath());
                File[] fileArray = file.listFiles((FilenameFilter)new ExtensionInfoMgr.SPE_FilenameFiler());
                if (fileArray == null || fileArray.length <= 0) break;
                try {
                    this.mSpeFile = fileArray[0];
                    this.mManifestHelper = new ExtensionBundleManifestHelper(this.mSpeFile);
                    this.mCommandSpecSet = this.mManifestHelper.getCommandSpecsSet();
                    this.mCodeSpecSet = this.mManifestHelper.getCodeFilesSet();
                    this.mDialogSpecSet = this.mManifestHelper.getDialogSpecsSet();
                    if (!this.mDialogSpecSet.isEmpty()) {
                        this.mNeedRemoveCDB = true;
                        break;
                    }
                    this.mNeedRemoveCDB = false;
                }
                catch (ZipException zipException) {
                }
                catch (IOException iOException) {}
                break;
            }
            if (this.mExtBundleInstalledFilesAndFolders.isEmpty()) continue;
            break;
        }
        if (!this.mExtBundleInstalledFilesAndFolders.isEmpty()) {
            String string2;
            File file = new File(this.mExtBundleInstalledFilesAndFolders.firstElement());
            string2 = file.getParent().toString() + File.separator;
            for (String string3 : this.mCommandSpecSet) {
                this.mCommandPath.add(string2 + string3);
                this.mExtBundleInstalledFilesAndFolders.add(string2 + string3);
            }
            for (String string4 : this.mCodeSpecSet) {
                String string5 = string2 + string4;
                this.mExtBundleInstalledFilesAndFolders.add(string5);
            }
        }
    }

    public boolean doRemove(String string) {
        this.init();
        this.loadPathsNeedToBeDeleted(string);
        if (!this.canBeDeleted(this.mPathsNeedToBeDeleted)) {
            return false;
        }
        if (this.mNeedRemoveCDB && !this.unDeployCDB()) {
            this.setErrorMsg("Could not remove extension " + string);
            return false;
        }
        for (String string2 : this.mCommandPath) {
            File file = new File(string2);
            if (!file.exists()) continue;
            SyntaxMgr.getSyntaxMgr().executeSyntax("EXTENSION ACTION=REMOVE /SPECIFICATION COMMAND='" + string2 + "'.");
        }
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.deleteExtFolders()) {
            this.setErrorMsg("Could not remove extension " + string);
            return false;
        }
        this.setSuccessMsg(string + " removed successfully ");
        return true;
    }

    private boolean unDeployCDB() {
        for (String string : this.mCDBInstalledFolderPath) {
            try {
                if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                    if (BuilderUtil.getInstance().removeDeployed(string)) continue;
                    return false;
                }
                if (BuilderUtil.getInstance().getAppType() != AppType.MODELER) continue;
                String string2 = BuilderFrame.getExtensionId((File)new File(string));
                BuilderUtil.getInstance().unloadExtension(string2);
                File file = new File(string);
                if (file.delete()) continue;
                return false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    public static Vector<String> getCustomDialogBuilderPaths() {
        Vector<String> vector = new Vector<String>();
        vector.addAll(Arrays.asList(FileLocationsUtil.getSecondaryExtensionDirectory()));
        vector.add(FileLocationsUtil.getAppdataCustomDialogDirectoryForAllUsers());
        if (System.getProperty("os.name", "Windows").toLowerCase().startsWith("win")) {
            vector.add(FileLocationsUtil.getAppdataCustomDialogDirectory());
            vector.add(FileLocationsUtil.getCustomDialogsDirectory());
        } else {
            vector.add(FileLocationsUtil.getCustomDialogsDirectory());
            vector.add(FileLocationsUtil.getAppdataCustomDialogDirectory());
        }
        return (Vector)vector.clone();
    }

    public String getErrorMsg() {
        return this.mErrorMsg;
    }

    public String getSuccessMsg() {
        return this.mSuccessMsg;
    }

    private void setErrorMsg(String string) {
        this.mErrorMsg = string;
    }

    private void setSuccessMsg(String string) {
        this.mSuccessMsg = string;
    }
}

