/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.define_sets;

import com.spss.java_client.ui.controls.BasicACREvent;
import com.spss.java_client.ui.controls.BasicACRWidget;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DefineSetsPanel
extends BasicACRWidget {
    private JLabel mSetNameLabel;
    private Action mAddSetAction;
    private Action mChangeSetAction;
    private Action mRemoveSetAction;
    private StringTextField mSetNameTextField;

    public DefineSetsPanel(String string) {
        super(BasicACRWidget.ButtonOrienation.eWEST, string);
    }

    @Override
    public void setAddEnabled(boolean bl) {
        this.mAddSetAction.setEnabled(bl);
    }

    @Override
    public void setChangeEnabled(boolean bl) {
        this.mChangeSetAction.setEnabled(bl);
    }

    @Override
    public void setRemoveEnabled(boolean bl) {
        this.mRemoveSetAction.setEnabled(bl);
    }

    @Override
    public boolean isAddEnabled() {
        return this.mAddSetAction.isEnabled();
    }

    @Override
    public boolean isChangeEnabled() {
        return this.mChangeSetAction.isEnabled();
    }

    @Override
    public boolean isRemoveEnabled() {
        return this.mRemoveSetAction.isEnabled();
    }

    public StringTextField getValuesTextField() {
        return this.mSetNameTextField;
    }

    @Override
    protected void init() {
        this.mSetNameTextField = new StringTextField(10);
        this.mSetNameTextField.setDocument(new FixedLengthDocument(64));
        this.mAddSetAction = new ToggleButtonAction("IDS_ADD_SET"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefineSetsPanel.this.fireBasicACREvent(BasicACREvent.EventType.addButtonPress, actionEvent);
            }
        };
        this.mChangeSetAction = new ToggleButtonAction("IDS_CHANGE_SET"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefineSetsPanel.this.fireBasicACREvent(BasicACREvent.EventType.changeButtonPress, actionEvent);
            }
        };
        this.mRemoveSetAction = new ToggleButtonAction("IDS_REMOVE_SET"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefineSetsPanel.this.fireBasicACREvent(BasicACREvent.EventType.removeButtonPress, actionEvent);
            }
        };
        this.mSetNameLabel = new JLabel(ResUtil.getCommonDlgString("IDS_DEFINE_SETS_SET_NAME"));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.mSetNameLabel.setDisplayedMnemonic(ResUtil.getCommonDlgAccessKey("IDK_DEFINE_SETS_SET_NAME"));
        }
        this.mSetNameLabel.setLabelFor((Component)((Object)this.getValuesTextField()));
        JButton jButton = new JButton(this.mAddSetAction);
        JButton jButton2 = new JButton(this.mChangeSetAction);
        JButton jButton3 = new JButton(this.mRemoveSetAction);
        this.mItemList = new SerializableList(this.mListKey);
        this.mItemList.setSelectionMode(0);
        this.mScrollPane = new JScrollPane(this.mItemList);
        this.mScrollPane.setPreferredSize(new Dimension(50, 100));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardButtonInsets();
        Insets insets2 = new Insets(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(this, this.mSetNameLabel, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        insets2.set(0, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this, jButton, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this, jButton2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this, jButton3, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.normalizeButtonWidths((JPanel)this);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(this, (JComponent)((Object)this.mSetNameTextField), gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(0, insets.left, insets.top, 0);
        DialogUtil.addUsingGBL(this, this.mScrollPane, gridBagConstraints, 1, 2, 1, 2, n, insets2);
        this.mAddSetAction.setEnabled(false);
        this.mChangeSetAction.setEnabled(false);
        this.mRemoveSetAction.setEnabled(false);
        this.mItemList.addListSelectionListener(this);
        this.mItemList.addFocusListener(this);
        this.mItemList.getModel().addListDataListener(this);
    }
}

