/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.define_sets;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.IVariableSet;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableSortType;
import com.spss.java_client.core.documents.data.dictionary.VariableSet;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.BasicACREvent;
import com.spss.java_client.ui.controls.IBasicACRListener;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.utilities.define_sets.DefineSetsPanel;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DefineSetsDlg
extends BaseProcedureDialog
implements IBasicACRListener,
DocumentListener,
ListDataListener,
FocusListener {
    private static final String DEFINE_SET_WIDGET_CMD_ACTION = "DEFINE_SET_WIDGET_CMD_ACTION";
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private ArrowButton mArrowButton;
    private TargetVariableList mVarSetTargetList;
    private JLabel mVarSetLabel;
    private JScrollPane mVarSetListScrollPane;
    private DefineSetsPanel mACRWidget;
    private GridBagConstraints mGridConstraints;
    private Vector<IVariableSet> mVarSetVector;
    private ISpssDataSrc mDataSrc;
    private SpssVariableSortType mSortType;

    public DefineSetsDlg(JFrame jFrame) {
        super(jFrame, true, UtilitiesResBundle.getDefaultResourceBundleName(), UtilitiesResBundle.getImageFolder());
        Point point;
        this.setTitle(this.getResString("IDS_DEFINE_SETS_TITLE"));
        this.setDefaultCloseOperation(0);
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize(this.getIActionKey());
        if (dimension != null) {
            this.setSize(dimension);
        }
        if ((point = ProcedureDlgMgr.getMgr().getDialogLocation(this.getIActionKey())) != null) {
            this.setLocation(point);
        } else {
            this.setLocationRelativeTo(this.getParent());
        }
    }

    @Override
    public String generateSyntax() {
        return null;
    }

    @Override
    public String getIActionKey() {
        return "utilities_define_variable_sets";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_dset";
    }

    @Override
    public void acrEventOccured(BasicACREvent basicACREvent) {
        BasicACREvent.EventType eventType = basicACREvent.getEventType();
        if (eventType.equals((Object)BasicACREvent.EventType.addButtonPress)) {
            this.acrAddButtonPressed();
        } else if (eventType.equals((Object)BasicACREvent.EventType.removeButtonPress)) {
            this.acrRemoveButtonPressed();
        } else if (eventType.equals((Object)BasicACREvent.EventType.changeButtonPress)) {
            this.acrChangeButtonPressed();
        } else if (eventType.equals((Object)BasicACREvent.EventType.listSelectionValueChange) || eventType.equals((Object)BasicACREvent.EventType.listGotFocus) && this.mACRWidget.getList().getSelectedIndex() != -1) {
            this.acrListSelectionChange();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.stateOfAddChangeRemove();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.stateOfAddChangeRemove();
        if (this.mACRWidget.getValuesTextField().getText().length() == 0) {
            this.stateOfACRButtons(false, false, false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.stateOfAddChangeRemove();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.stateOfAddChangeRemove();
        if (this.mVarSetTargetList.getModel().getSize() == 0) {
            this.stateOfACRButtons(false, false, false);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mACRWidget.getValuesTextField()) {
            this.mACRWidget.getValuesTextField().selectAll();
        }
        if (focusEvent.getSource().equals(this.mSrcVarList)) {
            this.mArrowButton.setEnabled(true);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    protected boolean canDispose() {
        return !this.showPendingChangesWarning();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupMainPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DefineSetsDlg.this.cancelPressed();
                DefineSetsDlg.this.dispose();
            }
        });
        this.pack();
    }

    @Override
    protected boolean cancelPressed() {
        boolean bl = this.showPendingChangesWarning();
        if (!bl) {
            this.mDataSrc.saveVariableSets(this.mVarSetVector);
            this.saveDialogState();
            ProcedureDlgMgr.getMgr().saveDialogSize(this.getIActionKey(), this.getSize());
            ProcedureDlgMgr.getMgr().saveDialogLocation(this.getIActionKey(), this.getLocation());
            ProcedureDlgMgr.getMgr().savePersistentState(this.getIActionKey(), this.getDialogDataModel());
            return true;
        }
        return false;
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        jPanel.remove(this.getOkButton());
        jPanel.remove(this.getPasteButton());
        jPanel.remove(this.getResetButton());
        this.getCancelButton().setText(this.getResString("IDS_CLOSE"));
        this.getRootPane().setDefaultButton(this.getCancelButton());
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    @Override
    protected void loadDialogState() {
        Object object = this.getDialogDataModel().getObject("DEFINE_SETS_KEY");
        if (object != null) {
            this.mVarSetVector = (Vector)object;
            int n = 0;
            for (IVariableSet iVariableSet : this.mVarSetVector) {
                Vector vector = iVariableSet.getVariableNames(IVariableSet.ChangeCase.kNoChange);
                for (String string : vector) {
                    if (this.mDataSrc.findVarIndex(string) != -1) continue;
                    iVariableSet.deleteVariable(string);
                }
                Vector vector2 = iVariableSet.getVariableNames(IVariableSet.ChangeCase.kNoChange);
                if (vector2.size() == 0) continue;
                this.mACRWidget.addListItemAt(n, iVariableSet.getName(IVariableSet.ChangeCase.kNoChange));
                ++n;
            }
        } else {
            this.mVarSetVector = this.mDataSrc.getVariableSets(ISpssDataSrc.VarSetsType.kVariableSet);
            int n = 0;
            for (IVariableSet iVariableSet : this.mVarSetVector) {
                this.mACRWidget.addListItemAt(n, iVariableSet.getName(IVariableSet.ChangeCase.kNoChange));
                ++n;
            }
        }
        this.loadSrcList();
        this.setVisible(true);
    }

    @Override
    protected void saveDialogState() {
        this.getDialogDataModel().putObject("DEFINE_SETS_KEY", this.mVarSetVector);
    }

    private void initVars() {
        Object object;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            object = ((DataFrame)spssFrame).getDatasetId();
            this.mDataSrc = DataMgr.getDataMgr().getDataSource((LocallyUniqueId)object);
        }
        this.mSrcVarList = new SrcVariableList();
        this.loadSrcList();
        this.mSrcVarList.requestFocus();
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight()));
        this.mSrcVarList.addFocusListener(this);
        object = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences = ((Preferences)object).node("options");
        Preferences preferences2 = preferences.node("general");
        String string = preferences2.get("var_list_sort", PrefDefaults.DEF_VAR_LIST_SORT_ORDER_FILE);
        if (string.equals(IOptionConstants.VAR_LIST_SORT_VALUES[0])) {
            this.mSortType = SpssVariableSortType.alpha;
        } else if (string.equals(IOptionConstants.VAR_LIST_SORT_VALUES[1])) {
            this.mSortType = SpssVariableSortType.file;
        } else if (string.equals(IOptionConstants.VAR_LIST_SORT_VALUES[2])) {
            this.mSortType = SpssVariableSortType.measurement;
        }
        this.mVarSetTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eMoveOriginal);
        this.mVarSetTargetList.setSortType(this.mSortType);
        this.mVarSetListScrollPane = new JScrollPane(this.mVarSetTargetList);
        this.mVarSetTargetList.setLoadFromPersistent(false);
        this.mVarSetTargetList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mVarSetTargetList.getFixedCellHeight() * 9 + 2));
        this.mVarSetListScrollPane.setPreferredSize(this.mVarSetTargetList.getMinimumSize());
        this.mVarSetTargetList.getModel().addListDataListener(this);
        this.mArrowButton = new ArrowButton();
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mVarSetTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mVarSetLabel = DialogUtil.createLabel(this, "IDS_DEFINE_SETS_VARIABLES_SET");
        this.mVarSetLabel.setLabelFor(this.mVarSetTargetList);
        this.mACRWidget = new DefineSetsPanel(DEFINE_SET_WIDGET_CMD_ACTION);
        this.mACRWidget.setAllowDuplicates(false);
        this.mACRWidget.getList().setFocusable(true);
        this.mACRWidget.addBasicACRListener(this);
        this.mACRWidget.getValuesTextField().getDocument().addDocumentListener(this);
        this.mACRWidget.getValuesTextField().addFocusListener(this);
        this.mArrowButton.setEnabled(false);
        this.mVarSetVector = new Vector();
        this.mGridConstraints = new GridBagConstraints();
    }

    private void setupMainPanel(JPanel jPanel) {
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getArrowButtonInsets();
        this.mGridConstraints.fill = 0;
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mACRWidget, this.mGridConstraints, 0, 1, 3, 1, n, null);
        this.mGridConstraints.weighty = 0.0;
        Insets insets2 = new Insets(DialogUtil.getComponentGroupGap(), insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mVarSetLabel, this.mGridConstraints, 2, 2, 1, 1, n, insets2);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_DEFINE_SETS_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        insets2.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mGridConstraints, 0, 2, 1, 1, n, insets2);
        this.mGridConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, this.mGridConstraints, 0, 3, 1, 1, n, null);
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.fill = 0;
        n = 10;
        insets2.set(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, this.mGridConstraints, 1, 3, 1, 1, n, insets2);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.fill = 1;
        n = 23;
        insets2.set(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mVarSetListScrollPane, this.mGridConstraints, 2, 3, 1, 1, n, insets2);
    }

    private void acrAddButtonPressed() {
        this.stateOfACRButtons(false, false, false);
        int n = this.mACRWidget.getList().getModel().getSize();
        VariableSet variableSet = new VariableSet();
        variableSet.setName(this.mACRWidget.getValuesTextField().getText().trim());
        variableSet.setLabel(this.mACRWidget.getValuesTextField().getText().trim());
        for (int i = 0; i < this.mVarSetTargetList.getModel().getSize(); ++i) {
            variableSet.addVariableName(this.mVarSetTargetList.getModel().getElementAt(i).getName());
        }
        this.setSrcListSelection();
        this.mACRWidget.addListItemAt(n, variableSet.getName(IVariableSet.ChangeCase.kNoChange));
        this.mVarSetVector.add(n, (IVariableSet)variableSet);
        this.mACRWidget.getList().clearSelection();
        this.setStateOfControls();
    }

    private void acrRemoveButtonPressed() {
        this.stateOfACRButtons(false, false, false);
        int n = this.mACRWidget.getListSelectedIndex();
        this.setSrcListSelection();
        this.mVarSetVector.remove(n);
        this.mACRWidget.removeListItemAt(n);
        this.setStateOfControls();
    }

    private void acrChangeButtonPressed() {
        this.stateOfACRButtons(false, false, false);
        int n = this.mACRWidget.getListSelectedIndex();
        VariableSet variableSet = new VariableSet();
        variableSet.setName(this.mACRWidget.getValuesTextField().getText().trim());
        variableSet.setLabel(this.mACRWidget.getValuesTextField().getText().trim());
        for (int i = 0; i < this.mVarSetTargetList.getModel().getSize(); ++i) {
            variableSet.addVariableName(this.mVarSetTargetList.getModel().getElementAt(i).getName());
        }
        this.setSrcListSelection();
        this.mVarSetVector.remove(n);
        this.mVarSetVector.add(n, (IVariableSet)variableSet);
        this.mACRWidget.removeListItemAt(n);
        this.mACRWidget.addListItemAt(n, variableSet.getName(IVariableSet.ChangeCase.kNoChange));
        this.mACRWidget.getList().clearSelection();
        this.setStateOfControls();
    }

    private void acrListSelectionChange() {
        if (this.mACRWidget.getListSelectedIndex() != -1) {
            this.mACRWidget.getValuesTextField().getDocument().removeDocumentListener(this);
            this.mACRWidget.getValuesTextField().setText(this.mACRWidget.getListItemAt(this.mACRWidget.getListSelectedIndex()).toString());
            this.mACRWidget.getValuesTextField().getDocument().addDocumentListener(this);
            this.loadTargetList();
            VarListModel varListModel = this.mVarSetTargetList.getModel();
            varListModel.sort();
            this.mACRWidget.setRemoveEnabled(true);
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            this.mArrowButton.setEnabled(true);
        } else {
            this.mACRWidget.setRemoveEnabled(false);
            this.setSrcListSelection();
            this.setStateOfControls();
        }
        this.mACRWidget.setAddEnabled(false);
        this.mACRWidget.setChangeEnabled(false);
    }

    private void stateOfAddChangeRemove() {
        if (this.mACRWidget.getList().getSelectedIndex() == -1 && this.mACRWidget.getValuesTextField().getText().length() > 0 && this.mVarSetTargetList.getModel().getSize() > 0) {
            if (this.mACRWidget.getValuesTextField().getText().trim().equals("")) {
                this.stateOfACRButtons(false, false, false);
            } else {
                this.stateOfACRButtons(true, false, false);
                this.selectListItem();
            }
        } else if (this.mACRWidget.getListItemCount() > 0 && this.mACRWidget.getValuesTextField().getText().length() > 0 && this.mACRWidget.getList().getSelectedIndex() == -1) {
            this.selectListItem();
        } else if (this.mACRWidget.getList().getSelectedIndex() != -1 && this.mACRWidget.getValuesTextField().getText().length() > 0 && this.mACRWidget.getValuesTextField().getText().equals(this.mACRWidget.getList().getSelectedValue().toString()) && this.mVarSetTargetList.getModel().getSize() > 0) {
            Vector vector = this.mVarSetVector.get(this.mACRWidget.getList().getSelectedIndex()).getVariableNames(IVariableSet.ChangeCase.kNoChange);
            boolean bl = false;
            if (this.mVarSetTargetList.getModel().getSize() != vector.size()) {
                bl = true;
            } else {
                for (int i = 0; i < this.mVarSetTargetList.getModel().getSize(); ++i) {
                    if (vector.contains(this.mVarSetTargetList.getModel().getElementAt(i).getName())) continue;
                    bl = true;
                }
            }
            if (bl) {
                this.stateOfACRButtons(false, true, false);
            } else {
                this.stateOfACRButtons(false, false, true);
            }
        } else if (this.mACRWidget.getList().getSelectedIndex() != -1 && this.mACRWidget.getValuesTextField().getText().length() > 0 && !this.mACRWidget.getValuesTextField().getText().equals(this.mACRWidget.getList().getSelectedValue().toString()) && this.mVarSetTargetList.getModel().getSize() > 0) {
            if (this.mACRWidget.getValuesTextField().getText().trim().equals("")) {
                this.stateOfACRButtons(false, false, false);
            } else {
                this.stateOfACRButtons(true, true, false);
            }
            this.selectListItem();
        }
    }

    private void selectListItem() {
        for (int i = 0; i < this.mACRWidget.getListItemCount(); ++i) {
            if (!this.mACRWidget.getValuesTextField().getText().equalsIgnoreCase(this.mACRWidget.getListItemAt(i).toString())) continue;
            this.stateOfACRButtons(false, false, true);
            this.mACRWidget.removeBasicACRListener(this);
            this.mACRWidget.getList().setSelectedIndex(i);
            this.mACRWidget.addBasicACRListener(this);
            this.loadTargetList();
        }
    }

    private void loadSrcList() {
        this.mSrcVarList.getModel().removeAll();
        if (this.mDataSrc != null) {
            int n = this.mDataSrc.columnCount();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = this.mDataSrc.getVariable(i);
                this.mSrcVarList.getModel().addElement(iSpssVariable);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadTargetList() {
        void var4_11;
        void var4_8;
        Vector<IVariableSet> vector = this.mVarSetVector;
        Vector<ISpssVariable> vector2 = new Vector<ISpssVariable>();
        for (IVariableSet iVariableSet : vector) {
            String string = iVariableSet.getVariableNames().toString();
            int n = string.length();
            String string2 = string.substring(1, n - 1);
            if (!iVariableSet.getName(IVariableSet.ChangeCase.kNoChange).equals(this.mACRWidget.getListItemAt(this.mACRWidget.getListSelectedIndex()).toString())) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string2.toLowerCase(), ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                int n2 = this.mDataSrc.findVarIndex(string3);
                ISpssVariable iSpssVariable = this.mDataSrc.getVariable(n2);
                vector2.add(iSpssVariable);
            }
        }
        this.mVarSetTargetList.getModel().removeListDataListener(this);
        this.mVarSetTargetList.getModel().removeAll();
        for (ISpssVariable iSpssVariable : vector2) {
            this.mVarSetTargetList.getModel().addElement(iSpssVariable);
        }
        Object object = new int[this.mVarSetTargetList.getModel().getSize()];
        boolean bl = false;
        while (var4_8 < this.mVarSetTargetList.getModel().getSize()) {
            object[var4_8] = var4_8;
            ++var4_8;
        }
        this.mVarSetTargetList.setSelectedIndices((int[])object);
        this.mVarSetTargetList.getModel().addListDataListener(this);
        this.mSrcVarList.removeAll();
        if (this.mDataSrc != null) {
            int n = this.mDataSrc.columnCount();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = this.mDataSrc.getVariable(i);
                this.mSrcVarList.getModel().addElement(iSpssVariable);
            }
        }
        boolean bl2 = false;
        while (var4_11 < this.mVarSetTargetList.getModel().getSize()) {
            this.mSrcVarList.getModel().removeElement(this.mVarSetTargetList.getModel().getElementAt((int)var4_11));
            ++var4_11;
        }
    }

    private void stateOfACRButtons(boolean bl, boolean bl2, boolean bl3) {
        this.mACRWidget.setAddEnabled(bl);
        this.mACRWidget.setChangeEnabled(bl2);
        this.mACRWidget.setRemoveEnabled(bl3);
    }

    private void setStateOfControls() {
        this.mACRWidget.getValuesTextField().setText("");
        this.mVarSetTargetList.removeAll();
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.setEnabled(true);
    }

    private void setSrcListSelection() {
        int[] nArray = new int[this.mVarSetTargetList.getModel().getSize()];
        int n = 0;
        this.loadSrcList();
        this.mSrcVarList.requestFocus();
        for (int i = 0; i < this.mSrcVarList.getModel().getSize(); ++i) {
            for (int j = 0; j < this.mVarSetTargetList.getModel().getSize(); ++j) {
                if (!this.mVarSetTargetList.getModel().getElementAt(j).getName().equals(this.mSrcVarList.getModel().getElementAt(i).getName())) continue;
                nArray[n] = i;
                ++n;
            }
        }
        this.mSrcVarList.setSelectedIndices(nArray);
    }

    private boolean showPendingChangesWarning() {
        int n;
        boolean bl = false;
        if ((this.mACRWidget.isAddEnabled() || this.mACRWidget.isChangeEnabled()) && ((n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_DEFINE_SETS_ERR_MESSAGE_PENDING_OPERATIONS_WILL_BE_LOST"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) == 3 || n == -1)) {
            bl = true;
        }
        return bl;
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mACRWidget.getValuesTextField());
        vector.add(this.mACRWidget.getList());
        for (n = 0; n < this.mACRWidget.getComponentCount(); ++n) {
            if (!(this.mACRWidget.getComponent(n) instanceof JButton)) continue;
            vector.add(this.mACRWidget.getComponent(n));
        }
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mVarSetTargetList);
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            if (!(this.mCmdButtonPanel.getComponent(n) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }
}

