/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.command.executor.CommandExecutor;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer.ExtensionBundleHelper;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer.TermsOfUseDlg;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer.ViewBundleReadMeFileDialog;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ViewInstalledExtensionBundleDetailsDialog
extends BaseDialog {
    private JPanel mDetailsPanel;
    private JLabel mSummaryLbl;
    private JTextField mSummaryText;
    private JLabel mDescriptionLbl;
    private JTextArea mDescriptionText;
    private JScrollPane mDescScrollPane;
    private JLabel mAuthorLbl;
    private JTextField mAuthorText;
    private JLabel mReleaseDateLbl;
    private JTextField mReleaseDateText;
    private JLabel mSpacer_01;
    private JLabel mVersionLbl;
    private JTextField mVersionText;
    private JLabel mStatsVerLbl;
    private JTextField mStatsVerText;
    private JLabel mLinksLbl;
    private JTextField mLinksText;
    private JButton mViewReadmeBtn;
    private JButton mViewTermsOfUseBtn;
    private JPanel mComponentsPanel;
    private JLabel mCustomDialogLbl;
    private JPanel mComponentsSubPanel;
    private JTextField mNameHeader;
    private JTextField mMenuLocationHeader;
    private JTextField mNameText;
    private JTextField mMenuLocationText;
    private JLabel mExtensionCmdsLbl;
    private JTextField mExtensionCmdsText;
    private JPanel mDepenenciesPanel;
    private JLabel mPythonReqLbl;
    private JTextField mPythonReqText;
    private JLabel mRReqLbl;
    private JTextField mRReqText;
    private JLabel mRPackagesLbl;
    private JTextField mRPackagesText;
    private JLabel mPythonPackagesLbl;
    private JTextField mPythonPackagesText;
    private JPanel mMainPanel;
    private ExtensionBundleHelper mExtensionBundleHelper;

    public ViewInstalledExtensionBundleDetailsDialog(JDialog jDialog) {
        super(jDialog, "", true, ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), UtilitiesResBundle.getImageFolder());
        Point point;
        this.setDefaultCloseOperation(2);
        this.setTitle(this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DAILOG2_TITLE"));
        this.pack();
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize(this.getIActionKey());
        if (dimension != null) {
            this.setSize(dimension);
        }
        if ((point = ProcedureDlgMgr.getMgr().getDialogLocation(this.getIActionKey())) != null) {
            this.setLocation(point);
        } else {
            this.setLocationRelativeTo(jDialog);
        }
    }

    protected void init() {
        super.init();
        this.initVariables();
        JPanel jPanel = this.getViewPanel();
        this.setupMainPanel(jPanel);
        this.pack();
        this.setTabPolicy();
    }

    private void setTabPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSummaryText);
        vector.add(this.mDescriptionText);
        vector.add(this.mAuthorText);
        vector.add(this.mReleaseDateText);
        vector.add(this.mVersionText);
        vector.add(this.mStatsVerText);
        vector.add(this.mLinksText);
        vector.add(this.mViewTermsOfUseBtn);
        vector.add(this.mViewReadmeBtn);
        vector.add(this.mNameText);
        vector.add(this.mMenuLocationText);
        vector.add(this.mPythonReqText);
        vector.add(this.mRReqText);
        vector.add(this.mRPackagesText);
        vector.add(this.mPythonPackagesText);
        vector.addAll(new Vector<Component>(Arrays.asList(this.getCmdButtonPanel().getComponents())));
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    public String getDialogHelpID() {
        return "idh_ext_bundles_details";
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        JButton jButton = new JButton(new CloseAction());
        JButton jButton2 = new JButton((Action)this.createHelpAction());
        if (UIToolDialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                DialogUtil.setupMacHelpButton(jButton2);
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void initVariables() {
        this.mDetailsPanel = new JPanel();
        this.mDetailsPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_DETAILS")));
        this.mDetailsPanel.setLayout(new GridBagLayout());
        Dimension dimension = new Dimension(440, 272);
        this.mDetailsPanel.setMinimumSize(dimension);
        this.mDetailsPanel.setPreferredSize(dimension);
        this.mDetailsPanel.setSize(dimension);
        this.mSummaryLbl = new JLabel();
        this.mSummaryLbl.setText(this.getResString("IDS_EXTENSION_BUNDLE_REQUIRED_TAB_SUMMARY"));
        this.mSummaryText = new JTextField();
        this.mSummaryLbl.setLabelFor(this.mSummaryText);
        this.mDescriptionLbl = new JLabel();
        this.mDescriptionLbl.setText(this.getResString("IDS_EXTENSION_BUNDLE_REQUIRED_TAB_DESCRIPTION"));
        this.mDescriptionLbl.setVerticalAlignment(1);
        this.mDescScrollPane = new JScrollPane();
        this.mDescriptionText = new JTextArea();
        this.mDescriptionText.setColumns(20);
        this.mDescriptionText.setRows(5);
        this.mDescriptionText.setLineWrap(true);
        this.mDescriptionText.setWrapStyleWord(true);
        this.mDescScrollPane.setViewportView(this.mDescriptionText);
        this.mDescriptionLbl.setLabelFor(this.mDescriptionText);
        this.mAuthorLbl = new JLabel();
        this.mAuthorLbl.setText(this.getResString("IDS_EXTENSION_BUNDLE_REQUIRED_TAB_AUTHOR"));
        this.mAuthorText = new JTextField();
        this.mAuthorLbl.setLabelFor(this.mAuthorText);
        this.mReleaseDateLbl = new JLabel();
        this.mReleaseDateLbl.setText(this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_RELEASE_DATE"));
        this.mReleaseDateText = new JTextField();
        Dimension dimension2 = new Dimension(70, 20);
        this.mReleaseDateText.setMinimumSize(dimension2);
        this.mReleaseDateText.setSize(dimension2);
        this.mReleaseDateLbl.setLabelFor(this.mReleaseDateText);
        this.mSpacer_01 = new JLabel();
        this.mSpacer_01.setText(" ");
        this.mVersionLbl = new JLabel();
        this.mVersionLbl.setText(this.getResString("IDS_EXTENSION_BUNDLE_REQUIRED_TAB_VERSION"));
        this.mVersionText = new JTextField();
        Dimension dimension3 = new Dimension(40, 20);
        this.mVersionText.setMinimumSize(dimension3);
        this.mVersionText.setSize(dimension3);
        this.mVersionLbl.setLabelFor(this.mVersionText);
        this.mStatsVerLbl = new JLabel();
        this.mStatsVerLbl.setHorizontalAlignment(4);
        this.mStatsVerLbl.setLabelFor(this.mStatsVerText);
        this.mStatsVerLbl.setText(this.getResString("IDS_EXTENSION_BUNDLE_REQUIRED_TAB_PASW_STATISTICS_VERSION"));
        this.mStatsVerText = new JTextField();
        this.mStatsVerLbl.setLabelFor(this.mStatsVerText);
        this.mLinksLbl = new JLabel();
        this.mLinksLbl.setText(this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_LINKS"));
        this.mLinksText = new JTextField();
        this.mLinksLbl.setLabelFor(this.mLinksText);
        this.mViewReadmeBtn = new JButton();
        this.mViewReadmeBtn.setText(this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_VIEWREADME"));
        this.mViewReadmeBtn.setAction(new ViewReadMeAction());
        this.mViewReadmeBtn.setEnabled(false);
        this.mViewTermsOfUseBtn = new JButton();
        this.mViewTermsOfUseBtn.setText(this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_VIEW_TERMS_OF_USE"));
        this.mViewTermsOfUseBtn.setAction(new ViewTermsOfUseAction());
        this.mViewTermsOfUseBtn.setEnabled(false);
        this.mComponentsPanel = new JPanel();
        this.mComponentsPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_COMPONENTS")));
        this.mComponentsPanel.setLayout(new GridBagLayout());
        this.mComponentsSubPanel = new JPanel();
        this.mComponentsSubPanel.setLayout(new GridBagLayout());
        this.mNameHeader = new JTextField();
        this.mNameHeader.setHorizontalAlignment(0);
        this.mNameHeader.setText(this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_NAME"));
        this.mNameHeader.setFocusable(false);
        this.mNameHeader.setName("mNameHeader");
        this.mMenuLocationHeader = new JTextField();
        this.mMenuLocationHeader.setHorizontalAlignment(0);
        this.mMenuLocationHeader.setText(this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_MENU_LOC"));
        this.mMenuLocationHeader.setFocusable(false);
        this.mMenuLocationHeader.setName("mMenuLocationHeader");
        this.mNameText = new JTextField();
        this.mMenuLocationText = new JTextField();
        this.mCustomDialogLbl = new JLabel();
        this.mCustomDialogLbl.setText(this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_CUSTDLG"));
        this.mCustomDialogLbl.setLabelFor(this.mNameHeader);
        this.mExtensionCmdsLbl = new JLabel();
        this.mExtensionCmdsLbl.setText(this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_EXTCMDS"));
        this.mExtensionCmdsText = new JTextField();
        this.mExtensionCmdsLbl.setLabelFor(this.mExtensionCmdsText);
        this.mDepenenciesPanel = new JPanel();
        this.mDepenenciesPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_DEPENDENCIES")));
        this.mDepenenciesPanel.setLayout(new GridBagLayout());
        this.mPythonReqLbl = new JLabel();
        this.mPythonReqLbl.setText(this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_PYTH_REQ"));
        this.mPythonReqText = new JTextField();
        Dimension dimension4 = new Dimension(35, 22);
        this.mPythonReqText.setMinimumSize(dimension4);
        this.mPythonReqText.setPreferredSize(dimension4);
        this.mPythonReqText.setSize(dimension4);
        this.mPythonReqLbl.setLabelFor(this.mPythonReqText);
        this.mRReqLbl = new JLabel();
        this.mRReqLbl.setText(this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_R_REQ"));
        this.mRReqText = new JTextField();
        this.mRReqText.setMinimumSize(dimension4);
        this.mRReqText.setPreferredSize(dimension4);
        this.mRReqText.setSize(dimension4);
        this.mRReqLbl.setLabelFor(this.mRReqText);
        this.mRPackagesLbl = new JLabel();
        this.mRPackagesLbl.setText(this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_R_PKGS"));
        this.mRPackagesText = new JTextField();
        this.mRPackagesLbl.setLabelFor(this.mRPackagesText);
        this.mPythonPackagesLbl = new JLabel();
        this.mPythonPackagesLbl.setText(this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_PYTH_MODS"));
        this.mPythonPackagesText = new JTextField();
        this.mPythonPackagesLbl.setLabelFor(this.mPythonPackagesText);
    }

    private void findJTextFieldComponents(Component[] componentArray) {
        for (Component component : componentArray) {
            if (component instanceof JTextField) {
                ((JTextField)component).setEditable(false);
                if (component.getName() != null && (component.getName().equals("mNameHeader") || component.getName().equals("mMenuLocationHeader"))) {
                    component.setBackground(UIManager.getDefaults().getColor("TableHeader.background"));
                    continue;
                }
                component.setBackground(UIManager.getDefaults().getColor("Panel.background"));
                continue;
            }
            if (component instanceof JTextArea) {
                ((JTextArea)component).setEditable(false);
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.findJTextFieldComponents(((Container)component).getComponents());
        }
    }

    private JPanel setupDetailsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.bottom += 5;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = insets;
        this.mDetailsPanel.add((Component)this.mSummaryLbl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = insets;
        this.mDetailsPanel.add((Component)this.mSummaryText, gridBagConstraints);
        this.mDescriptionLbl.setVerticalAlignment(1);
        this.mDescriptionLbl.setHorizontalTextPosition(2);
        this.mDescriptionLbl.setRequestFocusEnabled(false);
        this.mDescriptionLbl.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        this.mDetailsPanel.add((Component)this.mDescriptionLbl, gridBagConstraints);
        this.mDescriptionText.setColumns(20);
        this.mDescriptionText.setRows(5);
        this.mDescScrollPane.setViewportView(this.mDescriptionText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = insets;
        this.mDetailsPanel.add((Component)this.mDescScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = insets;
        this.mDetailsPanel.add((Component)this.mAuthorLbl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.mDetailsPanel.add((Component)this.mAuthorText, gridBagConstraints);
        this.mReleaseDateLbl.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets;
        this.mDetailsPanel.add((Component)this.mReleaseDateLbl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = insets;
        this.mDetailsPanel.add((Component)this.mReleaseDateText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = insets;
        this.mDetailsPanel.add((Component)this.mVersionLbl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = insets;
        this.mDetailsPanel.add((Component)this.mVersionText, gridBagConstraints);
        this.mStatsVerLbl.setHorizontalAlignment(4);
        this.mStatsVerLbl.setLabelFor(this.mStatsVerText);
        this.mStatsVerLbl.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets;
        this.mDetailsPanel.add((Component)this.mStatsVerLbl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = insets;
        this.mDetailsPanel.add((Component)this.mStatsVerText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = insets;
        this.mDetailsPanel.add((Component)this.mLinksLbl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.mDetailsPanel.add((Component)this.mLinksText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.mDetailsPanel.add((Component)this.mViewTermsOfUseBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets;
        this.mDetailsPanel.add((Component)this.mViewReadmeBtn, gridBagConstraints);
        JLabel jLabel = new JLabel();
        jLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = insets;
        this.mDetailsPanel.add((Component)jLabel, gridBagConstraints);
        return this.mDetailsPanel;
    }

    private JPanel setupComponentsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.bottom += 5;
        int n = 18;
        int n2 = 1;
        n2 = 0;
        gridBagConstraints.fill = 2;
        n = 18;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this.mComponentsPanel, this.mCustomDialogLbl, gridBagConstraints, 0, 0, n2, 1, n, insets);
        this.mComponentsSubPanel = this.setupComponentsSubPanel();
        gridBagConstraints = new GridBagConstraints();
        n2 = 0;
        gridBagConstraints.fill = 1;
        n = 18;
        gridBagConstraints.weighty = 0.5;
        DialogUtil.addUsingGBL(this.mComponentsPanel, this.mComponentsSubPanel, gridBagConstraints, 0, 1, n2, 2, n, insets);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        n = 18;
        DialogUtil.addUsingGBL(this.mComponentsPanel, this.mExtensionCmdsLbl, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints = new GridBagConstraints();
        n2 = 0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mComponentsPanel, this.mExtensionCmdsText, gridBagConstraints, 1, 3, n2, 1, n, insets);
        return this.mComponentsPanel;
    }

    private JPanel setupComponentsSubPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(0, 0, 0, 0);
        --insets.bottom;
        --insets.right;
        int n = 18;
        gridBagConstraints.fill = 2;
        n = 18;
        gridBagConstraints.weightx = 0.3;
        DialogUtil.addUsingGBL(this.mComponentsSubPanel, this.mNameHeader, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.7;
        DialogUtil.addUsingGBL(this.mComponentsSubPanel, this.mMenuLocationHeader, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.bottom += 6;
        gridBagConstraints.weightx = 0.3;
        DialogUtil.addUsingGBL(this.mComponentsSubPanel, this.mNameText, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.7;
        DialogUtil.addUsingGBL(this.mComponentsSubPanel, this.mMenuLocationText, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return this.mComponentsSubPanel;
    }

    private JPanel setupDependenciesPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.bottom += 5;
        int n = 18;
        int n2 = 1;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mDepenenciesPanel, this.mPythonReqLbl, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mDepenenciesPanel, this.mPythonReqText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mDepenenciesPanel, this.mRReqLbl, gridBagConstraints, 2, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mDepenenciesPanel, this.mRReqText, gridBagConstraints, 3, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mDepenenciesPanel, this.mRPackagesLbl, gridBagConstraints, 0, 1, 1, 1, n, insets);
        n2 = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        DialogUtil.addUsingGBL(this.mDepenenciesPanel, this.mRPackagesText, gridBagConstraints, 1, 1, n2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(this.mDepenenciesPanel, this.mPythonPackagesLbl, gridBagConstraints, 0, 2, 1, 1, n, insets);
        n2 = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        DialogUtil.addUsingGBL(this.mDepenenciesPanel, this.mPythonPackagesText, gridBagConstraints, 1, 2, n2, 1, n, insets);
        return this.mDepenenciesPanel;
    }

    private void setupMainPanel(JPanel jPanel) {
        this.mMainPanel = new JPanel();
        this.mMainPanel.setFocusable(true);
        this.mMainPanel.setLayout(new GridBagLayout());
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.bottom += 5;
        int n = 18;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        n = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mDetailsPanel = this.setupDetailsPanel();
        DialogUtil.addUsingGBL(this.mMainPanel, this.mDetailsPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        n = 18;
        this.mComponentsPanel = this.setupComponentsPanel();
        DialogUtil.addUsingGBL(this.mMainPanel, this.mComponentsPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        n = 18;
        this.mDepenenciesPanel = this.setupDependenciesPanel();
        DialogUtil.addUsingGBL(this.mMainPanel, this.mDepenenciesPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.findJTextFieldComponents(this.mDetailsPanel.getComponents());
        this.findJTextFieldComponents(this.mComponentsPanel.getComponents());
        this.findJTextFieldComponents(this.mDepenenciesPanel.getComponents());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets2 = new Insets(0, 0, 0, 0);
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mMainPanel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
    }

    public String getIActionKey() {
        return "utilities_view_extension_bundles_dialog2";
    }

    public void setExtensionBundle(ExtensionBundleHelper extensionBundleHelper) {
        StringBuilder stringBuilder;
        Vector<String> vector;
        this.mExtensionBundleHelper = extensionBundleHelper;
        this.mSummaryText.setText(this.mExtensionBundleHelper.getSummary());
        this.mSummaryText.setCaretPosition(0);
        this.mDescriptionText.setText(this.mExtensionBundleHelper.getDescription());
        this.mDescriptionText.setCaretPosition(0);
        String string = this.mDescriptionLbl.getAccessibleContext().getAccessibleName();
        this.mDescriptionText.getAccessibleContext().setAccessibleName(string + this.mExtensionBundleHelper.getDescription());
        this.mAuthorText.setText(this.mExtensionBundleHelper.getAuthor());
        this.mReleaseDateText.setText(this.mExtensionBundleHelper.getReleaseDate());
        this.mVersionText.setText(this.mExtensionBundleHelper.getVersion());
        this.mStatsVerText.setText(this.mExtensionBundleHelper.getStatsVersion());
        this.mLinksText.setText(this.mExtensionBundleHelper.getLinks());
        this.mLinksText.setCaretPosition(0);
        String string2 = extensionBundleHelper.getActionId();
        SpssAction spssAction = ActionCatalog.getActionCatalog().getSpssAction(string2);
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame();
        if (spssAction != null) {
            vector = CommandExecutor.get().getMenuLabelHierarchy(spssFrame.getJMenuBar(), spssAction.getActionId());
            if (vector != null) {
                stringBuilder = new StringBuilder();
                for (String string3 : vector) {
                    if (string3.endsWith("...")) {
                        string3 = string3.substring(0, string3.lastIndexOf("..."));
                    }
                    if (stringBuilder.length() == 0) {
                        stringBuilder.append(string3);
                        continue;
                    }
                    stringBuilder.append(">").append(string3);
                }
                Object object = vector.get(vector.size() - 1);
                if (((String)object).endsWith("...")) {
                    object = ((String)object).substring(0, ((String)object).lastIndexOf("..."));
                }
                this.mNameText.setText((String)object);
                this.mMenuLocationText.setText(stringBuilder.toString());
            } else {
                ComponentState.trace((String)("getMenuLabelHierarchy returned null for action id " + spssAction.getActionId()));
            }
        } else if (string2 != null) {
            ComponentState.trace((String)("ActionCatalog returned null for action id (restart of client needed/pending?) " + extensionBundleHelper.getActionId()));
            this.mNameText.setText(this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_RESTART_REQ"));
            this.mMenuLocationText.setText(this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_RESTART_REQ"));
        } else {
            ComponentState.trace((String)"ActionCatalog returned null for action id and extension bundle ActionID null");
        }
        vector = this.mExtensionBundleHelper.getExtensionCommands();
        if (vector != null) {
            stringBuilder = new StringBuilder();
            for (String string3 : vector) {
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string3);
            }
            this.mExtensionCmdsText.setText(stringBuilder.toString());
        }
        try {
            if (this.mExtensionBundleHelper.hasReadMeFile()) {
                this.mViewReadmeBtn.setEnabled(true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.mExtensionBundleHelper.hasTermOfUseFile()) {
                this.mViewTermsOfUseBtn.setEnabled(true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mPythonReqText.setText(this.mExtensionBundleHelper.requiresPython() ? this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_YES") : this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_NO"));
        this.mPythonPackagesText.setText(this.mExtensionBundleHelper.getPythonPackages());
        this.mRReqText.setText(this.mExtensionBundleHelper.requiresR() ? this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_YES") : this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_NO"));
        this.mRPackagesText.setText(this.mExtensionBundleHelper.getRPackages());
    }

    public void showBundlesReadMeFile() {
        ViewBundleReadMeFileDialog viewBundleReadMeFileDialog = new ViewBundleReadMeFileDialog((JDialog)((Object)this));
        try {
            viewBundleReadMeFileDialog.setReadMeContents(this.mExtensionBundleHelper.getReadMeFileContents());
            viewBundleReadMeFileDialog.setVisible(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void showDWTermsOfUseDlg() {
        try {
            String string = this.mExtensionBundleHelper.getTermsOfUseFileContents();
            final TermsOfUseDlg termsOfUseDlg = new TermsOfUseDlg((JDialog)((Object)this), string);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    termsOfUseDlg.moveToMainConent();
                }
            });
            termsOfUseDlg.setVisible(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class ViewTermsOfUseAction
    extends AbstractAction {
        ViewTermsOfUseAction() {
            this.putValue("Name", ViewInstalledExtensionBundleDetailsDialog.this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_VIEW_TERMS_OF_USE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ViewInstalledExtensionBundleDetailsDialog.this.showDWTermsOfUseDlg();
        }
    }

    private class ViewReadMeAction
    extends AbstractAction {
        ViewReadMeAction() {
            this.putValue("Name", ViewInstalledExtensionBundleDetailsDialog.this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_VIEWREADME"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ViewInstalledExtensionBundleDetailsDialog.this.showBundlesReadMeFile();
        }
    }

    private class CloseAction
    extends AbstractAction {
        CloseAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CLOSE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProcedureDlgMgr.getMgr().saveDialogSize(ViewInstalledExtensionBundleDetailsDialog.this.getIActionKey(), ViewInstalledExtensionBundleDetailsDialog.this.getSize());
            ProcedureDlgMgr.getMgr().saveDialogLocation(ViewInstalledExtensionBundleDetailsDialog.this.getIActionKey(), ViewInstalledExtensionBundleDetailsDialog.this.getLocation());
            ViewInstalledExtensionBundleDetailsDialog.this.dispose();
        }
    }
}

