/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer;

import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer.ExtensionBundleHelper;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import java.util.zip.ZipException;

public class ExtensionBundlesManager {
    public static final String EXTENSION_BUNDLE_FILE_EXT_TEXT = ".spe";
    private static ExtensionBundlesManager sExtensionBundlesManager = null;
    private static Vector<String> mVisitedDirectories = new Vector();
    HashMap<String, ExtensionBundleHelper> mLoadedExtensionBundles = new HashMap();

    public static ExtensionBundlesManager getExtensionBundlesManager() {
        if (sExtensionBundlesManager == null) {
            sExtensionBundlesManager = new ExtensionBundlesManager();
            sExtensionBundlesManager.loadInstalledExtensions();
        } else {
            sExtensionBundlesManager.refreshInstalledExtensions();
        }
        return sExtensionBundlesManager;
    }

    private ExtensionBundlesManager() {
    }

    private void refreshInstalledExtensions() {
        mVisitedDirectories.clear();
        this.mLoadedExtensionBundles.clear();
        sExtensionBundlesManager.loadInstalledExtensions();
    }

    public void loadInstalledExtensions() {
        Vector vector = FileLocationsUtil.getExtensionsPathes();
        this.loadInstalledExtensions(vector.toArray(new String[vector.size()]));
    }

    public void loadInstalledExtensions(Vector<String> vector) {
        this.loadInstalledExtensions(vector.toArray(new String[vector.size()]));
    }

    public void loadInstalledExtensions(String[] stringArray) {
        for (String string : stringArray) {
            File file = new File(string);
            File[] fileArray = file.listFiles();
            if (fileArray == null) continue;
            for (File file2 : fileArray) {
                if (!file2.isDirectory() || mVisitedDirectories.contains(file2.getPath()) || !this.addExtensionBundle(file2)) continue;
                mVisitedDirectories.add(file2.getPath());
            }
        }
    }

    public boolean addExtensionBundle(File file) {
        boolean bl = false;
        File[] fileArray = file.listFiles(new SPE_FilenameFiler());
        if (fileArray != null && fileArray.length > 0) {
            try {
                ExtensionBundleHelper extensionBundleHelper = new ExtensionBundleHelper(fileArray[0]);
                this.mLoadedExtensionBundles.put(extensionBundleHelper.getName(), extensionBundleHelper);
                bl = true;
            }
            catch (ZipException zipException) {
                zipException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl;
    }

    public boolean addExtensionBundle(String string) {
        return this.addExtensionBundle(new File(string));
    }

    public HashMap<String, String> getNamesAndSummaries() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (ExtensionBundleHelper extensionBundleHelper : this.mLoadedExtensionBundles.values()) {
            hashMap.put(extensionBundleHelper.getName(), extensionBundleHelper.getSummary());
        }
        return hashMap;
    }

    public ExtensionBundleHelper getExtensionBundleHelper(String string) {
        return this.mLoadedExtensionBundles.get(string);
    }

    static class SPE_FilenameFiler
    implements FilenameFilter {
        SPE_FilenameFiler() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.endsWith(ExtensionBundlesManager.EXTENSION_BUNDLE_FILE_EXT_TEXT);
        }
    }
}

