/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_install_utility.ExtensionBundleManifestHelper;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.util.PASWFileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.prefs.Preferences;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExtensionBundleHelper {
    private File mExtensionZipFile;
    private String mName;
    private String mSummary;
    private String mDescription;
    private String mAuthor;
    private String mReleaseDate;
    private String mVersion;
    private String mStatsVersion;
    private String mTargetFilePath;
    private String mLinks;
    private String mCategories;
    private String mTranslationCataloguesPath;
    private Vector<String> mExtensionCommands;
    private boolean mRequiresPython;
    private String mPythonPackages;
    private boolean mRequiresR;
    private String mRPackages;
    private String mActionId = null;
    private String mCommandSpecs;
    private Set<String> mDialogSpecsSet;
    private Set<String> mCommandSpecsSet;
    private Set<String> mCodeFilesSet;
    private Set<String> mMiscFilesSet;
    private Set<String> mRLocationSet;
    private Set<String> mPythonModulesSet;
    private static final String XML_FILE_EXT = ".xml";
    private ExtensionBundleManifestHelper mManifestHelper;
    private static final String TERMS_OF_USE_ENTRY = "dWTermsOfUse/dWTermsOfUse.html";
    public static final String TERMS_OF_USE_FILE_NAME = "dWTermsOfUse.html";
    public static final String TERMS_OF_USE_FOLDER_NAME = "dWTermsOfUse";

    public ExtensionBundleHelper(File file) throws IOException {
        this.mExtensionZipFile = file;
        try {
            this.mManifestHelper = new ExtensionBundleManifestHelper(this.mExtensionZipFile);
            this.mName = this.mManifestHelper.getBundleName();
            this.mSummary = this.mManifestHelper.getSummary();
            this.mDescription = this.mManifestHelper.getDescription();
            this.mAuthor = this.mManifestHelper.getAuthor();
            this.mReleaseDate = this.mManifestHelper.getDate();
            this.mVersion = this.mManifestHelper.getVersion();
            this.mStatsVersion = this.mManifestHelper.getProductVersion();
            this.mTargetFilePath = this.mManifestHelper.getTargetFilePath();
            this.mLinks = this.mManifestHelper.getLinks();
            this.mCategories = this.mManifestHelper.getCategories();
            this.mRequiresPython = this.mManifestHelper.isPythonPluginInstalled();
            this.mRequiresR = this.mManifestHelper.isRPluginInstalled();
            this.mRequiresR = this.mManifestHelper.isRPluginInstalled();
            this.mTranslationCataloguesPath = this.mManifestHelper.getTranslationCataloguesPath();
            this.mPythonPackages = this.mManifestHelper.getAttributes().getValue("Python-Modules");
            this.mRPackages = this.mManifestHelper.getAttributes().getValue("R-Packages");
            this.mCommandSpecs = this.mManifestHelper.getAttributes().getValue("Command-Specs");
            this.mDialogSpecsSet = new HashSet<String>(this.mManifestHelper.getDialogSpecsSet());
            this.mCommandSpecsSet = new HashSet<String>(this.mManifestHelper.getCommandSpecsSet());
            this.mCodeFilesSet = new HashSet<String>(this.mManifestHelper.getCodeFilesSet());
            this.mMiscFilesSet = new HashSet<String>(this.mManifestHelper.getMiscFilesSet());
            this.mRLocationSet = new HashSet<String>(this.mManifestHelper.getRLocationSet());
            this.mPythonModulesSet = new HashSet<String>(this.mManifestHelper.getPythonModulesSet());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getName() {
        return this.mName;
    }

    public String getSummary() {
        return this.mSummary;
    }

    public String getEnglishSummary() {
        return this.mManifestHelper.getEnglishSummary();
    }

    public String getEnglishDescription() {
        return this.mManifestHelper.getEnglishDescription();
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getAuthor() {
        return this.mAuthor;
    }

    public String getReleaseDate() {
        return this.mReleaseDate;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public String getStatsVersion() {
        return this.mStatsVersion;
    }

    public File getTargetFile() {
        return new File(this.mTargetFilePath);
    }

    public String getTargetFilePath() {
        return this.mTargetFilePath;
    }

    public String getLinks() {
        return this.mLinks;
    }

    public String getCategories() {
        return this.mCategories;
    }

    public boolean requiresPython() {
        return this.mRequiresPython;
    }

    public String getPythonPackages() {
        return this.mPythonPackages;
    }

    public boolean requiresR() {
        return this.mRequiresR;
    }

    public String getRPackages() {
        return this.mRPackages;
    }

    public String getTranslationCataloguesPath() {
        return this.mTranslationCataloguesPath;
    }

    public Set<String> getDialogSpecsSet() {
        return this.mDialogSpecsSet;
    }

    public Set<String> getCommandSpecsSet() {
        return this.mCommandSpecsSet;
    }

    public Set<String> getCodeFilesSet() {
        return this.mCodeFilesSet;
    }

    public Set<String> getMiscFilesSet() {
        return this.mMiscFilesSet;
    }

    public Set<String> getRLocationSet() {
        return this.mRLocationSet;
    }

    public Set<String> getPythonModulesSet() {
        return this.mPythonModulesSet;
    }

    public boolean unzipTranslationCataloguesDirectory(File file) {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.getTargetFile());
            zipInputStream = new JarInputStream(fileInputStream);
            String string = this.mManifestHelper.getTranslationCataloguesPath();
            bl = ExtensionBundleHelper.unJarTranslationCataloguesToDirectory((JarInputStream)zipInputStream, file.getAbsolutePath(), string);
            zipInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            try {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            iOException.printStackTrace();
        }
        return bl;
    }

    public static boolean unJarTranslationCataloguesToDirectory(JarInputStream jarInputStream, String string, String string2) throws IOException {
        boolean bl = true;
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        boolean bl2 = false;
        while (jarEntry != null) {
            Object object;
            if (jarEntry.isDirectory()) {
                object = jarEntry.getName().substring(0, jarEntry.getName().length() - 1);
                object = ExtensionBundleHelper.getOSTypeSlashifiedPath((String)object);
                if (bl2) {
                    bl = ExtensionBundleHelper.makeDirectoryFromFullAndRelativePaths(string, (String)object);
                    if (!bl) {
                        break;
                    }
                } else if (!((String)object).equals("META-INF") && string2 != null && string2.equals(object)) {
                    bl2 = true;
                    bl = ExtensionBundleHelper.makeDirectoryFromFullAndRelativePaths(string, (String)object);
                    if (!bl) {
                        break;
                    }
                }
            } else if (bl2) {
                String string3 = ExtensionBundleHelper.getOSTypeSlashifiedPath(jarEntry.getName());
                if (string3.contains(TERMS_OF_USE_FILE_NAME)) {
                    object = string + File.separator + TERMS_OF_USE_FOLDER_NAME;
                    new File((String)object).mkdirs();
                }
                object = ExtensionBundleHelper.readEntry(jarInputStream);
                String string4 = string + File.separator + string3;
                FileOutputStream fileOutputStream = new FileOutputStream(string4);
                try {
                    fileOutputStream.write(((ByteBuffer)object).array());
                }
                catch (IOException iOException) {
                    fileOutputStream.close();
                    bl = false;
                    break;
                }
                fileOutputStream.close();
            }
            jarInputStream.closeEntry();
            jarEntry = jarInputStream.getNextJarEntry();
        }
        jarInputStream.close();
        return bl;
    }

    private static boolean makeDirectoryFromFullAndRelativePaths(String string, String string2) {
        String string3 = string + File.separator + string2;
        boolean bl = new File(string3).mkdir();
        if (bl) {
            // empty if block
        }
        return bl;
    }

    private static String getOSTypeSlashifiedPath(String string) {
        string = OSCheck.getOSType() == OSInfo.OSType.WIN ? string.replace('/', File.separatorChar) : string.replace('\\', File.separatorChar);
        return string;
    }

    public boolean writeFilesToDirectory(Set<String> set, File file) {
        Vector<String> vector = new Vector<String>();
        vector.add(file.getAbsolutePath());
        boolean bl = this.writeFilesToFirstWritableDirectory(set, vector);
        return bl;
    }

    public boolean writeFilesToFirstWritableDirectory(Set<String> set, Vector<String> vector) {
        boolean bl = true;
        boolean bl2 = false;
        for (String string : vector) {
            File file = new File(string);
            if (!file.exists() || !file.isDirectory() || !PASWFileUtil.isWritable((File)file)) continue;
            File file2 = this.getTargetFile();
            for (String string2 : set) {
                if (this.readAndWriteBundleFile(file2, file, string2) != null) continue;
                bl = false;
                break;
            }
            bl2 = true;
            break;
        }
        if (!bl2) {
            bl = false;
        }
        return bl;
    }

    private File readAndWriteBundleFile(File file, File file2, String string) {
        File file3 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            JarInputStream jarInputStream = new JarInputStream(fileInputStream);
            file3 = this.readAndWriteFromJar(jarInputStream, file2, string);
            jarInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return file3;
    }

    private File readAndWriteFromJar(JarInputStream jarInputStream, File file, String string) throws IOException {
        File file2 = null;
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            String string2 = jarEntry.getName();
            if (string2.equals(string)) {
                ByteBuffer byteBuffer = ExtensionBundleHelper.readEntry(jarInputStream);
                FileOutputStream fileOutputStream = new FileOutputStream(file.getPath() + File.separator + string2);
                fileOutputStream.write(byteBuffer.array());
                fileOutputStream.close();
                jarInputStream.closeEntry();
                file2 = new File(file.getPath() + File.separator + string2);
                break;
            }
            jarInputStream.closeEntry();
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return file2;
    }

    public static ByteBuffer readEntry(JarInputStream jarInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[50000];
        try {
            int n = jarInputStream.read(byArray, 0, 50000);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = jarInputStream.read(byArray, 0, 50000);
            }
        }
        catch (IOException iOException) {
            byteArrayOutputStream.reset();
            iOException.printStackTrace();
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    private String getXmlFilePath() {
        return new File(this.mExtensionZipFile.getParent()).getParentFile().getAbsolutePath();
    }

    public boolean hasReadMeFile() throws IOException {
        boolean bl = false;
        JarFile jarFile = new JarFile(this.mExtensionZipFile);
        String string = ComponentState.getILangLocale().getLanguage();
        ComponentState.trace((String)("ExtensionBundleHepler.hasReadMeFile() Language = " + string));
        JarEntry jarEntry = jarFile.getJarEntry("ReadMe_" + string + ".txt");
        if (jarEntry == null) {
            jarEntry = jarFile.getJarEntry("ReadMe.txt");
        }
        if (jarEntry != null) {
            bl = true;
        }
        jarFile.close();
        return bl;
    }

    public boolean hasTermOfUseFile() throws IOException {
        boolean bl = false;
        JarFile jarFile = new JarFile(this.mExtensionZipFile);
        String string = ComponentState.getILangLocale().getLanguage();
        ComponentState.trace((String)("ExtensionBundleHepler.hasReadMeFile() Language = " + string));
        JarEntry jarEntry = jarFile.getJarEntry(TERMS_OF_USE_ENTRY);
        if (jarEntry != null) {
            bl = true;
        }
        jarFile.close();
        return bl;
    }

    public String getReadMeFileContents() throws IOException {
        JarFile jarFile = new JarFile(this.mExtensionZipFile);
        StringBuilder stringBuilder = new StringBuilder();
        String string = ComponentState.getILangLocale().getLanguage();
        JarEntry jarEntry = jarFile.getJarEntry("ReadMe_" + string + ".txt");
        if (jarEntry == null) {
            jarEntry = jarFile.getJarEntry("ReadMe.txt");
        }
        if (jarEntry != null) {
            String string2;
            InputStreamReader inputStreamReader;
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            try {
                inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ComponentState.trace((String)"Could not open readme file using UTF-8");
                inputStreamReader = new InputStreamReader(inputStream);
            }
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append(System.getProperty("line.separator"));
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
        }
        jarFile.close();
        return stringBuilder.toString();
    }

    public String getTermsOfUseFileContents() throws IOException {
        JarFile jarFile = new JarFile(this.mExtensionZipFile);
        StringBuilder stringBuilder = new StringBuilder();
        String string = ComponentState.getILangLocale().getLanguage();
        JarEntry jarEntry = jarFile.getJarEntry(TERMS_OF_USE_ENTRY);
        if (jarEntry != null) {
            String string2;
            InputStreamReader inputStreamReader;
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            try {
                inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ComponentState.trace((String)"Could not open terms of use file using UTF-8");
                inputStreamReader = new InputStreamReader(inputStream);
            }
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append(System.getProperty("line.separator"));
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
        }
        jarFile.close();
        return stringBuilder.toString();
    }

    public String getActionId() {
        if (this.mActionId == null) {
            String string = this.getName().replace(' ', '_');
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(FileLocationsUtil.getCustomDialogsDirectory());
            stringBuilder.append(File.separator);
            stringBuilder.append(string);
            stringBuilder.append(File.separator);
            stringBuilder.append(string);
            stringBuilder.append(XML_FILE_EXT);
            File file = new File(stringBuilder.toString());
            if (file.exists()) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    this.mActionId = this.getActionIdFromXmlInputStream(fileInputStream);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    parserConfigurationException.printStackTrace();
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                }
            } else {
                try {
                    JarFile jarFile = new JarFile(this.mExtensionZipFile);
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        int n;
                        JarEntry jarEntry = enumeration.nextElement();
                        if (!jarEntry.getName().endsWith(".spd")) continue;
                        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
                        Preferences preferences2 = preferences.node("file_locations");
                        String string2 = preferences2.get("temp_dir", PrefDefaults.DEF_GENERAL_TEMP_DIR);
                        if (!string2.endsWith(File.separator)) {
                            string2 = string2 + File.separatorChar;
                        }
                        InputStream inputStream = jarFile.getInputStream(jarEntry);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                        FileOutputStream fileOutputStream = new FileOutputStream(new File(string2 + jarEntry.getName()));
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                        byte[] byArray = new byte[4096];
                        while ((n = bufferedInputStream.read(byArray)) != -1) {
                            bufferedOutputStream.write(byArray, 0, n);
                        }
                        bufferedInputStream.close();
                        bufferedOutputStream.close();
                        JarFile jarFile2 = new JarFile(string2 + jarEntry.getName());
                        Enumeration<JarEntry> enumeration2 = jarFile2.entries();
                        while (enumeration2.hasMoreElements()) {
                            JarEntry jarEntry2 = enumeration2.nextElement();
                            String string3 = jarEntry2.getName();
                            if (!XML_FILE_EXT.regionMatches(true, 0, string3, string3.length() - XML_FILE_EXT.length(), XML_FILE_EXT.length())) continue;
                            InputStream inputStream2 = jarFile2.getInputStream(jarEntry2);
                            this.mActionId = this.getActionIdFromXmlInputStream(inputStream2);
                            if (this.mActionId == null) continue;
                            break;
                        }
                        jarFile2.close();
                        new File(string2 + jarEntry.getName()).deleteOnExit();
                        new File(string2 + jarEntry.getName()).delete();
                    }
                    jarFile.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    parserConfigurationException.printStackTrace();
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                }
            }
        }
        return this.mActionId;
    }

    private String getActionIdFromXmlInputStream(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        String string = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("UserInterface");
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element;
                NodeList nodeList2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (nodeList2 = (element = (Element)node).getElementsByTagName("MenuItem")) == null) continue;
                Element element2 = (Element)nodeList2.item(0);
                string = element2.getAttribute("action");
                string = string.replace("_action", "");
                break;
            }
        }
        return string;
    }

    public Vector<String> getExtensionCommands() {
        if (this.mExtensionCommands == null && this.mCommandSpecs != null) {
            String[] stringArray;
            this.mExtensionCommands = new Vector();
            for (String string : stringArray = this.mCommandSpecs.split(",")) {
                String string2 = this.getXmlFilePath() + File.separator + string.replace(' ', '_');
                ComponentState.trace((String)("ExtensionBundleHelper::getExtensionCommands(): About to open " + string2));
                try {
                    FileInputStream fileInputStream = new FileInputStream(new File(string2));
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(fileInputStream);
                    document.getDocumentElement().normalize();
                    Element element = document.getDocumentElement();
                    String string3 = element.getAttribute("Name");
                    if (string3 != null) {
                        this.mExtensionCommands.add(string3);
                        continue;
                    }
                    ComponentState.trace((String)("ExtensionBundleHelper::getExtensionCommands(): Warning - no Name element " + string2));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    parserConfigurationException.printStackTrace();
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                }
            }
        }
        return this.mExtensionCommands;
    }
}

