/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer.DialogsToolTipJTable;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer.ExtensionBundlesManager;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.help.StatsHelp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class BaseInstalledExtensionBundlesDialog
extends BaseDialog {
    protected JPanel mMainPanel;
    protected JLabel mInfoText1;
    protected JTextArea mInfoText2;
    protected JLabel mInfoImage1;
    protected JTable mBundlesTable;
    protected JScrollPane mBundlesTableScrollPane;
    protected static InstalledBundleColumn[] fInstalledBundleColumns = null;

    public BaseInstalledExtensionBundlesDialog(SpssFrame spssFrame) {
        super((JFrame)spssFrame, false, ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), UtilitiesResBundle.getImageFolder());
        this.setDefaultCloseOperation(2);
        this.setTitle(this.getDialogTitle());
        this.pack();
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize(this.getIActionKey());
        if (dimension != null) {
            this.setSize(dimension);
        }
        this.setLocationRelativeTo(spssFrame);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    public abstract String getDialogHelpID();

    public abstract String getIActionKey();

    public abstract String getDialogTitle();

    public void dispose() {
        super.dispose();
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        JButton jButton = new JButton(new CloseAction());
        JButton jButton2 = new JButton((Action)this.createHelpAction());
        if (UIToolDialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                DialogUtil.setupMacHelpButton(jButton2);
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    protected void init() {
        super.init();
        this.initVariables();
        JPanel jPanel = this.getViewPanel();
        this.setupMainPanel(jPanel);
        this.pack();
        this.setTabPolicy();
        this.loadInstalledExtensionBundles();
    }

    private void setTabPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mBundlesTable);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    public void refresh() {
        InstalledBundlesTableModel installedBundlesTableModel = (InstalledBundlesTableModel)this.mBundlesTable.getModel();
        ArrayList<String[]> arrayList = installedBundlesTableModel.getData();
        arrayList.clear();
        this.loadInstalledExtensionBundles();
        this.repaint();
    }

    private void loadInstalledExtensionBundles() {
        InstalledBundlesTableModel installedBundlesTableModel = (InstalledBundlesTableModel)this.mBundlesTable.getModel();
        ExtensionBundlesManager extensionBundlesManager = ExtensionBundlesManager.getExtensionBundlesManager();
        HashMap<String, String> hashMap = extensionBundlesManager.getNamesAndSummaries();
        Set<String> set = hashMap.keySet();
        for (String string : set) {
            installedBundlesTableModel.addDataItem(string, hashMap.get(string));
        }
        Collections.sort(installedBundlesTableModel.getData(), new StringColumnTableSorter(0, InstalledBundleColumn.SortOrder.ASCENDING));
        ((DialogsToolTipJTable)this.mBundlesTable).fitColumnToWidestEntry(0, 2);
        if (installedBundlesTableModel.getRowCount() > 0) {
            this.mBundlesTable.changeSelection(0, 0, false, false);
        }
    }

    private void initVariables() {
        fInstalledBundleColumns = new InstalledBundleColumn[]{new InstalledBundleColumn(0, true), new InstalledBundleColumn(1, true)};
        this.mInfoText1 = new JLabel(this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOG1_INFO_TEXT1"));
        final LinkTextRenderer linkTextRenderer = new LinkTextRenderer();
        this.mBundlesTable = new DialogsToolTipJTable(new InstalledBundlesTableModel()){

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                if (n2 == 1) {
                    return linkTextRenderer;
                }
                return super.getCellRenderer(n, n2);
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        Dimension dimension = new Dimension(500, 180);
        this.mBundlesTable.setMinimumSize(dimension);
        this.mBundlesTable.setAutoResizeMode(0);
        this.mBundlesTable.setSelectionMode(0);
        this.mBundlesTable.getTableHeader().setReorderingAllowed(false);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mBundlesTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mBundlesTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mBundlesTable.getActionMap().put("tabIn", abstractAction2);
        this.mBundlesTable.getActionMap().put("tabOut", abstractAction);
        this.mBundlesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1 && BaseInstalledExtensionBundlesDialog.this.mBundlesTable.getSelectedColumn() == 1) {
                    String string = (String)BaseInstalledExtensionBundlesDialog.this.mBundlesTable.getValueAt(BaseInstalledExtensionBundlesDialog.this.mBundlesTable.getSelectedRow(), 0);
                    BaseInstalledExtensionBundlesDialog.this.showExtensionBundleDialog(string);
                }
            }
        });
        JTableHeader jTableHeader = this.mBundlesTable.getTableHeader();
        jTableHeader.setDefaultRenderer(new InstalledBundlesTableHeaderRenderer());
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    return;
                }
                int n = BaseInstalledExtensionBundlesDialog.this.mBundlesTable.getTableHeader().columnAtPoint(mouseEvent.getPoint());
                if (n != -1 && fInstalledBundleColumns[n].isSortable()) {
                    this.sortColumn(n, (InstalledBundlesTableModel)BaseInstalledExtensionBundlesDialog.this.mBundlesTable.getModel());
                }
            }

            void sortColumn(int n, InstalledBundlesTableModel installedBundlesTableModel) {
                ArrayList<String[]> arrayList = installedBundlesTableModel.getData();
                switch (fInstalledBundleColumns[n].getSortSequence()) {
                    case ASCENDING: {
                        Collections.sort(arrayList, new StringColumnTableSorter(n, InstalledBundleColumn.SortOrder.DESCENDING));
                        fInstalledBundleColumns[n].setSortSequence(InstalledBundleColumn.SortOrder.DESCENDING);
                        break;
                    }
                    case DESCENDING: {
                        Collections.sort(arrayList, new StringColumnTableSorter(n, InstalledBundleColumn.SortOrder.ASCENDING));
                        fInstalledBundleColumns[n].setSortSequence(InstalledBundleColumn.SortOrder.ASCENDING);
                    }
                }
                ((InstalledBundlesTableHeaderRenderer)BaseInstalledExtensionBundlesDialog.this.mBundlesTable.getTableHeader().getDefaultRenderer()).setSortedColumn(n);
                installedBundlesTableModel.fireTableDataChanged();
                BaseInstalledExtensionBundlesDialog.this.mBundlesTable.getTableHeader().repaint();
            }
        });
        this.mBundlesTableScrollPane = new JScrollPane(this.mBundlesTable);
        this.mBundlesTableScrollPane.setPreferredSize(this.mBundlesTable.getMinimumSize());
        this.mBundlesTableScrollPane.setHorizontalScrollBarPolicy(30);
        this.mBundlesTableScrollPane.setVerticalScrollBarPolicy(20);
        this.mBundlesTableScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Component component = componentEvent.getComponent();
                int n = component.getWidth();
                TableColumn tableColumn = BaseInstalledExtensionBundlesDialog.this.mBundlesTable.getColumnModel().getColumn(BaseInstalledExtensionBundlesDialog.this.mBundlesTable.getModel().getColumnCount() - 1);
                int n2 = BaseInstalledExtensionBundlesDialog.this.mBundlesTable.getWidth() - tableColumn.getWidth();
                int n3 = n - n2;
                if (n3 > 0) {
                    tableColumn.setPreferredWidth(n3 - 5);
                }
            }
        });
        this.mBundlesTable.setSize(dimension);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        this.mInfoImage1 = new JLabel();
        this.mInfoImage1.setIcon(new ImageIcon(uRL));
        this.mInfoText2 = new JTextArea(this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOG1_INFO_TEXT2"));
        this.mInfoText2.setEditable(false);
        this.mInfoText2.setOpaque(false);
        this.mInfoText2.setFocusable(false);
        this.mInfoText2.setWrapStyleWord(true);
        this.mInfoText2.setLineWrap(true);
    }

    private void setupMainPanel(JPanel jPanel) {
        this.mMainPanel = new JPanel();
        this.mMainPanel.setFocusable(true);
        this.mMainPanel.setLayout(new GridBagLayout());
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.bottom += 5;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mMainPanel, this.mInfoText1, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 18;
        DialogUtil.addUsingGBL(this.mMainPanel, this.mBundlesTableScrollPane, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mMainPanel, this.mInfoImage1, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mMainPanel, this.mInfoText2, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets2 = new Insets(0, 0, 0, 0);
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mMainPanel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
    }

    protected abstract void showExtensionBundleDialog(String var1);

    public static class InstalledBundleColumn {
        public static final int COLUMN_NAME = 0;
        public static final int COLUMN_DESC = 1;
        private int fColumnNumber = -1;
        private boolean fSortable = false;
        private SortOrder fSortSequence = SortOrder.ASCENDING;

        public InstalledBundleColumn(int n, boolean bl) {
            this.fColumnNumber = n;
            this.fSortable = bl;
        }

        public int getColumnNumber() {
            return this.fColumnNumber;
        }

        public boolean isSortable() {
            return this.fSortable;
        }

        public SortOrder getSortSequence() {
            return this.fSortSequence;
        }

        public void setSortSequence(SortOrder sortOrder) {
            this.fSortSequence = sortOrder;
        }

        public static enum SortOrder {
            ASCENDING,
            DESCENDING;

        }
    }

    private class InstalledBundlesTableHeaderRenderer
    implements TableCellRenderer {
        private JPanel mRenderer = new JPanel(new BorderLayout(0, 0));
        private JLabel mTextRenderer = new JLabel();
        private int fSortedColumnNumber = -1;

        public InstalledBundlesTableHeaderRenderer() {
            this.mRenderer.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.mTextRenderer.setHorizontalTextPosition(10);
            this.mTextRenderer.setHorizontalAlignment(0);
            this.mRenderer.add((Component)this.mTextRenderer, "Center");
        }

        public void setSortedColumn(int n) {
            this.fSortedColumnNumber = n;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable != null) {
                if (this.fSortedColumnNumber == n2) {
                    if (fInstalledBundleColumns[n2].getSortSequence() == InstalledBundleColumn.SortOrder.ASCENDING) {
                        this.mTextRenderer.setIcon(new ImageIcon(ResUtil.getImageResource("sortasc.gif")));
                    } else if (fInstalledBundleColumns[n2].getSortSequence() == InstalledBundleColumn.SortOrder.DESCENDING) {
                        this.mTextRenderer.setIcon(new ImageIcon(ResUtil.getImageResource("sortdesc.gif")));
                    } else {
                        this.mTextRenderer.setIcon(null);
                    }
                } else {
                    this.mTextRenderer.setIcon(null);
                }
            }
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                this.mTextRenderer.setText(ComponentState.prepareStringForBidiRendering((String)object.toString()));
            } else {
                this.mTextRenderer.setText(object.toString());
            }
            return this.mRenderer;
        }
    }

    class InstalledBundlesTableModel
    extends AbstractTableModel {
        private String[] mColNames;
        private ArrayList<String[]> mTableData;

        InstalledBundlesTableModel() {
            this.mColNames = new String[]{BaseInstalledExtensionBundlesDialog.this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_NAME"), BaseInstalledExtensionBundlesDialog.this.getResString("IDS_VIEW_INSTALLED_EXTENSION_BUNDLES_DIALOGS_SUMMARY")};
            this.mTableData = new ArrayList();
        }

        @Override
        public int getColumnCount() {
            return this.mColNames.length;
        }

        public void addDataItem(String string, String string2) {
            this.mTableData.add(new String[]{string, string2});
        }

        @Override
        public String getColumnName(int n) {
            return this.mColNames[n];
        }

        @Override
        public int getRowCount() {
            return this.mTableData.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.mTableData.get(n)[n2];
        }

        public ArrayList<String[]> getData() {
            return this.mTableData;
        }
    }

    public class StringColumnTableSorter
    implements Comparator {
        InstalledBundleColumn.SortOrder fSortOrder;
        int colNumber = -1;

        StringColumnTableSorter(int n, InstalledBundleColumn.SortOrder sortOrder) {
            this.fSortOrder = sortOrder;
            this.colNumber = n;
        }

        public int compare(Object object, Object object2) {
            String[] stringArray = (String[])object;
            String[] stringArray2 = (String[])object2;
            String string = stringArray[this.colNumber];
            String string2 = stringArray2[this.colNumber];
            if (string instanceof String && string.length() == 0) {
                string = null;
            }
            if (string2 instanceof String && string2.length() == 0) {
                string2 = null;
            }
            if (string == null && string2 == null) {
                return 0;
            }
            if (string == null) {
                return 1;
            }
            if (string2 == null) {
                return -1;
            }
            if (this.fSortOrder == InstalledBundleColumn.SortOrder.ASCENDING) {
                return string.toString().compareToIgnoreCase(string2.toString());
            }
            return string2.toString().compareToIgnoreCase(string.toString());
        }
    }

    static class LinkTextRenderer
    extends DefaultTableCellRenderer {
        @Override
        public void setValue(Object object) {
            this.setForeground(Color.BLUE);
            super.setValue("<HTML><U>" + object + "...</U></HTML>");
        }
    }

    private class CloseAction
    extends AbstractAction {
        CloseAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CLOSE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProcedureDlgMgr.getMgr().saveDialogSize(BaseInstalledExtensionBundlesDialog.this.getIActionKey(), BaseInstalledExtensionBundlesDialog.this.getSize());
            BaseInstalledExtensionBundlesDialog.this.dispose();
        }
    }
}

