/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.bundle_install_utility;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.core.documents.output.header.HeaderItem;
import com.spss.java_client.core.documents.output.text.LogItem;
import com.spss.java_client.core.documents.output.text.TextItem;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_install_utility.ExtensionBundleManifestHelper;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_install_utility.ExtensionBundleMessageDlg;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer.ExtensionBundleHelper;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.actions.InstallDlgAction;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.utilities.StatsCDBAppInfo;
import com.spss.shared.core_tools.file.SpssFile;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.ConsumeStream;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.app.CDBAppInfo;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.ui_builder.SpecificationBuilder;
import com.spss.uitools.ui_builder.definition.AddOnType;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.util.IniHandler;
import com.spss.uitools.util.PASWFileUtil;
import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class InstallExtensionBundle {
    static final String EXTENSION_BUNDLE_BAD_VERSION_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_BAD_VERSION_MSG";
    static final String EXTENSION_BUNDLE_BAD_VERSION_MSG_2 = "IDS_INSTALL_EXTENSION_BUNDLE_BAD_VERSION_MSG_2";
    static final String EXTENSION_BUNDLE_BAD_VERSION_MSG_3 = "IDS_INSTALL_EXTENSION_BUNDLE_BAD_VERSION_MSG_3";
    static final String EXTENSION_BUNDLE_R_PLUGIN_MISSING_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_R_PLUGIN_MISSING_MSG";
    static final String EXTENSION_BUNDLE_BUNDLE_ALREADY_INSTALLED_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_BUNDLE_ALREADY_INSTALLED_MSG";
    static final String EXTENSION_BUNDLE_SUCCESS_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_SUCCESS_MSG";
    static final String EXTENSION_BUNDLE_OUT_OF_DISK_SPACE_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_OUT_OF_DISK_SPACE_MSG";
    static final String EXTENSION_BUNDLE_MSG1_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG1_TEXT";
    static final String EXTENSION_BUNDLE_MSG2_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG2_TEXT";
    static final String EXTENSION_BUNDLE_MSG3_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG3_TEXT";
    static final String EXTENSION_BUNDLE_MSG4_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG4_TEXT";
    static final String EXTENSION_BUNDLE_MSG5_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG5_TEXT";
    static final String EXTENSION_BUNDLE_MSG6_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG6_TEXT";
    static final String EXTENSION_BUNDLE_MSG7_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG7_TEXT";
    static final String EXTENSION_BUNDLE_TITLE1_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_TITLE1_TEXT";
    static final String EXTENSION_BUNDLE_TITLE2_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_TITLE2_TEXT";
    static final String EXTENSION_BUNDLE_R_PROGRAMMABILITY = "IDS_INSTALL_EXTENSION_BUNDLE_R_PROGRAMMABILITY";
    static final String EXTENSION_BUNDLE_PYTHON_PROGRAMMABILITY = "IDS_INSTALL_EXTENSION_BUNDLE_PYTHON_PROGRAMMABILITY";
    static final String EXTENSION_BUNDLE_SUCCESSFULL_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_SUCCESSFULL_MSG";
    static final String EXTENSION_BUNDLE_SUCCESSFULL1_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_SUCCESSFULL1_MSG";
    static final String EXTENSION_BUNDLE_VERSION_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_VERSION_MSG";
    static final String EXTENSION_BUNDLE_VERSION_MSG_2 = "IDS_CMDLINE_EXTENSION_BUNDLE_VERSION_MSG_2";
    static final String EXTENSION_BUNDLE_VERSION_MSG_3 = "IDS_CMDLINE_EXTENSION_BUNDLE_VERSION_MSG_3";
    static final String EXTENSION_BUNDLE_R_PLUGIN_REQUIRED_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_R_PLUGIN_REQUIRED_MSG";
    static final String EXTENSION_BUNDLE_NO_PERMISSIONS_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_NO_PERMISSIONS_MSG";
    static final String EXTENSION_BUNDLE_EARLIER_VERSION_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_EARLIER_VERSION_MSG";
    static final String EXTENSION_BUNDLE_ERR_READING_PACKAGE_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_ERR_READING_PACKAGE_MSG";
    static final String EXTENSION_BUNDLE_ERR_OUT_OF_DISK_SPACE_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_OUT_OF_DISK_SPACE_MSG";
    static final String EXTENSION_BUNDLE_NOT_FOUND1_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_NOT_FOUND1_MSG";
    static final String EXTENSION_BUNDLE_NOT_FOUND2_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_NOT_FOUND2_MSG";
    static final String EXTENSION_BUNDLE_NOT_FOUND3_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_NOT_FOUND3_MSG";
    static final String EXTENSION_BUNDLE_NOT_FOUND4_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_NOT_FOUND4_MSG";
    JFrame mFrame;
    private File mSpeFile;
    private File mSpeRepositoryFile;
    private PesFile mRepositoryFile;
    private File mRPath;
    private File mPythonPath;
    private File mNameDirectory;
    private String mBundleName;
    private boolean bRInstalled = false;
    private boolean bPythonInstalled = false;
    private boolean bInstallCustomDialogs = true;
    private boolean bDownloadRPackages = true;
    private ExtensionBundleManifestHelper mManifestHelper;
    private Set<String> mCommandFilesPath;
    private boolean bCommandFiles = false;
    private boolean bUseExVerPath = false;
    static final String DW_TERMS_OF_USE_FOLDER = "dWTermsOfUse";
    static final String DW_TERMS_OF_USE_FILE = "dWTermsOfUse.html";
    static final String DW_TERMS_OF_USE_ENTRY = "dWTermsOfUse/dWTermsOfUse.html";
    static final String TEMPLATE_SUFFIX = ".viztemplate";
    static final String PYTHON_JAR_FILE_NAME = "pythoncfg.jar";
    private static final String m_externalRPref = "/com/ibm/SPSS/externalr/";
    private String mInstalledDlgMenuString;
    private StatsCDBAppInfo mAppInfo;
    private boolean mBothHaveSpdAndCfe;

    public InstallExtensionBundle(JFrame jFrame) {
        this(jFrame, true, true);
    }

    public InstallExtensionBundle(JFrame jFrame, boolean bl, boolean bl2) {
        this.init();
        this.mFrame = jFrame;
        this.bInstallCustomDialogs = bl;
        this.bDownloadRPackages = bl2;
    }

    private void init() {
        this.mSpeFile = null;
        this.mSpeRepositoryFile = null;
        this.mRepositoryFile = null;
        this.mRPath = null;
        this.mPythonPath = null;
        this.mNameDirectory = null;
        this.mBundleName = null;
        this.bRInstalled = false;
        this.bPythonInstalled = false;
        this.mCommandFilesPath = new HashSet<String>();
        this.bCommandFiles = false;
        this.mAppInfo = new StatsCDBAppInfo(false);
        BuilderUtil.getInstance().setAppInfo((CDBAppInfo)this.mAppInfo);
        this.mBothHaveSpdAndCfe = false;
    }

    private boolean unInstallExist() {
        Vector vector = FileLocationsUtil.getExtensionsPathes((boolean)this.bUseExVerPath);
        for (String string : vector) {
            string = string.endsWith(File.separator) ? string + this.mBundleName : string + File.separator + this.mBundleName;
            File file = new File(string);
            if (!file.exists() || !file.isDirectory()) continue;
            ExtensionBundleManifestHelper extensionBundleManifestHelper = null;
            for (File file2 : file.listFiles()) {
                if (!file2.getName().endsWith(".spe") || !file2.getName().contains(this.mBundleName)) continue;
                try {
                    extensionBundleManifestHelper = new ExtensionBundleManifestHelper(file2);
                    break;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (this.mFrame == null && extensionBundleManifestHelper != null && !this.checkForInstalledExtensionVersion(extensionBundleManifestHelper.getVersion())) {
                System.out.println(MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_EARLIER_VERSION_MSG), this.mBundleName, extensionBundleManifestHelper.getVersion(), this.mManifestHelper.getVersion()));
                return false;
            }
            int n = 0;
            if (this.mFrame != null) {
                Object[] objectArray = new Object[]{ResUtil.getCommonDlgString("IDS_YES"), ResUtil.getCommonDlgString("IDS_NO")};
                n = JOptionPane.showOptionDialog(this.mFrame, CoreResUtil.getString((String)EXTENSION_BUNDLE_BUNDLE_ALREADY_INSTALLED_MSG), VersionInfo.getAppVersionString(), 0, 3, null, objectArray, objectArray[0]);
            }
            if (n == 0) {
                BuilderUtil.getInstance().removeDeployedBundle(new File(string + File.separator + this.mBundleName + ".spe"));
                return true;
            }
            return false;
        }
        return true;
    }

    public void doInstall(File file) {
        this.init();
        if (this.setupSpeFileAndCheckForPES(file)) {
            boolean bl = this.processSpeFile();
            if (this.mRepositoryFile != null) {
                this.mSpeFile = this.mSpeRepositoryFile;
                PES_Repository.removeFromPesCache((File)file);
            }
            if (this.mFrame != null && bl) {
                for (String string : this.mCommandFilesPath) {
                    SyntaxMgr.getSyntaxMgr().executeSyntax("EXTENSION /SPECIFICATION COMMAND='" + string + "'.");
                }
            }
        }
    }

    private boolean setupSpeFileAndCheckForPES(File file) {
        this.mSpeRepositoryFile = file;
        this.mRepositoryFile = PES_Repository.getPesFile((String)file.getAbsolutePath());
        if (this.mRepositoryFile != null) {
            String string = PES_Repository.RetrieveFromPES((PesFile)this.mRepositoryFile);
            file = this.mRepositoryFile.getCacheFile();
            if (file == null) {
                if (string != null && string.length() > 0) {
                    if (this.mFrame != null) {
                        SpssAlertOptionPane.showWarningMessageDialog(this.mFrame, string, VersionInfo.getAppVersionString());
                    } else {
                        System.out.println(string);
                    }
                }
                return false;
            }
        }
        this.mSpeFile = file;
        return true;
    }

    private boolean processSpeFile() {
        this.mInstalledDlgMenuString = "";
        if (this.readManifest() && this.checkForCorrectVersion() && this.checkForRPackages() && this.checkIfPlugInsAreRequired() && this.unInstallExist() && this.createNameDirectoryUnderExtensionsDirectory() && this.writeCodeFilesToDirectory() && this.writeCommandFilesToDirectories() && this.writeSpeFileToNameDirectory() && this.writerDWLicenseFileToNameDirectory() && this.writeMiscFilesToDirectory()) {
            if (this.unzipSpdFileToDirectory()) {
                if (this.unzipTranslationCataloguesDirectory() && this.downloadRPackagesIfNeededFromInternet() && this.installVizTemplate()) {
                    Object object;
                    String string = CoreResUtil.getString((String)EXTENSION_BUNDLE_SUCCESSFULL_MSG);
                    string = MessageFormat.format(string, this.mBundleName);
                    if (this.mFrame == null) {
                        System.out.println(string);
                    }
                    if (this.mInstalledDlgMenuString.length() > 0) {
                        if (this.mInstalledDlgMenuString.contains(".")) {
                            object = "";
                            String[] stringArray = this.mInstalledDlgMenuString.split("\\.|>");
                            for (int i = 0; i < stringArray.length; ++i) {
                                String string2 = ResUtil.getString(stringArray[i]);
                                object = string2 != null ? (String)object + string2 : (String)object + stringArray[i];
                                if (i >= stringArray.length - 1) continue;
                                object = (String)object + ">";
                            }
                            this.mInstalledDlgMenuString = object;
                        }
                        object = String.format(BuilderResUtil.getString((String)"IDS_DIALOG_INSTALLED"), this.mInstalledDlgMenuString);
                        string = string + "\n";
                        string = string + (String)object;
                    }
                    if (this.mFrame != null) {
                        JOptionPane.showConfirmDialog(this.mFrame, string, VersionInfo.getAppVersionString(), -1, 1);
                        if (this.mBothHaveSpdAndCfe) {
                            object = ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
                            this.addMessageToOutputViewer(((ResourceBundle)object).getString("IDS_EXTENSION_BUNDLE_OUTPUT_ITEM_DESCRIPITION"), BuilderResUtil.getString((String)"IDS_INSTALL_EXTENSION_BUNDLE_SPD_NOT_INSTALLED_MSG"));
                        }
                    }
                    return true;
                }
            } else {
                BuilderUtil.getInstance().deleteFolder(this.mNameDirectory);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writerDWLicenseFileToNameDirectory() {
        boolean bl = true;
        ZipInputStream zipInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(this.mSpeFile));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String string = zipEntry.getName();
                if (string.equals(DW_TERMS_OF_USE_ENTRY)) {
                    int n;
                    String string2 = this.mNameDirectory.getCanonicalPath() + File.separator + DW_TERMS_OF_USE_FOLDER;
                    File file = new File(string2);
                    boolean bl2 = file.mkdirs();
                    if (!bl2) {
                        boolean bl3 = bl = false;
                        return bl3;
                    }
                    String string3 = string2 + File.separator + DW_TERMS_OF_USE_FILE;
                    fileOutputStream = new FileOutputStream(string3);
                    byte[] byArray = new byte[1024];
                    while ((n = zipInputStream.read(byArray)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception exception) {
            boolean bl4 = bl = false;
            return bl4;
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    private boolean checkForInstalledExtensionVersion(String string) {
        int[] nArray = new int[]{0, 0, 0};
        StringTokenizer stringTokenizer = new StringTokenizer(this.mManifestHelper.getVersion(), ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        int[] nArray2 = new int[]{0, 0, 0};
        stringTokenizer = new StringTokenizer(string, ".");
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray2[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        for (n = 0; n < 3; ++n) {
            if (nArray[n] == nArray2[n]) continue;
            return nArray[n] > nArray2[n];
        }
        return true;
    }

    private boolean checkForCorrectVersion() {
        Object object;
        int[] nArray = new int[]{0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        StringTokenizer stringTokenizer = new StringTokenizer(VersionInfo.getVersionString(), ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(this.mManifestHelper.getProductVersion(), ".");
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray2[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        boolean bl = this.checkMajorMinorPatchVersionsWithMinor(nArray, nArray2);
        if (bl) {
            object = new int[]{0, 0, 0, 0};
            stringTokenizer = new StringTokenizer(this.mManifestHelper.getMaxStatsVersion(), ".");
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                object[n++] = Integer.parseInt(stringTokenizer.nextToken());
            }
            bl = this.checkMajorMinorPatchVersionsWithMax(nArray, (int[])object);
        }
        if (!bl) {
            if (this.mFrame != null) {
                object = "";
                object = this.mManifestHelper.getMaxStatsVersion() == null || this.mManifestHelper.getMaxStatsVersion() == "" ? MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_BAD_VERSION_MSG), this.mManifestHelper.getProductVersion()) : (!this.mManifestHelper.getMaxStatsVersion().equals(this.mManifestHelper.getProductVersion()) ? MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_BAD_VERSION_MSG_2), this.mManifestHelper.getProductVersion(), this.mManifestHelper.getMaxStatsVersion()) : MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_BAD_VERSION_MSG_3), this.mManifestHelper.getProductVersion()));
                JOptionPane.showConfirmDialog(this.mFrame, object, VersionInfo.getAppVersionString(), -1, 1);
            } else if (this.mManifestHelper.getMaxStatsVersion() == null || this.mManifestHelper.getMaxStatsVersion() == "") {
                System.out.println(MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_VERSION_MSG), this.mBundleName, this.mManifestHelper.getProductVersion()));
            } else if (!this.mManifestHelper.getMaxStatsVersion().equals(this.mManifestHelper.getProductVersion())) {
                System.out.println(MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_VERSION_MSG_2), this.mBundleName, this.mManifestHelper.getProductVersion(), this.mManifestHelper.getMaxStatsVersion()));
            } else {
                System.out.println(MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_VERSION_MSG_3), this.mBundleName, this.mManifestHelper.getProductVersion()));
            }
        }
        if (bl) {
            object = this.mManifestHelper.getPythonVersion();
            this.bUseExVerPath = object != null && ((String)object).compareTo("3") == 0;
        }
        return bl;
    }

    private boolean checkMajorMinorPatchVersionsWithMinor(int[] nArray, int[] nArray2) {
        boolean bl = true;
        if (nArray[0] < nArray2[0]) {
            bl = false;
        } else if (nArray[0] == nArray2[0]) {
            if (nArray[1] < nArray2[1]) {
                bl = false;
            } else if (nArray[1] == nArray2[1]) {
                if (nArray[2] < nArray2[2]) {
                    bl = false;
                } else if (nArray[2] == nArray2[2] && nArray[3] < nArray2[3]) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean checkMajorMinorPatchVersionsWithMax(int[] nArray, int[] nArray2) {
        boolean bl = true;
        if (nArray[0] > nArray2[0]) {
            bl = false;
        } else if (nArray[0] == nArray2[0]) {
            if (nArray[1] > nArray2[1]) {
                bl = false;
            } else if (nArray[1] == nArray2[1]) {
                if (nArray[2] > nArray2[2]) {
                    bl = false;
                } else if (nArray[2] == nArray2[2] && nArray[3] > nArray2[3]) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean checkForRPackages() {
        boolean bl = true;
        if (this.mManifestHelper.getRLocationSet().size() > 0) {
            this.setRInstallerPath();
            if (!this.bRInstalled) {
                if (this.mFrame != null) {
                    ExtensionBundleMessageDlg extensionBundleMessageDlg = new ExtensionBundleMessageDlg(this.mFrame, VersionInfo.getAppVersionString(), CoreResUtil.getString((String)EXTENSION_BUNDLE_R_PLUGIN_MISSING_MSG), "", null, true, "idh_r_plugin_missing");
                    extensionBundleMessageDlg.setVisible(true);
                } else {
                    System.out.println(MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_R_PLUGIN_REQUIRED_MSG), this.mBundleName));
                }
                bl = false;
            }
        }
        return bl;
    }

    private void setRInstallerPath() {
        String string;
        Object object;
        this.mRPath = null;
        String string2 = "";
        IniHandler iniHandler = InstallExtensionBundle.getSpssReaderFromSpssHomeDir("spssdxcfg.ini");
        string2 = InstallExtensionBundle.getProfileValue(iniHandler, AddOnType.R.toString(), "HOME");
        if (string2.isEmpty()) {
            object = VersionInfo.getMajorMinorVersionString();
            string = m_externalRPref + (String)object;
            try {
                if (Preferences.userRoot().nodeExists(string)) {
                    Preferences preferences = Preferences.userRoot().node(string);
                    string2 = preferences.get("r_path", string2);
                }
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
            }
        }
        if (string2.equals("")) {
            return;
        }
        object = new File(string2);
        try {
            string2 = ((File)object).getCanonicalPath();
            if (!string2.equals("")) {
                if (!string2.endsWith(File.separator + "bin" + File.separator) && !string2.endsWith(File.separator + "bin")) {
                    string2 = string2.endsWith(File.separator) ? string2 + "bin" + File.separator : string2 + File.separator + "bin" + File.separator;
                }
                if (!string2.endsWith(File.separator)) {
                    string2 = string2 + File.separator;
                }
                string = string2 + "R";
                if (OSCheck.getOSType() == OSInfo.OSType.WIN) {
                    string = string + ".exe";
                }
                this.mRPath = new File(string);
                if (this.mRPath.exists()) {
                    this.bRInstalled = true;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setPythonInstallerPath() {
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("application.home"));
        String string = stringBuffer.append(File.separator) + PYTHON_JAR_FILE_NAME;
        this.mPythonPath = new File(string);
        if (this.mPythonPath.exists()) {
            this.bPythonInstalled = true;
        }
    }

    public static IniHandler getSpssReaderFromSpssHomeDir(String string) {
        IniHandler iniHandler = null;
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("application.home"));
        stringBuffer.append(File.separatorChar).append(string);
        File file = new File(stringBuffer.toString());
        if (file.exists()) {
            iniHandler = IniHandler.loadIniFile((String)stringBuffer.toString(), (boolean)true, (String)"UTF-8");
        }
        return iniHandler;
    }

    public static String getProfileValue(IniHandler iniHandler, String string, String string2) {
        LinkedList linkedList;
        String string3 = "";
        if (iniHandler != null && (linkedList = iniHandler.getPrivateProfileString(string, string2)) != null && !linkedList.isEmpty()) {
            string3 = (String)linkedList.getFirst();
        }
        return string3;
    }

    private boolean checkIfPlugInsAreRequired() {
        boolean bl = true;
        if (this.mManifestHelper.isRPluginInstalled() || this.mManifestHelper.isPythonPluginInstalled()) {
            if (this.mManifestHelper.isRPluginInstalled() && !this.bRInstalled) {
                this.setRInstallerPath();
            }
            if (this.mManifestHelper.isPythonPluginInstalled()) {
                this.setPythonInstallerPath();
            }
            if ((this.mManifestHelper.isRPluginInstalled() && !this.bRInstalled || this.mManifestHelper.isPythonPluginInstalled() && !this.bPythonInstalled) && this.mFrame != null) {
                Vector<String> vector = new Vector<String>();
                if (this.mManifestHelper.isRPluginInstalled() && !this.bRInstalled) {
                    vector.add(CoreResUtil.getString((String)EXTENSION_BUNDLE_R_PROGRAMMABILITY));
                }
                if (this.mManifestHelper.isPythonPluginInstalled() && !this.bPythonInstalled) {
                    vector.add(CoreResUtil.getString((String)EXTENSION_BUNDLE_PYTHON_PROGRAMMABILITY));
                }
                ExtensionBundleMessageDlg extensionBundleMessageDlg = new ExtensionBundleMessageDlg(this.mFrame, CoreResUtil.getString((String)EXTENSION_BUNDLE_TITLE1_MSG), CoreResUtil.getString((String)EXTENSION_BUNDLE_MSG1_MSG), CoreResUtil.getString((String)EXTENSION_BUNDLE_MSG2_MSG), vector, false, "idh_missing_plugin");
                extensionBundleMessageDlg.setVisible(true);
                if (!extensionBundleMessageDlg.wasContinuePressed()) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean createNameDirectoryUnderExtensionsDirectory() {
        boolean bl = false;
        String string = this.mBundleName.replaceAll(" ", "_");
        File file = this.createDirectoryUnderExtensionsDirectory(string);
        if (file != null) {
            this.mNameDirectory = file;
            bl = true;
        }
        return bl;
    }

    private boolean unzipTranslationCataloguesDirectory() {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.mSpeFile);
            zipInputStream = new JarInputStream(fileInputStream);
            String string = this.mManifestHelper.getTranslationCataloguesPath();
            bl = ExtensionBundleHelper.unJarTranslationCataloguesToDirectory((JarInputStream)zipInputStream, this.mNameDirectory.getAbsolutePath(), string);
            zipInputStream.close();
            if (!bl) {
                if (this.mFrame != null) {
                    ExtensionBundleMessageDlg extensionBundleMessageDlg = new ExtensionBundleMessageDlg(this.mFrame, VersionInfo.getAppVersionString(), CoreResUtil.getString((String)EXTENSION_BUNDLE_OUT_OF_DISK_SPACE_MSG), "", null, true, "idh_cust_not_writeable");
                    extensionBundleMessageDlg.setVisible(true);
                } else {
                    System.out.println(MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_ERR_OUT_OF_DISK_SPACE_MSG), this.mBundleName));
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            try {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            iOException.printStackTrace();
        }
        return bl;
    }

    private File createDirectoryUnderExtensionsDirectory(String string) {
        boolean bl = true;
        File file = null;
        boolean bl2 = false;
        Vector vector = FileLocationsUtil.getExtensionsPathes((boolean)this.bUseExVerPath);
        for (String string2 : vector) {
            string2 = string2.endsWith(File.separator) ? string2 + string : string2 + File.separator + string;
            file = new File(string2);
            if (file.exists() && file.isDirectory()) {
                bl2 = true;
                ExtensionBundleManifestHelper extensionBundleManifestHelper = null;
                for (File file2 : file.listFiles()) {
                    if (!file2.getName().endsWith(".spe") || !file2.getName().contains(string)) continue;
                    try {
                        extensionBundleManifestHelper = new ExtensionBundleManifestHelper(file2);
                        break;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (this.mFrame == null && extensionBundleManifestHelper != null && !this.checkForInstalledExtensionVersion(extensionBundleManifestHelper.getVersion())) {
                    System.out.println(MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_EARLIER_VERSION_MSG), this.mBundleName, extensionBundleManifestHelper.getVersion(), this.mManifestHelper.getVersion()));
                    return null;
                }
                int n = 0;
                if (this.mFrame != null) {
                    Object[] objectArray = new Object[]{ResUtil.getCommonDlgString("IDS_YES"), ResUtil.getCommonDlgString("IDS_NO")};
                    n = JOptionPane.showOptionDialog(this.mFrame, CoreResUtil.getString((String)EXTENSION_BUNDLE_BUNDLE_ALREADY_INSTALLED_MSG), VersionInfo.getAppVersionString(), 0, 3, null, objectArray, objectArray[0]);
                }
                if (n == 0) {
                    File file3;
                    String string3 = string2 + "_" + Calendar.getInstance().getTimeInMillis();
                    bl = SpssFile.deleteDirectory((File)file, (String)string3);
                    if (bl) {
                        bl = file.mkdir();
                    }
                    if ((file3 = new File(string3)).exists()) {
                        file3.delete();
                    }
                    bl = true;
                    break;
                }
                return null;
            }
            if (file.exists() || !(bl = file.mkdir()) || !file.exists()) continue;
            break;
        }
        if (!bl) {
            if (this.mFrame != null) {
                Object object;
                if (bl2 && OSInfo.getOSType() == OSInfo.OSType.WIN) {
                    object = new ExtensionBundleMessageDlg(this.mFrame, VersionInfo.getAppVersionString(), MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_MSG7_MSG), file.getAbsolutePath().toString()), null, null, true, "idh_ext_not_writeable");
                    object.setVisible(true);
                } else {
                    object = new ExtensionBundleMessageDlg(this.mFrame, VersionInfo.getAppVersionString(), CoreResUtil.getString((String)EXTENSION_BUNDLE_MSG3_MSG), CoreResUtil.getString((String)EXTENSION_BUNDLE_MSG6_MSG), vector, true, "idh_ext_not_writeable");
                    object.setVisible(true);
                }
            } else if (bl2 && OSInfo.getOSType() == OSInfo.OSType.WIN) {
                System.out.println(MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_MSG7_MSG), file.getAbsolutePath().toString()));
            } else {
                System.out.println(MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_NO_PERMISSIONS_MSG), this.mBundleName));
            }
            file = null;
        }
        return file;
    }

    private void deleteExtensionDir() {
    }

    private boolean writeCodeFilesToDirectory() {
        return this.writeFilesToExtensionsDirectory(this.mManifestHelper.getCodeFilesSet());
    }

    private boolean writeCommandFilesToDirectories() {
        this.bCommandFiles = true;
        boolean bl = this.writeFilesToExtensionsDirectory(this.mManifestHelper.getCommandSpecsSet());
        this.bCommandFiles = false;
        return bl;
    }

    private boolean writeMiscFilesToDirectory() {
        return this.writeFilesToDirectory(this.mManifestHelper.getMiscFilesSet(), this.mNameDirectory);
    }

    private boolean writeSpeFileToNameDirectory() {
        boolean bl;
        try {
            File file = PASWFileUtil.createTempFile((String)this.mSpeFile.getName(), (String)".spe", (File)this.mNameDirectory);
            DocUtil.copyFile(this.mSpeFile, file);
            File file2 = new File(this.mNameDirectory.getAbsolutePath() + File.separator + this.mSpeFile.getName());
            bl = file.renameTo(file2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private boolean writeFilesToExtensionsDirectory(Set<String> set) {
        Vector vector = FileLocationsUtil.getExtensionsPathes((boolean)this.bUseExVerPath);
        boolean bl = this.writeFilesToFirstWritableDirectory(set, vector);
        return bl;
    }

    private boolean writeFilesToDirectory(Set<String> set, File file) {
        Vector<String> vector = new Vector<String>();
        vector.add(file.getAbsolutePath());
        boolean bl = this.writeFilesToFirstWritableDirectory(set, vector);
        return bl;
    }

    private boolean unzipSpdFileToDirectory() {
        boolean bl = true;
        if (this.bInstallCustomDialogs && !this.mManifestHelper.getDialogSpecsSet().isEmpty()) {
            String string = PrefsMgr.getPrefsMgr().getTempPath();
            Set<String> set = this.mManifestHelper.getDialogSpecsSet();
            Iterator<String> iterator = set.iterator();
            File file = null;
            Vector<File> vector = new Vector<File>();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                if (string2.endsWith(".spd")) {
                    file = new File(string + File.separator + (String)string2);
                    continue;
                }
                if (!string2.endsWith(".cfe")) continue;
                File file2 = new File(string + File.separator + (String)string2);
                vector.add(file2);
            }
            if (file != null && vector.size() > 0) {
                this.mBothHaveSpdAndCfe = true;
            }
            if (bl = this.writeSpdFileToDirectory(string)) {
                try {
                    if (vector.size() > 0) {
                        this.mAppInfo.setCompabibleMode(false);
                        bl = this.unZipCFEfile(vector);
                    } else if (file != null) {
                        this.mAppInfo.setCompabibleMode(true);
                        bl = this.unZipSpdFile(file);
                    }
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            if (file != null && file.exists()) {
                file.delete();
            }
            for (File file2 : vector) {
                file2.deleteOnExit();
            }
        }
        return bl;
    }

    private boolean unZipCFEfile(Vector<File> vector) {
        boolean bl = true;
        if (vector.size() == 0) {
            return bl;
        }
        Vector<String> vector2 = new Vector<String>();
        vector2.add(SpecificationBuilder.getAppDataCustomCFEFolderPath((boolean)this.bUseExVerPath));
        if (vector2.size() > 0) {
            for (String string : vector2) {
                File file = new File(string);
                if (!file.exists() || !file.isDirectory() || !PASWFileUtil.isWritable((File)file)) continue;
                try {
                    InstallDlgAction installDlgAction;
                    if (vector.size() == 1) {
                        InstallDlgAction installDlgAction2 = new InstallDlgAction(true);
                        DialogDefinition dialogDefinition = installDlgAction2.readPackageFile(vector.get(0), false);
                        if (dialogDefinition != null) {
                            if (!installDlgAction2.validateSyntaxAndMenuLocation(this.mFrame, dialogDefinition, true)) {
                                return false;
                            }
                            if (!installDlgAction2.deployCFSpecification(false, this.mFrame, dialogDefinition, true, this.bUseExVerPath)) break;
                            this.mInstalledDlgMenuString = this.mInstalledDlgMenuString + dialogDefinition.getCommandLocation().getCommandPath() + ">" + dialogDefinition.getCommandLocation().getCommandTitle();
                            break;
                        }
                        return bl;
                    }
                    Vector<DialogDefinition> vector3 = new Vector<DialogDefinition>();
                    boolean bl2 = true;
                    for (int i = 0; i < vector.size() && bl2; ++i) {
                        installDlgAction = new InstallDlgAction(true);
                        File file2 = vector.get(i);
                        DialogDefinition dialogDefinition = installDlgAction.readPackageFile(file2, false);
                        if (dialogDefinition == null) continue;
                        if (!installDlgAction.validateSyntaxAndMenuLocation(this.mFrame, dialogDefinition, true)) {
                            return false;
                        }
                        vector3.add(dialogDefinition);
                    }
                    for (DialogDefinition dialogDefinition : vector3) {
                        installDlgAction = new InstallDlgAction(true);
                        installDlgAction.deployCFSpecification(false, this.mFrame, dialogDefinition, true, this.bUseExVerPath);
                        this.mInstalledDlgMenuString = this.mInstalledDlgMenuString + dialogDefinition.getCommandLocation().getCommandPath() + ">" + dialogDefinition.getCommandLocation().getCommandTitle() + "\n";
                    }
                    break;
                }
                catch (Exception exception) {
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    private boolean unZipSpdFile(File file) throws Exception {
        String string;
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = FileLocationsUtil.getSecondaryExtensionDirectory((boolean)this.bUseExVerPath);
        if (stringArray != null && stringArray.length > 0) {
            vector.addAll(Arrays.asList(stringArray));
        }
        if (System.getProperty("os.name", "Windows").toLowerCase().indexOf("win") >= 0) {
            string = FileLocationsUtil.getAppdataCustomDialogDirectoryForAllUsers();
            if (string != null && !string.isEmpty()) {
                vector.add(string);
            }
            if ((string = FileLocationsUtil.getAppdataCustomDialogDirectory()) != null && !string.isEmpty()) {
                vector.add(string);
            }
            if ((string = FileLocationsUtil.getCustomDialogsDirectory()) != null && !string.isEmpty()) {
                vector.add(string);
            }
        } else {
            string = FileLocationsUtil.getCustomDialogsDirectory();
            if (string != null && !string.isEmpty()) {
                vector.add(string);
            }
            if ((string = FileLocationsUtil.getAppdataCustomDialogDirectory()) != null && !string.isEmpty()) {
                vector.add(string);
            }
        }
        if (vector.size() > 0) {
            for (String string2 : vector) {
                DialogDefinition dialogDefinition;
                File file2 = new File(string2);
                if (!file2.exists() || !file2.isDirectory() || !PASWFileUtil.isWritable((File)file2)) continue;
                InstallDlgAction installDlgAction = (InstallDlgAction)ActionCatalog.getActionCatalog().getSpssAction("utilities_install_dialog");
                if (!installDlgAction.validateSyntaxAndMenuLocation(this.mFrame, dialogDefinition = installDlgAction.readPackageFile(file), false)) {
                    return false;
                }
                bl = installDlgAction.deploySpecification(false, this.mFrame, dialogDefinition, this.mFrame != null, this.bUseExVerPath);
                if (bl) {
                    this.mInstalledDlgMenuString = this.mInstalledDlgMenuString + dialogDefinition.getCommandLocation().getCommandPath() + ">" + dialogDefinition.getCommandLocation().getCommandTitle();
                }
                return bl;
            }
        }
        if (this.mFrame != null) {
            Object object = new ExtensionBundleMessageDlg(this.mFrame, CoreResUtil.getString((String)EXTENSION_BUNDLE_TITLE2_MSG), CoreResUtil.getString((String)EXTENSION_BUNDLE_MSG4_MSG), "", vector, true, "idh_cust_not_writeable");
            object.setVisible(true);
        } else {
            System.out.println(MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_NO_PERMISSIONS_MSG), this.mBundleName));
        }
        return bl;
    }

    private boolean writeSpdFileToDirectory(String string) {
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        boolean bl = this.writeFilesToFirstWritableDirectory(this.mManifestHelper.getDialogSpecsSet(), vector);
        if (!bl) {
            if (this.mFrame != null) {
                ExtensionBundleMessageDlg extensionBundleMessageDlg = new ExtensionBundleMessageDlg(this.mFrame, CoreResUtil.getString((String)EXTENSION_BUNDLE_TITLE2_MSG), CoreResUtil.getString((String)EXTENSION_BUNDLE_MSG4_MSG), "", vector, true, "idh_cust_not_writeable");
                extensionBundleMessageDlg.setVisible(true);
            } else {
                System.out.println(MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_NO_PERMISSIONS_MSG), this.mBundleName));
            }
        }
        return bl;
    }

    private boolean writeFilesToFirstWritableDirectory(Set<String> set, Vector<String> vector) {
        boolean bl = true;
        boolean bl2 = false;
        for (String string : vector) {
            File file = new File(string);
            if (!file.exists() || !file.isDirectory() || !PASWFileUtil.isWritable((File)file)) continue;
            for (String string2 : set) {
                File file2 = this.readAndWriteBundleFile(this.mSpeFile, file, string2);
                if (file2 == null) {
                    bl = false;
                    break;
                }
                String string3 = file2.getAbsolutePath();
                if (!this.bCommandFiles) continue;
                this.mCommandFilesPath.add(string3);
            }
            bl2 = true;
            break;
        }
        if (!bl2) {
            bl = false;
        }
        return bl;
    }

    private File readAndWriteBundleFile(File file, File file2, String string) {
        File file3 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            JarInputStream jarInputStream = new JarInputStream(fileInputStream);
            file3 = this.readAndWriteFromJar(jarInputStream, file2, string);
            jarInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return file3;
    }

    private File readAndWriteFromJar(JarInputStream jarInputStream, File file, String string) throws IOException {
        File file2 = null;
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            String string2 = jarEntry.getName();
            if (string2.equals(string)) {
                ByteBuffer byteBuffer = this.readEntry(jarInputStream);
                FileOutputStream fileOutputStream = new FileOutputStream(file.getPath() + File.separator + string2);
                fileOutputStream.write(byteBuffer.array());
                fileOutputStream.close();
                jarInputStream.closeEntry();
                file2 = new File(file.getPath() + File.separator + string2);
                break;
            }
            jarInputStream.closeEntry();
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return file2;
    }

    private boolean unJarTranslationCataloguesToDirectory(JarInputStream jarInputStream, String string) throws IOException {
        boolean bl = true;
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        boolean bl2 = false;
        while (jarEntry != null) {
            Object object;
            if (jarEntry.isDirectory()) {
                String string2;
                object = jarEntry.getName().substring(0, jarEntry.getName().length() - 1);
                object = this.getOSTypeSlashifiedPath((String)object);
                if (bl2) {
                    bl = this.makeDirectoryFromFullAndRelativePaths(string, (String)object);
                    if (!bl) {
                        break;
                    }
                } else if (!((String)object).equals("META-INF") && (string2 = this.mManifestHelper.getTranslationCataloguesPath()) != null && string2.equals(object)) {
                    bl2 = true;
                    bl = this.makeDirectoryFromFullAndRelativePaths(string, (String)object);
                    if (!bl) {
                        break;
                    }
                }
            } else if (bl2) {
                String string3 = this.getOSTypeSlashifiedPath(jarEntry.getName());
                object = this.readEntry(jarInputStream);
                String string4 = string + File.separator + string3;
                FileOutputStream fileOutputStream = new FileOutputStream(string4);
                try {
                    fileOutputStream.write(((ByteBuffer)object).array());
                }
                catch (IOException iOException) {
                    fileOutputStream.close();
                    bl = false;
                    break;
                }
                fileOutputStream.close();
            }
            jarInputStream.closeEntry();
            jarEntry = jarInputStream.getNextJarEntry();
        }
        jarInputStream.close();
        return bl;
    }

    private boolean makeDirectoryFromFullAndRelativePaths(String string, String string2) {
        String string3 = string + File.separator + string2;
        return new File(string3).mkdir();
    }

    boolean downloadRPackagesIfNeededFromInternet() {
        boolean bl = true;
        if (this.bRInstalled && this.bDownloadRPackages) {
            File file;
            File file2;
            block14: {
                file2 = null;
                file = null;
                try {
                    file2 = this.createTempBatchFile(this.getBatchRString());
                    file = this.createTempRLogFile();
                    Vector<String> vector = new Vector<String>();
                    if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
                        vector.add(System.getProperty("application.home") + File.separator + "runR.bat");
                    } else {
                        vector.add(System.getProperty("application.home") + File.separator + "runR.sh");
                    }
                    File file3 = new File((String)vector.firstElement());
                    if (!file3.exists()) break block14;
                    bl = false;
                    this.makeRCommandLineList(file2, file, vector);
                    if (this.mFrame != null) {
                        this.mFrame.setCursor(Cursor.getPredefinedCursor(3));
                    }
                    try {
                        ProcessBuilder processBuilder = new ProcessBuilder(vector);
                        Process process = processBuilder.start();
                        new ConsumeStream(process.getInputStream(), new PrintStream(new ByteArrayOutputStream()));
                        new ConsumeStream(process.getErrorStream(), new PrintStream(new ByteArrayOutputStream()));
                        if (process.waitFor() == 0) {
                            bl = true;
                        } else {
                            Vector<String> vector2 = new Vector<String>();
                            this.readTempRLogFile(file, vector2);
                            this.showErrMsgForRPackagesThatDidNotInstall(vector2);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    if (this.mFrame != null) {
                        this.mFrame.setCursor(null);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (file2 != null) {
                file2.delete();
            }
            if (file != null) {
                file.delete();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean installVizTemplate() {
        boolean bl = true;
        ZipInputStream zipInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(this.mSpeFile));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String string = zipEntry.getName();
                if (string.endsWith(TEMPLATE_SUFFIX)) {
                    int n;
                    String string2 = this.getVizTemplateDir().getAbsolutePath();
                    String string3 = string2 + File.separator + "templates" + File.separator + string;
                    fileOutputStream = new FileOutputStream(string3);
                    byte[] byArray = new byte[1024];
                    while ((n = zipInputStream.read(byArray)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception exception) {
            boolean bl2 = bl = false;
            return bl2;
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    private void showErrMsgForRPackagesThatDidNotInstall(Vector<String> vector) {
        if (this.mFrame == null && !this.bDownloadRPackages) {
            String string = MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_NOT_FOUND1_MSG), this.mBundleName) + vector.toString() + CoreResUtil.getString((String)EXTENSION_BUNDLE_NOT_FOUND2_MSG);
            System.out.println(string);
        } else if (this.mFrame != null) {
            ExtensionBundleMessageDlg extensionBundleMessageDlg = new ExtensionBundleMessageDlg(this.mFrame, VersionInfo.getAppVersionString(), CoreResUtil.getString((String)EXTENSION_BUNDLE_MSG5_MSG), CoreResUtil.getString((String)EXTENSION_BUNDLE_MSG6_MSG), vector, true, "idh_r_install_fail");
            extensionBundleMessageDlg.setVisible(true);
        } else {
            String string = MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_NOT_FOUND3_MSG), this.mBundleName) + vector.toString() + CoreResUtil.getString((String)EXTENSION_BUNDLE_NOT_FOUND4_MSG);
            System.out.println(string);
        }
    }

    private void makeRCommandLineList(File file, File file2, Vector<String> vector) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("--vanilla --slave --args");
        for (String string : this.mManifestHelper.getRLocationSet()) {
            stringBuilder.append(' ').append(string);
        }
        stringBuilder.append(" '").append(file2.getAbsolutePath()).append("'");
        vector.add(this.mRPath.getAbsolutePath());
        vector.add("CMD");
        vector.add("BATCH");
        vector.add(stringBuilder.toString());
        vector.add(file.getAbsolutePath());
    }

    private String getBatchRString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        String string = VersionInfo.getMajorMinorVersionString();
        String string2 = m_externalRPref + string;
        String string3 = "";
        try {
            if (Preferences.userRoot().nodeExists(string2)) {
                object = Preferences.userRoot().node(string2);
                string3 = ((Preferences)object).get("lib_path", string3);
            }
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        if (string3.isEmpty()) {
            bl = true;
        }
        if (!string3.endsWith(File.separator)) {
            string3 = string3 + File.separator;
        }
        File file = this.mFrame == null && !this.bDownloadRPackages ? (bl ? new File(System.getProperty("application.home") + File.separator + "checkpkgs.R") : new File(string3 + "checkpkgs.R")) : (bl ? new File(System.getProperty("application.home") + File.separator + "getpkgs.R") : new File(string3 + "getpkgs.R"));
        try {
            String string4;
            object = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            while ((string4 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string4).append('\n');
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    private File createTempBatchFile(String string) throws IOException {
        String string2 = PrefsMgr.getPrefsMgr().getTempPath();
        File file = PASWFileUtil.createTempFile((String)"spss", (String)".R", (File)new File(string2));
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file, false);
        fileOutputStream.write(string.getBytes("UTF-8"));
        fileOutputStream.close();
        return file;
    }

    private File createTempRLogFile() throws IOException {
        String string = PrefsMgr.getPrefsMgr().getTempPath();
        File file = PASWFileUtil.createTempFile((String)"spssRLog", (String)".txt", (File)new File(string));
        file.deleteOnExit();
        return file;
    }

    private void readTempRLogFile(File file, Vector<String> vector) throws IOException {
        if (file.exists()) {
            String string;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string = bufferedReader.readLine()) != null) {
                vector.add(string);
            }
            bufferedReader.close();
        }
    }

    private String getOSTypeSlashifiedPath(String string) {
        string = OSCheck.getOSType() == OSInfo.OSType.WIN ? string.replace('/', File.separatorChar) : string.replace('\\', File.separatorChar);
        return string;
    }

    private boolean readManifest() {
        boolean bl = true;
        try {
            String string;
            this.mManifestHelper = new ExtensionBundleManifestHelper(this.mSpeFile);
            this.mBundleName = this.mManifestHelper.getBundleName();
            boolean bl2 = bl = this.mBundleName != null && this.mBundleName.length() > 0;
            if (bl) {
                string = this.mManifestHelper.getSummary();
                boolean bl3 = bl = string != null && string.length() > 0;
            }
            if (!bl) {
                string = CoreResUtil.getString((String)"IDS_INSTALL_EXTENSION_BUNDLE_NO_NAME_SUMMARY_MSG");
                if (this.mFrame != null) {
                    ExtensionBundleMessageDlg extensionBundleMessageDlg = new ExtensionBundleMessageDlg(this.mFrame, VersionInfo.getAppVersionString(), null, string, null, true, "idh_r_install_fail");
                    extensionBundleMessageDlg.setVisible(true);
                } else {
                    System.out.println(string);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private ByteBuffer readEntry(JarInputStream jarInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[50000];
        try {
            int n = jarInputStream.read(byArray, 0, 50000);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = jarInputStream.read(byArray, 0, 50000);
            }
        }
        catch (IOException iOException) {
            byteArrayOutputStream.reset();
            iOException.printStackTrace();
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    private File getVizTemplateDir() {
        String string = System.getProperty("user.home");
        if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
            return new File(string, "Application Data/SPSSInc/Graphboard");
        }
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            return new File(string, "Library/Application Support/SPSSInc/Graphboard");
        }
        return new File(string, ".Graphboard");
    }

    private void addMessageToOutputViewer(String string, String string2) {
        ViewerFrame viewerFrame;
        OutputManager outputManager = OutputManager.getOutputManager();
        IOutputDocument iOutputDocument = outputManager.getDesignatedDocument();
        IOutputItem iOutputItem = null;
        for (long i = iOutputDocument.getItemCount() - 1L; !(i < 0L || (iOutputItem = iOutputDocument.getItemAtIndex(i)) instanceof HeaderItem || iOutputItem instanceof LogItem || iOutputItem.getDescription().equals(string)); --i) {
        }
        TextItem textItem = new TextItem();
        textItem.setDescription(string);
        textItem.setContents(string2);
        iOutputDocument.insertItem((IOutputItem)textItem, iOutputItem, true);
        if (SpssFrameMgr.getSpssFrameMgr().openDocumentCount(DocType.OUTPUT_DOC) > 0 && (viewerFrame = (ViewerFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.OUTPUT_DOC)) != null) {
            if (viewerFrame.getExtendedState() != 6) {
                viewerFrame.setExtendedState(0);
            }
            viewerFrame.toFront();
        }
    }
}

