/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.bundle_install_utility;

import com.spss.charteditor.component.CETextArea;
import com.spss.charteditor.component.LimitedPlainDocument;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.LocalFileSysUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SerializableEditableList;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_install_utility.ExtensionBundleDlg;
import com.spss.java_client.ui.dialogs.common.BaseSpssTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;

public class ExtensionBundleRequiredTab
extends BaseSpssTab
implements ActionListener,
KeyListener,
ListDataListener,
ListSelectionListener,
FocusListener {
    public static final String REQUIRED_NAME_TEXT_KEY = "IDK_NAME_TEXT";
    public static final String REQUIRED_FILES_KEY = "IDK_EXTENSION_BUNDLE_REQUIRED_TAB_FILES";
    public static final String REQUIRED_SUMMARY_TEXT_KEY = "IDK_SUMMARY_TEXT";
    public static final String REQUIRED_DESC_TEXT_KEY = "IDK_DESC_TEXT";
    public static final String REQUIRED_AUTHOR_TEXT_KEY = "IDK_AUTHOR_TEXT";
    public static final String REQUIRED_VERSION_TEXT_KEY = "IDK_VERSION_TEXT";
    public static final String REQUIRED_VERSION_COMBO_KEY = "IDK_VERSION_COMBO";
    public static final String REQUIRED_TARGET_FILE_TEXT_KEY = "IDK_TARGET_FILE_TEXT";
    static final String REQUIRED_OPEN_DIALOG_FILTER = "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_OPEN_DIALOG_FILTER";
    static final String REQUIRED_OPEN_DIALOG_EXTENSION = "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_OPEN_DIALOG_EXTENSION";
    static final String REQUIRED_OPEN_DIALOG_TITLE = "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_OPEN_DIALOG_TITLE";
    static final String REQUIRED_SPE_DIALOG_FILTER = "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_SPE_DIALOG_FILTER";
    static final String REQUIRED_SPE_DIALOG_EXTENSION = "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_SPE_DIALOG_EXTENSION";
    static final String REQUIRED_SPE_DIALOG_TITLE = "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_SPE_DIALOG_TITLE";
    static final String REQUIRED_INFO_TEXT = "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_INFO_TEXT";
    static final String REQUIRED_NAME_THREE_WORDS_LIMIT_ERR = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_NAME_THREE_WORDS_LIMIT";
    static final String REQUIRED_SPD_FILE_DUPLICATION_ERR = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_SPD_FILE_DUPLICATION";
    static final String REQUIRED_FILE_DUPLICATION_ERR = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_FILE_DUPLICATION";
    static final String REQUIRED_REQUIRED_FILES_ERR = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_REQUIRED_FILES";
    static final String REQUIRED_REQUIRED_SUB_FILES_ERR = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_REQUIRED_SUB_FILES";
    static final String REQUIRED_VERSION_ERR = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_VERSION";
    static final String REQUIRED_FILE_NOT_FOUND_MSG = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_FILE_NOT_FOUND_MSG";
    static final String REQUIRED_ACCESS_DENIED = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_ACCESS_DENIED";
    static final String REQUIRED_ENTER_FILE = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_ENTER_FILE";
    private static String LINE_SEPERATOR = System.getProperty("line.separator");
    private JLabel mInfoTextImageLabel;
    private JTextArea mInfoTextArea;
    private JLabel mNameFieldLabel;
    private JTextField mNameField;
    private JLabel mFilesLabel;
    private SerializableEditableList mFilesList;
    private JScrollPane mFilesListScrollPane;
    private JButton mAddButton;
    private JButton mRemoveButton;
    private JLabel mSummaryFieldLabel;
    private JTextField mSummaryField;
    private JLabel mDescFieldLabel;
    private NoCRLFTextArea mDescField;
    private JScrollPane mDescFieldScrollPane;
    private JLabel mAuthorFieldLabel;
    private JTextField mAuthorField;
    private JLabel mVersionLabel;
    private JTextField mVersionField;
    private JLabel mVersionComboLabel;
    private JComboBox mVersionCombo;
    private JLabel mTargetFileLabel;
    private FileTextField mTargetFileTextField;
    private JButton mBrowseButton;
    private Vector<String> mDialogSpecsVector = new Vector();
    private Vector<String> mCommandSpecsVector = new Vector();
    private Vector<String> mCodeFilesVector = new Vector();
    private Vector<String> mMiscFilesVector = new Vector();
    private Vector<String> mAllFilesVector = new Vector();
    ExtensionBundleDlg mParent;

    public ExtensionBundleRequiredTab(ExtensionBundleDlg extensionBundleDlg, boolean bl) {
        super(extensionBundleDlg, false);
        this.mParent = extensionBundleDlg;
        this.initPanel();
        if (bl) {
            this.setDefaults();
        }
    }

    protected void loadDialogState() {
        DialogDataModel dialogDataModel = this.mParent.getDialogDataModel();
        String string = dialogDataModel.getString(REQUIRED_DESC_TEXT_KEY);
        if (string != null) {
            this.mDescField.setText(string);
        }
        if ((string = dialogDataModel.getString(REQUIRED_TARGET_FILE_TEXT_KEY)) != null) {
            this.mTargetFileTextField.setText(string);
        }
    }

    protected void saveDialogState() {
        this.appendTempPathToFileNames();
        this.mParent.getDialogDataModel().putString(REQUIRED_DESC_TEXT_KEY, this.mDescField.getText());
        this.mParent.getDialogDataModel().putString(REQUIRED_TARGET_FILE_TEXT_KEY, this.mTargetFileTextField.getText());
    }

    private void appendTempPathToFileNames() {
        if (this.mParent.getInEditMode().booleanValue()) {
            String string = this.mParent.getNameDirectory().getPath();
            DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
            defaultListModel.removeListDataListener(this);
            for (int i = 0; i < defaultListModel.size(); ++i) {
                String string2 = this.getListItemAt(i);
                if (string2.contains(File.separator)) continue;
                this.setListItemAt(i, string + File.separator + string2);
            }
            defaultListModel.addListDataListener(this);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_required";
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVariables();
        this.setupPanel();
        this.enableUIItems();
        this.setFocusTraversalPolicy();
    }

    private void initVariables() {
        TextFieldListener textFieldListener = new TextFieldListener();
        this.mInfoTextArea = new JTextArea(this.getResString(REQUIRED_INFO_TEXT));
        this.mInfoTextArea.setEditable(false);
        this.mInfoTextArea.setOpaque(false);
        this.mInfoTextArea.setFocusable(false);
        this.mInfoTextArea.setWrapStyleWord(true);
        this.mInfoTextArea.setLineWrap(true);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        this.mInfoTextImageLabel = new JLabel();
        this.mInfoTextImageLabel.setIcon(new ImageIcon(uRL));
        this.mNameField = new JTextField();
        if (ComponentState.isBtdRtlOrLtr()) {
            if (ComponentState.getBTD() == 1) {
                this.mNameField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                this.mNameField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        }
        this.mNameField.addKeyListener(this);
        this.mNameField.getDocument().addDocumentListener(textFieldListener);
        this.mNameField.setAction(new TextFieldAction(this.mParent, REQUIRED_NAME_TEXT_KEY));
        this.mNameField.setPreferredSize(new Dimension(325, this.mNameField.getMinimumSize().height));
        this.mNameFieldLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_NAME");
        this.mNameFieldLabel.setLabelFor(this.mNameField);
        this.mFilesList = new SerializableEditableList(REQUIRED_FILES_KEY);
        this.mFilesList.addListSelectionListener(this);
        DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
        defaultListModel.addListDataListener(this);
        this.mFilesListScrollPane = new JScrollPane(this.mFilesList);
        this.mFilesListScrollPane.setPreferredSize(new Dimension(325, 102));
        this.mFilesListScrollPane.getVerticalScrollBar().setEnabled(true);
        this.mFilesLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_FILES");
        this.mFilesLabel.setLabelFor(this.mFilesList);
        this.mAddButton = DialogUtil.createButton(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_ADD", this);
        this.mRemoveButton = DialogUtil.createButton(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_REMOVE", this);
        this.mSummaryField = new JTextField();
        if (ComponentState.isBtdRtlOrLtr()) {
            if (ComponentState.getBTD() == 1) {
                this.mSummaryField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                this.mSummaryField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        }
        this.mSummaryField.getDocument().addDocumentListener(textFieldListener);
        this.mSummaryField.setAction(new TextFieldAction(this.mParent, REQUIRED_SUMMARY_TEXT_KEY));
        this.mSummaryField.setPreferredSize(new Dimension(325, this.mSummaryField.getMinimumSize().height));
        this.mSummaryFieldLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_SUMMARY");
        this.mSummaryFieldLabel.setLabelFor(this.mSummaryField);
        this.mDescField = new NoCRLFTextArea();
        this.mDescField.addKeyListener(this);
        this.mDescField.getDocument().addDocumentListener(textFieldListener);
        this.mDescField.setLineWrap(true);
        this.mDescField.setWrapStyleWord(true);
        this.mDescField.setRows(3);
        this.mDescFieldScrollPane = new JScrollPane((Component)((Object)this.mDescField));
        this.mDescFieldScrollPane.setHorizontalScrollBarPolicy(31);
        this.mDescFieldScrollPane.setPreferredSize(new Dimension(325, 50));
        this.mDescFieldLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_DESCRIPTION");
        this.mDescFieldLabel.setLabelFor((Component)((Object)this.mDescField));
        this.mAuthorField = new JTextField();
        if (ComponentState.isBtdRtlOrLtr()) {
            if (ComponentState.getBTD() == 1) {
                this.mAuthorField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                this.mAuthorField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        }
        this.mAuthorField.getDocument().addDocumentListener(textFieldListener);
        this.mAuthorField.setAction(new TextFieldAction(this.mParent, REQUIRED_AUTHOR_TEXT_KEY));
        this.mAuthorField.setPreferredSize(new Dimension(325, this.mAuthorField.getMinimumSize().height));
        this.mAuthorFieldLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_AUTHOR");
        this.mAuthorFieldLabel.setLabelFor(this.mAuthorField);
        this.mVersionField = new JTextField();
        this.mVersionField.setDocument((Document)new LimitedPlainDocument(8));
        this.mVersionField.setAction(new TextFieldAction(this.mParent, REQUIRED_VERSION_TEXT_KEY));
        this.mVersionField.addKeyListener(this);
        this.mVersionField.getDocument().addDocumentListener(textFieldListener);
        this.mVersionField.setPreferredSize(new Dimension(53, this.mVersionField.getMinimumSize().height));
        this.mVersionLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_VERSION");
        this.mVersionLabel.setLabelFor(this.mVersionField);
        String string = this.getResString("IDS_EXTENSION_BUNDLE_REQUIRED_TAB_VERSION_NUMBERS");
        String[] stringArray = string.split(",");
        this.mVersionCombo = new JComboBox<String>(stringArray);
        this.mVersionCombo.setAction(new ComboboxAction(this.mParent, REQUIRED_VERSION_COMBO_KEY));
        this.mVersionCombo.addActionListener(this);
        Dimension dimension = this.mVersionCombo.getMinimumSize();
        dimension.width = 60;
        this.mVersionCombo.setMaximumSize(dimension);
        this.mVersionCombo.setPreferredSize(dimension);
        this.mVersionCombo.setEditable(false);
        this.mVersionComboLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_PASW_STATISTICS_VERSION");
        this.mVersionComboLabel.setLabelFor(this.mVersionCombo);
        this.mTargetFileTextField = new FileTextField();
        this.mTargetFileTextField.setColumns(45);
        this.mTargetFileLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_TARGET_FILE");
        this.mTargetFileLabel.setLabelFor((Component)((Object)this.mTargetFileTextField));
        this.mTargetFileTextField.getDocument().addDocumentListener(textFieldListener);
        this.mTargetFileTextField.addFocusListener(this);
        this.mBrowseButton = DialogUtil.createButton(this.mParent, "IDS_EXTENSION_BUNDLE_REQUIRED_TAB_BROWSE", this);
    }

    private String getFileNameExt(String string) {
        String string2 = "";
        if (string.lastIndexOf(".") >= 0 && string.lastIndexOf(".") < string.length() - 1) {
            string2 = string.substring(string.lastIndexOf(".") + 1);
        }
        return string2;
    }

    private void setupPanel() {
        this.setLayout(new GridBagLayout());
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        Insets insets2 = (Insets)DialogUtil.getStandardDialogInsets().clone();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets3 = new Insets(0, insets2.left, n2, insets.right);
        Insets insets4 = new Insets(0, insets.left, n2, insets.right);
        Insets insets5 = new Insets(n2, insets2.left, insets2.bottom, insets2.right);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n3 = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(this, this.mInfoTextImageLabel, gridBagConstraints, 1, 0, 1, 1, n3, new Insets(insets2.top, insets2.left, n2 * 3, insets2.right));
        DialogUtil.addUsingGBL(this, this.mInfoTextArea, gridBagConstraints, 2, 0, 6, 1, n3, new Insets(insets2.top, insets.left, n2 * 3, insets2.right));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(this, this.mNameFieldLabel, gridBagConstraints, 0, 1, 2, 1, n3, insets3);
        DialogUtil.addUsingGBL(this, this.mNameField, gridBagConstraints, 2, 1, 3, 1, n3, insets4);
        DialogUtil.addUsingGBL(this, this.mFilesLabel, gridBagConstraints, 0, 2, 2, 1, n3, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, this.mFilesListScrollPane, gridBagConstraints, 2, 2, 3, 1, n3, insets4);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.setupAddRemoveButtonsPanel(), gridBagConstraints, 5, 2, 1, 1, n3, new Insets(0, n, n2, insets2.right));
        DialogUtil.addUsingGBL(this, this.mSummaryFieldLabel, gridBagConstraints, 0, 6, 2, 1, n3, insets3);
        DialogUtil.addUsingGBL(this, this.mSummaryField, gridBagConstraints, 2, 6, 3, 1, n3, insets4);
        DialogUtil.addUsingGBL(this, this.mDescFieldLabel, gridBagConstraints, 0, 7, 2, 1, n3, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, this.mDescFieldScrollPane, gridBagConstraints, 2, 7, 3, 1, n3, insets4);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.mAuthorFieldLabel, gridBagConstraints, 0, 8, 2, 1, n3, insets3);
        DialogUtil.addUsingGBL(this, this.mAuthorField, gridBagConstraints, 2, 8, 3, 1, n3, insets4);
        DialogUtil.addUsingGBL(this, this.mVersionLabel, gridBagConstraints, 0, 9, 2, 1, n3, insets3);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mVersionField, gridBagConstraints, 2, 9, 1, 1, n3, insets4);
        DialogUtil.addUsingGBL(this, this.mVersionComboLabel, gridBagConstraints, 3, 9, 1, 1, n3, insets3);
        DialogUtil.addUsingGBL(this, this.mVersionCombo, gridBagConstraints, 4, 9, 1, 1, n3, insets4);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.setupTargetFileForExtensionBundlePanel(), gridBagConstraints, 0, 10, 6, 1, n3, insets5);
    }

    private JPanel setupAddRemoveButtonsPanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardButtonInsets().clone();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        jPanel.setLayout(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel, this.mAddButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRemoveButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private JPanel setupTargetFileForExtensionBundlePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n, n, n);
        gridBagConstraints.weighty = 0.0;
        int n2 = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTargetFileTextField), gridBagConstraints, 0, 0, 1, 1, n2, insets);
        n2 = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        return OptionsUtil.setupControlOnBorder(jPanel, this.mTargetFileLabel);
    }

    private void setFocusTraversalPolicy() {
        this.addToComponentOrder(this.mNameField);
        this.addToComponentOrder(this.mFilesList);
        this.addToComponentOrder(this.mAddButton);
        this.addToComponentOrder(this.mRemoveButton);
        this.addToComponentOrder(this.mSummaryField);
        this.addToComponentOrder((Object)this.mDescField);
        this.addToComponentOrder(this.mAuthorField);
        this.addToComponentOrder(this.mVersionField);
        this.addToComponentOrder(this.mVersionCombo);
        this.addToComponentOrder(this.mTargetFileTextField);
        this.addToComponentOrder(this.mBrowseButton);
        this.addAllToComponentOrder(new Vector<Object>(Arrays.asList(this.mParent.getCmdButtonPanel().getComponents())));
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    public void setDefaults() {
        this.mNameField.setText("");
        ((DefaultListModel)this.mFilesList.getModel()).clear();
        this.mSummaryField.setText("");
        this.mDescField.setText("");
        this.mAuthorField.setText("");
        this.mVersionField.setText("");
        this.mTargetFileTextField.setText("");
        this.setInitialized(true);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == (DefaultListModel)this.mFilesList.getModel()) {
            DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
            defaultListModel.removeListDataListener(this);
            String string = this.getListItemAt(listDataEvent.getIndex0());
            if (string.trim().length() == 0) {
                this.removeListItemAt(listDataEvent.getIndex0());
            }
            defaultListModel.addListDataListener(this);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    private void removeListItemAt(int n) {
        ((DefaultListModel)this.mFilesList.getModel()).removeElementAt(n);
    }

    private String getListItemAt(int n) {
        return this.mFilesList.getModel().getElementAt(n).toString();
    }

    private void addListItemAt(int n, String string) {
        DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
        if (string.equals("")) {
            string = " ";
        }
        defaultListModel.add(n, string);
    }

    private void setListItemAt(int n, String string) {
        DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
        if (string.equals("")) {
            string = " ";
        }
        defaultListModel.setElementAt(string, n);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.mNameField && keyEvent.getKeyChar() >= ' ' && keyEvent.getKeyChar() <= '\u007f') {
            String string = "\"*:/<>?\\|";
            if (string.contains("" + keyEvent.getKeyChar())) {
                Toolkit.getDefaultToolkit().beep();
                keyEvent.consume();
            }
        } else if (keyEvent.getSource() == this.mVersionField && !Character.isDigit(keyEvent.getKeyChar()) && keyEvent.getKeyChar() != '.' && keyEvent.getKeyChar() != '\u007f' && keyEvent.getKeyChar() != '\b' && keyEvent.getKeyChar() != '\n') {
            Toolkit.getDefaultToolkit().beep();
            keyEvent.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.mDescField && keyEvent.getKeyCode() == 10) {
            Toolkit.getDefaultToolkit().beep();
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mAddButton) {
            this.processAddButton();
        } else if (object == this.mRemoveButton) {
            this.processRemoveButton();
        } else if (object == this.mBrowseButton) {
            this.processBrowseButton();
        }
    }

    private void processAddButton() {
        File file;
        RemoteFileChooser remoteFileChooser;
        String string = (String)this.mFilesList.getSelectedValue();
        if (string == null) {
            string = "";
        }
        if ((remoteFileChooser = this.showFileDialog(false, this.getResString(REQUIRED_OPEN_DIALOG_EXTENSION), this.getResString(REQUIRED_OPEN_DIALOG_FILTER), this.getResString(REQUIRED_OPEN_DIALOG_TITLE), string)) != null && (file = remoteFileChooser.getSelectedFile()) != null) {
            String string2 = file.getAbsolutePath();
            if ((string2 = string2.trim()) != null && string2.length() > 0) {
                String string3 = file.getName().trim();
                String string4 = this.getFileNameExt(string2);
                PesFile pesFile = PES_Repository.getPesFile((String)string2);
                if (pesFile != null) {
                    string2 = pesFile.getUri();
                }
                DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
                int n = defaultListModel.size();
                for (int i = 0; i < n; ++i) {
                    String string5 = this.getListItemAt(i);
                    String string6 = "";
                    String string7 = this.getFileNameExt(string5);
                    int n2 = string5.length() - string3.length();
                    if (n2 >= 0) {
                        string6 = string5.substring(n2);
                    }
                    if (string4.equalsIgnoreCase("spd") && string7.equalsIgnoreCase("spd")) {
                        JOptionPane.showConfirmDialog((Component)((Object)this.mParent), this.getResString(REQUIRED_SPD_FILE_DUPLICATION_ERR), VersionInfo.getAppVersionString(), -1, 1);
                        this.mFilesList.clearSelection();
                        this.mFilesList.setSelectedIndex(i);
                        return;
                    }
                    if (!string3.equalsIgnoreCase(string6)) continue;
                    JOptionPane.showConfirmDialog((Component)((Object)this.mParent), this.getResString(REQUIRED_FILE_DUPLICATION_ERR), VersionInfo.getAppVersionString(), -1, 1);
                    this.mFilesList.clearSelection();
                    this.mFilesList.setSelectedIndex(i);
                    return;
                }
                this.addListItemAt(n, string2);
                this.mFilesList.clearSelection();
                this.mFilesList.setSelectedIndex(n);
                this.mParent.enableUIItems();
            }
        }
    }

    private void processRemoveButton() {
        int n;
        int n2 = this.mFilesList.getSelectionModel().getMaxSelectionIndex();
        for (int i = n = this.mFilesList.getSelectionModel().getMinSelectionIndex(); i >= 0 && i <= n2; ++i) {
            if (!this.mFilesList.getSelectionModel().isSelectedIndex(i)) continue;
            this.removeListItemAt(i);
        }
        this.mParent.enableUIItems();
        this.mFilesList.clearSelection();
        this.mFilesList.requestFocusInWindow();
    }

    private void processBrowseButton() {
        RemoteFileChooser remoteFileChooser = this.showFileDialog(true, this.getResString(REQUIRED_SPE_DIALOG_EXTENSION), this.getResString(REQUIRED_SPE_DIALOG_FILTER), this.getResString(REQUIRED_SPE_DIALOG_TITLE), "");
        if (remoteFileChooser != null) {
            String string = remoteFileChooser.getSelectedFilePath();
            String string2 = string.toLowerCase();
            int n = string2.indexOf(this.getResString(REQUIRED_SPE_DIALOG_EXTENSION));
            if (n == -1) {
                string = string.concat(this.getResString(REQUIRED_SPE_DIALOG_EXTENSION));
            } else if (string2.substring(n).compareToIgnoreCase(this.getResString(REQUIRED_SPE_DIALOG_EXTENSION)) != 0) {
                string = string.concat(this.getResString(REQUIRED_SPE_DIALOG_EXTENSION));
            }
            this.mTargetFileTextField.setText(string);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.mParent.enableUIItems();
        }
    }

    @Override
    protected boolean validateTab() {
        boolean bl = false;
        if (super.validateTab() && this.validateNameField() && this.validateFilesListField() && this.validateVersionField() && this.validateTargetFile()) {
            bl = true;
        }
        return bl;
    }

    private boolean validateNameField() {
        boolean bl = true;
        String string = this.mNameField.getText().trim();
        String[] stringArray = string.split(" ");
        String string2 = "";
        int n = 0;
        for (String string3 : stringArray) {
            if (string3.equals("")) continue;
            string2 = string2 + string3 + " ";
            ++n;
        }
        if (string2.endsWith(" ")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        this.mNameField.setText(string2);
        if (n > 3) {
            JOptionPane.showConfirmDialog((Component)((Object)this.mParent), this.getResString(REQUIRED_NAME_THREE_WORDS_LIMIT_ERR), VersionInfo.getAppVersionString(), -1, 1);
            bl = false;
            this.mNameField.requestFocusInWindow();
        }
        return bl;
    }

    private boolean validateFilesListField() {
        boolean bl = true;
        if (this.mFilesList != null && this.mFilesList.isEnabled()) {
            DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
            defaultListModel.removeListDataListener(this);
            for (int i = 0; i < defaultListModel.size(); ++i) {
                String string = this.getListItemAt(i);
                if (string.trim().length() > 0) {
                    File file;
                    PesFile pesFile;
                    string = string.trim();
                    this.setListItemAt(i, string);
                    if (this.mParent.getInEditMode().booleanValue() && !string.contains(File.separator)) {
                        string = this.mParent.getNameDirectory().getPath() + File.separator + string;
                    }
                    if ((pesFile = PES_Repository.getPesFile((String)(file = new File(string.trim())).getAbsolutePath())) != null) {
                        bl = pesFile.existsInPES() && pesFile.canReadFromPesFile();
                    } else if (!file.exists()) {
                        bl = false;
                    } else if (file.isFile()) {
                        bl = true;
                    }
                    if (bl) continue;
                    this.mFilesList.setSelectedIndex(i);
                    this.mFilesList.requestFocusInWindow();
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mParent), this.getResString(REQUIRED_FILE_NOT_FOUND_MSG), VersionInfo.getAppVersionString());
                    break;
                }
                this.removeListItemAt(i);
                --i;
            }
            defaultListModel.addListDataListener(this);
        }
        if (bl) {
            bl = this.validateFilesListFieldForValidFileTypes();
        }
        return bl;
    }

    private boolean validateFilesListFieldForValidFileTypes() {
        boolean bl = true;
        int n = this.getNumOfFileTypesInList("spd");
        int n2 = this.getNumOfFileTypesInList("xml");
        int n3 = this.getNumOfFileTypesInList("py");
        int n4 = this.getNumOfFileTypesInList("pyc");
        int n5 = this.getNumOfFileTypesInList("pyo");
        int n6 = this.getNumOfFileTypesInList("r");
        int n7 = this.getNumOfFileTypesInList("class");
        int n8 = this.getNumOfFileTypesInList("jar");
        if (n <= 0 && n2 <= 0) {
            JOptionPane.showConfirmDialog((Component)((Object)this.mParent), this.getResString(REQUIRED_REQUIRED_FILES_ERR), VersionInfo.getAppVersionString(), -1, 1);
            bl = false;
        } else if (n2 > 0 && n3 == 0 && n4 == 0 && n5 == 0 && n6 == 0 && n7 == 0 && n8 == 0) {
            JOptionPane.showConfirmDialog((Component)((Object)this.mParent), this.getResString(REQUIRED_REQUIRED_SUB_FILES_ERR), VersionInfo.getAppVersionString(), -1, 1);
            bl = false;
        }
        if (bl) {
            this.copyFileListItemsIntoVectors();
        }
        return bl;
    }

    private void copyFileListItemsIntoVectors() {
        DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
        int n = defaultListModel.size();
        this.mDialogSpecsVector.clear();
        this.mCommandSpecsVector.clear();
        this.mCodeFilesVector.clear();
        this.mMiscFilesVector.clear();
        this.mAllFilesVector.clear();
        for (int i = 0; i < n; ++i) {
            File file;
            String string;
            String string2;
            String string3 = this.getListItemAt(i);
            if (this.mParent.getInEditMode().booleanValue() && !string3.contains(File.separator)) {
                string3 = this.mParent.getNameDirectory().getPath() + File.separator + string3;
            }
            if ((string2 = this.getFileNameExt(string = (file = new File(string3)).getName())) != null) {
                if (string2.equalsIgnoreCase("spd")) {
                    this.mDialogSpecsVector.add(string);
                } else if (string2.equalsIgnoreCase("xml")) {
                    this.mCommandSpecsVector.add(string);
                } else if (string2.equalsIgnoreCase("py") || string2.equalsIgnoreCase("pyc") || string2.equalsIgnoreCase("pyo") || string2.equalsIgnoreCase("R") || string2.equalsIgnoreCase("class") || string2.equalsIgnoreCase("jar")) {
                    this.mCodeFilesVector.add(string);
                } else {
                    this.mMiscFilesVector.add(string);
                }
                this.mAllFilesVector.add(string3);
                continue;
            }
            if (string == null) continue;
            this.mMiscFilesVector.add(string);
            this.mAllFilesVector.add(string3);
        }
    }

    private int getNumOfFileTypesInList(String string) {
        DefaultListModel defaultListModel = (DefaultListModel)this.mFilesList.getModel();
        int n = defaultListModel.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string2 = this.getFileNameExt(this.getListItemAt(i));
            if (!string2.equalsIgnoreCase(string)) continue;
            ++n2;
        }
        return n2;
    }

    private boolean validateVersionField() {
        boolean bl = true;
        String string = this.mVersionField.getText().trim();
        String[] stringArray = string.split("\\.");
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        for (String string2 : arrayList) {
            if (!string2.equals("")) continue;
            bl = false;
            break;
        }
        if (bl) {
            if (arrayList.size() > 3 || arrayList.size() == 0) {
                bl = false;
            } else if (arrayList.size() == 1) {
                arrayList.add(1, "0");
                arrayList.add(2, "0");
            } else if (arrayList.size() == 2) {
                arrayList.add(2, "0");
            }
        }
        if (bl) {
            String string3 = (String)arrayList.get(0) + "." + (String)arrayList.get(1) + "." + (String)arrayList.get(2);
            this.mVersionField.setText(string3);
        } else {
            JOptionPane.showConfirmDialog((Component)((Object)this.mParent), this.getResString(REQUIRED_VERSION_ERR), VersionInfo.getAppVersionString(), -1, 1);
            bl = false;
            this.mVersionField.requestFocusInWindow();
        }
        return bl;
    }

    private boolean validateTargetFile() {
        boolean bl = false;
        if (this.mTargetFileTextField != null && this.mTargetFileTextField.isEnabled()) {
            if (this.mTargetFileTextField.getText().trim().length() > 0) {
                File file;
                PesFile pesFile;
                String string = LocalFileSysUtil.getLocalFileSysUtil().ExpandEnvVars(this.mTargetFileTextField.getText().trim());
                this.mTargetFileTextField.setText(string);
                String string2 = this.getFileNameExt(this.mTargetFileTextField.getText());
                if (string2 == null || !string2.equalsIgnoreCase("spe")) {
                    this.mTargetFileTextField.setText(this.mTargetFileTextField.getText() + ".spe");
                }
                if ((pesFile = PES_Repository.getPesFile((String)(file = new File(this.mTargetFileTextField.getText())).getAbsolutePath())) != null) {
                    bl = !pesFile.existsInPES() || pesFile.canWriteToPesFile();
                } else if (!file.exists()) {
                    try {
                        if (file.createNewFile()) {
                            file.delete();
                            bl = true;
                        }
                    }
                    catch (IOException iOException) {
                        bl = false;
                    }
                } else if (file.isFile()) {
                    bl = true;
                }
                if (!bl) {
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mParent), this.getResString(REQUIRED_ENTER_FILE), VersionInfo.getAppVersionString());
                }
            } else {
                bl = false;
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mParent), this.getResString(REQUIRED_ENTER_FILE), VersionInfo.getAppVersionString());
            }
            if (!bl) {
                this.mTargetFileTextField.requestFocusInWindow();
            }
        }
        return bl;
    }

    private RemoteFileChooser showFileDialog(boolean bl, String string, String string2, String string3, String string4) {
        RemoteFileChooser remoteFileChooser = bl ? new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false) : new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, string4, false, false, true);
        remoteFileChooser.setDialogTitle(string3);
        remoteFileChooser.setFileSelectionMode(0);
        RefFileFilter refFileFilter = new RefFileFilter(string2, string);
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        if (bl) {
            remoteFileChooser.setAcceptAllFileFilterUsed(false);
            if (string4.trim().length() != 0) {
                remoteFileChooser.setCurrentDirectory(new File(string4));
            }
        } else {
            remoteFileChooser.setAcceptAllFileFilterUsed(true);
        }
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        int n = bl ? remoteFileChooser.showSaveDialog((Component)((Object)this.mParent)) : remoteFileChooser.showOpenDialog((Component)((Object)this.mParent));
        if (n == 0) {
            return remoteFileChooser;
        }
        return null;
    }

    boolean isComplete() {
        boolean bl = false;
        if (this.mNameField.getText().length() > 0 && this.mSummaryField.getText().length() > 0 && this.mDescField.getText().length() > 0 && this.mAuthorField.getText().length() > 0 && this.mVersionField.getText().length() > 0 && this.mTargetFileTextField.getText().length() > 0 && this.mFilesList.getModel().getSize() > 0) {
            bl = true;
        }
        return bl;
    }

    void enableUIItems() {
        this.enableRemoveButton();
        this.enableVersionCombo();
    }

    private boolean enableRemoveButton() {
        boolean bl = this.mFilesList.getSelectedValue() != null;
        this.mRemoveButton.setEnabled(bl);
        return bl;
    }

    private boolean enableVersionCombo() {
        boolean bl = true;
        this.mVersionCombo.setEnabled(bl);
        return bl;
    }

    public String getNameKeyValuePairs() {
        String string = "Name: " + this.mNameField.getText() + "\n";
        return string;
    }

    public String getDialogSpecsKeyValuePairs() {
        String string = null;
        if (this.mDialogSpecsVector.size() > 0) {
            string = "Dialog-Specs: " + this.mDialogSpecsVector.get(0) + "\n";
        }
        return string;
    }

    public String getCommandSpecsKeyValuePairs() {
        return this.buildKeyValuePairsFromListOfFiles("Command-Specs", this.mCommandSpecsVector);
    }

    public String getCodeFilesKeyValuePairs() {
        return this.buildKeyValuePairsFromListOfFiles("Code-Files", this.mCodeFilesVector);
    }

    public String getMiscFilesKeyValuePairs() {
        return this.buildKeyValuePairsFromListOfFiles("Misc-Files", this.mMiscFilesVector);
    }

    public String getSummaryKeyValuePairs() {
        String string = "Summary: " + this.mSummaryField.getText() + "\n";
        return string;
    }

    public String getDescriptionKeyValuePairs() {
        String string = "Description: " + this.mDescField.getText() + "\n";
        return string;
    }

    public String getAuthorKeyValuePairs() {
        String string = "Author: " + this.mAuthorField.getText() + "\n";
        return string;
    }

    public String getVersionKeyValuePairs() {
        String string = null;
        string = "Version: " + this.mVersionField.getText() + "\n";
        return string;
    }

    public String getProductVersionKeyValuePairs() {
        String string = "Product-Version: " + this.mVersionCombo.getSelectedItem().toString() + "\n";
        return string;
    }

    private String buildKeyValuePairsFromListOfFiles(String string, Vector<String> vector) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("");
        if (vector.size() > 0) {
            stringBuffer.append(string).append(": ");
            object = vector.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                stringBuffer.append(string2).append(",");
            }
            stringBuffer = stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        return ((String)(object = stringBuffer.toString())).equals("") ? null : object;
    }

    public Vector<String> getDialogSpecs() {
        return this.mDialogSpecsVector;
    }

    public Vector<String> getCommandSpecs() {
        return this.mCommandSpecsVector;
    }

    public Vector<String> getCodeFiles() {
        return this.mCodeFilesVector;
    }

    public Vector<String> getMiscFiles() {
        return this.mMiscFilesVector;
    }

    public Vector<String> getAllFiles() {
        return this.mAllFilesVector;
    }

    public String getTargetFileForExtensionBundle() {
        return this.mTargetFileTextField.getText();
    }

    public JTextArea getInfoTextArea() {
        return this.mInfoTextArea;
    }

    public JTextField getNameField() {
        return this.mNameField;
    }

    public SerializableEditableList getFilesList() {
        return this.mFilesList;
    }

    public JTextField getSummaryField() {
        return this.mSummaryField;
    }

    public CETextArea getDescField() {
        return this.mDescField;
    }

    public JTextField getAuthorField() {
        return this.mAuthorField;
    }

    public JTextField getVersionField() {
        return this.mVersionField;
    }

    public JComboBox getVersionCombo() {
        return this.mVersionCombo;
    }

    public FileTextField getTargetFileTextField() {
        return this.mTargetFileTextField;
    }

    public class NoCRLFTextArea
    extends CETextArea {
        public void paste() {
            super.paste();
            String string = this.getText();
            string = string.replaceAll(LINE_SEPERATOR, " ");
            if (string.contains("\n")) {
                string = string.replaceAll("\n", " ");
            } else if (string.contains("\r")) {
                string = string.replaceAll("\r", " ");
            }
            this.setText(string);
        }
    }

    private class TextFieldListener
    implements DocumentListener {
        private TextFieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ExtensionBundleRequiredTab.this.mParent.enableUIItems();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ExtensionBundleRequiredTab.this.mParent.enableUIItems();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            ExtensionBundleRequiredTab.this.mParent.enableUIItems();
        }
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JCheckBox) {
                ExtensionBundleRequiredTab.this.mParent.enableUIItems();
            }
        }
    }
}

