/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.bundle_install_utility;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.ui.controls.DefaultListCellEditor;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SerializableEditableList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_install_utility.ExtensionBundleDlg;
import com.spss.java_client.ui.dialogs.common.BaseSpssTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.TextAttribute;
import java.io.File;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class ExtensionBundleOptionalTab
extends BaseSpssTab
implements ActionListener,
KeyListener,
ListDataListener,
ListSelectionListener {
    public static final String OPTIONAL_RELEASE_DATE_TEXT_KEY = "IDK_RELEASE_DATE_TEXT";
    public static final String OPTIONAL_LINKS_TEXT_KEY = "IDK_LINKS_TEXT";
    public static final String OPTIONAL_CATEGORIES_TEXT_KEY = "IDK_CATEGORIES_TEXT";
    public static final String OPTIONAL_R_PACKAGES_LIST_KEY = "IDK_R_PACKAGES_LIST";
    public static final String OPTIONAL_PYTHON_MODULES_LIST_KEY = "IDK_PYTHON_MODULES_LIST";
    public static final String OPTIONAL_TRANSLATION_CATALOGUES_FOLDER_TEXT_KEY = "IDK_TRANSLATION_CATALOGUES_FOLDER_TEXT";
    public static final String OPTIONAL_PYTHON_CHECKBOX_KEY = "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_PYTHON_CHECKBOX";
    public static final String OPTIONAL_R_CHECKBOX_KEY = "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_R_CHECKBOX";
    static final String OPTIONAL_TCF_DIALOG_FILTER = "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_TCF_DIALOG_FILTER";
    static final String OPTIONAL_TCF_DIALOG_EXTENSION = "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_TCF_DIALOG_EXTENSION";
    static final String OPTIONAL_TCF_DIALOG_TITLE = "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_TCF_DIALOG_TITLE";
    private JLabel mReleaseDateLabel;
    private JTextField mReleaseDateField;
    private JLabel mLinksLabel;
    private JTextField mLinksField;
    private JLabel mCategoriesLabel;
    private JTextField mCategoriesField;
    private JCheckBox mPythonCheckbox;
    private JCheckBox mRCheckbox;
    private JLabel mRPackagesListLabel;
    private SerializableEditableList mRPackagesList;
    private JScrollPane mRPackagesListScrollPane;
    private JLabel mPythonModulesListLabel;
    private SerializableEditableList mPythonModulesList;
    private JScrollPane mPythonModulesListScrollPane;
    private JLabel mTranslationCataloguesFolderLabel;
    private FileTextField mTranslationCataloguesFolderText;
    private JButton mBrowseButton;
    ExtensionBundleDlg mParent;

    public ExtensionBundleOptionalTab(ExtensionBundleDlg extensionBundleDlg, boolean bl) {
        super(extensionBundleDlg, false);
        this.mParent = extensionBundleDlg;
        this.initPanel();
        if (bl) {
            this.setDefaults();
        }
        this.mReleaseDateField.requestFocusInWindow();
    }

    protected void loadDialogState() {
        DialogDataModel dialogDataModel = this.mParent.getDialogDataModel();
        String string = dialogDataModel.getString(OPTIONAL_TRANSLATION_CATALOGUES_FOLDER_TEXT_KEY);
        if (string != null) {
            this.mTranslationCataloguesFolderText.setText(string);
        }
        if (this.mParent.getInEditMode().booleanValue()) {
            this.maybeAppendEmptyItemToList(this.mRPackagesList, (DefaultListModel)this.mRPackagesList.getModel());
            this.maybeAppendEmptyItemToList(this.mPythonModulesList, (DefaultListModel)this.mPythonModulesList.getModel());
        }
    }

    protected void saveDialogState() {
        if (this.mParent.getInEditMode().booleanValue()) {
            String string = this.mParent.getNameDirectory().getPath();
            String string2 = this.mTranslationCataloguesFolderText.getText();
            if (!string2.contains(File.separator)) {
                this.mTranslationCataloguesFolderText.setText(string + File.separator + string2);
            }
        }
        this.mParent.getDialogDataModel().putString(OPTIONAL_TRANSLATION_CATALOGUES_FOLDER_TEXT_KEY, this.mTranslationCataloguesFolderText.getText());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_optional";
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVariables();
        this.setupPanel();
        this.enableUIItems();
        this.setFocusTraversalPolicy();
    }

    private void initVariables() {
        TextFieldListener textFieldListener = new TextFieldListener();
        this.mReleaseDateField = new JTextField();
        this.mReleaseDateField.getDocument().addDocumentListener(textFieldListener);
        this.mReleaseDateField.setAction(new TextFieldAction(this.mParent, OPTIONAL_RELEASE_DATE_TEXT_KEY));
        this.mReleaseDateField.setPreferredSize(new Dimension(66, this.mReleaseDateField.getMinimumSize().height));
        this.mReleaseDateLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_RELEASE_DATE");
        this.mReleaseDateLabel.setLabelFor(this.mReleaseDateField);
        this.mLinksField = new JTextField();
        if (ComponentState.isBtdRtlOrLtr()) {
            if (ComponentState.getBTD() == 1) {
                this.mLinksField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                this.mLinksField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        }
        this.mLinksField.getDocument().addDocumentListener(textFieldListener);
        this.mLinksField.setAction(new TextFieldAction(this.mParent, OPTIONAL_LINKS_TEXT_KEY));
        this.mLinksField.setPreferredSize(new Dimension(325, this.mLinksField.getMinimumSize().height));
        this.mLinksLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_LINKS");
        this.mLinksLabel.setLabelFor(this.mLinksField);
        this.mCategoriesField = new JTextField();
        if (ComponentState.isBtdRtlOrLtr()) {
            if (ComponentState.getBTD() == 1) {
                this.mCategoriesField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                this.mCategoriesField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        }
        this.mCategoriesField.getDocument().addDocumentListener(textFieldListener);
        this.mCategoriesField.setAction(new TextFieldAction(this.mParent, OPTIONAL_CATEGORIES_TEXT_KEY));
        this.mCategoriesField.setPreferredSize(new Dimension(325, this.mCategoriesField.getMinimumSize().height));
        this.mCategoriesLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_CATEGORIES");
        this.mCategoriesLabel.setLabelFor(this.mCategoriesField);
        this.mPythonCheckbox = DialogUtil.createCheckBox(this.mParent, OPTIONAL_PYTHON_CHECKBOX_KEY, (ActionListener)this);
        this.mRCheckbox = DialogUtil.createCheckBox(this.mParent, OPTIONAL_R_CHECKBOX_KEY, (ActionListener)this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mPythonCheckbox);
        spssButtonGroup.add(this.mRCheckbox);
        int n = 19;
        int n2 = 8;
        this.mPythonModulesList = new SerializableEditableList(OPTIONAL_PYTHON_MODULES_LIST_KEY);
        DefaultListCellEditor defaultListCellEditor = (DefaultListCellEditor)this.mPythonModulesList.getListCellEditor();
        n = defaultListCellEditor.getComponent().getFont().getSize() + n2;
        this.mPythonModulesList.setFixedCellHeight(n);
        this.mPythonModulesList.addListSelectionListener(this);
        this.mPythonModulesList.addKeyListener(this);
        DefaultListModel defaultListModel = (DefaultListModel)this.mPythonModulesList.getModel();
        defaultListModel.addListDataListener(this);
        this.mPythonModulesListScrollPane = new JScrollPane(this.mPythonModulesList);
        this.mPythonModulesListScrollPane.setPreferredSize(new Dimension(75, 102));
        this.mPythonModulesListScrollPane.getVerticalScrollBar().setEnabled(true);
        this.mPythonModulesListLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_PYTHON_MODULES_LIST");
        this.mPythonModulesListLabel.setLabelFor(this.mPythonModulesList);
        this.mRPackagesList = new SerializableEditableList(OPTIONAL_R_PACKAGES_LIST_KEY);
        defaultListCellEditor = (DefaultListCellEditor)this.mRPackagesList.getListCellEditor();
        n = defaultListCellEditor.getComponent().getFont().getSize() + n2;
        this.mRPackagesList.setFixedCellHeight(n);
        this.mRPackagesList.addListSelectionListener(this);
        this.mRPackagesList.addKeyListener(this);
        defaultListModel = (DefaultListModel)this.mRPackagesList.getModel();
        defaultListModel.addListDataListener(this);
        this.mRPackagesListScrollPane = new JScrollPane(this.mRPackagesList);
        this.mRPackagesListScrollPane.setPreferredSize(new Dimension(75, 102));
        this.mRPackagesListScrollPane.getVerticalScrollBar().setEnabled(true);
        this.mRPackagesListLabel = DialogUtil.createLabel(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_R_PACKAGES_LIST");
        this.mRPackagesListLabel.setLabelFor(this.mRPackagesList);
        this.mTranslationCataloguesFolderText = new FileTextField();
        this.mTranslationCataloguesFolderText.setColumns(45);
        this.mTranslationCataloguesFolderText.setEditable(false);
        this.mTranslationCataloguesFolderText.setOpaque(false);
        this.mTranslationCataloguesFolderText.setFocusable(false);
        this.mTranslationCataloguesFolderLabel = new JLabel(this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_TRANSLATION_CATALOGUES_FOLDER"));
        this.mTranslationCataloguesFolderLabel.setLabelFor((Component)((Object)this.mTranslationCataloguesFolderText));
        this.mBrowseButton = DialogUtil.createButton(this.mParent, "IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_BROWSE", this);
    }

    private void setupPanel() {
        this.setLayout(new GridBagLayout());
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        Insets insets2 = (Insets)DialogUtil.getStandardDialogInsets().clone();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.setupInformationalPanel(), gridBagConstraints, 0, 0, 1, 1, n2, new Insets(insets2.top, insets2.left, insets.bottom, insets2.right));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this, this.setupDependenciesPanel(), gridBagConstraints, 0, 1, 1, 1, n2, new Insets(n, insets2.left, insets.bottom, insets2.right));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(this, this.setupTranslationCataloguesFolderPanel(), gridBagConstraints, 0, 2, 1, 1, n2, new Insets(n, insets2.left, insets2.bottom, insets2.right));
    }

    private JPanel setupInformationalPanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(0, n2, n2, insets.right);
        Insets insets3 = new Insets(0, insets.left, n2, n2);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_INFORMATIONAL_FIELDS")));
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mReleaseDateLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mReleaseDateField, gridBagConstraints, 1, 0, 1, 1, n, insets3);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mLinksLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mLinksField, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mCategoriesLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mCategoriesField, gridBagConstraints, 1, 2, 1, 1, n, insets3);
        return jPanel;
    }

    private JPanel setupDependenciesPanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_DEPENDENCIES")));
        jPanel.setLayout(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel, this.mPythonCheckbox, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, n2, insets.bottom, n2));
        DialogUtil.addUsingGBL(jPanel, this.mRCheckbox, gridBagConstraints, 0, 1, 1, 1, n, new Insets(0, n2, insets.bottom, n2));
        DialogUtil.addUsingGBL(jPanel, new JSeparator(), gridBagConstraints, 0, 2, 2, 1, n, new Insets(n2 * 3, n2, n2 * 3, n2));
        DialogUtil.addUsingGBL(jPanel, this.mRPackagesListLabel, gridBagConstraints, 0, 3, 1, 1, n, new Insets(0, n2, insets.bottom, n2 * 3));
        DialogUtil.addUsingGBL(jPanel, this.mPythonModulesListLabel, gridBagConstraints, 1, 3, 1, 1, n, new Insets(0, n2 * 3, insets.bottom, n2));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mRPackagesListScrollPane, gridBagConstraints, 0, 4, 1, 1, n, new Insets(0, n2, n2, n2 * 3));
        DialogUtil.addUsingGBL(jPanel, this.mPythonModulesListScrollPane, gridBagConstraints, 1, 4, 1, 1, n, new Insets(0, n2 * 3, n2, n2));
        return jPanel;
    }

    private JPanel setupTranslationCataloguesFolderPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(0, n, n, insets.right);
        Insets insets3 = new Insets(0, insets.left, n, n);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        int n2 = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mTranslationCataloguesFolderLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        n2 = 25;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTranslationCataloguesFolderText), gridBagConstraints, 1, 0, 1, 1, n2, insets3);
        n2 = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        this.addToComponentOrder(this.mReleaseDateField);
        this.addToComponentOrder(this.mLinksField);
        this.addToComponentOrder(this.mCategoriesField);
        this.addToComponentOrder(this.mPythonCheckbox);
        this.addToComponentOrder(this.mRCheckbox);
        this.addToComponentOrder(this.mRPackagesList);
        this.addToComponentOrder(this.mPythonModulesList);
        this.addToComponentOrder(this.mBrowseButton);
        this.addAllToComponentOrder(new Vector<Object>(Arrays.asList(this.mParent.getCmdButtonPanel().getComponents())));
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    public void setDefaults() {
        this.mReleaseDateField.setText("");
        this.mLinksField.setText("");
        this.mCategoriesField.setText("");
        this.mPythonCheckbox.setSelected(false);
        this.mRCheckbox.setSelected(false);
        ((DefaultListModel)this.mRPackagesList.getModel()).clear();
        this.addListItemAt(this.mRPackagesList, 0, "");
        ((DefaultListModel)this.mPythonModulesList.getModel()).clear();
        this.addListItemAt(this.mPythonModulesList, 0, "");
        this.setPythonAndRSelectionDefaults();
        this.mTranslationCataloguesFolderText.setText("");
        this.setInitialized(true);
    }

    public void setPythonAndRSelectionDefaults() {
        this.mRPackagesList.setSelectedIndex(0);
        this.mPythonModulesList.setSelectedIndex(0);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mRPackagesList.getModel()) {
            this.removeOrTrimListItem(this.mRPackagesList, listDataEvent.getIndex0());
        } else if (listDataEvent.getSource() == this.mPythonModulesList.getModel()) {
            this.removeOrTrimListItem(this.mPythonModulesList, listDataEvent.getIndex0());
        }
    }

    private void removeOrTrimListItem(SerializableEditableList serializableEditableList, int n) {
        boolean bl = false;
        DefaultListModel defaultListModel = (DefaultListModel)serializableEditableList.getModel();
        defaultListModel.removeListDataListener(this);
        String string = this.getListItemAt(serializableEditableList, n);
        if (string.trim().length() == 0) {
            this.removeListItemAt(serializableEditableList, n);
            bl = true;
        } else {
            this.setListItemAt(serializableEditableList, n, string.trim());
        }
        this.maybeAppendEmptyItemToList(serializableEditableList, defaultListModel);
        if (bl) {
            serializableEditableList.setSelectedIndex(n);
        }
        defaultListModel.addListDataListener(this);
    }

    private void removeListItemAt(JList jList, int n) {
        ((DefaultListModel)jList.getModel()).removeElementAt(n);
    }

    private String getListItemAt(JList jList, int n) {
        return jList.getModel().getElementAt(n).toString();
    }

    private void addListItemAt(JList jList, int n, String string) {
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        defaultListModel.add(n, string);
    }

    private void setListItemAt(JList jList, int n, String string) {
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        defaultListModel.setElementAt(string, n);
    }

    private void deleteItemInList(SerializableEditableList serializableEditableList, KeyEvent keyEvent) {
        int n = serializableEditableList.getSelectedIndex();
        if (n >= 0) {
            DefaultListModel defaultListModel = (DefaultListModel)serializableEditableList.getModel();
            defaultListModel.removeListDataListener(this);
            this.removeListItemAt(serializableEditableList, n);
            this.maybeAppendEmptyItemToList(serializableEditableList, defaultListModel);
            serializableEditableList.setSelectedIndex(n);
            defaultListModel.addListDataListener(this);
            keyEvent.consume();
        }
    }

    private void maybeAppendEmptyItemToList(SerializableEditableList serializableEditableList, DefaultListModel defaultListModel) {
        boolean bl = true;
        for (int i = 0; i < defaultListModel.size(); ++i) {
            String string = this.getListItemAt(serializableEditableList, i);
            if (string.trim().length() != 0) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.addListItemAt(serializableEditableList, defaultListModel.size(), "");
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.mRPackagesList && keyEvent.getKeyChar() == '\u007f') {
            this.deleteItemInList(this.mRPackagesList, keyEvent);
        } else if (keyEvent.getSource() == this.mPythonModulesList && keyEvent.getKeyChar() == '\u007f') {
            this.deleteItemInList(this.mPythonModulesList, keyEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mBrowseButton) {
            this.processBrowseButton();
        }
    }

    private void processBrowseButton() {
        String string;
        String string2 = this.getResString(OPTIONAL_TCF_DIALOG_FILTER);
        RemoteFileChooser remoteFileChooser = this.showSelectFolderFileDialog(string2, string = this.getResString(OPTIONAL_TCF_DIALOG_TITLE));
        if (remoteFileChooser != null) {
            String string3 = remoteFileChooser.getSelectedFilePath();
            String string4 = string3.toLowerCase();
            int n = string4.indexOf(this.getResString(OPTIONAL_TCF_DIALOG_EXTENSION));
            if (n == -1) {
                string3 = string3.concat(this.getResString(OPTIONAL_TCF_DIALOG_EXTENSION));
            } else if (string4.substring(n).compareToIgnoreCase(this.getResString(OPTIONAL_TCF_DIALOG_EXTENSION)) != 0) {
                string3 = string3.concat(this.getResString(OPTIONAL_TCF_DIALOG_EXTENSION));
            }
            this.mTranslationCataloguesFolderText.setText(string3);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.mParent.enableUIItems();
        }
    }

    @Override
    protected boolean validateTab() {
        return true;
    }

    private RemoteFileChooser showSelectFolderFileDialog(String string, String string2) {
        OpenFolderChooser openFolderChooser = new OpenFolderChooser(RemoteFileChooser.ChooserType.OpenFolder, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
        openFolderChooser.setDialogTitle(string2);
        openFolderChooser.setFileSelectionMode(1);
        openFolderChooser.setAcceptAllFileFilterUsed(false);
        RefFileFilter refFileFilter = new RefFileFilter(string, "");
        openFolderChooser.setFileFilter((FileFilter)refFileFilter);
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            openFolderChooser.setApproveButtonMnemonic(this.getDlgAccessKey("IDK_OMS_BROWSE_FOLDER_APPROVE_BUTTON_KEY"));
        }
        int n = openFolderChooser.showDialog(this, this.getResString("IDS_OMS_BROWSE_FOLDER_APPROVE_BUTTON_TEXT"));
        openFolderChooser.resetStrings();
        return n == 0 ? openFolderChooser : null;
    }

    boolean isComplete() {
        boolean bl = false;
        if (this.mTranslationCataloguesFolderText.getText().length() > 0) {
            bl = true;
        }
        return bl;
    }

    void enableUIItems() {
    }

    public String getDateKeyValuePairs() {
        String string = null;
        if (this.mReleaseDateField.getText().length() > 0) {
            string = "Date: " + this.mReleaseDateField.getText() + "\n";
        }
        return string;
    }

    public String getLinksKeyValuePairs() {
        String string = null;
        if (this.mLinksField.getText().length() > 0) {
            string = "Links: " + this.mLinksField.getText() + "\n";
        }
        return string;
    }

    public String getCategoriesKeyValuePairs() {
        String string = null;
        if (this.mCategoriesField.getText().length() > 0) {
            string = "Categories: " + this.mCategoriesField.getText() + "\n";
        }
        return string;
    }

    public String getPluginsKeyValuePairs() {
        String string = null;
        if (this.mPythonCheckbox.isSelected() || this.mRCheckbox.isSelected()) {
            string = "Plugins: ";
            String string2 = this.mPythonCheckbox.isSelected() && this.mRCheckbox.isSelected() ? "Python,R\n" : (this.mPythonCheckbox.isSelected() ? "Python\n" : "R\n");
            string = string + string2;
        }
        return string;
    }

    public String getRPackagesKeyValuePairs() {
        return this.buildKeyValuePairsFromList("R-Packages", this.mRPackagesList);
    }

    public String getPythonModulesKeyValuePairs() {
        return this.buildKeyValuePairsFromList("Python-Modules", this.mPythonModulesList);
    }

    public String getTranslationCataloguesKeyValuePairs() {
        String string = null;
        if (this.mTranslationCataloguesFolderText.getText().length() > 0) {
            File file;
            String string2 = this.getTranslationCataloguesPath();
            if (this.mParent.getInEditMode().booleanValue() && !string2.contains(File.separator)) {
                string2 = this.mParent.getNameDirectory() + File.separator + string2;
            }
            if ((file = new File(string2)).exists()) {
                string = "Translation-Catalogues: " + file.getName() + "\n";
            }
        }
        return string;
    }

    public String getTranslationCataloguesPath() {
        return this.mTranslationCataloguesFolderText.getText();
    }

    public FileTextField getTranslationCatalogues() {
        return this.mTranslationCataloguesFolderText;
    }

    private String buildKeyValuePairsFromList(String string, SerializableEditableList serializableEditableList) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer("");
        DefaultListModel defaultListModel = (DefaultListModel)serializableEditableList.getModel();
        int n = defaultListModel.size() - 1;
        if (n > 0) {
            stringBuffer.append(string).append(": ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(this.getListItemAt(serializableEditableList, i)).append(",");
            }
            stringBuffer = stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        return (string2 = stringBuffer.toString()).equals("") ? null : string2;
    }

    public class OpenFolderChooser
    extends RemoteFileChooser {
        public OpenFolderChooser(RemoteFileChooser.ChooserType chooserType, RemoteFileChooser.ChooserOption chooserOption, String string, boolean bl) {
            super(chooserType, chooserOption, string, bl);
        }

        @Override
        protected void installStrings() {
            super.installStrings();
            UIManager.getDefaults().put("FileChooser.lookInLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_IN_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.filesOfTypeLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_FILES_OF_TYPE_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.folderNameLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_OPEN_FOLDER_LABEL_TEXT"));
        }

        public void resetStrings() {
            UIManager.getDefaults().put("FileChooser.lookInLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_LOOK_IN_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.filesOfTypeLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_FILES_OF_TYPE_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.folderNameLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_FOLDER_LABEL_TEXT"));
        }
    }

    private class TextFieldListener
    implements DocumentListener {
        private TextFieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ExtensionBundleOptionalTab.this.mParent.enableUIItems();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ExtensionBundleOptionalTab.this.mParent.enableUIItems();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            ExtensionBundleOptionalTab.this.mParent.enableUIItems();
        }
    }
}

