/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.bundle_install_utility;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ExtensionBundleManifestHelper {
    private File mExtensionZipFile;
    Attributes mAttributes;
    ResourceBundle mResBundle;
    private boolean bPythonPluginInstalled = false;
    private boolean bRPluginInstalled = false;
    private static final String UNDER_SCORE = "_";
    private static final String EMPTY_STRING = "";
    private Set<String> mDialogSpecsSet = new HashSet<String>();
    private Set<String> mCommandSpecsSet = new HashSet<String>();
    private Set<String> mCodeFilesSet = new HashSet<String>();
    private Set<String> mMiscFilesSet = new HashSet<String>();
    private Set<String> mRLocationSet = new HashSet<String>();
    private Set<String> mPythonModulesSet = new HashSet<String>();

    public ExtensionBundleManifestHelper() throws IOException {
        this(null);
    }

    public ExtensionBundleManifestHelper(File file) throws IOException {
        if (file != null) {
            this.mExtensionZipFile = file;
            this.init();
            try {
                JarFile jarFile = new JarFile(this.mExtensionZipFile);
                Manifest manifest = jarFile.getManifest();
                this.mAttributes = manifest.getMainAttributes();
                this.initPluginsInstalledState();
                this.fillDialogSpecsSet();
                this.fillCommandSpecsSet();
                this.fillCodeFilesSet();
                this.fillMiscFilesSet();
                this.fillRLocactionSet();
                this.fillPythonModulesSet();
                jarFile.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw iOException;
            }
        }
    }

    private void init() {
        this.bPythonPluginInstalled = false;
        this.bRPluginInstalled = false;
        this.mDialogSpecsSet.clear();
        this.mCommandSpecsSet.clear();
        this.mCodeFilesSet.clear();
        this.mMiscFilesSet.clear();
        this.mRLocationSet.clear();
        this.mPythonModulesSet.clear();
    }

    public void initPluginsInstalledState() {
        String string = this.getPlugins();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("Python")) {
                    this.bPythonPluginInstalled = true;
                    continue;
                }
                if (!string2.equals("R")) continue;
                this.bRPluginInstalled = true;
            }
        }
    }

    public boolean fillDialogSpecsSet() {
        return this.fillSet(this.mDialogSpecsSet, "Dialog-Specs");
    }

    public boolean fillCommandSpecsSet() {
        return this.fillSet(this.mCommandSpecsSet, "Command-Specs");
    }

    public boolean fillCodeFilesSet() {
        return this.fillSet(this.mCodeFilesSet, "Code-Files");
    }

    public boolean fillMiscFilesSet() {
        return this.fillSet(this.mMiscFilesSet, "Misc-Files");
    }

    public boolean fillRLocactionSet() {
        return this.fillSet(this.mRLocationSet, "R-Packages");
    }

    public boolean fillPythonModulesSet() {
        return this.fillSet(this.mPythonModulesSet, "Python-Modules");
    }

    private boolean fillSet(Set<String> set, String string) {
        boolean bl = false;
        String string2 = this.mAttributes.getValue(string);
        if (string2 != null && !string2.equals(EMPTY_STRING)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                set.add(string3);
            }
            bl = true;
        }
        return bl;
    }

    public Attributes getAttributes() {
        return this.mAttributes;
    }

    public String getBundleName() {
        return this.mAttributes.getValue("Name");
    }

    public String getSummary() {
        String string = this.getTranslatedInfoFromProperties("Summary");
        if (string == null) {
            string = this.mAttributes.getValue("Summary");
        }
        return string;
    }

    public String getDescription() {
        String string = this.getTranslatedInfoFromProperties("Description");
        if (string == null) {
            string = this.mAttributes.getValue("Description");
        }
        return string;
    }

    public String getAuthor() {
        return this.mAttributes.getValue("Author");
    }

    public String getVersion() {
        return this.mAttributes.getValue("Version");
    }

    public String getProductVersion() {
        return this.mAttributes.getValue("Product-Version");
    }

    public String getMaxStatsVersion() {
        return this.mAttributes.getValue("Product-Version-Maximum");
    }

    public String getTargetFilePath() {
        return this.mExtensionZipFile.getAbsolutePath();
    }

    public String getDate() {
        return this.mAttributes.getValue("Date");
    }

    public String getLinks() {
        return this.mAttributes.getValue("Links");
    }

    public String getCategories() {
        return this.mAttributes.getValue("Categories");
    }

    public String getPlugins() {
        return this.mAttributes.getValue("Plugins");
    }

    public String getTranslationCataloguesPath() {
        return this.mAttributes.getValue("Translation-Catalogues");
    }

    public boolean isPythonPluginInstalled() {
        return this.bPythonPluginInstalled;
    }

    public boolean isRPluginInstalled() {
        return this.bRPluginInstalled;
    }

    public Set<String> getDialogSpecsSet() {
        return this.mDialogSpecsSet;
    }

    public Set<String> getCommandSpecsSet() {
        return this.mCommandSpecsSet;
    }

    public Set<String> getCodeFilesSet() {
        return this.mCodeFilesSet;
    }

    public Set<String> getMiscFilesSet() {
        return this.mMiscFilesSet;
    }

    public Set<String> getRLocationSet() {
        return this.mRLocationSet;
    }

    public Set<String> getPythonModulesSet() {
        return this.mPythonModulesSet;
    }

    public String getEnglishSummary() {
        return this.mAttributes.getValue("Summary");
    }

    public String getEnglishDescription() {
        return this.mAttributes.getValue("Description");
    }

    public String getPythonVersion() {
        return this.mAttributes.getValue("Python-Version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTranslatedInfoFromProperties(String string) {
        String string2 = null;
        String string3 = Locale.getDefault().toString();
        String string4 = this.getBundleName().replace(' ', '_');
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(this.mExtensionZipFile));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String string5 = zipEntry.getName();
                if (string5.contains(string3) && string5.contains(string4) && string5.contains(".properties")) {
                    PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(zipInputStream);
                    string2 = propertyResourceBundle.getString(string);
                    propertyResourceBundle.clearCache();
                    break;
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (IOException iOException) {
            string2 = null;
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string2;
    }
}

