/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.bundle_install_utility;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_install_utility.ExtensionBundleOptionalTab;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_install_utility.ExtensionBundleRequiredTab;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer.ExtensionBundleHelper;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSpssTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.file.SpssFile;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.util.PASWFileUtil;
import com.spss.uitools.util.StreamCopier;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExtensionBundleDlg
extends BaseDialog
implements ChangeListener {
    public static final String NAME_KEY = "Name";
    public static final String DIALOG_SPECS_KEY = "Dialog-Specs";
    public static final String COMMAND_SPECS_KEY = "Command-Specs";
    public static final String CODE_FILES_KEY = "Code-Files";
    public static final String MISC_FILES_KEY = "Misc-Files";
    public static final String SUMMARY_KEY = "Summary";
    public static final String DESCRIPTION_KEY = "Description";
    public static final String AUTHOR_KEY = "Author";
    public static final String VERSION_KEY = "Version";
    public static final String PRODUCT_VERSION_KEY = "Product-Version";
    public static final String PRODUCT_VERSION_MAX_KEY = "Product-Version-Maximum";
    public static final String DATE_KEY = "Date";
    public static final String LINKS_KEY = "Links";
    public static final String CATEGORIES_KEY = "Categories";
    public static final String PLUGINS_KEY = "Plugins";
    public static final String R_PACKAGES_KEY = "R-Packages";
    public static final String PYTHON_MODULES_KEY = "Python-Modules";
    public static final String TRANSLATION_CATALOGUES_KEY = "Translation-Catalogues";
    public static final String PYTHON_VERSION_KEY = "Python-Version";
    static final String EDIT_READING_SPE_MSG = "ERR_EDIT_EXTENSION_BUNDLE_READING_SPE_MSG";
    static final String EDIT_SAVING_SPE_TOO_TEMP_LOC_MSG = "ERR_EDIT_EXTENSION_BUNDLE_SAVING_SPE_TOO_TEMP_LOC_MSG";
    protected DialogDataModel mDialogDataModel = new DialogDataModel();
    private JTabbedPane mTabbedPane;
    private ExtensionBundleRequiredTab mRequiredTab;
    private ExtensionBundleOptionalTab mOptionalTab;
    private JButton mSaveButton;
    private JButton mCancelButton;
    private boolean bHaveWrittenTranslationCataloguesRelPath = false;
    private File mNameDirectory = null;
    private ExtensionBundleHelper mExtensionBundleHelper;
    private Boolean inEditMode = false;
    private Boolean mWasSaved = false;

    public ExtensionBundleDlg(SpssFrame spssFrame) {
        super((JFrame)spssFrame, false, ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), UtilitiesResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_EXTENSION_BUNDLE_TITLE"));
        this.pack();
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize(this.getIActionKey());
        if (dimension != null) {
            this.setSize(dimension);
        }
        this.setLocationRelativeTo(spssFrame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ActionEvent actionEvent = new ActionEvent(ExtensionBundleDlg.this.mCancelButton, 1001, ResUtil.getCommonDlgString("IDS_CANCEL"));
                ExtensionBundleDlg.this.mCancelButton.getAction().actionPerformed(actionEvent);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){
            final WindowEvent closingEvent;
            {
                this.closingEvent = new WindowEvent((Window)((Object)ExtensionBundleDlg.this), 201);
            }

            @Override
            public void run() {
                if (ExtensionBundleDlg.this.isDisplayable()) {
                    if (ExtensionBundleDlg.this.inEditMode.booleanValue()) {
                        if (ExtensionBundleDlg.this.initDialogDataModel()) {
                            ExtensionBundleDlg.this.loadDialogState();
                        } else {
                            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(this.closingEvent);
                        }
                    } else {
                        ProcedureDlgMgr.getMgr().loadPersistentState(ExtensionBundleDlg.this.getIActionKey(), ExtensionBundleDlg.this.getDialogDataModel());
                        ExtensionBundleDlg.this.loadDialogState();
                    }
                    ExtensionBundleDlg.this.mOptionalTab.setPythonAndRSelectionDefaults();
                }
            }
        });
    }

    public ExtensionBundleDlg(SpssFrame spssFrame, ExtensionBundleHelper extensionBundleHelper) {
        this(spssFrame);
        this.inEditMode = true;
        this.setTitle(this.getResString("IDS_EXTENSION_BUNDLE_EDIT_TITLE"));
        this.mExtensionBundleHelper = extensionBundleHelper;
    }

    protected void loadDialogState() {
        BaseProcedureDialog.loadState(this.getDialogDataModel(), (Container)((Object)this), BaseProcedureDialog.NameLabelOption.no_override);
        this.mRequiredTab.loadDialogState();
        this.mOptionalTab.loadDialogState();
    }

    protected void saveDialogState() {
        this.mRequiredTab.saveDialogState();
        this.mOptionalTab.saveDialogState();
        BaseProcedureDialog.saveState(this.getDialogDataModel(), (Container)((Object)this));
        ProcedureDlgMgr.getMgr().savePersistentState(this.getIActionKey(), this.getDialogDataModel());
        ProcedureDlgMgr.getMgr().addRecallItem(this.getTitle(), this.getIActionKey());
    }

    public DialogDataModel getDialogDataModel() {
        return this.mDialogDataModel;
    }

    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.setupTabbedPane(jPanel);
        for (int i = 0; i < this.mTabbedPane.getTabCount(); ++i) {
            this.mTabbedPane.setSelectedIndex(i);
        }
        this.mTabbedPane.setSelectedIndex(0);
        this.pack();
    }

    public void dispose() {
        super.dispose();
    }

    public String getIActionKey() {
        return "utilities_create_extension_bundle";
    }

    private void setTabPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.addAll(this.mRequiredTab.getComponentOrder());
        vector.addAll(this.mOptionalTab.getComponentOrder());
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    public void doHelp() {
        BaseSpssTab baseSpssTab = (BaseSpssTab)this.mTabbedPane.getSelectedComponent();
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, baseSpssTab.getDialogHelpID());
    }

    public boolean initDialogDataModel() {
        String string;
        boolean bl = false;
        String string2 = string = this.mExtensionBundleHelper != null ? this.mExtensionBundleHelper.getTargetFilePath() : null;
        if (string != null && new File(string).exists() && this.createNameDirectoryInTempDirectory() && this.writeCodeFilesToDirectory() && this.writeCommandFilesToDirectory() && this.writeMiscFilesToDirectory() && this.writeSpdFileToDirectory() && this.unzipTranslationCataloguesDirectory()) {
            this.preLoadDialogDataModel();
            bl = true;
        }
        if (!bl) {
            this.initDialogDataModelFailed(string);
        }
        return bl;
    }

    private void initDialogDataModelFailed(String string) {
        if (this.mNameDirectory != null) {
            SpssFile.recursiveDelete((File)this.mNameDirectory);
            this.mNameDirectory = null;
        }
        if (string == null) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), CoreResUtil.getString((String)EDIT_READING_SPE_MSG), VersionInfo.getAppVersionString());
        } else {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), CoreResUtil.getString((String)EDIT_SAVING_SPE_TOO_TEMP_LOC_MSG), VersionInfo.getAppVersionString());
        }
    }

    private void preLoadDialogDataModel() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.mExtensionBundleHelper.getDialogSpecsSet());
        hashSet.addAll(this.mExtensionBundleHelper.getCommandSpecsSet());
        hashSet.addAll(this.mExtensionBundleHelper.getCodeFilesSet());
        hashSet.addAll(this.mExtensionBundleHelper.getMiscFilesSet());
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String object2 : hashSet) {
            hashSet2.add(object2);
        }
        String string = this.getResString("IDS_EXTENSION_BUNDLE_REQUIRED_TAB_VERSION_NUMBERS");
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string.split(",")));
        dialogDataModel.putString("IDK_NAME_TEXT", this.mExtensionBundleHelper.getName());
        dialogDataModel.putArray("IDK_EXTENSION_BUNDLE_REQUIRED_TAB_FILES", hashSet2.toArray());
        dialogDataModel.putString("IDK_SUMMARY_TEXT", this.mExtensionBundleHelper.getSummary());
        dialogDataModel.putString("IDK_DESC_TEXT", this.mExtensionBundleHelper.getDescription());
        dialogDataModel.putString("IDK_AUTHOR_TEXT", this.mExtensionBundleHelper.getAuthor());
        dialogDataModel.putString("IDK_VERSION_TEXT", this.mExtensionBundleHelper.getVersion());
        dialogDataModel.putInteger("IDK_VERSION_COMBO", arrayList.indexOf(this.mExtensionBundleHelper.getStatsVersion()));
        dialogDataModel.putString("IDK_TARGET_FILE_TEXT", this.mExtensionBundleHelper.getTargetFilePath());
        dialogDataModel.putString("IDK_RELEASE_DATE_TEXT", this.mExtensionBundleHelper.getReleaseDate());
        dialogDataModel.putString("IDK_LINKS_TEXT", this.mExtensionBundleHelper.getLinks());
        dialogDataModel.putString("IDK_CATEGORIES_TEXT", this.mExtensionBundleHelper.getCategories());
        dialogDataModel.putBoolean("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_PYTHON_CHECKBOX", this.mExtensionBundleHelper.requiresPython());
        dialogDataModel.putBoolean("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_R_CHECKBOX", this.mExtensionBundleHelper.requiresR());
        if (this.mExtensionBundleHelper.getRLocationSet().isEmpty()) {
            dialogDataModel.putArray("IDK_R_PACKAGES_LIST", new String[]{""});
        } else {
            dialogDataModel.putArray("IDK_R_PACKAGES_LIST", this.mExtensionBundleHelper.getRLocationSet().toArray());
        }
        if (this.mExtensionBundleHelper.getPythonModulesSet().isEmpty()) {
            dialogDataModel.putArray("IDK_PYTHON_MODULES_LIST", new String[]{""});
        } else {
            dialogDataModel.putArray("IDK_PYTHON_MODULES_LIST", this.mExtensionBundleHelper.getPythonModulesSet().toArray());
        }
        dialogDataModel.putString("IDK_TRANSLATION_CATALOGUES_FOLDER_TEXT", this.mExtensionBundleHelper.getTranslationCataloguesPath());
    }

    private boolean createNameDirectoryInTempDirectory() {
        boolean bl = false;
        try {
            String string = PrefsMgr.getPrefsMgr().getTempPath();
            File file = PASWFileUtil.createTempFile((String)"spss", (String)"", (File)new File(string));
            if (file != null && file.delete()) {
                bl = file.mkdir();
            }
            if (bl) {
                this.mNameDirectory = file;
                this.mNameDirectory.deleteOnExit();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }

    private boolean writeCodeFilesToDirectory() {
        return this.mExtensionBundleHelper.writeFilesToDirectory(this.mExtensionBundleHelper.getCodeFilesSet(), this.mNameDirectory);
    }

    private boolean writeCommandFilesToDirectory() {
        return this.mExtensionBundleHelper.writeFilesToDirectory(this.mExtensionBundleHelper.getCommandSpecsSet(), this.mNameDirectory);
    }

    private boolean writeSpdFileToDirectory() {
        return this.mExtensionBundleHelper.writeFilesToDirectory(this.mExtensionBundleHelper.getDialogSpecsSet(), this.mNameDirectory);
    }

    private boolean writeMiscFilesToDirectory() {
        return this.mExtensionBundleHelper.writeFilesToDirectory(this.mExtensionBundleHelper.getMiscFilesSet(), this.mNameDirectory);
    }

    private boolean unzipTranslationCataloguesDirectory() {
        return this.mExtensionBundleHelper.unzipTranslationCataloguesDirectory(this.mNameDirectory);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        this.mSaveButton = new JButton(new SaveAction());
        this.mSaveButton.setEnabled(false);
        JButton jButton = new JButton(new ResetAction());
        this.mCancelButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton((Action)this.createHelpAction());
        if (UIToolDialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                DialogUtil.setupMacHelpButton(jButton2);
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mSaveButton, gridBagConstraints, 4, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mSaveButton);
                jPanel.add(jButton);
                jPanel.add(this.mCancelButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mSaveButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mCancelButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mSaveButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    void enableUIItems() {
        if (this.mRequiredTab != null) {
            this.mRequiredTab.enableUIItems();
        }
        if (this.mOptionalTab != null) {
            this.mOptionalTab.enableUIItems();
        }
        this.enableSaveButton();
    }

    private boolean enableSaveButton() {
        boolean bl = this.mRequiredTab.isComplete();
        this.mSaveButton.setEnabled(bl);
        return bl;
    }

    private void addTab(String string, BaseSpssTab baseSpssTab) {
        this.mTabbedPane.add(string, baseSpssTab);
    }

    private void setupTabbedPane(JPanel jPanel) {
        this.mTabbedPane = new JTabbedPane();
        this.mTabbedPane.setFocusable(true);
        this.mTabbedPane.addChangeListener(this);
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ExtensionBundleDlg.this.mTabbedPane.repaint();
            }
        };
        this.mTabbedPane.addFocusListener(focusAdapter);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ExtensionBundleDlg.this.mTabbedPane.requestFocusInWindow();
            }
        };
        this.mTabbedPane.addMouseListener(mouseAdapter);
        this.mTabbedPane.setTabLayoutPolicy(0);
        this.mRequiredTab = new ExtensionBundleRequiredTab(this, false);
        this.mRequiredTab.setDefaults();
        this.mTabbedPane.addTab(this.getResString("IDS_EXTENSION_BUNDLE_REQUIRED_TAB_TITLE"), this.mRequiredTab);
        this.mOptionalTab = new ExtensionBundleOptionalTab(this, true);
        this.mOptionalTab.setDefaults();
        this.mTabbedPane.addTab(this.getResString("IDS_EXTENSION_BUNDLE_OPTIONAL_TAB_TITLE"), this.mOptionalTab);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, 0, 0);
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTabbedPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createExtensionPackage() {
        File[] fileArray;
        Object object;
        boolean bl = true;
        File file = new File(this.mRequiredTab.getTargetFileForExtensionBundle());
        PesFile pesFile = PES_Repository.getPesFile((String)file.getAbsolutePath());
        if (pesFile != null) {
            object = new File(PrefsMgr.getPrefsMgr().getTempPath());
            try {
                file = PASWFileUtil.createTempFile((String)"rep", (String)"", (File)object);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        object = null;
        try {
            String string2;
            int n;
            Object object2;
            if (file.exists()) {
                object2 = String.format(CoreResUtil.getString((String)"ERR_FILE_EXISTS_WARNING"), file.getName());
                n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), (String)object2, (String)(fileArray = VersionInfo.getAppVersionString()), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION);
                if (n == 2) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (!PASWFileUtil.isWritable((String)file.getAbsolutePath()) && !file.delete()) {
                    object2 = String.format(CoreResUtil.getString((String)"ERR_FILE_READ_ONLY_FILE_MESSAGE"), file.getName());
                    SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), (String)object2, (String)fileArray, SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
                    boolean bl3 = false;
                    return bl3;
                }
            }
            object2 = new FileOutputStream(file, false);
            object = new JarOutputStream((OutputStream)object2);
            ((ZipOutputStream)object).setMethod(0);
            this.saveManifestToJar((JarOutputStream)object);
            fileArray = new File[this.mRequiredTab.getAllFiles().size()];
            n = 0;
            for (String string2 : this.mRequiredTab.getAllFiles()) {
                fileArray[n++] = new File(string2);
            }
            this.saveFilesToJar((JarOutputStream)object, fileArray);
            String string3 = this.mNameDirectory + File.separator + "dWTermsOfUse" + File.separator + "dWTermsOfUse.html";
            if (new File(string3).isFile()) {
                this.jarDirectory((JarOutputStream)object, this.mNameDirectory + File.separator + "dWTermsOfUse", "dWTermsOfUse");
            }
            if ((string2 = this.mOptionalTab.getTranslationCataloguesPath()) != null && string2.length() > 0) {
                if (this.getInEditMode().booleanValue() && !string2.contains(File.separator)) {
                    string2 = this.mNameDirectory + File.separator + string2;
                    this.mOptionalTab.getTranslationCatalogues().setText(string2);
                }
                File file2 = new File(string2);
                this.jarDirectory((JarOutputStream)object, string2, file2.getName());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        finally {
            if (object != null) {
                try {
                    ((ZipOutputStream)object).close();
                }
                catch (IOException iOException) {}
            }
        }
        if (pesFile == null) return bl;
        int n = PES_Repository.MapFilterToMimeType((String)"(*.spe)");
        String string = PES_Repository.StoreToPES((File)file, (PesFile)pesFile, (int)n, (String)(fileArray = ComponentState.getCurrentCharset().displayName()));
        if (string != null && string.length() > 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
            bl = false;
        }
        PES_Repository.removeFromPesCache((File)file);
        return bl;
    }

    private void saveManifestToJar(JarOutputStream jarOutputStream) throws IOException {
        String string = "META-INF/MANIFEST.MF";
        JarEntry jarEntry = new JarEntry(string);
        StringBuffer stringBuffer = new StringBuffer();
        this.createManifestContents(stringBuffer);
        String string2 = stringBuffer.toString();
        byte[] byArray = string2.getBytes("UTF-8");
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        jarEntry.setSize(byArray.length);
        jarEntry.setCrc(cRC32.getValue());
        jarOutputStream.putNextEntry(jarEntry);
        jarOutputStream.write(byArray);
        jarOutputStream.closeEntry();
    }

    private void saveFilesToJar(JarOutputStream jarOutputStream, File[] fileArray) throws Exception {
        for (File file : fileArray) {
            Object object;
            Object object2;
            Object object3;
            PesFile pesFile = PES_Repository.getPesFile((String)file.getAbsolutePath());
            if (pesFile != null) {
                object3 = PES_Repository.RetrieveFromPES((PesFile)pesFile);
                file = pesFile.getCacheFile();
                if (file == null) {
                    if (object3 == null || ((String)object3).length() <= 0) continue;
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), (String)object3, VersionInfo.getAppVersionString());
                    continue;
                }
            }
            if (file.isFile()) {
                object3 = new FileInputStream(file);
                object2 = new ByteArrayOutputStream();
                StreamCopier.copyStream((InputStream)object3, (OutputStream)object2);
                object = ((ByteArrayOutputStream)object2).toByteArray();
                if (((byte[])object).length <= 0) {
                    throw new Exception("Can't read input bytes");
                }
                CRC32 cRC32 = new CRC32();
                cRC32.update((byte[])object);
                JarEntry jarEntry = new JarEntry(file.getName());
                jarEntry.setSize(((Object)object).length);
                jarEntry.setCrc(cRC32.getValue());
                jarOutputStream.putNextEntry(jarEntry);
                jarOutputStream.write((byte[])object);
                jarOutputStream.closeEntry();
            } else if (file.isDirectory()) {
                object3 = new byte[0];
                object2 = new CRC32();
                object2.update((byte[])object3);
                object = new JarEntry(file.getName() + "/");
                ((ZipEntry)object).setSize(0L);
                ((ZipEntry)object).setCrc(((CRC32)object2).getValue());
                jarOutputStream.putNextEntry((ZipEntry)object);
                jarOutputStream.closeEntry();
            }
            if (pesFile == null) continue;
            PES_Repository.removeFromPesCache((File)file);
        }
    }

    public void zipDir(String string, ZipOutputStream zipOutputStream) {
        try {
            File file = new File(string);
            String[] stringArray = file.list();
            byte[] byArray = new byte[2156];
            int n = 0;
            for (String string2 : stringArray) {
                Object object;
                File file2 = new File(file, string2);
                if (file2.isDirectory()) {
                    object = file2.getPath();
                    this.zipDir((String)object, zipOutputStream);
                    continue;
                }
                object = new FileInputStream(file2);
                ZipEntry zipEntry = new ZipEntry(file2.getPath());
                zipOutputStream.putNextEntry(zipEntry);
                while ((n = ((FileInputStream)object).read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                ((FileInputStream)object).close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jarDirectory(JarOutputStream jarOutputStream, String string, String string2) {
        File file = new File(string);
        String[] stringArray = file.list();
        Vector<String> vector = this.getFiles(string, stringArray);
        File[] fileArray = new File[vector.size()];
        int n = 0;
        for (String string3 : vector) {
            fileArray[n++] = new File(string3);
        }
        if (!this.bHaveWrittenTranslationCataloguesRelPath) {
            try {
                this.bHaveWrittenTranslationCataloguesRelPath = true;
                byte[] iOException = new byte[]{};
                CRC32 cRC32 = new CRC32();
                cRC32.update(iOException);
                JarEntry jarEntry = new JarEntry(string2 + "/");
                jarEntry.setSize(0L);
                jarEntry.setCrc(cRC32.getValue());
                jarOutputStream.putNextEntry(jarEntry);
                jarOutputStream.closeEntry();
            }
            catch (IOException exception) {
                this.bHaveWrittenTranslationCataloguesRelPath = false;
                exception.printStackTrace();
                return;
            }
        }
        try {
            for (File file2 : fileArray) {
                Object object;
                Object object2;
                Object object3;
                String string4;
                if (file2.isFile() && !file2.isHidden()) {
                    Object object4;
                    String string5;
                    Object object5;
                    Object object6;
                    Closeable closeable;
                    string4 = Locale.getDefault().toString();
                    object3 = file2.getAbsolutePath();
                    if (((String)object3).contains((String)(object2 = File.separator) + string4 + (String)object2) && ((String)object3).endsWith(".properties")) {
                        object = new Properties();
                        closeable = new FileInputStream((String)object3);
                        ((Properties)object).load((InputStream)closeable);
                        ((InputStream)closeable).close();
                        object6 = new BufferedReader(new InputStreamReader(new FileInputStream((String)object3)));
                        object5 = new StringBuilder();
                        string5 = null;
                        while ((string5 = ((BufferedReader)object6).readLine()) != null) {
                            if (!string5.trim().startsWith("#")) continue;
                            ((StringBuilder)object5).append(string5 + "\r\n");
                        }
                        ((BufferedReader)object6).close();
                        object4 = new FileOutputStream((String)object3);
                        ((OutputStream)object4).write(((StringBuilder)object5).toString().getBytes());
                        ((Properties)object).setProperty(SUMMARY_KEY, this.mRequiredTab.getSummaryField().getText());
                        ((Properties)object).setProperty(DESCRIPTION_KEY, this.mRequiredTab.getDescField().getText());
                        ((Properties)object).store((OutputStream)object4, "");
                        ((OutputStream)object4).close();
                    }
                    object = new FileInputStream(file2);
                    closeable = new ByteArrayOutputStream();
                    StreamCopier.copyStream((InputStream)object, (OutputStream)closeable);
                    object6 = ((ByteArrayOutputStream)closeable).toByteArray();
                    if (((byte[])object6).length <= 0) {
                        throw new Exception("Can't read input bytes");
                    }
                    object5 = new CRC32();
                    object5.update((byte[])object6);
                    string5 = string2 + File.separator + file2.getName();
                    object4 = new JarEntry(string5);
                    ((ZipEntry)object4).setSize(((Object)object6).length);
                    ((ZipEntry)object4).setCrc(((CRC32)object5).getValue());
                    jarOutputStream.putNextEntry((ZipEntry)object4);
                    jarOutputStream.write((byte[])object6);
                    jarOutputStream.closeEntry();
                    continue;
                }
                if (!file2.isDirectory() || file2.isHidden()) continue;
                string4 = string2 + File.separator + file2.getName();
                object3 = new byte[0];
                object2 = new CRC32();
                object2.update((byte[])object3);
                object = new JarEntry(string4 + "/");
                ((ZipEntry)object).setSize(0L);
                ((ZipEntry)object).setCrc(((CRC32)object2).getValue());
                jarOutputStream.putNextEntry((ZipEntry)object);
                jarOutputStream.closeEntry();
                this.jarDirectory(jarOutputStream, file2.getAbsolutePath(), string4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Vector<String> getFiles(String string, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        for (String string2 : stringArray) {
            String string3 = string + File.separator + string2;
            vector.add(string3);
        }
        return vector;
    }

    private void createManifestContents(StringBuffer stringBuffer) {
        Locale locale = Locale.getDefault();
        String string = this.mOptionalTab.getTranslationCataloguesPath();
        boolean bl = string != null && string.length() > 0;
        stringBuffer.append(this.make72Safe(this.mRequiredTab.getNameKeyValuePairs()));
        if (this.mRequiredTab.getDialogSpecsKeyValuePairs() != null) {
            stringBuffer.append(this.make72Safe(this.mRequiredTab.getDialogSpecsKeyValuePairs()));
        }
        if (this.mRequiredTab.getCommandSpecsKeyValuePairs() != null) {
            stringBuffer.append(this.make72Safe(this.mRequiredTab.getCommandSpecsKeyValuePairs()));
        }
        if (this.mRequiredTab.getCodeFilesKeyValuePairs() != null) {
            stringBuffer.append(this.make72Safe(this.mRequiredTab.getCodeFilesKeyValuePairs()));
        }
        if (this.mRequiredTab.getMiscFilesKeyValuePairs() != null) {
            stringBuffer.append(this.make72Safe(this.mRequiredTab.getMiscFilesKeyValuePairs()));
        }
        if (locale == Locale.ENGLISH || !bl) {
            stringBuffer.append(this.make72Safe(this.mRequiredTab.getSummaryKeyValuePairs()));
            stringBuffer.append(this.make72Safe(this.mRequiredTab.getDescriptionKeyValuePairs()));
        } else if (this.mExtensionBundleHelper != null) {
            stringBuffer.append(this.make72Safe("Summary: " + this.mExtensionBundleHelper.getEnglishSummary() + "\n"));
            stringBuffer.append(this.make72Safe("Description: " + this.mExtensionBundleHelper.getEnglishDescription() + "\n"));
        }
        stringBuffer.append(this.make72Safe(this.mRequiredTab.getAuthorKeyValuePairs()));
        stringBuffer.append(this.make72Safe(this.mRequiredTab.getVersionKeyValuePairs()));
        stringBuffer.append(this.make72Safe(this.mRequiredTab.getProductVersionKeyValuePairs()));
        if (this.mOptionalTab.getDateKeyValuePairs() != null) {
            stringBuffer.append(this.make72Safe(this.mOptionalTab.getDateKeyValuePairs()));
        }
        if (this.mOptionalTab.getLinksKeyValuePairs() != null) {
            stringBuffer.append(this.make72Safe(this.mOptionalTab.getLinksKeyValuePairs()));
        }
        if (this.mOptionalTab.getCategoriesKeyValuePairs() != null) {
            stringBuffer.append(this.make72Safe(this.mOptionalTab.getCategoriesKeyValuePairs()));
        }
        if (this.mOptionalTab.getPluginsKeyValuePairs() != null) {
            stringBuffer.append(this.make72Safe(this.mOptionalTab.getPluginsKeyValuePairs()));
        }
        if (this.mOptionalTab.getRPackagesKeyValuePairs() != null) {
            stringBuffer.append(this.make72Safe(this.mOptionalTab.getRPackagesKeyValuePairs()));
        }
        if (this.mOptionalTab.getPythonModulesKeyValuePairs() != null) {
            stringBuffer.append(this.make72Safe(this.mOptionalTab.getPythonModulesKeyValuePairs()));
        }
        if (this.mOptionalTab.getTranslationCataloguesKeyValuePairs() != null) {
            stringBuffer.append(this.make72Safe(this.mOptionalTab.getTranslationCataloguesKeyValuePairs()));
        }
    }

    StringBuffer make72Safe(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        if (n > 72) {
            int n2 = 70;
            while (n2 < n - 2) {
                stringBuffer.insert(n2, "\r\n ");
                n2 += 72;
                n += 3;
            }
        }
        return stringBuffer;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        BaseSpssTab baseSpssTab = (BaseSpssTab)this.mTabbedPane.getSelectedComponent();
        baseSpssTab.setEnabled(true);
        baseSpssTab.setFocusable(true);
        Vector<Object> vector = baseSpssTab.mComponentOrder;
        if (!vector.contains(this.mTabbedPane)) {
            vector.add(this.mTabbedPane);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(baseSpssTab.mComponentOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    public Boolean wasSaved() {
        return this.mWasSaved;
    }

    public File getNameDirectory() {
        return this.mNameDirectory;
    }

    public Boolean getInEditMode() {
        return this.inEditMode;
    }

    private void close() {
        if (this.validateTabs() && this.createExtensionPackage()) {
            this.mWasSaved = true;
            this.saveDialogState();
            this.dispose();
        }
    }

    boolean validateTabs() {
        return this.mRequiredTab.validateTab() && this.mOptionalTab.validateTab();
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue(ExtensionBundleDlg.NAME_KEY, ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProcedureDlgMgr.getMgr().saveDialogSize(ExtensionBundleDlg.this.getIActionKey(), ExtensionBundleDlg.this.getSize());
            ProcedureDlgMgr.getMgr().saveDialogLocation(ExtensionBundleDlg.this.getIActionKey(), ExtensionBundleDlg.this.getLocation());
            if (ExtensionBundleDlg.this.inEditMode.booleanValue() && ExtensionBundleDlg.this.mNameDirectory != null) {
                String string = ExtensionBundleDlg.this.mOptionalTab.getTranslationCataloguesPath();
                if (string == null || string.length() == 0) {
                    SpssFile.recursiveDelete((File)ExtensionBundleDlg.this.mNameDirectory);
                }
                ExtensionBundleDlg.this.mNameDirectory = null;
            }
            ExtensionBundleDlg.this.dispose();
        }
    }

    class ResetAction
    extends AbstractAction {
        ResetAction() {
            String string = "IDS_RESET";
            this.putValue(ExtensionBundleDlg.NAME_KEY, ResUtil.getCommonDlgString(string));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                string = string.replaceFirst("IDS_", "IDK_");
                this.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey(string));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExtensionBundleDlg.this.getDialogDataModel().clear();
            ProcedureDlgMgr.getMgr().savePersistentState(ExtensionBundleDlg.this.getIActionKey(), ExtensionBundleDlg.this.getDialogDataModel());
            ExtensionBundleDlg.this.mRequiredTab.reset();
            ExtensionBundleDlg.this.mOptionalTab.reset();
        }
    }

    private class SaveAction
    extends AbstractAction {
        SaveAction() {
            this.putValue(ExtensionBundleDlg.NAME_KEY, ResUtil.getCommonDlgString("IDS_COMMON_SAVE_DLG_BUTTON"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProcedureDlgMgr.getMgr().saveDialogSize(ExtensionBundleDlg.this.getIActionKey(), ExtensionBundleDlg.this.getSize());
            ProcedureDlgMgr.getMgr().saveDialogLocation(ExtensionBundleDlg.this.getIActionKey(), ExtensionBundleDlg.this.getLocation());
            ExtensionBundleDlg.this.close();
        }
    }
}

