/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.bundle_from_internet;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.uitools.util.IniHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class StatisticsEnv {
    private boolean mIsPythonEssentialInstalled = false;
    private boolean mIsREssentialInstalled = false;
    private boolean mIsJavaEssentialsInstalled = true;
    private int mStatisticsMajorVersion = 22;
    private static StatisticsEnv mInstance = null;
    private ArrayList<String> mExtensionServerUrls = new ArrayList();
    private static final String INI_EXTENSION_SECTION_NAME = "EXTENSION";
    private static final String INI_EXTENSION_SERVER_URL_PRIFIX = "EXTENSION_SERVER_URL_";
    private static final String INI_DX_CONFIG_NAME = "spssdxcfg.ini";
    private static final String INI_R_SECTION_NAME = "R";
    private static final String INI_R_HOME_KEY = "HOME";
    private static final String SPSS_HOME = "application.home";
    private static final String PYTHON_JAR_FILE_NAME = "pythoncfg.jar";

    public static StatisticsEnv getStatisticsEnv() {
        if (mInstance == null) {
            mInstance = new StatisticsEnv();
        }
        return mInstance;
    }

    private StatisticsEnv() {
        String string;
        this.mIsREssentialInstalled = this.checkRInstalled();
        this.mIsPythonEssentialInstalled = this.checkPythonInstalled();
        String string2 = VersionInfo.getMajorVersionString();
        this.mStatisticsMajorVersion = Integer.parseInt(string2);
        int n = 1;
        IniHandler iniHandler = this.getSpssReaderFromSpssHomeDir(INI_DX_CONFIG_NAME);
        while ((string = this.getProfileValue(iniHandler, INI_EXTENSION_SECTION_NAME, INI_EXTENSION_SERVER_URL_PRIFIX + n)) != null && !string.isEmpty()) {
            if (!this.mExtensionServerUrls.contains(string)) {
                this.mExtensionServerUrls.add(string);
            }
            ++n;
        }
    }

    private boolean checkPythonInstalled() {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(System.getProperty(SPSS_HOME));
        stringBuffer.append(File.separator).append(PYTHON_JAR_FILE_NAME);
        File file = new File(stringBuffer.toString());
        if (file.exists()) {
            bl = true;
        }
        return bl;
    }

    private boolean checkRInstalled() {
        String string = "";
        boolean bl = false;
        IniHandler iniHandler = this.getSpssReaderFromSpssHomeDir(INI_DX_CONFIG_NAME);
        string = this.getProfileValue(iniHandler, INI_R_SECTION_NAME, INI_R_HOME_KEY);
        if (string.isEmpty()) {
            String string2 = VersionInfo.getMajorMinorVersionString();
            String string3 = "/com/ibm/SPSS/externalr/" + string2;
            try {
                if (Preferences.userRoot().nodeExists(string3)) {
                    Preferences preferences = Preferences.userRoot().node(string3);
                    string = preferences.get("r_path", string);
                    if (string.length() > 0) {
                        File file = new File(string);
                        if (!file.exists() || !file.isDirectory()) {
                            string = "";
                        }
                    } else {
                        string = "";
                    }
                }
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
            }
        }
        if (!string.isEmpty()) {
            bl = true;
        }
        return bl;
    }

    private IniHandler getSpssReaderFromSpssHomeDir(String string) {
        IniHandler iniHandler = null;
        StringBuffer stringBuffer = new StringBuffer(System.getProperty(SPSS_HOME));
        stringBuffer.append(File.separatorChar).append(string);
        File file = new File(stringBuffer.toString());
        if (file.exists()) {
            iniHandler = IniHandler.loadIniFile((String)stringBuffer.toString(), (boolean)true, (String)"UTF-8");
        }
        return iniHandler;
    }

    private String getProfileValue(IniHandler iniHandler, String string, String string2) {
        LinkedList linkedList;
        String string3 = "";
        if (iniHandler != null && (linkedList = iniHandler.getPrivateProfileString(string, string2)) != null && !linkedList.isEmpty()) {
            string3 = (String)linkedList.getFirst();
        }
        return string3;
    }

    public boolean isPythonPluginInstalled() {
        return this.mIsPythonEssentialInstalled;
    }

    public boolean isRPluginInstalled() {
        return this.mIsREssentialInstalled;
    }

    public boolean isJavaPlugInInstalled() {
        return this.mIsJavaEssentialsInstalled;
    }

    public int getStatsMajorVersion() {
        return this.mStatisticsMajorVersion;
    }

    public ArrayList<String> getDownloadExtensionServerUrls() {
        return (ArrayList)this.mExtensionServerUrls.clone();
    }
}

