/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.bundle_from_internet;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.LocalFileSysUtil;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.core.documents.output.header.HeaderItem;
import com.spss.java_client.core.documents.output.text.LogItem;
import com.spss.java_client.core.documents.output.text.TextItem;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssProgressDlg;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_from_internet.DeveloperWorksTermsOfUseDlg;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_from_internet.ExtensionBundleInstaller;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_from_internet.ExtensionBundleRequirementsDlg;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_from_internet.ExtensionsManager;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_from_internet.StatisticsEnv;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer.DialogsToolTipJTable;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.file.SpssFile;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.developerworks.core.ExtensionInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.help.StatsHelp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class InstallExtensionsFromInternetDlg
extends BaseDialog
implements ActionListener {
    private JTextArea mTextAreaInfo;
    private JLabel mLabelFilter;
    private JTextField mTextFieldFilter;
    private JButton mButtonFilter;
    private JTable mTableBundlesList;
    private JScrollPane mScrollPaneBundlesListTable;
    private JTextArea mTextAreaNonIbmExt;
    private JButton mButtonSelectAll;
    private JButton mButtonClearAll;
    private JRadioButton mRadioButtonInstall;
    private JRadioButton mRadioButtonDownloadOnly;
    private JLabel mLabelTargetFolder;
    private JTextField mTextFieldTargetFolder;
    private JButton mButtonBrowse;
    private SpssButtonGroup mButtongrp;
    private JButton mButtonOk;
    private JButton mButtonCancel;
    private JButton mButtonHelp;
    private JPanel mMainPanel;
    private final int initialTableWidth = 800;
    private final int initialTableHeight = 300;
    private SpssProgressDlg mProgressDlg = null;
    private DeveloperWorksTermsOfUseDlg mTermOfUseDlg = null;
    private static ExtensionBundleTableColumn[] mExtensionBundleColumns = null;
    static final String BROWSER_FOLDER_FILTER = "IDS_EXTENSION_BUNDELS_BROWSER_FOLDER_FILTER";
    static final String BROWSER_FOLDER_TITLE = "IDS_EXTENSION_BUNDELS_BROWSER_FOLDER_TITLE";
    static final String BROWSER_FOLDER_EXTENSION = "IDS_EXTENSION_BUNDELS_BROWSER_FOLDER_EXTENSION";
    static final String PROGRESS_BAR_TITLE = "IDS_EXTENSION_BUNDLES_PROGRESS_BAR_TITLE";
    static final String DOWNLOADING_MESSAGE = "IDS_EXTENSION_BUNDLES_DOWNLOADING";
    static final String INSTALLING_MESSAGE_PRIFIX = "IDS_EXTENSION_BUNDLES_INSTALLING_PREFIX";
    static final String INSTALLING_MESSAGE_SUFFIX = "IDS_EXTENSION_BUNDLES_INSTALLING_SUFFIX";
    static final String EXTENSION_BUNDLE_EXTENSION = ".spe";
    static final String OUTPUT_ITEM_DESCRIPTION = "IDS_EXTENSION_BUNDLE_OUTPUT_ITEM_DESCRIPITION";
    static final String NOT_AVAILABLE = "N/A";
    static final String THIRD_PARTY_INDICATOR = "*";
    static final String REQUIRED_ENTER_FILE = "ERR_EXTENSION_BUNDLE_REQUIRED_TAB_ENTER_FILE";

    public InstallExtensionsFromInternetDlg(SpssFrame spssFrame) {
        super((JFrame)spssFrame, false, ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), UtilitiesResBundle.getImageFolder());
        this.setDefaultCloseOperation(2);
        this.setTitle(this.getDialogTitle());
        this.pack();
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize(this.getIActionKey());
        if (dimension != null) {
            this.setSize(dimension);
        }
        this.setLocationRelativeTo(spssFrame);
    }

    private String getDialogTitle() {
        return this.getResString("IDS_INSTALL_EXTENSION_BUNDLE_FROM_INTERNET_DLG_TITLE");
    }

    private String getIActionKey() {
        return "utilities_install_extension_bundle_from_internet";
    }

    private String getIntroductionInfo() {
        return this.getResString("IDS_DOWNLOAD_EXTENSION_DLG_INTRODUCTION");
    }

    private void adjustColumnPreferredWidth(JTable jTable) {
        InstalledBundlesFromInternetTableModel installedBundlesFromInternetTableModel = (InstalledBundlesFromInternetTableModel)jTable.getModel();
        ((DialogsToolTipJTable)jTable).fitColumnToWidestEntry(0, 2);
        ((DialogsToolTipJTable)jTable).fitColumnToWidestEntry(1, 2);
        int n = jTable.getColumnCount();
        int n2 = 120;
        for (int i = 0; i < n; ++i) {
            if (i <= 1 || i >= 5) continue;
            jTable.getColumnModel().getColumn(i).setPreferredWidth(n2);
        }
        if (installedBundlesFromInternetTableModel.getRowCount() > 0) {
            jTable.changeSelection(0, 0, false, false);
        }
    }

    private InstalledBundlesFromInternetTableModel getTableModel() {
        return new InstalledBundlesFromInternetTableModel();
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_extension_bundles_download");
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel();
        Insets insets = DialogUtil.getStandardButtonInsets();
        this.mButtonOk = new JButton(new OkAction());
        int n = this.getTableModel().getSelectedExtensionnames().size();
        if (n > 0) {
            this.mButtonOk.setEnabled(true);
        } else {
            this.mButtonOk.setEnabled(false);
        }
        this.mButtonCancel = new JButton(new CancelAction());
        this.mButtonHelp = new JButton(new HelpAction());
        if (UIToolDialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n2 = insets.right + insets.left;
            if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                DialogUtil.setupMacHelpButton(this.mButtonHelp);
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n2, 0, 0);
                int n3 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mButtonHelp, gridBagConstraints, 0, 0, 1, 1, n3, null);
                n3 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, this.mButtonCancel, gridBagConstraints, 2, 0, 1, 1, n3, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mButtonOk, gridBagConstraints, 3, 0, 1, 1, n3, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n2, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mButtonOk);
                jPanel.add(this.mButtonCancel);
                jPanel.add(this.mButtonHelp);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n4 = insets.left + insets.right;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n4 * 2));
            jPanel.add(this.mButtonOk);
            jPanel.add(Box.createVerticalStrut(n4));
            jPanel.add(this.mButtonCancel);
            jPanel.add(Box.createVerticalStrut(n4));
            jPanel.add(this.mButtonHelp);
        }
        this.getRootPane().setDefaultButton(this.mButtonCancel);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mButtonFilter) {
            this.clearSelection();
            this.filterExtension();
        } else if (object == this.mButtonSelectAll) {
            int n = this.mTableBundlesList.getModel().getRowCount();
            int n2 = this.mTableBundlesList.getModel().getColumnCount();
            ExtensionsManager extensionsManager = ExtensionsManager.getExtensionsManager();
            for (int i = 0; i < n; ++i) {
                String string = (String)this.mTableBundlesList.getModel().getValueAt(i, 0);
                boolean bl = extensionsManager.isNeedUpdate(string);
                if (!bl) continue;
                this.mTableBundlesList.getModel().setValueAt(true, i, n2 - 1);
            }
            this.mTableBundlesList.repaint();
        } else if (object == this.mButtonClearAll) {
            this.clearSelection();
        } else if (object == this.mButtonBrowse) {
            this.processBrowseButton();
        } else if (object == this.mRadioButtonInstall) {
            this.mTextFieldTargetFolder.setEnabled(false);
            this.mButtonBrowse.setEnabled(false);
        } else if (object == this.mRadioButtonDownloadOnly) {
            this.mTextFieldTargetFolder.setEnabled(true);
            this.mButtonBrowse.setEnabled(true);
        }
    }

    protected void init() {
        super.init();
        this.initVariables();
        JPanel jPanel = this.getViewPanel();
        this.setupMainPanel(jPanel);
        this.pack();
        this.setTabPolicy();
        this.adjustColumnPreferredWidth(this.mTableBundlesList);
        this.addActionListeners();
    }

    private void downloadExtensions(String string) {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        this.mProgressDlg = new SpssProgressDlg((Window)spssFrame, this.getResString(PROGRESS_BAR_TITLE));
        this.mProgressDlg.setMessage(this.getResString(DOWNLOADING_MESSAGE));
        this.mProgressDlg.setLocationRelativeTo((Component)((Object)this));
        ExtensionDownloader extensionDownloader = new ExtensionDownloader(string);
        Thread thread = new Thread(extensionDownloader);
        thread.start();
        this.mProgressDlg.setVisible(true);
        if (!this.mProgressDlg.isWorkDone()) {
            thread.interrupt();
            return;
        }
        ArrayList<String> arrayList = extensionDownloader.getFaildedExtensins();
        int n = arrayList.size();
        if (n == 0) {
            Object[] objectArray = new Object[]{ResUtil.getCommonDlgString("IDS_OK")};
            String string2 = this.getResString("IDS_EXTENSION_BUNDLE_SUCCESSFULLY_DOWNLOADED");
            SpssAlertOptionPane.showOptionDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, objectArray, objectArray[0]);
            ArrayList<String> arrayList2 = ((InstalledBundlesFromInternetTableModel)this.mTableBundlesList.getModel()).getSelectedExtensionnames();
            String string3 = this.mTextFieldTargetFolder.getText();
            if (!string3.endsWith(File.separator)) {
                string3 = string3 + File.separator;
            }
            String string4 = "";
            String string5 = this.getResString("IDS_EXTENSION_BUNDLE_SUCCESSFULLY_DOWNLOADED_TO");
            for (String string6 : arrayList2) {
                String string7 = string5.replace("{0}", string6) + "\n    " + string3 + string6.replace(" ", "_") + EXTENSION_BUNDLE_EXTENSION;
                string4 = string4 + string7 + "\n\n";
            }
            this.addMessageToOutputViewer(this.getResString(OUTPUT_ITEM_DESCRIPTION), string4);
        } else {
            Object[] objectArray = new Object[]{ResUtil.getCommonDlgString("IDS_OK")};
            String string8 = this.getResString("IDS_EXTENSION_BUNDLE_FAILED_DOWNLOADED");
            SpssAlertOptionPane.showOptionDialog((Window)((Object)this), string8, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, objectArray, objectArray[0]);
            ArrayList<String> arrayList3 = ((InstalledBundlesFromInternetTableModel)this.mTableBundlesList.getModel()).getSelectedExtensionnames();
            String string9 = this.mTextFieldTargetFolder.getText();
            if (!string9.endsWith(File.separator)) {
                string9 = string9 + File.separator;
            }
            String string10 = "";
            String string11 = this.getResString("IDS_EXTENSION_BUNDLE_SUCCESSFULLY_DOWNLOADED_TO");
            String string12 = this.getResString("IDS_EXTENSION_BUNDLE_FAIL_TO_DOWNLOAD");
            for (String string13 : arrayList3) {
                String string14;
                if (arrayList.contains(string13)) {
                    string14 = string11.replace("{0}", string13) + "\n    " + string9 + string13.replace(" ", "_") + EXTENSION_BUNDLE_EXTENSION;
                    string10 = string10 + string14 + "\n\n";
                    continue;
                }
                string14 = string12.replace("{0}", string13);
                string10 = string10 + string14 + "\n\n";
            }
            this.addMessageToOutputViewer(this.getResString(OUTPUT_ITEM_DESCRIPTION), string10);
        }
    }

    private void downloadAndInstallExtensions() {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        this.mProgressDlg = new SpssProgressDlg((Window)spssFrame, this.getResString(PROGRESS_BAR_TITLE));
        this.mProgressDlg.setMessage(this.getResString(DOWNLOADING_MESSAGE));
        this.mProgressDlg.setLocationRelativeTo((Component)((Object)this));
        ExtensionDownloadAndInstall extensionDownloadAndInstall = new ExtensionDownloadAndInstall();
        Thread thread = new Thread(extensionDownloadAndInstall);
        thread.start();
        this.mProgressDlg.setVisible(true);
        if (!this.mProgressDlg.isWorkDone()) {
            thread.interrupt();
            return;
        }
        HashMap<String, String> hashMap = extensionDownloadAndInstall.getFailReason();
        HashMap<String, String> hashMap2 = extensionDownloadAndInstall.getSuccessInstalledMsg();
        if (hashMap.size() == 0) {
            Object[] objectArray = new Object[]{ResUtil.getCommonDlgString("IDS_OK")};
            String string = this.getResString("IDS_EXTENSION_BUNDLE_SUCCESSFULLY_INSTALLED");
            SpssAlertOptionPane.showOptionDialog((Window)((Object)this), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, objectArray, objectArray[0]);
            Set<String> set = hashMap2.keySet();
            String string2 = "";
            for (String string3 : set) {
                string = hashMap2.get(string3);
                if (string == null) continue;
                String string8 = string3 + ":" + string;
                string2 = string2 + string8 + "\n\n";
            }
            if (!string2.isEmpty()) {
                this.addMessageToOutputViewer(this.getResString(OUTPUT_ITEM_DESCRIPTION), string2);
            }
        } else {
            String string;
            Object[] objectArray = new Object[]{ResUtil.getCommonDlgString("IDS_OK")};
            String string6 = this.getResString("IDS_EXTENSION_BUNDLE_FAILED_INSTALLED");
            SpssAlertOptionPane.showOptionDialog((Window)((Object)this), string6, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, objectArray, objectArray[0]);
            Set<String> set = hashMap.keySet();
            String string7 = "";
            for (String object2 : set) {
                string = object2 + ":" + hashMap.get(object2);
                string7 = string7 + string + "\n\n";
            }
            Set<String> set2 = hashMap2.keySet();
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                String string2 = string + ":" + hashMap2.get(string);
                string7 = string7 + string2 + "\n\n";
            }
            this.addMessageToOutputViewer(this.getResString(OUTPUT_ITEM_DESCRIPTION), string7);
        }
    }

    private void clearSelection() {
        this.mTableBundlesList.editCellAt(0, 0);
        int n = this.mTableBundlesList.getModel().getRowCount();
        int n2 = this.mTableBundlesList.getModel().getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.mTableBundlesList.getModel().setValueAt(false, i, n2 - 1);
        }
        this.mTableBundlesList.repaint();
    }

    private void deleteDir(String string) {
        File file = new File(string);
        String string2 = file.getParent() + Calendar.getInstance().getTimeInMillis();
        SpssFile.deleteDirectory((File)file, (String)string2);
        File file2 = new File(string2);
        if (file2.isDirectory()) {
            file2.delete();
        }
    }

    private boolean validateTargetFile() {
        boolean bl = false;
        if (this.mTextFieldTargetFolder != null && this.mTextFieldTargetFolder.isEnabled()) {
            if (this.mTextFieldTargetFolder.getText().trim().length() > 0) {
                String string = LocalFileSysUtil.getLocalFileSysUtil().ExpandEnvVars(this.mTextFieldTargetFolder.getText().trim());
                this.mTextFieldTargetFolder.setText(string);
                File file = new File(this.mTextFieldTargetFolder.getText());
                PesFile pesFile = PES_Repository.getPesFile((String)file.getAbsolutePath());
                bl = pesFile != null ? !pesFile.existsInPES() || pesFile.canWriteToPesFile() : file.isDirectory();
                if (!bl) {
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString(REQUIRED_ENTER_FILE), VersionInfo.getAppVersionString());
                }
            } else {
                bl = false;
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString(REQUIRED_ENTER_FILE), VersionInfo.getAppVersionString());
            }
            if (!bl) {
                this.mTextFieldTargetFolder.requestFocusInWindow();
            }
        }
        return bl;
    }

    private void filterExtension() {
        RowFilter<Object, Object> rowFilter = new RowFilter<Object, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry) {
                String string = InstallExtensionsFromInternetDlg.this.mTextFieldFilter.getText();
                String string2 = (String)entry.getValue(0);
                if (string2.startsWith(InstallExtensionsFromInternetDlg.THIRD_PARTY_INDICATOR)) {
                    int n = string2.indexOf(InstallExtensionsFromInternetDlg.THIRD_PARTY_INDICATOR) + InstallExtensionsFromInternetDlg.THIRD_PARTY_INDICATOR.length();
                    string2 = string2.substring(n);
                }
                return ExtensionsManager.getExtensionsManager().isExtensionInclude(string, string2);
            }
        };
        TableRowSorter<InstalledBundlesFromInternetTableModel> tableRowSorter = new TableRowSorter<InstalledBundlesFromInternetTableModel>((InstalledBundlesFromInternetTableModel)this.mTableBundlesList.getModel());
        tableRowSorter.setRowFilter(rowFilter);
        this.mTableBundlesList.setRowSorter(tableRowSorter);
    }

    private JPanel setupFilterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        int n = 18;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mLabelFilter, gridBagConstraints, 0, 1, 1, 1, n, new Insets(insets.top, insets.left, insets.bottom, insets.right));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mTextFieldFilter, gridBagConstraints, 1, 1, 2, 1, n, new Insets(insets.top, insets.left, insets.bottom, insets.right + 10));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right + 5);
        DialogUtil.addUsingGBL(jPanel, this.mButtonFilter, gridBagConstraints, 3, 1, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        Insets insets3 = new Insets(insets.top, insets.left + 133, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mButtonSelectAll, gridBagConstraints, 6, 2, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mButtonClearAll, gridBagConstraints, 7, 2, 1, 1, n, insets);
        return jPanel;
    }

    private void initVariables() {
        mExtensionBundleColumns = new ExtensionBundleTableColumn[]{new ExtensionBundleTableColumn(0, true), new ExtensionBundleTableColumn(1, true), new ExtensionBundleTableColumn(2, true), new ExtensionBundleTableColumn(3, true), new ExtensionBundleTableColumn(4, true), new ExtensionBundleTableColumn(5, true)};
        this.mTextAreaInfo = new JTextArea(this.getIntroductionInfo());
        this.mTextAreaInfo.setEditable(false);
        this.mTextAreaInfo.setOpaque(false);
        this.mTextAreaInfo.setFocusable(false);
        this.mTextAreaInfo.setWrapStyleWord(true);
        this.mTextAreaInfo.setLineWrap(false);
        this.mTextFieldFilter = new JTextField();
        this.mTextFieldFilter.setPreferredSize(new Dimension(50, this.mTextFieldFilter.getMinimumSize().height));
        this.mLabelFilter = DialogUtil.createLabel(this, "IDS_INSTALL_EXTENSION_BUNDLE_FROM_INTERNET_INFOLABEL_FILTER");
        this.mLabelFilter.setLabelFor(this.mTextFieldFilter);
        this.mButtonFilter = DialogUtil.createButton(this, "IDS_EXTENSION_BUNDLE_LIST_FILTER_BUTTON", this);
        this.mButtonSelectAll = DialogUtil.createButton(this, "IDS_EXTENSION_BUNDLE_LIST_SELECT_ALL_BUTTON", this);
        this.mButtonClearAll = DialogUtil.createButton(this, "IDS_EXTENSION_BUNDLE_LIST_CLEAR_ALL_BUTTON", this);
        this.mTableBundlesList = new DialogsToolTipJTable(this.getTableModel()){
            private static final long serialVersionUID = 1L;

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                switch (n2) {
                    case 4: {
                        return new prerequisitiesTextRenderer();
                    }
                    case 2: 
                    case 3: {
                        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
                        defaultTableCellRenderer.setHorizontalAlignment(0);
                        return defaultTableCellRenderer;
                    }
                }
                return super.getCellRenderer(n, n2);
            }
        };
        Dimension dimension = new Dimension(800, 300);
        this.mTableBundlesList.setMinimumSize(dimension);
        this.mTableBundlesList.setSelectionMode(0);
        this.mTableBundlesList.setAutoResizeMode(0);
        JTableHeader jTableHeader = this.mTableBundlesList.getTableHeader();
        jTableHeader.setDefaultRenderer(new ExtensionBundlesTableHeaderRenderer());
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    return;
                }
                int n = InstallExtensionsFromInternetDlg.this.mTableBundlesList.getTableHeader().columnAtPoint(mouseEvent.getPoint());
                if (n != -1 && mExtensionBundleColumns[n].isSortable()) {
                    this.sortColumn(n, (InstalledBundlesFromInternetTableModel)InstallExtensionsFromInternetDlg.this.mTableBundlesList.getModel());
                }
            }

            void sortColumn(int n, InstalledBundlesFromInternetTableModel installedBundlesFromInternetTableModel) {
                ArrayList<Object[]> arrayList = installedBundlesFromInternetTableModel.getData();
                switch (mExtensionBundleColumns[n].getSortSequence()) {
                    case ASCENDING: {
                        Collections.sort(arrayList, new ExtensionBundleColumnTableSorter(n, ExtensionBundleTableColumn.SortOrder.DESCENDING));
                        mExtensionBundleColumns[n].setSortSequence(ExtensionBundleTableColumn.SortOrder.DESCENDING);
                        break;
                    }
                    case DESCENDING: {
                        Collections.sort(arrayList, new ExtensionBundleColumnTableSorter(n, ExtensionBundleTableColumn.SortOrder.ASCENDING));
                        mExtensionBundleColumns[n].setSortSequence(ExtensionBundleTableColumn.SortOrder.ASCENDING);
                    }
                }
                ((ExtensionBundlesTableHeaderRenderer)InstallExtensionsFromInternetDlg.this.mTableBundlesList.getTableHeader().getDefaultRenderer()).setSortedColumn(n);
                installedBundlesFromInternetTableModel.fireTableDataChanged();
                InstallExtensionsFromInternetDlg.this.mTableBundlesList.getTableHeader().repaint();
            }
        });
        this.mScrollPaneBundlesListTable = new JScrollPane(this.mTableBundlesList);
        this.mScrollPaneBundlesListTable.setPreferredSize(this.mTableBundlesList.getMinimumSize());
        this.mScrollPaneBundlesListTable.setHorizontalScrollBarPolicy(30);
        this.mScrollPaneBundlesListTable.setVerticalScrollBarPolicy(20);
        this.mScrollPaneBundlesListTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Component component = componentEvent.getComponent();
                int n = component.getWidth();
                TableColumn tableColumn = InstallExtensionsFromInternetDlg.this.mTableBundlesList.getColumnModel().getColumn(1);
                int n2 = InstallExtensionsFromInternetDlg.this.mTableBundlesList.getWidth() - tableColumn.getWidth();
                int n3 = n - n2;
                if (n3 > 0) {
                    tableColumn.setPreferredWidth(n3 - 5);
                }
            }
        });
        this.mTextAreaNonIbmExt = new JTextArea(this.getResString("IDS_EXTENSION_BUNDLE_NON_IBM_COMMENS"));
        this.mTextAreaNonIbmExt.setEditable(false);
        this.mTextAreaNonIbmExt.setOpaque(false);
        this.mTextAreaNonIbmExt.setFocusable(false);
        this.mTextAreaNonIbmExt.setWrapStyleWord(true);
        this.mTextAreaNonIbmExt.setLineWrap(false);
        this.mRadioButtonInstall = new JRadioButton(new ToggleButtonAction(this, "IDS_EXTENSION_BUNDLE_DOWNLOAD_AND_INSTALL"));
        this.mRadioButtonInstall.setSelected(true);
        this.mRadioButtonInstall.addActionListener(this);
        this.mRadioButtonDownloadOnly = new JRadioButton(new ToggleButtonAction(this, "IDS_EXTENSION_BUNDLE_DOWNLOAD_ONLY"));
        this.mRadioButtonDownloadOnly.addActionListener(this);
        this.mButtongrp = new SpssButtonGroup();
        this.mButtongrp.add(this.mRadioButtonInstall);
        this.mButtongrp.add(this.mRadioButtonDownloadOnly);
        this.mTextFieldTargetFolder = new JTextField();
        this.mTextFieldTargetFolder.setPreferredSize(new Dimension(150, this.mTextFieldTargetFolder.getMinimumSize().height));
        this.mTextFieldTargetFolder.setEnabled(false);
        this.mLabelTargetFolder = DialogUtil.createLabel(this, "IDS_EXTENSION_BUNDLE_DOWNLOAD_FOLDER");
        this.mLabelTargetFolder.setLabelFor(this.mTextFieldTargetFolder);
        this.mButtonBrowse = DialogUtil.createButton(this, "IDS_EXTENSION_BUNDLE_DOWNLOAD_FOLDER_BROWSER", this);
        this.mButtonBrowse.setEnabled(false);
    }

    private void setupMainPanel(JPanel jPanel) {
        this.mMainPanel = new JPanel();
        this.mMainPanel.setFocusable(true);
        this.mMainPanel.setLayout(new GridBagLayout());
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.bottom += 5;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        int n2 = 18;
        DialogUtil.addUsingGBL(this.mMainPanel, this.mTextAreaInfo, gridBagConstraints, 0, n, 4, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JPanel jPanel2 = this.setupFilterPanel();
        DialogUtil.addUsingGBL(this.mMainPanel, jPanel2, gridBagConstraints, 0, ++n, 8, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mMainPanel, this.mScrollPaneBundlesListTable, gridBagConstraints, 0, ++n, 8, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mMainPanel, this.mTextAreaNonIbmExt, gridBagConstraints, 0, ++n, 2, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(insets.top + 20, insets.left + 10, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this.mMainPanel, this.mRadioButtonInstall, gridBagConstraints, 0, ++n, 3, 1, n2, insets2);
        Insets insets3 = new Insets(insets.top, insets.left + 10, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this.mMainPanel, this.mRadioButtonDownloadOnly, gridBagConstraints, 0, ++n, 3, 1, n2, insets3);
        gridBagConstraints.fill = 0;
        Insets insets4 = new Insets(insets.top, insets.left + 25, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this.mMainPanel, this.mLabelTargetFolder, gridBagConstraints, 0, ++n, 1, 1, n2, insets4);
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mMainPanel, this.mTextFieldTargetFolder, gridBagConstraints, 1, n, 2, 1, n2, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.4;
        Insets insets5 = new Insets(insets.top, insets.left, insets.bottom, insets.right + 100);
        DialogUtil.addUsingGBL(this.mMainPanel, this.mButtonBrowse, gridBagConstraints, 3, n, 1, 1, n2, insets5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets6 = new Insets(0, 0, 0, 0);
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mMainPanel, gridBagConstraints, 0, 0, 1, 1, n2, insets6);
    }

    private void setTabPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTextFieldFilter);
        vector.add(this.mButtonFilter);
        vector.add(this.mButtonSelectAll);
        vector.add(this.mButtonClearAll);
        vector.add(this.mTableBundlesList);
        vector.add(this.mRadioButtonInstall);
        vector.add(this.mRadioButtonDownloadOnly);
        vector.add(this.mTextFieldTargetFolder);
        vector.add(this.mButtonOk);
        vector.add(this.mButtonCancel);
        vector.add(this.mButtonHelp);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void addActionListeners() {
        this.mTableBundlesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                String string;
                if (mouseEvent.getClickCount() == 1 && InstallExtensionsFromInternetDlg.this.mTableBundlesList.getSelectedColumn() == 4 && (string = (String)InstallExtensionsFromInternetDlg.this.mTableBundlesList.getValueAt(InstallExtensionsFromInternetDlg.this.mTableBundlesList.getSelectedRow(), 4)).equals(InstallExtensionsFromInternetDlg.this.getResString("IDS_EXTENSION_BUNDELS_DLG_TABLE_PREREQUISTIES_NO"))) {
                    String string2 = (String)InstallExtensionsFromInternetDlg.this.mTableBundlesList.getValueAt(InstallExtensionsFromInternetDlg.this.mTableBundlesList.getSelectedRow(), 0);
                    ExtensionsManager.getExtensionsManager().setSelectedExtensionName(string2);
                    ExtensionBundleRequirementsDlg extensionBundleRequirementsDlg = new ExtensionBundleRequirementsDlg(InstallExtensionsFromInternetDlg.this, InstallExtensionsFromInternetDlg.this.getResString("IDS_EXTENSION_BUNDLE_REQUIREMENT_DLG_TITLE"), string2);
                    extensionBundleRequirementsDlg.setResizable(false);
                    extensionBundleRequirementsDlg.setVisible(true);
                }
            }
        });
        this.mTextFieldFilter.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    InstallExtensionsFromInternetDlg.this.clearSelection();
                    InstallExtensionsFromInternetDlg.this.filterExtension();
                    keyEvent.consume();
                }
            }
        });
    }

    private void processBrowseButton() {
        String string;
        String string2 = this.getResString(BROWSER_FOLDER_FILTER);
        RemoteFileChooser remoteFileChooser = this.showSelectFolderFileDialog(string2, string = this.getResString(BROWSER_FOLDER_TITLE));
        if (remoteFileChooser != null) {
            String string3 = remoteFileChooser.getSelectedFilePath();
            String string4 = string3.toLowerCase();
            int n = string4.indexOf(this.getResString(BROWSER_FOLDER_EXTENSION));
            if (n == -1) {
                string3 = string3.concat(this.getResString(BROWSER_FOLDER_EXTENSION));
            } else if (string4.substring(n).compareToIgnoreCase(this.getResString(BROWSER_FOLDER_EXTENSION)) != 0) {
                string3 = string3.concat(this.getResString(BROWSER_FOLDER_EXTENSION));
            }
            this.mTextFieldTargetFolder.setText(string3);
        }
    }

    private ArrayList<ExtensionInfo> getAllExtensionInfomations() {
        return ExtensionsManager.getExtensionsManager().getExtensions();
    }

    private RemoteFileChooser showSelectFolderFileDialog(String string, String string2) {
        OpenFolderChooser openFolderChooser = new OpenFolderChooser(RemoteFileChooser.ChooserType.OpenFolder, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
        openFolderChooser.setDialogTitle(string2);
        openFolderChooser.setFileSelectionMode(1);
        openFolderChooser.setAcceptAllFileFilterUsed(false);
        RefFileFilter refFileFilter = new RefFileFilter(string, "");
        openFolderChooser.setFileFilter((FileFilter)refFileFilter);
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            openFolderChooser.setApproveButtonMnemonic(this.getDlgAccessKey("IDK_OMS_BROWSE_FOLDER_APPROVE_BUTTON_KEY"));
        }
        int n = openFolderChooser.showDialog((Component)((Object)this), this.getResString("IDS_OMS_BROWSE_FOLDER_APPROVE_BUTTON_TEXT"));
        openFolderChooser.resetStrings();
        return n == 0 ? openFolderChooser : null;
    }

    private void addMessageToOutputViewer(String string, String string2) {
        ViewerFrame viewerFrame;
        OutputManager outputManager = OutputManager.getOutputManager();
        IOutputDocument iOutputDocument = outputManager.getDesignatedDocument();
        IOutputItem iOutputItem = null;
        for (long i = iOutputDocument.getItemCount() - 1L; !(i < 0L || (iOutputItem = iOutputDocument.getItemAtIndex(i)) instanceof HeaderItem || iOutputItem instanceof LogItem || iOutputItem.getDescription().equals(string)); --i) {
        }
        TextItem textItem = new TextItem();
        textItem.setDescription(string);
        textItem.setContents(string2);
        iOutputDocument.insertItem((IOutputItem)textItem, iOutputItem, true);
        if (SpssFrameMgr.getSpssFrameMgr().openDocumentCount(DocType.OUTPUT_DOC) > 0 && (viewerFrame = (ViewerFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.OUTPUT_DOC)) != null) {
            if (viewerFrame.getExtendedState() != 6) {
                viewerFrame.setExtendedState(0);
            }
            viewerFrame.toFront();
        }
    }

    public class ExtensionBundleColumnTableSorter
    implements Comparator {
        ExtensionBundleTableColumn.SortOrder mSortOrder;
        int colNumber = -1;

        ExtensionBundleColumnTableSorter(int n, ExtensionBundleTableColumn.SortOrder sortOrder) {
            this.mSortOrder = sortOrder;
            this.colNumber = n;
        }

        public int compare(Object object, Object object2) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            Object object3 = objectArray[this.colNumber];
            Object object4 = objectArray2[this.colNumber];
            if (object3 instanceof String && ((String)object3).length() == 0) {
                object3 = null;
            }
            if (object4 instanceof String && ((String)object4).length() == 0) {
                object4 = null;
            }
            if (object3 == null && object4 == null) {
                return 0;
            }
            if (object3 == null) {
                return 1;
            }
            if (object4 == null) {
                return -1;
            }
            if (this.mSortOrder == ExtensionBundleTableColumn.SortOrder.ASCENDING) {
                return object3.toString().compareToIgnoreCase(object4.toString());
            }
            return object4.toString().compareToIgnoreCase(object3.toString());
        }
    }

    private static class ExtensionBundleTableColumn {
        public static final int COLUMN_NAME = 0;
        public static final int COLUMN_SUMMARY = 1;
        public static final int COLUMN_LATEST_VERSION = 2;
        public static final int COLUMN_INSTALLED_VERSION = 3;
        public static final int COLUMN_PREREQUISTIES = 4;
        public static final int COLUMN_SELECTED = 5;
        private int mColumnNumber = -1;
        private boolean mSortable = false;
        private SortOrder mSortSequence = SortOrder.ASCENDING;

        public ExtensionBundleTableColumn(int n, boolean bl) {
            this.mColumnNumber = n;
            this.mSortable = bl;
        }

        public int getColumnNumber() {
            return this.mColumnNumber;
        }

        public boolean isSortable() {
            return this.mSortable;
        }

        public SortOrder getSortSequence() {
            return this.mSortSequence;
        }

        public void setSortSequence(SortOrder sortOrder) {
            this.mSortSequence = sortOrder;
        }

        public static enum SortOrder {
            ASCENDING,
            DESCENDING;

        }
    }

    private class ExtensionBundlesTableHeaderRenderer
    implements TableCellRenderer {
        private JPanel mRenderer = new JPanel(new BorderLayout(0, 0));
        private JLabel mTextRenderer = new JLabel();
        private int mSortedColumnNumber = -1;

        public ExtensionBundlesTableHeaderRenderer() {
            this.mRenderer.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.mTextRenderer.setHorizontalTextPosition(10);
            this.mTextRenderer.setHorizontalAlignment(0);
            this.mRenderer.add((Component)this.mTextRenderer, "Center");
        }

        public void setSortedColumn(int n) {
            this.mSortedColumnNumber = n;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable != null) {
                if (this.mSortedColumnNumber == n2) {
                    this.mTextRenderer.setIcon(new ImageIcon(ResUtil.getImageResource("sortasc.gif")));
                    if (mExtensionBundleColumns[n2].getSortSequence() == ExtensionBundleTableColumn.SortOrder.ASCENDING) {
                        this.mTextRenderer.setIcon(new ImageIcon(ResUtil.getImageResource("sortasc.gif")));
                    } else if (mExtensionBundleColumns[n2].getSortSequence() == ExtensionBundleTableColumn.SortOrder.DESCENDING) {
                        this.mTextRenderer.setIcon(new ImageIcon(ResUtil.getImageResource("sortdesc.gif")));
                    } else {
                        this.mTextRenderer.setIcon(null);
                    }
                } else {
                    this.mTextRenderer.setIcon(null);
                }
            }
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                this.mTextRenderer.setText(ComponentState.prepareStringForBidiRendering((String)object.toString()));
            } else {
                this.mTextRenderer.setText(object.toString());
            }
            return this.mRenderer;
        }
    }

    public class OpenFolderChooser
    extends RemoteFileChooser {
        public OpenFolderChooser(RemoteFileChooser.ChooserType chooserType, RemoteFileChooser.ChooserOption chooserOption, String string, boolean bl) {
            super(chooserType, chooserOption, string, bl);
        }

        @Override
        protected void installStrings() {
            super.installStrings();
            UIManager.getDefaults().put("FileChooser.lookInLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_IN_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.filesOfTypeLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_FILES_OF_TYPE_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.folderNameLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_OPEN_FOLDER_LABEL_TEXT"));
        }

        public void resetStrings() {
            UIManager.getDefaults().put("FileChooser.lookInLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_LOOK_IN_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.filesOfTypeLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_FILES_OF_TYPE_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.folderNameLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_FOLDER_LABEL_TEXT"));
        }
    }

    class InstalledBundlesFromInternetTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] mColNames;
        private Class<?>[] types;
        private ArrayList<Object[]> mTableData;

        public ArrayList<String> getSelectedExtensionnames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = this.mTableData.size();
            for (int i = 0; i < n; ++i) {
                Boolean bl = (Boolean)this.mTableData.get(i)[5];
                if (!bl.booleanValue()) continue;
                String string = (String)this.mTableData.get(i)[0];
                if (string.startsWith(InstallExtensionsFromInternetDlg.THIRD_PARTY_INDICATOR)) {
                    string = string.substring(InstallExtensionsFromInternetDlg.THIRD_PARTY_INDICATOR.length());
                }
                arrayList.add(string);
            }
            return arrayList;
        }

        public InstalledBundlesFromInternetTableModel() {
            this.mColNames = new String[]{InstallExtensionsFromInternetDlg.this.getResString("IDS_EXTENSION_BUNDELS_DLG_TABLE_NAME"), InstallExtensionsFromInternetDlg.this.getResString("IDS_EXTENSION_BUNDELS_DLG_TABLE_NAME_SUMMARY"), InstallExtensionsFromInternetDlg.this.getResString("IDS_EXTENSION_BUNDELS_DLG_TABLE_LATEST_VERSION"), InstallExtensionsFromInternetDlg.this.getResString("IDS_EXTENSION_BUNDELS_DLG_TABLE_INSTALLED_VERSION"), InstallExtensionsFromInternetDlg.this.getResString("IDS_EXTENSION_BUNDELS_DLG_TABLE_PREREQUISTIES"), InstallExtensionsFromInternetDlg.this.getResString("IDS_EXTENSION_BUNDELS_DLG_TABLE_NAME_SELECT")};
            this.types = new Class[]{String.class, String.class, String.class, String.class, String.class, Boolean.class};
            this.mTableData = new ArrayList();
            ArrayList arrayList = InstallExtensionsFromInternetDlg.this.getAllExtensionInfomations();
            String string = PrefsMgr.getILangTag();
            for (ExtensionInfo extensionInfo : arrayList) {
                String string2;
                String string3 = extensionInfo.getAuthor().toUpperCase().contains("IBM") ? extensionInfo.getName() : InstallExtensionsFromInternetDlg.THIRD_PARTY_INDICATOR + extensionInfo.getName();
                String string4 = extensionInfo.getSummary(string);
                String string5 = extensionInfo.getVersion();
                String string6 = extensionInfo.getInstalledVersion();
                String string7 = string2 = this.isSatisfiedInstallRequirement(extensionInfo) ? InstallExtensionsFromInternetDlg.this.getResString("IDS_EXTENSION_BUNDELS_DLG_TABLE_PREREQUISTIES_YES") : InstallExtensionsFromInternetDlg.this.getResString("IDS_EXTENSION_BUNDELS_DLG_TABLE_PREREQUISTIES_NO");
                if (string3 == null || string3.isEmpty()) {
                    string3 = InstallExtensionsFromInternetDlg.NOT_AVAILABLE;
                }
                if (string4 == null || string4.isEmpty()) {
                    string4 = InstallExtensionsFromInternetDlg.NOT_AVAILABLE;
                }
                if (string5 == null || string5.isEmpty()) {
                    string5 = InstallExtensionsFromInternetDlg.NOT_AVAILABLE;
                }
                this.addDataItem(string3, string4, string5, string6, string2, false);
            }
        }

        public void addDataItem(String string, String string2, String string3, String string4, String string5, Boolean bl) {
            this.mTableData.add(new Object[]{string, string2, string3, string4, string5, bl});
        }

        @Override
        public int getColumnCount() {
            return this.mColNames.length;
        }

        @Override
        public int getRowCount() {
            return this.mTableData.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = this.mTableData.get(n)[n2];
            return object;
        }

        @Override
        public String getColumnName(int n) {
            return this.mColNames[n];
        }

        public ArrayList<Object[]> getData() {
            return this.mTableData;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.types[n];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (object instanceof Boolean) {
                this.mTableData.get((int)n)[n2] = object;
                int n3 = this.getSelectedExtensionnames().size();
                if (n3 > 0) {
                    InstallExtensionsFromInternetDlg.this.mButtonOk.setEnabled(true);
                } else {
                    InstallExtensionsFromInternetDlg.this.mButtonOk.setEnabled(false);
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 4;
        }

        private boolean isSatisfiedInstallRequirement(ExtensionInfo extensionInfo) {
            boolean bl = true;
            StatisticsEnv statisticsEnv = StatisticsEnv.getStatisticsEnv();
            if (extensionInfo.isPlugInRequired(ExtensionInfo.PLURIN_TYPE.R) && !statisticsEnv.isRPluginInstalled()) {
                bl = false;
            }
            if (extensionInfo.isPlugInRequired(ExtensionInfo.PLURIN_TYPE.PYTHON) && !statisticsEnv.isPythonPluginInstalled()) {
                bl = false;
            }
            if (extensionInfo.isPlugInRequired(ExtensionInfo.PLURIN_TYPE.JAVA) && !statisticsEnv.isJavaPlugInInstalled()) {
                bl = false;
            }
            if (extensionInfo.getStatisticsMajorVersion() > statisticsEnv.getStatsMajorVersion()) {
                bl = false;
            }
            return bl;
        }
    }

    class ExtensionDownloadAndInstall
    implements Runnable {
        private HashMap<String, String> mFailReason = new HashMap();
        private HashMap<String, String> mSuccessInstalledMsg = new HashMap();
        private ExtensionBundleInstaller mInstaller = new ExtensionBundleInstaller();

        ExtensionDownloadAndInstall() {
        }

        public HashMap<String, String> getFailReason() {
            return (HashMap)this.mFailReason.clone();
        }

        public HashMap<String, String> getSuccessInstalledMsg() {
            return (HashMap)this.mSuccessInstalledMsg.clone();
        }

        private void addErrorMessage(String string, String string2) {
            this.mFailReason.put(string, string2);
        }

        private void addSuccessMessage(String string, String string2) {
            this.mSuccessInstalledMsg.put(string, string2);
        }

        @Override
        public void run() {
            Object object;
            Object object22;
            Vector vector = FileLocationsUtil.getExtensionsPathes();
            Object object3 = null;
            for (Object object22 : vector) {
                object22 = ((String)object22).endsWith(File.separator) ? (String)object22 + Calendar.getInstance().getTimeInMillis() : (String)object22 + File.separator + Calendar.getInstance().getTimeInMillis();
                object = new File((String)object22);
                if (!((File)object).mkdirs()) continue;
                object3 = object22;
                break;
            }
            ArrayList<String> arrayList = ((InstalledBundlesFromInternetTableModel)InstallExtensionsFromInternetDlg.this.mTableBundlesList.getModel()).getSelectedExtensionnames();
            if (object3 == null) {
                object22 = arrayList.iterator();
                while (object22.hasNext()) {
                    object = (String)object22.next();
                    this.addErrorMessage((String)object, InstallExtensionsFromInternetDlg.this.getResString("IDS_EXTENSION_BUNDLE_NO_PERMISSIONS_MSG"));
                }
                return;
            }
            object22 = arrayList.iterator();
            while (object22.hasNext()) {
                object = (String)object22.next();
                String string = InstallExtensionsFromInternetDlg.this.getResString("IDS_EXTENSION_BUNDLES_DOWNLOADING_INSTALLING");
                string = string.replace("{0}", (CharSequence)object);
                InstallExtensionsFromInternetDlg.this.mProgressDlg.setMessage(string);
                String string2 = ExtensionsManager.getExtensionsManager().downloadExtension((String)object, (String)object3);
                if (string2 == null) {
                    this.addErrorMessage((String)object, InstallExtensionsFromInternetDlg.this.getResString("IDS_EXTENSION_BUNDLE_FAIL_TO_DOWNLOAD"));
                    continue;
                }
                if (Thread.currentThread().isInterrupted()) {
                    InstallExtensionsFromInternetDlg.this.deleteDir((String)object3);
                    return;
                }
                String string3 = (String)object3 + File.separator + ((String)object).replace(" ", "_") + InstallExtensionsFromInternetDlg.EXTENSION_BUNDLE_EXTENSION;
                boolean bl = this.mInstaller.doInstall(new File(string3));
                if (!bl) {
                    this.addErrorMessage((String)object, this.mInstaller.getErrorMsg());
                } else {
                    this.addSuccessMessage((String)object, this.mInstaller.getSuccessMsg());
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                InstallExtensionsFromInternetDlg.this.deleteDir((String)object3);
                return;
            }
            InstallExtensionsFromInternetDlg.this.deleteDir(object3);
            InstallExtensionsFromInternetDlg.this.mProgressDlg.setWorkDone(true);
            InstallExtensionsFromInternetDlg.this.mProgressDlg.dispose();
        }
    }

    class ExtensionDownloader
    implements Runnable {
        private ArrayList<String> mFaildDownloadExtensions = new ArrayList();
        private String mDestDir = "";

        public ExtensionDownloader(String string) {
            this.mDestDir = string;
        }

        public ArrayList<String> getFaildedExtensins() {
            return (ArrayList)this.mFaildDownloadExtensions.clone();
        }

        @Override
        public void run() {
            Object object;
            Object object22;
            Vector vector = FileLocationsUtil.getExtensionsPathes();
            Object object3 = null;
            for (Object object22 : vector) {
                object22 = ((String)object22).endsWith(File.separator) ? (String)object22 + Calendar.getInstance().getTimeInMillis() : (String)object22 + File.separator + Calendar.getInstance().getTimeInMillis();
                object = new File((String)object22);
                if (!((File)object).mkdirs()) continue;
                object3 = object22;
                break;
            }
            ArrayList<String> arrayList = ((InstalledBundlesFromInternetTableModel)InstallExtensionsFromInternetDlg.this.mTableBundlesList.getModel()).getSelectedExtensionnames();
            if (object3 == null) {
                object22 = arrayList.iterator();
                while (object22.hasNext()) {
                    object = (String)object22.next();
                    this.mFaildDownloadExtensions.add((String)object);
                }
                return;
            }
            object22 = arrayList.iterator();
            while (object22.hasNext()) {
                object = (String)object22.next();
                String string = ExtensionsManager.getExtensionsManager().downloadExtension((String)object, (String)object3);
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (string == null) {
                    this.mFaildDownloadExtensions.add((String)object);
                    continue;
                }
                File file = new File(this.mDestDir + File.separator + new File(string).getName());
                PesFile pesFile = PES_Repository.getPesFile((String)file.getAbsolutePath());
                if (pesFile != null) {
                    String string2;
                    int n = PES_Repository.MapFilterToMimeType((String)"(*.spe)");
                    String string3 = PES_Repository.StoreToPES((File)new File(string), (PesFile)pesFile, (int)n, (String)(string2 = ComponentState.getCurrentCharset().displayName()));
                    if (string3 != null && string3.length() > 0) {
                        this.mFaildDownloadExtensions.add((String)object);
                    }
                    PES_Repository.removeFromPesCache((File)file);
                    continue;
                }
                File file2 = new File(string);
                file2.renameTo(file);
            }
            InstallExtensionsFromInternetDlg.this.deleteDir(object3);
            InstallExtensionsFromInternetDlg.this.mProgressDlg.setWorkDone(true);
            InstallExtensionsFromInternetDlg.this.mProgressDlg.dispose();
        }
    }

    class HelpAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InstallExtensionsFromInternetDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProcedureDlgMgr.getMgr().saveDialogSize(InstallExtensionsFromInternetDlg.this.getIActionKey(), InstallExtensionsFromInternetDlg.this.getSize());
            InstallExtensionsFromInternetDlg.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (InstallExtensionsFromInternetDlg.this.mRadioButtonDownloadOnly.isSelected() && !InstallExtensionsFromInternetDlg.this.validateTargetFile()) {
                return;
            }
            String string = ExtensionsManager.getExtensionsManager().getTermOfUseFileLocation();
            if (InstallExtensionsFromInternetDlg.this.mTermOfUseDlg == null) {
                InstallExtensionsFromInternetDlg.this.mTermOfUseDlg = new DeveloperWorksTermsOfUseDlg(InstallExtensionsFromInternetDlg.this, string);
            }
            InstallExtensionsFromInternetDlg.this.mTermOfUseDlg.initAcceptStateToUnAccept();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InstallExtensionsFromInternetDlg.this.mTermOfUseDlg.moveToMainConent();
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InstallExtensionsFromInternetDlg.this.mTermOfUseDlg.moveToMainConent();
                }
            });
            for (n = 0; n < 10; ++n) {
                try {
                    TimeUnit.MICROSECONDS.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            InstallExtensionsFromInternetDlg.this.mTermOfUseDlg.setVisible(true);
            for (n = 0; n < 10; ++n) {
                try {
                    TimeUnit.MICROSECONDS.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!InstallExtensionsFromInternetDlg.this.mTermOfUseDlg.isAccepted()) {
                return;
            }
            InstallExtensionsFromInternetDlg.this.dispose();
            if (InstallExtensionsFromInternetDlg.this.mRadioButtonDownloadOnly.isSelected()) {
                InstallExtensionsFromInternetDlg.this.downloadExtensions(InstallExtensionsFromInternetDlg.this.mTextFieldTargetFolder.getText());
            } else {
                InstallExtensionsFromInternetDlg.this.downloadAndInstallExtensions();
            }
        }
    }

    class prerequisitiesTextRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private final String linkData;

        prerequisitiesTextRenderer() {
            this.linkData = InstallExtensionsFromInternetDlg.this.getResString("IDS_EXTENSION_BUNDELS_DLG_TABLE_PREREQUISTIES_NO");
        }

        @Override
        public void setValue(Object object) {
            if (object.equals(this.linkData)) {
                this.setForeground(Color.BLUE);
                super.setValue("<HTML><U>" + object + "</U></HTML>");
            } else {
                super.setValue(object);
            }
            this.setHorizontalAlignment(0);
        }
    }
}

