/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.bundle_from_internet;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_from_internet.StatisticsEnv;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer.ExtensionBundleHelper;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer.ExtensionBundlesManager;
import com.spss.uitools.developerworks.core.ExtensionInfo;
import com.spss.uitools.developerworks.core.ExtensionInfoManager;
import com.spss.uitools.developerworks.util.LotusConnectionConnector;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ExtensionsManager {
    private static ExtensionsManager mManager = null;
    private ArrayList<ExtensionInfo> mExtensionInfos = null;
    private String mSelectedExtensionName;
    private static long mLastTimeToGetAllExtensions = 0L;
    private final long UPDATE_LOCAL_EXTENSION_INFO_DURATION = 3600000L;

    private static ArrayList<String> getExtensionInstallAddress() {
        return StatisticsEnv.getStatisticsEnv().getDownloadExtensionServerUrls();
    }

    private ExtensionsManager() {
    }

    public static boolean isAnyDownloadServerConnectable() {
        boolean bl = false;
        ArrayList<String> arrayList = ExtensionsManager.getExtensionInstallAddress();
        for (String string : arrayList) {
            if (!LotusConnectionConnector.isConnectable((String)string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public ArrayList<ExtensionInfo> getExtensions() {
        ExtensionInfoManager extensionInfoManager = ExtensionInfoManager.getExtensionInfoManager(ExtensionsManager.getExtensionInstallAddress());
        long l = System.currentTimeMillis();
        long l2 = l - mLastTimeToGetAllExtensions;
        this.mExtensionInfos = l2 > 3600000L ? extensionInfoManager.getAllExtensionInfoFromInternet() : extensionInfoManager.getAllExtensionInfo();
        ExtensionBundlesManager extensionBundlesManager = ExtensionBundlesManager.getExtensionBundlesManager();
        for (ExtensionInfo extensionInfo : this.mExtensionInfos) {
            ExtensionBundleHelper extensionBundleHelper = null;
            String string = extensionInfo.getName();
            extensionBundleHelper = extensionBundlesManager.getExtensionBundleHelper(string);
            if (extensionBundleHelper == null) {
                if (string.contains(" ")) {
                    string = string.replace(" ", "_");
                } else if (string.contains("_")) {
                    string = string.replace("_", " ");
                }
                extensionBundleHelper = extensionBundlesManager.getExtensionBundleHelper(string);
            }
            if (extensionBundleHelper == null) continue;
            extensionInfo.setIsInstalled(true);
            extensionInfo.setInstalledVersion(extensionBundleHelper.getVersion());
        }
        Collections.sort(this.mExtensionInfos, new ExtensionInfoSorter());
        mLastTimeToGetAllExtensions = System.currentTimeMillis();
        return (ArrayList)this.mExtensionInfos.clone();
    }

    public static ExtensionsManager getExtensionsManager() {
        if (mManager == null) {
            mManager = new ExtensionsManager();
        }
        return mManager;
    }

    public int getMinStatisticsVersion(String string) {
        int n = 17;
        ArrayList<ExtensionInfo> arrayList = this.getExtensions();
        for (ExtensionInfo extensionInfo : arrayList) {
            String string2 = extensionInfo.getName();
            if (string2 == null || !string2.equals(string)) continue;
            n = extensionInfo.getStatisticsMajorVersion();
        }
        return n;
    }

    public boolean isNeedUpdate(String string) {
        boolean bl = false;
        ArrayList<ExtensionInfo> arrayList = this.getExtensions();
        for (ExtensionInfo extensionInfo : arrayList) {
            String string2 = extensionInfo.getName();
            if (string2 == null || !string2.equals(string)) continue;
            bl = extensionInfo.canUpdate();
        }
        return bl;
    }

    public void setSelectedExtensionName(String string) {
        this.mSelectedExtensionName = string;
    }

    public boolean isExtensionInclude(String string, String string2) {
        if (string.trim().isEmpty()) {
            return true;
        }
        List<String> list = Arrays.asList(string.trim().toLowerCase().split("\\s+"));
        boolean bl = false;
        ExtensionInfo extensionInfo = this.getExtension(string2);
        if (extensionInfo == null) {
            return false;
        }
        String string3 = extensionInfo.getDescription(PrefsMgr.getILangTag());
        string3 = string3.toLowerCase();
        for (String string4 : list) {
            if (!string3.contains(string4)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String getSelectedExtensionName() {
        return this.mSelectedExtensionName;
    }

    private ExtensionInfo getExtension(String string) {
        ExtensionInfo extensionInfo = null;
        ArrayList<ExtensionInfo> arrayList = this.getExtensions();
        for (ExtensionInfo extensionInfo2 : arrayList) {
            String string2 = extensionInfo2.getName();
            if (string2 == null || !string2.equals(string)) continue;
            extensionInfo = extensionInfo2;
        }
        return extensionInfo;
    }

    public String downloadExtension(String string, String string2) {
        String string3;
        ExtensionInfo extensionInfo = this.getExtension(string);
        boolean bl = extensionInfo.getExtensionFile(new File(string3 = string2 + File.separator + string.replace(" ", "_") + ".spe"));
        if (bl) {
            return string3;
        }
        return null;
    }

    public String getTermOfUseFileLocation() {
        return ExtensionInfo.getTermOfUseFile().getAbsolutePath();
    }

    public boolean isPythonPluginRequired(String string) {
        ExtensionInfo extensionInfo = this.getExtension(string);
        return extensionInfo.isPlugInRequired(ExtensionInfo.PLURIN_TYPE.PYTHON);
    }

    public boolean isRPluginRequried(String string) {
        ExtensionInfo extensionInfo = this.getExtension(string);
        return extensionInfo.isPlugInRequired(ExtensionInfo.PLURIN_TYPE.R);
    }

    public boolean isJavaPluginRequired(String string) {
        ExtensionInfo extensionInfo = this.getExtension(string);
        return extensionInfo.isPlugInRequired(ExtensionInfo.PLURIN_TYPE.JAVA);
    }

    private class ExtensionInfoSorter
    implements Comparator<ExtensionInfo> {
        private ExtensionInfoSorter() {
        }

        @Override
        public int compare(ExtensionInfo extensionInfo, ExtensionInfo extensionInfo2) {
            return extensionInfo.getName().compareToIgnoreCase(extensionInfo2.getName());
        }
    }
}

