/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.bundle_from_internet;

import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_from_internet.ExtensionsManager;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_from_internet.StatisticsEnv;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer.DialogsToolTipJTable;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ExtensionBundleRequirementsDlg
extends BaseDialog {
    private static final long serialVersionUID = 1L;
    private JPanel mMainPanel;
    private JTextArea mInfoTextArea;
    private JLabel mInfoTextImageLabel;
    private JTable mRequirementTable;
    private JScrollPane mRequirmentTableScroolPane;
    private static final int mTableWidth = 500;
    private static final int mTableHeight = 123;
    private static final int mTableRowHeight = 24;
    private String mExtensionName;

    public ExtensionBundleRequirementsDlg(BaseDialog baseDialog, String string, String string2) {
        super(baseDialog, string, true, ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), UtilitiesResBundle.getImageFolder());
        this.mExtensionName = string2;
        this.deployUI();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo((Component)baseDialog);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "faq_plugins");
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        JButton jButton = new JButton(new CloseAction());
        JButton jButton2 = new JButton((Action)this.createHelpAction());
        if (UIToolDialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                DialogUtil.setupMacHelpButton(jButton2);
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    protected void init() {
        super.init();
    }

    private void deployUI() {
        this.initVariables();
        JPanel jPanel = this.getViewPanel();
        this.setupMainPanel(jPanel);
        this.pack();
        this.adjustColumnPreferredWidth(this.mRequirementTable);
    }

    private void adjustColumnPreferredWidth(JTable jTable) {
        int n = 10;
        ((DialogsToolTipJTable)jTable).fitColumnToWidestEntry(0, n);
        ((DialogsToolTipJTable)jTable).fitColumnToWidestEntry(1, n);
        ((DialogsToolTipJTable)jTable).fitColumnToWidestEntry(1, n);
    }

    private void initVariables() {
        this.mInfoTextArea = new JTextArea(this.getResString("IDS_EXTENSION_BUNDLE_REQUIREMENTS_INTRODUCTION").replace("{0}", this.mExtensionName));
        this.mInfoTextArea.setEditable(false);
        this.mInfoTextArea.setOpaque(false);
        this.mInfoTextArea.setFocusable(false);
        this.mInfoTextArea.setWrapStyleWord(true);
        this.mInfoTextArea.setLineWrap(false);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_DOC_VERSION_WARNING_IMAGE"));
        this.mInfoTextImageLabel = new JLabel();
        this.mInfoTextImageLabel.setIcon(new ImageIcon(uRL));
        this.mRequirementTable = new DialogsToolTipJTable(new RequirmentsTableModel(this.mExtensionName)){

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                switch (n2) {
                    case 1: 
                    case 2: {
                        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
                        defaultTableCellRenderer.setHorizontalAlignment(0);
                        return defaultTableCellRenderer;
                    }
                }
                return super.getCellRenderer(n, n2);
            }
        };
        Dimension dimension = new Dimension(500, 123);
        this.mRequirementTable.setMinimumSize(dimension);
        this.mRequirementTable.setSelectionMode(0);
        this.mRequirementTable.getTableHeader().setReorderingAllowed(false);
        this.mRequirementTable.setRowHeight(24);
        ((DefaultTableCellRenderer)this.mRequirementTable.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
        this.mRequirmentTableScroolPane = new JScrollPane(this.mRequirementTable);
        this.mRequirmentTableScroolPane.setPreferredSize(this.mRequirementTable.getMinimumSize());
        this.mRequirmentTableScroolPane.setHorizontalScrollBarPolicy(30);
        this.mRequirmentTableScroolPane.setVerticalScrollBarPolicy(20);
    }

    private void setupMainPanel(JPanel jPanel) {
        this.mMainPanel = new JPanel();
        this.mMainPanel.setFocusable(true);
        this.mMainPanel.setLayout(new GridBagLayout());
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.bottom += 5;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 18;
        DialogUtil.addUsingGBL(this.mMainPanel, this.mInfoTextImageLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mMainPanel, this.mInfoTextArea, gridBagConstraints, 1, 0, 1, 1, n, new Insets(insets.top + 15, insets.left + 10, insets.bottom, insets.right));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mMainPanel, this.mRequirmentTableScroolPane, gridBagConstraints, 0, 1, 6, 1, n, new Insets(insets.top + 15, insets.left + 50, insets.bottom, insets.right));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets2 = new Insets(0, 0, 0, 0);
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mMainPanel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
    }

    class RequirmentsTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private Class[] types;
        private ArrayList<Object[]> mTableData;

        public RequirmentsTableModel(String string) {
            this.columnNames = new String[]{ExtensionBundleRequirementsDlg.this.getResString(""), ExtensionBundleRequirementsDlg.this.getResString("IDS_EXTENSION_BUNDELS_REQUIREMENTS_TABLE_REQUIRED"), ExtensionBundleRequirementsDlg.this.getResString("IDS_EXTENSION_BUNDELS_REQUIREMENTS_TABLE_Installed")};
            this.types = new Class[]{String.class, String.class, String.class};
            this.mTableData = new ArrayList();
            String string2 = string;
            if (string2.startsWith("*")) {
                string2 = string2.substring(1);
            }
            ExtensionsManager extensionsManager = ExtensionsManager.getExtensionsManager();
            boolean bl = extensionsManager.isPythonPluginRequired(string2);
            boolean bl2 = extensionsManager.isRPluginRequried(string2);
            boolean bl3 = extensionsManager.isJavaPluginRequired(string2);
            this.addTableData(ExtensionBundleRequirementsDlg.this.getResString("IDS_EXTENSION_BUNDELS_REQUIREMENTS_TABLE_SPSS_VERSION"), ">=" + extensionsManager.getMinStatisticsVersion(extensionsManager.getSelectedExtensionName()), StatisticsEnv.getStatisticsEnv().getStatsMajorVersion() + "");
            this.addTableData(ExtensionBundleRequirementsDlg.this.getResString("IDS_EXTENSION_BUNDELS_REQUIREMENTS_TABLE_PYTHON_PLUGIN_REQUIRED"), bl, StatisticsEnv.getStatisticsEnv().isPythonPluginInstalled());
            this.addTableData(ExtensionBundleRequirementsDlg.this.getResString("IDS_EXTENSION_BUNDELS_REQUIREMENTS_TABLE_R_PLUGIN_REQUIRED"), bl2, StatisticsEnv.getStatisticsEnv().isRPluginInstalled());
            this.addTableData(ExtensionBundleRequirementsDlg.this.getResString("IDS_EXTENSION_BUNDELS_REQUIREMENTS_TABLE_JAVA_PLUGIN_REQUIRED"), bl3, StatisticsEnv.getStatisticsEnv().isJavaPlugInInstalled());
        }

        public void addTableData(String string, Boolean bl, Boolean bl2) {
            String string2 = bl != false ? ExtensionBundleRequirementsDlg.this.getResString("IDS_EXTENSION_BUNDELS_DLG_TABLE_PREREQUISTIES_YES") : ExtensionBundleRequirementsDlg.this.getResString("IDS_EXTENSION_BUNDELS_DLG_TABLE_PREREQUISTIES_NO");
            String string3 = bl2 != false ? ExtensionBundleRequirementsDlg.this.getResString("IDS_EXTENSION_BUNDELS_DLG_TABLE_PREREQUISTIES_YES") : ExtensionBundleRequirementsDlg.this.getResString("IDS_EXTENSION_BUNDELS_DLG_TABLE_PREREQUISTIES_NO");
            this.mTableData.add(new Object[]{string, string2, string3});
        }

        public void addTableData(String string, String string2, String string3) {
            this.mTableData.add(new Object[]{string, string2, string3});
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.mTableData.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.mTableData.get(n)[n2];
        }

        public Class getColumnClass(int n) {
            return this.types[n];
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public ArrayList<Object[]> getData() {
            return this.mTableData;
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CLOSE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExtensionBundleRequirementsDlg.this.dispose();
        }
    }
}

