/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.bundle_from_internet;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_install_utility.ExtensionBundleManifestHelper;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_viewer.ExtensionBundleHelper;
import com.spss.java_client.ui.doc_types.actions.InstallDlgAction;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.shared.core_tools.file.SpssFile;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.ConsumeStream;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.ui_builder.SpecificationBuilder;
import com.spss.uitools.ui_builder.definition.AddOnType;
import com.spss.uitools.ui_builder.definition.CommandLocation;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.util.IniHandler;
import com.spss.uitools.util.PASWFileUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ExtensionBundleInstaller {
    private File mSpeRepositoryFile;
    private PesFile mRepositoryFile;
    private String mErrorMsg;
    private String mSuccessMsg;
    private File mSpeFile;
    private String mBundleName;
    private File mRPath;
    private boolean bRInstalled = false;
    private File mPythonPath;
    private boolean bPythonInstalled = false;
    private boolean bInstallCustomDialogs = true;
    private boolean bDownloadRPackages = true;
    private boolean bUseExVerPath = false;
    private File mNameDirectory;
    private ExtensionBundleManifestHelper mManifestHelper;
    private Set<String> mCommandFilesPath;
    private boolean bCommandFiles = false;
    static final String EXTENSION_BUNDLE_BAD_VERSION_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_BAD_VERSION_MSG";
    static final String EXTENSION_BUNDLE_R_PLUGIN_MISSING_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_R_PLUGIN_MISSING_MSG";
    static final String EXTENSION_BUNDLE_R_PROGRAMMABILITY = "IDS_INSTALL_EXTENSION_BUNDLE_R_PROGRAMMABILITY";
    static final String EXTENSION_BUNDLE_PYTHON_PROGRAMMABILITY = "IDS_INSTALL_EXTENSION_BUNDLE_PYTHON_PROGRAMMABILITY";
    static final String EXTENSION_BUNDLE_MSG1_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG1_TEXT";
    static final String EXTENSION_BUNDLE_MSG2_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG2_TEXT";
    static final String EXTENSION_BUNDLE_MSG3_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG3_TEXT";
    static final String EXTENSION_BUNDLE_MSG4_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG4_TEXT";
    static final String EXTENSION_BUNDLE_MSG5_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG5_TEXT";
    static final String EXTENSION_BUNDLE_MSG6_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG6_TEXT";
    static final String EXTENSION_BUNDLE_MSG7_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG7_TEXT";
    static final String EXTENSION_BUNDLE_OUT_OF_DISK_SPACE_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_OUT_OF_DISK_SPACE_MSG";
    static final String EXTENSION_BUNDLE_NOT_FOUND1_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_NOT_FOUND1_MSG";
    static final String EXTENSION_BUNDLE_NOT_FOUND2_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_NOT_FOUND4_MSG";
    static final String EXTENSION_BUNDLE_SUCCESSFULL_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_SUCCESSFULL_MSG";
    static final String DW_TERMS_OF_USE_FOLDER = "dWTermsOfUse";
    static final String DW_TERMS_OF_USE_FILE = "dWTermsOfUse.html";
    static final String DW_TERMS_OF_USE_ENTRY = "dWTermsOfUse/dWTermsOfUse.html";
    static final String TEMPLATE_SUFFIX = ".viztemplate";
    private String mInstalledDlgMenuString;
    private boolean mBothHaveSpdAndCfe;
    private String mInstalledExtensionFilesPath;
    private String mInstalledCDBFilesPath;
    static final String PYTHON_JAR_FILE_NAME = "pythoncfg.jar";
    private static final String m_externalRPref = "/com/ibm/SPSS/externalr/";

    public String getSuccessMsg() {
        return this.mSuccessMsg;
    }

    public void setSuccessMsg(String string) {
        this.mSuccessMsg = string;
    }

    private boolean processSpeFile() {
        boolean bl = false;
        if (this.readManifest() && this.checkForCorrectVersion() && this.checkForRPackages() && this.checkIfPlugInsAreRequired() && this.createNameDirectoryUnderExtensionsDirectory() && this.writeCodeFilesToDirectory() && this.writeCommandFilesToDirectories() && this.writeSpeFileToNameDirectory() && this.writerDWLicenseFileToNameDirectory() && this.writeMiscFilesToDirectory()) {
            if (this.unzipSpdFileToDirectory()) {
                if (this.unzipTranslationCataloguesDirectory() && this.downloadRPackagesIfNeededFromInternet() && this.installVizTemplate()) {
                    String string = BuilderResUtil.getString((String)EXTENSION_BUNDLE_SUCCESSFULL_MSG);
                    string = MessageFormat.format(string, this.mBundleName);
                    if (this.mInstalledDlgMenuString.length() > 0) {
                        String string2 = MessageFormat.format(BuilderResUtil.getString((String)"IDS_INSTALL_CUSTOM_DIALOG_FOR_EXTENSION_SUCCESSFULLY"), this.mManifestHelper.getBundleName(), this.mInstalledDlgMenuString);
                        string = string + "\n";
                        string = string + string2;
                    }
                    if (this.mBothHaveSpdAndCfe) {
                        string = string + "\n";
                        string = string + BuilderResUtil.getString((String)"IDS_INSTALL_EXTENSION_BUNDLE_SPD_NOT_INSTALLED_MSG");
                    }
                    this.setSuccessMsg(string);
                    bl = true;
                }
            } else {
                BuilderUtil.getInstance().deleteFolder(this.mNameDirectory);
            }
        }
        return bl;
    }

    private void init() {
        this.mSpeFile = null;
        this.mSpeRepositoryFile = null;
        this.mRepositoryFile = null;
        this.mRPath = null;
        this.mPythonPath = null;
        this.mNameDirectory = null;
        this.mBundleName = null;
        this.bRInstalled = false;
        this.bPythonInstalled = false;
        this.mErrorMsg = "";
        this.mCommandFilesPath = new HashSet<String>();
        this.bCommandFiles = false;
        this.mInstalledDlgMenuString = "";
        this.mBothHaveSpdAndCfe = false;
        this.mInstalledCDBFilesPath = "";
        this.mInstalledExtensionFilesPath = "";
    }

    public String getInstalledExtensionFilesPath() {
        return this.mInstalledExtensionFilesPath;
    }

    public String getInstalledCDBFilesPath() {
        return this.mInstalledCDBFilesPath;
    }

    private void setInstalledExtensionFilesPath(String string) {
        this.mInstalledExtensionFilesPath = string;
    }

    private void setInstalledDBFilesPath(String string) {
        this.mInstalledCDBFilesPath = string;
    }

    public boolean doInstall(File file) {
        boolean bl = false;
        this.init();
        if (this.setupSpeFileAndCheckForPES(file)) {
            bl = this.processSpeFile();
            if (this.mRepositoryFile != null) {
                this.mSpeFile = this.mSpeRepositoryFile;
                PES_Repository.removeFromPesCache((File)file);
            }
            if (bl) {
                for (String string : this.mCommandFilesPath) {
                    SyntaxMgr.getSyntaxMgr().executeSyntax("EXTENSION /SPECIFICATION COMMAND='" + string + "'.");
                }
            }
        }
        return bl;
    }

    private void setErrorMsg(String string) {
        this.mErrorMsg = string;
    }

    public String getErrorMsg() {
        return this.mErrorMsg;
    }

    private boolean setupSpeFileAndCheckForPES(File file) {
        this.mSpeRepositoryFile = file;
        this.mRepositoryFile = PES_Repository.getPesFile((String)file.getAbsolutePath());
        if (this.mRepositoryFile != null) {
            String string = PES_Repository.RetrieveFromPES((PesFile)this.mRepositoryFile);
            file = this.mRepositoryFile.getCacheFile();
            if (file == null) {
                if (string != null && string.length() > 0) {
                    this.setErrorMsg(string);
                }
                return false;
            }
        }
        this.mSpeFile = file;
        return true;
    }

    private boolean readManifest() {
        boolean bl = true;
        try {
            this.mManifestHelper = new ExtensionBundleManifestHelper(this.mSpeFile);
            this.mBundleName = this.mManifestHelper.getBundleName();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private boolean checkForCorrectVersion() {
        int[] nArray = new int[]{0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        StringTokenizer stringTokenizer = new StringTokenizer(VersionInfo.getVersionString(), ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(this.mManifestHelper.getProductVersion(), ".");
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray2[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        boolean bl = this.checkMajorMinorPatchVersions(nArray, nArray2);
        if (!bl) {
            this.setErrorMsg(CoreResUtil.getString((String)EXTENSION_BUNDLE_BAD_VERSION_MSG));
        }
        if (bl) {
            String string = this.mManifestHelper.getPythonVersion();
            this.bUseExVerPath = string != null && string.compareTo("3") == 0;
        }
        return bl;
    }

    private boolean checkMajorMinorPatchVersions(int[] nArray, int[] nArray2) {
        boolean bl = true;
        if (nArray[0] < nArray2[0]) {
            bl = false;
        } else if (nArray[0] == nArray2[0]) {
            if (nArray[1] < nArray2[1]) {
                bl = false;
            } else if (nArray[1] == nArray2[1]) {
                if (nArray[2] < nArray2[2]) {
                    bl = false;
                } else if (nArray[2] == nArray2[2] && nArray[3] < nArray2[3]) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean checkForRPackages() {
        boolean bl = true;
        if (this.mManifestHelper.getRLocationSet().size() > 0) {
            this.setRInstallerPath();
            if (!this.bRInstalled) {
                this.setErrorMsg(CoreResUtil.getString((String)EXTENSION_BUNDLE_R_PLUGIN_MISSING_MSG));
                bl = false;
            }
        }
        return bl;
    }

    private void setRInstallerPath() {
        String string;
        Object object;
        this.mRPath = null;
        String string2 = "";
        IniHandler iniHandler = ExtensionBundleInstaller.getSpssReaderFromSpssHomeDir("spssdxcfg.ini");
        string2 = ExtensionBundleInstaller.getProfileValue(iniHandler, AddOnType.R.toString(), "HOME");
        if (string2.isEmpty()) {
            object = VersionInfo.getMajorMinorVersionString();
            string = m_externalRPref + (String)object;
            try {
                if (Preferences.userRoot().nodeExists(string)) {
                    Preferences preferences = Preferences.userRoot().node(string);
                    string2 = preferences.get("r_path", string2);
                }
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
            }
        }
        if (string2.equals("")) {
            return;
        }
        object = new File(string2);
        try {
            string2 = ((File)object).getCanonicalPath();
            if (!string2.equals("")) {
                if (!string2.endsWith(File.separator + "bin" + File.separator) && !string2.endsWith(File.separator + "bin")) {
                    string2 = string2.endsWith(File.separator) ? string2 + "bin" + File.separator : string2 + File.separator + "bin" + File.separator;
                }
                if (!string2.endsWith(File.separator)) {
                    string2 = string2 + File.separator;
                }
                string = string2 + "R";
                if (OSCheck.getOSType() == OSInfo.OSType.WIN) {
                    string = string + ".exe";
                }
                this.mRPath = new File(string);
                if (this.mRPath.exists()) {
                    this.bRInstalled = true;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setPythonInstallerPath() {
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("application.home"));
        String string = stringBuffer.append(File.separator) + PYTHON_JAR_FILE_NAME;
        this.mPythonPath = new File(string);
        if (this.mPythonPath.exists()) {
            this.bPythonInstalled = true;
        }
    }

    private File createDirectoryUnderExtensionsDirectory(String string) {
        boolean bl = true;
        boolean bl2 = false;
        File file = null;
        Vector vector = FileLocationsUtil.getExtensionsPathes((boolean)this.bUseExVerPath);
        for (String string2 : vector) {
            string2 = string2.endsWith(File.separator) ? string2 + string : string2 + File.separator + string;
            file = new File(string2);
            if (file.exists() && file.isDirectory()) {
                File file2;
                bl2 = true;
                String string3 = string2 + "_" + Calendar.getInstance().getTimeInMillis();
                bl = SpssFile.deleteDirectory((File)file, (String)string3);
                if (bl) {
                    bl = file.mkdir();
                }
                if (!(file2 = new File(string3)).exists()) break;
                file2.delete();
                break;
            }
            if (file.exists() || !(bl = file.mkdir()) || !file.exists()) continue;
            break;
        }
        if (!bl) {
            Object object = "";
            object = bl2 && OSInfo.getOSType() == OSInfo.OSType.WIN ? MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_MSG7_MSG), file.getAbsolutePath().toString()) : CoreResUtil.getString((String)EXTENSION_BUNDLE_MSG3_MSG) + CoreResUtil.getString((String)EXTENSION_BUNDLE_MSG6_MSG) + vector;
            this.setErrorMsg((String)object);
            file = null;
        }
        return file;
    }

    private boolean createNameDirectoryUnderExtensionsDirectory() {
        boolean bl = false;
        String string = this.mBundleName.replaceAll(" ", "_");
        File file = this.createDirectoryUnderExtensionsDirectory(string);
        if (file != null) {
            this.mNameDirectory = file;
            bl = true;
            this.setInstalledExtensionFilesPath(file.getParentFile().getAbsolutePath());
        }
        return bl;
    }

    public String getPathWhereExtensionActuallyInstalled() {
        if (this.mNameDirectory == null) {
            return null;
        }
        return this.mNameDirectory.getAbsolutePath();
    }

    private boolean checkIfPlugInsAreRequired() {
        boolean bl = true;
        if (this.mManifestHelper.getDialogSpecsSet().isEmpty() && (this.mManifestHelper.isRPluginInstalled() || this.mManifestHelper.isPythonPluginInstalled())) {
            if (this.mManifestHelper.isRPluginInstalled() && !this.bRInstalled) {
                this.setRInstallerPath();
            }
            if (this.mManifestHelper.isPythonPluginInstalled()) {
                this.setPythonInstallerPath();
            }
            if (this.mManifestHelper.isRPluginInstalled() && !this.bRInstalled || this.mManifestHelper.isPythonPluginInstalled() && !this.bPythonInstalled) {
                Vector<String> vector = new Vector<String>();
                if (this.mManifestHelper.isRPluginInstalled() && !this.bRInstalled) {
                    vector.add(CoreResUtil.getString((String)EXTENSION_BUNDLE_R_PROGRAMMABILITY));
                }
                if (this.mManifestHelper.isPythonPluginInstalled() && !this.bPythonInstalled) {
                    vector.add(CoreResUtil.getString((String)EXTENSION_BUNDLE_PYTHON_PROGRAMMABILITY));
                }
                String string = CoreResUtil.getString((String)EXTENSION_BUNDLE_MSG1_MSG) + CoreResUtil.getString((String)EXTENSION_BUNDLE_MSG2_MSG) + vector;
                this.setErrorMsg(string);
                bl = false;
            }
        }
        return bl;
    }

    private boolean writeCodeFilesToDirectory() {
        return this.writeFilesToExtensionsDirectory(this.mManifestHelper.getCodeFilesSet());
    }

    private boolean writeCommandFilesToDirectories() {
        this.bCommandFiles = true;
        boolean bl = this.writeFilesToExtensionsDirectory(this.mManifestHelper.getCommandSpecsSet());
        this.bCommandFiles = false;
        return bl;
    }

    private boolean writeSpeFileToNameDirectory() {
        boolean bl;
        try {
            File file = PASWFileUtil.createTempFile((String)this.mSpeFile.getName(), (String)".spe", (File)this.mNameDirectory);
            DocUtil.copyFile(this.mSpeFile, file);
            bl = file.renameTo(new File(this.mNameDirectory.getAbsolutePath() + File.separator + this.mSpeFile.getName()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writerDWLicenseFileToNameDirectory() {
        boolean bl = true;
        ZipInputStream zipInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(this.mSpeFile));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String string = zipEntry.getName();
                if (string.equals(DW_TERMS_OF_USE_ENTRY)) {
                    int n;
                    String string2 = this.mNameDirectory.getCanonicalPath() + File.separator + DW_TERMS_OF_USE_FOLDER;
                    File file = new File(string2);
                    boolean bl2 = file.mkdirs();
                    if (!bl2) {
                        boolean bl3 = bl = false;
                        return bl3;
                    }
                    String string3 = string2 + File.separator + DW_TERMS_OF_USE_FILE;
                    fileOutputStream = new FileOutputStream(string3);
                    byte[] byArray = new byte[1024];
                    while ((n = zipInputStream.read(byArray)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception exception) {
            boolean bl4 = bl = false;
            return bl4;
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    private String getBatchRString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        String string = VersionInfo.getMajorMinorVersionString();
        String string2 = m_externalRPref + string;
        String string3 = "";
        try {
            if (Preferences.userRoot().nodeExists(string2)) {
                object = Preferences.userRoot().node(string2);
                string3 = ((Preferences)object).get("lib_path", string3);
            }
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        if (string3.isEmpty()) {
            bl = true;
        }
        if (!string3.endsWith(File.separator)) {
            string3 = string3 + File.separator;
        }
        File file = bl ? new File(System.getProperty("application.home") + File.separator + "getpkgs.R") : new File(string3 + "getpkgs.R");
        try {
            String string4;
            object = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            while ((string4 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string4).append('\n');
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    private File createTempBatchFile(String string) throws IOException {
        String string2 = PrefsMgr.getPrefsMgr().getTempPath();
        File file = PASWFileUtil.createTempFile((String)"spss", (String)".R", (File)new File(string2));
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file, false);
        fileOutputStream.write(string.getBytes("UTF-8"));
        fileOutputStream.close();
        return file;
    }

    private File createTempRLogFile() throws IOException {
        String string = PrefsMgr.getPrefsMgr().getTempPath();
        File file = PASWFileUtil.createTempFile((String)"spssRLog", (String)".txt", (File)new File(string));
        file.deleteOnExit();
        return file;
    }

    boolean downloadRPackagesIfNeededFromInternet() {
        boolean bl = true;
        if (this.bRInstalled && this.bDownloadRPackages) {
            File file;
            File file2;
            block11: {
                file2 = null;
                file = null;
                try {
                    file2 = this.createTempBatchFile(this.getBatchRString());
                    file = this.createTempRLogFile();
                    Vector<String> vector = new Vector<String>();
                    if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
                        vector.add(System.getProperty("application.home") + File.separator + "runR.bat");
                    } else {
                        vector.add(System.getProperty("application.home") + File.separator + "runR.sh");
                    }
                    File file3 = new File((String)vector.firstElement());
                    if (!file3.exists()) break block11;
                    bl = false;
                    this.makeRCommandLineList(file2, file, vector);
                    try {
                        ProcessBuilder processBuilder = new ProcessBuilder(vector);
                        Process process = processBuilder.start();
                        new ConsumeStream(process.getInputStream(), new PrintStream(new ByteArrayOutputStream()));
                        new ConsumeStream(process.getErrorStream(), new PrintStream(new ByteArrayOutputStream()));
                        if (process.waitFor() == 0) {
                            bl = true;
                            break block11;
                        }
                        Vector<String> vector2 = new Vector<String>();
                        this.readTempRLogFile(file, vector2);
                        this.showErrMsgForRPackagesThatDidNotInstall(vector2);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (file2 != null) {
                file2.delete();
            }
            if (file != null) {
                file.delete();
            }
        }
        return bl;
    }

    private void showErrMsgForRPackagesThatDidNotInstall(Vector<String> vector) {
        String string = MessageFormat.format(CoreResUtil.getString((String)EXTENSION_BUNDLE_NOT_FOUND1_MSG), this.mBundleName) + vector.toString() + CoreResUtil.getString((String)EXTENSION_BUNDLE_NOT_FOUND2_MSG);
        this.setErrorMsg(string);
    }

    private void readTempRLogFile(File file, Vector<String> vector) throws IOException {
        if (file.exists()) {
            String string;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string = bufferedReader.readLine()) != null) {
                vector.add(string);
            }
            bufferedReader.close();
        }
    }

    private void makeRCommandLineList(File file, File file2, Vector<String> vector) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("--vanilla --slave --args");
        for (String string : this.mManifestHelper.getRLocationSet()) {
            stringBuilder.append(' ').append(string);
        }
        stringBuilder.append(" '").append(file2.getAbsolutePath()).append("'");
        vector.add(this.mRPath.getAbsolutePath());
        vector.add("CMD");
        vector.add("BATCH");
        vector.add(stringBuilder.toString());
        vector.add(file.getAbsolutePath());
    }

    private boolean unzipTranslationCataloguesDirectory() {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.mSpeFile);
            zipInputStream = new JarInputStream(fileInputStream);
            String string = this.mManifestHelper.getTranslationCataloguesPath();
            bl = ExtensionBundleHelper.unJarTranslationCataloguesToDirectory((JarInputStream)zipInputStream, this.mNameDirectory.getAbsolutePath(), string);
            zipInputStream.close();
            if (!bl) {
                String string2 = CoreResUtil.getString((String)EXTENSION_BUNDLE_OUT_OF_DISK_SPACE_MSG);
                this.setErrorMsg(string2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            try {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            iOException.printStackTrace();
        }
        return bl;
    }

    private boolean unZipCFEfile(Vector<File> vector) {
        boolean bl = true;
        Vector<String> vector2 = new Vector<String>();
        vector2.add(SpecificationBuilder.getAppDataCustomCFEFolderPath((boolean)this.bUseExVerPath));
        if (vector2.size() > 0) {
            for (String string : vector2) {
                File file = new File(string);
                if (!file.exists() || !file.isDirectory() || !PASWFileUtil.isWritable((File)file)) continue;
                try {
                    File file2;
                    InstallDlgAction installDlgAction;
                    Cloneable cloneable;
                    if (vector.size() == 1) {
                        cloneable = new InstallDlgAction(true);
                        DialogDefinition dialogDefinition = ((InstallDlgAction)cloneable).readPackageFile(vector.get(0), false);
                        if (dialogDefinition != null) {
                            if (!((InstallDlgAction)cloneable).validateSyntaxAndMenuLocation(null, dialogDefinition, true)) {
                                return false;
                            }
                            if (!((InstallDlgAction)cloneable).deployCFSpecification(false, null, dialogDefinition, true, this.bUseExVerPath)) continue;
                            this.mInstalledDlgMenuString = dialogDefinition.getCommandLocation().getUserCommandString((CommandLocation.ResLoader)cloneable).replaceAll("/", ">");
                            continue;
                        }
                        return bl;
                    }
                    cloneable = new Vector();
                    boolean bl2 = true;
                    for (int i = 0; i < vector.size() && bl2; ++i) {
                        installDlgAction = new InstallDlgAction(true);
                        file2 = vector.get(i);
                        DialogDefinition dialogDefinition = installDlgAction.readPackageFile(file2, false);
                        if (dialogDefinition == null) continue;
                        if (!installDlgAction.validateSyntaxAndMenuLocation(null, dialogDefinition, true)) {
                            return false;
                        }
                        ((Vector)cloneable).add(dialogDefinition);
                    }
                    Iterator iterator = ((Vector)cloneable).iterator();
                    while (iterator.hasNext()) {
                        file2 = (DialogDefinition)iterator.next();
                        installDlgAction = new InstallDlgAction(true);
                        installDlgAction.deployCFSpecification(false, null, (DialogDefinition)file2, true, this.bUseExVerPath);
                        this.mInstalledDlgMenuString = this.mInstalledDlgMenuString + file2.getCommandLocation().getUserCommandString((CommandLocation.ResLoader)installDlgAction).replaceAll("/", ">") + "\n";
                    }
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean unzipSpdFileToDirectory() {
        boolean bl = true;
        if (this.bInstallCustomDialogs && !this.mManifestHelper.getDialogSpecsSet().isEmpty()) {
            String string = PrefsMgr.getPrefsMgr().getTempPath();
            Set<String> set = this.mManifestHelper.getDialogSpecsSet();
            Iterator<String> iterator = set.iterator();
            File file = null;
            Vector<File> vector = new Vector<File>();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                if (string2.endsWith(".spd")) {
                    file = new File(string + File.separator + (String)string2);
                    continue;
                }
                if (!string2.endsWith(".cfe")) continue;
                File file2 = new File(string + File.separator + (String)string2);
                vector.add(file2);
            }
            if (file != null && vector.size() > 0) {
                this.mBothHaveSpdAndCfe = true;
            }
            bl = this.writeSpdFileToDirectory(string);
            bl = this.writeFilesToDirectory(set, this.mNameDirectory);
            if (bl) {
                try {
                    if (vector.size() > 0) {
                        bl = this.unZipCFEfile(vector);
                    } else if (file != null) {
                        bl = this.unZipSpdFile(file);
                    }
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            if (file != null && file.exists()) {
                file.delete();
            }
            for (File file2 : vector) {
                file2.deleteOnExit();
            }
        }
        return bl;
    }

    private boolean unZipSpdFile(File file) throws Exception {
        String string;
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = FileLocationsUtil.getSecondaryExtensionDirectory((boolean)this.bUseExVerPath);
        if (stringArray != null && stringArray.length > 0) {
            vector.addAll(Arrays.asList(stringArray));
        }
        if ((string = FileLocationsUtil.getAppdataCustomDialogDirectoryForAllUsers()) != null && !string.isEmpty()) {
            vector.add(string);
        }
        if (System.getProperty("os.name", "Windows").toLowerCase().indexOf("win") >= 0) {
            string = FileLocationsUtil.getAppdataCustomDialogDirectory();
            if (string != null && !string.isEmpty()) {
                vector.add(string);
            }
            if ((string = FileLocationsUtil.getCustomDialogsDirectory()) != null && !string.isEmpty()) {
                vector.add(string);
            }
        } else {
            string = FileLocationsUtil.getCustomDialogsDirectory();
            if (string != null && !string.isEmpty()) {
                vector.add(string);
            }
            if ((string = FileLocationsUtil.getAppdataCustomDialogDirectory()) != null && !string.isEmpty()) {
                vector.add(string);
            }
        }
        if (vector.size() > 0) {
            for (String string2 : vector) {
                DialogDefinition dialogDefinition;
                File file2 = new File(string2);
                if (!file2.exists() || !file2.isDirectory() || !PASWFileUtil.isWritable((File)file2)) continue;
                InstallDlgAction installDlgAction = (InstallDlgAction)ActionCatalog.getActionCatalog().getSpssAction("utilities_install_dialog");
                bl = installDlgAction.deploySpecification(null, dialogDefinition = installDlgAction.readPackageFile(file), false, this.bUseExVerPath);
                if (bl) {
                    this.mInstalledDlgMenuString = dialogDefinition.getCommandLocation().getUserCommandString((CommandLocation.ResLoader)installDlgAction).replaceAll("/", ">");
                }
                this.setInstalledDBFilesPath(file2.getAbsolutePath());
                return bl;
            }
        }
        String string3 = CoreResUtil.getString((String)EXTENSION_BUNDLE_MSG4_MSG) + vector;
        this.setErrorMsg(string3);
        return bl;
    }

    private boolean writeSpdFileToDirectory(String string) {
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        boolean bl = this.writeFilesToFirstWritableDirectory(this.mManifestHelper.getDialogSpecsSet(), vector);
        if (!bl) {
            this.setErrorMsg(CoreResUtil.getString((String)EXTENSION_BUNDLE_MSG4_MSG) + vector);
        }
        return bl;
    }

    private boolean writeMiscFilesToDirectory() {
        return this.writeFilesToDirectory(this.mManifestHelper.getMiscFilesSet(), this.mNameDirectory);
    }

    private boolean writeFilesToDirectory(Set<String> set, File file) {
        Vector<String> vector = new Vector<String>();
        vector.add(file.getAbsolutePath());
        boolean bl = this.writeFilesToFirstWritableDirectory(set, vector);
        return bl;
    }

    private boolean writeFilesToExtensionsDirectory(Set<String> set) {
        Vector vector = FileLocationsUtil.getExtensionsPathes((boolean)this.bUseExVerPath);
        boolean bl = this.writeFilesToFirstWritableDirectory(set, vector);
        return bl;
    }

    private boolean writeFilesToFirstWritableDirectory(Set<String> set, Vector<String> vector) {
        boolean bl = true;
        boolean bl2 = false;
        for (String string : vector) {
            File file = new File(string);
            if (!file.exists() || !file.isDirectory() || !PASWFileUtil.isWritable((File)file)) continue;
            for (String string2 : set) {
                File file2 = this.readAndWriteBundleFile(this.mSpeFile, file, string2);
                if (file2 == null) {
                    bl = false;
                    break;
                }
                if (!this.bCommandFiles) continue;
                this.mCommandFilesPath.add(file2.getAbsolutePath());
            }
            bl2 = true;
            break;
        }
        if (!bl2) {
            bl = false;
        }
        return bl;
    }

    private File readAndWriteBundleFile(File file, File file2, String string) {
        File file3 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            JarInputStream jarInputStream = new JarInputStream(fileInputStream);
            file3 = this.readAndWriteFromJar(jarInputStream, file2, string);
            jarInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return file3;
    }

    private File readAndWriteFromJar(JarInputStream jarInputStream, File file, String string) throws IOException {
        File file2 = null;
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            String string2 = jarEntry.getName();
            if (string2.equals(string)) {
                ByteBuffer byteBuffer = this.readEntry(jarInputStream);
                FileOutputStream fileOutputStream = new FileOutputStream(file.getPath() + File.separator + string2);
                fileOutputStream.write(byteBuffer.array());
                fileOutputStream.close();
                jarInputStream.closeEntry();
                file2 = new File(file.getPath() + File.separator + string2);
                break;
            }
            jarInputStream.closeEntry();
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return file2;
    }

    private ByteBuffer readEntry(JarInputStream jarInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[50000];
        try {
            int n = jarInputStream.read(byArray, 0, 50000);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = jarInputStream.read(byArray, 0, 50000);
            }
        }
        catch (IOException iOException) {
            byteArrayOutputStream.reset();
            iOException.printStackTrace();
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean installVizTemplate() {
        boolean bl = true;
        ZipInputStream zipInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(this.mSpeFile));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String string = zipEntry.getName();
                if (string.endsWith(TEMPLATE_SUFFIX)) {
                    int n;
                    String string2 = this.getVizTemplateDir().getAbsolutePath();
                    String string3 = string2 + File.separator + "templates" + File.separator + string;
                    fileOutputStream = new FileOutputStream(string3);
                    byte[] byArray = new byte[1024];
                    while ((n = zipInputStream.read(byArray)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception exception) {
            boolean bl2 = bl = false;
            return bl2;
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    private File getVizTemplateDir() {
        String string = System.getProperty("user.home");
        if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
            return new File(string, "Application Data/SPSSInc/Graphboard");
        }
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            return new File(string, "Library/Application Support/SPSSInc/Graphboard");
        }
        return new File(string, ".Graphboard");
    }

    public static IniHandler getSpssReaderFromSpssHomeDir(String string) {
        IniHandler iniHandler = null;
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("application.home"));
        stringBuffer.append(File.separatorChar).append(string);
        File file = new File(stringBuffer.toString());
        if (file.exists()) {
            iniHandler = IniHandler.loadIniFile((String)stringBuffer.toString(), (boolean)true, (String)"UTF-8");
        }
        return iniHandler;
    }

    public static String getProfileValue(IniHandler iniHandler, String string, String string2) {
        LinkedList linkedList;
        String string3 = "";
        if (iniHandler != null && (linkedList = iniHandler.getPrivateProfileString(string, string2)) != null && !linkedList.isEmpty()) {
            string3 = (String)linkedList.getFirst();
        }
        return string3;
    }
}

