/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableComparator;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableSortType;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.controls.TableFindManager;
import com.spss.uitools.util.IOptionConstants;
import com.spss.uitools.util.TraceSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class VariablesDlg
extends BaseProcedureDialog
implements ListSelectionListener {
    private static final int VAR_INFO_TABLE_WIDTH = 300;
    private static final int TABLE_WIDTH = 160;
    private static final int TABLE_HEIGHT = 200;
    private static final int LIST_WIDTH = 200;
    private static final int FIRST_COL_PREF_WIDTH = 20;
    private static final int FIRST_COL_MAX_WIDTH = 50;
    private static final int SECOND_COL_WIDTH = 130;
    private static final int ROW_HIGHT = 20;
    private static final int VISIBLE_COLUMN = 0;
    private static final int VARIABLE_COLUMN = 1;
    private static final String VAR_INFO_LABEL = "IDS_UTILITIES_VARIABLES_INFO_LABEL";
    private static final String VAR_INFO_LIST = "IDS_VAR_INFO_LIST";
    private static final String VAR_INFO_CONTEXT_MENU = "IDS_UTILITIES_VARIABLES_VARINFO_CONTEXT_MSG";
    private static final int VAR_INFO_PADX = 150;
    private static final int VAR_INFO_PADY = 50;
    public static final int VAR_NAME_ROW = 0;
    public static final int VAR_LABEL_ROW = 1;
    public static final int VAR_TYPE_ROW = 2;
    public static final int VAR_MISSING_VALUE_ROW = 3;
    public static final int VAR_MEASUREMENT_LEVEL_ROW = 4;
    JTable mGeneralVarInfoTable;
    GeneralVarInfoTableModel mGeneralVarInfoTableModel;
    JScrollPane mGeneralVarInfoScrollPane;
    JTable mValueLabelsInfoTable;
    ValueLabelsInfoTableModel mValueLabelsInfoTableModel;
    JScrollPane mValueLabelsInfoScrollPane;
    private JTable mVariableTable;
    private JScrollPane mVariableTableScrollPane;
    private Vector<ISpssVariable> mVariables;
    private ArrayList<SheetData> mSheetData;
    private JFrame mParentFrame;

    public VariablesDlg(JFrame jFrame) {
        super(jFrame, false, UtilitiesResBundle.getDefaultResourceBundleName(), UtilitiesResBundle.getImageFolder());
        this.mParentFrame = jFrame;
        this.setTitle(this.getResString("IDS_UTILITIES_VARIABLES_TITLE"));
        this.setLocationRelativeTo(jFrame);
    }

    @Override
    public String getIActionKey() {
        return "utilities_variables";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_varw";
    }

    public String privateGenerateSyntax() {
        String string = "";
        int[] nArray = this.mVariableTable.getSelectedRows();
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[nArray.length];
        for (SheetData sheetData : this.mSheetData) {
            for (int i = 0; i < nArray.length; ++i) {
                ISpssVariable iSpssVariable = (ISpssVariable)this.mVariableTable.getModel().getValueAt(nArray[i], 0);
                if (!sheetData.getVariable().getId().equals((Object)iSpssVariable.getId())) continue;
                iSpssVariableArray[i] = sheetData.getVariable();
                String string2 = iSpssVariableArray[i].getName();
                string = this.concatinateWithBidi(string, string2);
            }
        }
        return string;
    }

    private String concatinateWithBidi(String string, String string2) {
        if (!ComponentState.isBtdRtlOrLtr()) {
            string = string2 != null && string2.length() > 0 && ComponentState.containsBidiLetter((String)string2) && (ComponentState.isBidiLetter((char)string2.charAt(0)) || string2.charAt(0) == '\u05b9') ? string + Character.toString('\u200e') + " " + '\u200e' + '\u202b' + string2 + '\u202c' : string + " " + string2;
        } else {
            String string3 = Character.toString('\u200e') + (ComponentState.getBTD() == 1 ? (char)'\u202b' : '\u202a');
            string = string + Character.toString('\u200e') + " " + string3 + string2 + '\u202c';
        }
        return string;
    }

    @Override
    public String generateSyntax() {
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.showDetails();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefault(true);
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    @Override
    protected boolean okPastePressed() {
        if (this.getPressedButton() == this.getOkButton()) {
            int n = -1;
            DataFrame dataFrame = (DataFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
            if (dataFrame != null) {
                ISpssVariable iSpssVariable = (ISpssVariable)this.mVariableTable.getModel().getValueAt(this.mVariableTable.getSelectedRow(), 0);
                for (SheetData object2 : this.mSheetData) {
                    if (!object2.getVariable().getId().equals((Object)iSpssVariable.getId())) continue;
                    n = object2.getIndex();
                    break;
                }
                if (n < 0) {
                    assert (false);
                    return false;
                }
                dataFrame.toFront();
                DataView dataView = dataFrame.getDataView();
                JTable jTable = dataView.getDataTable(1);
                int n2 = Math.max(jTable.getSelectedColumn(), 0);
                jTable.changeSelection(n, n2, false, false);
                JTable jTable2 = dataView.getDataTable(0);
                int n3 = Math.max(jTable2.getSelectedRow(), 0);
                jTable2.changeSelection(n3, n, false, false);
                ProcedureDlgMgr.getMgr().saveDialogSize(this.getIActionKey(), this.getSize());
                ProcedureDlgMgr.getMgr().saveDialogLocation(this.getIActionKey(), this.getLocation());
                return true;
            }
            return false;
        }
        this.doPaste();
        return false;
    }

    @Override
    protected boolean cancelPressed() {
        ProcedureDlgMgr.getMgr().saveDialogSize(this.getIActionKey(), this.getSize());
        ProcedureDlgMgr.getMgr().saveDialogLocation(this.getIActionKey(), this.getLocation());
        return true;
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        jPanel.remove(this.getResetButton());
        this.getOkButton().setText(this.getResString("IDS_UTILITIES_VARIABLES_GOTO_BUTTON"));
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    @Override
    protected void validateTableData() {
        int n = this.mVariableTable.getSelectedRow();
        ISpssVariable iSpssVariable = n >= 0 ? (ISpssVariable)this.mVariableTable.getModel().getValueAt(n, 0) : null;
        Vector<ISpssVariable> vector = this.loadFromActiveDataset();
        this.sortBasedOnPrefs(vector);
        this.mVariableTable.setModel(new TableModel(vector));
        this.setDefault(false);
        int n2 = this.findVariableIndex(iSpssVariable);
        if (n2 != -1) {
            this.mVariableTable.getSelectionModel().setSelectionInterval(n2, n2);
        }
    }

    private int findVariableIndex(ISpssVariable iSpssVariable) {
        int n = -1;
        if (iSpssVariable != null) {
            for (int i = 0; i < this.mVariableTable.getModel().getRowCount(); ++i) {
                ISpssVariable iSpssVariable2 = (ISpssVariable)this.mVariableTable.getModel().getValueAt(i, 0);
                if (!iSpssVariable.getId().equals((Object)iSpssVariable2.getId())) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    private void sortBasedOnPrefs(Vector<ISpssVariable> vector) {
        SpssVariableSortType spssVariableSortType = this.getSortOrderUserPref();
        boolean bl = this.getShowLabelsUserPref();
        Collections.sort(vector, new SpssVariableComparator(spssVariableSortType, bl));
    }

    private SpssVariableSortType getSortOrderUserPref() {
        Preferences preferences = this.getGeneralPreferences();
        SpssVariableSortType spssVariableSortType = SpssVariableSortType.alpha;
        String string = preferences.get("var_list_sort", PrefDefaults.DEF_VAR_LIST_SORT_ORDER_FILE);
        if (string.equals(IOptionConstants.VAR_LIST_SORT_VALUES[2])) {
            spssVariableSortType = SpssVariableSortType.measurement;
        } else if (string.equals(IOptionConstants.VAR_LIST_SORT_VALUES[1])) {
            spssVariableSortType = SpssVariableSortType.file;
        }
        return spssVariableSortType;
    }

    private boolean getShowLabelsUserPref() {
        Preferences preferences = this.getGeneralPreferences();
        return preferences.get("var_list_display", PrefDefaults.DEF_VAR_LIST_DISPLAY_LABELS).equals(IOptionConstants.VAR_LIST_DISPLAY_VALUES[0]);
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_UTILITIES_VARIABLES_SOURCE_LIST_LABEL");
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel2, this.mVariableTableScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel3 = new JPanel(new GridBagLayout(), true);
        Insets insets2 = new Insets(insets.top, insets.left * 2, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = new JLabel(this.getResString(VAR_INFO_LABEL), 10);
        DialogUtil.addUsingGBL(jPanel3, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel3, this.mGeneralVarInfoScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel3 = new JLabel(" ", 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets3 = new Insets(insets.top + 10, insets.left * 2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel3, this.mValueLabelsInfoScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets3);
        JSplitPane jSplitPane = new JSplitPane(1, jPanel2, jPanel3);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        DialogUtil.addUsingGBL(jPanel, jSplitPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
        jSplitPane.resetToPreferredSizes();
    }

    private void initVars() {
        this.mGeneralVarInfoTableModel = new GeneralVarInfoTableModel();
        this.mGeneralVarInfoTable = new JTable(this.mGeneralVarInfoTableModel);
        this.mGeneralVarInfoTable.setSelectionMode(0);
        this.mGeneralVarInfoTable.setCellSelectionEnabled(true);
        this.mGeneralVarInfoTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    VariablesDlg.this.executeTablePopup(mouseEvent, VariablesDlg.this.mGeneralVarInfoTable);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    VariablesDlg.this.executeTablePopup(mouseEvent, VariablesDlg.this.mGeneralVarInfoTable);
                }
            }
        });
        this.mGeneralVarInfoScrollPane = new JScrollPane(this.mGeneralVarInfoTable);
        this.mGeneralVarInfoScrollPane.setPreferredSize(new Dimension(300, 90));
        this.mValueLabelsInfoTableModel = new ValueLabelsInfoTableModel();
        this.mValueLabelsInfoTable = new JTable(this.mValueLabelsInfoTableModel);
        this.mValueLabelsInfoTable.setSelectionMode(0);
        this.mValueLabelsInfoTable.setCellSelectionEnabled(true);
        this.mValueLabelsInfoTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    VariablesDlg.this.executeTablePopup(mouseEvent, VariablesDlg.this.mValueLabelsInfoTable);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    VariablesDlg.this.executeTablePopup(mouseEvent, VariablesDlg.this.mValueLabelsInfoTable);
                }
            }
        });
        this.mValueLabelsInfoScrollPane = new JScrollPane(this.mValueLabelsInfoTable);
        this.mValueLabelsInfoScrollPane.setPreferredSize(new Dimension(300, 150));
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(DialogUtil.applyMultiLines(this.getResString(VAR_INFO_CONTEXT_MENU)));
        jPopupMenu.add(jMenuItem);
        JPopupMenu jPopupMenu2 = new JPopupMenu();
        JMenuItem jMenuItem2 = new JMenuItem(DialogUtil.applyMultiLines(this.getResString("IDS_UTILITIES_VARIABLES_SOURCE_CONTEXT_MSG")));
        jPopupMenu2.add(jMenuItem2);
        this.mSheetData = new ArrayList();
        this.mVariables = this.loadFromActiveDataset();
        this.mVariableTable = new MyTable();
        this.mVariableTable.setDefaultRenderer(Object.class, new TableRenderer());
        this.sortBasedOnPrefs(this.mVariables);
        this.mVariableTable.setModel(new TableModel(this.mVariables));
        this.mVariableTableScrollPane = new JScrollPane(this.mVariableTable);
        this.mVariableTableScrollPane.setPreferredSize(new Dimension(160, 200));
        this.mVariableTableScrollPane.getViewport().setBackground(Color.WHITE);
        this.mVariableTableScrollPane.setHorizontalScrollBarPolicy(30);
        this.mVariableTable.setShowGrid(false);
        this.setDefaultSelection();
        ListSelectionModel listSelectionModel = this.mVariableTable.getSelectionModel();
        listSelectionModel.setSelectionInterval(0, 0);
        listSelectionModel.addListSelectionListener(this);
        this.mVariableTable.getTableHeader().setReorderingAllowed(false);
        this.mVariableTable.addMouseListener(new mouseClick(jPopupMenu2));
        this.showDetails();
    }

    private void executeTablePopup(MouseEvent mouseEvent, JTable jTable) {
        int n = jTable.rowAtPoint(mouseEvent.getPoint());
        int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
        if (n != -1 && n2 != -1) {
            jTable.changeSelection(n, n2, false, false);
            jTable.getSelectionModel().setSelectionInterval(n, n);
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setName("popupMenu");
        JMenuItem jMenuItem = new JMenuItem(new CopyAction(jTable));
        jMenuItem.setText(ResUtil.getCommonDlgString("IDS_VAR_DLG_COPY"));
        jMenuItem.setName(ResUtil.getCommonDlgString("IDS_VAR_DLG_COPY"));
        jMenuItem.setMnemonic(ResUtil.getCommonDlgAccessKey("IDK_VAR_DLG_COPY"));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    protected void setGeneralVarInfoTableColumnWidths() {
        for (int i = 0; i < this.mGeneralVarInfoTable.getColumnModel().getColumnCount(); ++i) {
            TableColumn tableColumn = this.mGeneralVarInfoTable.getColumnModel().getColumn(i);
            double d = i == 0 ? 120.0 : 180.0;
            tableColumn.setPreferredWidth((int)d);
        }
    }

    protected void setValueLabelsInfoTableColumnWidths() {
        for (int i = 0; i < this.mGeneralVarInfoTable.getColumnModel().getColumnCount(); ++i) {
            TableColumn tableColumn = this.mValueLabelsInfoTable.getColumnModel().getColumn(i);
            double d = i == 0 ? 60.0 : 240.0;
            tableColumn.setPreferredWidth((int)d);
        }
    }

    private void setDefault(boolean bl) {
        DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)this.mVariableTable.getColumnModel();
        this.mVariableTable.setRowHeight(20);
        TableColumn tableColumn = defaultTableColumnModel.getColumn(0);
        tableColumn.setPreferredWidth(20);
        tableColumn.setMaxWidth(50);
        tableColumn = defaultTableColumnModel.getColumn(1);
        tableColumn.setPreferredWidth(130);
        ListSelectionModel listSelectionModel = this.mVariableTable.getSelectionModel();
        listSelectionModel.setSelectionInterval(0, 0);
        listSelectionModel.addListSelectionListener(this);
        this.mVariableTable.getTableHeader().setReorderingAllowed(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VariablesDlg.this.mVariableTable.requestFocusInWindow();
            }
        });
        this.showDetails();
        if (bl) {
            this.setGeneralVarInfoTableColumnWidths();
            this.setValueLabelsInfoTableColumnWidths();
        }
    }

    public void setVisible(boolean bl) {
        this.setDefaultSelection();
        super.setVisible(bl);
    }

    private void setDefaultSelection() {
        ListSelectionModel listSelectionModel = this.mVariableTable.getSelectionModel();
        int n = this.getSelectionIndex();
        listSelectionModel.setSelectionInterval(n, n);
    }

    public int getSelectionIndex() {
        DataFrame dataFrame;
        DataView dataView;
        int n = 0;
        if (this.mParentFrame instanceof DataFrame && (dataView = (dataFrame = (DataFrame)this.mParentFrame).getDataView()) != null) {
            JTable jTable = dataView.getDataTable(dataView.getActiveView());
            if (jTable instanceof VarViewTable) {
                int[] nArray = jTable.getSelectedRows();
                n = nArray != null && nArray.length == 1 ? nArray[0] : 0;
            } else if (jTable instanceof DataViewTable) {
                int[] nArray = jTable.getSelectedColumns();
                n = nArray != null && nArray.length == 1 ? nArray[0] : 0;
            }
        }
        return n < this.mVariableTable.getModel().getRowCount() ? n : 0;
    }

    private void showDetails() {
        int[] nArray = this.mVariableTable.getSelectedRows();
        boolean[] blArray = new boolean[1];
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[nArray.length];
        int n = 0;
        for (SheetData sheetData : this.mSheetData) {
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i] < this.mVariableTable.getModel().getRowCount() ? nArray[i] : 0;
                ISpssVariable iSpssVariable = (ISpssVariable)this.mVariableTable.getModel().getValueAt(n2, 0);
                if (!sheetData.getVariable().getId().equals((Object)iSpssVariable.getId())) continue;
                iSpssVariableArray[i] = sheetData.getVariable();
                blArray[0] = sheetData.isSelected();
                if (++n > 1) break;
            }
            if (n <= true) continue;
            break;
        }
        if (nArray.length > 0) {
            if (n == 1) {
                ISpssVariable iSpssVariable = iSpssVariableArray[0];
                this.getOkButton().setEnabled(true);
                if (iSpssVariable != null) {
                    ((GeneralVarInfoTableModel)this.mGeneralVarInfoTable.getModel()).setActiveVar(iSpssVariable);
                    ((ValueLabelsInfoTableModel)this.mValueLabelsInfoTable.getModel()).setActiveVar(iSpssVariable);
                    this.getOkButton().setEnabled(blArray[0]);
                }
            } else {
                this.getOkButton().setEnabled(false);
            }
            this.getPasteButton().setEnabled(true);
        } else {
            this.getOkButton().setEnabled(false);
            this.getPasteButton().setEnabled(false);
        }
    }

    private Vector<ISpssVariable> loadFromActiveDataset() {
        ISpssDataSrc iSpssDataSrc;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        if (spssFrame instanceof DataFrame && (iSpssDataSrc = DataMgr.getDataMgr().getDataSource(((DataFrame)spssFrame).getDatasetId())) != null) {
            this.mSheetData.clear();
            for (int i = 0; i < iSpssDataSrc.columnCount(); ++i) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                vector.add(iSpssVariable);
                SheetData sheetData = new SheetData();
                sheetData.setIndex(i);
                sheetData.setSelected(iSpssDataSrc.isVariableInCurrentSet(iSpssDataSrc.getVariable(i)));
                sheetData.setVariable(iSpssVariable);
                this.mSheetData.add(sheetData);
            }
        }
        return vector;
    }

    private Preferences getGeneralPreferences() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options");
        return preferences2.node("general");
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mVariableTable);
        vector.add(this.mGeneralVarInfoTable);
        vector.add(this.mValueLabelsInfoTable);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void doPaste() {
        String string = this.privateGenerateSyntax();
        if (string != null && string.length() > 0) {
            SyntaxFrame syntaxFrame = (SyntaxFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.SYNTAX_DOC);
            if (syntaxFrame != null) {
                syntaxFrame.pasteSyntax(string, true, true);
            } else {
                TraceSettings.trace1((String)"No syntax to execute in BaseProcedureDialog!", (int)15);
            }
        }
    }

    class MyTable
    extends JTable {
        TableFindManager findManager = new TableFindManager();
        private CharsetEncoder mEncoder = ComponentState.getCurrentCharset().newEncoder();
        private boolean mShowLabels = false;

        public MyTable() {
            Preferences preferences = VariablesDlg.this.getGeneralPreferences();
            this.mShowLabels = preferences.get("var_list_display", PrefDefaults.DEF_VAR_LIST_DISPLAY_LABELS).equals(IOptionConstants.VAR_LIST_DISPLAY_VALUES[0]);
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent) {
            super.processKeyEvent(keyEvent);
            TableFindManager.Callback callback = new TableFindManager.Callback(){

                public boolean isValidChar(char c) {
                    return MyTable.this.testValidChar(Character.valueOf(c));
                }

                public String getRowText(int n) {
                    return MyTable.this.findManager.getCellTextFromRenderer((JTable)MyTable.this, 1, n);
                }
            };
            this.findManager.processKeyEvent((JTable)this, 1, callback, keyEvent);
        }

        protected boolean testValidChar(Character c) {
            boolean bl;
            try {
                this.mEncoder.reset();
                ByteBuffer byteBuffer = ByteBuffer.allocate(256);
                CharBuffer charBuffer = CharBuffer.wrap(new char[]{c.charValue()});
                CoderResult coderResult = this.mEncoder.encode(charBuffer, byteBuffer, true);
                bl = coderResult.equals(CoderResult.UNDERFLOW);
                this.mEncoder.flush(byteBuffer);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
            }
            return bl;
        }

        public void setShowVarLabels(boolean bl) {
            this.mShowLabels = bl;
        }

        public boolean getShowVarLabels() {
            return this.mShowLabels;
        }
    }

    class SheetData {
        private int index;
        private ISpssVariable variable;
        private boolean selected = true;

        SheetData() {
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int n) {
            this.index = n;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public ISpssVariable getVariable() {
            return this.variable;
        }

        public void setVariable(ISpssVariable iSpssVariable) {
            this.variable = iSpssVariable;
        }
    }

    class mouseClick
    extends MouseAdapter {
        JPopupMenu popup;

        public mouseClick(JPopupMenu jPopupMenu) {
            this.popup = jPopupMenu;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            if (mouseEvent.getSource().equals(VariablesDlg.this.mVariableTable)) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
                    VariablesDlg.this.showDetails();
                }
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    VariablesDlg.this.doPaste();
                }
                if (mouseEvent.getButton() == 3) {
                    this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    class VariablesDlgPopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        VariablesDlgPopupListener(JPopupMenu jPopupMenu) {
            this.popup = jPopupMenu;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class TableModel
    extends AbstractTableModel {
        private String[] columnNames;

        public TableModel(Vector<ISpssVariable> vector) {
            this.columnNames = new String[]{VariablesDlg.this.getResString("IDS_UTILITIES_VARIABLES_VISIBLE_COL"), VariablesDlg.this.getResString("IDS_UTILITIES_VARIABLES_VARIABLE_COL")};
            VariablesDlg.this.mVariables = vector;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public int getRowCount() {
            return VariablesDlg.this.mVariables.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return VariablesDlg.this.mVariables.get(n);
        }

        public Vector<ISpssVariable> getTableData() {
            return VariablesDlg.this.mVariables;
        }
    }

    class TableRenderer
    extends JLabel
    implements TableCellRenderer {
        JCheckBox check = new JCheckBox();

        TableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ISpssVariable iSpssVariable = (ISpssVariable)object;
            if (iSpssVariable == null) {
                return null;
            }
            String string = iSpssVariable.getLabel() + " [" + iSpssVariable.getName() + "]";
            this.setToolTipText(string);
            if (n2 == 0) {
                this.check.setHorizontalAlignment(0);
                this.check.setBackground(Color.white);
                SheetData sheetData = (SheetData)VariablesDlg.this.mSheetData.get(n);
                this.check.setSelected(sheetData.isSelected());
                this.check.setToolTipText(string);
                this.setBackground(Color.lightGray);
                return this.check;
            }
            if (n2 == 1) {
                this.setBorder(new EmptyBorder(1, 1, 1, 1));
                Icon icon = iSpssVariable.getCustomIcon();
                icon = icon != null ? icon : VariableList.getStandardIcon(iSpssVariable);
                this.setIcon(icon);
                String string2 = iSpssVariable.getName();
                String string3 = iSpssVariable.getLabel();
                if (((MyTable)jTable).getShowVarLabels() && string3.length() > 0) {
                    this.setText(string3 + " [" + string2 + "]");
                } else {
                    this.setText(string2);
                }
                if (jTable.isEnabled()) {
                    this.setOpaque(true);
                    if (bl) {
                        if (jTable.hasFocus()) {
                            this.setBackground(jTable.getSelectionBackground());
                            this.setForeground(jTable.getSelectionForeground());
                        } else {
                            this.setBackground(Color.lightGray);
                            this.setForeground(Color.black);
                        }
                    } else {
                        this.setBackground(jTable.getBackground());
                        this.setForeground(jTable.getForeground());
                    }
                } else {
                    this.setOpaque(false);
                }
                Border border = null;
                if (bl2 && jTable.isEnabled()) {
                    if (jTable.hasFocus()) {
                        border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                    }
                    if (border == null) {
                        border = UIManager.getBorder("List.focusCellHighlightBorder");
                    }
                } else {
                    border = new EmptyBorder(1, 1, 1, 1);
                }
                this.setBorder(border);
            }
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }

    private class GeneralVarInfoTableModel
    extends DefaultTableModel {
        ISpssVariable mActiveVar = null;
        ArrayList<String> mRowNames = new ArrayList();

        public ISpssVariable getActiveVar() {
            return this.mActiveVar;
        }

        private GeneralVarInfoTableModel() {
            this.initRowNames();
        }

        private void initRowNames() {
            if (ComponentState.isBtdRtlOrLtr()) {
                this.mRowNames.add(ComponentState.prepareStringForBidiRendering((String)ResUtil.getCommonDlgString("IDS_VAR_DLG_NAME")));
                this.mRowNames.add(ComponentState.prepareStringForBidiRendering((String)ResUtil.getCommonDlgString("IDS_VAR_DLG_LABEL")));
                this.mRowNames.add(ComponentState.prepareStringForBidiRendering((String)ResUtil.getCommonDlgString("IDS_VAR_DLG_TYPE")));
                this.mRowNames.add(ComponentState.prepareStringForBidiRendering((String)ResUtil.getCommonDlgString("IDS_VAR_DLG_MISSING_VALUES")));
                this.mRowNames.add(ComponentState.prepareStringForBidiRendering((String)ResUtil.getCommonDlgString("IDS_VAR_DLG_MEASUREMENT")));
            } else {
                this.mRowNames.add(ResUtil.getCommonDlgString("IDS_VAR_DLG_NAME"));
                this.mRowNames.add(ResUtil.getCommonDlgString("IDS_VAR_DLG_LABEL"));
                this.mRowNames.add(ResUtil.getCommonDlgString("IDS_VAR_DLG_TYPE"));
                this.mRowNames.add(ResUtil.getCommonDlgString("IDS_VAR_DLG_MISSING_VALUES"));
                this.mRowNames.add(ResUtil.getCommonDlgString("IDS_VAR_DLG_MEASUREMENT"));
            }
        }

        public void setActiveVar(ISpssVariable iSpssVariable) {
            this.mActiveVar = iSpssVariable;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int n) {
            return "";
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.mRowNames != null && this.mRowNames.size() > 0 ? this.mRowNames.size() : 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = "";
            if (n2 == 0) {
                string = this.mRowNames.get(n);
            } else if (this.mActiveVar != null) {
                if (n == 0) {
                    string = this.mActiveVar.getName();
                } else if (n == 1) {
                    string = this.mActiveVar.getLabel();
                } else if (n == 2) {
                    string = "" + this.mActiveVar.getFormat().getFormatType() + this.mActiveVar.getFormat().getWidth();
                } else if (n == 3) {
                    string = this.getMissingValue();
                } else if (n == 4) {
                    string = this.getMeasurementLevel();
                }
                if (ComponentState.isBtdRtlOrLtr()) {
                    string = ComponentState.prepareStringForBidiRendering((String)string);
                }
            }
            return string;
        }

        public String getMissingValue() {
            String string = "";
            if (this.mActiveVar != null) {
                SPSS_Format sPSS_Format = this.mActiveVar.getFormat();
                FormatType formatType = sPSS_Format.getFormatType();
                StringBuffer stringBuffer = new StringBuffer();
                OBS[] oBSArray = new OBS[3];
                for (int i = 0; i < 3; ++i) {
                    oBSArray[i] = new OBS();
                }
                ISpssVariable.Rule rule = this.mActiveVar.getMissingValues(oBSArray[0], oBSArray[1], oBSArray[2]);
                boolean bl = formatType.isStringFormat();
                if (rule.equals((Object)ISpssVariable.Rule.one) || rule.equals((Object)ISpssVariable.Rule.two) || rule.equals((Object)ISpssVariable.Rule.three)) {
                    if (oBSArray[0] != null) {
                        stringBuffer.append(bl ? "'" + oBSArray[0].getString().trim() + "'" : CellValueFormatter.obsToString((OBS)oBSArray[0], (SPSS_Format)sPSS_Format));
                    }
                    if (rule.equals((Object)ISpssVariable.Rule.two) || rule.equals((Object)ISpssVariable.Rule.three)) {
                        if (oBSArray[2] != null) {
                            stringBuffer.append(", ");
                            stringBuffer.append(bl ? "'" + oBSArray[1].getString().trim() + "'" : CellValueFormatter.obsToString((OBS)oBSArray[1], (SPSS_Format)sPSS_Format));
                        }
                        if (rule.equals((Object)ISpssVariable.Rule.three) && oBSArray[2] != null) {
                            stringBuffer.append(", ");
                            stringBuffer.append(bl ? "'" + oBSArray[2].getString().trim() + "'" : CellValueFormatter.obsToString((OBS)oBSArray[2], (SPSS_Format)sPSS_Format));
                        }
                    }
                } else if (rule.equals((Object)ISpssVariable.Rule.range) || rule.equals((Object)ISpssVariable.Rule.range_plus)) {
                    if (oBSArray[0] != null) {
                        stringBuffer.append(bl ? oBSArray[0].getString().trim() : CellValueFormatter.obsToString((OBS)oBSArray[0], (SPSS_Format)sPSS_Format));
                    }
                    if (oBSArray[1] != null) {
                        stringBuffer.append(" - ");
                        stringBuffer.append(bl ? oBSArray[1].getString().trim() : CellValueFormatter.obsToString((OBS)oBSArray[1], (SPSS_Format)sPSS_Format));
                    }
                    if (rule.equals((Object)ISpssVariable.Rule.range_plus) && oBSArray[2] != null) {
                        stringBuffer.append(", ");
                        stringBuffer.append(bl ? oBSArray[1].getString().trim() : CellValueFormatter.obsToString((OBS)oBSArray[2], (SPSS_Format)sPSS_Format));
                    }
                }
                if (stringBuffer.toString().equals("")) {
                    stringBuffer.append(VariablesDlg.this.getResString("IDS_UTILITIES_VARIABLES_VARINFO_NONE"));
                }
                string = stringBuffer.toString();
            }
            return string;
        }

        public String getMeasurementLevel() {
            String string = "";
            if (this.mActiveVar != null) {
                MeasurementLevel measurementLevel = this.mActiveVar.getMeasurementLevel();
                string = measurementLevel.equals((Object)MeasurementLevel.nominal) ? VarViewTable.sMeasurementValues[2] : (measurementLevel.equals((Object)MeasurementLevel.ordinal) ? VarViewTable.sMeasurementValues[1] : VarViewTable.sMeasurementValues[0]);
            }
            return string;
        }
    }

    private class ValueLabelsInfoTableModel
    extends DefaultTableModel {
        ISpssVariable mActiveVar = null;

        private ValueLabelsInfoTableModel() {
        }

        public ISpssVariable getActiveVar() {
            return this.mActiveVar;
        }

        public void setActiveVar(ISpssVariable iSpssVariable) {
            this.mActiveVar = iSpssVariable;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int n) {
            return n == 0 ? ResUtil.getCommonDlgString("IDS_VAR_DLG_VALUE") : ResUtil.getCommonDlgString("IDS_VAR_DLG_LABEL");
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.mActiveVar != null && this.mActiveVar.getSortedValueLabels() != null ? this.mActiveVar.getSortedValueLabels().size() : 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string;
            ArrayList<String> arrayList;
            ArrayList arrayList2;
            String string2 = "";
            if (this.mActiveVar != null && (arrayList2 = this.mActiveVar.getSortedValueLabels()) != null && arrayList2.size() > 0 && n >= 0 && n < arrayList2.size() && (arrayList = this.getValueLabelParts(string = (string2 = (String)arrayList2.get(n)))) != null) {
                if (arrayList.size() > 0 & n2 == 0) {
                    string2 = arrayList.get(0);
                } else if (arrayList.size() > 1 & n2 == 1) {
                    string2 = arrayList.get(1);
                }
            }
            return string2;
        }

        private ArrayList<String> getValueLabelParts(String string) {
            String string2;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = string.indexOf(" ");
            if (n != -1 && (string2 = string.substring(0, n)) != null) {
                arrayList.add(string2);
                String string3 = string.substring(n, string.length());
                if (string3 != null) {
                    arrayList.add(string3);
                }
            }
            return arrayList;
        }
    }

    public class CopyAction
    extends AbstractAction {
        private JTable mTable;

        public CopyAction(JTable jTable) {
            this.mTable = jTable;
            this.putValue("Name", "Copy");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.mTable.getSelectedRow();
            int n2 = this.mTable.getSelectedColumn();
            StringSelection stringSelection = new StringSelection((String)this.mTable.getValueAt(n, n2));
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }
}

