/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.IVariableSet;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.BaseDataList;
import com.spss.java_client.ui.controls.FocusHighlighter;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class UseVarSetsDlg
extends BaseProcedureDialog
implements ItemListener {
    private JTextArea mMultilineArea;
    private FocusHighlighter mFocusHighlighter;
    private JCheckBox mAllVarsCheck;
    private JCheckBox mNewVarsCheck;
    private JButton mCheckAllButton;
    private JButton mUncheckAllButton;
    private BaseDataList mList;
    private DefaultListModel mDefListModel;
    private LocallyUniqueId mDataSetID;

    public UseVarSetsDlg(JFrame jFrame) {
        super(jFrame, true, UtilitiesResBundle.getDefaultResourceBundleName(), UtilitiesResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_USE_VAR_SETS_TITLE"));
    }

    @Override
    public String generateSyntax() {
        return null;
    }

    @Override
    public String getIActionKey() {
        return "utilities_use_variable_sets";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_uset";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.getOkButton().setEnabled(this.isAtleastOneCheckBoxSelected());
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    @Override
    protected boolean okPastePressed() {
        ISpssDataSrc iSpssDataSrc = this.getDataSource();
        if (iSpssDataSrc != null) {
            Vector<String> vector = new Vector<String>();
            if (this.mDataSetID != null) {
                for (int i = 0; i < this.mList.getModel().getSize(); ++i) {
                    JCheckBox jCheckBox = (JCheckBox)this.mList.getModel().getElementAt(i);
                    if (!jCheckBox.isSelected()) continue;
                    vector.add(jCheckBox.getText());
                }
                iSpssDataSrc.setSelectedVariableSets(vector);
            }
        }
        ProcedureDlgMgr.getMgr().saveDialogSize(this.getIActionKey(), this.getSize());
        ProcedureDlgMgr.getMgr().saveDialogLocation(this.getIActionKey(), this.getLocation());
        return true;
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        jPanel.remove(this.getPasteButton());
        jPanel.remove(this.getResetButton());
        this.getOkButton().setEnabled(true);
        this.getRootPane().setDefaultButton(this.getOkButton());
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private boolean isAtleastOneCheckBoxSelected() {
        boolean bl = false;
        for (int i = 0; i < this.mList.getModel().getSize(); ++i) {
            JCheckBox jCheckBox = (JCheckBox)this.mList.getModel().getElementAt(i);
            if (!jCheckBox.isSelected()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void addItemListenersToAllCheckBoxes() {
        for (int i = 0; i < this.mList.getModel().getSize(); ++i) {
            JCheckBox jCheckBox = (JCheckBox)this.mList.getModel().getElementAt(i);
            jCheckBox.addItemListener(this);
        }
    }

    private void initVars() {
        String string = CoreResUtil.getString((String)"IDS_VSETS_ALLVARIABLES");
        this.mAllVarsCheck = new JCheckBox(string);
        string = CoreResUtil.getString((String)"IDS_VSETS_NEWVARIABLES");
        this.mNewVarsCheck = new JCheckBox(string);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_USE_VAR_SETS_CHECK_ALL_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UseVarSetsDlg.this.checkAllBoxes(true);
            }
        };
        this.mCheckAllButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_USE_VAR_SETS_UNCHECK_ALL_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UseVarSetsDlg.this.checkAllBoxes(false);
            }
        };
        this.mUncheckAllButton = new JButton(toggleButtonAction);
        this.mList = new BaseDataList((ListModel)new DefaultListModel());
        this.mDefListModel = new DefaultListModel();
        this.loadSelectVarList();
        this.refreshCheckboxSelection();
        if (!this.isAtleastOneCheckBoxSelected()) {
            this.mAllVarsCheck.setSelected(true);
            this.mNewVarsCheck.setSelected(true);
        }
        this.mList.setCellRenderer(new SelectVarListRenderer());
        this.mList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JCheckBox jCheckBox;
                jCheckBox.setSelected(!(jCheckBox = (JCheckBox)UseVarSetsDlg.this.mList.getSelectedValue()).isSelected());
                UseVarSetsDlg.this.mList.repaint();
            }
        });
        this.mList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    JCheckBox jCheckBox;
                    jCheckBox.setSelected(!(jCheckBox = (JCheckBox)UseVarSetsDlg.this.mList.getSelectedValue()).isSelected());
                    UseVarSetsDlg.this.mList.repaint();
                }
            }
        });
        this.addItemListenersToAllCheckBoxes();
    }

    private void loadSelectVarList() {
        this.mDefListModel.addElement(this.mAllVarsCheck);
        this.mDefListModel.addElement(this.mNewVarsCheck);
        ISpssDataSrc iSpssDataSrc = this.getDataSource();
        if (iSpssDataSrc != null) {
            Vector vector = iSpssDataSrc.getVariableSets(ISpssDataSrc.VarSetsType.kVariableSet);
            for (IVariableSet iVariableSet : vector) {
                this.mDefListModel.addElement(new JCheckBox(String.format(ComponentState.getSPSSLocale(), iVariableSet.getName(IVariableSet.ChangeCase.kNoChange), new Object[0])));
            }
            this.mList.setModel(this.mDefListModel);
        }
    }

    private ISpssDataSrc getDataSource() {
        ISpssDataSrc iSpssDataSrc = null;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            this.mDataSetID = ((DataFrame)spssFrame).getDatasetId();
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(this.mDataSetID);
        }
        return iSpssDataSrc;
    }

    private void refreshCheckboxSelection() {
        Vector vector;
        ISpssDataSrc iSpssDataSrc = this.getDataSource();
        if (iSpssDataSrc != null && (vector = iSpssDataSrc.getVariableSetsInUse()) != null) {
            for (String string : vector) {
                for (int i = 0; i < this.mList.getModel().getSize(); ++i) {
                    JCheckBox jCheckBox = (JCheckBox)this.mList.getModel().getElementAt(i);
                    if (!jCheckBox.getText().equals(string)) continue;
                    jCheckBox.setSelected(true);
                }
            }
        }
    }

    private void checkAllBoxes(boolean bl) {
        for (int i = 0; i < this.mList.getModel().getSize(); ++i) {
            JCheckBox jCheckBox = (JCheckBox)this.mList.getModel().getElementAt(i);
            jCheckBox.setSelected(bl);
        }
        this.mList.repaint();
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_USE_VAR_SETS_SELECT_VAR_LABEL");
        jLabel.setLabelFor(this.mList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mList);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.checkUncheckButtonsPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets2);
        this.mMultilineArea = new JTextArea(this.getResString("IDS_USE_VAR_SETS_MULTILINE_LABEL"));
        this.mMultilineArea.setLineWrap(true);
        this.mMultilineArea.setWrapStyleWord(true);
        this.mMultilineArea.setOpaque(false);
        this.mMultilineArea.setFocusable(true);
        this.mMultilineArea.setEditable(false);
        this.mMultilineArea.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.mFocusHighlighter = new FocusHighlighter(this.mMultilineArea);
        this.mMultilineArea.addFocusListener(this.mFocusHighlighter);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets2.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMultilineArea, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        DialogUtil.normalizeLabelWidths(jPanel);
    }

    private JPanel checkUncheckButtonsPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mCheckAllButton, this.mUncheckAllButton};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, null, 1);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mList);
        vector.add(this.mCheckAllButton);
        vector.add(this.mUncheckAllButton);
        vector.add(this.mMultilineArea);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    class SelectVarListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        SelectVarListRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof JCheckBox) {
                this.setText(((JCheckBox)object).getText());
                this.setSelected(((JCheckBox)object).isSelected());
                this.setVisible(((JCheckBox)object).isVisible());
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            Border border = null;
            if (bl2) {
                if (bl) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = new EmptyBorder(1, 1, 1, 1);
            }
            this.setBorder(border);
            return this;
        }
    }
}

