/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.BaseList;
import com.spss.uitools.controls.TableFindManager;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.util.CharacterUtil;
import com.spss.uitools.util.IniHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class OmsIdentifiersDlg
extends BaseDialog {
    private JTextArea mDialogDescription;
    private JLabel mCommandIdentifiersLabel;
    private JLabel mTableSubTypesIdentifiersLabel;
    private JButton mPasteCommandsButton;
    private JButton mPasteSubTypesButton;
    private JButton mCloseButton;
    private JButton mHelpButton;
    private JTable mCommandTable;
    private GridBagConstraints mConstraints;
    private Insets mInset;
    private JList mSubTypeList;
    private JScrollPane mScrollPane;
    private DefaultListModel mListModel;
    private TableModel mModel;
    private JScrollPane mSubTypesScroll;
    private LinkedList<String> mSectionNames;
    private IniHandler mIniHandler;

    public OmsIdentifiersDlg(SpssFrame spssFrame) {
        super((JFrame)spssFrame, false, ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), UtilitiesResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_OMS_IDENTIFIERS_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    public String getDialogHelpID() {
        return "idh_idd_omsgui_dialog";
    }

    public String generateSyntax(ActionEvent actionEvent) {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        if (actionEvent.getSource() == this.mPasteCommandsButton) {
            int[] nArray;
            for (int n : nArray = this.mCommandTable.getSelectedRows()) {
                String string = (String)this.mCommandTable.getModel().getValueAt(n, 1);
                string = " " + CharacterUtil.smartQuote((String)string);
                stringBuffer.append(string);
            }
        } else {
            int[] nArray;
            for (int n : nArray = this.mSubTypeList.getSelectedIndices()) {
                String string = (String)this.mSubTypeList.getModel().getElementAt(n);
                string = " " + CharacterUtil.smartQuote((String)string);
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.mCommandTable.getModel().getRowCount() == 0) {
            this.repaintDefaultRows();
        }
    }

    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = insets.left + insets.right;
        this.mCloseButton = new JButton(new CloseAction());
        this.getRootPane().setDefaultButton(this.mCloseButton);
        this.mHelpButton = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(this.mHelpButton);
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets2 = new Insets(0, n, 0, 0);
            int n2 = 23;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, this.mCloseButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(this.mCloseButton);
            jPanel.add(this.mHelpButton);
        }
        this.getRootPane().setDefaultButton(this.mCloseButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void repaintDefaultRows() {
        this.mCommandTable.setEnabled(false);
        this.mScrollPane.setVerticalScrollBarPolicy(21);
        Object[] objectArray = this.getColumnData();
        int n = this.mScrollPane.getHeight();
        int n2 = n / 16;
        this.mModel = new DefaultTableModel(objectArray, n2);
        this.mCommandTable.setModel(this.mModel);
    }

    private void setUpUI(JPanel jPanel) {
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDialogDescription, this.mConstraints, 0, 0, 2, 1, 23, this.mInset);
        this.mConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCommandIdentifiersLabel, this.mConstraints, 0, 1, 1, 1, 23, this.mInset);
        DialogUtil.addUsingGBL(jPanel, this.mTableSubTypesIdentifiersLabel, this.mConstraints, 1, 1, 1, 1, 23, this.mInset);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, this.mConstraints, 0, 2, 1, 1, 23, this.mInset);
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSubTypesScroll, this.mConstraints, 1, 2, 1, 1, 23, this.mInset);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mPasteCommandsButton, this.mConstraints, 0, 3, 1, 1, 10, DialogUtil.getStandardButtonInsets());
        DialogUtil.addUsingGBL(jPanel, this.mPasteSubTypesButton, this.mConstraints, 1, 3, 1, 1, 10, DialogUtil.getStandardButtonInsets());
    }

    private void initVars() {
        Object[] objectArray;
        this.mDialogDescription = new JTextArea(this.getResString("IDS_DIALOG_DESCRIPTION"));
        this.mDialogDescription.setLineWrap(true);
        this.mDialogDescription.setWrapStyleWord(true);
        this.mDialogDescription.setRows(2);
        this.mDialogDescription.setOpaque(false);
        this.mDialogDescription.setEditable(false);
        this.mCommandIdentifiersLabel = DialogUtil.createLabel(this, "IDS_COMMAND_IDENTIFIERS");
        Font font = this.mCommandIdentifiersLabel.getFont();
        this.mDialogDescription.setFont(font);
        this.mTableSubTypesIdentifiersLabel = DialogUtil.createLabel(this, "IDS_TABLE_SUBTYPE_IDENTIFIERS");
        this.mPasteCommandsButton = new JButton(new ToggleButtonAction(this, "IDS_PASTE_COMMANDS"));
        this.mPasteCommandsButton.addActionListener(new LaunchSyntaxEditor());
        this.mPasteCommandsButton.setEnabled(false);
        this.mPasteSubTypesButton = new JButton(new ToggleButtonAction(this, "IDS_PASTE_SUBTYPES"));
        this.mPasteSubTypesButton.addActionListener(new LaunchSyntaxEditor());
        this.mPasteSubTypesButton.setEnabled(false);
        this.mCommandTable = new CommandTable();
        this.mCommandTable.getTableHeader().setReorderingAllowed(false);
        this.mCommandTable.setMinimumSize(new Dimension(300, 165));
        this.mCommandIdentifiersLabel.setLabelFor(this.mCommandTable);
        this.mCommandTable.setAutoResizeMode(0);
        this.mCommandTable.setRowSelectionAllowed(true);
        this.mCommandTable.setColumnSelectionAllowed(false);
        Vector<String> vector = this.getAllSubTypes();
        Vector<Object[]> vector2 = new Vector<Object[]>();
        for (int i = 0; i < vector.size(); ++i) {
            objectArray = vector.elementAt(i);
            objectArray = objectArray.substring(objectArray.indexOf("=") + 2, objectArray.length());
            vector2.addElement(objectArray);
        }
        Collections.sort(vector2, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareToIgnoreCase(string2);
            }
        });
        this.mSubTypeList = new BaseList(vector2);
        this.mSubTypeList.addListSelectionListener(new SubListSelectionListener());
        this.mTableSubTypesIdentifiersLabel.setLabelFor(this.mSubTypeList);
        this.mScrollPane = new JScrollPane(this.mCommandTable);
        this.mScrollPane.setPreferredSize(this.mCommandTable.getMinimumSize());
        this.mScrollPane.setHorizontalScrollBarPolicy(30);
        this.mScrollPane.setVerticalScrollBarPolicy(20);
        Object[][] objectArray2 = this.getCellData();
        objectArray = this.getColumnData();
        this.mModel = new DefaultTableModel(objectArray2, objectArray){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.mCommandTable.setModel(this.mModel);
        ListSelectionModel listSelectionModel = this.mCommandTable.getSelectionModel();
        this.mListModel = new DefaultListModel();
        listSelectionModel.addListSelectionListener(new TableSelectionListener());
        this.mConstraints = new GridBagConstraints();
        this.mSubTypesScroll = new JScrollPane(this.mSubTypeList);
        this.mInset = new Insets(0, 3, 0, 3);
        this.mSectionNames = new LinkedList();
        this.mIniHandler = null;
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mCommandTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mCommandTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mCommandTable.getActionMap().put("tabIn", abstractAction2);
        this.mCommandTable.getActionMap().put("tabOut", abstractAction);
        final JTable jTable = this.mCommandTable;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableColumnModel tableColumnModel = jTable.getColumnModel();
                TableColumn tableColumn = tableColumnModel.getColumn(0);
                tableColumn.setPreferredWidth(140);
                tableColumn = tableColumnModel.getColumn(1);
                tableColumn.setPreferredWidth(140);
                jTable.revalidate();
                ListSelectionModel listSelectionModel = OmsIdentifiersDlg.this.mCommandTable.getSelectionModel();
                listSelectionModel.setSelectionInterval(0, 0);
            }
        });
    }

    private Object[] getColumnData() {
        return new String[]{this.getResString("IDS_TABLE_COLUMN1"), this.getResString("IDS_TABLE_COLUMN2")};
    }

    private Object[][] getCellData() {
        String string = "omsgui.ini";
        String string2 = VersionInfo.getStatisticsHome() + File.separatorChar + string;
        Object[][] objectArray = null;
        File file = new File(string2);
        if (file.exists()) {
            this.mIniHandler = IniHandler.loadIniFile((String)string2, (boolean)true, (String)"");
            if (this.mIniHandler != null) {
                this.mSectionNames = this.mIniHandler.getPrivateProfileSectionNames();
                if (this.mSectionNames != null) {
                    HashMap hashMap = this.mIniHandler.getPrivateProfileSection("Subtypes");
                    if (hashMap == null) {
                        return null;
                    }
                    hashMap = this.mIniHandler.getPrivateProfileSection("Command_Subtypes");
                    if (hashMap == null) {
                        return null;
                    }
                    hashMap = this.mIniHandler.getPrivateProfileSection("Commands");
                    if (hashMap == null) {
                        return null;
                    }
                    Iterator iterator = hashMap.keySet().iterator();
                    objectArray = new Object[hashMap.size()][2];
                    int n = 0;
                    int n2 = 0;
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        objectArray[n][n2] = string3;
                        objectArray[n][++n2] = hashMap.get(string3);
                        ++n;
                        n2 = 0;
                    }
                }
            }
        }
        objectArray = this.refineData(objectArray);
        return objectArray;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mCommandTable);
        vector.add(this.mPasteCommandsButton);
        vector.add(this.mSubTypeList);
        vector.add(this.mPasteSubTypesButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    public void dispose() {
        int n;
        this.mCommandTable.clearSelection();
        Vector<String> vector = this.getAllSubTypes();
        Vector<String> vector2 = new Vector<String>();
        for (n = 0; n < vector.size(); ++n) {
            String string = vector.elementAt(n);
            string = string.substring(string.indexOf("=") + 2, string.length());
            vector2.addElement(string);
        }
        Collections.sort(vector2, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareToIgnoreCase(string2);
            }
        });
        this.mListModel.clear();
        for (n = 0; n < vector2.size(); ++n) {
            this.mListModel.add(n, vector2.get(n));
        }
        this.mSubTypeList.setModel(this.mListModel);
        super.dispose();
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    private Vector<String> getSubTypes(String string) {
        String string2 = "omsgui.ini";
        String string3 = VersionInfo.getStatisticsHome() + File.separatorChar + string2;
        Vector<String> vector = new Vector<String>();
        File file = new File(string3);
        if (file.exists()) {
            this.mIniHandler = IniHandler.loadIniFile((String)string3, (boolean)true, (String)"");
            if (this.mIniHandler != null) {
                HashMap hashMap = this.mIniHandler.getPrivateProfileSection("Command_Subtypes");
                if (hashMap == null) {
                    System.out.println("Error");
                } else {
                    LinkedList linkedList = this.mIniHandler.getPrivateProfileString("Command_Subtypes", string);
                    String string4 = linkedList.toString();
                    String string5 = string4.substring(1, string4.length() - 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string5, ";");
                    HashMap hashMap2 = this.mIniHandler.getPrivateProfileSection("Subtypes");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string6 = ((IniHandler.KeyValuePair)hashMap2.get(stringTokenizer.nextToken())).toString();
                        String string7 = string6.substring(string6.indexOf("=") + 1, string6.length());
                        vector.add(string7);
                    }
                }
            }
        }
        return vector;
    }

    private Vector<String> getAllSubTypes() {
        Vector<String> vector = new Vector<String>();
        String string = "omsgui.ini";
        String string2 = VersionInfo.getStatisticsHome() + File.separatorChar + string;
        this.mIniHandler = IniHandler.loadIniFile((String)string2, (boolean)true, (String)"");
        if (this.mIniHandler != null) {
            HashMap hashMap = this.mIniHandler.getPrivateProfileSection("Command_Subtypes");
            if (hashMap == null) {
                return vector;
            }
            hashMap = this.mIniHandler.getPrivateProfileSection("Subtypes");
            if (hashMap == null) {
                return vector;
            }
            for (String string3 : hashMap.keySet()) {
                vector.add(((IniHandler.KeyValuePair)hashMap.get(string3)).toString());
            }
        }
        return vector;
    }

    private Object[][] refineData(Object[][] objectArray) {
        int n = objectArray.length;
        Object[][] objectArray2 = new Object[n][2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = objectArray[i][1].toString();
            String[] stringArray = string.split("=");
            if (stringArray.length == 3) {
                objectArray2[i][n2] = stringArray[0] + stringArray[1];
                objectArray2[i][++n2] = stringArray[2];
            }
            if (stringArray.length == 2) {
                objectArray2[i][n2] = stringArray[0];
                objectArray2[i][++n2] = stringArray[1];
            }
            n2 = 0;
        }
        this.sort(objectArray2);
        return objectArray2;
    }

    private void sort(Object[][] objectArray) {
        Collator collator = Collator.getInstance();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = i + 1; j < objectArray.length; ++j) {
                if (collator.compare(objectArray[i][n].toString(), objectArray[j][n].toString()) > 0) {
                    Object object = objectArray[i][n];
                    objectArray[i][n] = objectArray[j][n];
                    objectArray[j][n] = object;
                    object = objectArray[i][++n];
                    objectArray[i][n] = objectArray[j][n];
                    objectArray[j][n] = object;
                }
                n = 0;
            }
        }
    }

    private class CommandTable
    extends JTable {
        TableFindManager findManager = new TableFindManager();
        private CharsetEncoder mEncoder = ComponentState.getCurrentCharset().newEncoder();

        private CommandTable() {
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            int n;
            Point point = mouseEvent.getPoint();
            int n2 = this.rowAtPoint(point);
            String string = this.cellTextIsFullyVisible(this.getCellRect(n2, n = this.columnAtPoint(point), true), n2, n) ? super.getToolTipText() : (String)this.getValueAt(n2, n);
            return string;
        }

        private boolean cellTextIsFullyVisible(Rectangle rectangle, int n, int n2) {
            int n3 = this.getCellTextWidth(n, n2);
            if (n3 >= rectangle.width) {
                return false;
            }
            Rectangle rectangle2 = this.getVisibleRect();
            return rectangle2.contains(rectangle.x, rectangle.y) && rectangle2.contains(rectangle.x + n3, rectangle.y);
        }

        private int getCellTextWidth(int n, int n2) {
            Object object = this.getValueAt(n, n2);
            if (object == null) {
                return 0;
            }
            String string = object.toString();
            Component component = this.getCellRendererComponent(n, n2);
            return this.getTextWidthInComp(string, component);
        }

        private int getTextWidthInComp(String string, Component component) {
            Serializable serializable;
            FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
            int n = 0;
            if (component instanceof JComponent) {
                serializable = ((JComponent)component).getInsets();
                n += ((Insets)serializable).left + ((Insets)serializable).right;
            }
            if (component instanceof JLabel && ((JLabel)(serializable = (JLabel)component)).getIcon() != null) {
                n += ((JLabel)serializable).getIcon().getIconWidth() + ((JLabel)serializable).getIconTextGap();
            }
            return SwingUtilities.computeStringWidth(fontMetrics, string) + n;
        }

        protected Component getCellRendererComponent(int n, int n2) {
            String string = this.getValueAt(n, n2).toString();
            TableCellRenderer tableCellRenderer = this.getCellRenderer(n, n2);
            if (ComponentState.isBtdRtlOrLtr() && this.getValueAt(n, n2) != null && this.getValueAt(n, n2) instanceof String && ((String)this.getValueAt(n, n2)).length() > 0) {
                return tableCellRenderer == null ? null : tableCellRenderer.getTableCellRendererComponent(this, ComponentState.prepareStringForBidiRendering((String)string), this.isCellSelected(n, n2), this.hasFocus(), n, n2);
            }
            return tableCellRenderer == null ? null : tableCellRenderer.getTableCellRendererComponent(this, string, this.isCellSelected(n, n2), this.hasFocus(), n, n2);
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent) {
            super.processKeyEvent(keyEvent);
            TableFindManager.Callback callback = new TableFindManager.Callback(){

                public boolean isValidChar(char c) {
                    return CommandTable.this.testValidChar(Character.valueOf(c));
                }

                public String getRowText(int n) {
                    return CommandTable.this.findManager.getCellTextFromRenderer((JTable)CommandTable.this, 0, n);
                }
            };
            this.findManager.processKeyEvent((JTable)this, 0, callback, keyEvent);
        }

        protected boolean testValidChar(Character c) {
            boolean bl;
            try {
                this.mEncoder.reset();
                ByteBuffer byteBuffer = ByteBuffer.allocate(256);
                CharBuffer charBuffer = CharBuffer.wrap(new char[]{c.charValue()});
                CoderResult coderResult = this.mEncoder.encode(charBuffer, byteBuffer, true);
                bl = coderResult.equals(CoderResult.UNDERFLOW);
                this.mEncoder.flush(byteBuffer);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
            }
            return bl;
        }
    }

    private class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
            this.putValue("AcceleratorKey", 112);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OmsIdentifiersDlg.this.doHelp();
        }
    }

    private class CloseAction
    extends AbstractAction {
        CloseAction() {
            this.putValue("Name", OmsIdentifiersDlg.this.getResString("IDS_CLOSE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OmsIdentifiersDlg.this.dispose();
        }
    }

    private class LaunchSyntaxEditor
    implements ActionListener {
        private LaunchSyntaxEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = OmsIdentifiersDlg.this.generateSyntax(actionEvent);
            if (string != null && string.length() > 0) {
                SyntaxFrame syntaxFrame = (SyntaxFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.SYNTAX_DOC);
                if (syntaxFrame != null) {
                    syntaxFrame.pasteSyntax(string, false, false);
                } else {
                    ComponentState.trace1((String)"No syntax to execute in BaseProcedureDialog!", (int)15);
                }
            }
        }
    }

    private class SubListSelectionListener
    implements ListSelectionListener {
        private SubListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (((JList)listSelectionEvent.getSource()).getSelectedIndex() != -1) {
                OmsIdentifiersDlg.this.mPasteSubTypesButton.setEnabled(true);
            } else {
                OmsIdentifiersDlg.this.mPasteSubTypesButton.setEnabled(false);
            }
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private Vector<String> mSubTypes = new Vector();

        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            OmsIdentifiersDlg.this.mPasteCommandsButton.setEnabled(true);
            OmsIdentifiersDlg.this.mSubTypeList.clearSelection();
            if (OmsIdentifiersDlg.this.mSubTypeList.getSelectedIndex() == -1) {
                OmsIdentifiersDlg.this.mPasteSubTypesButton.setEnabled(false);
            }
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = ((ListSelectionModel)listSelectionEvent.getSource()).getMaxSelectionIndex();
            OmsIdentifiersDlg.this.mListModel.clear();
            if (n != -1) {
                int n2;
                int n3 = OmsIdentifiersDlg.this.mCommandTable.getSelectedRow();
                if (n3 == (n2 = OmsIdentifiersDlg.this.mCommandTable.getSelectionModel().getMaxSelectionIndex())) {
                    this.mSubTypes.clear();
                    String string = (String)OmsIdentifiersDlg.this.mModel.getValueAt(n3, 0);
                    this.mSubTypes = OmsIdentifiersDlg.this.getSubTypes(string);
                    Collections.sort(this.mSubTypes, new Comparator<String>(){

                        @Override
                        public int compare(String string, String string2) {
                            return string.compareToIgnoreCase(string2);
                        }
                    });
                    for (int i = 0; i < this.mSubTypes.size(); ++i) {
                        OmsIdentifiersDlg.this.mListModel.add(i, this.mSubTypes.get(i));
                    }
                } else {
                    int n4;
                    this.mSubTypes.clear();
                    for (n4 = n3; n4 <= n2; ++n4) {
                        if (!OmsIdentifiersDlg.this.mCommandTable.isCellSelected(n4, 0)) continue;
                        String string = (String)OmsIdentifiersDlg.this.mModel.getValueAt(n4, 0);
                        Vector vector = OmsIdentifiersDlg.this.getSubTypes(string);
                        for (String string2 : vector) {
                            if (this.mSubTypes.contains(string2)) continue;
                            this.mSubTypes.add(string2);
                        }
                        Collections.sort(this.mSubTypes, new Comparator<String>(){

                            @Override
                            public int compare(String string, String string2) {
                                return string.compareToIgnoreCase(string2);
                            }
                        });
                    }
                    for (n4 = 0; n4 < this.mSubTypes.size(); ++n4) {
                        OmsIdentifiersDlg.this.mListModel.add(n4, this.mSubTypes.get(n4));
                    }
                }
                if (OmsIdentifiersDlg.this.mListModel.size() > 0) {
                    OmsIdentifiersDlg.this.mSubTypeList.setSelectionInterval(0, 0);
                }
            } else {
                OmsIdentifiersDlg.this.mPasteCommandsButton.setEnabled(false);
                Vector vector = OmsIdentifiersDlg.this.getAllSubTypes();
                Collections.sort(vector, new Comparator<String>(){

                    @Override
                    public int compare(String string, String string2) {
                        return string.compareToIgnoreCase(string2);
                    }
                });
                for (int i = 0; i < vector.size(); ++i) {
                    OmsIdentifiersDlg.this.mListModel.add(i, vector.get(i));
                }
            }
            OmsIdentifiersDlg.this.mSubTypeList.setModel(OmsIdentifiersDlg.this.mListModel);
            OmsIdentifiersDlg.this.mSubTypeList.setSelectionInterval(0, 0);
        }
    }
}

