/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.ui_builder.definition.AddOnType;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.util.IniHandler;
import com.spss.uitools.util.TraceSettings;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class MissingAddOnsDlg
extends BaseDialog {
    private boolean mWasContinuePressed = false;

    public static boolean checkForMissingAddOns(JFrame jFrame, DialogDefinition dialogDefinition) {
        Vector<String> vector = MissingAddOnsDlg.checkForMissing(dialogDefinition);
        if (vector.size() == 0) {
            return true;
        }
        MissingAddOnsDlg missingAddOnsDlg = new MissingAddOnsDlg(jFrame, vector);
        missingAddOnsDlg.setVisible(true);
        return missingAddOnsDlg.wasContinuePressed();
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_missing_plugin");
    }

    private void initialize(Vector<String> vector) {
        this.setTitle(this.getResString("IDS_MISSING_ADD_ONS_TITLE"));
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.top += 10;
        int n = 23;
        JLabel jLabel = new JLabel(this.getResString("IDS_MISSING_ADD_ONS_MSG1"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String object2 : vector) {
            defaultListModel.addElement(object2);
        }
        JList jList = new JList(defaultListModel);
        jList.setVisibleRowCount(4);
        gridBagConstraints.fill = 2;
        insets.top -= 4;
        DialogUtil.addUsingGBL(jPanel, new JScrollPane(jList), gridBagConstraints, 0, 1, 1, 1, n, insets);
        JLabel jLabel2 = new JLabel(this.getResString("IDS_MISSING_ADD_ONS_MSG2"));
        gridBagConstraints.weighty = 1.0;
        insets.bottom = 10;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        JButton jButton = new JButton(new ContinueAction());
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private static Vector<String> checkForMissing(DialogDefinition dialogDefinition) {
        Vector<String> vector = new Vector<String>();
        Set set = dialogDefinition.getRequiredAddOns();
        for (AddOnType addOnType : set) {
            if (addOnType == AddOnType.R) {
                if (MissingAddOnsDlg.checkRInstalled()) continue;
                vector.add(BuilderResUtil.getString((String)"IDS_R_PROGRAMMABILITY"));
                continue;
            }
            if (addOnType == AddOnType.Python) {
                if (MissingAddOnsDlg.checkPythonInstalled("pythoncfg.jar")) continue;
                vector.add(BuilderResUtil.getString((String)"IDS_PYTHON_PROGRAMMABILITY"));
                continue;
            }
            TraceSettings.trace1((String)("==> Unknown Add-On type: " + addOnType.name() + " <=="), (int)15);
            vector.add(addOnType.name());
        }
        return vector;
    }

    public boolean wasContinuePressed() {
        return this.mWasContinuePressed;
    }

    private MissingAddOnsDlg(JFrame jFrame, Vector<String> vector) {
        super(jFrame, "", true, ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), UtilitiesResBundle.getImageFolder());
        this.initialize(vector);
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    private static boolean checkPythonInstalled(String string) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("application.home"));
        stringBuffer.append(File.separator).append(string);
        File file = new File(stringBuffer.toString());
        if (file.exists()) {
            bl = true;
        }
        return bl;
    }

    private static boolean checkRInstalled() {
        String string = "";
        boolean bl = false;
        IniHandler iniHandler = MissingAddOnsDlg.getSpssReaderFromSpssHomeDir("spssdxcfg.ini");
        string = MissingAddOnsDlg.getProfileValue(iniHandler, AddOnType.R.toString(), "HOME");
        if (string.isEmpty()) {
            String string2 = VersionInfo.getMajorMinorVersionString();
            String string3 = "/com/ibm/SPSS/externalr/" + string2;
            try {
                if (Preferences.userRoot().nodeExists(string3)) {
                    Preferences preferences = Preferences.userRoot().node(string3);
                    string = preferences.get("r_path", string);
                    if (string.length() > 0) {
                        File file = new File(string);
                        if (!file.exists() || !file.isDirectory()) {
                            string = "";
                        }
                    } else {
                        string = "";
                    }
                }
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
            }
        }
        if (!string.isEmpty()) {
            bl = true;
        }
        return bl;
    }

    private static IniHandler getSpssReaderFromSpssHomeDir(String string) {
        IniHandler iniHandler = null;
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("application.home"));
        stringBuffer.append(File.separatorChar).append(string);
        File file = new File(stringBuffer.toString());
        if (file.exists()) {
            iniHandler = IniHandler.loadIniFile((String)stringBuffer.toString(), (boolean)true, (String)"UTF-8");
        }
        return iniHandler;
    }

    private static String getProfileValue(IniHandler iniHandler, String string, String string2) {
        LinkedList linkedList;
        String string3 = "";
        if (iniHandler != null && (linkedList = iniHandler.getPrivateProfileString(string, string2)) != null && !linkedList.isEmpty()) {
            string3 = (String)linkedList.getFirst();
        }
        return string3;
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MissingAddOnsDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MissingAddOnsDlg.this.dispose();
        }
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MissingAddOnsDlg.this.mWasContinuePressed = true;
            MissingAddOnsDlg.this.dispose();
        }
    }
}

