/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities;

import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class LimitTextWidth
implements Runnable {
    private int mBeginningOfLine;
    private int mMaxWidth;
    private JTextArea mTextArea;

    public LimitTextWidth(JTextArea jTextArea, int n, int n2) {
        this.mTextArea = jTextArea;
        this.mMaxWidth = n;
        try {
            int n3 = jTextArea.getLineOfOffset(n2);
            this.mBeginningOfLine = jTextArea.getLineStartOffset(n3);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            for (int i = this.mTextArea.getLineOfOffset(this.mBeginningOfLine); i < this.mTextArea.getLineCount(); ++i) {
                this.modifyOneLine(i);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    private String getText(Selection selection) {
        try {
            return this.mTextArea.getText(selection.getStart(), selection.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    private Selection getLineOffsets(int n) {
        try {
            int n2 = this.mTextArea.getLineStartOffset(n);
            int n3 = this.mTextArea.getLineEndOffset(n);
            return new Selection(n2, n3);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private Selection findExcess(Selection selection) {
        int n;
        Selection selection2 = new Selection();
        String string = this.getText(selection);
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() <= this.mMaxWidth) {
            return null;
        }
        for (n = this.mMaxWidth; n >= 0 && !Character.isWhitespace(string.charAt(n)); --n) {
        }
        if (n < 0) {
            selection2.setStart(selection.getStart() + this.mMaxWidth);
            selection2.setEnd(selection.getStart() + string.length());
            return selection2;
        }
        selection2.setStart(selection.getStart() + n);
        selection2.setEnd(selection.getStart() + string.length());
        return selection2;
    }

    private void modifyOneLine(int n) {
        Selection selection = this.getLineOffsets(n);
        if (selection == null) {
            return;
        }
        Selection selection2 = this.findExcess(selection);
        if (selection2 != null) {
            Selection selection3;
            String string = this.getText(selection2);
            int n2 = this.mTextArea.getCaret().getDot();
            int n3 = n2 - selection2.getStart();
            this.mTextArea.replaceRange(null, selection2.getStart(), selection2.getEnd());
            if (n + 1 >= this.mTextArea.getLineCount()) {
                this.mTextArea.append("\n" + string);
                selection3 = this.getLineOffsets(n + 1);
            } else {
                selection3 = this.getLineOffsets(n + 1);
                this.mTextArea.insert(string, selection3.getStart());
            }
            if (n3 >= 0) {
                this.mTextArea.getCaret().setDot(selection3.getStart() + n3);
            }
        }
    }

    private class Selection {
        private int start;
        private int end;

        public Selection() {
            this.start = 0;
            this.end = 0;
        }

        public Selection(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int n) {
            this.start = n;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int n) {
            this.end = n;
        }

        public int getLength() {
            return this.end - this.start;
        }

        public String toString() {
            return "start: " + this.start + "  end: " + this.end + " len: " + this.getLength();
        }
    }
}

