/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ExtensionType;
import com.spss.java_client.core.documents.data.dictionary.IExtension;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.dialogs.base.utilities.LimitTextWidth;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.SpssTextArea;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class DataFileCommentsDlg
extends BaseProcedureDialog
implements KeyListener,
DocumentListener,
FocusListener {
    private static final String DISPLAY_COMMENT_CHECK_KEY = "IDS_DATA_FILE_COMMENTS_DISPLAY";
    private static final int MAX_LINE_LENGTH = 80;
    private SpssTextArea mEditor;
    private JScrollPane mScrollPane;
    private JCheckBox mDisplayCommentCheck;
    private JLabel mColCountLabel;
    private JLabel mCommentsLabel;
    private JLabel mColNumberLabel;
    private StringBuffer mDefaultComment;
    private boolean mHasComments;
    private boolean mIsChanged;
    boolean mDone;

    public DataFileCommentsDlg(JFrame jFrame) {
        super(jFrame, true, UtilitiesResBundle.getDefaultResourceBundleName(), UtilitiesResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_DATA_FILE_COMMENTS_TITLE"));
    }

    @Override
    public void reset() {
        this.enableOkPaste(true);
        this.mEditor.setText("");
        this.mEditor.setText(this.mDefaultComment.toString());
        this.mDisplayCommentCheck.setSelected(false);
        this.mDisplayCommentCheck.setEnabled(this.mEditor.getText().length() > 0);
        this.mColCountLabel.setText("1");
        this.mIsChanged = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataFileCommentsDlg.this.mEditor.requestFocus();
                DataFileCommentsDlg.this.mEditor.setCaretPosition(0);
            }
        });
    }

    @Override
    public String generateSyntax() {
        Object object;
        String[] stringArray;
        if (!this.mIsChanged) {
            return "";
        }
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getCommand("* " + this.getResString("IDS_DATA_FILE_COMMENTS_TITLE") + ".", true));
        stringBuffer.append(SyntaxUtil.getCommand("PRESERVE.", true));
        stringBuffer.append(SyntaxUtil.getCommand("SET PRINT OFF.", true));
        if (this.mHasComments) {
            stringBuffer.append(SyntaxUtil.getCommand("DROP DOCUMENTS.", true));
        }
        if (this.mEditor.getText().length() > 0) {
            stringBuffer.append(SyntaxUtil.getCommand("ADD DOCUMENT", true));
            stringArray = this.mEditor.getText().split("\n");
            object = "";
            for (String string : stringArray) {
                object = (String)object + SyntaxUtil.getCommand(CharacterUtil.smartQuote((String)this.trimRight(string).replace("\n", "\\n")));
            }
            stringBuffer.append(this.trimRight((String)object)).append(".\n");
        }
        if ((object = (stringArray = this.getDialogDataModel()).getBoolean(DISPLAY_COMMENT_CHECK_KEY)) != null && ((Boolean)object).booleanValue()) {
            stringBuffer.append(SyntaxUtil.getCommand("DISPLAY DOCUMENTS.", true));
        }
        stringBuffer.append(SyntaxUtil.getCommand("RESTORE.", false));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "utilities_data_file_comments";
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = this.mEditor.validateContents();
        if (bl && this.mEditor.getText().length() == 0) {
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_DATA_FILE_COMMENTS_WARNING_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            bl = n == 0;
        }
        return bl;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_doc_comments";
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource().equals(this.mEditor) && keyEvent.getKeyCode() == 9) {
            this.mEditor.selectAll();
            Component component = keyEvent.isShiftDown() ? this.getFocusTraversalPolicy().getComponentBefore((Container)((Object)this), (Component)keyEvent.getSource()) : this.getFocusTraversalPolicy().getComponentAfter((Container)((Object)this), (Component)keyEvent.getSource());
            this.mEditor.setText(this.mEditor.getText());
            component.requestFocus();
            this.mIsChanged = true;
        }
        this.mColCountLabel.setText(String.valueOf(this.getColumnCount()));
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource().equals(this.mEditor) && keyEvent.getKeyCode() != 9) {
            this.mColCountLabel.setText(String.valueOf(this.getColumnCount()));
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mScrollPane)) {
            this.mEditor.requestFocus();
            this.mEditor.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.mIsChanged = true;
        int n = documentEvent.getOffset();
        SwingUtilities.invokeLater(new LimitTextWidth((JTextArea)this.mEditor, 80, n));
        this.setEnableState();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.mIsChanged = true;
        int n = documentEvent.getOffset();
        SwingUtilities.invokeLater(new LimitTextWidth((JTextArea)this.mEditor, 80, n));
        this.setEnableState();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.mIsChanged = true;
        int n = documentEvent.getOffset();
        SwingUtilities.invokeLater(new LimitTextWidth((JTextArea)this.mEditor, 80, n));
        this.setEnableState();
    }

    private void setEnableState() {
        if (this.mEditor.getText().length() > 0) {
            this.mDisplayCommentCheck.setEnabled(true);
        } else {
            this.mDisplayCommentCheck.setEnabled(false);
            this.mDisplayCommentCheck.setSelected(false);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.setTabPolicy();
        this.pack();
    }

    private JPanel setupViewPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mCommentsLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mScrollPane.setPreferredSize(this.mEditor.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 0, 1, 6, 5, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDisplayCommentCheck, gridBagConstraints, 0, 6, 3, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mColNumberLabel, gridBagConstraints, 4, 6, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mColCountLabel, gridBagConstraints, 5, 6, 1, 1, n, insets);
        return jPanel;
    }

    private String processComment(String string) {
        String string2 = "";
        while (string.length() >= 80) {
            int n = string.indexOf(10);
            if (n != -1 && n < 80) {
                string2 = string2 + string.substring(0, n + 1);
                string = string.substring(n + 1, string.length());
                continue;
            }
            n = 80;
            String string3 = CharacterUtil.rightTrim((String)string.substring(0, n));
            string2 = string2 + string3 + "\n";
            string = CharacterUtil.rightTrim((String)string.substring(n, string.length()));
        }
        if (string.length() > 0) {
            string2 = string2 + string;
        }
        return string2;
    }

    private void setDefaults() {
        this.mHasComments = false;
        this.mIsChanged = false;
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        IExtension iExtension = iSpssDataSrc.getExtension(ExtensionType.kDocument);
        this.mDefaultComment = new StringBuffer();
        if (iExtension != null) {
            iExtension.resetIterator();
            byte[] byArray = new byte[(int)iExtension.length()];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            iExtension.getNext(byteBuffer);
            String string = "";
            try {
                string = new String(byteBuffer.array(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            if (string != null && string.length() > 0) {
                while (string.length() >= 80) {
                    String string2 = string.substring(0, 80);
                    string2 = this.trimRight(string2);
                    this.mDefaultComment.append(string2);
                    this.mDefaultComment.append("\n");
                    if (string.length() >= 81) {
                        string = string.substring(80);
                        continue;
                    }
                    string = null;
                    break;
                }
                if (string != null && string.length() > 0) {
                    this.trimRight(string);
                    this.mDefaultComment.append(string);
                }
            }
        }
        this.mEditor.setText(this.mDefaultComment.toString());
        if (this.mDefaultComment.length() > 0) {
            this.mHasComments = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataFileCommentsDlg.this.mEditor.requestFocus();
                DataFileCommentsDlg.this.mEditor.setCaretPosition(0);
            }
        });
        this.mDisplayCommentCheck.setEnabled(this.mEditor.getText().length() > 0);
        this.enableOkPaste(true);
    }

    private String trimRight(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (n == 0) {
            return " ";
        }
        if (string.trim().length() > 0) {
            while (cArray[n - 1] <= ' ') {
                --n;
            }
            return string.substring(0, n);
        }
        return string.substring(0, 1);
    }

    private void trimRight(StringBuffer stringBuffer) {
        int n;
        for (n = stringBuffer.length() - 1; n >= 0 && Character.isWhitespace(stringBuffer.charAt(n)); --n) {
        }
        stringBuffer.replace(++n, stringBuffer.length(), "");
    }

    private void initVars() {
        this.mEditor = new SpssTextArea(Charset.forName("UTF-8"));
        this.mEditor.setMinimumSize(new Dimension(250, 300));
        this.mDone = false;
        this.mScrollPane = new JScrollPane((Component)this.mEditor);
        this.mEditor.setDocument((Document)new NoTabDocument());
        if (ComponentState.isBtdRtlOrLtr()) {
            if (ComponentState.getBTD() == 1) {
                this.mEditor.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                this.mEditor.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        }
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, DISPLAY_COMMENT_CHECK_KEY);
        this.mDisplayCommentCheck = new JCheckBox(toggleButtonAction);
        this.mCommentsLabel = DialogUtil.createLabel(this, "IDS_DATA_FILE_COMMENTS_LABEL");
        this.mCommentsLabel.setLabelFor((Component)this.mEditor);
        this.mColNumberLabel = new JLabel(this.getResString("IDS_DATA_FILE_COMMENTS_COL_NUM_LABEL"));
        this.mColCountLabel = new JLabel("1");
        this.mColCountLabel.setMinimumSize(new Dimension(20, 20));
        this.mColCountLabel.setPreferredSize(this.mColCountLabel.getMinimumSize());
        this.setDefaults();
        this.mEditor.addKeyListener((KeyListener)this);
        this.mScrollPane.addFocusListener(this);
        this.mEditor.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DataFileCommentsDlg.this.mColCountLabel.setText(String.valueOf(DataFileCommentsDlg.this.getColumnCount()));
            }
        });
        this.mEditor.getDocument().addDocumentListener(this);
    }

    private int getColumnCount() {
        int n = 0;
        try {
            int n2 = this.mEditor.getCaretPosition();
            int n3 = this.mEditor.getLineOfOffset(n2);
            int n4 = this.mEditor.getLineStartOffset(n3);
            String string = this.mEditor.getText(n4, n2 - n4);
            n = string.length() + 1;
        }
        catch (BadLocationException badLocationException) {
            ComponentState.trace1((String)badLocationException.getMessage(), (int)15);
        }
        return n;
    }

    private void setTabPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mScrollPane);
        vector.add(this.mDisplayCommentCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    class NoTabDocument
    extends PlainDocument {
        NoTabDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (!string.equals("\t")) {
                super.insertString(n, string, attributeSet);
            }
        }
    }
}

