/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.visual_bander;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.CoreFrequencies;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.transform.res.TransformResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.FrequenciesScanner;
import com.spss.java_client.ui.dialogs.common.IFrequencyScannerListener;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.actions.GatingDialogAction;
import com.spss.java_client.ui.doc_types.actions.ProcedureAction;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.doc_util.ProcedureDialogLoader;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.IntTextField;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class VisualBanderProcDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
DocumentListener,
IFrequencyScannerListener {
    public static final String LIMIT_CASES_CHECKBOX = "IDS_VB_LIMIT_CASES";
    public static final String LIMIT_CASE_EDIT = "IDS_VB_LIMIT_CASES_EDIT";
    private static TargetVariableList sTargetVarList;
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private ArrowButton mArrowButton;
    private JScrollPane mTargetScrollPane;
    private IntTextField mLimitCasesEdit;
    private JCheckBox mLimitCasesCheck;

    public VisualBanderProcDlg(JFrame jFrame) {
        super(jFrame, false, TransformResBundle.getDefaultResourceBundleName(), TransformResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_VISUAL_BANDER_TITLE"));
    }

    @Override
    protected void saveDialogState() {
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    @Override
    public String generateSyntax() {
        return null;
    }

    @Override
    public String getIActionKey() {
        return "transform_visual_binning_main";
    }

    public void showInfoDialog(String string) {
        SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mLimitCasesEdit.setEnabled(this.mLimitCasesCheck.isSelected());
        this.mLimitCasesEdit.setOpaque(this.mLimitCasesCheck.isSelected());
        this.mLimitCasesEdit.setEditable(this.mLimitCasesCheck.isSelected());
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    public static VarListModel getTargetListModel() {
        return sTargetVarList.getModel();
    }

    public long getMaxCases() {
        if (this.mLimitCasesEdit.getText() != null && !this.mLimitCasesEdit.getText().equals("")) {
            return Long.parseLong(this.mLimitCasesEdit.getText());
        }
        return 0L;
    }

    public static boolean canShowLabel() {
        return sTargetVarList.getShowVarLabels();
    }

    public void enableContinue(boolean bl) {
        this.getOkButton().setEnabled(bl);
    }

    @Override
    public void finishedScanning(final CoreFrequencies coreFrequencies) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpssAction spssAction = ActionCatalog.getActionCatalog().getSpssAction("transform_visual_binning_main");
                VisualBanderProcDlg.this.showDialog(spssAction, coreFrequencies);
            }
        });
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bander_gating";
    }

    @Override
    protected boolean okPastePressed() {
        if (this.continuePressed() && sTargetVarList.getModel().getSize() > 0) {
            this.resetAutomationListener();
            this.setVisible(false);
            DataFrame dataFrame = (DataFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
            LocallyUniqueId locallyUniqueId = dataFrame.getDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            long l = iSpssDataSrc.rowCount();
            Vector<LocallyUniqueId> vector = new Vector<LocallyUniqueId>();
            int n = sTargetVarList.getModel().getSize();
            long l2 = -1L;
            VarListModel varListModel = sTargetVarList.getModel();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = varListModel.getElementAt(i);
                vector.add(iSpssVariable.getId());
            }
            if (this.mLimitCasesCheck.isSelected() && this.mLimitCasesEdit.getText() != null && !this.mLimitCasesEdit.getText().equals("")) {
                l2 = Long.parseLong(this.mLimitCasesEdit.getText());
            }
            ProcedureDlgMgr.getMgr().saveDialogSize(this.getIActionKey(), this.getSize());
            long l3 = l2 == -1L ? l : l2;
            int n2 = this.getUpdateInterval(l3);
            CoreFrequencies coreFrequencies = new CoreFrequencies();
            coreFrequencies.wantWeighted(true);
            coreFrequencies.run(locallyUniqueId, vector, n2, l3);
            FrequenciesScanner frequenciesScanner = new FrequenciesScanner(coreFrequencies, SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame(), this.getResString("IDS_SCANNING_CASES"));
            frequenciesScanner.registerScannerListener(this);
            frequenciesScanner.startScanning();
            return true;
        }
        return false;
    }

    private int getUpdateInterval(long l) {
        int n = 500;
        if (l > 500000L) {
            n = 2000;
        } else if (l > 100000L) {
            n = 1000;
        }
        return n;
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        jPanel.remove(this.getPasteButton());
        jPanel.remove(this.getResetButton());
        this.getOkButton().setText(ResUtil.getCommonDlgString("IDS_CONTINUE"));
        this.getRootPane().setDefaultButton(this.getOkButton());
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    @Override
    protected void init() {
        super.init();
        this.initVar();
        JPanel jPanel = super.getViewPanel();
        JPanel jPanel2 = this.setupViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.setDefaults();
        this.pack();
        this.setFocusTraversalPolicy();
    }

    private void initVar() {
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.addVarFilter(new SpssVarFilter(4616, true, true));
        this.mSrcVarList.loadFromActiveDataset();
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        sTargetVarList = new TargetVariableList();
        sTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), sTargetVarList.getFixedCellHeight() * 11 + 2));
        this.mTargetScrollPane = new JScrollPane(sTargetVarList);
        this.mTargetScrollPane.setPreferredSize(sTargetVarList.getMinimumSize());
        sTargetVarList.getModel().addListDataListener(this);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(sTargetVarList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, LIMIT_CASES_CHECKBOX);
        this.mLimitCasesCheck = new JCheckBox(toggleButtonAction);
        this.mLimitCasesCheck.addItemListener(this);
        this.mLimitCasesEdit = new IntTextField(true);
        this.mLimitCasesEdit.setColumns(5);
        this.mLimitCasesEdit.setMinimumSize(new Dimension(62, 20));
        this.mLimitCasesEdit.setAction((Action)new TextFieldAction(this, LIMIT_CASE_EDIT));
        this.mLimitCasesEdit.getDocument().addDocumentListener(this);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(sTargetVarList);
        vector.add(this.mLimitCasesCheck);
        vector.add(this.mLimitCasesEdit);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupViewPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(uRL));
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_VB_VARLIST_LABEL");
        jLabel2.setLabelFor(this.mSrcVarList);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_VB_BANDLIST_LABEL");
        jLabel3.setLabelFor(sTargetVarList);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setRows(2);
        jTextArea.setFont(jLabel2.getFont());
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setText(this.getResString("IDS_VB_LABEL1"));
        jTextArea.setFocusable(false);
        JTextArea jTextArea2 = new JTextArea();
        jTextArea2.setRows(2);
        jTextArea2.setFont(jLabel2.getFont());
        jTextArea2.setOpaque(false);
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setText(this.getResString("IDS_VB_LABEL2"));
        jTextArea2.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 0, 3, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jTextArea2, gridBagConstraints, 1, 1, 3, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 2, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 3, 2, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 1, 3, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane, gridBagConstraints, 3, 3, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 2, 3, 1, 1, n, DialogUtil.getArrowButtonInsets());
        gridBagConstraints.weightx = 1.0;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.setupLimitCasesPanel(), gridBagConstraints, 1, 4, 3, 1, n, insets);
        return jPanel;
    }

    private JPanel setupLimitCasesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mLimitCasesCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLimitCasesEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private boolean canEnableContinue() {
        if (sTargetVarList.getModel().getSize() > 0) {
            if (this.mLimitCasesCheck.isSelected()) {
                return this.mLimitCasesEdit.getText().length() > 0;
            }
            return true;
        }
        return false;
    }

    private void setDefaults() {
        this.mLimitCasesEdit.setEnabled(false);
        this.mLimitCasesEdit.setOpaque(false);
        this.mLimitCasesEdit.setEditable(false);
        this.enableContinue(false);
        this.mSrcVarList.setSelectedIndex(0);
    }

    private boolean continuePressed() {
        if (!this.isTargetListvalid()) {
            this.showInfoDialog(this.getResString("ERR_VB_VARIABLE_SELECTED_NOT_VALID"));
            VarListModel varListModel = sTargetVarList.getModel();
            Vector<SpssVariable> vector = new Vector<SpssVariable>();
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            for (int i = 0; i < varListModel.getSize(); ++i) {
                SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(i);
                int n = iSpssDataSrc.findVarIndex(spssVariable.getId());
                if (n != -1 && spssVariable.getType() <= 0 && !spssVariable.getMeasurementLevel().equals((Object)MeasurementLevel.nominal)) continue;
                vector.addElement(spssVariable);
            }
            for (ISpssVariable iSpssVariable : vector) {
                varListModel.removeElement(iSpssVariable);
            }
            this.dispose();
        }
        return true;
    }

    private boolean isTargetListvalid() {
        VarListModel varListModel = sTargetVarList.getModel();
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        for (int i = 0; i < varListModel.getSize(); ++i) {
            SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(i);
            int n = iSpssDataSrc.findVarIndex(spssVariable.getId());
            if (n != -1 && spssVariable.getType() <= 0 && !spssVariable.getMeasurementLevel().equals((Object)MeasurementLevel.nominal)) continue;
            return false;
        }
        return true;
    }

    private void showDialog(SpssAction spssAction, CoreFrequencies coreFrequencies) {
        try {
            Class<?> clazz;
            Object object;
            if (spssAction instanceof ProcedureAction) {
                object = (ProcedureAction)spssAction;
                clazz = Class.forName(((ProcedureAction)object).getDlgLaunchPath());
            } else if (spssAction instanceof GatingDialogAction) {
                object = (GatingDialogAction)spssAction;
                clazz = Class.forName(((ProcedureAction)object).getDlgLaunchPath());
            } else {
                assert (false);
                return;
            }
            object = clazz.getConstructor(JFrame.class, CoreFrequencies.class);
            ProcedureDialogLoader.dialogLaunching((ProcedureAction)spssAction, null);
            ((Constructor)object).newInstance(this.getParent(), coreFrequencies);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

