/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.visual_bander;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.transform.visual_bander.VisualBanderDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.FloatDocument;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntDocument;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class VisualBanderMakeCutpoints
extends BaseSubDialog
implements ItemListener,
DocumentListener,
FocusListener {
    private static final String EQUAL_WIDTH_INTERVAL_RADIO = "IDS_VB_EQUAL_WIDTH_INTERVALS";
    private static final String EQUAL_PERCENTILE_RADIO = "IDS_VB_EQUAL_PERCENTILES_BASED_ON_SCANNED_CASES";
    private static final String FIRST_STD_DEVIATION = "IDS_VB_+/-_1_STD_DEVIATION";
    private static final String SECOND_STD_DEVIATION = "IDS_VB_+/-_2_STD_DEVIATION";
    private static final String THIRD_STD_DEVIATION = "IDS_VB_+/-_3_STD_DEVIATION";
    private static final String CUTPTS_AT_MEAN_N_STD_DEVIATION = "IDS_VB_CUTPOINTS_AT_MEAN_AND_SELECTED_STANDARD_DEVIATIONS_BASED_ON_SCANNED_CASES";
    private JRadioButton mEqualWidthRadio;
    private JRadioButton mEqualPercentileRadio;
    private JRadioButton mCutPtAtMeanRadio;
    private JLabel mCutPtLocationLabel;
    private JLabel mNoOfCutptsInEWLabel;
    private JLabel mWidthInEWLabel;
    private JLabel mLastCutPtLocLabel;
    private ContextEnabledTextField mCutPtLocationEdit;
    private IntTextField mNoOfCutPtsInEWEdit;
    private FloatTextField mWidthInEWEdit;
    private JLabel mNoOfCutptsInEPLabel;
    private JLabel mWidthInEPLabel;
    private IntTextField mNoOfCutPtsInEPEdit;
    private FloatTextField mWidthInEPEdit;
    private JCheckBox mFirstStdDevCheck;
    private JCheckBox mSecondStdDevCheck;
    private JCheckBox mThirdStdDevCheck;
    private boolean mUniformAutoUpdated;
    private double mFirstLoc;
    private VisualBanderDlg.ScannedVarListVar var;
    private JTextField mLastCutPtEdit;
    private boolean mPercentileAutoUpdated;
    private TitledBorder mEqualWidthPanelBorder;
    private TitledBorder mEqualPercentilePanelBorder;
    private SpssButtonGroup mRadioGroup;

    public VisualBanderMakeCutpoints(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_VB_MAKE_CUTPOINTS"), true);
        this.var = ((VisualBanderDlg)this.mParentDlg).getCurrentVar();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        if (itemEvent.getSource() == this.mEqualWidthRadio) {
            bl = this.mEqualWidthRadio.isSelected();
            this.enableEqualWidthGroup(bl);
            this.enableEqualPercentileGroup(!bl);
            this.enableCutPtAtMeanAndStdDevGroup(!bl);
            if (bl) {
                DialogUtil.enableTitledBorder(this.mEqualWidthPanelBorder, true);
                DialogUtil.enableTitledBorder(this.mEqualPercentilePanelBorder, false);
                this.repaint();
            }
            this.enableContinue(this.canEnableContinue());
        }
        if (itemEvent.getSource() == this.mEqualPercentileRadio) {
            bl = this.mEqualPercentileRadio.isSelected();
            this.enableEqualWidthGroup(!bl);
            this.enableEqualPercentileGroup(bl);
            this.enableCutPtAtMeanAndStdDevGroup(!bl);
            if (bl) {
                DialogUtil.enableTitledBorder(this.mEqualWidthPanelBorder, false);
                DialogUtil.enableTitledBorder(this.mEqualPercentilePanelBorder, true);
                this.repaint();
            }
            this.enableContinue(this.canEnableContinue());
        }
        if (itemEvent.getSource() == this.mCutPtAtMeanRadio) {
            this.enableEqualWidthGroup(!this.mCutPtAtMeanRadio.isSelected());
            this.enableEqualPercentileGroup(!this.mCutPtAtMeanRadio.isSelected());
            this.enableCutPtAtMeanAndStdDevGroup(this.mCutPtAtMeanRadio.isSelected());
            this.enableContinue(this.canEnableContinue());
        }
    }

    @Override
    public boolean continuePressed() {
        if (this.var.getCutPts().size() > 2 && !this.showDialog(this.getResString("ERR_VB_EXISTING_CUTPOINTS_REPLACED"))) {
            return false;
        }
        if (this.mEqualWidthRadio.isSelected()) {
            this.calculateUniformCutPoints();
        } else {
            if (this.mEqualPercentileRadio.isSelected()) {
                String string = this.mNoOfCutPtsInEPEdit.getText();
                double d = Double.parseDouble(this.mWidthInEPEdit.getText());
                return ((VisualBanderDlg)this.mParentDlg).createPercentileCutPts(Integer.parseInt(string), d);
            }
            this.calculateMeanSdCutPts();
        }
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bander_cutpoints";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        double d;
        int n;
        if (documentEvent.getDocument() == this.mNoOfCutPtsInEPEdit.getDocument()) {
            if (!this.mPercentileAutoUpdated) {
                n = 0;
                if (this.mNoOfCutPtsInEPEdit.getText().equals("")) {
                    this.mWidthInEPEdit.setText("");
                    this.enableContinue(this.canEnableContinue());
                    return;
                }
                n = Integer.parseInt(this.mNoOfCutPtsInEPEdit.getText());
                if (n > 0 && n <= 500) {
                    d = -1.0;
                    d = 100.0 / (double)(n + 1);
                    this.mPercentileAutoUpdated = true;
                    this.mWidthInEPEdit.setText(String.format(ComponentState.getSPSSLocale(), "%.2f", d));
                    this.mPercentileAutoUpdated = false;
                } else {
                    this.showInfoDialog(this.getResString("ERR_VB_NUMBER_TOO_SMALL_OR_MANY"));
                }
            }
            this.enableContinue(this.canEnableContinue());
        }
        if (documentEvent.getDocument() == this.mWidthInEPEdit.getDocument()) {
            if (!this.mPercentileAutoUpdated) {
                String string = this.mWidthInEPEdit.getText();
                d = 0.0;
                double d2 = 0.0;
                if (!string.equals("")) {
                    try {
                        d = string.equals(".") ? 0.0 : Double.parseDouble(string);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    this.mNoOfCutPtsInEPEdit.setText("");
                    this.enableContinue(this.canEnableContinue());
                    return;
                }
                if (string.length() > 0 && !(d <= 0.0) && !(d > 50.0)) {
                    d2 = 100.0 / d - 1.0;
                }
                if ((d2 = (double)Math.round(d2)) > 500.0 && d != 0.0) {
                    this.showInfoDialog(this.getResString("ERR_VB_WIDTH_TOO_SMALL"));
                    return;
                }
                if ((int)d2 > 0) {
                    String string2 = "";
                    string2 = String.format("%d", (int)d2);
                    this.mPercentileAutoUpdated = true;
                    this.mNoOfCutPtsInEPEdit.setText(string2);
                    this.mPercentileAutoUpdated = false;
                }
            }
            this.enableContinue(this.canEnableContinue());
        }
        if (documentEvent.getDocument() == this.mCutPtLocationEdit.getDocument()) {
            this.calculateLastCutPoints();
        }
        if (documentEvent.getDocument() == this.mNoOfCutPtsInEWEdit.getDocument()) {
            n = 0;
            if (this.mNoOfCutPtsInEWEdit.getText().length() > 0) {
                n = Integer.parseInt(this.mNoOfCutPtsInEWEdit.getText());
                if (n > 0 && n <= 500) {
                    this.calculateLastCutPoints();
                } else {
                    this.mUniformAutoUpdated = true;
                    this.showInfoDialog(this.getResString("ERR_VB_NUMBER_TOO_SMALL_OR_MANY"));
                    this.mUniformAutoUpdated = false;
                }
            }
            this.enableContinue(this.canEnableContinue());
        }
        if (documentEvent.getDocument() == this.mWidthInEWEdit.getDocument()) {
            double d3 = Double.parseDouble(this.mWidthInEWEdit.getText());
            if (d3 > 0.0) {
                this.calculateLastCutPoints();
            }
            this.enableContinue(this.canEnableContinue());
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        double d;
        int n;
        if (documentEvent.getDocument() == this.mNoOfCutPtsInEPEdit.getDocument()) {
            if (!this.mPercentileAutoUpdated) {
                n = 0;
                if (this.mNoOfCutPtsInEPEdit.getText().equals("")) {
                    this.mWidthInEPEdit.setText("");
                    this.enableContinue(this.canEnableContinue());
                    return;
                }
                n = Integer.parseInt(this.mNoOfCutPtsInEPEdit.getText());
                if (n > 0 && n <= 500) {
                    d = -1.0;
                    d = 100.0 / (double)(n + 1);
                    this.mPercentileAutoUpdated = true;
                    this.mWidthInEPEdit.setText(String.format(ComponentState.getSPSSLocale(), "%.2f", d));
                    this.mPercentileAutoUpdated = false;
                }
            }
            this.enableContinue(this.canEnableContinue());
        }
        if (documentEvent.getDocument() == this.mWidthInEPEdit.getDocument()) {
            if (!this.mPercentileAutoUpdated) {
                String string = this.mWidthInEPEdit.getText();
                d = 0.0;
                double d2 = 0.0;
                if (!string.equals("")) {
                    try {
                        d = Double.parseDouble(string);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    this.mNoOfCutPtsInEPEdit.setText("");
                    this.enableContinue(this.canEnableContinue());
                    return;
                }
                if (string.length() > 0 && !(d <= 0.0) && !(d > 50.0)) {
                    d2 = 100.0 / d - 1.0;
                }
                if ((d2 = (double)Math.round(d2)) > 500.0 && d != 0.0) {
                    this.mPercentileAutoUpdated = true;
                    this.showInfoDialog(this.getResString("ERR_VB_WIDTH_TOO_SMALL"));
                    this.mPercentileAutoUpdated = false;
                    return;
                }
                if ((int)d2 > 0) {
                    String string2 = "";
                    string2 = String.format("%d", (int)d2);
                    this.mPercentileAutoUpdated = true;
                    this.mNoOfCutPtsInEPEdit.setText(string2);
                    this.mPercentileAutoUpdated = false;
                }
            }
            this.enableContinue(this.canEnableContinue());
        }
        if (documentEvent.getDocument() == this.mNoOfCutPtsInEWEdit.getDocument()) {
            if (this.mNoOfCutPtsInEWEdit.getText().length() > 0) {
                n = Integer.parseInt(this.mNoOfCutPtsInEWEdit.getText());
                if (n > 0 && n <= 500) {
                    this.calculateLastCutPoints();
                } else {
                    this.mUniformAutoUpdated = true;
                    this.showInfoDialog(this.getResString("ERR_VB_NUMBER_TOO_SMALL_OR_MANY"));
                    this.mUniformAutoUpdated = false;
                }
            }
            this.enableContinue(this.canEnableContinue());
        }
        if (documentEvent.getDocument() == this.mWidthInEWEdit.getDocument()) {
            double d3;
            if (this.mWidthInEWEdit.getText().length() > 0 && (d3 = Double.parseDouble(this.mWidthInEWEdit.getText())) > 0.0) {
                this.calculateLastCutPoints();
            }
            this.enableContinue(this.canEnableContinue());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        double d;
        int n;
        if (documentEvent.getDocument() == this.mNoOfCutPtsInEPEdit.getDocument()) {
            if (!this.mPercentileAutoUpdated) {
                n = 0;
                if (this.mNoOfCutPtsInEPEdit.getText().equals("")) {
                    this.mWidthInEPEdit.setText("");
                    this.enableContinue(this.canEnableContinue());
                    return;
                }
                n = Integer.parseInt(this.mNoOfCutPtsInEPEdit.getText());
                if (n > 0 && n <= 500) {
                    d = -1.0;
                    d = 100.0 / (double)(n + 1);
                    this.mPercentileAutoUpdated = true;
                    this.mWidthInEPEdit.setText(String.format(ComponentState.getSPSSLocale(), "%.2f", d));
                    this.mPercentileAutoUpdated = false;
                }
            }
            this.enableContinue(this.canEnableContinue());
        }
        if (documentEvent.getDocument() == this.mWidthInEPEdit.getDocument()) {
            if (!this.mPercentileAutoUpdated) {
                String string = this.mWidthInEPEdit.getText();
                d = 0.0;
                double d2 = 0.0;
                if (!string.equals("")) {
                    try {
                        d = Double.parseDouble(string);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    this.mNoOfCutPtsInEPEdit.setText("");
                    this.enableContinue(this.canEnableContinue());
                    return;
                }
                if (string.length() > 0 && !(d <= 0.0) && !(d > 50.0)) {
                    d2 = 100.0 / d - 1.0;
                }
                if ((d2 = (double)Math.round(d2)) > 500.0 && d != 0.0) {
                    this.showInfoDialog(this.getResString("ERR_VB_WIDTH_TOO_SMALL"));
                    return;
                }
                if ((int)d2 > 0) {
                    String string2 = "";
                    string2 = String.format("%d", (int)d2);
                    this.mPercentileAutoUpdated = true;
                    this.mNoOfCutPtsInEPEdit.setText(string2);
                    this.mPercentileAutoUpdated = false;
                }
            }
            this.enableContinue(this.canEnableContinue());
        }
        if (documentEvent.getDocument() == this.mNoOfCutPtsInEWEdit.getDocument()) {
            if (this.mNoOfCutPtsInEWEdit.getText().length() > 0) {
                n = Integer.parseInt(this.mNoOfCutPtsInEWEdit.getText());
                if (n > 0 && n <= 500) {
                    this.calculateLastCutPoints();
                } else {
                    this.mUniformAutoUpdated = true;
                    this.showInfoDialog(this.getResString("ERR_VB_NUMBER_TOO_SMALL_OR_MANY"));
                    this.mUniformAutoUpdated = false;
                }
            }
            this.enableContinue(this.canEnableContinue());
        }
        if (documentEvent.getDocument() == this.mWidthInEWEdit.getDocument()) {
            double d3;
            if (this.mWidthInEWEdit.getText().length() > 0 && (d3 = Double.parseDouble(this.mWidthInEWEdit.getText())) > 0.0) {
                this.calculateLastCutPoints();
            }
            this.enableContinue(this.canEnableContinue());
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        double d;
        String string;
        if (focusEvent.getSource() == this.mCutPtLocationEdit && !this.mUniformAutoUpdated && (string = this.mCutPtLocationEdit.getText()).length() > 0) {
            OBS oBS = new OBS();
            if (CellValueFormatter.stringToObs((String)string, (SPSS_Format)this.var.getSpssVar().getFormat(), (OBS)oBS)) {
                this.mFirstLoc = oBS.getNum();
                if (Double.isInfinite(this.mFirstLoc)) {
                    this.mCutPtLocationEdit.setText("");
                    this.mLastCutPtEdit.setText("");
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    int n = string.indexOf("E");
                    if (n == -1) {
                        SPSS_Format sPSS_Format = this.var.getSpssVar().getFormat();
                        sPSS_Format = string.length() >= 40 ? new SPSS_Format(FormatType.E, sPSS_Format.getWidth(), sPSS_Format.getDecimals()) : sPSS_Format;
                        String string2 = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
                        this.mUniformAutoUpdated = true;
                        this.mCutPtLocationEdit.setText(string2);
                    }
                    this.mUniformAutoUpdated = false;
                    this.calculateRemainingField();
                }
            } else {
                this.mCutPtLocationEdit.setText("");
            }
            this.calculateRemainingField();
        }
        if (focusEvent.getSource() == this.mNoOfCutPtsInEWEdit && !this.mUniformAutoUpdated) {
            this.calculateRemainingField();
        }
        if (focusEvent.getSource() == this.mWidthInEWEdit) {
            double d2;
            string = this.mWidthInEWEdit.getText();
            if (string.length() > 0 && (d2 = Double.parseDouble(string)) == 0.0) {
                this.showInfoDialog(this.getResString("ERR_VB_BIN_WIDTH_POSITIVE"));
                this.setSelectionText((JTextField)this.mWidthInEWEdit, 0);
            }
            if (!this.mUniformAutoUpdated) {
                this.calculateRemainingField();
            }
        }
        if (focusEvent.getSource() == this.mWidthInEPEdit && (string = this.mWidthInEPEdit.getText()).length() > 0 && ((d = Double.parseDouble(string)) <= 0.0 || d > 50.0)) {
            this.showInfoDialog(this.getResString("ERR_VB_BIN_WIDTH_PTILE_POSITIVE"));
            this.setSelectionText((JTextField)this.mWidthInEPEdit, 0);
        }
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        return true;
    }

    private void setSelectionText(final JTextField jTextField, int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jTextField.requestFocusInWindow();
            }
        });
        jTextField.setSelectionStart(n);
        jTextField.setSelectionEnd(jTextField.getText().length());
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.setupViewPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        this.pack();
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.renameContinueAction("IDS_APPLY");
    }

    private void initVars() {
        FocusListener[] focusListenerArray;
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, EQUAL_WIDTH_INTERVAL_RADIO);
        this.mEqualWidthRadio = new JRadioButton(toggleButtonAction);
        this.mEqualWidthRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, EQUAL_PERCENTILE_RADIO);
        this.mEqualPercentileRadio = new JRadioButton(toggleButtonAction);
        this.mEqualPercentileRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, CUTPTS_AT_MEAN_N_STD_DEVIATION);
        this.mCutPtAtMeanRadio = new JRadioButton(toggleButtonAction);
        this.mCutPtAtMeanRadio.addItemListener(this);
        this.mCutPtLocationLabel = DialogUtil.createLabel(this, "IDS_VB_FIRST_CUTPOINT_LOCATION");
        this.mNoOfCutptsInEWLabel = DialogUtil.createLabel(this, "IDS_VB_NUMBER_OF_CUTPOINTS");
        this.mWidthInEWLabel = DialogUtil.createLabel(this, "IDS_VB_WIDTH");
        this.mLastCutPtLocLabel = new JLabel(this.getResString("IDS_VB_LAST_CUTPOINT_LOCATION"));
        this.mCutPtLocationEdit = new ContextEnabledTextField();
        this.mCutPtLocationEdit.addFocusListener((FocusListener)this);
        this.mCutPtLocationEdit.getDocument().addDocumentListener(this);
        this.mNoOfCutPtsInEWEdit = new IntTextField(true);
        this.mNoOfCutPtsInEWEdit.setDocument((Document)new IntDocument());
        this.mNoOfCutPtsInEWEdit.getDocument().addDocumentListener(this);
        this.mNoOfCutPtsInEWEdit.addFocusListener((FocusListener)this);
        this.mWidthInEWEdit = new FloatTextField(true);
        this.mWidthInEWEdit.setDocument((Document)new FloatDocument(true));
        this.mWidthInEWEdit.setMinVal(0.0);
        this.mWidthInEWEdit.setIncludeMinRange(false);
        this.mWidthInEWEdit.getDocument().addDocumentListener(this);
        for (FocusListener focusListener : focusListenerArray = this.mWidthInEWEdit.getFocusListeners()) {
            if (!(focusListener instanceof FloatTextField)) continue;
            this.mWidthInEWEdit.removeFocusListener(focusListener);
            break;
        }
        this.mWidthInEWEdit.addFocusListener((FocusListener)this);
        this.mLastCutPtEdit = new JTextField();
        this.mLastCutPtEdit.setOpaque(false);
        this.mLastCutPtEdit.setBorder(BorderFactory.createEmptyBorder());
        this.mLastCutPtEdit.setEditable(false);
        this.mLastCutPtEdit.setFocusable(false);
        this.mCutPtLocationLabel.setLabelFor((Component)this.mCutPtLocationEdit);
        this.mNoOfCutptsInEWLabel.setLabelFor((Component)this.mNoOfCutPtsInEWEdit);
        this.mWidthInEWLabel.setLabelFor((Component)this.mWidthInEWEdit);
        this.mNoOfCutptsInEPLabel = DialogUtil.createLabel(this, "IDS_VB_NUMBER_OF_CUTPOINTS(%)");
        this.mWidthInEPLabel = DialogUtil.createLabel(this, "IDS_VB_WIDTH(%)");
        this.mNoOfCutPtsInEPEdit = new IntTextField(0, 500, true);
        this.mNoOfCutPtsInEPEdit.setDocument((Document)new IntDocument());
        this.mNoOfCutPtsInEPEdit.getDocument().addDocumentListener(this);
        this.mWidthInEPEdit = new FloatTextField(true);
        this.mWidthInEPEdit.setDocument((Document)new FloatDocument(true));
        this.mWidthInEPEdit.getDocument().addDocumentListener(this);
        for (FocusListener focusListener : focusListenerArray = this.mWidthInEPEdit.getFocusListeners()) {
            if (!(focusListener instanceof FloatTextField)) continue;
            this.mWidthInEPEdit.removeFocusListener(focusListener);
            break;
        }
        this.mWidthInEPEdit.addFocusListener((FocusListener)this);
        this.mNoOfCutptsInEPLabel.setLabelFor((Component)this.mNoOfCutPtsInEPEdit);
        this.mWidthInEPLabel.setLabelFor((Component)this.mWidthInEPEdit);
        toggleButtonAction = new ToggleButtonAction(this, FIRST_STD_DEVIATION);
        this.mFirstStdDevCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, SECOND_STD_DEVIATION);
        this.mSecondStdDevCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, THIRD_STD_DEVIATION);
        this.mThirdStdDevCheck = new JCheckBox(toggleButtonAction);
        this.mRadioGroup = new SpssButtonGroup();
        this.mRadioGroup.add(this.mEqualWidthRadio);
        this.mRadioGroup.add(this.mEqualPercentileRadio);
        this.mRadioGroup.add(this.mCutPtAtMeanRadio);
        this.mEqualWidthPanelBorder = BorderFactory.createTitledBorder(this.getResString("IDS_VB_INTERVALS_FILL_IN_AT_LEAST_TWO_FIELDS"));
        this.mEqualPercentilePanelBorder = BorderFactory.createTitledBorder(this.getResString("IDS_VB_INTERVALS_FILL_IN_EITHER_FIELD"));
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRadioGroup);
        vector.add(this.mCutPtLocationEdit);
        vector.add(this.mNoOfCutPtsInEWEdit);
        vector.add(this.mWidthInEWEdit);
        vector.add(this.mNoOfCutPtsInEPEdit);
        vector.add(this.mWidthInEPEdit);
        vector.add(this.mFirstStdDevCheck);
        vector.add(this.mSecondStdDevCheck);
        vector.add(this.mThirdStdDevCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupViewPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap() * 2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mEqualWidthRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupEqualWidthIntervalPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mEqualPercentileRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupEqualPercentilePanel(), gridBagConstraints, 0, 3, 1, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mCutPtAtMeanRadio, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JPanel jPanel2 = this.setupMeanAndStdDeviationCutPtPanel();
        DialogUtil.createButtonGroup(jPanel2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        insets2.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupApplyDescPanel(), gridBagConstraints, 0, 6, 1, 1, n, insets2);
        return jPanel;
    }

    private void setDefaults() {
        this.enableEqualWidthGroup(true);
        this.enableEqualPercentileGroup(false);
        this.enableCutPtAtMeanAndStdDevGroup(false);
        this.mEqualWidthRadio.setSelected(true);
        this.enableContinue(false);
    }

    private void enableCutPtAtMeanAndStdDevGroup(boolean bl) {
        this.mFirstStdDevCheck.setEnabled(bl);
        this.mSecondStdDevCheck.setEnabled(bl);
        this.mThirdStdDevCheck.setEnabled(bl);
    }

    private void enableEqualPercentileGroup(boolean bl) {
        this.mNoOfCutptsInEPLabel.setEnabled(bl);
        this.mWidthInEPLabel.setEnabled(bl);
        this.mNoOfCutPtsInEPEdit.setEnabled(bl);
        this.mWidthInEPEdit.setEnabled(bl);
        this.mNoOfCutPtsInEPEdit.setOpaque(bl);
        this.mWidthInEPEdit.setOpaque(bl);
    }

    private void enableEqualWidthGroup(boolean bl) {
        this.mCutPtLocationLabel.setEnabled(bl);
        this.mNoOfCutptsInEWLabel.setEnabled(bl);
        this.mWidthInEWLabel.setEnabled(bl);
        this.mCutPtLocationEdit.setEnabled(bl);
        this.mNoOfCutPtsInEWEdit.setEnabled(bl);
        this.mLastCutPtEdit.setEnabled(bl);
        this.mWidthInEWEdit.setEnabled(bl);
        this.mLastCutPtLocLabel.setEnabled(bl);
        this.mCutPtLocationEdit.setOpaque(bl);
        this.mNoOfCutPtsInEWEdit.setOpaque(bl);
        this.mWidthInEWEdit.setOpaque(bl);
    }

    private JPanel setupEqualWidthIntervalPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(this.mEqualWidthPanelBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(3, 3, 3, n2);
        Insets insets2 = new Insets(3, n2, 3, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCutPtLocationLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mNoOfCutptsInEWLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mWidthInEWLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCutPtLocationEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNoOfCutPtsInEWEdit, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mWidthInEWEdit, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mLastCutPtLocLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        gridBagConstraints.ipady = 7;
        gridBagConstraints.weightx = 1.0;
        insets.set(1, 3, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mLastCutPtEdit, gridBagConstraints, 1, 3, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupEqualPercentilePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(this.mEqualPercentilePanelBorder);
        JLabel jLabel = new JLabel(" ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(3, 3, 3, n2);
        Insets insets2 = new Insets(3, n2, 3, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNoOfCutptsInEPLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mWidthInEPLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNoOfCutPtsInEPEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mWidthInEPEdit, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupMeanAndStdDeviationCutPtPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mFirstStdDevCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSecondStdDevCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mThirdStdDevCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupApplyDescPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(uRL));
        JTextArea jTextArea = new JTextArea();
        jTextArea.setRows(2);
        jTextArea.setFont(this.mLastCutPtLocLabel.getFont());
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setText(this.getResString("IDS_APPLY_DESC"));
        jTextArea.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 2, 0, 1, 1, n, null);
        return jPanel;
    }

    private boolean showDialog(String string) {
        int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
        return n == 0;
    }

    private void showInfoDialog(String string) {
        SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
    }

    private void calculateUniformCutPoints() {
        String string = this.mCutPtLocationEdit.getText();
        String string2 = this.mNoOfCutPtsInEWEdit.getText();
        String string3 = this.mWidthInEWEdit.getText();
        double d = Double.parseDouble(string3) * ((VisualBanderDlg)this.mParentDlg).calculatedWidthForFormatType();
        ((VisualBanderDlg)this.mParentDlg).createUniformCutPts(this.mFirstLoc, Integer.parseInt(string2), d);
    }

    private void calculateMeanSdCutPts() {
        boolean[] blArray = new boolean[]{false, false, false};
        if (this.mFirstStdDevCheck.isSelected()) {
            blArray[0] = true;
        }
        if (this.mSecondStdDevCheck.isSelected()) {
            blArray[1] = true;
        }
        if (this.mThirdStdDevCheck.isSelected()) {
            blArray[2] = true;
        }
        ((VisualBanderDlg)this.mParentDlg).createMeanSdCutPts(blArray);
    }

    private void calculateLastCutPoints() {
        String string = "";
        String string2 = "";
        String string3 = "";
        string = this.mCutPtLocationEdit.getText();
        string2 = this.mNoOfCutPtsInEWEdit.getText();
        string3 = this.mWidthInEWEdit.getText();
        int n = string.indexOf("E");
        if (n >= 0) {
            this.mLastCutPtEdit.setText(string);
        } else if (string.length() > 0 && string2.length() > 0 && string3.length() > 0) {
            double d = this.mFirstLoc + (double)(Integer.parseInt(string2) - 1) * (string3.equals(".") ? 0.0 : Double.parseDouble(string3) * ((VisualBanderDlg)this.mParentDlg).calculatedWidthForFormatType());
            OBS oBS = new OBS();
            oBS.setNum(d);
            SPSS_Format sPSS_Format = this.var.getSpssVar().getFormat();
            String string4 = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)this.var.getSpssVar().getFormat());
            this.mLastCutPtEdit.setText(string4);
        }
        this.enableContinue(this.canEnableContinue());
    }

    private boolean canEnableContinue() {
        String string;
        String string2;
        if (this.mEqualWidthRadio.isSelected()) {
            string2 = this.mCutPtLocationEdit.getText();
            string = this.mNoOfCutPtsInEWEdit.getText();
            String string3 = this.mWidthInEWEdit.getText();
            if (string2.length() > 0 && string.length() > 0 && string3.length() > 0) {
                int n = Integer.parseInt(string);
                double d = Double.parseDouble(string3);
                if (n > 0 && d > 0.0) {
                    return true;
                }
            }
        }
        if (this.mCutPtAtMeanRadio.isSelected()) {
            return true;
        }
        if (this.mEqualPercentileRadio.isSelected()) {
            string2 = this.mNoOfCutPtsInEPEdit.getText();
            string = this.mWidthInEPEdit.getText();
            if (string2.length() > 0 && string.length() > 0) {
                int n = Integer.parseInt(string2);
                double d = Double.parseDouble(string);
                if (n > 0 && d > 0.0 && d <= 50.0) {
                    return true;
                }
            }
        }
        return false;
    }

    private void calculateRemainingField() {
        double d;
        double d2;
        String string = this.mCutPtLocationEdit.getText();
        String string2 = this.mNoOfCutPtsInEWEdit.getText();
        String string3 = this.mWidthInEWEdit.getText();
        VisualBanderDlg.ScannedVarListVar scannedVarListVar = ((VisualBanderDlg)this.mParentDlg).getCurrentVar();
        double d3 = scannedVarListVar.getMinVal();
        double d4 = scannedVarListVar.getMaxVal();
        if (string.length() <= 0 && string2.length() > 0 && string3.length() > 0) {
            string = String.format(ComponentState.getSPSSLocale(), "%.2f", d3);
            OBS oBS = new OBS();
            oBS.setNum(d3);
            this.mFirstLoc = d3;
            String string4 = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)scannedVarListVar.getSpssVar().getFormat());
            this.mUniformAutoUpdated = true;
            this.mCutPtLocationEdit.setText(string4);
            this.mUniformAutoUpdated = false;
        }
        if (string.length() > 0 && string2.length() <= 0 && string3.length() > 0) {
            double d5 = d4 - this.mFirstLoc;
            d2 = Double.parseDouble(string3) * ((VisualBanderDlg)this.mParentDlg).calculatedWidthForFormatType();
            double d6 = 0.0;
            if (d5 > 0.0) {
                if (d2 != 0.0) {
                    d6 = d5 / d2;
                }
                if (d6 != Math.ceil(d6)) {
                    d6 += 1.0;
                }
                if (d6 > 500.0 && d2 != 0.0) {
                    this.mUniformAutoUpdated = true;
                    this.showInfoDialog(this.getResString("ERR_VB_WIDTH_TOO_SMALL"));
                    this.mCutPtLocationEdit.setText("");
                    this.mNoOfCutPtsInEWEdit.setText("");
                    this.mWidthInEWEdit.setText("");
                    this.mWidthInEWEdit.requestFocus();
                    this.mUniformAutoUpdated = false;
                } else {
                    string2 = String.format("%d", (int)d6);
                    this.mUniformAutoUpdated = true;
                    if (d2 == 0.0) {
                        this.mNoOfCutPtsInEWEdit.setText("");
                    } else {
                        this.mNoOfCutPtsInEWEdit.setText(string2);
                    }
                    this.mUniformAutoUpdated = false;
                }
            }
        }
        if (string.length() > 0 && string2.length() > 0 && string3.length() <= 0 && (d = d4 - this.mFirstLoc) > 0.0) {
            d2 = d / Double.parseDouble(string2) / ((VisualBanderDlg)this.mParentDlg).calculatedWidthForFormatType();
            String string5 = "";
            string5 = String.format("%%.%df", Math.max(3, 2));
            string3 = String.format(string5, d2);
            this.mUniformAutoUpdated = true;
            this.mWidthInEWEdit.setText(string3);
            this.mUniformAutoUpdated = false;
        }
    }
}

