/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.visual_bander;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.ui.dialogs.base.transform.visual_bander.CutPoint;
import com.spss.java_client.ui.dialogs.base.transform.visual_bander.Plane;
import com.spss.java_client.ui.dialogs.base.transform.visual_bander.VisualBanderDlg;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.JPanel;

class VisualBanderHistogram
extends JPanel {
    boolean mMouseDragged = false;
    boolean mMouseReleased = false;
    boolean mMarkAxis = false;
    boolean mPlotData = false;
    boolean mPlotCutPoints = false;
    public static JPanel mThisRef;
    Double x;
    int x1;
    int y1;
    int x2;
    int y2;
    Cursor mCurrentCursor;
    CutPoint mOldCp;
    public static Plane mXYPlane;

    public VisualBanderHistogram() {
        mThisRef = this;
        this.addMouseListener(new MyMouseListener());
        this.addMouseMotionListener(new MyMouseMotionListener());
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        mXYPlane.plotAxis(graphics2D);
        if (this.mMarkAxis) {
            mXYPlane.markXaxis(graphics2D);
        }
        if (this.mPlotData) {
            mXYPlane.plot(graphics2D);
        }
        if (this.mPlotCutPoints) {
            int n;
            VisualBanderDlg.ScannedVarListVar scannedVarListVar = mXYPlane.getScannedVar();
            if (scannedVarListVar == null || scannedVarListVar.getCutPts().size() <= 1) {
                return;
            }
            Vector<CutPoint> vector = scannedVarListVar.getCutPts();
            if (this.mOldCp != null && !mXYPlane.cutPointExist(this.mOldCp.getOBS().getNum())) {
                mXYPlane.removeCutPoint(graphics2D, this.mOldCp, this.getBackground());
            } else {
                for (n = 0; n < vector.size() - 2; ++n) {
                    if (!vector.get(n).isSelected()) continue;
                    this.mOldCp = new CutPoint(vector.get(n).getOBS());
                    break;
                }
            }
            for (n = 0; n < vector.size() - 2; ++n) {
                if (!vector.get(n).isSelected()) continue;
                this.mOldCp.setOBS(vector.get(n).getOBS());
                break;
            }
            CutPoint cutPoint = this.getSelectedCutPoint();
            if (this.x != null && cutPoint != null) {
                cutPoint.setOBS(new OBS(mXYPlane.mBinWidthelToUnits(this.x)));
            }
            for (int i = 0; i < vector.size() - 2; ++i) {
                cutPoint = vector.get(i);
                mXYPlane.plotCutPoint(graphics2D, cutPoint);
            }
        }
        graphics2D.setColor(Color.black);
        if (this.mCurrentCursor != null) {
            this.setCursor(this.mCurrentCursor);
        }
    }

    private void testForOverlappingCutPoints(CutPoint cutPoint) {
        if (mXYPlane.cutPointOverlapped(this.x)) {
            SpssAlertOptionPane.showWarningMessageDialog(this, VisualBanderHistogram.mXYPlane.mCPOverlapedMessage, VersionInfo.getAppVersionString());
            mXYPlane.removeCutPoint(cutPoint);
            mThisRef.repaint();
            mXYPlane.displayCutPoints();
            this.x = null;
        }
    }

    private CutPoint getSelectedCutPoint() {
        CutPoint cutPoint = null;
        VisualBanderDlg.ScannedVarListVar scannedVarListVar = mXYPlane.getScannedVar();
        if (scannedVarListVar != null) {
            Vector<CutPoint> vector = scannedVarListVar.getCutPts();
            for (int i = 0; i < vector.size() - 2; ++i) {
                CutPoint cutPoint2 = vector.get(i);
                if (!cutPoint2.isSelected()) continue;
                cutPoint = cutPoint2;
                break;
            }
        }
        return cutPoint;
    }

    public Plane getXyPlane() {
        return mXYPlane;
    }

    public void setXyPlane(Plane plane) {
        mXYPlane = plane;
    }

    public void setMarkAxis(boolean bl) {
        this.mMarkAxis = bl;
    }

    public void setPlotCutPoints(boolean bl) {
        this.mPlotCutPoints = bl;
    }

    public void setPlotData(boolean bl) {
        this.mPlotData = bl;
    }

    public void setScannedVariable(VisualBanderDlg.ScannedVarListVar scannedVarListVar) {
        mXYPlane.setScannedVariable(scannedVarListVar);
    }

    public void setMaximumHt(double d) {
        mXYPlane.setMaxY(d);
    }

    static {
        mXYPlane = new Plane(530.0, 130.0);
    }

    class MyMouseMotionListener
    extends MouseMotionAdapter {
        MyMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            VisualBanderHistogram.this.mMouseReleased = false;
            VisualBanderDlg.ScannedVarListVar scannedVarListVar = mXYPlane.getScannedVar();
            if (scannedVarListVar == null) {
                return;
            }
            VisualBanderHistogram.this.mMouseDragged = true;
            VisualBanderHistogram.this.x = mouseEvent.getX();
            VisualBanderHistogram.this.x1 = mouseEvent.getX();
            VisualBanderHistogram.this.x2 = mouseEvent.getX();
            VisualBanderHistogram.this.y1 = mouseEvent.getY();
            VisualBanderHistogram.this.y2 = mouseEvent.getY();
            mThisRef.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            VisualBanderDlg.ScannedVarListVar scannedVarListVar = mXYPlane.getScannedVar();
            if (scannedVarListVar == null) {
                return;
            }
            Vector<CutPoint> vector = scannedVarListVar.getCutPts();
            for (int i = 0; i < vector.size() - 2; ++i) {
                if (!vector.get(i).isMouseOn(mouseEvent.getX(), mouseEvent.getY(), mXYPlane)) continue;
                VisualBanderHistogram.this.mCurrentCursor = Cursor.getPredefinedCursor(12);
                mThisRef.repaint();
                return;
            }
            VisualBanderHistogram.this.mCurrentCursor = Cursor.getDefaultCursor();
            mThisRef.repaint();
        }
    }

    class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            VisualBanderDlg.ScannedVarListVar scannedVarListVar = mXYPlane.getScannedVar();
            if (scannedVarListVar == null) {
                return;
            }
            Vector<CutPoint> vector = scannedVarListVar.getCutPts();
            for (int i = 0; i < vector.size() - 2; ++i) {
                if (!vector.get(i).isMouseOn(mouseEvent.getX(), mouseEvent.getY(), mXYPlane)) continue;
                mXYPlane.setSelectedCutPoint(i);
                VisualBanderHistogram.this.x1 = mouseEvent.getX();
                VisualBanderHistogram.this.y1 = mouseEvent.getY();
                return;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Cloneable cloneable;
            VisualBanderDlg.ScannedVarListVar scannedVarListVar = mXYPlane.getScannedVar();
            if (scannedVarListVar == null) {
                return;
            }
            VisualBanderHistogram.this.mMouseReleased = true;
            if (VisualBanderHistogram.this.mMouseDragged) {
                cloneable = scannedVarListVar.getCutPts();
                for (int i = 0; i < ((Vector)cloneable).size() - 2; ++i) {
                    CutPoint cutPoint = (CutPoint)((Vector)cloneable).get(i);
                    if (!cutPoint.isSelected() || !cutPoint.isMouseOn(mouseEvent.getX(), mouseEvent.getY(), mXYPlane)) continue;
                    VisualBanderHistogram.this.x = ((CutPoint)((Vector)cloneable).get(i)).getOBS().getNum();
                    VisualBanderHistogram.this.x = mXYPlane.xUnitsToPixel(VisualBanderHistogram.this.x);
                    VisualBanderHistogram.this.x2 = mouseEvent.getX();
                    VisualBanderHistogram.this.y2 = mouseEvent.getY();
                    VisualBanderHistogram.this.x = VisualBanderHistogram.this.x + (double)VisualBanderHistogram.this.x2 - (double)VisualBanderHistogram.this.x1;
                }
                VisualBanderHistogram.this.mMouseDragged = false;
            }
            if ((cloneable = VisualBanderHistogram.this.getSelectedCutPoint()) != null && ((CutPoint)cloneable).getOBS().getNum() > scannedVarListVar.getEndPos() || ((CutPoint)cloneable).getOBS().getNum() < scannedVarListVar.getStartPos()) {
                mXYPlane.removeCutPoint((CutPoint)cloneable);
            }
            VisualBanderHistogram.this.testForOverlappingCutPoints((CutPoint)cloneable);
            VisualBanderHistogram.this.x = null;
            mXYPlane.displayCutPoints();
            mThisRef.repaint();
        }
    }
}

