/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.visual_bander;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.CoreFrequencies;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.core.server.messages.sysfilemsg.ObsVecMap;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.FocusHighlighter;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.transform.res.TransformResBundle;
import com.spss.java_client.ui.dialogs.base.transform.visual_bander.CutPoint;
import com.spss.java_client.ui.dialogs.base.transform.visual_bander.Plane;
import com.spss.java_client.ui.dialogs.base.transform.visual_bander.VisualBanderCopyVariables;
import com.spss.java_client.ui.dialogs.base.transform.visual_bander.VisualBanderHistogram;
import com.spss.java_client.ui.dialogs.base.transform.visual_bander.VisualBanderMakeCutpoints;
import com.spss.java_client.ui.dialogs.base.transform.visual_bander.VisualBanderProcDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.text.DefaultCaret;

public class VisualBanderDlg
extends BaseProcedureDialog
implements ListSelectionListener,
MouseListener,
FocusListener,
ItemListener,
KeyListener,
PropertyChangeListener {
    public static final int LOWER_END_POINT_START_OFFSET = 100;
    private static final int MAX_LABEL = 120;
    private static final String FROM_ANOTHER_VAR_BUTTON = "IDS_VB_FROM_ANOTHER_VAR_BUTTON";
    private static final String TO_ANOTHER_VAR_BUTTON = "IDS_VB_TO_OTHER_VAR_BUTTON";
    private static final String EXCLUDED_RADIO = "IDS_VB_ENDPOINTS_EXCLUDED";
    private static final String INCLUDED_RADIO = "IDS_VB_ENDPOINTS_INCLUDED";
    private static final String MAKE_CUTPOINT_BUTTON = "IDS_VB_MAKE_CUTPOINTS_BUTTON";
    private static final String MAKE_LABEL_BUTTON = "IDS_VB_MAKE_LABELS_BUTTON";
    private static final String REVERSE_SCALE_CHECK = "IDS_VB_REVERSE_SCALE_CHECK";
    private JButton mFromAnotherVar;
    private JButton mToOtherVar;
    private IntTextField mCasesScannedEdit;
    private IntTextField mMissingValEdit;
    private StringTextField mCurrVarNameEdit;
    private StringTextField mCurrVarLabelEdit;
    private StringTextField mBandedVarNameEdit;
    private StringTextField mBandedVarLabelEdit;
    private JTextField mMinValEdit;
    private JTextField mMaxValEdit;
    private PlainTable mCutPtable;
    private JButton mMakeCutPtButton;
    private JButton mMakeLblButton;
    private JCheckBox mRevScaleCheck;
    private JRadioButton mIncludedRadio;
    private JRadioButton mExcludedRadio;
    private TitledBorder mEndPtPanelBorder;
    private VisualBanderHistogram mHistogramPanel;
    private ScannedVarListVar mScannedVar;
    private int mMaxCutPts;
    private SpssButtonGroup mRadioGroup;
    private JPopupMenu mPopupMenu;
    private JMenuItem mCutItem;
    private JMenuItem mCopyItem;
    private JMenuItem mPasteItem;
    private JMenuItem mClearItem;
    private JMenuItem mDeleteRow;
    private JMenuItem mDeleteLbls;
    private JMenuItem mDeleteCutpts;
    private boolean mShowLabels;
    private boolean mReplaceCanceled = false;
    private boolean mAreCPLabeled;
    private Vector<CutPoint> mOriginalCutPts;
    private Plane mPlane;
    private SrcVariableList mScannedVarList;
    private HashMap<SpssVariable, ScannedVarListVar> mVarMap;
    private long mCasesScanned;
    private int mPressedColumn = -1;
    private boolean mSyntaxSuppressed = false;

    public VisualBanderDlg(JFrame jFrame, CoreFrequencies coreFrequencies) {
        super(jFrame, true, TransformResBundle.getDefaultResourceBundleName(), TransformResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_VISUAL_BANDER_TITLE"));
        this.getFreqTable(coreFrequencies);
        if (this.mScannedVarList.getModel().getSize() > 0) {
            this.mScannedVarList.setSelectedIndex(0);
        }
        this.setDefaultCloseOperation(0);
    }

    @Override
    public String generateSyntax() {
        if (this.mSyntaxSuppressed) {
            return "";
        }
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("* ");
        stringBuffer.append(this.getResString("IDS_VISUAL_BANDER_SYNTAX_TITLE"));
        stringBuffer.append(".");
        VarListModel varListModel = this.mScannedVarList.getModel();
        stringBuffer.append("\n");
        for (int i = 0; i < varListModel.getSize(); ++i) {
            SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(i);
            ScannedVarListVar scannedVarListVar = this.mVarMap.get(spssVariable);
            String string = scannedVarListVar.getBandedVarName();
            if (string.equals("") || scannedVarListVar.getCutPts() == null || scannedVarListVar.getCutPts().size() <= 2) continue;
            stringBuffer.append(SyntaxUtil.getMainCommand("*"));
            stringBuffer.append(scannedVarListVar.getSpssVar().getName());
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            MissingSpec missingSpec = new MissingSpec(scannedVarListVar);
            stringBuffer.append(SyntaxUtil.getMainCommand("RECODE "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(scannedVarListVar.getSpssVar().getName()));
            if (!missingSpec.haveRemapping()) {
                stringBuffer.append(" (MISSING=COPY)");
            }
            if (scannedVarListVar.isEndptIncluded()) {
                stringBuffer.append(this.generateRECODEcmdforIncluded(scannedVarListVar, scannedVarListVar.isReversedScale()));
            } else {
                stringBuffer.append(this.generateRECODEcmdforExcluded(scannedVarListVar, scannedVarListVar.isReversedScale()));
            }
            stringBuffer.append(" (ELSE=SYSMIS) INTO ");
            stringBuffer.append(string);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(missingSpec.generateTransformSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LABELS "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
            if (!scannedVarListVar.getBandedVarLabel().equals("")) {
                stringBuffer.append(" ");
                stringBuffer.append(CharacterUtil.smartQuote((String)scannedVarListVar.getBandedVarLabel()));
            }
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("FORMATS "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string + " (F5.0)"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("VALUE LABELS "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string + this.getValueLabelList(scannedVarListVar, scannedVarListVar.isReversedScale()) + missingSpec.getLabelsForMissingValues()));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(missingSpec.generateMissingValuesSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LEVEL "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string + " (ORDINAL)"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (SyntaxUtil.readTransformationMergePrefs()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("EXECUTE"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    public String generateRECODEcmdforIncluded(ScannedVarListVar scannedVarListVar, boolean bl) {
        String string = "";
        Vector<CutPoint> vector = scannedVarListVar.getCutPts();
        int n = vector.size();
        for (int i = 0; i < n - 1; ++i) {
            String string2;
            CutPoint cutPoint = vector.get(i);
            if (!cutPoint.getOBS().isString()) {
                string2 = bl ? String.format("%d", n - 1 - i) : String.format("%d", i + 1);
                double d = cutPoint.getOBS().getNum();
                string = string + " (LO THRU ";
                string = string + this.getFormattedStringValue(d) + "=";
                string = string + string2 + ")";
                continue;
            }
            string2 = bl ? String.format("%d", n - 1 - i) : String.format("%d", i + 1);
            string = string + " (LO";
            string = string + " THRU HI=";
            string2 = string2 + ")";
            string = string + string2;
        }
        return string;
    }

    public String generateRECODEcmdforExcluded(ScannedVarListVar scannedVarListVar, boolean bl) {
        CutPoint cutPoint;
        String string = "HI";
        String string2 = "";
        Vector<CutPoint> vector = scannedVarListVar.getCutPts();
        int n = vector.size();
        if (!(n <= 0 || (cutPoint = vector.get(n - 2)).getOBS().isString() && cutPoint.getOBS().getString().equals(this.getResString("IDS_VB_GRID_HIGH_VALUE")))) {
            cutPoint = vector.get(n - 1);
            double d = cutPoint.getOBS().getNum();
            string = this.getFormattedStringValue(d);
        }
        for (int i = n - 2; i > 0; --i) {
            CutPoint cutPoint2 = vector.get(i - 1);
            double d = cutPoint2.getOBS().getNum();
            String string3 = this.getFormattedStringValue(d);
            String string4 = bl ? String.format("%d", n - 1 - i) : String.format("%d", i + 1);
            string2 = string2 + " (";
            string2 = string2 + string3;
            string2 = string2 + " THRU " + string;
            string2 = string2 + "=" + string4;
            string2 = string2 + ")";
        }
        if (bl) {
            string2 = string2 + " (LO THRU ";
            string2 = string2 + string;
            string2 = string2 + "=";
            string2 = string2 + String.format("%d", n - 1);
            string2 = string2 + ")";
        } else {
            string2 = string2 + " (LO THRU ";
            string2 = string2 + string;
            string2 = string2 + "=1)";
        }
        return string2;
    }

    public String getValueLabelList(ScannedVarListVar scannedVarListVar, boolean bl) {
        String string = "";
        Vector<CutPoint> vector = scannedVarListVar.getCutPts();
        int n = vector.size();
        for (int i = 0; i < n - 1; ++i) {
            CutPoint cutPoint = vector.get(i);
            String string2 = bl ? String.format("%d", n - 1 - i) : String.format("%d", i + 1);
            string = string + " " + string2;
            string = string + " ";
            string = cutPoint.getLabel().length() > 0 ? string + CharacterUtil.smartQuote((String)cutPoint.getLabel()) : string + "''";
        }
        return string;
    }

    @Override
    public boolean okPastePressed() {
        String string;
        boolean bl;
        Object object;
        Object object2;
        if (this.mCutPtable.isEditing()) {
            this.mCutPtable.getCellEditor().stopCellEditing();
        }
        this.mSyntaxSuppressed = false;
        this.mReplaceCanceled = false;
        VarListModel varListModel = this.mScannedVarList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            object2 = (SpssVariable)varListModel.getElementAt(i);
            object = this.mVarMap.get(object2);
            bl = ((ScannedVarListVar)object).getBandedVarName().equals("");
            if (!bl && this.isVarNameWeightedOrFilterd(((ScannedVarListVar)object).getBandedVarName())) {
                this.showInfoDialog(this.getResString("ERR_VB_VARIABLE_WEIGHT_OR_FILTER"));
                this.mBandedVarNameEdit.setText("");
                ((ScannedVarListVar)object).setBandedVarName("");
                this.mBandedVarNameEdit.requestFocus();
                return false;
            }
            if (!bl && !((ScannedVarListVar)object).getSpssVar().getName().equals(((ScannedVarListVar)object).getBandedVarName()) && this.isVarNamePresentInScannedList((ScannedVarListVar)object)) break;
            if (bl || this.mReplaceCanceled || !this.isVarNamePresentInDataSet(((ScannedVarListVar)object).getBandedVarName())) continue;
            if (this.showDialog(this.getResString("ERR_VB_VARIABLE_EXIST"))) break;
            return false;
        }
        if (!((string = this.getBandedVarNames()).equals("") || this.mReplaceCanceled || this.showDialog((String)(object2 = String.format(ComponentState.getSPSSLocale(), this.getResString("ERR_VB_MISSING_NAME_OR_CUTPT"), string))))) {
            this.mBandedVarNameEdit.requestFocus();
            return false;
        }
        if (!this.mReplaceCanceled) {
            int n = this.getBandedVarCount();
            object = String.format(ComponentState.getSPSSLocale(), this.getResString("ERR_VB_VARIABLE_CREATED_COUNT"), n);
            bl = this.showDialog((String)object);
            this.mSyntaxSuppressed = bl && n == 0;
            return bl;
        }
        return false;
    }

    @Override
    public String getIActionKey() {
        return "transform_visual_binning";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bander_main";
    }

    public boolean createPercentileCutPts(int n, double d) {
        CutPoint cutPoint;
        Object object;
        double[] dArray = this.getDupliCutPtsCountInPtile(n, d);
        if (this.mMaxCutPts < n && !this.showDialog((String)(object = String.format(ComponentState.getSPSSLocale(), this.getResString("ERR_VB_LESS_CUTPOINTS_GENERATED"), this.mMaxCutPts)))) {
            return false;
        }
        object = new Vector<CutPoint>();
        for (int i = 0; i < this.mMaxCutPts; ++i) {
            cutPoint = new CutPoint();
            cutPoint.setOBS(new OBS(dArray[i]));
            ((Vector)object).add(cutPoint);
        }
        ((Vector)object).add(new CutPoint(new OBS(this.getResString("IDS_VB_GRID_HIGH_VALUE"))));
        ((Vector)object).add(new CutPoint(new OBS()));
        this.mScannedVar.setCutPts((Vector<CutPoint>)object);
        this.mOriginalCutPts = new Vector();
        try {
            Iterator iterator = ((Vector)object).iterator();
            while (iterator.hasNext()) {
                cutPoint = (CutPoint)iterator.next();
                this.mOriginalCutPts.add((CutPoint)cutPoint.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        this.createHistoData(this.mScannedVar, this.mScannedVar.getMinVal(), this.mScannedVar.getMaxVal());
        this.mCutPtable.setModel(new CutPointTableModel((Vector<CutPoint>)object));
        this.setColumnEditors();
        this.setDefaultSelectedCell();
        return true;
    }

    private void setDefaultSelectedCell() {
        if (this.mCutPtable.getRowCount() > 0) {
            this.mCutPtable.setRowSelectionInterval(0, 0);
            this.mCutPtable.setColumnSelectionInterval(1, 1);
        }
    }

    public double[] getDupliCutPtsCountInPtile(int n, double d) {
        double[] dArray = new double[n];
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            double d2 = d * (double)(i + 1);
            if (d2 > 100.0) {
                d2 = 100.0;
            }
            double d3 = this.getPercentile(this.mScannedVar.getValMap(), d2);
            for (int j = 0; j < i; ++j) {
                if (dArray[j] != d3) continue;
                bl = true;
                break;
            }
            if (!bl) {
                dArray[n2] = d3;
                ++n2;
            }
            bl = false;
        }
        this.mMaxCutPts = n2;
        return dArray;
    }

    public double calculatedWidthForFormatType() {
        double d = 1.0;
        SPSS_Format sPSS_Format = this.mScannedVar.getSpssVar().getFormat();
        switch (sPSS_Format.getFormatType()) {
            case DATE: 
            case ADATE: 
            case EDATE: 
            case JDATE: 
            case SDATE: {
                d = 86400.0;
                break;
            }
            case QYR: {
                d = 8035200.0;
                break;
            }
            case MOYR: {
                d = 2678400.0;
                break;
            }
            case WKYR: {
                d = 604800.0;
                break;
            }
            case WKDAY: {
                d = 86400.0;
                break;
            }
            case MONTH: {
                d = 2678400.0;
                break;
            }
            case TIME: {
                if (sPSS_Format.getWidth() > 5) {
                    d = 1.0;
                    break;
                }
                d = 60.0;
                break;
            }
            case DTIME: {
                if (sPSS_Format.getWidth() > 9) {
                    d = 1.0;
                    break;
                }
                d = 60.0;
                break;
            }
            case DATETIME: {
                if (sPSS_Format.getWidth() >= 20) {
                    d = 1.0;
                    break;
                }
                d = 60.0;
                break;
            }
        }
        return d;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getSource() == this.mScannedVarList.getSelectionModel() && this.mScannedVarList.getSelectedIndex() != -1) {
            String string;
            if (this.mScannedVar != null) {
                string = this.mBandedVarNameEdit.getText();
                if (!string.equals("")) {
                    VarNameValidator.ValidNameCode validNameCode = VarNameValidator.validateSPSSName((String)string, (boolean)true);
                    if (validNameCode != VarNameValidator.ValidNameCode.SPSSNAME_STANDARD) {
                        this.mScannedVarList.setSelectedValue(this.mScannedVar.getSpssVar(), true);
                        return;
                    }
                    this.mScannedVar.setBandedVarName(string);
                } else {
                    this.mScannedVar.setBandedVarName(string);
                }
            }
            string = (SpssVariable)this.mScannedVarList.getSelectedValue();
            this.mScannedVar = this.mVarMap.get(string);
            this.mCurrVarNameEdit.setText(this.mScannedVar.getSpssVar().getName());
            this.mCurrVarLabelEdit.setText(this.mScannedVar.getSpssVar().getLabel());
            this.mCurrVarNameEdit.setCaretPosition(0);
            this.mCurrVarLabelEdit.setCaretPosition(0);
            this.mMissingValEdit.setText(Long.toString(this.mScannedVar.getMissingVals()));
            this.mBandedVarNameEdit.setOpaque(true);
            this.mBandedVarNameEdit.setEnabled(true);
            this.mBandedVarNameEdit.setEditable(true);
            this.mBandedVarLabelEdit.setEnabled(true);
            this.mBandedVarLabelEdit.setOpaque(true);
            this.mBandedVarLabelEdit.setEditable(true);
            if (this.mScannedVar.getValMap() != null && this.mScannedVar.getValMap().size() > 0) {
                this.mMinValEdit.setText(CellValueFormatter.obsToString((OBS)new OBS(this.mScannedVar.getMinVal()), (SPSS_Format)this.mScannedVar.getSpssVar().getFormat()));
                this.mMaxValEdit.setText(CellValueFormatter.obsToString((OBS)new OBS(this.mScannedVar.getMaxVal()), (SPSS_Format)this.mScannedVar.getSpssVar().getFormat()));
            }
            this.mBandedVarNameEdit.setText(this.mScannedVar.getBandedVarName());
            this.mBandedVarLabelEdit.setText(this.mScannedVar.getBandedVarLabel());
            this.mBandedVarNameEdit.setCaretPosition(0);
            this.mBandedVarLabelEdit.setCaretPosition(0);
            this.mMakeCutPtButton.setEnabled(this.mScannedVar.canDrawHistogram());
            this.mMakeLblButton.setEnabled(true);
            this.mEndPtPanelBorder.setTitleColor(Color.black);
            this.repaint();
            this.mIncludedRadio.setEnabled(true);
            this.mExcludedRadio.setEnabled(true);
            if (this.mScannedVar.isEndptIncluded()) {
                this.mIncludedRadio.setSelected(true);
            } else {
                this.mExcludedRadio.setSelected(true);
            }
            this.mRevScaleCheck.setEnabled(true);
            this.mRevScaleCheck.setSelected(this.mScannedVar.isReversedScale());
            this.mCutPtable.setEnabled(true);
            this.mCutPtable.setModel(new CutPointTableModel(this.mScannedVar.getCutPts()));
            this.setColumnEditors();
            this.setDefaultSelectedCell();
            this.mPlane.setPlaneAttributes(this.mScannedVar.getMaxVal(), this.mScannedVar.getMaximumValue(), this.mHistogramPanel.getWidth(), this.mHistogramPanel.getHeight(), this.mScannedVar.getNoOfBins());
            this.mHistogramPanel.setScannedVariable(this.mScannedVar);
            this.mHistogramPanel.setMarkAxis(this.mScannedVar.canDrawHistogram());
            this.mHistogramPanel.setPlotCutPoints(this.mScannedVar.canDrawHistogram());
            this.mHistogramPanel.setPlotData(true);
            this.mHistogramPanel.repaint();
            this.enableCopyButtons();
            this.mCutPtable.addNotify();
            this.enableOkPaste(true);
            this.enableReset(this.canEnableReset());
            this.setColumnEditors();
            if (this.allValuesMissing()) {
                this.mScannedVarList.remove(this.mScannedVarList.getSelectedIndex());
            }
            if (this.mCasesScannedEdit.getText().equals("")) {
                this.mCasesScannedEdit.setText("" + this.mCasesScanned);
            }
        }
        if (listSelectionEvent.getSource() == this.mCutPtable.getSelectionModel()) {
            int n = this.mCutPtable.getSelectedRow();
            if (this.mCutPtable.getRowCount() > 2 && n != -1 && n < this.mCutPtable.getRowCount() - 2) {
                this.mPlane.setSelectedCutPoint(n);
                this.mHistogramPanel.repaint();
            }
        }
    }

    public void showInfoDialog(String string) {
        SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
    }

    public void showMessage(String string) {
        SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
    }

    public ScannedVarListVar getCurrentVar() {
        SpssVariable spssVariable = (SpssVariable)this.mScannedVarList.getSelectedValue();
        return this.mVarMap.get(spssVariable);
    }

    public void enableCopyButtons() {
        VarListModel varListModel = this.mScannedVarList.getModel();
        if (varListModel.getSize() > 1) {
            for (int i = 0; i < varListModel.getSize(); ++i) {
                SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(i);
                ScannedVarListVar scannedVarListVar = this.mVarMap.get(spssVariable);
                if (scannedVarListVar.getSpssVar().getName().equals(this.mScannedVar.getSpssVar().getName())) continue;
                if (scannedVarListVar.getCutPts() != null && scannedVarListVar.getCutPts().size() > 2) {
                    this.mFromAnotherVar.setEnabled(true);
                    break;
                }
                this.mFromAnotherVar.setEnabled(false);
            }
            if (this.mScannedVar.getCutPts() != null && this.mScannedVar.getCutPts().size() > 2) {
                this.mToOtherVar.setEnabled(true);
            } else {
                this.mToOtherVar.setEnabled(false);
            }
        }
    }

    public double getOffset(FormatType formatType, int n, int n2, double d, ScannedVarListVar scannedVarListVar) {
        double d2;
        switch (formatType) {
            case DATE: 
            case ADATE: 
            case EDATE: 
            case JDATE: 
            case SDATE: {
                d2 = 86400.0;
                break;
            }
            case TIME: {
                if (n2 > 0) {
                    d2 = Math.pow(10.0, -1 * n2);
                    break;
                }
                if (n >= 8 && n < 11) {
                    d2 = 1.0;
                    break;
                }
                d2 = 60.0;
                break;
            }
            case DATETIME: {
                if (n2 > 0) {
                    d2 = Math.pow(10.0, -1 * n2);
                    break;
                }
                if (n >= 20 && n < 23) {
                    d2 = 1.0;
                    break;
                }
                d2 = 60.0;
                break;
            }
            case DTIME: {
                if (n2 > 0) {
                    d2 = Math.pow(10.0, -1 * n2);
                    break;
                }
                if (n >= 12 && n < 15) {
                    d2 = 1.0;
                    break;
                }
                d2 = 60.0;
                break;
            }
            case MOYR: {
                d2 = 2678400.0;
                break;
            }
            case QYR: {
                d2 = 93.0;
                d2 *= 86400.0;
                break;
            }
            case WKYR: {
                d2 = 604800.0;
                break;
            }
            case WKDAY: 
            case MONTH: {
                d2 = 1.0;
                break;
            }
            default: {
                d2 = d == Math.ceil(d) && this.areAllDataValuesInt(scannedVarListVar) ? 1.0 : Math.pow(10.0, -1 * n2);
            }
        }
        return d2;
    }

    public boolean areAllDataValuesInt(ScannedVarListVar scannedVarListVar) {
        for (Map.Entry<OBS, Double> entry : scannedVarListVar.getValMap().entrySet()) {
            double d = entry.getKey().getNum();
            if (d == Math.ceil(d)) continue;
            return false;
        }
        return true;
    }

    public void createUniformCutPts(double d, int n, double d2) {
        Object object;
        Vector<CutPoint> vector = new Vector<CutPoint>();
        for (int i = 0; i < n; ++i) {
            object = new CutPoint();
            double d3 = d + (double)i * d2;
            ((CutPoint)object).setOBS(new OBS(d3));
            vector.add((CutPoint)object);
        }
        vector.add(new CutPoint(new OBS(this.getResString("IDS_VB_GRID_HIGH_VALUE"))));
        vector.add(new CutPoint(new OBS()));
        SpssVariable spssVariable = (SpssVariable)this.mScannedVarList.getSelectedValue();
        object = this.mVarMap.get(spssVariable);
        ((ScannedVarListVar)object).setCutPts(vector);
        this.mOriginalCutPts = new Vector();
        try {
            for (CutPoint cutPoint : vector) {
                this.mOriginalCutPts.add((CutPoint)cutPoint.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        this.createHistoData(this.mScannedVar, this.mScannedVar.getMinVal(), this.mScannedVar.getMaxVal());
        this.mCutPtable.setModel(new CutPointTableModel(vector));
        this.setColumnEditors();
        this.setDefaultSelectedCell();
    }

    public void createMeanSdCutPts(boolean[] blArray) {
        SpssVariable spssVariable = (SpssVariable)this.mScannedVarList.getSelectedValue();
        ScannedVarListVar scannedVarListVar = this.mVarMap.get(spssVariable);
        double[] dArray = this.getMeanAndStdDev(scannedVarListVar.getValMap());
        Vector<CutPoint> vector = new Vector<CutPoint>();
        try {
            Object object;
            for (int i = 0; i < 3; ++i) {
                if (!blArray[i]) continue;
                object = new OBS();
                object.setNum(dArray[0] + dArray[1] * (double)(i + 1));
                OBS oBS = new OBS();
                oBS.setNum(dArray[0] - dArray[1] * (double)(i + 1));
                CutPoint cutPoint = new CutPoint();
                cutPoint.setOBS(new OBS(object.getNum()));
                int n = this.getIndexInCPArray(vector, cutPoint);
                vector.add(n, cutPoint);
                CutPoint cutPoint2 = new CutPoint();
                cutPoint2.setOBS(new OBS(oBS.getNum()));
                vector.add(cutPoint2);
            }
            OBS oBS = new OBS();
            oBS.setNum(dArray[0]);
            object = new CutPoint();
            ((CutPoint)object).setOBS(new OBS(oBS.getNum()));
            vector.add((CutPoint)object);
            this.mOriginalCutPts = new Vector();
            for (CutPoint cutPoint : vector) {
                this.mOriginalCutPts.add((CutPoint)cutPoint.clone());
            }
            Collections.sort(this.mOriginalCutPts, new ObsSorter());
            vector.add(new CutPoint(new OBS(this.getResString("IDS_VB_GRID_HIGH_VALUE"))));
            vector.add(new CutPoint(new OBS()));
            this.mOriginalCutPts.add(new CutPoint(new OBS(this.getResString("IDS_VB_GRID_HIGH_VALUE"))));
            this.mOriginalCutPts.add(new CutPoint(new OBS()));
            scannedVarListVar.setCutPts(vector);
            this.createHistoData(this.mScannedVar, this.mScannedVar.getMinVal(), this.mScannedVar.getMaxVal());
            this.mCutPtable.setModel(new CutPointTableModel(vector));
            this.setColumnEditors();
            this.setDefaultSelectedCell();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DefaultListModel getCopyToListModel() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        VarListModel varListModel = this.mScannedVarList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(i);
            ScannedVarListVar scannedVarListVar = this.mVarMap.get(spssVariable);
            if (scannedVarListVar == this.mScannedVar) continue;
            if (this.mShowLabels) {
                defaultListModel.addElement(scannedVarListVar.getSpssVar().getLabel() + " [" + scannedVarListVar.getSpssVar().getName() + "]");
                continue;
            }
            defaultListModel.addElement(scannedVarListVar.getSpssVar().getName());
        }
        return defaultListModel;
    }

    public DefaultListModel getCopyFromListModel() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        VarListModel varListModel = this.mScannedVarList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(i);
            ScannedVarListVar scannedVarListVar = this.mVarMap.get(spssVariable);
            if (scannedVarListVar == this.mScannedVar || scannedVarListVar.getCutPts() == null || scannedVarListVar.getCutPts().size() <= 2) continue;
            if (this.mShowLabels) {
                defaultListModel.addElement(scannedVarListVar.getSpssVar().getLabel() + " [" + scannedVarListVar.getSpssVar().getName() + "]");
                continue;
            }
            defaultListModel.addElement(scannedVarListVar.getSpssVar().getName());
        }
        return defaultListModel;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.mCutPtable) {
            this.mPressedColumn = -1;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.doPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.doPopup(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void updateCutPoints(Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            VarListModel varListModel = this.mScannedVarList.getModel();
            for (Object object : objectArray) {
                for (int i = 0; i < varListModel.getSize(); ++i) {
                    Vector<CutPoint> vector;
                    String string;
                    SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(i);
                    ScannedVarListVar scannedVarListVar = this.mVarMap.get(spssVariable);
                    String string2 = string = this.mShowLabels ? scannedVarListVar.getSpssVar().getLabel() + " [" + scannedVarListVar.getSpssVar().getName() + "]" : scannedVarListVar.getSpssVar().getName();
                    if (!string.equals(object.toString())) continue;
                    Vector<CutPoint> vector2 = new Vector<CutPoint>();
                    if (bl) {
                        vector = this.mScannedVar.getCutPts();
                        try {
                            for (CutPoint cutPoint : vector) {
                                vector2.add((CutPoint)cutPoint.clone());
                            }
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            cloneNotSupportedException.printStackTrace();
                        }
                        scannedVarListVar.setCutPts(vector2);
                        scannedVarListVar.setEndptIncluded(this.mScannedVar.isEndptIncluded());
                        if (scannedVarListVar.isEndptIncluded()) {
                            this.mIncludedRadio.setSelected(true);
                        } else {
                            this.mExcludedRadio.setSelected(true);
                        }
                        scannedVarListVar.setReversedScale(this.mScannedVar.isReversedScale());
                        this.mRevScaleCheck.setSelected(scannedVarListVar.isReversedScale());
                        break;
                    }
                    vector = scannedVarListVar.getCutPts();
                    try {
                        for (CutPoint cutPoint : vector) {
                            vector2.add((CutPoint)cutPoint.clone());
                        }
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        cloneNotSupportedException.printStackTrace();
                    }
                    this.mScannedVar.setCutPts(vector2);
                    this.mScannedVar.setEndptIncluded(scannedVarListVar.isEndptIncluded());
                    if (this.mScannedVar.isEndptIncluded()) {
                        this.mIncludedRadio.setSelected(true);
                    } else {
                        this.mExcludedRadio.setSelected(true);
                    }
                    this.mScannedVar.setReversedScale(scannedVarListVar.isReversedScale());
                    this.mRevScaleCheck.setSelected(this.mScannedVar.isReversedScale());
                    this.mCutPtable.setModel(new CutPointTableModel(this.mScannedVar.getCutPts()));
                    this.setColumnEditors();
                    this.setDefaultSelectedCell();
                    break;
                }
                if (!bl) break;
            }
        }
    }

    public boolean isBandedVarNameDuplicated(String string) {
        VarListModel varListModel = this.mScannedVarList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(i);
            ScannedVarListVar scannedVarListVar = this.mVarMap.get(spssVariable);
            if (scannedVarListVar.getSpssVar().getName().equals(this.mScannedVar.getSpssVar().getName()) || !scannedVarListVar.getBandedVarName().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mCutPtable) {
            int n = this.mCutPtable.getSelectionModel().getAnchorSelectionIndex();
            int n2 = this.mCutPtable.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            int n3 = this.mCutPtable.getSelectionModel().getLeadSelectionIndex();
            int n4 = this.mCutPtable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (n > -1 && n2 > 0 && n3 > -1 && n4 > 0) {
                this.mCutPtable.setRowSelectionInterval(n, n3);
                this.mCutPtable.setColumnSelectionInterval(n2, n4);
            } else if (this.mCutPtable.getRowCount() > 0 && this.mCutPtable.getColumnCount() > 1) {
                this.setDefaultSelectedCell();
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mBandedVarNameEdit && this.mScannedVar != null) {
            if (!this.mBandedVarNameEdit.getText().equals("")) {
                this.validateBandedVarName(this.mBandedVarNameEdit.getText());
            } else {
                this.mScannedVar.setBandedVarName("");
            }
        }
        if (focusEvent.getSource() == this.mBandedVarLabelEdit && this.mScannedVar != null) {
            this.mScannedVar.setBandedVarLabel(this.mBandedVarLabelEdit.getText());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mRevScaleCheck && this.mScannedVar != null) {
            this.mScannedVar.setReversedScale(this.mRevScaleCheck.isSelected());
        }
        if (itemEvent.getSource() == this.mIncludedRadio && this.mScannedVar != null) {
            this.mScannedVar.setEndptIncluded(this.mIncludedRadio.isSelected());
            if (this.areCutPtsLabeled(this.mScannedVar) && this.mAreCPLabeled) {
                this.mAreCPLabeled = false;
                this.showInfoDialog(this.getResString("ERR_VB_AUTO_LABEL_NO_LONGER_CORRECT"));
            }
        }
        if (itemEvent.getSource() == this.mExcludedRadio && this.mScannedVar != null) {
            this.mScannedVar.setEndptIncluded(!this.mExcludedRadio.isSelected());
            if (this.areCutPtsLabeled(this.mScannedVar) && this.mAreCPLabeled) {
                this.mAreCPLabeled = false;
                this.showInfoDialog(this.getResString("ERR_VB_AUTO_LABEL_NO_LONGER_CORRECT"));
            }
        }
    }

    public boolean areCutPtsLabeled(ScannedVarListVar scannedVarListVar) {
        Vector<CutPoint> vector = scannedVarListVar.getCutPts();
        if (vector != null) {
            for (CutPoint cutPoint : vector) {
                if (cutPoint.getLabel().equals("")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127) {
            int n = this.mCutPtable.getSelectedRow();
            Vector<CutPoint> vector = this.mScannedVar.getCutPts();
            if (n != -1 && n < vector.size() - 2) {
                if (this.mAreCPLabeled) {
                    this.mAreCPLabeled = false;
                    this.showInfoDialog(this.getResString("ERR_VB_AUTO_LABEL_NO_LONGER_CORRECT"));
                }
                if (this.mCutPtable.getSelectedColumn() == 2) {
                    vector.get(n).setLabel("");
                } else {
                    vector.remove(n);
                }
                this.mCutPtable.setModel(new CutPointTableModel(vector));
                this.setColumnEditors();
                this.setDefaultSelectedCell();
                this.enableReset(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VisualBanderDlg.this.mCutPtable.grabFocus();
                    }
                });
            }
        } else if (keyEvent.getKeyCode() == 65 && keyEvent.isControlDown()) {
            this.mCutPtable.selectAll();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void reset() {
        if (this.showDialog(this.getResString("ERR_VB_DISCARD_ALL_CHANGES"))) {
            super.reset();
            this.setDefaults();
            this.mCutPtable.setModel(new CutPointTableModel());
            this.setColumnEditors();
            this.setDefaultSelectedCell();
            this.mHistogramPanel.setScannedVariable(null);
            this.mHistogramPanel.setPlotData(false);
            this.mHistogramPanel.setPlotCutPoints(false);
            this.mHistogramPanel.setMarkAxis(false);
            this.mHistogramPanel.repaint();
            this.mScannedVarList.clearSelection();
            this.enableOkPaste(false);
            VarListModel varListModel = this.mScannedVarList.getModel();
            for (int i = 0; i < varListModel.getSize(); ++i) {
                SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(i);
                ScannedVarListVar scannedVarListVar = this.mVarMap.get(spssVariable);
                scannedVarListVar.setDefaultVarProperties();
                this.createHistoData(scannedVarListVar, scannedVarListVar.getMinVal(), scannedVarListVar.getMaxVal());
            }
        }
    }

    public boolean canEnableReset() {
        VarListModel varListModel = this.mScannedVarList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(i);
            ScannedVarListVar scannedVarListVar = this.mVarMap.get(spssVariable);
            if (scannedVarListVar.getCutPts() == null || scannedVarListVar.getCutPts().size() <= 2) continue;
            return true;
        }
        return false;
    }

    protected boolean canDispose() {
        if (this.mCutPtable.isEditing()) {
            return false;
        }
        if (this.canEnableReset()) {
            return SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_VB_DISCARD_CHANGES"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION) == 1;
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, this.setupScannedVarListPanel(), gridBagConstraints, 0, 0, 1, 3, n, null);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.setupCasesScannednCopyBandsPanel(), gridBagConstraints, 0, 3, 1, 1, n, null);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupVarNameLabelPanel(), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupMinMaxValPanel(), gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.setupGridDescPanel(), gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupGridnCutPointsPanel(), gridBagConstraints, 1, 3, 1, 1, n, insets);
        this.pack();
        this.mHistogramPanel.setMinimumSize(new Dimension(this.mHistogramPanel.getWidth(), this.mHistogramPanel.getHeight()));
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (VisualBanderDlg.this.canDispose()) {
                    VisualBanderDlg.this.dispose();
                }
            }
        });
        this.mHistogramPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (VisualBanderDlg.this.mScannedVar == null) {
                    return;
                }
                VisualBanderDlg.this.mPlane.setPlaneAttributes(VisualBanderDlg.this.mScannedVar.getMaxVal(), VisualBanderDlg.this.mScannedVar.getMaximumValue(), VisualBanderDlg.this.mHistogramPanel.getWidth(), VisualBanderDlg.this.mHistogramPanel.getHeight(), VisualBanderDlg.this.mScannedVar.getNoOfBins());
                VisualBanderDlg.this.mHistogramPanel.setScannedVariable(VisualBanderDlg.this.mScannedVar);
                VisualBanderDlg.this.mHistogramPanel.setMarkAxis(VisualBanderDlg.this.mScannedVar.canDrawHistogram());
                VisualBanderDlg.this.mHistogramPanel.setPlotCutPoints(VisualBanderDlg.this.mScannedVar.canDrawHistogram());
                VisualBanderDlg.this.mHistogramPanel.setPlotData(true);
                VisualBanderDlg.this.mHistogramPanel.repaint();
            }
        });
    }

    @Override
    protected void loadDialogState() {
        Point point;
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize(this.getIActionKey());
        if (dimension != null) {
            this.setSize(dimension);
        }
        if ((point = ProcedureDlgMgr.getMgr().getDialogLocation(this.getIActionKey())) != null) {
            this.setLocation(point);
        } else if (this.getParent() != null) {
            this.setLocationRelativeTo(this.getParent());
        }
        this.setVisible(true);
    }

    @Override
    protected void saveDialogState() {
        ProcedureDlgMgr.getMgr().saveDialogSize(this.getIActionKey(), this.getSize());
        ProcedureDlgMgr.getMgr().saveDialogLocation(this.getIActionKey(), this.getLocation());
    }

    private void initVars() {
        FocusListener[] focusListenerArray;
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, FROM_ANOTHER_VAR_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VisualBanderDlg.this.runCopyFromSubDialog();
            }
        };
        this.mFromAnotherVar = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, TO_ANOTHER_VAR_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VisualBanderDlg.this.runCopyToSubDialog();
            }
        };
        this.mToOtherVar = new JButton(toggleButtonAction);
        this.mVarMap = new HashMap();
        VarListModel varListModel = VisualBanderProcDlg.getTargetListModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            SpssVariable object = (SpssVariable)varListModel.getElementAt(i);
            this.mVarMap.put(object, new ScannedVarListVar(object));
        }
        this.mScannedVarList = new SrcVariableList(varListModel);
        this.mScannedVarList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mShowLabels = VisualBanderProcDlg.canShowLabel();
        this.mCasesScannedEdit = new IntTextField(true);
        this.mCasesScannedEdit.setEditable(false);
        this.mCasesScannedEdit.setOpaque(false);
        this.mMissingValEdit = new IntTextField(true);
        this.mMissingValEdit.setEditable(false);
        this.mMissingValEdit.setOpaque(false);
        this.mCurrVarNameEdit = new StringTextField();
        this.mCurrVarLabelEdit = new StringTextField();
        this.mBandedVarNameEdit = new StringTextField();
        for (FocusListener focusListener : focusListenerArray = this.mBandedVarNameEdit.getFocusListeners()) {
            if (!(focusListener instanceof StringTextField)) continue;
            this.mBandedVarNameEdit.removeFocusListener(focusListener);
        }
        this.mBandedVarNameEdit.addFocusListener(this);
        this.mBandedVarNameEdit.setDocument(new FixedLengthDocument(64));
        this.mBandedVarLabelEdit = new StringTextField();
        this.mBandedVarLabelEdit.addFocusListener(this);
        this.mBandedVarLabelEdit.setDocument(new FixedLengthDocument(255));
        this.mMinValEdit = new JTextField();
        this.mMaxValEdit = new JTextField();
        this.mCutPtable = new PlainTable(new CutPointTableModel()){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                if (bl && eventObject instanceof KeyEvent && this.editorComp instanceof JTextField) {
                    ((JTextField)this.editorComp).setText("");
                }
                return bl;
            }

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string;
                String string2 = null;
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                int n3 = this.convertColumnIndexToModel(n2);
                if (n3 == 2 && (string = (String)this.getModel().getValueAt(n, n2)).length() > 15) {
                    string2 = string;
                }
                return string2;
            }
        };
        this.mCutPtable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    VisualBanderDlg.this.clearSelectedCells();
                }
            }
        });
        this.setDefaultSelectedCell();
        this.mCutPtable.addFocusListener(this);
        this.mCutPtable.getTableHeader().setReorderingAllowed(false);
        this.mCutPtable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    VisualBanderDlg.this.doPopup(mouseEvent);
                    return;
                }
                if (VisualBanderDlg.this.mCutPtable.isEditing()) {
                    VisualBanderDlg.this.mCutPtable.getCellEditor().stopCellEditing();
                }
                VisualBanderDlg.this.mPressedColumn = ((JTableHeader)mouseEvent.getSource()).getTable().columnAtPoint(mouseEvent.getPoint());
                int n = VisualBanderDlg.this.mCutPtable.getRowCount();
                if (n > 1) {
                    VisualBanderDlg.this.mCutPtable.setRowSelectionInterval(0, n - 2);
                } else if (n > 0) {
                    VisualBanderDlg.this.mCutPtable.setRowSelectionInterval(0, n - 1);
                }
                VisualBanderDlg.this.mCutPtable.setColumnSelectionInterval(VisualBanderDlg.this.mPressedColumn, VisualBanderDlg.this.mPressedColumn);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                VisualBanderDlg.this.mPressedColumn = ((JTableHeader)mouseEvent.getSource()).getTable().columnAtPoint(mouseEvent.getPoint());
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ((JTableHeader)actionEvent.getSource()).getTable().getRowCount();
                if (n == 2 || n == 0) {
                    return;
                }
                if (VisualBanderDlg.this.mPressedColumn == 1) {
                    if (0 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)VisualBanderDlg.this), VisualBanderDlg.this.getResString("ERR_VB_CLEAR_VALUE_LABELS_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                        VisualBanderDlg.this.mCutPtable.setModel(new CutPointTableModel(null));
                        VisualBanderDlg.this.setColumnEditors();
                        VisualBanderDlg.this.setDefaultSelectedCell();
                    }
                } else if (VisualBanderDlg.this.mPressedColumn == 2 && 0 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)VisualBanderDlg.this), VisualBanderDlg.this.getResString("ERR_VB_CLEAR_LABELS_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                    ((CutPointTableModel)VisualBanderDlg.this.mCutPtable.getModel()).clearLabels();
                }
            }
        };
        this.mCutPtable.getTableHeader().registerKeyboardAction(actionListener, "Delete Popup", KeyStroke.getKeyStroke(127, 0), 2);
        this.mCutPtable.setDefaultRenderer(Object.class, new CutPointTableRenderer());
        this.mCutPtable.addMouseListener(this);
        this.mCutPtable.setCellSelectionEnabled(true);
        this.mCutPtable.addKeyListener(this);
        this.mCutPtable.setFocusCycleRoot(false);
        this.mCutPtable.setSurrendersFocusOnKeystroke(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableColumn tableColumn = VisualBanderDlg.this.mCutPtable.getColumnModel().getColumn(0);
                FontMetrics fontMetrics = VisualBanderDlg.this.mCutPtable.getFontMetrics(VisualBanderDlg.this.mCutPtable.getFont());
                int n = fontMetrics.stringWidth("66666666");
                tableColumn.setMinWidth(n);
                tableColumn.setPreferredWidth(n);
                tableColumn.setMaxWidth(n);
            }
        });
        ListSelectionModel listSelectionModel = this.mCutPtable.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.setColumnEditors();
        this.makeTabActions();
        this.makeClipboardActions();
        this.makeButtonActions();
        toggleButtonAction = new ToggleButtonAction(this, REVERSE_SCALE_CHECK);
        this.mRevScaleCheck = new JCheckBox(toggleButtonAction);
        this.mRevScaleCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, INCLUDED_RADIO);
        this.mIncludedRadio = new JRadioButton(toggleButtonAction);
        this.mIncludedRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, EXCLUDED_RADIO);
        this.mExcludedRadio = new JRadioButton(toggleButtonAction);
        this.mExcludedRadio.addItemListener(this);
        this.mRadioGroup = new SpssButtonGroup();
        this.mRadioGroup.add(this.mIncludedRadio);
        this.mRadioGroup.add(this.mExcludedRadio);
        this.mEndPtPanelBorder = BorderFactory.createTitledBorder(this.getResString("IDS_VB_UPPER_ENDPOINTS"));
        PopupMenuListener popupMenuListener = new PopupMenuListener();
        this.mPopupMenu = new JPopupMenu();
        this.mCutItem = new JMenuItem(ResUtil.getString("edit_cut"));
        this.mCopyItem = new JMenuItem(ResUtil.getString("edit_copy"));
        this.mPasteItem = new JMenuItem(ResUtil.getString("edit_paste"));
        this.mClearItem = new JMenuItem(ResUtil.getString("edit_clear"));
        this.mDeleteRow = new JMenuItem(this.getResString("IDS_VB_DELETE_ROW_MENUITEM"));
        this.mDeleteLbls = new JMenuItem(this.getResString("IDS_VB_DELETE_LABELS_MENUITEM"));
        this.mDeleteCutpts = new JMenuItem(this.getResString("IDS_VB_DELETE_CUTPOINTS_MENUITEM"));
        this.mCutItem.addActionListener(popupMenuListener);
        this.mCopyItem.addActionListener(popupMenuListener);
        this.mPasteItem.addActionListener(popupMenuListener);
        this.mClearItem.addActionListener(popupMenuListener);
        this.mDeleteRow.addActionListener(popupMenuListener);
        this.mDeleteLbls.addActionListener(popupMenuListener);
        this.mDeleteCutpts.addActionListener(popupMenuListener);
        this.mPopupMenu.add(this.mCutItem);
        this.mPopupMenu.add(this.mCopyItem);
        this.mPopupMenu.add(this.mPasteItem);
        this.mPopupMenu.add(this.mClearItem);
        this.mPopupMenu.addSeparator();
        this.mPopupMenu.add(this.mDeleteRow);
        this.mPopupMenu.add(this.mDeleteLbls);
        this.mPopupMenu.add(this.mDeleteCutpts);
    }

    private void makeButtonActions() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, MAKE_CUTPOINT_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VisualBanderDlg.this.runCutPointSubDialog();
            }
        };
        this.mMakeCutPtButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MAKE_LABEL_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VisualBanderDlg.this.makeLabel();
            }
        };
        this.mMakeLblButton = new JButton(toggleButtonAction);
    }

    private void makeTabActions() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mCutPtable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mCutPtable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mCutPtable.getActionMap().put("tabIn", abstractAction2);
        this.mCutPtable.getActionMap().put("tabOut", abstractAction);
    }

    private void makeClipboardActions() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Clipboard clipboard = VisualBanderDlg.this.mCutPtable.getToolkit().getSystemClipboard();
                TransferHandler transferHandler = VisualBanderDlg.this.mCutPtable.getTransferHandler();
                if (transferHandler != null && clipboard != null) {
                    transferHandler.exportToClipboard(VisualBanderDlg.this.mCutPtable, clipboard, 1);
                    VisualBanderDlg.this.clearSelectedCells();
                }
            }
        };
        this.mCutPtable.getInputMap(0).put(KeyStroke.getKeyStroke(88, 128), "cut");
        this.mCutPtable.getActionMap().put("cut", abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Transferable transferable;
                Clipboard clipboard = VisualBanderDlg.this.mCutPtable.getToolkit().getSystemClipboard();
                if (clipboard != null && (transferable = clipboard.getContents(null)) != null && clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                    try {
                        String string = transferable.getTransferData(DataFlavor.stringFlavor).toString();
                        VisualBanderDlg.this.pasteData(string);
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        unsupportedFlavorException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        };
        this.mCutPtable.getInputMap(0).put(KeyStroke.getKeyStroke(86, 128), "paste");
        this.mCutPtable.getActionMap().put("paste", abstractAction2);
    }

    private void pasteData(String string) {
        String[] stringArray;
        int n = this.mCutPtable.getSelectedRow();
        int n2 = this.mCutPtable.getSelectedColumn();
        this.mCutPtable.clearSelection();
        int n3 = n;
        int n4 = n2;
        for (String string2 : stringArray = string.split("\n")) {
            String[] stringArray2;
            for (String string3 : stringArray2 = string2.split("\t")) {
                if (n3 < this.mCutPtable.getRowCount() && n4 < this.mCutPtable.getColumnCount()) {
                    this.mCutPtable.setValueAt(string3, n3, n4);
                }
                this.mCutPtable.getColumnModel().getSelectionModel().addSelectionInterval(n4, n4);
                ++n4;
            }
            this.mCutPtable.getSelectionModel().addSelectionInterval(n3, n3);
            n4 = n2;
            ++n3;
        }
    }

    private void clearSelectedCells() {
        int[] nArray = this.mCutPtable.getSelectedRows();
        int[] nArray2 = this.mCutPtable.getSelectedColumns();
        for (int n : nArray) {
            for (int n2 : nArray2) {
                this.mCutPtable.setValueAt("", n, n2);
            }
        }
        this.mCutPtable.clearSelection();
        this.mCutPtable.getSelectionModel().setSelectionInterval(nArray[0], nArray[nArray.length - 1]);
        this.mCutPtable.getColumnModel().getSelectionModel().setSelectionInterval(nArray2[0], nArray2[nArray2.length - 1]);
    }

    @Override
    protected boolean cancelPressed() {
        if (this.canEnableReset()) {
            return SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_VB_DISCARD_CHANGES"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION) == 1;
        }
        return true;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mScannedVarList);
        vector.add(this.mBandedVarNameEdit);
        vector.add(this.mBandedVarLabelEdit);
        vector.add(this.mHistogramPanel);
        vector.add(this.mCutPtable);
        vector.add(this.mRadioGroup);
        vector.add(this.mMakeCutPtButton);
        vector.add(this.mMakeLblButton);
        vector.add(this.mRevScaleCheck);
        vector.add(this.mFromAnotherVar);
        vector.add(this.mToOtherVar);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private int computeNumOfBin(long l) {
        int n = (int)(3.0 + Math.log10(l) * (Math.log(l) / Math.log(2.0)));
        if (n < 3) {
            n = 3;
        } else if (n > 40) {
            n = 40;
        }
        return n;
    }

    private void getFreqTable(CoreFrequencies coreFrequencies) {
        int n = coreFrequencies.getVarMapCount();
        VarListModel varListModel = this.mScannedVarList.getModel();
        this.mCasesScanned = coreFrequencies.casesPassed();
        for (int i = 0; i < n; ++i) {
            ObsVecMap obsVecMap = coreFrequencies.getVariableMap(i);
            short s = (Short)obsVecMap.getKeySpec().get(0);
            TreeMap treeMap = obsVecMap.getObsMap();
            SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(i);
            ScannedVarListVar scannedVarListVar = this.mVarMap.get(spssVariable);
            long l = this.getNonMissingCount(treeMap, scannedVarListVar);
            int n2 = scannedVarListVar.getValMap().size();
            if (n2 <= 0) continue;
            double d = s > 0 ? Double.parseDouble(scannedVarListVar.getValMap().firstKey().getString()) : scannedVarListVar.getValMap().firstKey().getNum();
            double d2 = s > 0 ? Double.parseDouble(scannedVarListVar.getValMap().lastKey().getString()) : scannedVarListVar.getValMap().lastKey().getNum();
            scannedVarListVar.setNoOfBins(this.computeNumOfBin(l));
            this.createHistoData(scannedVarListVar, d, d2);
        }
    }

    private int getBandedVarCount() {
        int n = 0;
        VarListModel varListModel = this.mScannedVarList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(i);
            ScannedVarListVar scannedVarListVar = this.mVarMap.get(spssVariable);
            if (scannedVarListVar.getBandedVarName().equals("") || scannedVarListVar.getCutPts() == null || scannedVarListVar.getCutPts().size() <= 2) continue;
            ++n;
        }
        return n;
    }

    private String getBandedVarNames() {
        String string = "";
        VarListModel varListModel = this.mScannedVarList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(i);
            ScannedVarListVar scannedVarListVar = this.mVarMap.get(spssVariable);
            if ((!scannedVarListVar.getBandedVarName().equals("") || scannedVarListVar.getCutPts() == null || scannedVarListVar.getCutPts().size() <= 2) && (scannedVarListVar.getBandedVarName().equals("") || scannedVarListVar.getCutPts() != null && scannedVarListVar.getCutPts().size() != 2)) continue;
            string = string + scannedVarListVar.getSpssVar().getName() + " ";
        }
        if ((string = string.trim()).contains(" ")) {
            string = string.replace(" ", ", ");
        }
        return string;
    }

    private boolean isVarNamePresentInScannedList(ScannedVarListVar scannedVarListVar) {
        boolean bl = false;
        ScannedVarListVar scannedVarListVar2 = null;
        VarListModel varListModel = this.mScannedVarList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            SpssVariable spssVariable = (SpssVariable)varListModel.getElementAt(i);
            ScannedVarListVar scannedVarListVar3 = this.mVarMap.get(spssVariable);
            if (!scannedVarListVar3.getSpssVar().getName().equals(scannedVarListVar.getBandedVarName())) continue;
            scannedVarListVar2 = scannedVarListVar3;
            bl = true;
        }
        if (bl) {
            if (this.showDialog(this.getResString("ERR_VB_VARIABLE_IN_SCAN_LIST"))) {
                VarListModel varListModel2 = this.mScannedVarList.getModel();
                varListModel2.removeElement((ISpssVariable)scannedVarListVar2.getSpssVar());
                this.mScannedVarList.addNotify();
                this.mVarMap.remove(scannedVarListVar2.getSpssVar());
            } else {
                this.mBandedVarNameEdit.setText("");
                scannedVarListVar.setBandedVarName("");
                this.mReplaceCanceled = true;
            }
        }
        return bl;
    }

    private boolean isVarNamePresentInDataSet(String string) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.findVarIndex(string);
        return n != -1;
    }

    private boolean isVarNameWeightedOrFilterd(String string) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.findVarIndex(string);
        return n != -1 && (iSpssDataSrc.getFilterVarIndex() == n || iSpssDataSrc.getWeightVarIndex() == n);
    }

    private double getPercentile(TreeMap<OBS, Double> treeMap, double d) {
        int n;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        double d2 = iSpssDataSrc.getSystemMissing();
        double d3 = 0.0;
        for (Map.Entry<OBS, Double> entry : treeMap.entrySet()) {
            d3 += entry.getValue().doubleValue();
        }
        int n2 = n = treeMap.size();
        LinkedList<OBS> linkedList = new LinkedList<OBS>();
        linkedList.addAll(treeMap.keySet());
        Iterator<OBS> iterator = treeMap.keySet().iterator();
        if (n > 0 && !(d < 0.0) && !(d > 100.0)) {
            if (n == 1) {
                d2 = iterator.next().getNum();
            } else if (this.isZeroDiff(d, 0.0, 1.0)) {
                d2 = iterator.next().getNum();
            } else if (this.isZeroDiff(d, 100.0, 1.0)) {
                d2 = ((OBS)linkedList.get(--n2)).getNum();
            } else {
                double d4 = d / 100.0;
                d4 *= d3;
                double d5 = d3;
                double d6 = 0.0;
                OBS[] oBSArray = new OBS[n];
                linkedList.toArray(oBSArray);
                while (d4 < d5 && n2 > 0 && !this.isZeroDiff(d4, d5, d6)) {
                    d5 -= treeMap.get(oBSArray[--n2]).doubleValue();
                    d6 += 1.0;
                }
                d2 = n2 == treeMap.size() ? iterator.next().getNum() : (n2 == 0 ? ((OBS)linkedList.get(n2)).getNum() : (this.isZeroDiff(d4, d5, d6) ? (((OBS)linkedList.get(--n2)).getNum() + ((OBS)linkedList.get(n2 + 1)).getNum()) / 2.0 : ((OBS)linkedList.get(--n2 + 1)).getNum()));
            }
        }
        return d2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isZeroDiff(double d, double d2, double d3) {
        double d4 = Math.abs(d - d2);
        if (d4 == 0.0) return true;
        if (d == 0.0) return false;
        if (d2 == 0.0) return false;
        double d5 = Math.abs(d) < Math.abs(d2) ? Math.abs(d2) : Math.abs(d);
        if (!(d4 <= d5 * (Math.ulp(1.0) * d3))) return false;
        return true;
    }

    private long getNonMissingCount(TreeMap<OBS, Double> treeMap, ScannedVarListVar scannedVarListVar) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = 0;
        long l = 0L;
        TreeMap<OBS, Double> treeMap2 = new TreeMap<OBS, Double>();
        for (Map.Entry<OBS, Double> entry : treeMap.entrySet()) {
            boolean bl;
            OBS oBS = entry.getKey();
            double d = entry.getValue();
            boolean bl2 = scannedVarListVar.getSpssVar().isMissing(oBS);
            boolean bl3 = bl = oBS.getNum() == iSpssDataSrc.getSystemMissing();
            if (bl2 || bl) {
                n += (int)d;
                continue;
            }
            l = (long)((double)l + d);
            treeMap2.put(oBS, d);
        }
        scannedVarListVar.setValMap(treeMap2);
        scannedVarListVar.setMissingVals(n);
        return l;
    }

    private void createHistoData(ScannedVarListVar scannedVarListVar, double d, double d2) {
        int n = scannedVarListVar.getNoOfBins();
        SPSS_Format sPSS_Format = scannedVarListVar.getSpssVar().getFormat();
        double d3 = (d2 - d) / (double)(n - 1);
        if (0.0 == d3) {
            d3 = this.getOffset(sPSS_Format.getFormatType(), sPSS_Format.getWidth(), sPSS_Format.getDecimals(), scannedVarListVar.getMinVal(), scannedVarListVar);
        }
        scannedVarListVar.setInterval(d3);
        scannedVarListVar.setStartPos(d - d3);
        scannedVarListVar.setEndPos(d2 + d3);
        double d4 = scannedVarListVar.getStartPos();
        this.computeFreqForEachBin(scannedVarListVar, d4, n, d3);
    }

    private void computeFreqForEachBin(ScannedVarListVar scannedVarListVar, double d, int n, double d2) {
        int n2;
        double d3;
        double[] dArray;
        double[] dArray2;
        try {
            dArray2 = new double[n + 1];
            dArray = new double[n + 1];
            for (int i = 0; i <= n; ++i) {
                dArray2[i] = d + d2 * (double)(i + 1);
                dArray[i] = 0.0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        for (Map.Entry<OBS, Double> object : scannedVarListVar.getValMap().entrySet()) {
            d3 = scannedVarListVar.getSpssVar().getType() > 0 ? Double.parseDouble(object.getKey().getString()) : object.getKey().getNum();
            double d4 = object.getValue();
            for (n2 = 0; n2 < n; ++n2) {
                if (!(d3 >= dArray2[n2]) || !(d3 < dArray2[n2 + 1])) continue;
                int n3 = n2 + 1;
                dArray[n3] = dArray[n3] + d4;
            }
        }
        Vector vector = new Vector(n + 1);
        d3 = 0.0;
        OBS oBS = new OBS();
        SPSS_Format sPSS_Format = scannedVarListVar.getSpssVar().getFormat();
        sPSS_Format.setDecimals((byte)2);
        for (n2 = 0; n2 <= n; ++n2) {
            oBS.setNum(dArray2[n2]);
            HistoBin histoBin = new HistoBin();
            String string = this.formatOBS(oBS, sPSS_Format);
            histoBin.setLabel(string);
            histoBin.setBinBoundry(dArray2[n2]);
            histoBin.setBinCount(dArray[n2]);
            vector.add(n2, histoBin);
            d3 = d3 < dArray[n2] ? dArray[n2] : d3;
        }
        scannedVarListVar.setHistoBin(vector);
        scannedVarListVar.setMaximumValue(d3);
    }

    private void recalculateHistOnAddCutPt(double d) {
        boolean bl = false;
        SpssVariable spssVariable = (SpssVariable)this.mScannedVarList.getSelectedValue();
        ScannedVarListVar scannedVarListVar = this.mVarMap.get(spssVariable);
        double d2 = scannedVarListVar.getStartPos();
        double d3 = scannedVarListVar.getEndPos();
        if (d < d2) {
            d2 = d;
            bl = true;
        }
        if (d > d3) {
            d3 = d;
            bl = true;
        }
        if (bl) {
            this.createHistoData(scannedVarListVar, d2, d3);
            this.mHistogramPanel.setMaximumHt(this.mScannedVar.getMaximumValue());
            this.mHistogramPanel.setPlotData(true);
            this.mHistogramPanel.setMarkAxis(true);
            this.mHistogramPanel.repaint();
        }
    }

    private void recalculateHistOnDelCutPt() {
        boolean bl = false;
        SpssVariable spssVariable = (SpssVariable)this.mScannedVarList.getSelectedValue();
        ScannedVarListVar scannedVarListVar = this.mVarMap.get(spssVariable);
        double d = scannedVarListVar.getMinVal();
        double d2 = scannedVarListVar.getMaxVal();
        double d3 = scannedVarListVar.getInterval();
        int n = this.mOriginalCutPts.size();
        Vector<CutPoint> vector = scannedVarListVar.getCutPts();
        if (!vector.get(0).equals(this.mOriginalCutPts.get(0))) {
            if (this.mOriginalCutPts.get(0).getOBS().getNum() < d - d3) {
                bl = true;
            }
            if (n > 1 && this.mOriginalCutPts.get(1).getOBS().getNum() < d - d3) {
                d = this.mOriginalCutPts.get(1).getOBS().getNum();
                bl = true;
            }
        } else if (!vector.get(vector.size() - 3).equals(this.mOriginalCutPts.get(n - 3)) && this.mOriginalCutPts.get(n - 3).getOBS().getNum() > scannedVarListVar.getEndPos()) {
            if (this.mOriginalCutPts.get(n - 3).getOBS().getNum() > d2 + d3) {
                bl = true;
            }
        } else {
            bl = false;
        }
        if (bl) {
            this.createHistoData(scannedVarListVar, d, d2);
            this.mHistogramPanel.setMaximumHt(this.mScannedVar.getMaximumValue());
            this.mHistogramPanel.setPlotData(true);
            this.mHistogramPanel.setMarkAxis(true);
            this.mHistogramPanel.repaint();
        }
        if (vector.size() == 2) {
            this.createHistoData(scannedVarListVar, scannedVarListVar.getMinVal(), scannedVarListVar.getMaxVal());
        }
        this.mOriginalCutPts = new Vector();
        try {
            for (CutPoint cutPoint : scannedVarListVar.getCutPts()) {
                this.mOriginalCutPts.add((CutPoint)cutPoint.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    private void runCopyFromSubDialog() {
        this.runSubDialog(new VisualBanderCopyVariables((BaseProcedureDialog)this, this.getResString("IDS_VB_COPY_FROM_TITLE"), this.getResString("IDS_VB_COPY_FROM_DESC"), this.getCopyFromListModel(), false));
    }

    private void runCopyToSubDialog() {
        this.runSubDialog(new VisualBanderCopyVariables((BaseProcedureDialog)this, this.getResString("IDS_VB_COPY_TO_TITLE"), this.getResString("IDS_VB_COPY_TO_DESC"), this.getCopyToListModel(), true));
    }

    private void makeLabel() {
        this.mAreCPLabeled = true;
        int n = 0;
        boolean bl = this.mIncludedRadio.isSelected();
        String string = bl ? "<= " : "< ";
        Vector<CutPoint> vector = this.mScannedVar.getCutPts();
        for (int i = 0; i < vector.size(); ++i) {
            String string2;
            String string3;
            double d;
            String string4;
            CutPoint cutPoint = vector.get(i);
            if (i == 0) {
                if (cutPoint.getOBS().equals((Object)new OBS(this.getResString("IDS_VB_GRID_HIGH_VALUE")))) {
                    if (!cutPoint.getLabel().equals("")) {
                        ++n;
                        break;
                    }
                    cutPoint.setLabel(string + this.getResString("IDS_VB_GRID_HIGH_VALUE"));
                    break;
                }
                string4 = CellValueFormatter.obsToString((OBS)cutPoint.getOBS(), (SPSS_Format)this.mScannedVar.getSpssVar().getFormat());
                if (!cutPoint.getLabel().equals("")) {
                    ++n;
                    continue;
                }
                cutPoint.setLabel(string + string4);
                continue;
            }
            CutPoint cutPoint2 = vector.get(i - 1);
            SPSS_Format sPSS_Format = this.mScannedVar.getSpssVar().getFormat();
            if (cutPoint.getOBS().equals((Object)new OBS(this.getResString("IDS_VB_GRID_HIGH_VALUE")))) {
                if (i - 1 < 0) continue;
                if (bl) {
                    d = this.getOffset(sPSS_Format.getFormatType(), sPSS_Format.getWidth(), sPSS_Format.getDecimals(), cutPoint2.getOBS().getNum(), this.mScannedVar);
                    string4 = new OBS(cutPoint2.getOBS().getNum() + d);
                    String string5 = CellValueFormatter.obsToString((OBS)string4, (SPSS_Format)this.mScannedVar.getSpssVar().getFormat());
                    string5 = string5 + "+";
                    if (!cutPoint.getLabel().equals("")) {
                        ++n;
                        break;
                    }
                    cutPoint.setLabel(string5);
                    break;
                }
                string4 = CellValueFormatter.obsToString((OBS)cutPoint2.getOBS(), (SPSS_Format)this.mScannedVar.getSpssVar().getFormat());
                string4 = string4 + "+";
                if (!cutPoint.getLabel().equals("")) {
                    ++n;
                    break;
                }
                cutPoint.setLabel(string4);
                break;
            }
            if (bl) {
                d = this.getOffset(sPSS_Format.getFormatType(), sPSS_Format.getWidth(), sPSS_Format.getDecimals(), cutPoint2.getOBS().getNum(), this.mScannedVar);
                if (cutPoint2.getOBS().getNum() + d > cutPoint.getOBS().getNum()) {
                    d = Math.pow(10.0, -1 * sPSS_Format.getDecimals());
                }
                string4 = new OBS(cutPoint2.getOBS().getNum() + d);
                string3 = CellValueFormatter.obsToString((OBS)string4, (SPSS_Format)this.mScannedVar.getSpssVar().getFormat());
                string2 = CellValueFormatter.obsToString((OBS)cutPoint.getOBS(), (SPSS_Format)this.mScannedVar.getSpssVar().getFormat());
            } else {
                d = this.getOffset(sPSS_Format.getFormatType(), sPSS_Format.getWidth(), sPSS_Format.getDecimals(), cutPoint.getOBS().getNum(), this.mScannedVar);
                if (cutPoint2.getOBS().getNum() > cutPoint.getOBS().getNum() - d) {
                    d = Math.pow(10.0, -1 * sPSS_Format.getDecimals());
                }
                string3 = CellValueFormatter.obsToString((OBS)cutPoint2.getOBS(), (SPSS_Format)this.mScannedVar.getSpssVar().getFormat());
                string4 = new OBS(cutPoint.getOBS().getNum() - d);
                string2 = CellValueFormatter.obsToString((OBS)string4, (SPSS_Format)this.mScannedVar.getSpssVar().getFormat());
            }
            string4 = string3;
            string4 = string4 + " - ";
            string4 = string4 + string2;
            if (!cutPoint.getLabel().equals("")) {
                ++n;
                continue;
            }
            cutPoint.setLabel(string4);
        }
        this.mScannedVar.setCutPts(vector);
        if (n > 0) {
            String string6 = String.format(ComponentState.getSPSSLocale(), this.getResString("ERR_VB_M_OF_N_LABELS_CREATED"), vector.size() - 1 - n, vector.size() - 1);
            this.showInfoDialog(string6);
        }
        this.mCutPtable.setModel(new CutPointTableModel(vector));
        this.setColumnEditors();
        this.mCutPtable.addNotify();
        this.setDefaultSelectedCell();
    }

    private void setDefaults() {
        this.mCurrVarNameEdit.setOpaque(false);
        this.mCurrVarNameEdit.setEditable(false);
        this.mCurrVarLabelEdit.setOpaque(false);
        this.mCurrVarLabelEdit.setEditable(false);
        this.mBandedVarNameEdit.setOpaque(false);
        this.mBandedVarNameEdit.setEditable(false);
        this.mBandedVarNameEdit.setEnabled(false);
        this.mBandedVarLabelEdit.setOpaque(false);
        this.mBandedVarLabelEdit.setEditable(false);
        this.mBandedVarLabelEdit.setEnabled(false);
        this.mMinValEdit.setOpaque(false);
        this.mMinValEdit.setEditable(false);
        this.mMaxValEdit.setOpaque(false);
        this.mMaxValEdit.setEditable(false);
        this.mCasesScannedEdit.setText("");
        this.mMissingValEdit.setText("");
        this.mCurrVarNameEdit.setText("");
        this.mCurrVarLabelEdit.setText("");
        this.mBandedVarNameEdit.setText("");
        this.mBandedVarLabelEdit.setText("");
        this.mMinValEdit.setText("");
        this.mMaxValEdit.setText("");
        this.mMakeCutPtButton.setEnabled(false);
        this.mMakeLblButton.setEnabled(false);
        this.mRevScaleCheck.setEnabled(false);
        this.mFromAnotherVar.setEnabled(false);
        this.mToOtherVar.setEnabled(false);
        this.mIncludedRadio.setEnabled(false);
        this.mExcludedRadio.setEnabled(false);
        this.mEndPtPanelBorder.setTitleColor(Color.gray);
        this.repaint();
        this.mIncludedRadio.setSelected(true);
        this.enableReset(false);
        this.mCutPtable.setEnabled(false);
    }

    private JPanel setupScannedVarListPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_VB_SCANNED_VARLIST_LABEL");
        jLabel.setLabelFor(this.mScannedVarList);
        JScrollPane jScrollPane = new JScrollPane(this.mScannedVarList);
        this.mScannedVarList.setMinimumSize(new Dimension(150, 230));
        jScrollPane.setPreferredSize(this.mScannedVarList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.mScannedVarList.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.mScannedVarList.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 2, 1, n, null);
        return jPanel;
    }

    private JPanel setupCasesScannednCopyBandsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(this.getResString("IDS_VB_CASES_SCANNED"));
        JLabel jLabel2 = new JLabel(this.getResString("IDS_VB_MISSING_VALUES"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCasesScannedEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMissingValEdit, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupCopyBandsPanel(), gridBagConstraints, 0, 2, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel setupCopyBandsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_VB_COPY_BANDS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mFromAnotherVar, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mToOtherVar, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private JPanel setupVarNameLabelPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(this.getResString("IDS_VB_NAME"));
        JLabel jLabel2 = new JLabel(this.getResString("IDS_VB_LABEL"));
        JLabel jLabel3 = new JLabel(this.getResString("IDS_VB_CURRENT_VAR"));
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_VB_BANDED_VAR");
        jLabel4.setLabelFor((Component)((Object)this.mBandedVarNameEdit));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(3, 5, 3, 3);
        Insets insets2 = new Insets(3, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.mCurrVarNameEdit.setMinimumSize(new Dimension(150, 20));
        this.mCurrVarLabelEdit.setMinimumSize(new Dimension(280, 20));
        this.mCurrVarNameEdit.setPreferredSize(new Dimension(150, 20));
        this.mCurrVarLabelEdit.setPreferredSize(new Dimension(280, 20));
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mCurrVarNameEdit), gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mCurrVarLabelEdit), gridBagConstraints, 2, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        this.mBandedVarNameEdit.setMinimumSize(new Dimension(150, 20));
        this.mBandedVarLabelEdit.setMinimumSize(new Dimension(280, 20));
        this.mBandedVarNameEdit.setPreferredSize(new Dimension(150, 20));
        this.mBandedVarLabelEdit.setPreferredSize(new Dimension(280, 20));
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mBandedVarNameEdit), gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mBandedVarLabelEdit), gridBagConstraints, 2, 2, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel setupMinMaxValPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(this.getResString("IDS_VB_MINIMUM_VALUE"));
        JLabel jLabel2 = new JLabel(this.getResString("IDS_VB_MAXIMUM_VALUE"));
        JLabel jLabel3 = new JLabel(this.getResString("IDS_VB_NONMISSING_VALUE"));
        this.mMinValEdit.setPreferredSize(new Dimension(120, 20));
        this.mMaxValEdit.setPreferredSize(new Dimension(120, 20));
        this.mHistogramPanel = new VisualBanderHistogram();
        this.mPlane = new Plane(20.0, 5.0, 550.0, 100.0, 0, new String[]{this.getResString("IDS_VB_NO_DATA_FOR_HISTOGRAM"), this.getResString("IDS_VB_CUTPOINT_OVERLAPED_MSG")});
        this.mHistogramPanel.setXyPlane(this.mPlane);
        this.mHistogramPanel.setMarkAxis(false);
        this.mHistogramPanel.setPlotData(false);
        this.mHistogramPanel.setBackground(Color.WHITE);
        this.mHistogramPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.mHistogramPanel.addFocusListener(new FocusHighlighter(this.mHistogramPanel));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = new Insets(3, DialogUtil.getComponentGroupGap(), 3, 3);
        Insets insets2 = new Insets(3, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mMinValEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        n = 24;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 3, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mMaxValEdit, gridBagConstraints, 4, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mHistogramPanel, gridBagConstraints, 0, 1, 5, 1, n, insets);
        return jPanel;
    }

    private JPanel setupGridDescPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_VB_GRID_LABEL");
        jLabel.setVerticalAlignment(3);
        jLabel.setHorizontalAlignment(2);
        jLabel.setLabelFor(this.mCutPtable);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel2 = new JLabel();
        jLabel2.setIcon(new ImageIcon(uRL));
        JTextArea jTextArea = new JTextArea();
        jTextArea.setRows(3);
        jTextArea.setFont(jLabel.getFont());
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setText(this.getResString("IDS_VB_GRID_DESC"));
        jTextArea.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        int n = 16;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, 0, 0, 1));
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 2, 0, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupGridnCutPointsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(this.mCutPtable);
        this.mCutPtable.setMinimumSize(new Dimension(390, 150));
        jScrollPane.setPreferredSize(this.mCutPtable.getMinimumSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 4, n, null);
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.setupUpperEndptPanel(), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets2 = DialogUtil.getStandardButtonInsets();
        Insets insets3 = DialogUtil.getStandardControlInsets();
        insets.set(insets2.top, n2, insets2.bottom, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mMakeCutPtButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMakeLblButton, gridBagConstraints, 1, 2, 1, 1, n, insets);
        insets.set(insets3.top, n2, insets3.bottom, insets3.right);
        DialogUtil.addUsingGBL(jPanel, this.mRevScaleCheck, gridBagConstraints, 1, 3, 1, 1, n, insets);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private JPanel setupUpperEndptPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_VB_UPPER_ENDPOINTS"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mIncludedRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mExcludedRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void runCutPointSubDialog() {
        this.runSubDialog(new VisualBanderMakeCutpoints(this));
    }

    private void rescaleHistogramIfNeeded() {
        Vector<CutPoint> vector = this.mScannedVar.getCutPts();
        if (vector != null) {
            if (this.mOriginalCutPts != null && this.mOriginalCutPts.size() != 2 && vector.size() < this.mOriginalCutPts.size()) {
                this.recalculateHistOnDelCutPt();
            } else if (vector.size() > 2) {
                for (int i = 0; i < vector.size() - 2; ++i) {
                    CutPoint cutPoint = vector.get(i);
                    this.recalculateHistOnAddCutPt(cutPoint.getOBS().getNum());
                }
            }
        }
    }

    private boolean showDialog(String string) {
        int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
        return n == 0;
    }

    private int getIndexInCPArray(Vector<CutPoint> vector, CutPoint cutPoint) {
        if (vector.size() == 0) {
            return 0;
        }
        for (int i = 0; i < vector.size(); ++i) {
            CutPoint cutPoint2 = vector.get(i);
            int n = cutPoint2.getOBS().compareTo((Object)cutPoint.getOBS());
            if (n != 1) continue;
            return i;
        }
        return vector.size();
    }

    private double[] getMeanAndStdDev(TreeMap<OBS, Double> treeMap) {
        double[] dArray = new double[]{0.0, 0.0};
        double d = 0.0;
        double d2 = 0.0;
        for (Map.Entry<OBS, Double> entry : treeMap.entrySet()) {
            d2 += entry.getValue().doubleValue();
        }
        if (!(d2 <= 0.0)) {
            for (Map.Entry<OBS, Double> entry : treeMap.entrySet()) {
                d += entry.getKey().getNum() * entry.getValue() / d2;
            }
            dArray[0] = d;
            if (!(d2 <= 1.0)) {
                double d3 = 0.0;
                d2 -= 1.0;
                for (Map.Entry<OBS, Double> entry : treeMap.entrySet()) {
                    d3 += (entry.getKey().getNum() - d) * (entry.getKey().getNum() - d) * entry.getValue() / d2;
                }
                if (d3 < Double.MAX_VALUE) {
                    dArray[1] = Math.sqrt(d3);
                }
            }
        }
        return dArray;
    }

    private void validateBandedVarName(String string) {
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        boolean bl = true;
        if (n > 0 && n != 100 && n != 3) {
            bl = DialogUtil.showBadSpssVarNameWarning(n, this);
        }
        if (bl) {
            if (string.equals("")) {
                this.mScannedVar.setBandedVarName(string);
            } else if (this.isBandedVarNameDuplicated(string)) {
                this.showInfoDialog(this.getResString("ERR_VB_DUPLICATED_BANDEDVAR_MESSAGE"));
                this.mBandedVarNameEdit.setText("");
                this.mBandedVarNameEdit.requestFocus();
            } else {
                this.mScannedVar.setBandedVarName(string);
            }
        } else {
            if (this.mScannedVar != null && !this.mScannedVarList.getSelectedValue().equals(this.mScannedVar.getSpssVar())) {
                this.mScannedVarList.setSelectedValue(this.mScannedVar.getSpssVar(), true);
            }
            this.mBandedVarNameEdit.setText("");
            this.mBandedVarNameEdit.requestFocus();
        }
    }

    private boolean allValuesMissing() {
        boolean bl = false;
        OBS[] oBSArray = new OBS[]{new OBS(0.0), new OBS(0.0), new OBS(0.0)};
        ISpssVariable.Rule rule = this.mScannedVar.getSpssVar().getMissingValues(oBSArray[0], oBSArray[1], oBSArray[2]);
        if (rule.value() == -2) {
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            double d = iSpssDataSrc.getObslo();
            double d2 = iSpssDataSrc.getObshi();
            if (oBSArray[0].getNum() == d && oBSArray[1].getNum() == d2) {
                this.showInfoDialog(this.getResString("ERR_VB_ALL_VALUES_ARE_MISSING"));
                bl = true;
            }
        }
        return bl;
    }

    private void doPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            boolean bl = false;
            Clipboard clipboard = this.mCutPtable.getToolkit().getSystemClipboard();
            if (clipboard != null && clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                bl = true;
            }
            this.mPasteItem.setEnabled(bl);
            int n = this.mCutPtable.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.mCutPtable.columnAtPoint(mouseEvent.getPoint());
            int n3 = this.mCutPtable.getRowCount();
            this.mDeleteRow.setEnabled(n != n3 - 2);
            if (n2 != 0) {
                this.mPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private String getFormattedStringValue(double d) {
        char c = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale()).getDecimalSeparator();
        StringBuilder stringBuilder = new StringBuilder(DialogUtil.formatDouble(d));
        int n = stringBuilder.indexOf("" + c);
        if (n != -1) {
            String string = stringBuilder.substring(n);
            if (string.length() >= 13) {
                stringBuilder = new StringBuilder(String.format(UIToolResUtil.getSPSSLocale(), "%.15G", d));
            } else if (string.length() == 2 && string.equals(".0")) {
                stringBuilder = new StringBuilder(String.format(UIToolResUtil.getSPSSLocale(), "%d", Math.round(d)));
            }
        }
        return UIToolResUtil.removeLocale((String)stringBuilder.toString());
    }

    private void setColumnEditors() {
        TableColumn tableColumn = this.mCutPtable.getColumnModel().getColumn(1);
        JTextField jTextField = new JTextField();
        if (ComponentState.isBtdRtlOrLtr()) {
            if (ComponentState.getBTD() == 1) {
                jTextField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                jTextField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        }
        jTextField.setCaret(new DefaultCaret());
        tableColumn.setCellEditor(new DefaultCellEditor(jTextField));
        TableColumn tableColumn2 = this.mCutPtable.getColumnModel().getColumn(2);
        JTextField jTextField2 = new JTextField();
        jTextField2.setCaret(new DefaultCaret());
        jTextField2.setDocument(new FixedLengthDocument(120));
        if (ComponentState.isBtdRtlOrLtr()) {
            if (ComponentState.getBTD() == 1) {
                jTextField2.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                jTextField2.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        }
        tableColumn2.setCellEditor(new DefaultCellEditor(jTextField2));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("tableCellEditor") && propertyChangeEvent.getNewValue() != null && this.mCutPtable.getEditorComponent() != null) {
            this.mCutPtable.getEditorComponent().addFocusListener(this);
        }
    }

    private String formatOBS(CutPoint cutPoint) {
        SPSS_Format sPSS_Format = this.mScannedVar.getSpssVar().getFormat();
        int n = sPSS_Format.getDecimals();
        sPSS_Format.setDecimals((byte)(++n));
        return this.formatOBS(cutPoint.getOBS(), sPSS_Format);
    }

    private String formatOBS(OBS oBS, SPSS_Format sPSS_Format) {
        String string = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
        if (string.length() >= 40) {
            string = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)new SPSS_Format(FormatType.E, sPSS_Format.getWidth(), sPSS_Format.getDecimals()));
        }
        return string;
    }

    private static class MissingSpec {
        private static final int SAFETY_RANGE = 100;
        private ScannedVarListVar mScannedVar;
        private int mMaxBin;
        private int mRelocationTarget;
        private boolean mHaveRemapping;
        private boolean mHasRange = false;
        private boolean mHasDiscrete = false;
        private OBS[] mOriginalMissing;
        private OBS[] mNewMissing;
        private double mRangeOffset;
        private double mDiscreteOffset;

        public MissingSpec(ScannedVarListVar scannedVarListVar) {
            this.mScannedVar = scannedVarListVar;
            SpssVariable spssVariable = scannedVarListVar.getSpssVar();
            this.mOriginalMissing = new OBS[]{new OBS(0.0), new OBS(0.0), new OBS(0.0)};
            this.mNewMissing = new OBS[]{new OBS(0.0), new OBS(0.0), new OBS(0.0)};
            ISpssVariable.Rule rule = spssVariable.getMissingValues(this.mOriginalMissing[0], this.mOriginalMissing[1], this.mOriginalMissing[2]);
            this.mMaxBin = scannedVarListVar.getCutPts().size() - 1;
            this.mRelocationTarget = this.mMaxBin + 100;
            this.mHaveRemapping = false;
            switch (rule) {
                case range_plus: 
                case range: {
                    this.setRange();
                    break;
                }
                case one: 
                case two: 
                case three: {
                    this.setDiscrete();
                }
            }
        }

        public void setRange() {
            this.mHasRange = true;
            if (!this.mOriginalMissing[2].isEmpty()) {
                this.mHasDiscrete = true;
                if (!this.discreteOverlaps(this.mOriginalMissing[2].getNum())) {
                    this.mNewMissing[2] = new OBS(this.mOriginalMissing[2].getNum());
                    this.mDiscreteOffset = 0.0;
                } else {
                    this.mHaveRemapping = true;
                    this.mNewMissing[2] = new OBS((double)this.mRelocationTarget);
                    ++this.mRelocationTarget;
                }
            }
            if (!this.rangeOverlaps(this.mOriginalMissing[0].getNum(), this.mOriginalMissing[1].getNum())) {
                this.mNewMissing[0] = new OBS(this.mOriginalMissing[0].getNum());
                this.mNewMissing[1] = new OBS(this.mOriginalMissing[1].getNum());
                this.mRangeOffset = 0.0;
            } else {
                this.mHaveRemapping = true;
                if (this.isLow(this.mOriginalMissing[0].getNum())) {
                    this.mRangeOffset = 0.0 - (this.mOriginalMissing[1].getNum() + 1.0);
                    this.mNewMissing[0] = new OBS(this.mOriginalMissing[0].getNum());
                    this.mNewMissing[1] = new OBS(this.mOriginalMissing[1].getNum() + this.mRangeOffset);
                } else {
                    this.mRangeOffset = (double)this.mRelocationTarget - this.mOriginalMissing[0].getNum();
                    this.mNewMissing[0] = new OBS(this.mOriginalMissing[0].getNum() + this.mRangeOffset);
                    this.mNewMissing[1] = new OBS(this.mOriginalMissing[1].getNum() + this.mRangeOffset);
                }
            }
        }

        public void setDiscrete() {
            this.mHasDiscrete = true;
            boolean bl = false;
            double d = this.mOriginalMissing[0].getNum();
            for (OBS oBS : this.mOriginalMissing) {
                if (oBS.isEmpty()) continue;
                if (oBS.getNum() < d) {
                    d = oBS.getNum();
                }
                if (!this.discreteOverlaps(oBS.getNum())) continue;
                bl = true;
            }
            this.mDiscreteOffset = !bl ? 0.0 : (double)(this.mRelocationTarget - (int)d);
            for (int i = 0; i < this.mOriginalMissing.length; ++i) {
                if (!this.mOriginalMissing[i].isEmpty()) {
                    if (!bl) {
                        this.mNewMissing[i] = new OBS(this.mOriginalMissing[i].getNum());
                        continue;
                    }
                    this.mHaveRemapping = true;
                    this.mNewMissing[i] = new OBS(this.mOriginalMissing[i].getNum() + this.mDiscreteOffset);
                    continue;
                }
                this.mNewMissing[i].setEmpty(true);
            }
        }

        private boolean rangeOverlaps(double d, double d2) {
            if (d > d2) {
                double d3 = d2;
                d2 = d;
                d = d3;
            }
            return d2 >= 0.0 && d <= (double)this.mMaxBin;
        }

        private boolean discreteOverlaps(double d) {
            return d >= 1.0 && d <= (double)this.mMaxBin;
        }

        private boolean isLow(double d) {
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            return d == iSpssDataSrc.getObslo();
        }

        private boolean isHigh(double d) {
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            return d == iSpssDataSrc.getObshi();
        }

        private String getFormattedStringValue(double d) {
            if (this.isLow(d)) {
                return "LO";
            }
            if (this.isHigh(d)) {
                return "HI";
            }
            char c = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale()).getDecimalSeparator();
            String string = Double.toString(d);
            int n = string.indexOf(c);
            if (n != -1) {
                String string2 = string.substring(n);
                if (string2.length() >= 13) {
                    string = String.format("%.15G", d);
                } else if (string2.length() == 2 && string2.equals(".0")) {
                    string = String.format("%d", Math.round(d));
                } else if (string.indexOf(69) != -1) {
                    string = DialogUtil.formatDouble(d);
                }
            }
            return string;
        }

        public String generateTransformSyntax() {
            String string = "";
            if (this.mHasRange) {
                if (this.mRangeOffset != 0.0) {
                    string = this.generateTransformMissingSyntax(this.mRangeOffset);
                }
                if (this.mHasDiscrete) {
                    if (this.mRangeOffset != 0.0 || this.mOriginalMissing[2].getNum() != this.mNewMissing[2].getNum()) {
                        // empty if block
                    }
                    string = string + this.generateTransformValueSyntax(this.mOriginalMissing[2].getNum(), this.mNewMissing[2].getNum());
                }
            } else if (this.mHasDiscrete && this.mDiscreteOffset != 0.0) {
                string = this.generateTransformMissingSyntax(this.mDiscreteOffset);
            }
            return string;
        }

        private String generateTransformMissingSyntax(double d) {
            String string = "";
            string = string + SyntaxUtil.getMainCommand("IF");
            string = string + SyntaxUtil.getMainCommandParamters("(MISSING (");
            string = string + this.mScannedVar.getSpssVar().getName();
            string = string + ")) ";
            string = string + this.mScannedVar.getBandedVarName();
            string = string + "=VALUE (";
            string = string + this.mScannedVar.getSpssVar().getName();
            string = string + ") + ";
            String string2 = this.getFormattedStringValue(d);
            string = string + string2;
            string = string + ".\n";
            return string;
        }

        private String generateTransformValueSyntax(double d, double d2) {
            String string = "";
            string = string + SyntaxUtil.getMainCommand("IF");
            string = string + SyntaxUtil.getMainCommandParamters("(VALUE (");
            string = string + this.mScannedVar.getSpssVar().getName();
            string = string + ") EQ ";
            String string2 = this.getFormattedStringValue(d);
            String string3 = this.getFormattedStringValue(d2);
            string = string + string2;
            string = string + ") ";
            string = string + this.mScannedVar.getBandedVarName();
            string = string + "=";
            string = string + string3;
            string = string + ".\n";
            return string;
        }

        public String generateMissingValuesSyntax() {
            String string = "";
            if (this.mHasRange) {
                string = string + SyntaxUtil.getMainCommand("MISSING VALUES ");
                string = string + this.mScannedVar.getBandedVarName();
                string = string + " (";
                if (this.mHasDiscrete) {
                    string = string + this.getFormattedStringValue(this.mNewMissing[2].getNum());
                    string = string + " , ";
                }
                string = string + this.getFormattedStringValue(this.mNewMissing[0].getNum());
                string = string + " THRU ";
                string = string + this.getFormattedStringValue(this.mNewMissing[1].getNum());
                string = string + ").\n";
            } else if (this.mHasDiscrete) {
                string = string + SyntaxUtil.getMainCommand("MISSING VALUES ");
                string = string + this.mScannedVar.getBandedVarName();
                string = string + " (";
                for (int i = 0; i < 3; ++i) {
                    if (this.mOriginalMissing[i].isEmpty()) continue;
                    if (i > 0) {
                        string = string + " , ";
                    }
                    string = string + this.getFormattedStringValue(this.mNewMissing[i].getNum());
                }
                string = string + ").\n";
            }
            return string;
        }

        public String getLabelsForMissingValues() {
            String string = "";
            SpssVariable spssVariable = this.mScannedVar.getSpssVar();
            IValueLabelMap iValueLabelMap = spssVariable.getValueLabels();
            Set set = iValueLabelMap.getValueLabelEntries();
            if (this.mHasRange) {
                Object object = set.iterator();
                while (object.hasNext()) {
                    Map.Entry entry = (Map.Entry)object.next();
                    OBS oBS = (OBS)entry.getKey();
                    if (!(oBS.getNum() >= this.mOriginalMissing[0].getNum()) || !(oBS.getNum() <= this.mOriginalMissing[1].getNum())) continue;
                    string = string + this.missingLabelItem(oBS.getNum() + this.mRangeOffset, (String)entry.getValue());
                }
                if (this.mHasDiscrete && (object = iValueLabelMap.get(this.mOriginalMissing[2])) != null) {
                    string = string + this.missingLabelItem(this.mNewMissing[2].getNum(), (String)object);
                }
            } else if (this.mHasDiscrete) {
                for (int i = 0; i < 3; ++i) {
                    String string2;
                    if (this.mOriginalMissing[i].isEmpty() || (string2 = iValueLabelMap.get(this.mOriginalMissing[i])) == null) continue;
                    string = string + this.missingLabelItem(this.mNewMissing[i].getNum(), string2);
                }
            }
            return string;
        }

        private String missingLabelItem(double d, String string) {
            String string2 = "";
            string2 = string2 + " ";
            string2 = string2 + this.getFormattedStringValue(d);
            string2 = string2 + " ";
            string2 = string2 + CharacterUtil.smartQuote((String)string);
            return string2;
        }

        public boolean haveRemapping() {
            return this.mHaveRemapping;
        }
    }

    class HistoBin {
        double mBoundry;
        double mCount;
        String mLabel = "";

        HistoBin() {
        }

        public void setBinBoundry(double d) {
            this.mBoundry = d;
        }

        public void setLabel(String string) {
            this.mLabel = string;
        }

        public void setBinCount(double d) {
            this.mCount = d;
        }

        public double getCount() {
            return this.mCount;
        }

        public double getBoundry() {
            return this.mBoundry;
        }

        public String getLabel() {
            return this.mLabel;
        }
    }

    class CutPointTableRenderer
    extends DefaultTableCellRenderer {
        JLabel mLabel;

        CutPointTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.mLabel = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 0) {
                JTableHeader jTableHeader = jTable.getTableHeader();
                this.setOpaque(true);
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
                this.mLabel.setHorizontalAlignment(2);
            } else if (n2 == 1) {
                this.mLabel.setHorizontalAlignment(4);
            } else if (n2 == 2) {
                this.mLabel.setHorizontalAlignment(2);
            }
            return this.mLabel;
        }
    }

    class ScannedVarListVar {
        private JLabel mMeasurementIcon;
        private SpssVariable mSpssVar;
        private String mBandedVarName = "";
        private String mBandedVarLabel = "";
        private long mMissingVals;
        private double mMinVal;
        private double mMaxVal;
        private double mMaxValFromFreqTable;
        Vector<HistoBin> mHistobins;
        public double mInterval;
        public double mStartpos;
        public double mEndpos;
        public int mNoOfBins;
        Vector<CutPoint> mCutPtArray;
        private TreeMap<OBS, Double> mFreqTable;
        public boolean mIsReversedScale;
        public boolean mIsEndptIncluded = true;
        public boolean mDrawHistogram = false;

        public ScannedVarListVar(SpssVariable spssVariable) {
            this.mSpssVar = spssVariable;
            this.mBandedVarLabel = this.mSpssVar.getLabel().equals("") ? this.mSpssVar.getName() + VisualBanderDlg.this.getResString("IDS_VB_BRACKET_BINNED") : this.mSpssVar.getLabel() + VisualBanderDlg.this.getResString("IDS_VB_BRACKET_BINNED");
            this.mMeasurementIcon = new JLabel(VariableList.getStandardIcon((ISpssVariable)this.mSpssVar));
            this.mMeasurementIcon.setOpaque(true);
        }

        public void setHistoBin(Vector<HistoBin> vector) {
            this.mHistobins = vector;
        }

        public double getStartPos() {
            return this.mStartpos;
        }

        public double getEndPos() {
            return this.mEndpos;
        }

        public void setEndPos(double d) {
            this.mEndpos = d;
        }

        public void setStartPos(double d) {
            this.mStartpos = d;
        }

        public void setInterval(double d) {
            this.mInterval = d;
        }

        public double getInterval() {
            return this.mInterval;
        }

        public String getBandedVarLabel() {
            return this.mBandedVarLabel;
        }

        public void setBandedVarLabel(String string) {
            this.mBandedVarLabel = string;
        }

        public void setDefaultVarProperties() {
            this.mBandedVarLabel = this.mSpssVar.getLabel().equals("") ? this.mSpssVar.getName() + VisualBanderDlg.this.getResString("IDS_VB_BRACKET_BINNED") : this.mSpssVar.getLabel() + VisualBanderDlg.this.getResString("IDS_VB_BRACKET_BINNED");
            this.setCutPts(null);
            this.setBandedVarName("");
            this.setReversedScale(false);
            this.setEndptIncluded(true);
        }

        public String getBandedVarName() {
            return this.mBandedVarName;
        }

        public void setBandedVarName(String string) {
            this.mBandedVarName = string;
        }

        public double getMaxVal() {
            return this.mMaxVal;
        }

        public void setMaxVal(double d) {
            this.mMaxVal = d;
        }

        public double getMinVal() {
            return this.mMinVal;
        }

        public void setMinVal(double d) {
            this.mMinVal = d;
        }

        public long getMissingVals() {
            return this.mMissingVals;
        }

        public void setMissingVals(long l) {
            this.mMissingVals = l;
        }

        public TreeMap<OBS, Double> getValMap() {
            return this.mFreqTable;
        }

        public void setValMap(TreeMap<OBS, Double> treeMap) {
            this.mFreqTable = treeMap;
            if (this.mFreqTable.size() > 0) {
                this.mMinVal = this.mFreqTable.firstKey().getNum();
                this.mMaxVal = this.mFreqTable.lastKey().getNum();
                this.mDrawHistogram = this.mMaxVal != this.mMinVal;
            }
        }

        public SpssVariable getSpssVar() {
            return this.mSpssVar;
        }

        public void setNoOfBins(int n) {
            this.mNoOfBins = n;
        }

        public double getMaximumValue() {
            return this.mMaxValFromFreqTable;
        }

        public void setMaximumValue(double d) {
            this.mMaxValFromFreqTable = d;
        }

        public int getNoOfBins() {
            return this.mNoOfBins;
        }

        public Vector<HistoBin> getHistoBins() {
            return this.mHistobins;
        }

        public void setCutPts(Vector<CutPoint> vector) {
            this.mCutPtArray = vector;
            CutPointTableModel cutPointTableModel = (CutPointTableModel)VisualBanderDlg.this.mCutPtable.getModel();
            cutPointTableModel.fireTableDataChanged();
        }

        public Vector<CutPoint> getCutPts() {
            return this.mCutPtArray;
        }

        public boolean isReversedScale() {
            return this.mIsReversedScale;
        }

        public boolean canDrawHistogram() {
            return this.mDrawHistogram;
        }

        public void setReversedScale(boolean bl) {
            this.mIsReversedScale = bl;
        }

        public boolean isEndptIncluded() {
            return this.mIsEndptIncluded;
        }

        public void setEndptIncluded(boolean bl) {
            this.mIsEndptIncluded = bl;
        }

        public JLabel getMeasurementIcon() {
            return this.mMeasurementIcon;
        }
    }

    class PopupMenuListener
    implements ActionListener {
        PopupMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == VisualBanderDlg.this.mCutItem) {
                Action action = VisualBanderDlg.this.mCutPtable.getActionMap().get("cut");
                if (action != null) {
                    action.actionPerformed(new ActionEvent(VisualBanderDlg.this.mCutPtable, 1, "cut"));
                }
            } else if (actionEvent.getSource() == VisualBanderDlg.this.mCopyItem) {
                VisualBanderDlg.this.mCutPtable.dispatchEvent(new KeyEvent(VisualBanderDlg.this.mCutPtable, 401, 0L, 128, 67, 'C'));
            } else if (actionEvent.getSource() == VisualBanderDlg.this.mPasteItem) {
                Action action = VisualBanderDlg.this.mCutPtable.getActionMap().get("paste");
                if (action != null) {
                    action.actionPerformed(new ActionEvent(VisualBanderDlg.this.mCutPtable, 1, "paste"));
                }
            } else if (actionEvent.getSource() == VisualBanderDlg.this.mClearItem) {
                VisualBanderDlg.this.clearSelectedCells();
            } else if (actionEvent.getSource() == VisualBanderDlg.this.mDeleteRow) {
                int n = VisualBanderDlg.this.mCutPtable.getSelectedRow();
                Vector<CutPoint> vector = VisualBanderDlg.this.mScannedVar.getCutPts();
                if (n != -1 && n < vector.size() - 2) {
                    if (VisualBanderDlg.this.mAreCPLabeled) {
                        VisualBanderDlg.this.mAreCPLabeled = false;
                        VisualBanderDlg.this.showInfoDialog(VisualBanderDlg.this.getResString("ERR_VB_AUTO_LABEL_NO_LONGER_CORRECT"));
                    }
                    vector.remove(n);
                    VisualBanderDlg.this.mCutPtable.setModel(new CutPointTableModel(vector));
                    VisualBanderDlg.this.setColumnEditors();
                    VisualBanderDlg.this.setDefaultSelectedCell();
                }
            } else if (actionEvent.getSource() == VisualBanderDlg.this.mDeleteLbls) {
                CutPointTableModel cutPointTableModel = (CutPointTableModel)VisualBanderDlg.this.mCutPtable.getModel();
                for (int i = 0; i < cutPointTableModel.getRowCount() - 1; ++i) {
                    cutPointTableModel.setValueAt("", i, 2);
                }
                VisualBanderDlg.this.mCutPtable.setModel(cutPointTableModel);
                VisualBanderDlg.this.setColumnEditors();
            } else if (actionEvent.getSource() == VisualBanderDlg.this.mDeleteCutpts) {
                VisualBanderDlg.this.mScannedVar.setCutPts(null);
                VisualBanderDlg.this.mCutPtable.setModel(new CutPointTableModel(VisualBanderDlg.this.mScannedVar.getCutPts()));
                VisualBanderDlg.this.setColumnEditors();
                VisualBanderDlg.this.setDefaultSelectedCell();
            }
        }
    }

    class ObsSorter
    implements Comparator<CutPoint> {
        ObsSorter() {
        }

        @Override
        public int compare(CutPoint cutPoint, CutPoint cutPoint2) {
            return cutPoint.getOBS().compareTo((Object)cutPoint2.getOBS());
        }
    }

    class CutPointTableModel
    extends AbstractTableModel {
        Vector<CutPoint> mCutPointList;

        public CutPointTableModel() {
        }

        public CutPointTableModel(Vector<CutPoint> vector) {
            if (vector == null) {
                vector = new Vector();
                vector.add(new CutPoint(new OBS(VisualBanderDlg.this.getResString("IDS_VB_GRID_HIGH_VALUE"))));
                vector.add(new CutPoint(new OBS()));
            }
            this.mCutPointList = vector;
            VisualBanderDlg.this.mScannedVar.setCutPts(this.mCutPointList);
            this.fireTableDataChanged();
            VisualBanderDlg.this.enableCopyButtons();
            VisualBanderDlg.this.mHistogramPanel.setPlotCutPoints(VisualBanderDlg.this.mScannedVar.canDrawHistogram());
            VisualBanderDlg.this.mHistogramPanel.setMarkAxis(VisualBanderDlg.this.mScannedVar.canDrawHistogram());
            VisualBanderDlg.this.mHistogramPanel.repaint();
        }

        @Override
        public int getRowCount() {
            if (this.mCutPointList != null) {
                return this.mCutPointList.size();
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            int n3 = VisualBanderDlg.this.mCutPtable.getRowCount();
            CutPoint cutPoint = this.mCutPointList.get(n);
            if (n2 == 0) {
                return n + 1;
            }
            if (n2 == 1 && n != n3 - 2) {
                return VisualBanderDlg.this.formatOBS(cutPoint);
            }
            if (n2 == 1 && n == n3 - 2) {
                return VisualBanderDlg.this.getResString("IDS_VB_GRID_HIGH_VALUE");
            }
            if (n2 == 2 && n != n3 - 1) {
                return cutPoint.getLabel();
            }
            return "";
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 1: {
                    return VisualBanderDlg.this.getResString("IDS_VB_VALUE");
                }
                case 2: {
                    return VisualBanderDlg.this.getResString("IDS_VB_LABEL_TB");
                }
            }
            return " ";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0 && n >= 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            int n3;
            CutPoint cutPoint = this.mCutPointList.get(n);
            CutPoint cutPoint2 = null;
            OBS oBS = new OBS();
            if (n2 == 1 && !object.toString().equals("")) {
                if (CellValueFormatter.stringToObs((String)object.toString(), (SPSS_Format)VisualBanderDlg.this.mScannedVar.getSpssVar().getFormat(), (OBS)oBS) && !this.isDuplicate(oBS)) {
                    if (VisualBanderDlg.this.mAreCPLabeled) {
                        VisualBanderDlg.this.mAreCPLabeled = false;
                        VisualBanderDlg.this.showInfoDialog(VisualBanderDlg.this.getResString("ERR_VB_AUTO_LABEL_NO_LONGER_CORRECT"));
                    }
                    if (n >= this.getRowCount() - 2) {
                        cutPoint2 = new CutPoint(oBS);
                        this.mCutPointList.add(this.getRowCount() - 2, cutPoint2);
                    } else {
                        cutPoint2 = cutPoint;
                        cutPoint.setOBS(oBS);
                    }
                }
            } else {
                cutPoint.setLabel(object.toString());
            }
            if (cutPoint2 != null && (n3 = this.mCutPointList.indexOf(cutPoint2)) != -1) {
                VisualBanderDlg.this.mCutPtable.setRowSelectionInterval(n3, n3);
            }
            VisualBanderDlg.this.mScannedVar.setCutPts(this.mCutPointList);
            VisualBanderDlg.this.rescaleHistogramIfNeeded();
            VisualBanderDlg.this.enableCopyButtons();
            VisualBanderDlg.this.mHistogramPanel.setPlotCutPoints(VisualBanderDlg.this.mScannedVar.canDrawHistogram());
            VisualBanderDlg.this.mHistogramPanel.setMarkAxis(VisualBanderDlg.this.mScannedVar.canDrawHistogram());
            VisualBanderDlg.this.mHistogramPanel.repaint();
        }

        private boolean isDuplicate(OBS oBS) {
            for (int i = 0; i < this.mCutPointList.size() - 2; ++i) {
                CutPoint cutPoint = this.mCutPointList.get(i);
                if (!cutPoint.getOBS().equals((Object)oBS)) continue;
                VisualBanderDlg.this.showInfoDialog(VisualBanderDlg.this.getResString("ERR_VB_KEY_DUPLICATE_MESSAGE"));
                return true;
            }
            return false;
        }

        @Override
        public void fireTableDataChanged() {
            super.fireTableDataChanged();
            if (this.mCutPointList != null) {
                Collections.sort(this.mCutPointList.subList(0, this.mCutPointList.size() - 2), new ObsSorter());
                this.selectCutpoint();
                VisualBanderDlg.this.enableReset(VisualBanderDlg.this.canEnableReset());
                VisualBanderDlg.this.rescaleHistogramIfNeeded();
            }
        }

        public void selectCutpoint() {
            for (int i = 0; i < this.mCutPointList.size(); ++i) {
                CutPoint cutPoint = this.mCutPointList.get(i);
                if (!cutPoint.isSelected()) continue;
                if (i <= -1 || i >= VisualBanderDlg.this.mCutPtable.getRowCount()) break;
                VisualBanderDlg.this.mCutPtable.grabFocus();
                VisualBanderDlg.this.mCutPtable.setRowSelectionInterval(i, i);
                VisualBanderDlg.this.mCutPtable.setColumnSelectionInterval(1, 1);
                break;
            }
        }

        public void clearLabels() {
            for (CutPoint cutPoint : this.mCutPointList) {
                cutPoint.setLabel("");
            }
            this.fireTableDataChanged();
        }

        public Vector<CutPoint> getTableData() {
            return this.mCutPointList;
        }
    }
}

