/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.visual_bander;

import com.spss.java_client.ui.dialogs.base.transform.visual_bander.CutPoint;
import com.spss.java_client.ui.dialogs.base.transform.visual_bander.VisualBanderDlg;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

class Plane {
    double mMaxXvalue;
    double mMaxYvalue;
    double mBinWidth;
    double mBinHeight;
    double mXOrigin;
    double mYOrigin;
    double mPlaneWidth;
    double mPlaneHeight;
    int mNumOfBins;
    VisualBanderDlg.ScannedVarListVar mScannedVar;
    String mNoDataMessage = "";
    String mCPOverlapedMessage = "";

    Plane(double d, double d2) {
        this.mPlaneWidth = d;
        this.mPlaneHeight = d2;
        this.mXOrigin = 20.0;
        this.mYOrigin = d2 - 28.0;
    }

    Plane(double d, double d2, double d3, double d4, int n, String[] stringArray) {
        this.mMaxXvalue = d;
        this.mMaxYvalue = d2;
        this.mXOrigin = 20.0;
        this.mYOrigin = d4 - 28.0;
        this.mPlaneWidth = d3;
        this.mPlaneHeight = d4;
        this.mBinWidth = (this.mPlaneWidth - this.mXOrigin - 40.0) / (double)(n + 1);
        this.mBinHeight = (this.mPlaneHeight - 40.0) / this.mMaxYvalue;
        this.mNumOfBins = n;
        this.mNoDataMessage = stringArray[0];
        this.mCPOverlapedMessage = stringArray[1];
    }

    public void setPlaneAttributes(double d, double d2, double d3, double d4, int n) {
        this.mMaxXvalue = d;
        this.mMaxYvalue = d2;
        this.mYOrigin = d4 - 28.0;
        this.mPlaneWidth = d3;
        this.mPlaneHeight = d4;
        this.mBinWidth = (this.mPlaneWidth - this.mXOrigin - 40.0) / (double)(n + 1);
        this.mBinHeight = (this.mPlaneHeight - 40.0) / this.mMaxYvalue;
        this.mNumOfBins = n;
    }

    public void displayCutPoints() {
        Vector<CutPoint> vector = this.mScannedVar.getCutPts();
        if (vector == null) {
            return;
        }
        this.mScannedVar.setCutPts(vector);
    }

    public void setSelectedCutPoint(int n) {
        if (this.mScannedVar == null) {
            return;
        }
        Vector<CutPoint> vector = this.mScannedVar.getCutPts();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size() - 2; ++i) {
            if (i == n) {
                vector.get(i).setSelected(true);
                continue;
            }
            vector.get(i).setSelected(false);
        }
    }

    public boolean cutPointExist(double d) {
        Vector<CutPoint> vector = this.mScannedVar.getCutPts();
        if (vector == null) {
            return false;
        }
        for (int i = 0; i < vector.size() - 2; ++i) {
            if (d != vector.get(i).getOBS().getNum()) continue;
            return true;
        }
        return false;
    }

    public void setScannedVariable(VisualBanderDlg.ScannedVarListVar scannedVarListVar) {
        this.mScannedVar = scannedVarListVar;
    }

    public VisualBanderDlg.ScannedVarListVar getScannedVar() {
        return this.mScannedVar;
    }

    public void setMaxY(double d) {
        this.mMaxYvalue = d;
        this.mBinHeight = (this.mPlaneHeight - 40.0) / this.mMaxYvalue;
    }

    public void removeCutPoint(Graphics2D graphics2D, CutPoint cutPoint, Color color) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.xUnitsToPixel(cutPoint.getOBS().getNum()), 8.0, 0.7, this.mPlaneHeight - 36.0);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(this.xUnitsToPixel(cutPoint.getOBS().getNum()), 8.0, 1.7, this.mPlaneHeight - 36.0);
        graphics2D.setColor(color);
        graphics2D.draw(double_);
        if (cutPoint.isSelected()) {
            graphics2D.draw(double_2);
        }
        this.removeCutPoint(cutPoint);
        graphics2D.setColor(Color.black);
        this.plotAxis(graphics2D);
    }

    public void plotCutPoint(Graphics2D graphics2D, CutPoint cutPoint) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.xUnitsToPixel(cutPoint.getOBS().getNum()), 8.0, 1.0, this.mPlaneHeight - 36.0);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(this.xUnitsToPixel(cutPoint.getOBS().getNum()), 8.0, 2.0, this.mPlaneHeight - 36.0);
        if (cutPoint.isSelected()) {
            graphics2D.setColor(Color.RED);
            graphics2D.draw(double_2);
            graphics2D.fill(double_2);
        } else {
            graphics2D.setColor(Color.BLUE);
            graphics2D.draw(double_);
            graphics2D.fill(double_);
        }
        graphics2D.setColor(Color.black);
    }

    public void plotAxis(Graphics2D graphics2D) {
        Line2D.Double double_ = new Line2D.Double(this.mXOrigin, this.mYOrigin, this.mPlaneWidth - 40.0, this.mYOrigin);
        Line2D.Double double_2 = new Line2D.Double(this.mXOrigin, this.mYOrigin, this.mXOrigin, 8.0);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
    }

    public void markXaxis(Graphics2D graphics2D) {
        for (int i = 0; i <= this.mNumOfBins; ++i) {
            double d = (double)i * this.mBinWidth + this.mXOrigin;
            Line2D.Double double_ = new Line2D.Double(d, this.mYOrigin + 2.0, d, this.mYOrigin - 2.0);
            graphics2D.draw(double_);
        }
    }

    public void plot(Graphics2D graphics2D) {
        long l = 1L;
        long l2 = 0L;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Font font = graphics2D.getFont();
        if (this.mScannedVar.getMaxVal() == this.mScannedVar.getMinVal()) {
            l2 = fontMetrics.stringWidth(this.mNoDataMessage);
            graphics2D.drawString(this.mNoDataMessage, (int)(this.mPlaneWidth / 2.0 - (double)(l2 / 2L)), (int)this.mPlaneHeight / 2);
            return;
        }
        Vector<VisualBanderDlg.HistoBin> vector = this.mScannedVar.getHistoBins();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            VisualBanderDlg.HistoBin histoBin = vector.get(i);
            String string = histoBin.getLabel();
            double d = this.mXOrigin + (double)i * this.mBinWidth;
            double d2 = this.mYOrigin - histoBin.getCount() * this.mBinHeight;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, this.mBinWidth, this.mYOrigin - d2);
            graphics2D.setColor(Color.YELLOW);
            graphics2D.fill(double_);
            graphics2D.setColor(Color.black);
            graphics2D.draw(double_);
            graphics2D.setFont(new Font(font.getName(), font.getStyle(), font.getSize() - 2));
            l2 = fontMetrics.stringWidth(string);
        }
        if ((double)l2 > this.mBinWidth) {
            l = Math.round((double)l2 / this.mBinWidth);
        }
        this.drawLabel(graphics2D, l);
        graphics2D.setFont(font);
    }

    public void drawLabel(Graphics2D graphics2D, long l) {
        if (l <= 0L) {
            return;
        }
        boolean bl = true;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Vector<VisualBanderDlg.HistoBin> vector = this.mScannedVar.getHistoBins();
        int n = 0;
        while (n < vector.size()) {
            VisualBanderDlg.HistoBin histoBin = vector.get(n);
            String string = histoBin.getLabel();
            int n2 = fontMetrics.stringWidth(string);
            if (bl) {
                graphics2D.drawString(string, (int)(this.mXOrigin + (double)(n + 1) * this.mBinWidth - (double)(n2 / 2)), (int)(this.mYOrigin + 12.0));
                bl = l == 1L && (double)n2 < this.mBinWidth;
            } else {
                graphics2D.drawString(string, (int)(this.mXOrigin + (double)(n + 1) * this.mBinWidth - (double)(n2 / 2)), (int)(this.mYOrigin + 22.0));
                bl = true;
            }
            n = (int)((long)n + l);
        }
    }

    public void plotPoints(Graphics2D graphics2D) {
        Vector<CutPoint> vector = this.mScannedVar.getCutPts();
        for (int i = 0; i <= vector.size() - 2; ++i) {
            this.plotCutPoint(graphics2D, vector.get(i));
        }
    }

    public double mBinWidthelToUnits(double d) {
        return (d - this.mXOrigin) * (this.mScannedVar.getInterval() / this.mBinWidth) + this.mScannedVar.getStartPos();
    }

    public double xUnitsToPixel(double d) {
        return this.mXOrigin + (d - this.mScannedVar.getStartPos()) / this.mScannedVar.getInterval() * this.mBinWidth;
    }

    public boolean cutPointOverlapped(double d) {
        Vector<CutPoint> vector = this.mScannedVar.getCutPts();
        if (vector == null) {
            return false;
        }
        for (int i = 0; i < vector.size() - 2; ++i) {
            CutPoint cutPoint = vector.get(i);
            double d2 = this.xUnitsToPixel(cutPoint.getOBS().getNum());
            if (cutPoint.isSelected() || !(d2 >= d - 4.0) || !(d2 <= d + 4.0)) continue;
            return true;
        }
        return false;
    }

    public void removeCutPoint(CutPoint cutPoint) {
        Vector<CutPoint> vector = this.mScannedVar.getCutPts();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (cutPoint.getOBS().getNum() != vector.get(i).getOBS().getNum()) continue;
            vector.remove(i);
            break;
        }
    }
}

