/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.replace_missing_val;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDropListener;
import com.spss.java_client.ui.dialogs.base.transform.replace_missing_val.ReplaceMissingValuesCellRenderer;
import com.spss.java_client.ui.dialogs.base.transform.res.TransformResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IPlainListVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.VarInfoBag;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public class ReplaceMissingValuesDlg
extends BaseProcedureDialog
implements ListSelectionListener,
ItemListener,
ActionListener,
FocusListener,
DocumentListener,
IPlainListVarMoveHandler,
ListDataListener {
    private static final String EMPTY_STR = "";
    private static final String VALUE_OUT_OF_RANGE = "ERR_RMV_VALUE_OUT_OF_RANGE";
    private static final String MEAN_STR = "MEAN";
    private static final String MEDIAN_STR = "MEDIAN";
    private static final String ALL_STR = "ALL";
    private static final String OPENING_BRACKET = "(";
    private static final String CLOSING_BRACKET = ")";
    private static final String SPACE = " ";
    private static final String UNDERSCORE = "_";
    private SrcVariableList mSrcVarList;
    private JLabel mNewVariablesLabel;
    private PlainList mTargetVarList;
    private ComponentsArrowButton mArrowButton;
    private JLabel mNameLabel;
    private StringTextField mNameText;
    private JButton mChangeButton;
    private JLabel mMethodLabel;
    private JComboBox mMethodComboBox;
    private JLabel mSpanOfNearbyPtLabel;
    private JRadioButton mNumberRadio;
    private IntTextField mNumberText;
    private JRadioButton mAllRadio;
    private SpssVarFilter mSrcVarFilter;
    private SpssButtonGroup mRadioButtonGroup;
    private Vector<String> mMethodComboValuesText;
    private String mOrigNameText;
    private String mOrigNumberText;
    private String mOrigVarName;

    public ReplaceMissingValuesDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, false, TransformResBundle.getDefaultResourceBundleName(), TransformResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_RMV_TITLE"));
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append(SyntaxUtil.getMainCommand("RMV"));
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < this.mTargetVarList.getModel().getSize(); ++i) {
            RMVCustomData rMVCustomData = (RMVCustomData)this.mTargetVarList.getModel().getElementAt(i);
            stringBuffer2.append("/").append(rMVCustomData.getFirstDisplayPart()).append("=");
            String string = rMVCustomData.getSecondDisplayPart();
            if (string.contains(ALL_STR)) {
                string = string.substring(0, string.indexOf(ALL_STR)) + ALL_STR + CLOSING_BRACKET;
            }
            stringBuffer2.append(string);
            if (i == this.mTargetVarList.getModel().getSize() - 1) continue;
            stringBuffer2.append(SPACE);
        }
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(stringBuffer2.toString()));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rmvx";
    }

    @Override
    public final String getIActionKey() {
        return "transform_replace_missing_values";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mMethodComboBox)) {
            int n;
            RMVCustomData rMVCustomData = (RMVCustomData)this.mTargetVarList.getSelectedValue();
            if (rMVCustomData != null) {
                this.mChangeButton.setEnabled(this.hasStateChanged(rMVCustomData));
            }
            boolean bl = (n = this.mMethodComboBox.getSelectedIndex()) == 1 || n == 2;
            this.mSpanOfNearbyPtLabel.setEnabled(bl);
            this.mNumberRadio.setEnabled(bl);
            this.mNumberText.setEnabled(bl && this.mNumberRadio.isSelected());
            this.mNumberText.setOpaque(bl && this.mNumberRadio.isSelected());
            this.mAllRadio.setEnabled(bl);
        } else if (itemEvent.getSource().equals(this.mAllRadio)) {
            if (this.mAllRadio.isSelected()) {
                this.mNumberText.setEnabled(false);
                this.mNumberText.setOpaque(false);
                if (this.mTargetVarList.getSelectedValue() != null) {
                    this.mChangeButton.setEnabled(this.hasStateChanged((RMVCustomData)this.mTargetVarList.getSelectedValue()));
                }
            }
        } else if (itemEvent.getSource().equals(this.mNumberRadio) && this.mNumberRadio.isSelected()) {
            this.mNumberText.setEnabled(true);
            this.mNumberText.setOpaque(true);
            if (this.mTargetVarList.getSelectedValue() != null) {
                this.mChangeButton.setEnabled(this.hasStateChanged((RMVCustomData)this.mTargetVarList.getSelectedValue()));
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.mTargetVarList)) {
            int[] nArray = this.mTargetVarList.getSelectedIndices();
            if (nArray.length > 1) {
                this.disableNameAndMethodPanel();
            } else if (nArray.length == 1) {
                this.mChangeButton.setEnabled(false);
                this.loadVariableValues();
            }
        } else if (listSelectionEvent.getSource().equals(this.mSrcVarList)) {
            this.disableNameAndChangeButton();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mSrcVarList)) {
            this.mSrcVarList.requestFocus();
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            if (this.mSrcVarList.getSelectedValue() != null) {
                this.disableNameAndChangeButton();
            }
        } else if (focusEvent.getSource().equals(this.mTargetVarList)) {
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            int[] nArray = this.mTargetVarList.getSelectedIndices();
            if (nArray.length > 1) {
                this.disableNameAndMethodPanel();
            } else if (nArray.length == 1) {
                this.setNameText();
            }
        } else if (focusEvent.getSource().equals(this.mNameText)) {
            this.mNameText.selectAll();
        } else if (focusEvent.getSource().equals(this.mNumberText)) {
            this.mNumberText.selectAll();
        } else if (focusEvent.getSource().equals(this.mNumberRadio)) {
            this.mNumberText.setEnabled(true);
            this.mNumberText.setOpaque(true);
            this.mNumberText.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        RMVCustomData rMVCustomData = (RMVCustomData)this.mTargetVarList.getSelectedValue();
        if (rMVCustomData != null) {
            if (documentEvent.getDocument().equals(this.mNameText.getDocument())) {
                if (this.mNumberText.isEnabled()) {
                    if (this.mNumberText.getText().length() > 0) {
                        this.mChangeButton.setEnabled(this.hasStateChanged(rMVCustomData));
                    } else {
                        this.mChangeButton.setEnabled(false);
                    }
                } else {
                    this.mChangeButton.setEnabled(this.hasStateChanged(rMVCustomData));
                }
                this.mOrigNameText = this.mNameText.getText();
                this.mOrigVarName = rMVCustomData.getFirstDisplayPart();
            } else if (documentEvent.getDocument().equals(this.mNumberText.getDocument())) {
                if (this.mNameText.getText().length() > 0) {
                    this.mChangeButton.setEnabled(this.hasStateChanged(rMVCustomData));
                } else {
                    this.mChangeButton.setEnabled(false);
                }
                this.mOrigNumberText = this.mNumberText.getText();
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        RMVCustomData rMVCustomData = (RMVCustomData)this.mTargetVarList.getSelectedValue();
        if (rMVCustomData != null) {
            if (documentEvent.getDocument().equals(this.mNameText.getDocument())) {
                if (this.mNumberText.isEnabled()) {
                    if (this.mNumberText.getText().length() > 0) {
                        this.mChangeButton.setEnabled(this.hasStateChanged(rMVCustomData));
                    } else {
                        this.mChangeButton.setEnabled(false);
                    }
                } else {
                    this.mChangeButton.setEnabled(this.hasStateChanged(rMVCustomData));
                }
                this.mOrigNameText = this.mNameText.getText();
                this.mOrigVarName = rMVCustomData.getFirstDisplayPart();
            } else if (documentEvent.getDocument().equals(this.mNumberText.getDocument())) {
                if (this.mNumberText.getText().length() > 0) {
                    this.mChangeButton.setEnabled(this.hasStateChanged(rMVCustomData));
                } else {
                    this.mChangeButton.setEnabled(false);
                }
                this.mOrigNumberText = this.mNumberText.getText();
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public boolean isDragAllowed(JList jList, JList jList2, Object[] objectArray) {
        return true;
    }

    @Override
    public Object[] getModifiedData(Object[] objectArray, JList jList, PlainList plainList) {
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        if (plainList.equals(this.mTargetVarList)) {
            for (Object object : objectArray) {
                if (!(object instanceof ISpssVariable)) continue;
                RMVCustomData rMVCustomData = new RMVCustomData((ISpssVariable)object);
                rMVCustomData.setFirstDisplayPart(this.getFirstPart(rMVCustomData.getVarName()));
                int n2 = this.mMethodComboBox.getSelectedIndex();
                String string = this.getSecondPart(rMVCustomData.getVarName(), this.mMethodComboValuesText.get(n2));
                rMVCustomData.setSecondDisplayPart(string);
                objectArray2[n] = rMVCustomData;
                ++n;
            }
        }
        if (n == objectArray.length) {
            return objectArray2;
        }
        return objectArray;
    }

    @Override
    public boolean preMoveVariables(Object[] objectArray, PlainList plainList) {
        if (plainList.equals(this.mTargetVarList)) {
            if (this.mMethodComboBox.getSelectedIndex() == 1 && this.mNumberRadio.isSelected() && this.mNumberText.getText().length() == 0 || this.mMethodComboBox.getSelectedIndex() == 1 && this.mNumberRadio.isSelected() && this.mNumberText.getText().length() > 0 && !this.numberTextNotZero()) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString(VALUE_OUT_OF_RANGE), VersionInfo.getAppVersionString());
                this.mNumberText.selectAll();
                this.mNumberText.requestFocus();
                return false;
            }
            if (this.mMethodComboBox.getSelectedIndex() == 2 && this.mNumberRadio.isSelected() && this.mNumberText.getText().length() == 0 || this.mMethodComboBox.getSelectedIndex() == 2 && this.mNumberRadio.isSelected() && this.mNumberText.getText().length() > 0 && !this.numberTextNotZero()) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString(VALUE_OUT_OF_RANGE), VersionInfo.getAppVersionString());
                this.mNumberText.selectAll();
                this.mNumberText.requestFocus();
                return false;
            }
            if (this.mTargetVarList.getMaxLimitOfList() < objectArray.length + this.mTargetVarList.getModel().getSize()) {
                String string = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_LIST_MAX_LIMIT_EXCEEDED_WARNING"), this.mTargetVarList.getMaxLimitOfList());
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
                return false;
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        if (SpssArrowButton.ButtonOrientation.left == ((ComponentsArrowButton)actionEvent.getSource()).getArrowOrientation()) {
            Object object;
            int[] nArray = this.mTargetVarList.getSelectedIndices();
            Object[] objectArray = this.mTargetVarList.getSelectedValues();
            for (int i = nArray.length - 1; i >= 0; --i) {
                object = (RMVCustomData)((DefaultListModel)this.mTargetVarList.getModel()).getElementAt(nArray[i]);
                ((DefaultListModel)this.mTargetVarList.getModel()).removeElement(object);
            }
            this.updateOkPaste();
            this.disableNameAndChangeButton();
            int[] nArray2 = this.getSrcListSelectedIndices(objectArray);
            this.mSrcVarList.setSelectedIndices(nArray2);
            object = this.mSrcVarList;
            SwingUtilities.invokeLater(new Runnable((VariableList)object){
                final /* synthetic */ VariableList val$varList;
                {
                    this.val$varList = variableList;
                }

                @Override
                public void run() {
                    this.val$varList.requestFocus();
                }
            });
        } else {
            DefaultListModel defaultListModel = (DefaultListModel)this.mTargetVarList.getModel();
            ISpssVariable[] iSpssVariableArray = this.mSrcVarList.getSelectedValues();
            this.mSrcVarList.clearSelection();
            int n = this.mTargetVarList.getModel().getSize();
            int n2 = n + iSpssVariableArray.length - 1;
            this.mTargetVarList.clearSelection();
            int n3 = 0;
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                Object object;
                if (this.mTargetVarList.getMaxLimitOfList() >= iSpssVariableArray.length - n3 + this.mTargetVarList.getModel().getSize()) {
                    object = new RMVCustomData(iSpssVariable);
                    ((RMVCustomData)object).setFirstDisplayPart(this.getFirstPart(((RMVCustomData)object).getVarName()));
                    int srcVariableList = this.mMethodComboBox.getSelectedIndex();
                    String string = this.getSecondPart(((RMVCustomData)object).getVarName(), this.mMethodComboValuesText.get(srcVariableList));
                    if (string.equals(EMPTY_STR)) {
                        bl = true;
                    } else {
                        ((RMVCustomData)object).setSecondDisplayPart(string);
                        defaultListModel.addElement(object);
                    }
                    if (iSpssVariableArray.length == 1) {
                        this.mOrigNameText = ((RMVCustomData)object).getFirstDisplayPart();
                        this.mOrigVarName = ((RMVCustomData)object).getFirstDisplayPart();
                    }
                } else {
                    object = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_LIST_MAX_LIMIT_EXCEEDED_WARNING"), this.mTargetVarList.getMaxLimitOfList());
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), (String)object, VersionInfo.getAppVersionString());
                    this.mSrcVarList.setSelection(iSpssVariableArray);
                    final SrcVariableList srcVariableList = this.mSrcVarList;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            srcVariableList.requestFocus();
                        }
                    });
                    return;
                }
                ++n3;
            }
            if (!bl) {
                this.updateOkPaste();
                this.mTargetVarList.setSelectionInterval(n, n2);
                this.mTargetVarList.ensureIndexIsVisible(n2);
                final PlainList plainList = this.mTargetVarList;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        plainList.requestFocus();
                    }
                });
            }
        }
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = true;
        if (this.mChangeButton.isEnabled() && 0 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_RMV_WARNING_PENDING_OPERATION_LOST"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
            bl = false;
        }
        if (this.changeExistingVariables() && bl && 0 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_RMV_WARNING_CHANGE_EXISTING_VARIABLE"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
            bl = false;
        }
        return bl && super.okPastePressed();
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.enableOkPaste(false);
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters();
        }
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.validateSerializableLists();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void validateSerializableLists() {
        for (int i = this.mTargetVarList.getModel().getSize() - 1; i >= 0; --i) {
            ISpssVariable iSpssVariable;
            RMVCustomData rMVCustomData = (RMVCustomData)this.mTargetVarList.getModel().getElementAt(i);
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.findVarIndex(rMVCustomData.getVarName());
            if (n == -1) {
                iSpssVariable = rMVCustomData.getMVariable();
                boolean bl = iSpssDataSrc.isVariableInCurrentSet(rMVCustomData.getMVariable());
                if (!bl) {
                    ((DefaultListModel)this.mTargetVarList.getModel()).removeElementAt(i);
                    continue;
                }
                rMVCustomData.setVarName(iSpssVariable.getName());
                rMVCustomData.setFirstDisplayPart(this.getFirstPart(rMVCustomData.getVarName()));
                int n2 = this.mMethodComboBox.getSelectedIndex();
                rMVCustomData.setSecondDisplayPart(this.getSecondPart(rMVCustomData.getVarName(), this.mMethodComboValuesText.get(n2)));
                continue;
            }
            iSpssVariable = iSpssDataSrc.getVariable(n);
            if (this.mSrcVarList.canIncludeVariable(iSpssVariable)) continue;
            ((DefaultListModel)this.mTargetVarList.getModel()).removeElementAt(i);
            this.mSrcVarList.getModel().removeElement(iSpssVariable);
        }
        this.mTargetVarList.repaint();
        this.updateOkPaste();
    }

    private void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mSrcVarList, this.mPlainListVarMoveHandler));
        PlainListDragAdapter plainListDragAdapter = new PlainListDragAdapter(this.mTargetVarList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mTargetVarList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mTargetVarList, this.mPlainListVarMoveHandler));
    }

    private void initVars() {
        ActionListener[] actionListenerArray;
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.addFocusListener(this);
        this.mSrcVarList.addListSelectionListener(this);
        this.mArrowButton = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.right);
        for (ActionListener actionListener : actionListenerArray = this.mArrowButton.getActionListeners()) {
            this.mArrowButton.removeActionListener(actionListener);
        }
        this.mArrowButton.addActionListener(this);
        this.mTargetVarList = new PlainList("PLAIN_LIST_KEY");
        this.mTargetVarList.setDragType(PlainList.DragType.eAutoDragCopy);
        this.mTargetVarList.setMaxLimitOfList(100);
        this.mTargetVarList.addFocusListener(this);
        this.mTargetVarList.addListSelectionListener(this);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mNewVariablesLabel = DialogUtil.createLabel(this, "IDS_RMV_NEW_VARIABLES_LABEL");
        this.mNewVariablesLabel.setLabelFor(this.mTargetVarList);
        this.mArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        ReplaceMissingValuesCellRenderer replaceMissingValuesCellRenderer = new ReplaceMissingValuesCellRenderer();
        this.mTargetVarList.setCellRenderer(replaceMissingValuesCellRenderer);
        this.mNameText = new StringTextField();
        this.mNameText.getDocument().addDocumentListener(this);
        this.mNameText.addFocusListener(this);
        this.mNameLabel = DialogUtil.createLabel(this, "IDS_RMV_NAME_LABEL");
        this.mNameLabel.setLabelFor((Component)((Object)this.mNameText));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_CHANGE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ReplaceMissingValuesDlg.this.isAlreadyPresent(ReplaceMissingValuesDlg.this.mNameText.getText(), ReplaceMissingValuesDlg.this.mTargetVarList.getSelectedIndex())) {
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)ReplaceMissingValuesDlg.this), ReplaceMissingValuesDlg.this.getResString("ERR_RMV_DUPLICATE_NEW_VARIABLES"), VersionInfo.getAppVersionString());
                    ReplaceMissingValuesDlg.this.mNameText.selectAll();
                    ReplaceMissingValuesDlg.this.mNameText.requestFocus();
                } else if (ReplaceMissingValuesDlg.this.isValidVariableName(ReplaceMissingValuesDlg.this.mNameText.getText())) {
                    if (ReplaceMissingValuesDlg.this.mMethodComboBox.getSelectedIndex() == 1 || ReplaceMissingValuesDlg.this.mMethodComboBox.getSelectedIndex() == 2) {
                        if (ReplaceMissingValuesDlg.this.numberTextNotZero()) {
                            ReplaceMissingValuesDlg.this.handleChangeButtonPress();
                            ReplaceMissingValuesDlg.this.mChangeButton.setEnabled(false);
                            final PlainList plainList = ReplaceMissingValuesDlg.this.mTargetVarList;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    plainList.requestFocus();
                                }
                            });
                        } else {
                            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)ReplaceMissingValuesDlg.this), ReplaceMissingValuesDlg.this.getResString(ReplaceMissingValuesDlg.VALUE_OUT_OF_RANGE), VersionInfo.getAppVersionString());
                            ReplaceMissingValuesDlg.this.mNumberText.selectAll();
                            ReplaceMissingValuesDlg.this.mNumberText.requestFocus();
                        }
                    } else {
                        ReplaceMissingValuesDlg.this.handleChangeButtonPress();
                        ReplaceMissingValuesDlg.this.mChangeButton.setEnabled(false);
                        final PlainList plainList = ReplaceMissingValuesDlg.this.mTargetVarList;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                plainList.requestFocus();
                            }
                        });
                    }
                }
            }
        };
        this.mChangeButton = new JButton(toggleButtonAction);
        String[] stringArray = this.getResStringArray("IDS_RMV_METHOD_NAMES");
        Vector<String> vector = new Vector<String>();
        vector.addAll(Arrays.asList(stringArray));
        this.mMethodComboBox = new JComboBox(vector);
        this.mMethodComboBox.setAction(new ComboboxAction(this, "COMBO_BOX_KEY"));
        this.mMethodComboBox.addItemListener(this);
        this.mMethodLabel = DialogUtil.createLabel(this, "IDS_RMV_METHOD_LABEL");
        this.mMethodLabel.setLabelFor(this.mMethodComboBox);
        this.mSpanOfNearbyPtLabel = new JLabel(this.getResString("IDS_RMV_SPAN_OF_NEARBY_PT_LABEL"));
        toggleButtonAction = new ToggleButtonAction(this, "IDS_RMV_NUMBER_RADIO");
        this.mNumberRadio = new JRadioButton(toggleButtonAction);
        this.mNumberRadio.addFocusListener(this);
        this.mNumberRadio.addItemListener(this);
        this.mNumberText = new IntTextField(true);
        this.mNumberText.setColumns(2);
        this.mNumberText.setDocument((Document)new FixedLengthNumericDocument(3, true, false));
        this.mNumberText.getDocument().addDocumentListener(this);
        this.mNumberText.addFocusListener((FocusListener)this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_RMV_ALL_RADIO");
        this.mAllRadio = new JRadioButton(toggleButtonAction);
        this.mAllRadio.addItemListener(this);
        this.mMethodComboValuesText = new Vector();
        this.mPlainListVarMoveHandler = this;
    }

    private void setDefaults() {
        ((DefaultListModel)this.mTargetVarList.getModel()).removeAllElements();
        if (this.mSrcVarFilter != null) {
            this.mSrcVarList.removeVarFilter(this.mSrcVarFilter);
        }
        this.mSrcVarFilter = new SpssVarFilter(8, true, false);
        this.mSrcVarList.addVarFilter(this.mSrcVarFilter);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mArrowButton.setEnabled(true);
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mNameLabel.setEnabled(false);
        this.mNameText.setEnabled(false);
        this.mNameText.setOpaque(false);
        this.mNameText.setText(EMPTY_STR);
        this.mSpanOfNearbyPtLabel.setEnabled(false);
        this.mMethodComboBox.setSelectedIndex(0);
        this.mChangeButton.setEnabled(false);
        this.mNumberRadio.setEnabled(false);
        this.mNumberRadio.setSelected(true);
        this.mNumberText.setEnabled(false);
        this.mNumberText.setOpaque(false);
        this.mNumberText.setText("2");
        this.mOrigNumberText = this.mNumberText.getText();
        this.mOrigNameText = EMPTY_STR;
        this.mAllRadio.setEnabled(false);
        String[] stringArray = new String[]{"SMEAN", MEAN_STR, MEDIAN_STR, "LINT", "TREND"};
        this.mMethodComboValuesText.addAll(Arrays.asList(stringArray));
        this.updateOkPaste();
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_RMV_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 2, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mNewVariablesLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 5 + 2));
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetVarList);
        jScrollPane2.setPreferredSize(this.mTargetVarList.getMinimumSize());
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, null);
        Insets insets2 = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel2 = this.setupNameAndMethodPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 2, 2, 1, n, insets2);
    }

    private JPanel setupNameAndMethodPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_RMV_NAME_AND_METHOD_PANEL_TITLE")));
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNameLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNameText), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(-3, DialogUtil.getGroupBoxInnerMargin(), 3, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mChangeButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getStandardControlInsets().left, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMethodLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mMethodComboBox, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JPanel jPanel2 = this.setupRadioPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel setupRadioPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSpanOfNearbyPtLabel, gridBagConstraints, 0, 0, 3, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.set(insets.bottom, insets.bottom * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNumberRadio, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getComponentGroupGap(), DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNumberText, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mAllRadio, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        this.mRadioButtonGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mNameText);
        vector.add(this.mMethodComboBox);
        vector.add(this.mRadioButtonGroup);
        vector.add(this.mNumberText);
        vector.add(this.mChangeButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void disableNameAndChangeButton() {
        this.mNameLabel.setEnabled(false);
        this.mNameText.setEnabled(false);
        this.mNameText.setOpaque(false);
        this.mNameText.setText(EMPTY_STR);
        this.mChangeButton.setEnabled(false);
    }

    private void disableNameAndMethodPanel() {
        this.mNameLabel.setEnabled(false);
        this.mNameText.setEnabled(false);
        this.mNameText.setOpaque(false);
        this.mNameText.setText(EMPTY_STR);
        this.mChangeButton.setEnabled(false);
        this.mMethodLabel.setEnabled(false);
        this.mMethodComboBox.setEnabled(false);
        this.mSpanOfNearbyPtLabel.setEnabled(false);
        this.mNumberRadio.setEnabled(false);
        this.mNumberText.setEnabled(false);
        this.mNumberText.setOpaque(false);
        this.mAllRadio.setEnabled(false);
    }

    private void setNameText() {
        RMVCustomData rMVCustomData = (RMVCustomData)this.mTargetVarList.getSelectedValue();
        if (rMVCustomData != null) {
            this.mNameLabel.setEnabled(true);
            this.mNameText.setEnabled(true);
            this.mNameText.setOpaque(true);
            this.mNameText.getDocument().removeDocumentListener(this);
            if (rMVCustomData.getFirstDisplayPart().equalsIgnoreCase(this.mOrigVarName)) {
                if (this.mOrigNameText == null || this.mOrigNameText.equals(EMPTY_STR)) {
                    this.mNameText.setText(rMVCustomData.getFirstDisplayPart());
                } else {
                    this.mNameText.setText(this.mOrigNameText);
                    this.mOrigNameText = null;
                }
            } else {
                this.mNameText.setText(rMVCustomData.getFirstDisplayPart());
            }
            this.mNameText.getDocument().addDocumentListener(this);
        }
    }

    private void loadVariableValues() {
        RMVCustomData rMVCustomData = (RMVCustomData)this.mTargetVarList.getSelectedValue();
        if (rMVCustomData != null) {
            this.mNameLabel.setEnabled(true);
            this.mNameText.setEnabled(true);
            this.mNameText.setOpaque(true);
            this.mNameText.getDocument().removeDocumentListener(this);
            if (rMVCustomData.getFirstDisplayPart().equalsIgnoreCase(this.mOrigVarName)) {
                if (this.mOrigNameText == null || this.mOrigNameText.equals(EMPTY_STR)) {
                    this.mNameText.setText(rMVCustomData.getFirstDisplayPart());
                } else {
                    this.mNameText.setText(this.mOrigNameText);
                    this.mOrigNameText = null;
                }
            } else {
                this.mNameText.setText(rMVCustomData.getFirstDisplayPart());
            }
            this.mNameText.getDocument().addDocumentListener(this);
            this.mMethodLabel.setEnabled(true);
            this.mMethodComboBox.setEnabled(true);
            String string = rMVCustomData.getSecondDisplayPart();
            int n = string.indexOf(OPENING_BRACKET);
            String string2 = string.substring(0, n);
            int n2 = this.mMethodComboValuesText.indexOf(string2);
            this.mMethodComboBox.removeItemListener(this);
            this.mMethodComboBox.setSelectedIndex(n2);
            this.mMethodComboBox.addItemListener(this);
            if (n2 == 1 || n2 == 2) {
                this.mSpanOfNearbyPtLabel.setEnabled(true);
                this.mNumberRadio.setEnabled(true);
                this.mNumberText.setEnabled(true);
                this.mNumberText.setOpaque(true);
                this.mAllRadio.setEnabled(true);
                int n3 = string.indexOf(SPACE);
                int n4 = string.indexOf(CLOSING_BRACKET);
                String string3 = string.substring(n3 + 1, n4);
                if (string3.equals(ALL_STR)) {
                    this.mAllRadio.setSelected(true);
                    this.mNumberText.setEnabled(false);
                    this.mNumberText.setOpaque(false);
                } else {
                    this.mNumberRadio.setSelected(true);
                    this.mNumberText.setEnabled(true);
                    this.mNumberText.setOpaque(true);
                    this.mNumberText.getDocument().removeDocumentListener(this);
                    if (rMVCustomData.getFirstDisplayPart().equalsIgnoreCase(this.mOrigVarName)) {
                        this.mNumberText.setText(this.mOrigNumberText);
                    } else {
                        this.mNumberText.setText(string3);
                    }
                    this.mNumberText.getDocument().addDocumentListener(this);
                }
            } else {
                this.mSpanOfNearbyPtLabel.setEnabled(false);
                this.mNumberRadio.setEnabled(false);
                this.mNumberText.setEnabled(false);
                this.mNumberText.setOpaque(false);
                this.mAllRadio.setEnabled(false);
            }
        }
    }

    private String getFirstPart(String string) {
        Object object;
        int n;
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < this.mTargetVarList.getModel().getSize(); ++n) {
            object = (RMVCustomData)this.mTargetVarList.getModel().getElementAt(n);
            if (!((RMVCustomData)object).getVarName().equals(string)) continue;
            vector.add(((RMVCustomData)object).getFirstDisplayPart());
        }
        for (n = 1; n <= vector.size(); ++n) {
            object = string + UNDERSCORE + n;
            if (vector.contains(object)) continue;
            return object;
        }
        object = string + UNDERSCORE + n;
        return object;
    }

    private String getSecondPart(String string, String string2) {
        String string3 = EMPTY_STR;
        if (string2.equals(MEAN_STR)) {
            if (this.mNumberRadio.isSelected()) {
                if (this.mNumberText.getText().length() > 0) {
                    if (this.numberTextNotZero()) {
                        string3 = "MEAN(" + string + SPACE + this.mNumberText.getText() + CLOSING_BRACKET;
                    } else {
                        SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString(VALUE_OUT_OF_RANGE), VersionInfo.getAppVersionString());
                        this.mNumberText.selectAll();
                        this.mNumberText.requestFocus();
                    }
                } else {
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString(VALUE_OUT_OF_RANGE), VersionInfo.getAppVersionString());
                    this.mNumberText.selectAll();
                    this.mNumberText.requestFocus();
                }
            } else if (this.mAllRadio.isSelected()) {
                string3 = "MEAN(" + string + SPACE + ALL_STR + CLOSING_BRACKET;
            }
        } else if (string2.equals(MEDIAN_STR)) {
            if (this.mNumberRadio.isSelected()) {
                if (this.mNumberText.getText().length() > 0) {
                    if (this.numberTextNotZero()) {
                        string3 = "MEDIAN(" + string + SPACE + this.mNumberText.getText() + CLOSING_BRACKET;
                    } else {
                        SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString(VALUE_OUT_OF_RANGE), VersionInfo.getAppVersionString());
                        this.mNumberText.selectAll();
                        this.mNumberText.requestFocus();
                    }
                } else {
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString(VALUE_OUT_OF_RANGE), VersionInfo.getAppVersionString());
                    this.mNumberText.selectAll();
                    this.mNumberText.requestFocus();
                }
            } else if (this.mAllRadio.isSelected()) {
                string3 = "MEDIAN(" + string + SPACE + ALL_STR + CLOSING_BRACKET;
            }
        } else {
            string3 = string2 + OPENING_BRACKET + string + CLOSING_BRACKET;
        }
        return string3;
    }

    private boolean isValidVariableName(String string) {
        boolean bl;
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        if (n > 0 && n != 100) {
            DialogUtil.showBadSpssVarNameWarning(n, this);
            this.mNameText.selectAll();
            this.mNameText.requestFocus();
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private void updateOkPaste() {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    private boolean hasStateChanged(RMVCustomData rMVCustomData) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = !this.mNameText.getText().equals(rMVCustomData.getFirstDisplayPart());
        String string = rMVCustomData.getSecondDisplayPart();
        int n = string.indexOf(OPENING_BRACKET);
        String string2 = string.substring(0, n);
        int n2 = this.mMethodComboValuesText.indexOf(string2);
        if (this.mMethodComboBox.getSelectedIndex() == n2) {
            int n3;
            int n4;
            String string3;
            bl2 = n2 == 1 || n2 == 2 ? ((string3 = string.substring((n4 = string.indexOf(SPACE)) + 1, n3 = string.indexOf(CLOSING_BRACKET))).equals(ALL_STR) ? !this.mAllRadio.isSelected() : this.mAllRadio.isSelected() || !string3.equals(this.mNumberText.getText())) : false;
            bl = false;
        } else {
            bl = true;
        }
        return bl3 || bl || bl2;
    }

    private boolean numberTextNotZero() {
        boolean bl = true;
        Integer n = new Integer(this.mNumberText.getText());
        if (0 == n) {
            bl = false;
        }
        return bl;
    }

    private boolean isAlreadyPresent(String string, int n) {
        boolean bl = false;
        for (int i = 0; i < this.mTargetVarList.getModel().getSize(); ++i) {
            RMVCustomData rMVCustomData;
            if (i == n || !string.equals((rMVCustomData = (RMVCustomData)this.mTargetVarList.getModel().getElementAt(i)).getFirstDisplayPart())) continue;
            bl = true;
        }
        return bl;
    }

    private boolean changeExistingVariables() {
        boolean bl = false;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        for (int i = 0; i < this.mTargetVarList.getModel().getSize(); ++i) {
            RMVCustomData rMVCustomData = (RMVCustomData)this.mTargetVarList.getModel().getElementAt(i);
            if (iSpssDataSrc.findVarIndex(rMVCustomData.getFirstDisplayPart()) == -1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void handleChangeButtonPress() {
        RMVCustomData rMVCustomData = (RMVCustomData)this.mTargetVarList.getModel().getElementAt(this.mTargetVarList.getSelectedIndex());
        rMVCustomData.setFirstDisplayPart(this.mNameText.getText());
        int n = this.mMethodComboBox.getSelectedIndex();
        rMVCustomData.setSecondDisplayPart(this.getSecondPart(rMVCustomData.getVarName(), this.mMethodComboValuesText.get(n)));
    }

    private int[] getSrcListSelectedIndices(Object[] objectArray) {
        Vector<String> vector = new Vector<String>();
        for (Object object : objectArray) {
            if (vector.contains(((RMVCustomData)object).getVarName())) continue;
            vector.add(((RMVCustomData)object).getVarName());
        }
        int[] nArray = new int[vector.size()];
        int n = 0;
        for (int i = 0; i < this.mSrcVarList.getModel().getSize(); ++i) {
            if (!vector.contains(this.mSrcVarList.getModel().getElementAt(i).getName())) continue;
            nArray[n] = i;
            ++n;
        }
        return nArray;
    }

    public static class RMVCustomData
    implements SerializableObject {
        ISpssVariable mVariable;
        private String mVarName;
        private String mFirstDisplayPart;
        private String mSecondDisplayPart;

        public RMVCustomData() {
        }

        public RMVCustomData(ISpssVariable iSpssVariable) {
            this.mVarName = iSpssVariable.getName();
            this.mVariable = iSpssVariable;
        }

        public String getFirstDisplayPart() {
            return this.mFirstDisplayPart;
        }

        public void setFirstDisplayPart(String string) {
            this.mFirstDisplayPart = string;
        }

        public String getSecondDisplayPart() {
            return this.mSecondDisplayPart;
        }

        public void setSecondDisplayPart(String string) {
            this.mSecondDisplayPart = string;
        }

        public String getVarName() {
            return this.mVarName;
        }

        public void setVarName(String string) {
            this.mVarName = string;
        }

        public ISpssVariable getMVariable() {
            return this.mVariable;
        }

        public void setMVariable(ISpssVariable iSpssVariable) {
            this.mVariable = iSpssVariable;
        }

        public String toString() {
            return this.getFirstDisplayPart() + " = " + this.getSecondDisplayPart();
        }

        public String getClassName() {
            return "com.spss.java_client.ui.dialogs.base.transform.replace_missing_val.ReplaceMissingValuesDlg$RMVCustomData";
        }

        public boolean writeVersionedObject(ObjectOutputStream objectOutputStream, int n) throws Exception {
            objectOutputStream.writeUTF(this.mVarName);
            objectOutputStream.writeUTF(this.mFirstDisplayPart);
            objectOutputStream.writeUTF(this.mSecondDisplayPart);
            VarInfoBag varInfoBag = new VarInfoBag(this.mVariable);
            return varInfoBag.writeVersionedObject(objectOutputStream, n);
        }

        public boolean readVersionedObject(ObjectInputStream objectInputStream, int n) throws Exception {
            this.mVarName = objectInputStream.readUTF();
            this.mFirstDisplayPart = objectInputStream.readUTF();
            this.mSecondDisplayPart = objectInputStream.readUTF();
            VarInfoBag varInfoBag = new VarInfoBag();
            boolean bl = varInfoBag.readVersionedObject(objectInputStream, n);
            if (bl) {
                this.mVariable = DialogDataModel.varBagToVariable(varInfoBag);
            }
            return bl;
        }
    }
}

