/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.rank_cases;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.transform.rank_cases.RankCasesTies;
import com.spss.java_client.ui.dialogs.base.transform.rank_cases.RankCasesTypes;
import com.spss.java_client.ui.dialogs.base.transform.res.TransformResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class RankCasesDlg
extends BaseProcedureDialog
implements ListDataListener {
    public static final int MAX_ELEMENTS = 8;
    private static final String ASSIGNSMALLEST_KEY = "IDS_RANKCASES_ASSIGNSMALLEST";
    private static final String ASSIGNLARGEST_KEY = "IDS_RANKCASES_ASSIGNLARGEST";
    static final String TARGETLISTVARKEY = "IDS_RANKCASES_VARLIST_COLON";
    static final String TARGETLISTBYKEY = "IDS_RANKCASES_BY_COLON";
    static final String DISPSUMMARY_KEY = "IDS_RANKCASES_DISPSUMMARY";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private TargetVariableList mTargetByList;
    private JRadioButton mAssignSmallestRadio;
    private JRadioButton mAssignLargestRadio;
    private JScrollPane mScrollPaneSourcelist;
    private JScrollPane mScrollPaneVarlist;
    private JScrollPane mScrollPaneBylist;
    private ArrowButton mArrowButtonVarlist;
    private JLabel mVarList;
    private ArrowButton mArrowButtonBylist;
    private JLabel mByList;
    private SpssButtonGroup mGroupAssign;
    private JCheckBox mDispCheck;
    private JButton mRankTypes;
    private JButton mTies;
    private Insets mInsets;

    public RankCasesDlg(JFrame jFrame) {
        super(jFrame, false, TransformResBundle.getDefaultResourceBundleName(), TransformResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_RANKCASES"));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rank";
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("RANK"));
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string = this.mTargetVarList.getVariablesStringList();
        String string2 = this.mTargetByList.getVariablesStringList();
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES=") + string);
        Boolean bl = dialogDataModel.getBoolean(ASSIGNSMALLEST_KEY);
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getCommand(" (A)", false));
        } else {
            stringBuffer.append(SyntaxUtil.getCommand(" (D)", false));
        }
        int n = string2.length();
        if (n != 0) {
            stringBuffer.append(" BY " + string2);
        }
        if ((bl = dialogDataModel.getBoolean("IDS_RANKCASES_TYPES_PROPEST")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PROPORTION"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_RANKCASES_TYPES_NORMALSCORES")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/NORMAL"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_RANKCASES_TYPES_RANK")) == null || bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/RANK"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_RANKCASES_TYPES_SAVAGESCORE")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/SAVAGE"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_RANKCASES_TYPES_NTILES")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/NTILES"));
            stringBuffer.append("(" + dialogDataModel.getString("IDS_RANKCASES_TXTFIELD_NTILES4_KEY") + ")");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_RANKCASES_TYPES_FRACTRANK")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/RFRACTION"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_RANKCASES_TYPES_FRACTRANKPERC")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PERCENT"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_RANKCASES_TYPES_SUMOFCASE")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/N"));
        }
        if ((bl = dialogDataModel.getBoolean(DISPSUMMARY_KEY)) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PRINT=YES"));
        } else {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PRINT=NO"));
        }
        bl = dialogDataModel.getBoolean("IDS_RANKCASES_TIES_MEAN");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/TIES=MEAN"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_RANKCASES_TIES_LOW")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/TIES=LOW"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_RANKCASES_TIES_HIGH")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/TIES=HIGH"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_RANKCASES_TIES_SEQUENTIAL")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/TIES=CONDENSE"));
        }
        bl = dialogDataModel.getBoolean("IDS_RANKCASES_TYPES_PROPEST");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_RANKCASES_TYPES_NORMALSCORES");
        if (!(bl != null && bl.booleanValue() || bl2 != null && bl2.booleanValue())) {
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        bl = dialogDataModel.getBoolean("IDS_RANKCASES_TYPES_PROPEST");
        bl2 = dialogDataModel.getBoolean("IDS_RANKCASES_TYPES_NORMALSCORES");
        if (bl != null && bl.booleanValue() || bl2 != null && bl2.booleanValue()) {
            bl = dialogDataModel.getBoolean("IDS_RANKCASES_TYPES_BLOM");
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/FRACTION=BLOM"));
            }
            if ((bl = dialogDataModel.getBoolean("IDS_RANKCASES_TYPES_TUKEY")) != null && bl.booleanValue()) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/FRACTION=TUKEY"));
            }
            if ((bl = dialogDataModel.getBoolean("IDS_RANKCASES_TYPES_RANKIT")) != null && bl.booleanValue()) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/FRACTION=RANKIT"));
            }
            if ((bl = dialogDataModel.getBoolean("IDS_RANKCASES_TYPES_VANDERW")) != null && bl.booleanValue()) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/FRACTION=VW"));
            }
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public final String getIActionKey() {
        return "transform_rank_cases";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.mTargetByList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setFocusable(true);
        this.setDefaults();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        this.mInsets = new Insets(0, 0, 0, 0);
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupLists();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 23, null);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocusInWindow();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        String string = "IDS_RANKCASES_RANKTYPES_3DOTS";
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, string){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RankCasesDlg.this.runRankCasesTypesSubDialog();
            }
        };
        this.mRankTypes = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mRankTypes);
        string = "IDS_RANKCASES_TIES_3DOTS";
        toggleButtonAction = new ToggleButtonAction(this, string){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RankCasesDlg.this.runTiesSubDialog();
            }
        };
        this.mTies = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mTies);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mSrcVarList.loadFromActiveDataset();
        this.mScrollPaneSourcelist = new JScrollPane(this.mSrcVarList);
        this.mScrollPaneSourcelist.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mArrowButtonVarlist = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mVarList = DialogUtil.createLabel(this, TARGETLISTVARKEY);
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mScrollPaneVarlist = new JScrollPane(this.mTargetVarList);
        this.mScrollPaneVarlist.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setIdentifier(TARGETLISTVARKEY);
        this.mArrowButtonBylist = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mByList = DialogUtil.createLabel(this, TARGETLISTBYKEY);
        this.mTargetByList = new TargetVariableList();
        this.mTargetByList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mTargetByList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mScrollPaneBylist = new JScrollPane(this.mTargetByList);
        this.mScrollPaneBylist.setPreferredSize(this.mTargetByList.getMinimumSize());
        this.mTargetByList.getModel().addListDataListener(this);
        this.mTargetByList.setIdentifier(TARGETLISTBYKEY);
        this.mTargetByList.setMaxLimitOfList(8);
        this.mVarList.setLabelFor(this.mTargetVarList);
        this.mByList.setLabelFor(this.mTargetByList);
        this.mArrowButtonVarlist.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonVarlist.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButtonBylist.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonBylist.registerVariableList(this.mTargetByList, SpssArrowButton.ButtonOrientation.left);
        this.mGroupAssign = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, ASSIGNSMALLEST_KEY);
        this.mAssignSmallestRadio = new JRadioButton(toggleButtonAction);
        this.mGroupAssign.add(this.mAssignSmallestRadio);
        toggleButtonAction = new ToggleButtonAction(this, ASSIGNLARGEST_KEY);
        this.mAssignLargestRadio = new JRadioButton(toggleButtonAction);
        this.mGroupAssign.add(this.mAssignLargestRadio);
        toggleButtonAction = new ToggleButtonAction(this, DISPSUMMARY_KEY);
        this.mDispCheck = new JCheckBox(toggleButtonAction);
    }

    private void setDefaults() {
        this.mSrcVarList.setSelectedIndex(0);
        this.mAssignSmallestRadio.setSelected(true);
        this.mDispCheck.setSelected(true);
        this.mSrcVarList.requestFocus();
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButtonVarlist);
        vector.add(this.mArrowButtonBylist);
        vector.add(this.mTargetVarList);
        vector.add(this.mTargetByList);
        vector.add(this.mGroupAssign);
        vector.add(this.mDispCheck);
        vector.add(this.mRankTypes);
        vector.add(this.mTies);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private JPanel setupLists() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPaneSourcelist, gridBagConstraints, 0, 0, 1, 4, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonVarlist, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mVarList, gridBagConstraints, 2, 0, 1, 1, n, null);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPaneVarlist, gridBagConstraints, 2, 1, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonBylist, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        this.mInsets.set(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mByList, gridBagConstraints, 2, 2, 1, 1, n, this.mInsets);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPaneBylist, gridBagConstraints, 2, 3, 1, 1, n, null);
        JPanel jPanel2 = this.setupAssignPanel();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.mInsets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 4, 1, 1, 23, this.mInsets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.mInsets.set(DialogUtil.getComponentGroupGap(), 0, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mDispCheck, gridBagConstraints, 2, 4, 1, 1, 23, this.mInsets);
        return jPanel;
    }

    private JPanel setupAssignPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mAssignSmallestRadio, this.mAssignLargestRadio};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_RANKCASES_ASSIGN"), 2);
        return jPanel;
    }

    private void runRankCasesTypesSubDialog() {
        this.runSubDialog(new RankCasesTypes(this, this.getResString("IDS_RANKCASES_TYPES"), true));
    }

    private void runTiesSubDialog() {
        this.runSubDialog(new RankCasesTies(this, this.getResString("IDS_RANKCASES_TIES"), true));
    }
}

