/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.prepare_data_for_modeling;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.transform.res.TransformResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;

public class BacktransformScoreDlg
extends BaseProcedureDialog
implements ListDataListener,
ActionListener,
CaretListener {
    private static String NEW_FIELD_SUFFIX = "BTS_NEW_FIELD_SUFFIX";
    private static String XML_FILE_PATH = "BTS_XML_FILE_PATH";
    private static String DEFAULT_SUFFIX = "IDS_BTS_NEW_FIELD_SUFFIX_DEFAULT";
    private JTextArea mesgArea;
    private TargetVariableList mTargetVarList;
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private ArrowButton mArrowButton;
    private JScrollPane mTargetScrollPane;
    private JLabel mSuffixLabel;
    private StringTextField mNewFieldSuffix;
    private JLabel mXMLFileLabel;
    private FileTextField mXMLFileEdit;
    private JButton mBrowseButton;

    public BacktransformScoreDlg(JFrame jFrame) {
        super(jFrame, false, TransformResBundle.getDefaultResourceBundleName(), TransformResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_BF_SCORE_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public boolean okPastePressed() {
        String string = this.mNewFieldSuffix.getText();
        String string2 = "";
        boolean bl = this.isNameTooLong(string);
        if (bl || this.hasInValidSpssNameChar(string)) {
            string2 = bl ? this.getResString("ERR_BTS_SUFFIX_WARNING2") : this.getResString("ERR_BTS_SUFFIX_WARNING1");
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString());
            this.setSelection((JTextField)((Object)this.mNewFieldSuffix));
            return false;
        }
        short s = FileValidator.evaluateOpenFile((Component)((Object)this), this.mXMLFileEdit.getText().trim(), false, true);
        if (s == 5) {
            string2 = this.getResString("ERR_BTS_XML_FILE_NOT_EXISTS");
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString());
            this.setSelection((JTextField)((Object)this.mXMLFileEdit));
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String generateSyntax() {
        String string = SyntaxUtil.startSyntax().toString();
        String string2 = this.mTargetVarList.getVariablesStringList();
        string = string + SyntaxUtil.getMainCommand("TMS IMPORT").toString();
        string = string + SyntaxUtil.getCommand("\n  /INFILE TRANSFORMATIONS='", false).toString();
        string = string + this.mXMLFileEdit.getText() + "'";
        string = string + SyntaxUtil.getCommand(" MODE=BACK (PREDICTED=", false).toString();
        string = string + string2;
        string = string + SyntaxUtil.getCommand(" SUFFIX='", false).toString();
        string = string + this.mNewFieldSuffix.getText() + "')";
        string = string + SyntaxUtil.terminateSyntax();
        string = string + SyntaxUtil.getMainCommand("EXECUTE.").toString();
        return string;
    }

    @Override
    public final String getIActionKey() {
        return "transform_prepare_data_for_modeling_backtransform_score";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_adp_backtransform";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mBrowseButton) {
            String string = this.showOpenDialog();
            this.mXMLFileEdit.setText(string);
        }
        this.changeOKPasteState();
    }

    @Override
    public void loadDialogState() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string = dialogDataModel.getString(NEW_FIELD_SUFFIX);
        if (string != null && string.length() > 0) {
            this.mNewFieldSuffix.setText(string);
        }
        if ((string = dialogDataModel.getString(XML_FILE_PATH)) != null && string.length() > 0) {
            this.mXMLFileEdit.setText(string);
        }
        this.changeOKPasteState();
        super.loadDialogState();
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putString(NEW_FIELD_SUFFIX, this.mNewFieldSuffix.getText());
        dialogDataModel.putString(XML_FILE_PATH, this.mXMLFileEdit.getText());
    }

    private String showOpenDialog() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), true);
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_BTS_XML_FILE_FILTER"), this.getResString("IDS_BTS_XML_FILE_EXT")));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = remoteFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            String string = remoteFileChooser.getSelectedFilePath();
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            return string;
        }
        return "";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mXMLFileEdit.setText("");
        this.setDefaults();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.changeOKPasteState();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.changeOKPasteState();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.changeOKPasteState();
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.changeOKPasteState();
    }

    private void changeOKPasteState() {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0 && this.mNewFieldSuffix.getText().trim().length() > 0 && this.mXMLFileEdit.getText().trim().length() > 0);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.pack();
    }

    protected void initVars() {
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.addVarFilter(new SplitVarAndWeightVarFilter());
        this.mTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetVarList.setIdentifier("BackTransformVar");
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() + 2));
        this.mTargetVarList.addVarFilter(new SplitVarAndWeightVarFilter());
        this.mTargetScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mTargetScrollPane.setHorizontalScrollBarPolicy(31);
        this.mTargetScrollPane.setVerticalScrollBarPolicy(21);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mNewFieldSuffix = new StringTextField();
        this.mNewFieldSuffix.setColumns(30);
        this.mSuffixLabel = DialogUtil.createLabel(this, "IDS_BTS_NEW_FIELD_SUFFIX_LABEL");
        this.mSuffixLabel.setLabelFor((Component)((Object)this.mNewFieldSuffix));
        this.mNewFieldSuffix.addCaretListener(this);
        this.mXMLFileEdit = new FileTextField();
        this.mXMLFileEdit.setColumns(40);
        this.mXMLFileEdit.addCaretListener(this);
        this.mXMLFileLabel = DialogUtil.createLabel(this, "IDS_BTS_XML_FILE_LABEL");
        this.mXMLFileLabel.setLabelFor((Component)((Object)this.mXMLFileEdit));
        this.mBrowseButton = DialogUtil.createButton(this, "IDS_OPTIMAL_BINNING_SAVE_BROWSE_BUTTON", null);
        this.mBrowseButton.setEnabled(true);
        this.mBrowseButton.addActionListener(this);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mesgArea);
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mNewFieldSuffix);
        vector.add(this.mXMLFileEdit);
        vector.add(this.mBrowseButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupViewPanel(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_BTS_SRC_VARLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_BTS_TARGET_VAR_LABEL");
        jLabel2.setLabelFor(this.mTargetVarList);
        this.mesgArea = new JTextArea();
        this.mesgArea.setRows(3);
        this.mesgArea.setFont(jLabel.getFont());
        this.mesgArea.setOpaque(false);
        this.mesgArea.setLineWrap(true);
        this.mesgArea.setWrapStyleWord(true);
        this.mesgArea.setText(this.getResString("IDS_BTS_MESG"));
        this.mesgArea.setFocusable(true);
        this.mesgArea.setEditable(false);
        this.mesgArea.setEnabled(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mesgArea, gridBagConstraints, 0, 0, 3, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 2, 1, 1, n, null);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane, gridBagConstraints, 2, 2, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, 8, 0, 8);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        insets.set(15, 0, 15, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupXMLFilePanel(), gridBagConstraints, 0, 3, 3, 1, n, insets);
        return jPanel;
    }

    private JPanel setupXMLFilePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, n2 - 4, n2, n2 - 4);
        DialogUtil.addUsingGBL(jPanel, this.mSuffixLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNewFieldSuffix), gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(n2, n2 - 4, n2, -n2 * 8);
        DialogUtil.addUsingGBL(jPanel, this.mXMLFileLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, -n2 * 8, n2, n2 - 4);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mXMLFileEdit), gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 - 4, n2, n2 - 4);
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 2, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void setDefaults() {
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        this.mNewFieldSuffix.setText(this.getResString(DEFAULT_SUFFIX));
    }

    private boolean hasInValidSpssNameChar(String string) {
        int n;
        String string2 = "";
        if (this.mTargetVarList.getModel().getSize() > 0) {
            string2 = this.mTargetVarList.getModel().getElementAt(0).getName();
        }
        return (n = VarNameValidator.validateSPSSName((String)(string2 + string), (boolean)true).asInt()) > 0 && n != 100;
    }

    private boolean isNameTooLong(String string) {
        int n;
        try {
            n = string.getBytes(ComponentState.getCurrentCharsetName()).length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            n = string.length();
        }
        return n < 1 || n > 64;
    }

    private void setSelection(final JTextField jTextField) {
        jTextField.setSelectionStart(0);
        jTextField.setSelectionEnd(jTextField.getText().length());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jTextField.requestFocusInWindow();
            }
        });
    }

    private class SplitVarAndWeightVarFilter
    implements IVarFilter {
        private SplitVarAndWeightVarFilter() {
        }

        @Override
        public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
            LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.getNSplitVars();
            if (iSpssVariable != null && iSpssVariable.getId().equals((Object)iSpssDataSrc.getWeightVarId())) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable2 = iSpssDataSrc.getVariable(iSpssDataSrc.getSplitVarIndex(i));
                if (iSpssVariable == null || iSpssVariable2 == null || !iSpssVariable.getId().equals((Object)iSpssVariable2.getId())) continue;
                return false;
            }
            return true;
        }
    }
}

