/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.optimal_binning;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.transform.optimal_binning.OptimalBinningDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class VariablesTab
extends BaseProcedureTab
implements ListDataListener {
    private static final String IDS_VARIABLES_TO_BIN_LIST_KEY = "IDS_VARIABLES_TO_BIN_LIST";
    private static final String IDS_OPTIMIZE_BINS_LIST_KEY = "IDS_OPTIMIZE_BINS_LIST";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mVarsToBinList;
    private TargetVariableList mOptimizeBinsList;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mVarsToBinScrollPane;
    private JScrollPane mOptimizeBinsScrollPane;
    private ArrowButton mVarsToBinArrowButton;
    private ArrowButton mOptimizeBinsArrowButton;

    public VariablesTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.checkEnableOKPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.checkEnableOKPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.checkEnableOKPaste();
    }

    @Override
    public void reset() {
        super.reset();
        this.mVarsToBinList.removeAll();
        this.mOptimizeBinsList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.removeWeightedVar();
        ((OptimalBinningDlg)this.mParent).enableOkPaste(false);
        this.mVarsToBinArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mOptimizeBinsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mVarsToBinArrowButton.setEnabled(true);
        this.mOptimizeBinsArrowButton.setEnabled(true);
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_vars_panel";
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.addComponents(this);
    }

    @Override
    protected void aboutToShowTab() {
        this.setFocusTraversalPolicy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VariablesTab.this.mSrcVarList.requestFocus();
                if (VariablesTab.this.mSrcVarList.getSelectedIndex() == -1) {
                    VariablesTab.this.mSrcVarList.setSelectedIndex(0);
                }
            }
        });
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mSrcVarList;
    }

    String getVariablesTabSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/VARIABLES GUIDE="));
        stringBuffer.append(this.mOptimizeBinsList.getModel().getElementAt(0).getName() + " ");
        stringBuffer.append("BIN=" + this.mVarsToBinList.getVariablesStringList());
        return stringBuffer.toString();
    }

    ISpssVariable[] getVarsToBin() {
        int n = this.mVarsToBinList.getModel().getSize();
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[n];
        for (int i = 0; i < n; ++i) {
            iSpssVariableArray[i] = this.mVarsToBinList.getModel().getElementAt(i);
        }
        return iSpssVariableArray;
    }

    ISpssVariable[] getVariables() {
        int n = this.mSrcVarList.getModel().getSize();
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[n];
        for (int i = 0; i < n; ++i) {
            iSpssVariableArray[i] = this.mSrcVarList.getModel().getElementAt(i);
        }
        return iSpssVariableArray;
    }

    ISpssVariable getGuideVariable() {
        ISpssVariable iSpssVariable = null;
        try {
            iSpssVariable = this.mOptimizeBinsList.getModel().getElementAt(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iSpssVariable;
    }

    private void removeWeightedVar() {
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            VarListModel varListModel = this.mSrcVarList.getModel();
            int n = iSpssDataSrc.getWeightVarIndex();
            if (n != -1) {
                varListModel.removeElement(iSpssDataSrc.getVariable(n));
            }
        }
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.removeWeightedVar();
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mVarsToBinList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mVarsToBinList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mVarsToBinList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mVarsToBinList.getFixedCellHeight() * 12 + 2));
        this.mVarsToBinScrollPane = new JScrollPane(this.mVarsToBinList);
        this.mVarsToBinScrollPane.setPreferredSize(this.mVarsToBinList.getMinimumSize());
        this.mVarsToBinList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mVarsToBinList.setIdentifier(IDS_VARIABLES_TO_BIN_LIST_KEY);
        this.mVarsToBinList.getModel().addListDataListener(this);
        this.mOptimizeBinsList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mOptimizeBinsList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mOptimizeBinsScrollPane = new JScrollPane(this.mOptimizeBinsList);
        this.mOptimizeBinsScrollPane.setHorizontalScrollBarPolicy(31);
        this.mOptimizeBinsScrollPane.setVerticalScrollBarPolicy(21);
        this.mOptimizeBinsScrollPane.setPreferredSize(this.mOptimizeBinsList.getMinimumSize());
        this.mOptimizeBinsList.setIdentifier(IDS_OPTIMIZE_BINS_LIST_KEY);
        this.mOptimizeBinsList.getModel().addListDataListener(this);
        this.mVarsToBinArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mVarsToBinArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mVarsToBinArrowButton.registerVariableList(this.mVarsToBinList, SpssArrowButton.ButtonOrientation.left);
        this.mOptimizeBinsArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mOptimizeBinsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mOptimizeBinsArrowButton.registerVariableList(this.mOptimizeBinsList, SpssArrowButton.ButtonOrientation.left);
    }

    private void addComponents(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_OPTIMAL_BINNING_VARIABLES_VAR_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_OPTIMAL_BINNING_VARIABLES_OPTIMIZE_BINS_LABEL");
        jLabel2.setLabelFor(this.mOptimizeBinsList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getArrowButtonInsets();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n, 0, 0, 0);
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 3, n2, null);
        n2 = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mVarsToBinArrowButton, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.setupVarToBinImageAndLabel(), gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mVarsToBinScrollPane, gridBagConstraints, 2, 1, 1, 1, n2, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.setupOptimizeBinsImageAndLabel(), gridBagConstraints, 2, 2, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mOptimizeBinsScrollPane, gridBagConstraints, 2, 3, 1, 1, n2, null);
        n2 = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets3 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mOptimizeBinsArrowButton, gridBagConstraints, 1, 2, 1, 2, n2, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.setupInfoMessagePanel(jLabel.getFont()), gridBagConstraints, 0, 4, 3, 1, n2, insets2);
    }

    private JPanel setupVarToBinImageAndLabel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        ImageIcon imageIcon = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SCALE_VAR_IMAGE")));
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_OPTIMAL_BINNING_VARIABLES_VARS_TO_BIN_LABEL");
        jLabel.setIcon(imageIcon);
        jLabel.setLabelFor(this.mVarsToBinList);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupOptimizeBinsImageAndLabel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        ImageIcon imageIcon = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_NOMINAL_VAR_IMAGE")));
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_OPTIMAL_BINNING_VARIABLES_OPTIMIZE_BINS_LABEL");
        jLabel.setIcon(imageIcon);
        jLabel.setLabelFor(this.mOptimizeBinsList);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupInfoMessagePanel(Font font) {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(uRL));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_OPTIMAL_BINNING_VARIABLES_MULTILINE_ONE_MESSAGE"), 2, 40);
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFont(font);
        jTextArea.setFocusable(false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 0, 1, 1, n, null);
        JTextArea jTextArea2 = new JTextArea(this.getResString("IDS_OPTIMAL_BINNING_VARIABLES_MULTILINE_TWO_MESSAGE"), 2, 40);
        jTextArea2.setOpaque(false);
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setFont(font);
        jTextArea2.setFocusable(false);
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jTextArea2, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mVarsToBinArrowButton);
        vector.add(this.mOptimizeBinsArrowButton);
        vector.add(this.mVarsToBinList);
        vector.add(this.mOptimizeBinsList);
        JPanel jPanel = ((BaseTabbedDialog)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        vector.add(((OptimalBinningDlg)this.mParent).getTabbedPane());
        this.setComponentOrder(vector);
    }

    private void checkEnableOKPaste() {
        ((OptimalBinningDlg)this.mParent).enableOkPaste(this.mVarsToBinList.getModel().getSize() > 0 && this.mOptimizeBinsList.getModel().getSize() == 1);
    }
}

