/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.optimal_binning;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.transform.optimal_binning.OptimalBinningDlg;
import com.spss.java_client.ui.dialogs.base.transform.optimal_binning.VariablesTab;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class SaveTab
extends BaseProcedureTab
implements ItemListener,
FocusListener {
    private JCheckBox mChkCreateVariable;
    private StringTextField mTxtSuffix;
    private FileTextField mTxtFile;
    private JCheckBox mChkReplace;
    private RemoteFileChooser mFileChooser;
    private JButton mCmdBrowse;
    private JLabel mLblSuffix;
    private StringBuffer mDeleteSyntax;
    private StringBuffer mIntoSyntax;
    private boolean mOKPressed;

    public SaveTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_SAVE_PANEL";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mChkCreateVariable)) {
            if (this.mChkCreateVariable.isSelected()) {
                this.mTxtSuffix.setEnabled(true);
                this.mChkReplace.setEnabled(true);
                this.mLblSuffix.setEnabled(true);
                this.mTxtSuffix.setOpaque(true);
            } else {
                this.mTxtSuffix.setEnabled(false);
                this.mChkReplace.setEnabled(false);
                this.mLblSuffix.setEnabled(false);
                this.mTxtSuffix.setOpaque(false);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object.equals(this.mTxtSuffix)) {
            this.mTxtSuffix.selectAll();
        }
        if (object.equals(this.mTxtFile)) {
            this.mTxtFile.selectAll();
        }
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        this.setupGUI();
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        this.setFocusTraversalPolicy();
    }

    @Override
    protected boolean validateTab() {
        boolean bl = true;
        if (this.mChkCreateVariable.isSelected()) {
            String string = "";
            int n = VarNameValidator.validateSPSSName((String)this.mTxtSuffix.getText(), (boolean)true).asInt();
            if (n == 0) {
                bl = true;
            } else {
                bl = false;
                string = this.getResString("ERR_OPTIMAL_BINNING_SAVE_WARNING");
            }
            if (!bl) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, string, VersionInfo.getAppVersionString());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SaveTab.this.mTxtSuffix.requestFocus();
                        SaveTab.this.mTxtSuffix.selectAll();
                    }
                });
                return false;
            }
            VariablesTab variablesTab = ((OptimalBinningDlg)this.mParent).getMVariablesTab();
            ISpssVariable[] iSpssVariableArray = variablesTab.getVariables();
            ISpssVariable[] iSpssVariableArray2 = variablesTab.getVarsToBin();
            ISpssVariable iSpssVariable = variablesTab.getGuideVariable();
            ISpssVariable[] iSpssVariableArray3 = new ISpssVariable[iSpssVariableArray.length + iSpssVariableArray2.length];
            int n2 = 0;
            int n3 = 0;
            for (n3 = 0; n3 < iSpssVariableArray.length; ++n3) {
                iSpssVariableArray3[n2++] = iSpssVariableArray[n3];
            }
            for (n3 = 0; n3 < iSpssVariableArray2.length; ++n3) {
                iSpssVariableArray3[n2++] = iSpssVariableArray2[n3];
            }
            if (this.isExceed64Bytes(iSpssVariableArray2)) {
                if (bl) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_OPTIMAL_BINNING_SAVE_EXCEED_VARIABLE_NAME_WARNING"), VersionInfo.getAppVersionString());
                }
                bl = false;
                return bl;
            }
            String string2 = new String();
            string2 = this.isDuplicateInSource(iSpssVariableArray3, iSpssVariableArray2, iSpssVariable);
            if (!this.mChkReplace.isSelected() && string2.length() > 0) {
                if (!bl) {
                    return false;
                }
                this.showDuplicateVarsWarning(string2);
                bl = false;
                if (!this.mOKPressed) {
                    return this.mOKPressed;
                }
            }
        }
        if (this.mTxtFile.getText().length() > 0 && bl) {
            return FileValidator.validatePath(this, this.mTxtFile.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection());
        }
        return super.validateTab();
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mChkCreateVariable;
    }

    String getIntoSyntax() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.mChkCreateVariable.isSelected()) {
            stringBuffer.append("SAVE=YES (INTO=");
            if (this.mIntoSyntax.length() > 0) {
                stringBuffer.append(this.mIntoSyntax);
            }
            stringBuffer.append(")\n");
        }
        return stringBuffer.toString();
    }

    String getDeleteSyntax() {
        if (this.validateTab() && this.mDeleteSyntax.length() > 0) {
            String string = new String();
            string = SyntaxUtil.getMainCommand("DELETE VARIABLES").toString();
            string = string + SyntaxUtil.getMainCommandParamters(this.mDeleteSyntax.toString()).toString();
            return string;
        }
        return null;
    }

    String getRulesFiles() {
        StringBuffer stringBuffer = new StringBuffer("");
        try {
            if (this.mTxtFile.getText().trim().length() > 0) {
                stringBuffer.append(SyntaxUtil.getSubCommand("/OUTFILE RULES="));
                stringBuffer.append(CharacterUtil.smartQuote((String)this.mTxtFile.getText().trim()));
                stringBuffer.append("\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    String getRulesPerAttributes() {
        String string;
        String string2 = "";
        PesFile pesFile = PES_Repository.getPesFile((String)this.mTxtFile.getText().trim());
        if (pesFile != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            string2 = string2 + string;
        }
        return string2;
    }

    private void initVars() {
        this.mChkCreateVariable = new JCheckBox(new ToggleButtonAction(this.mParent, "IDS_OPTIMAL_BINNING_SAVE_BINNED_DATA_CHECK"));
        this.mChkCreateVariable.addItemListener(this);
        this.mChkReplace = new JCheckBox(new ToggleButtonAction(this.mParent, "IDS_OPTIMAL_BINNING_SAVE_REPLACE_CHECK"));
        this.mTxtSuffix = new StringTextField(15);
        this.mTxtSuffix.setOpaque(false);
        this.mTxtSuffix.addFocusListener(this);
        this.mTxtSuffix.setAction(new TextFieldAction(this.mParent, "IDS_SUFFIX_TEXT"));
        this.mLblSuffix = DialogUtil.createLabel(this.mParent, "IDS_OPTIMAL_BINNING_SAVE_SUFFIX_TEXT");
        this.mLblSuffix.setLabelFor((Component)((Object)this.mTxtSuffix));
        this.mTxtFile = new FileTextField();
        this.mTxtFile.setColumns(30);
        this.mTxtFile.addFocusListener(this);
        this.mTxtFile.setAction(new TextFieldAction(this.mParent, "IDS_FILE_TEXT"));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_OPTIMAL_BINNING_SAVE_BROWSE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SaveTab.this.openSaveDialog();
            }
        };
        this.mCmdBrowse = new JButton(toggleButtonAction);
        this.mDeleteSyntax = new StringBuffer();
        this.mIntoSyntax = new StringBuffer();
    }

    private void setDefaults() {
        this.mLblSuffix.setEnabled(false);
        this.mTxtSuffix.setEnabled(false);
        this.mChkReplace.setEnabled(false);
        this.mChkReplace.setSelected(false);
        this.mChkCreateVariable.setSelected(false);
        this.mTxtSuffix.setText(this.getResString("IDS_OPTIMAL_BINNING_SAVE_BIN_VALUE"));
        this.mTxtFile.setText("");
    }

    private void setupGUI() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, this.setupSaveVariablesPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2.set(DialogUtil.getComponentGroupGap(), 0, insets.bottom, 0);
        DialogUtil.addUsingGBL(this, this.setupSaveRulesPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets2);
    }

    private JPanel setupSaveVariablesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left * 2, insets.bottom, insets.right);
        jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_OPTIMAL_BINNING_SAVE_ACTIVA_DATASHEET_TITLE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mChkCreateVariable, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        insets2.set(insets.top, n2 * 4, insets.bottom, insets.right);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mLblSuffix, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2.set(insets.top, insets.left, insets.bottom, insets.right);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)((Object)this.mTxtSuffix), gridBagConstraints, 1, 0, 1, 1, n, insets2);
        insets2.set(insets.left * 4, 0, insets.top, insets.right);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        insets2.set(insets.left * 4, n2 * 4, insets.bottom, insets.right);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_OPTIMAL_BINNING_SAVE_ONE_LABEL"), 3, 40);
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFont(this.mLblSuffix.getFont());
        jTextArea.setFocusable(false);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        JSeparator jSeparator = new JSeparator();
        jSeparator.setSize(jSeparator.getMinimumSize());
        insets2.set(n2, insets.left * 2, n2, n2 * 3);
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        insets2.set(0, n2 * 4, n2, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mChkReplace, gridBagConstraints, 0, 4, 2, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupSaveRulesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_OPTIMAL_BINNING_SAVE_RULE_TITLE"));
        JLabel jLabel = new JLabel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jLabel = DialogUtil.createLabel(this.mParent, "IDS_OPTIMAL_BINNING_SAVE_FILE_FILETEXT");
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        jLabel.setLabelFor((Component)((Object)this.mTxtFile));
        insets2.set(insets.top, 0, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTxtFile), gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mCmdBrowse, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_OPTIMAL_BINNING_SAVE_SPECIFY_FILE_LABEL"), 2, 40);
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFont(jLabel.getFont());
        jTextArea.setFocusable(false);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 1, 2, 1, n, insets2);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        this.mComponentOrder.add(((OptimalBinningDlg)this.mParent).getTabbedPane());
        vector.add(this.mChkCreateVariable);
        vector.add(this.mTxtSuffix);
        vector.add(this.mChkReplace);
        vector.add(this.mTxtFile);
        vector.add(this.mCmdBrowse);
        this.setComponentOrder(vector);
    }

    private void openSaveDialog() {
        DataServerProxy dataServerProxy = DataServerProxy.getDataProxy();
        this.mFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Syntax, FileLocationsUtil.getDataFilesDirectoryPath(), dataServerProxy.isRemoteConnection());
        this.mFileChooser.setDialogTitle(this.getResString("IDS_OPTIMAL_BINNING_SAVE_DIALOG_TITLE"));
        String string = this.getResString("IDS_OPTIMAL_BINNING_SAVE_SPSS_EXTENSION");
        String string2 = this.getResString("IDS_OPTIMAL_BINNING_SAVE_SPSS_FILTER");
        this.mFileChooser.setFileSelectionMode(0);
        this.mFileChooser.setFileFilter((FileFilter)new RefFileFilter(string2, string));
        this.mFileChooser.setAcceptAllFileFilterUsed(false);
        int n = this.mFileChooser.showSaveDialog((Component)this.mParent);
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)this.mFileChooser.getCurrentDirectory().getAbsolutePath());
            this.mTxtFile.setText(this.mFileChooser.getSelectedFilePath());
        }
    }

    private String isDuplicateInSource(ISpssVariable[] iSpssVariableArray, ISpssVariable[] iSpssVariableArray2, ISpssVariable iSpssVariable) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = new String();
        this.mIntoSyntax.delete(0, this.mIntoSyntax.length());
        this.mDeleteSyntax.delete(0, this.mDeleteSyntax.length());
        for (int i = 0; i < iSpssVariableArray2.length; ++i) {
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(iSpssVariableArray2[i].getName());
            stringBuffer.append("_");
            stringBuffer.append(this.mTxtSuffix.getText().trim());
            if (iSpssVariable != null && stringBuffer.toString().equals(iSpssVariable.getName())) {
                stringBuffer.append("1");
            }
            this.mIntoSyntax.append(stringBuffer.toString() + " ");
            for (int j = 0; j < iSpssVariableArray.length; ++j) {
                if (!stringBuffer.toString().equals(iSpssVariableArray[j].getName())) continue;
                if (string == null) {
                    string = "";
                }
                string = string + iSpssVariableArray[j].getName() + "\n";
                this.mDeleteSyntax.append(iSpssVariableArray[j].getName());
                this.mDeleteSyntax.append(" ");
            }
        }
        if (this.mDeleteSyntax.length() > 0) {
            this.mDeleteSyntax.delete(this.mDeleteSyntax.length() - 1, this.mDeleteSyntax.length());
        }
        if (this.mIntoSyntax.length() > 0) {
            this.mIntoSyntax.delete(this.mIntoSyntax.length() - 1, this.mIntoSyntax.length());
        }
        return string;
    }

    private boolean isExceed64Bytes(ISpssVariable[] iSpssVariableArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mTxtSuffix.getText().trim().length() > 64) {
            return true;
        }
        if (this.mChkCreateVariable.isSelected()) {
            for (int i = 0; i < iSpssVariableArray.length; ++i) {
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append(iSpssVariableArray[i].getName());
                stringBuffer.append("_");
                stringBuffer.append(this.mTxtSuffix.getText().trim());
                if (stringBuffer.length() <= 64) continue;
                return true;
            }
        }
        return false;
    }

    private void showDuplicateVarsWarning(String string) {
        new WarningDialog(this.mParent, string);
    }

    private class WarningDialog
    extends BaseDialog
    implements FocusListener,
    KeyListener {
        private JTextArea mVarArea;
        private JButton mOkButton;
        private JButton mCancelButton;

        WarningDialog(BaseDialog baseDialog, String string) {
            super(baseDialog, baseDialog.getResString("IDS_OPTIMAL_BINNING_TITLE"), true, baseDialog.getResourceBundle(), baseDialog.getImageFilePath());
            this.doInit(string);
            this.pack();
            this.setLocationRelativeTo((Component)baseDialog);
            this.setVisible(true);
        }

        private void doInit(String string) {
            this.initVars(string);
            this.addComponents();
            this.mCmdButtonPanel = this.setupCmdButtons();
            UIToolDialogUtil.normalizeButtonWidths((JPanel)this.mCmdButtonPanel);
            this.mViewPanel.getParent().add((Component)this.mCmdButtonPanel, "South");
        }

        private void initVars(String string) {
            this.mVarArea = new JTextArea(string.trim());
            this.mVarArea.setMinimumSize(new Dimension(350, 100));
            this.mVarArea.setEditable(false);
            this.mVarArea.setOpaque(false);
            this.mVarArea.addFocusListener(this);
            this.mVarArea.addKeyListener(this);
            AbstractAction abstractAction = new AbstractAction(ResUtil.getCommonDlgString("IDS_OK")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SaveTab.this.mChkReplace.setSelected(true);
                    SaveTab.this.mOKPressed = true;
                    WarningDialog.this.dispose();
                }
            };
            this.mOkButton = new JButton(abstractAction);
            this.mOkButton.addKeyListener(this);
            abstractAction = new AbstractAction(ResUtil.getCommonDlgString("IDS_CANCEL")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SaveTab.this.mOKPressed = false;
                    WarningDialog.this.dispose();
                }
            };
            this.mCancelButton = new JButton(abstractAction);
            this.mCancelButton.addKeyListener(this);
        }

        private void addComponents() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets = UIToolDialogUtil.getStandardDialogInsets();
            Insets insets2 = new Insets(insets.top, insets.left, 0, insets.right);
            int n = 23;
            JLabel jLabel = DialogUtil.createLabel((BaseDialog)this.getParent(), "IDS_OPTIMAL_BINNING_VARIABLE_REPLACE_WARNING_LABEL");
            jLabel.setLabelFor(this.mVarArea);
            DialogUtil.addUsingGBL(this.mViewPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            insets2.set(0, insets2.left, 0, insets2.right);
            JScrollPane jScrollPane = new JScrollPane(this.mVarArea);
            jScrollPane.setAutoscrolls(true);
            jScrollPane.setPreferredSize(this.mVarArea.getMinimumSize());
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
            DialogUtil.addUsingGBL(this.mViewPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        }

        private JPanel setupCmdButtons() {
            JPanel jPanel = new JPanel(true);
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                FlowLayout flowLayout = new FlowLayout(2, 5, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mCancelButton);
                jPanel.add(this.mOkButton);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, 5, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOkButton);
                jPanel.add(this.mCancelButton);
            }
            this.getRootPane().setDefaultButton(this.mOkButton);
            return jPanel;
        }

        public void doHelp() {
        }

        protected JPanel setupCmdButtonPanel() {
            return null;
        }

        protected void setTabTraversal() {
            Vector<Object> vector = new Vector<Object>();
            vector.add(this.mVarArea);
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                vector.add(this.mCancelButton);
                vector.add(this.mOkButton);
            } else {
                vector.add(this.mOkButton);
                vector.add(this.mCancelButton);
            }
            this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.mVarArea.selectAll();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                if (!keyEvent.getSource().equals(this.mCancelButton)) {
                    SaveTab.this.mChkReplace.setSelected(true);
                    SaveTab.this.mOKPressed = true;
                } else {
                    SaveTab.this.mOKPressed = false;
                }
                this.dispose();
            } else if (keyEvent.getKeyCode() == 27) {
                SaveTab.this.mOKPressed = false;
                this.dispose();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

