/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.optimal_binning;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class OutputTab
extends BaseProcedureTab {
    private JCheckBox mEndpointsCheck;
    private JCheckBox mDescriptiveCheck;
    private JCheckBox mModelCheck;

    public OutputTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void reset() {
        super.reset();
        this.mEndpointsCheck.setSelected(true);
        this.mDescriptiveCheck.setSelected(false);
        this.mModelCheck.setSelected(false);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_output_panel";
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.addComponents(this);
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        this.setFocusTraversalPolicy();
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mEndpointsCheck;
    }

    String getOutputTabSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT"));
        if (!(this.mEndpointsCheck.isSelected() || this.mDescriptiveCheck.isSelected() || this.mModelCheck.isSelected())) {
            stringBuffer.append(" NONE");
            return stringBuffer.toString();
        }
        if (this.mEndpointsCheck.isSelected()) {
            stringBuffer.append(" ENDPOINTS");
        }
        if (this.mDescriptiveCheck.isSelected()) {
            stringBuffer.append(" DESCRIPTIVES");
        }
        if (this.mModelCheck.isSelected()) {
            stringBuffer.append(" ENTROPY");
        }
        return stringBuffer.toString();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_OPTIMAL_BINNING_OUTPUT_ENDPOINTS_FOR_BINS_CHECK");
        this.mEndpointsCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_OPTIMAL_BINNING_OUTPUT_DESCRIPTIVE_STATS_CHECK");
        this.mDescriptiveCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_OPTIMAL_BINNING_OUTPUT_MODEL_ENTROPY_CHECK");
        this.mModelCheck = new JCheckBox(toggleButtonAction);
        this.mEndpointsCheck.setSelected(true);
    }

    private void addComponents(JPanel jPanel) {
        JComponent[] jComponentArray = new JComponent[]{this.mEndpointsCheck, this.mDescriptiveCheck, this.mModelCheck};
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_OPTIMAL_BINNING_OUTPUT_DISPLAY_PANEL"));
        DialogUtil.createButtonGroup(jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mEndpointsCheck);
        vector.add(this.mDescriptiveCheck);
        vector.add(this.mModelCheck);
        this.setComponentOrder(vector);
    }
}

