/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.optimal_binning;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.transform.optimal_binning.OptimalBinningDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class OptionsTab
extends BaseProcedureTab
implements FocusListener,
ItemListener {
    private final int MIN_VALUE = 1;
    private final int MAX_NOBIN = Short.MAX_VALUE;
    private final int MIN_THRESHOLD = 0;
    private JCheckBox mChkPreBin;
    private JCheckBox mChkMergeBin;
    private JRadioButton mRdoInclusive;
    private JRadioButton mRdoExclusive;
    private JRadioButton mRdoFirstUnbounded;
    private JRadioButton mRdoFirstBounded;
    private JRadioButton mRdoLastUnbounded;
    private JRadioButton mRdoLastBounded;
    private OptimalBinningIntTextField mTxtMaxBins;
    private JLabel mLblThreshold;
    private JLabel mLblMaxNosBins;
    private OptimalBinningFloatTextField mTxtThreshold;
    private SpssButtonGroup mGrpEndpoints;
    private SpssButtonGroup mGrpFirstBin;
    private SpssButtonGroup mGrpLastBin;

    public OptionsTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_OPTIONS_PANEL";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object.equals((Object)this.mTxtMaxBins)) {
            this.mTxtMaxBins.selectAll();
        }
        if (object.equals((Object)this.mTxtThreshold)) {
            this.mTxtThreshold.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object.equals((Object)this.mTxtMaxBins)) {
            this.mTxtMaxBins.select(0, 0);
        }
        if (object.equals((Object)this.mTxtThreshold)) {
            this.mTxtThreshold.select(0, 0);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mChkPreBin)) {
            if (this.mChkPreBin.isSelected()) {
                this.mLblMaxNosBins.setEnabled(true);
                this.mTxtMaxBins.setEnabled(true);
                this.mTxtMaxBins.setOpaque(true);
            } else {
                this.mLblMaxNosBins.setEnabled(false);
                this.mTxtMaxBins.setEnabled(false);
                this.mTxtMaxBins.setOpaque(false);
            }
        }
        if (itemEvent.getSource().equals(this.mChkMergeBin)) {
            if (this.mChkMergeBin.isSelected()) {
                this.mLblThreshold.setEnabled(true);
                this.mTxtThreshold.setOpaque(true);
                this.mTxtThreshold.setEnabled(true);
            } else {
                this.mLblThreshold.setEnabled(false);
                this.mTxtThreshold.setOpaque(false);
                this.mTxtThreshold.setEnabled(false);
            }
        }
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        this.setupGUI();
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        this.setFocusTraversalPolicy();
    }

    @Override
    protected boolean validateTab() {
        if (this.mChkPreBin.isSelected()) {
            int n;
            try {
                n = Integer.parseInt(this.mTxtMaxBins.getText());
            }
            catch (Exception exception) {
                n = 0;
            }
            if (n <= 1 || n > Short.MAX_VALUE) {
                NumberFormat numberFormat = NumberFormat.getNumberInstance(ResUtil.getLocale());
                String string = MessageFormat.format(ResUtil.getString("ERR_WARNING_MSG"), numberFormat.format(2L), numberFormat.format(32767L));
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, string, VersionInfo.getAppVersionString());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptionsTab.this.mTxtMaxBins.requestFocus();
                        OptionsTab.this.mTxtMaxBins.selectAll();
                    }
                });
                return false;
            }
        }
        if (this.mChkMergeBin.isSelected()) {
            double d;
            try {
                d = Double.parseDouble(this.mTxtThreshold.getText());
            }
            catch (Exception exception) {
                d = -1.0;
            }
            if (d < 0.0 || d >= 1.0) {
                NumberFormat numberFormat = NumberFormat.getNumberInstance(ResUtil.getLocale());
                String string = MessageFormat.format(ResUtil.getString("ERR_WARNING_INCLUDE_MIN_MSG"), numberFormat.format(0L), numberFormat.format(1L));
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, string, VersionInfo.getAppVersionString());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptionsTab.this.mTxtThreshold.requestFocus();
                        OptionsTab.this.mTxtThreshold.selectAll();
                    }
                });
                return false;
            }
        }
        return super.validateTab();
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mChkPreBin;
    }

    String getOptionsTabSyntax() {
        StringBuffer stringBuffer = new StringBuffer(" PREPROCESS=");
        if (this.mChkPreBin.isSelected()) {
            stringBuffer.append("EQUALFREQ (BINS=");
            stringBuffer.append(this.mTxtMaxBins.getText());
            stringBuffer.append(")");
        } else {
            stringBuffer.append("NONE");
        }
        stringBuffer.append(" FORCEMERGE=");
        if (this.mChkMergeBin.isSelected()) {
            stringBuffer.append(this.mTxtThreshold.getText());
        } else {
            stringBuffer.append("0");
        }
        if (this.mRdoInclusive.isSelected()) {
            stringBuffer.append(" LOWERLIMIT=INCLUSIVE");
        } else {
            stringBuffer.append(" LOWERLIMIT=EXCLUSIVE");
        }
        if (this.mRdoFirstUnbounded.isSelected()) {
            stringBuffer.append(" LOWEREND=UNBOUNDED");
        } else {
            stringBuffer.append(" LOWEREND=OBSERVED");
        }
        if (this.mRdoLastUnbounded.isSelected()) {
            stringBuffer.append(" UPPEREND=UNBOUNDED");
        } else {
            stringBuffer.append(" UPPEREND=OBSERVED");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private void setDefaults() {
        this.mChkPreBin.setSelected(true);
        this.mTxtMaxBins.setText("1000");
        this.mChkMergeBin.setSelected(false);
        this.mLblThreshold.setEnabled(false);
        this.mTxtThreshold.setOpaque(false);
        this.mTxtThreshold.setEnabled(false);
        this.mTxtThreshold.setText("");
        this.mRdoInclusive.setSelected(true);
        this.mRdoFirstUnbounded.setSelected(true);
        this.mRdoLastUnbounded.setSelected(true);
    }

    private void initVars() {
        this.mChkPreBin = new JCheckBox(new ToggleButtonAction(this.mParent, "IDS_OPTIMAL_BINNING_OPTIONS_PRE_BIN_CHECK"));
        this.mChkMergeBin = new JCheckBox(new ToggleButtonAction(this.mParent, "IDS_OPTIMAL_BINNING_OPTIONS_MERGE_BIN_CHECK"));
        this.mRdoInclusive = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_OPTIMAL_BINNING_OPTIONS_LOWER_INCLUSIVE_RADIO"));
        this.mRdoExclusive = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_OPTIMAL_BINNING_OPTIONS_LOWER_EXLUSIVE_RADIO"));
        this.mRdoFirstBounded = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_OPTIMAL_BINNING_OPTIONS_FIRST_BOUNDED_RADIO"));
        this.mRdoFirstUnbounded = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_OPTIMAL_BINNING_OPTIONS_FIRST_UNBOUNDED_RADIO"));
        this.mRdoLastBounded = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_OPTIMAL_BINNING_OPTIONS_LAST_BOUNDED_RADIO"));
        this.mRdoLastUnbounded = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_OPTIMAL_BINNING_OPTIONS_LAST_UNBOUNDED_RADIO"));
        this.mTxtMaxBins = new OptimalBinningIntTextField();
        this.mTxtMaxBins.setPreferredSize(new Dimension(130, 19));
        this.mTxtMaxBins.setAction(new TextFieldAction(this.mParent, "IDS_MAX_BIN_TEXT"));
        this.mTxtMaxBins.addFocusListener(this);
        this.mTxtThreshold = new OptimalBinningFloatTextField();
        this.mTxtThreshold.setAction(new TextFieldAction(this.mParent, "IDS_THRESHOLD_RATIO_TEXT"));
        this.mTxtThreshold.addFocusListener(this);
        this.mLblThreshold = DialogUtil.createLabel(this.mParent, "IDS_OPTIMAL_BINNING_OPTIONS_THRESHOLD_RATIO_TEXT");
        this.mLblThreshold.setLabelFor((Component)((Object)this.mTxtThreshold));
        this.mLblMaxNosBins = DialogUtil.createLabel(this.mParent, "IDS_OPTIMAL_BINNING_OPTIONS_MAX_BIN_TEXT");
        this.mLblMaxNosBins.setLabelFor((Component)((Object)this.mTxtMaxBins));
        this.mChkMergeBin.addItemListener(this);
        this.mChkPreBin.addItemListener(this);
    }

    private void setupGUI() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, this.setupPreprocessingPanel(), gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(this, this.setupSparselyPanel(), gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(this, this.setupBinEndpointsPanel(), gridBagConstraints, 0, 2, 2, 1, n, insets);
        DialogUtil.addUsingGBL(this, this.setupFirstBinPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets);
        insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(this, this.setupLastBinPanel(), gridBagConstraints, 1, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this, new JPanel(), gridBagConstraints, 1, 4, 2, 1, n, insets);
    }

    private JPanel setupPreprocessingPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardButtonInsets();
        Insets insets2 = new Insets(insets.left, insets.top, insets.right, insets.bottom);
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_OPTIMAL_BINNING_OPTIONS_PREPROCESSING_TITLE"));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mChkPreBin, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_OPTIMAL_BINNING_OPTIONS_MAX_BIN_LABEL"), 2, 40);
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setFont(this.mLblMaxNosBins.getFont());
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        insets2.set(insets2.top, n2 * 4, insets2.bottom, insets2.right);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        insets2.set(insets2.right, n2 * 4, insets2.bottom, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mLblMaxNosBins, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        insets2.set(0, n2, insets2.bottom * 3, insets2.right);
        gridBagConstraints.ipadx = 7;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTxtMaxBins), gridBagConstraints, 1, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        this.mComponentOrder.add(((OptimalBinningDlg)this.mParent).getTabbedPane());
        vector.add(this.mChkPreBin);
        vector.add((Object)this.mTxtMaxBins);
        vector.add(this.mChkMergeBin);
        vector.add((Object)this.mTxtThreshold);
        vector.add(this.mGrpEndpoints);
        vector.add(this.mGrpFirstBin);
        vector.add(this.mGrpLastBin);
        this.setComponentOrder(vector);
    }

    private JPanel setupSparselyPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_OPTIMAL_BINNING_OPTIONS_SPARSELY_TITLE"));
        JLabel jLabel = new JLabel();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mChkMergeBin, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.set(DialogUtil.getComponentGroupGap(), n2 * 4, insets2.bottom, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mLblThreshold, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        insets2.set(insets.left * 3, insets.left, insets.bottom, insets.right);
        gridBagConstraints.ipadx = -5;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTxtThreshold), gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.weighty = 1.0;
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_OPTIMAL_BINNING_OPTIONS_MERGE_BIN_LABEL"), 2, 40);
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFont(jLabel.getFont());
        jTextArea.setFocusable(false);
        gridBagConstraints.fill = 2;
        insets2.set(insets.top, n2 * 4, insets2.bottom * 3, insets2.right);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupBinEndpointsPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mRdoInclusive, this.mRdoExclusive};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_OPTIMAL_BINNING_OPTIONS_BIN_ENDPOINTS_TITLE"), 2);
        this.mGrpEndpoints = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupFirstBinPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mRdoFirstUnbounded, this.mRdoFirstBounded};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_OPTIMAL_BINNING_OPTIONS_FIRST_BIN_TITLE"), 2);
        this.mGrpFirstBin = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupLastBinPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mRdoLastUnbounded, this.mRdoLastBounded};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_OPTIMAL_BINNING_OPTIONS_LAST_BIN_TITLE"), 2);
        this.mGrpLastBin = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private class OptimalBinningIntTextField
    extends IntTextField {
        OptimalBinningIntTextField() {
            super(true);
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class OptimalBinningFloatTextField
    extends FloatTextField {
        OptimalBinningFloatTextField() {
            super(0.0, 1.0, -1, true);
            super.setIncludeMaxRange(false);
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

