/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.optimal_binning;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.base.transform.optimal_binning.MissingValueTab;
import com.spss.java_client.ui.dialogs.base.transform.optimal_binning.OptionsTab;
import com.spss.java_client.ui.dialogs.base.transform.optimal_binning.OutputTab;
import com.spss.java_client.ui.dialogs.base.transform.optimal_binning.SaveTab;
import com.spss.java_client.ui.dialogs.base.transform.optimal_binning.VariablesTab;
import com.spss.java_client.ui.dialogs.base.transform.res.TransformResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import java.awt.Window;
import javax.swing.JFrame;

public class OptimalBinningDlg
extends BaseTabbedDialog {
    private VariablesTab mVariablesTab;
    private OutputTab mOutputTab;
    private OptionsTab mOptionTab;
    private SaveTab mSaveTab;
    private MissingValueTab mMissingValueTab;

    public OptimalBinningDlg(JFrame jFrame) {
        super(jFrame, false, TransformResBundle.getDefaultResourceBundleName(), TransformResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_OPTIMAL_BINNING_TITLE"));
    }

    @Override
    public boolean okPastePressed() {
        if (this.mOutputTab.getOutputTabSyntax().equalsIgnoreCase("  /PRINT NONE") && this.mSaveTab.getIntoSyntax().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OPTIMAL_BINNING_OUTPUT_SAVE_SELECTION_WARNING"), VersionInfo.getAppVersionString());
            return false;
        }
        BaseProcedureTab baseProcedureTab = (BaseProcedureTab)this.mTabbedPane.getSelectedComponent();
        if (baseProcedureTab != this.mSaveTab && !this.mSaveTab.validateTab()) {
            this.mTabbedPane.setSelectedIndex(2);
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        String string = this.mSaveTab.getDeleteSyntax();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append("* ").append(this.getResString("IDS_OPTIMAL_BINNING_SYNTAX_TITLE")).append(".");
        stringBuffer.append("\n").append(SyntaxUtil.getMainCommand("OPTIMAL BINNING"));
        stringBuffer.append("\n").append(this.mVariablesTab.getVariablesTabSyntax());
        if (this.mSaveTab.getIntoSyntax().length() > 0) {
            stringBuffer.append(" ").append(this.mSaveTab.getIntoSyntax());
        } else {
            stringBuffer.append(" SAVE=NO\n");
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA METHOD=MDLP"));
        stringBuffer.append(this.mOptionTab.getOptionsTabSyntax());
        stringBuffer.append(this.mMissingValueTab.getMissingValueTabSyntax());
        stringBuffer.append(this.mSaveTab.getRulesFiles());
        stringBuffer.append(this.mOutputTab.getOutputTabSyntax());
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(this.mSaveTab.getRulesPerAttributes());
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "transform_optimal_binning";
    }

    public VariablesTab getMVariablesTab() {
        return this.mVariablesTab;
    }

    @Override
    protected void enableOkPaste(boolean bl) {
        super.enableOkPaste(bl);
    }

    @Override
    protected void init() {
        super.init();
        this.mVariablesTab = new VariablesTab(this);
        this.addTab(this.getResString("IDS_OPTIMAL_BINNING_VARIABLES_CAPTION"), this.mVariablesTab);
        this.mOutputTab = new OutputTab(this);
        this.addTab(this.getResString("IDS_OPTIMAL_BINNING_OUTPUT_CAPTION"), this.mOutputTab);
        this.mSaveTab = new SaveTab(this);
        this.addTab(this.getResString("IDS_OPTIMAL_BINNING_SAVE_CAPTION"), this.mSaveTab);
        this.mMissingValueTab = new MissingValueTab(this);
        this.addTab(this.getResString("IDS_OPTIMAL_BINNING_MISSING_VALUE_CAPTION"), this.mMissingValueTab);
        this.mOptionTab = new OptionsTab(this);
        this.addTab(this.getResString("IDS_OPTIMAL_BINNING_OPTIONS_CAPTION"), this.mOptionTab);
        this.pack();
    }
}

