/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.optimal_binning;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.transform.optimal_binning.OptimalBinningDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class MissingValueTab
extends BaseProcedureTab {
    private JRadioButton mRdoPairwise;
    private JRadioButton mRdoListwise;
    private SpssButtonGroup mGrpBtn;

    public MissingValueTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_MISS_VAL_PANEL";
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        this.setupGUI();
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        this.setFocusTraversalPolicy();
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mRdoPairwise;
    }

    String getMissingValueTabSyntax() {
        StringBuffer stringBuffer = new StringBuffer(SyntaxUtil.getSubCommand("/MISSING SCOPE="));
        if (this.mRdoPairwise.isSelected()) {
            stringBuffer.append("PAIRWISE");
        } else {
            stringBuffer.append("LISTWISE");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private void initVars() {
        this.mRdoListwise = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_OPTIMAL_BINNING_MISSING_VALUE_LISTWISE_RADIO"));
        this.mRdoPairwise = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_OPTIMAL_BINNING_MISSING_VALUE_PAIRWISE_RADIO"));
        this.mGrpBtn = new SpssButtonGroup();
        this.mGrpBtn.add(this.mRdoPairwise);
        this.mGrpBtn.add(this.mRdoListwise);
    }

    private void setDefaults() {
        this.mRdoPairwise.setSelected(true);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        this.mComponentOrder.add(((OptimalBinningDlg)this.mParent).getTabbedPane());
        vector.add(this.mGrpBtn);
        this.setComponentOrder(vector);
    }

    private void setupGUI() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardButtonInsets();
        Insets insets2 = new Insets(DialogUtil.getComponentGroupGap(), 0, insets.bottom, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, this.setupMissinValuesPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets2);
    }

    private JPanel setupMissinValuesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_OPTIMAL_BINNING_MISSING_VALUE_TITLE"));
        JLabel jLabel = new JLabel();
        DialogUtil.addUsingGBL(jPanel, this.mRdoPairwise, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        jLabel = new JLabel(this.getResString("IDS_OPTIMAL_BINNING_MISSING_VALUE_PAIRWISE_LABEL"));
        insets2.set(insets.top, DialogUtil.getComponentGroupGap() * 2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        insets2.set(insets.left * 5, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mRdoListwise, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        jLabel = new JLabel(this.getResString("IDS_OPTIMAL_BINNING_MISSING_VALUE_LIKEWISE_LABEL"));
        insets2.set(insets.top, DialogUtil.getComponentGroupGap() * 2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        insets2.set(insets.left * 5, insets.left * 2, insets.right * 2, insets.right);
        jLabel = new JLabel(this.getResString("IDS_OPTIMAL_BINNING_MISSING_VALUE_USERWISE_LABEL"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        return jPanel;
    }
}

