/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.date_time_wizard;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.DateAndTimeWizardDlg;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.SubtractTwoDurationsPage2Of3;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SubtractTwoDurationsPage3Of3
extends AbstractWizardPage
implements DocumentListener,
FocusListener,
ListSelectionListener {
    static final String CREATE_KEY = "IDS_DNTW_CREATE_VARIABLE";
    static final String PASTE_KEY = "IDS_DNTW_PASTE_SYNTAX";
    static final String DNTW_SUBTRACT_DURATION_STEP_THREE_PAGEID = "DNTW_SUBTRACT_DURATION_STEP_THREE";
    private StringTextField mResultVariableText;
    private StringTextField mVariableText;
    private JRadioButton mCreateRadio;
    private JRadioButton mPasteSyntaxRadio;
    private SpssButtonGroup mGroup;
    private SerializableList mOutFormatList;
    private JScrollPane mOutFormatPane;
    private JLabel mCalculationLabel;
    private SubtractTwoDurationsPage2Of3 mSubtractTwoDurationsPage2Of3;
    private int mCheckResult;
    DialogFocusTraversalPolicy mPolicy;

    public SubtractTwoDurationsPage3Of3(BaseWizardDialog baseWizardDialog) {
        super(DNTW_SUBTRACT_DURATION_STEP_THREE_PAGEID, baseWizardDialog.getResString("IDS_DNTW_STEP_THREE_OF_THREE_TITLE"), baseWizardDialog, true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_dtwz_calculate3c";
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setEnabledFinish();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.setFocus();
        this.setEnabledFinish();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mResultVariableText) && this.mResultVariableText.getText().length() > 0) {
            this.showMessage();
            if (this.mCheckResult == 0) {
                this.mCheckResult = 5;
                this.mVariableText.grabFocus();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setEnabledFinish();
        this.mCheckResult = 3;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setEnabledFinish();
        this.mCheckResult = 3;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setEnabledFinish();
        this.mCheckResult = 3;
    }

    public boolean isPasteSyntaxRadioEnabled() {
        return this.mPasteSyntaxRadio != null && this.mPasteSyntaxRadio.isSelected();
    }

    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("* ").append(this.mWizardDialog.getResString("IDS_DATE_AND_TIME_WIZARD")).append(": ");
        stringBuffer.append(this.mResultVariableText.getText()).append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("COMPUTE "));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText() + "="));
        stringBuffer.append(this.mSubtractTwoDurationsPage2Of3.getDuration1Name().getName()).append(" - ");
        stringBuffer.append(this.mSubtractTwoDurationsPage2Of3.getMinusDuration2Name());
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LABELS"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText()));
        if (this.mVariableText.getText().length() > 0) {
            stringBuffer.append(" \"").append(this.mVariableText.getText()).append("\"");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LEVEL"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText()));
        String string = this.mSubtractTwoDurationsPage2Of3.getDuration1Name().getMeasurementLevel().toString().toUpperCase();
        stringBuffer.append(" (").append(string).append(")");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("FORMATS "));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText() + " ("));
        String string2 = DateAndTimeWizardDlg.mSyntaxFormatMap.get(this.mOutFormatList.getSelectedValue());
        stringBuffer.append(string2).append(")");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE WIDTH "));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText() + "(" + this.getVariableWidth(string2) + ")"));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (SyntaxUtil.readTransformationMergePrefs()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("EXECUTE"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    protected void aboutToShowPanel() {
        this.mSubtractTwoDurationsPage2Of3 = (SubtractTwoDurationsPage2Of3)this.mWizardDialog.getWizardModel().getPage("SubtractTwoDurationsPage2Of3");
        this.mOutFormatList.setSelectedIndex(0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.mWizardDialog.getResString("IDS_DNTW_EXTRACT_CALCULATION_LABEL"));
        stringBuffer.append("               ");
        stringBuffer.append(this.mSubtractTwoDurationsPage2Of3.getDuration1Name().getName());
        stringBuffer.append(" - ");
        stringBuffer.append(this.mSubtractTwoDurationsPage2Of3.getMinusDuration2Name());
        String string = stringBuffer.toString();
        this.mCalculationLabel.setText("");
        this.mCalculationLabel.setText(string);
        this.setEnabledFinish();
        if (DateAndTimeWizardDlg.mLabelPanel.getComponentCount() > 0) {
            JTextArea jTextArea = (JTextArea)DateAndTimeWizardDlg.mLabelPanel.getComponent(0);
            jTextArea.setText("");
            jTextArea.setText("\n" + string);
        }
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
    }

    private String getVariableWidth(String string) {
        String string2 = string.substring(string.length() - 4, string.length());
        char c = string2.charAt(0);
        if (Character.isLetter(c)) {
            string2 = string.substring(string.length() - 3, string.length());
        }
        if (Character.isLetter(c = string2.charAt(0))) {
            string2 = string.substring(string.length() - 2, string.length());
        }
        if (Character.isLetter(c = string2.charAt(0))) {
            string2 = string.substring(string.length() - 1, string.length());
        }
        if (string2.endsWith("0")) {
            Double d = new Double(string2);
            string2 = String.valueOf(d.intValue());
        } else if (string2.indexOf(".") != -1) {
            Double d = new Double(string2);
            string2 = String.valueOf(d.intValue() - 1);
        }
        return string2;
    }

    @Override
    public void init() {
        this.initVars();
        this.setupPanel();
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    private void setDefaults() {
        if (this.mCreateRadio != null) {
            this.mCreateRadio.setSelected(true);
        }
        if (this.mPasteSyntaxRadio != null && CommandLine.isClementineCaller()) {
            this.mPasteSyntaxRadio.setEnabled(false);
        }
        this.mResultVariableText.grabFocus();
        this.mResultVariableText.requestFocus();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mResultVariableText);
        vector.add(this.mOutFormatList);
        vector.add(this.mVariableText);
        if (this.mGroup != null) {
            vector.add(this.mGroup);
        }
        Vector<Object> vector2 = ((DateAndTimeWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private void initVars() {
        this.mResultVariableText = new StringTextField(16);
        this.mResultVariableText.getDocument().addDocumentListener(this);
        this.mResultVariableText.addFocusListener(this);
        this.mVariableText = new StringTextField(55);
        this.mVariableText.addFocusListener(this);
        if (VersionInfo.allowSyntax()) {
            this.mCreateRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, CREATE_KEY));
            this.mPasteSyntaxRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, PASTE_KEY));
            this.mGroup = new SpssButtonGroup();
            this.mGroup.add(this.mCreateRadio);
            this.mGroup.add(this.mPasteSyntaxRadio);
            this.mCreateRadio.addFocusListener(this);
            this.mPasteSyntaxRadio.addFocusListener(this);
        }
        DefaultListModel<Integer> defaultListModel = new DefaultListModel<Integer>();
        for (Integer n : DateAndTimeWizardDlg.PATTERNS_OP_DURATION_VALUES) {
            defaultListModel.addElement(n);
        }
        this.mOutFormatList = new SerializableList("IDS_DNTW_SERIALIZABLE_LIST");
        this.mOutFormatList.setCellRenderer(new DateAndTimeWizardDlg.DateIDRenederer());
        this.mOutFormatList.setSelectionMode(0);
        this.mOutFormatList.setModel(defaultListModel);
        this.mOutFormatPane = new JScrollPane(this.mOutFormatList);
        Dimension dimension = this.mOutFormatList.getMinimumSize();
        dimension.width += 80;
        dimension.height += 30;
        this.mOutFormatPane.setPreferredSize(dimension);
        this.mOutFormatList.addListSelectionListener(this);
        this.mOutFormatList.addFocusListener(this);
        this.mCalculationLabel = new JLabel();
    }

    private void setupPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n, 0, 0, 0);
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_RESULT_VARIABLE_LABEL");
        jLabel.setLabelFor((Component)((Object)this.mResultVariableText));
        JLabel jLabel2 = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_VARIABLE_LABEL");
        jLabel2.setLabelFor((Component)((Object)this.mVariableText));
        JLabel jLabel3 = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_OUTPUT_FORMAT_LABEL");
        jLabel3.setLabelFor(this.mOutFormatList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n2 = 23;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(this.mWizardPage, jLabel, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(n, n, 0, 0);
        DialogUtil.addUsingGBL(this.mWizardPage, jLabel3, gridBagConstraints, 2, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mWizardPage, (JComponent)((Object)this.mResultVariableText), gridBagConstraints, 1, 2, 1, 1, n2, null);
        gridBagConstraints.weightx = 1.0;
        insets.set(0, n, 0, 0);
        DialogUtil.addUsingGBL(this.mWizardPage, this.mOutFormatPane, gridBagConstraints, 2, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        insets.set(n, 0, 0, 0);
        DialogUtil.addUsingGBL(this.mWizardPage, jLabel2, gridBagConstraints, 1, 3, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this.mWizardPage, (JComponent)((Object)this.mVariableText), gridBagConstraints, 1, 4, 2, 1, n2, null);
        JPanel jPanel = VersionInfo.allowSyntax() ? this.setupExecutionPanel() : new JPanel();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 1, 5, 2, 1, n2, insets);
    }

    private JPanel setupExecutionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.mWizardDialog.getResString("IDS_DNTW_EXECUTION_TITLE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mCreateRadio, gridBagConstraints, 0, 0, 1, 1, n2, null);
        gridBagConstraints.weightx = 1.0;
        Insets insets = new Insets(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mPasteSyntaxRadio, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        return jPanel;
    }

    @Override
    public String getNextPage() {
        return null;
    }

    @Override
    public boolean hasNextPage() {
        return false;
    }

    @Override
    public boolean isLastPage() {
        return true;
    }

    private boolean setEnabledFinish() {
        String string = this.mResultVariableText.getText();
        if (string.length() > 0) {
            int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
            if (n > 0 && n != 100) {
                this.mWizardDialog.enableFinish(false);
                return false;
            }
            this.mWizardDialog.enableFinish(!this.mOutFormatList.isSelectionEmpty());
            return true;
        }
        this.mWizardDialog.enableFinish(false);
        return false;
    }

    private void showMessage() {
        String string = this.mResultVariableText.getText();
        if (string.length() > 0) {
            if (!this.setEnabledFinish()) {
                SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DNTW_ILLEGAL_MSG_WARNNING_MESSAGE"), VersionInfo.getAppVersionString());
            } else if (string.equals(this.mSubtractTwoDurationsPage2Of3.getDuration1Name().getName()) || string.equals(this.mSubtractTwoDurationsPage2Of3.getMinusDuration2Name())) {
                SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DNTW_SAME_VARIABLE_WARNNING_MESSAGE"), VersionInfo.getAppVersionString());
            } else if (!(this.checkDuplicateVariable() || this.mCheckResult != 1 && this.mCheckResult != 3)) {
                this.mCheckResult = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DNTW_OK_TO_REPLACE_OPTION_MESSAGE"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            }
        }
    }

    private boolean checkDuplicateVariable() {
        String string = this.mResultVariableText.getText();
        boolean bl = false;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.columnCount();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                String string2 = iSpssVariable.getName();
                if (!string.equals(string2)) continue;
                bl = true;
            }
        }
        if (bl) {
            this.mWizardDialog.enableFinish(false);
            return false;
        }
        return true;
    }

    private void setFocus() {
        String string = this.mResultVariableText.getText();
        if (string.length() > 0) {
            boolean bl;
            boolean bl2 = bl = !this.setEnabledFinish() || string.equals(this.mSubtractTwoDurationsPage2Of3.getDuration1Name().getName()) || string.equals(this.mSubtractTwoDurationsPage2Of3.getMinusDuration2Name());
            if (bl || !this.checkDuplicateVariable() && this.mCheckResult != 5) {
                this.mResultVariableText.grabFocus();
                this.mResultVariableText.requestFocusInWindow();
                this.mResultVariableText.setSelectionStart(0);
                this.mResultVariableText.setSelectionEnd(this.mResultVariableText.getText().length());
            }
        }
    }
}

