/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.date_time_wizard;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.DateAndTimeWizardDlg;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.ExtractPartOfDateOrTimePage1Of2;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExtractPartOfDateOrTimePage2Of2
extends AbstractWizardPage
implements DocumentListener,
FocusListener,
ListSelectionListener {
    static final String CREATE_KEY = "IDS_DNTW_CREATE_VARIABLE";
    static final String PASTE_KEY = "IDS_DNTW_PASTE_SYNTAX";
    static final String DNTW_EXTRACT_PART_STEP_TWO_PAGEID = "DNTW_EXTRACT_PART_STEP_TWO_PAGEID";
    private StringTextField mResultVariableText;
    private StringTextField mVariableText;
    private JRadioButton mCreateRadio;
    private JRadioButton mPasteSyntaxRadio;
    private SpssButtonGroup mGroup;
    private DefaultListModel mListModel;
    private SerializableList mOutFormatList;
    private JScrollPane mOutFormatPane;
    private JLabel mInputVariableLabel;
    private JLabel mUnitExtractedLabel;
    private JLabel mOutPutFormatLabel;
    private ExtractPartOfDateOrTimePage1Of2 mExtractPartOfDateOrTimePage1Of2;
    private int mCheckResult;
    DialogFocusTraversalPolicy mPolicy;
    private String[] mUnitsToExtract;

    public ExtractPartOfDateOrTimePage2Of2(BaseWizardDialog baseWizardDialog) {
        super(DNTW_EXTRACT_PART_STEP_TWO_PAGEID, baseWizardDialog.getResString("IDS_DNTW_STEP_TWO_OF_TWO_TITLE"), baseWizardDialog, true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_dtwz_get_part2";
    }

    public Map<String, String> getSyntaxUnitFormatMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(this.mUnitsToExtract[0], "YEAR");
        hashMap.put(this.mUnitsToExtract[1], "MONTH");
        hashMap.put(this.mUnitsToExtract[2], "MDAY");
        hashMap.put(this.mUnitsToExtract[3], "HOUR");
        hashMap.put(this.mUnitsToExtract[4], "MINUTE");
        hashMap.put(this.mUnitsToExtract[5], "SECOND");
        hashMap.put(this.mUnitsToExtract[6], "QUARTER");
        hashMap.put(this.mUnitsToExtract[7], "WEEK");
        hashMap.put(this.mUnitsToExtract[8], "DATE");
        hashMap.put(this.mUnitsToExtract[9], "TIME");
        hashMap.put(this.mUnitsToExtract[10], "WKDAY3");
        hashMap.put(this.mUnitsToExtract[11], "JDAY");
        hashMap.put("YEAR", "F8.0");
        hashMap.put("MONTH", "F8.0");
        hashMap.put("MDAY", "F8.0");
        hashMap.put("HOUR", "F8.0");
        hashMap.put("MINUTE", "F8.0");
        hashMap.put("SECOND", "F8.0");
        hashMap.put("QUARTER", "F8.0");
        hashMap.put("WEEK", "F8.0");
        hashMap.put("WKDAY3", "WKDAY3");
        hashMap.put("JDAY", "F5.0");
        return hashMap;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setEnabledFinish();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.setFocus();
        this.setEnabledFinish();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mResultVariableText) && this.mResultVariableText.getText().length() > 0) {
            this.showMessage();
            if (this.mCheckResult == 0) {
                this.mCheckResult = 5;
                this.mVariableText.requestFocus();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setEnabledFinish();
        this.mCheckResult = 3;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setEnabledFinish();
        this.mCheckResult = 3;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setEnabledFinish();
        this.mCheckResult = 3;
    }

    @Override
    public boolean hasNextPage() {
        return false;
    }

    @Override
    public boolean isLastPage() {
        return true;
    }

    @Override
    public String getNextPage() {
        return null;
    }

    @Override
    public void init() {
        this.initVars();
        this.setDefaults();
        this.setupPanel();
        this.setFocusTraversalPolicy();
    }

    public boolean isPasteSyntaxRadioEnabled() {
        return this.mPasteSyntaxRadio != null && this.mPasteSyntaxRadio.isSelected();
    }

    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("* ").append(this.mWizardDialog.getResString("IDS_DATE_AND_TIME_WIZARD")).append(": ");
        stringBuffer.append(this.mResultVariableText.getText()).append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("COMPUTE"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText() + "="));
        stringBuffer.append("XDATE.");
        String string = this.mExtractPartOfDateOrTimePage1Of2.getUnitToExtract();
        string = this.getSyntaxUnitFormatMap().get(string);
        stringBuffer.append(string);
        stringBuffer.append("(").append(this.mExtractPartOfDateOrTimePage1Of2.getDateOrTime().getName()).append(")");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LABELS"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText()));
        if (this.mVariableText.getText().length() > 0) {
            stringBuffer.append(" \"").append(this.mVariableText.getText()).append("\"");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LEVEL"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText()));
        String string2 = this.mExtractPartOfDateOrTimePage1Of2.getDateOrTime().getMeasurementLevel().toString().toUpperCase();
        stringBuffer.append("(");
        stringBuffer.append(string2.equalsIgnoreCase("unknown") ? "SCALE" : string2);
        stringBuffer.append(")");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("FORMATS"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText() + "("));
        string = string.equals("DATE") || string.equals("TIME") ? DateAndTimeWizardDlg.mSyntaxFormatMap.get(this.mOutFormatList.getSelectedValue()) : this.getSyntaxUnitFormatMap().get(string);
        stringBuffer.append(string).append(")");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE WIDTH"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText() + "(" + this.getVariableWidth(string) + ")"));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (SyntaxUtil.readTransformationMergePrefs()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("EXECUTE"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    protected void aboutToShowPanel() {
        this.mExtractPartOfDateOrTimePage1Of2 = (ExtractPartOfDateOrTimePage1Of2)this.mWizardDialog.getWizardModel().getPage("ExtractPartOfDateOrTimePage1Of2");
        this.mInputVariableLabel.setText("");
        this.mUnitExtractedLabel.setText("");
        this.mInputVariableLabel.setText(this.mExtractPartOfDateOrTimePage1Of2.getDateOrTime().getName());
        this.mUnitExtractedLabel.setText(this.mExtractPartOfDateOrTimePage1Of2.getUnitToExtract());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.mWizardDialog.getResString("IDS_DNTW_INPUT_VARIABLE_LABEL"));
        stringBuffer.append("               ");
        stringBuffer.append(this.mExtractPartOfDateOrTimePage1Of2.getDateOrTime().getName());
        String string = stringBuffer.toString();
        stringBuffer = new StringBuffer();
        stringBuffer.append(this.mWizardDialog.getResString("IDS_DNTW_UNIT_EXTRACTED_LABEL"));
        stringBuffer.append("               ");
        stringBuffer.append(this.mExtractPartOfDateOrTimePage1Of2.getUnitToExtract());
        String string2 = stringBuffer.toString();
        if (DateAndTimeWizardDlg.mLabelPanel.getComponentCount() > 0) {
            JTextArea object = (JTextArea)DateAndTimeWizardDlg.mLabelPanel.getComponent(0);
            object.setText("");
            object.setText("\n\n" + string + "\n" + string2);
        }
        this.mListModel.removeAllElements();
        if (this.mExtractPartOfDateOrTimePage1Of2.getUnitToExtract().equals(this.mUnitsToExtract[8]) || this.mExtractPartOfDateOrTimePage1Of2.getUnitToExtract().equals(this.mUnitsToExtract[9])) {
            this.mOutPutFormatLabel.setEnabled(true);
            if (this.mExtractPartOfDateOrTimePage1Of2.getUnitToExtract().equals(this.mUnitsToExtract[9])) {
                for (Integer n : DateAndTimeWizardDlg.PATTERNS_OP_DURATION_VALUES) {
                    this.mListModel.addElement(n);
                }
                this.mOutFormatList.setModel(this.mListModel);
                Dimension dimension = this.mOutFormatList.getMinimumSize();
                dimension.width = 180;
                dimension.height = 120;
                this.mOutFormatPane.setPreferredSize(dimension);
                this.mOutFormatList.setEnabled(true);
            } else {
                for (Integer n : DateAndTimeWizardDlg.DNTW_PATTERNS_OUTPUT_VALUES) {
                    this.mListModel.addElement(n);
                }
                this.mOutFormatList.setModel(this.mListModel);
                Dimension dimension = this.mOutFormatList.getMinimumSize();
                dimension.width = 180;
                dimension.height = 120;
                this.mOutFormatList.setMinimumSize(dimension);
                this.mOutFormatPane.setPreferredSize(dimension);
                this.mOutFormatList.setEnabled(true);
            }
        } else {
            this.mOutPutFormatLabel.setEnabled(false);
            this.mOutFormatList.setEnabled(false);
        }
        this.setEnabledFinish();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mPolicy.getDefaultComponent((Container)((Object)this.mWizardDialog)).requestFocusInWindow();
    }

    private String getVariableWidth(String string) {
        String string2 = string.substring(string.length() - 4, string.length());
        char c = string2.charAt(0);
        if (Character.isLetter(c)) {
            string2 = string.substring(string.length() - 3, string.length());
        }
        if (Character.isLetter(c = string2.charAt(0))) {
            string2 = string.substring(string.length() - 2, string.length());
        }
        if (Character.isLetter(c = string2.charAt(0))) {
            string2 = string.substring(string.length() - 1, string.length());
        }
        if (string2.endsWith("0")) {
            Double d = new Double(string2);
            string2 = String.valueOf(d.intValue());
        } else if (string2.indexOf(".") != -1) {
            Double d = new Double(string2);
            string2 = String.valueOf(d.intValue() - 1);
        }
        return string2;
    }

    private void setDefaults() {
        if (this.mCreateRadio != null) {
            this.mCreateRadio.setSelected(true);
        }
        if (this.mPasteSyntaxRadio != null && CommandLine.isClementineCaller()) {
            this.mPasteSyntaxRadio.setEnabled(false);
        }
    }

    private void initVars() {
        this.mResultVariableText = new StringTextField(16);
        this.mResultVariableText.getDocument().addDocumentListener(this);
        this.mResultVariableText.addFocusListener(this);
        this.mVariableText = new StringTextField(55);
        this.mVariableText.addFocusListener(this);
        if (VersionInfo.allowSyntax()) {
            this.mCreateRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, CREATE_KEY));
            this.mPasteSyntaxRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, PASTE_KEY));
            this.mGroup = new SpssButtonGroup();
            this.mGroup.add(this.mCreateRadio);
            this.mGroup.add(this.mPasteSyntaxRadio);
            this.mCreateRadio.addFocusListener(this);
            this.mPasteSyntaxRadio.addFocusListener(this);
        }
        this.mListModel = new DefaultListModel();
        this.mOutFormatList = new SerializableList("IDS_SERIALIZABLE_LIST");
        this.mOutFormatList.setCellRenderer(new DateAndTimeWizardDlg.DateIDRenederer());
        this.mOutFormatPane = new JScrollPane(this.mOutFormatList);
        Dimension dimension = this.mOutFormatList.getMinimumSize();
        dimension.width = 180;
        dimension.height = 120;
        this.mOutFormatPane.setPreferredSize(dimension);
        this.mOutFormatList.addListSelectionListener(this);
        this.mOutFormatList.addFocusListener(this);
        this.mInputVariableLabel = new JLabel("mInputVariableLabel");
        this.mUnitExtractedLabel = new JLabel("mUnitExtractedLabel");
        this.mOutPutFormatLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_OUTPUT_FORMAT_LABEL");
        this.mUnitsToExtract = this.mWizardDialog.getResStringArray("IDS_DNTW_UNITS_TO_EXTRACT");
    }

    private void setupPanel() {
        this.mWizardPage = this.getPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n, 0, 0);
        int n2 = 23;
        JPanel jPanel = this.setupTextAndLabelPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 1, 0, 1, 1, n2, insets);
    }

    private JPanel setupTextAndLabelPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n, 0, 0, 0);
        int n2 = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_RESULT_VARIABLE_LABEL");
        jLabel.setLabelFor((Component)((Object)this.mResultVariableText));
        JLabel jLabel2 = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_VARIABLE_LABEL");
        jLabel2.setLabelFor((Component)((Object)this.mVariableText));
        this.mOutPutFormatLabel.setLabelFor(this.mOutFormatPane);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n2, null);
        insets.set(0, n, 0, 0);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mOutPutFormatLabel, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mResultVariableText), gridBagConstraints, 0, 2, 1, 1, n2, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mOutFormatPane, gridBagConstraints, 1, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        insets.set(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 4, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mVariableText), gridBagConstraints, 0, 5, 2, 1, n2, null);
        JPanel jPanel2 = VersionInfo.allowSyntax() ? this.setupExecutionPanel() : new JPanel();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        insets = new Insets(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 6, 2, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupExecutionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.mWizardDialog.getResString("IDS_DNTW_EXECUTION_TITLE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mCreateRadio, gridBagConstraints, 0, 0, 1, 1, n2, null);
        Insets insets = new Insets(0, n, 0, 0);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mPasteSyntaxRadio, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        return jPanel;
    }

    private void showMessage() {
        String string = this.mResultVariableText.getText();
        if (string.length() > 0) {
            if (!this.setEnabledFinish()) {
                SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DNTW_ILLEGAL_MSG_WARNNING_MESSAGE"), VersionInfo.getAppVersionString());
            } else if (string.equals(this.mExtractPartOfDateOrTimePage1Of2.getDateOrTime().getName())) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DNTW_SAME_VARIABLE_WARNNING_MESSAGE"), VersionInfo.getAppVersionString());
            } else if (!(this.checkDuplicateVariable() || this.mCheckResult != 1 && this.mCheckResult != 3)) {
                this.mCheckResult = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DNTW_OK_TO_REPLACE_OPTION_MESSAGE"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            }
        }
    }

    private boolean checkDuplicateVariable() {
        String string = this.mResultVariableText.getText();
        boolean bl = false;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.columnCount();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                String string2 = iSpssVariable.getName();
                if (!string.equals(string2)) continue;
                bl = true;
            }
        }
        if (bl) {
            if (this.mOutFormatList.isEnabled()) {
                this.mWizardDialog.enableFinish(!this.mOutFormatList.isSelectionEmpty());
            } else {
                this.mWizardDialog.enableFinish(true);
            }
            return false;
        }
        return true;
    }

    private void setFocus() {
        String string = this.mResultVariableText.getText();
        if (string.length() > 0) {
            boolean bl;
            boolean bl2 = bl = !this.setEnabledFinish() || string.equals(this.mExtractPartOfDateOrTimePage1Of2.getDateOrTime().getName());
            if (bl || !this.checkDuplicateVariable() && this.mCheckResult != 5) {
                this.mResultVariableText.grabFocus();
                this.mResultVariableText.setSelectionStart(0);
                this.mResultVariableText.setSelectionEnd(this.mResultVariableText.getText().length());
                this.mResultVariableText.requestFocus();
            }
        }
    }

    private boolean setEnabledFinish() {
        String string = this.mResultVariableText.getText();
        if (string.length() > 0) {
            int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
            if (n > 0 && n != 100) {
                this.mWizardDialog.enableFinish(false);
                return false;
            }
            if (this.mOutFormatList.isEnabled()) {
                this.mWizardDialog.enableFinish(!this.mOutFormatList.isSelectionEmpty());
            } else {
                this.mWizardDialog.enableFinish(true);
            }
            return true;
        }
        this.mWizardDialog.enableFinish(false);
        return false;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mResultVariableText);
        vector.add(this.mVariableText);
        if (this.mGroup != null) {
            vector.add(this.mGroup);
        }
        Vector<Object> vector2 = ((DateAndTimeWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }
}

