/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.date_time_wizard;

import com.spss.java_client.core.documents.data.dictionary.DateAndTimeVariable;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.DateAndTimeSrcList;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.DateAndTimeVarListModel;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.DateAndTimeWizardDlg;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ExtractPartOfDateOrTimePage1Of2
extends AbstractWizardPage
implements ListDataListener {
    static final String EXT_PART_DATE_TIME_PAGE_1_OF_2_PAGEID = "ExtractPartOfDateOrTimePage1Of2";
    private JScrollPane mSrcScrollPane;
    private JScrollPane mDateTargetPane;
    private TargetVariableList mDateTargetList;
    private DateAndTimeSrcList mSrcVarList;
    private ArrowButton mDateArrowButton;
    private JComboBox mUnitsCombo;
    private FormatTextField mFormatText;
    DialogFocusTraversalPolicy mPolicy;

    public ExtractPartOfDateOrTimePage1Of2(BaseWizardDialog baseWizardDialog) {
        super(EXT_PART_DATE_TIME_PAGE_1_OF_2_PAGEID, baseWizardDialog.getResString("IDS_DNTW_STEP_ONE_OF_TWO_TITLE"), baseWizardDialog, true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_dtwz_get_part1";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableNext();
        this.setFormatType();
        this.mSrcVarList.getModel().sort();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableNext();
        this.setFormatType();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableNext();
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public String getNextPage() {
        return "DNTW_EXTRACT_PART_STEP_TWO_PAGEID";
    }

    @Override
    public void init() {
        this.initVars();
        this.setDefaults();
        this.setupPanel();
        this.setFocusTraversalPolicy();
    }

    public ISpssVariable getDateOrTime() {
        return this.mDateTargetList.getModel().getElementAt(0);
    }

    public String getUnitToExtract() {
        return this.mUnitsCombo.getSelectedItem().toString();
    }

    @Override
    protected void aboutToShowPanel() {
        Component component;
        if (DateAndTimeWizardDlg.mLabelPanel.getComponentCount() > 0) {
            component = (JTextArea)DateAndTimeWizardDlg.mLabelPanel.getComponent(0);
            component.setText("");
            component.setText(this.mWizardDialog.getResString("IDS_DNTW_GET_PART_LABEL"));
        }
        if (this.mWizardDialog.getGlassPane() instanceof DragPane) {
            component = this.mWizardDialog.getGlassPane();
            DragPane dragPane = (DragPane)component;
            dragPane.getDropListeners().removeAllElements();
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mSrcVarList));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mDateTargetList));
        }
        this.enableNext();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mPolicy.getDefaultComponent((Container)((Object)this.mWizardDialog)).requestFocusInWindow();
    }

    private void setDefaults() {
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void populateSrcList() {
        this.mSrcVarList.addVarFilter(new SpssVarFilter(32, false, false));
        this.mSrcVarList.loadFromActiveDataset();
        DateAndTimeVarListModel dateAndTimeVarListModel = (DateAndTimeVarListModel)this.mSrcVarList.getModel();
        DateAndTimeVariable dateAndTimeVariable = new DateAndTimeVariable(this.mWizardDialog.getResString("IDS_DNTW_TIME"), this.mWizardDialog.getResString("IDS_DNTW_CURRENT_DATE_AND_TIME"));
        dateAndTimeVariable.setFormat(new SPSS_Format(FormatType.ADATE, 10, 0));
        dateAndTimeVarListModel.addElement((ISpssVariable)dateAndTimeVariable);
    }

    private void initVars() {
        this.mSrcVarList = new DateAndTimeSrcList();
        DateAndTimeVarListModel dateAndTimeVarListModel = new DateAndTimeVarListModel(this.mSrcVarList);
        this.mSrcVarList.setModel(dateAndTimeVarListModel);
        this.populateSrcList();
        this.mSrcVarList.setSelectionMode(0);
        this.mSrcVarList.getModel().addListDataListener(this);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mDateTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mDateTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDateTargetList.getModel().addListDataListener(this);
        this.mDateTargetPane = new JScrollPane(this.mDateTargetList);
        this.mDateTargetPane.setPreferredSize(this.mDateTargetList.getMinimumSize());
        this.mDateTargetPane.setHorizontalScrollBarPolicy(31);
        this.mDateTargetPane.setVerticalScrollBarPolicy(21);
        this.mDateTargetList.getModel().addListDataListener(this);
        this.mDateArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDateArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDateArrowButton.registerVariableList(this.mDateTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mUnitsCombo = new JComboBox<String>(this.mWizardDialog.getResStringArray("IDS_DNTW_UNITS_TO_EXTRACT"));
        this.mFormatText = new FormatTextField(25, -1);
        this.mFormatText.setColumns(25);
        this.mFormatText.setEditable(false);
        this.mFormatText.setOpaque(false);
        this.mFormatText.setFocusable(false);
        this.mFormatText.setBorder(BorderFactory.createEmptyBorder());
        this.setFormatType();
    }

    private void setupPanel() {
        this.mWizardPage = this.getPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n, 0, 0);
        int n2 = 23;
        JPanel jPanel = this.setupLists();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
    }

    private JPanel setupLists() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n, 0, 0, 0);
        int n2 = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_UNITS_TO_EXTRACT_LABEL");
        jLabel.setLabelFor(this.mUnitsCombo);
        JLabel jLabel2 = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_SOURCE_VARIABLES");
        jLabel2.setLabelFor(this.mSrcVarList);
        JLabel jLabel3 = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_DATE_OR_TIME_LABEL");
        jLabel3.setLabelFor(this.mDateTargetList);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 1, n2, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 3, 6, n2, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n2 = 20;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        Insets insets3 = new Insets(0, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mDateArrowButton, gridBagConstraints, 3, 0, 1, 2, n2, insets3);
        gridBagConstraints.weightx = 1.0;
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 4, 0, 1, 1, n2, null);
        gridBagConstraints.fill = 2;
        insets3.set(0, 0, 0, 10 * n);
        DialogUtil.addUsingGBL(jPanel, this.mDateTargetPane, gridBagConstraints, 4, 1, 1, 1, n2, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets3.set(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mFormatText, gridBagConstraints, 4, 3, 1, 1, n2, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 4, 4, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets3.set(0, 0, 0, 10 * n);
        DialogUtil.addUsingGBL(jPanel, this.mUnitsCombo, gridBagConstraints, 4, 5, 1, 1, n2, insets3);
        JLabel jLabel4 = new JLabel(this.mWizardDialog.getResString("IDS_DNTW_TIME_LABEL"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 0, 7, 3, 1, n2, null);
        return jPanel;
    }

    private void enableNext() {
        if (this.mDateTargetList.getModel().getSize() > 0) {
            this.mWizardDialog.enableNext(true);
        } else {
            this.mWizardDialog.enableNext(false);
        }
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mDateArrowButton);
        vector.add(this.mDateTargetList);
        vector.add(this.mUnitsCombo);
        Vector<Object> vector2 = ((DateAndTimeWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private void setFormatType() {
        if (this.mDateTargetList.getModel().getSize() > 0) {
            SPSS_Format sPSS_Format = this.mDateTargetList.getModel().getElementAt(0).getWriteFormat();
            int n = -1;
            int n2 = sPSS_Format.asInt();
            switch (n2) {
                case 0: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[16];
                    break;
                }
                case 1313536: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[0];
                    break;
                }
                case 1313024: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[1];
                    break;
                }
                case 1509888: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[4];
                    break;
                }
                case 1509376: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[5];
                    break;
                }
                case 2492928: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[6];
                    break;
                }
                case 2492416: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[7];
                    break;
                }
                case 1574144: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[6];
                    break;
                }
                case 1574656: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[7];
                    break;
                }
                case 1902592: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[8];
                    break;
                }
                case 1902080: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[9];
                    break;
                }
                case 1837056: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[10];
                    break;
                }
                case 1836544: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[11];
                    break;
                }
                case 1968640: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[12];
                    break;
                }
                case 1968128: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[13];
                    break;
                }
                case 0x161100: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[14];
                    break;
                }
                case 1446912: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[15];
                    break;
                }
                case 1447682: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[16];
                    break;
                }
                case 0x150500: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[22];
                    break;
                }
                case 1378304: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[23];
                    break;
                }
                case 1379074: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[24];
                    break;
                }
                case 0x190900: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[25];
                    break;
                }
                case 1641472: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[26];
                    break;
                }
                case 1642242: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[27];
                    break;
                }
                case 2558464: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[28];
                    break;
                }
                case 2557952: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[30];
                    break;
                }
                case 5641730: {
                    n = DateAndTimeWizardDlg.PATTERNS_VALUES[19];
                    break;
                }
                default: {
                    n = -1;
                }
            }
            this.mFormatText.setDateID(n);
        } else {
            this.mFormatText.setDateID(-1);
        }
    }

    class FormatTextField
    extends JTextField {
        int mDateID;

        FormatTextField(int n) {
            this(n, -1);
        }

        FormatTextField(int n, int n2) {
            super(n);
            this.mDateID = -1;
            this.setDateID(n2);
        }

        public int getDateID() {
            return this.mDateID;
        }

        public void setDateID(int n) {
            this.mDateID = n;
            String string = n >= 0 ? ExtractPartOfDateOrTimePage1Of2.this.mWizardDialog.getResString("IDS_DNTW_FORMAT_LABEL") + "   " + DateAndTimeWizardDlg.mDateKeyToLocalizedStringMap.get(n) : ExtractPartOfDateOrTimePage1Of2.this.mWizardDialog.getResString("IDS_DNTW_FORMAT_LABEL") + "   " + ExtractPartOfDateOrTimePage1Of2.this.mWizardDialog.getResString("IDS_DNTW_DATE_OR_TIME_FORMAT");
            this.setText(string);
        }
    }
}

