/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.date_time_wizard;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableSortType;
import com.spss.java_client.ui.controls.ListKeyListener;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.Dimension;

public class DateAndTimeTargetVariableList
extends VariableList {
    TargetListType mTargetType = TargetListType.normal;
    TargetMeasurementType mTargetMeasurementType = TargetMeasurementType.none;
    private boolean mAllowDuplicates;
    private boolean mDataSource;
    private ListKeyListener mListKeyListener;

    public DateAndTimeTargetVariableList() {
        this(TargetListType.normal, VariableList.VarMoveType.eMoveOriginal);
    }

    public DateAndTimeTargetVariableList(TargetListType targetListType) {
        this(targetListType, VariableList.VarMoveType.eMoveOriginal);
    }

    public DateAndTimeTargetVariableList(TargetListType targetListType, VariableList.VarMoveType varMoveType) {
        super(varMoveType);
        this.setTargetType(targetListType);
        this.setContextMenuFlags(1);
        this.setSortType(SpssVariableSortType.none);
        this.setIdentifier("TargetVarList");
        this.mListKeyListener = new ListKeyListener(this);
        this.addKeyListener(this.mListKeyListener);
    }

    public TargetListType getTargetType() {
        return this.mTargetType;
    }

    public void setTargetType(TargetListType targetListType) {
        if (targetListType == this.mTargetType) {
            return;
        }
        this.mTargetType = targetListType;
        int n = this.getFixedCellHeight() + 2;
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), n);
        this.setMinimumSize(dimension);
        if (this.mTargetType == TargetListType.single_item) {
            this.setPreferredSize(dimension);
            this.setMaximumSize(dimension);
        } else {
            this.setPreferredSize(null);
            this.setMaximumSize(null);
        }
    }

    public TargetMeasurementType getTargetMeasurementType() {
        return this.mTargetMeasurementType;
    }

    public void setTargetMeasurementType(TargetMeasurementType targetMeasurementType) {
        if (targetMeasurementType == this.mTargetMeasurementType) {
            return;
        }
        this.mTargetMeasurementType = targetMeasurementType;
    }

    public String getVariablesStringList() {
        String string = "";
        int n = this.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            string = string + this.getModel().getElementAt(i).getName();
            if (i >= n - 1) continue;
            string = string + " ";
        }
        return string;
    }

    @Override
    public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
        boolean bl = super.canIncludeVariable(iSpssVariable);
        if (bl && this.mTargetType == TargetListType.single_item) {
            bl = this.getModel().getSize() == 0;
        }
        return bl;
    }

    @Override
    public void updateUI() {
        this.removeKeyListener(this.mListKeyListener);
        super.updateUI();
        this.addKeyListener(this.mListKeyListener);
    }

    public void setDataSource(boolean bl) {
        this.mDataSource = bl;
    }

    public boolean isDataSource() {
        return this.mDataSource;
    }

    public void setAllowDuplicates(boolean bl) {
        this.mAllowDuplicates = bl;
    }

    public boolean isAllowDuplicates() {
        return this.mAllowDuplicates;
    }

    public static enum TargetMeasurementType {
        none,
        scale,
        categorical;

    }

    public static enum TargetListType {
        normal,
        single_item;

    }
}

