/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.date_time_wizard;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.CreateDateFromStringStep1WizardPage;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.DateAndTimeWizardDlg;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.font.TextAttribute;
import java.text.Bidi;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

class CreateDateFromStringStep2WizardPage
extends AbstractWizardPage
implements DocumentListener {
    public static final String OUTPUT_FORMAT_LIST_KEY = "IDS_OUTPUT_FORMAT_LIST_FOR_STR";
    private StringTextField mInputVarText;
    private StringTextField mResVarText;
    private InputDateFormatTextField mInputFormatText;
    private StringTextField mVariableText;
    private SerializableList mOutFormatList;
    private JScrollPane mOutFormatPane;
    private JRadioButton mCreateVarRadio;
    private JRadioButton mPasteSyntaxRadio;
    private SpssButtonGroup mButtongrp;
    private DefaultListModel mOutFormatModel;
    private DialogFocusTraversalPolicy mPolicy;

    CreateDateFromStringStep2WizardPage(BaseWizardDialog baseWizardDialog) {
        super("CDTWSTEP2OF2", baseWizardDialog.getResString("IDS_CDNTW2_TITLE"), baseWizardDialog, true);
    }

    @Override
    public void init() {
        this.initVars();
        this.setDefaults();
        this.setUpWizard();
        this.setFoucsTraversalPolicy();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_dtwz_from_string2";
    }

    public String getGeneratedSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("* ").append(this.mWizardDialog.getResString("IDS_DATE_AND_TIME_WIZARD")).append(": ").append(this.mResVarText.getText()).append(SyntaxUtil.terminateSyntax());
        Map<Integer, String> map = DateAndTimeWizardDlg.mSyntaxFormatMap;
        String string = map.get(this.mInputFormatText.getDateID());
        stringBuffer.append(SyntaxUtil.getMainCommand("COMPUTE"));
        if (!string.equals("NO_FORMAT")) {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResVarText.getText())).append("=number(").append(this.mInputVarText.getText()).append(", ").append(string).append(")");
        } else {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResVarText.getText())).append("=").append(this.getComputeSyntax());
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LABELS"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResVarText.getText())).append(" ").append(CharacterUtil.smartQuote((String)this.mVariableText.getText()));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LEVEL "));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResVarText.getText())).append(" (SCALE)");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        string = map.get(this.mOutFormatList.getSelectedValue());
        stringBuffer.append(SyntaxUtil.getMainCommand("FORMATS"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResVarText.getText())).append(" (").append(string).append(")");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        String string2 = string.substring(string.length() - 4, string.length());
        char c = string2.charAt(0);
        if (Character.isLetter(c)) {
            string2 = string.substring(string.length() - 3, string.length());
        }
        if (Character.isLetter(c = string2.charAt(0))) {
            string2 = string.substring(string.length() - 2, string.length());
        }
        if (Character.isLetter(c = string2.charAt(0))) {
            string2 = string.substring(string.length() - 1, string.length());
        }
        if (string2.indexOf(".") != -1) {
            Double d = new Double(string2);
            string2 = String.valueOf(d.intValue() - 1);
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE WIDTH "));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResVarText.getText() + "(" + string2 + ")"));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (SyntaxUtil.readTransformationMergePrefs()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("EXECUTE"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isLastPage() {
        return true;
    }

    @Override
    public boolean hasNextPage() {
        return false;
    }

    @Override
    public String getNextPage() {
        return null;
    }

    public boolean isPasteSyntaxRadioEnabled() {
        return this.mPasteSyntaxRadio != null && this.mPasteSyntaxRadio.isSelected();
    }

    @Override
    protected void aboutToShowPanel() {
        Object object;
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mPolicy.getDefaultComponent((Container)((Object)this.mWizardDialog)).requestFocusInWindow();
        if (DateAndTimeWizardDlg.mLabelPanel.getComponentCount() > 0) {
            object = (JTextArea)DateAndTimeWizardDlg.mLabelPanel.getComponent(0);
            ((JTextComponent)object).setText("");
            ((JTextComponent)object).setText(this.mWizardDialog.getResString("IDS_CDNTW_CREATE_DATE_WITH_STRING"));
        }
        object = (CreateDateFromStringStep1WizardPage)this.mWizardDialog.getWizardModel().getPage("CDTWSTEP1OF2");
        this.mOutFormatModel.clear();
        Integer[] integerArray = ((CreateDateFromStringStep1WizardPage)object).getOutPutFormat();
        for (Integer n : integerArray) {
            this.mOutFormatModel.addElement(n);
        }
        if (ComponentState.getBTD() == 0) {
            Object object2 = ((CreateDateFromStringStep1WizardPage)object).getInputVariable();
            if (object2 != null && ((String)object2).length() > 0) {
                if (new Bidi(Character.toString(((String)object2).charAt(0)), 1).isRightToLeft()) {
                    this.mInputVarText.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                } else {
                    this.mInputVarText.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                }
            }
            if ((object2 = ((CreateDateFromStringStep1WizardPage)object).getVariableLabel()) != null && ((String)object2).length() > 0) {
                if (new Bidi(Character.toString(((String)object2).charAt(0)), 1).isRightToLeft()) {
                    this.mVariableText.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                } else {
                    this.mVariableText.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                }
            }
        }
        this.mInputVarText.setText(((CreateDateFromStringStep1WizardPage)object).getInputVariable());
        this.mInputFormatText.setDateID(((CreateDateFromStringStep1WizardPage)object).getInputFormat());
        this.mVariableText.setText(((CreateDateFromStringStep1WizardPage)object).getVariableLabel());
        int n = this.mOutFormatList.getSelectedIndex();
        SwingUtilities.invokeLater(new Runnable((CreateDateFromStringStep1WizardPage)object, n){
            final /* synthetic */ CreateDateFromStringStep1WizardPage val$previous;
            final /* synthetic */ int val$index;
            {
                this.val$previous = createDateFromStringStep1WizardPage;
                this.val$index = n;
            }

            @Override
            public void run() {
                CreateDateFromStringStep2WizardPage.this.mOutFormatList.clearSelection();
                CreateDateFromStringStep2WizardPage.this.mOutFormatList.setSelectedValue(this.val$previous.getInputFormat(), true);
                CreateDateFromStringStep2WizardPage.this.mOutFormatList.ensureIndexIsVisible(this.val$index);
            }
        });
        this.mResVarText.requestFocus();
        this.setEnabledFinish();
    }

    private StringBuffer getComputeSyntax() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.mInputFormatText.getDateID() == DateAndTimeWizardDlg.YYYYMMDD) {
            stringBuffer.append("date.dmy(number(substr(ltrim(").append(this.mInputVarText.getText()).append("),7,2),f2.0), number(substr(ltrim(").append(this.mInputVarText.getText()).append("),5,2),f2.0), number(substr(ltrim(").append(this.mInputVarText.getText()).append("),1,4),f4.0))");
        } else if (this.mInputFormatText.getDateID() == DateAndTimeWizardDlg.YYMMDD) {
            stringBuffer.append("date.dmy(number(substr(ltrim(").append(this.mInputVarText.getText()).append("),5,2),f2.0), number(substr(ltrim(").append(this.mInputVarText.getText()).append("),3,2),f2.0), number(substr(ltrim(").append(this.mInputVarText.getText()).append("),1,2),f2.0))");
        } else if (this.mInputFormatText.getDateID() == DateAndTimeWizardDlg.DDMMYYYY) {
            stringBuffer.append("date.dmy(number(substr(ltrim(").append(this.mInputVarText.getText()).append("),1,2),f2.0), number(substr(ltrim(").append(this.mInputVarText.getText()).append("),3,2),f2.0), number(substr(ltrim(").append(this.mInputVarText.getText()).append("),5),f4.0))");
        } else if (this.mInputFormatText.getDateID() == DateAndTimeWizardDlg.DDMMYY) {
            stringBuffer.append("date.dmy(number(substr(ltrim(").append(this.mInputVarText.getText()).append("),1,2),f2.0), number(substr(ltrim(").append(this.mInputVarText.getText()).append("),3,2),f2.0), number(substr(ltrim(").append(this.mInputVarText.getText()).append("),5),f2.0))");
        } else if (this.mInputFormatText.getDateID() == DateAndTimeWizardDlg.MMDDYYYY) {
            stringBuffer.append("date.dmy(number(substr(ltrim(").append(this.mInputVarText.getText()).append("),3,2),f2.0), number(substr(ltrim(").append(this.mInputVarText.getText()).append("),1,2),f2.0), number(substr(ltrim(").append(this.mInputVarText.getText()).append("),5),f4.0))");
        } else if (this.mInputFormatText.getDateID() == DateAndTimeWizardDlg.MMDDYY) {
            stringBuffer.append("date.dmy(number(substr(ltrim(").append(this.mInputVarText.getText()).append("),3,2),f2.0), number(substr(ltrim(").append(this.mInputVarText.getText()).append("),1,2),f2.0), number(substr(ltrim(").append(this.mInputVarText.getText()).append("),5,4),f4.0))");
        } else if (this.mInputFormatText.getDateID() == DateAndTimeWizardDlg.HHMM) {
            stringBuffer.append("time.hms(number(substr(ltrim(").append(this.mInputVarText.getText()).append("),1,2), f2), number(substr(ltrim(").append(this.mInputVarText.getText()).append("),3), f2))");
        } else if (this.mInputFormatText.getDateID() == DateAndTimeWizardDlg.HHMMSS) {
            stringBuffer.append("time.hms(number(substr(ltrim(").append(this.mInputVarText.getText()).append("),1,2), f2), number(substr(ltrim(").append(this.mInputVarText.getText()).append("),3,2), f2), number(substr(ltrim(").append(this.mInputVarText.getText()).append("),5), f5))");
        }
        return stringBuffer;
    }

    @Override
    public boolean validate() {
        return this.doValidate();
    }

    @Override
    public boolean validateOnBack() {
        return this.doValidate();
    }

    private boolean doValidate() {
        int n;
        boolean bl = true;
        if (!this.isVarNameValid()) {
            this.showDialog(this.mWizardDialog.getResString("ERR_CDNTP_RES_MSG"));
            bl = false;
        } else if (this.mOutFormatList.isSelectionEmpty()) {
            this.showDialog(this.mWizardDialog.getResString("ERR_CDNTW2_FORMAT_REQUIRED"));
            bl = false;
        } else if (!this.isResultVariableSameAsInput()) {
            this.showDialog(this.mWizardDialog.getResString("ERR_CDNTW2_SAME_NAME"));
            bl = false;
        } else if (this.isResultVariableAlreadyExist() && (n = this.showMessage(this.mWizardDialog.getResString("ERR_CDNTW2_ALREADY_EXIST"))) != 0) {
            bl = false;
        }
        return bl;
    }

    private boolean isVarNameValid() {
        String string = this.mResVarText.getText();
        if (string.length() == 0) {
            return true;
        }
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        return n <= 0 || n == 100;
    }

    private boolean setEnabledFinish() {
        boolean bl = true;
        String string = this.mResVarText.getText();
        if (string == null || string.length() == 0) {
            bl = false;
        }
        if (!this.isVarNameValid()) {
            bl = false;
        } else if (this.mOutFormatList.isSelectionEmpty()) {
            bl = false;
        } else if (!this.isResultVariableSameAsInput()) {
            bl = false;
        }
        this.mWizardDialog.enableFinish(bl);
        return bl;
    }

    private boolean isResultVariableSameAsInput() {
        String string;
        CreateDateFromStringStep1WizardPage createDateFromStringStep1WizardPage = (CreateDateFromStringStep1WizardPage)this.mWizardDialog.getWizardModel().getPage("CDTWSTEP1OF2");
        String string2 = this.mResVarText.getText();
        boolean bl = false;
        if (createDateFromStringStep1WizardPage.getInputVariable() != null && (string = createDateFromStringStep1WizardPage.getInputVariable()).compareToIgnoreCase(string2) == 0) {
            bl = true;
        }
        if (bl) {
            this.mWizardDialog.enableFinish(!this.mOutFormatList.isSelectionEmpty());
            return false;
        }
        return true;
    }

    private boolean isResultVariableAlreadyExist() {
        String string = this.mResVarText.getText();
        boolean bl = false;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.columnCount();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                String string2 = iSpssVariable.getName();
                if (!string.equals(string2)) continue;
                bl = true;
            }
        }
        if (bl) {
            this.mWizardDialog.enableFinish(!this.mOutFormatList.isSelectionEmpty());
            return true;
        }
        return false;
    }

    private void setDefaults() {
        if (VersionInfo.allowSyntax()) {
            this.mCreateVarRadio.setSelected(true);
            if (CommandLine.isClementineCaller()) {
                this.mPasteSyntaxRadio.setEnabled(false);
            }
        }
        this.mInputVarText.setEditable(false);
        this.mInputVarText.setOpaque(false);
        this.mInputFormatText.setOpaque(false);
        this.mInputFormatText.setEditable(false);
        this.mResVarText.grabFocus();
    }

    private void showDialog(String string) {
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string, VersionInfo.getAppVersionString());
    }

    private int showMessage(String string) {
        return SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
    }

    private void setUpWizard() {
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_CDNTW2_COMPLETE_STRING"));
        JLabel jLabel2 = DialogUtil.createLabel(this.mWizardDialog, "IDS_CDNTW2_INPUT_VAR");
        JLabel jLabel3 = DialogUtil.createLabel(this.mWizardDialog, "IDS_CDNTW2_IN_FORMAT");
        JLabel jLabel4 = DialogUtil.createLabel(this.mWizardDialog, "IDS_CDNTW2_RES_VAR");
        JLabel jLabel5 = DialogUtil.createLabel(this.mWizardDialog, "IDS_CDNTW2_OUT_FORMAT");
        JLabel jLabel6 = DialogUtil.createLabel(this.mWizardDialog, "IDS_CDNTW2_VAR_LABEL");
        jLabel6.setLabelFor((Component)((Object)this.mVariableText));
        jLabel2.setLabelFor((Component)((Object)this.mInputVarText));
        jLabel3.setLabelFor((Component)((Object)this.mInputFormatText));
        jLabel4.setLabelFor((Component)((Object)this.mResVarText));
        jLabel5.setLabelFor(this.mOutFormatList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(this.mWizardPage, jLabel, gridBagConstraints, 1, 0, 2, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(this.mWizardPage, this.setUpListPanel(), gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(this.mWizardPage, jLabel6, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(this.mWizardPage, (JComponent)((Object)this.mVariableText), gridBagConstraints, 1, 3, 2, 1, n, insets);
        insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mWizardPage, this.setUpExecutionPanel(), gridBagConstraints, 1, 4, 2, 1, n, insets);
    }

    private JPanel setUpListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_CDNTW2_INPUT_VAR");
        JLabel jLabel2 = DialogUtil.createLabel(this.mWizardDialog, "IDS_CDNTW2_IN_FORMAT");
        JLabel jLabel3 = DialogUtil.createLabel(this.mWizardDialog, "IDS_CDNTW2_RES_VAR");
        JLabel jLabel4 = DialogUtil.createLabel(this.mWizardDialog, "IDS_CDNTW2_OUT_FORMAT");
        JLabel jLabel5 = DialogUtil.createLabel(this.mWizardDialog, "IDS_CDNTW2_VAR_LABEL");
        jLabel5.setLabelFor((Component)((Object)this.mVariableText));
        jLabel.setLabelFor((Component)((Object)this.mInputVarText));
        jLabel2.setLabelFor((Component)((Object)this.mInputFormatText));
        jLabel3.setLabelFor((Component)((Object)this.mResVarText));
        jLabel4.setLabelFor(this.mOutFormatList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap() + 15);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap() + 15);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mInputVarText), gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mInputFormatText), gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, DialogUtil.getComponentGroupGap() + 15);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap() + 15);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mResVarText), gridBagConstraints, 0, 3, 1, 1, n, insets);
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, DialogUtil.getComponentGroupGap() + 15);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 1, 2, 1, 1, n, insets);
        insets = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap() + 15);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mOutFormatPane, gridBagConstraints, 1, 3, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpExecutionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        if (VersionInfo.allowSyntax()) {
            jPanel.setBorder(BorderFactory.createTitledBorder(this.mWizardDialog.getResString("IDS_CDNTW2_EXECUTION")));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            int n = 23;
            Insets insets = DialogUtil.getStandardControlInsets();
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mCreateVarRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            DialogUtil.addUsingGBL(jPanel, this.mPasteSyntaxRadio, gridBagConstraints, 1, 0, 1, 1, n, insets);
        }
        return jPanel;
    }

    private void setFoucsTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mInputVarText);
        vector.add(this.mInputFormatText);
        vector.add(this.mResVarText);
        vector.add(this.mOutFormatList);
        vector.add(this.mVariableText);
        if (VersionInfo.allowSyntax()) {
            vector.add(this.mButtongrp);
        }
        Vector<Object> vector2 = ((DateAndTimeWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private void initVars() {
        this.mInputVarText = new StringTextField(15);
        this.mResVarText = new StringTextField(15);
        this.mResVarText.getDocument().addDocumentListener(this);
        this.mInputFormatText = new InputDateFormatTextField(15);
        this.mVariableText = new StringTextField();
        this.mOutFormatList = new SerializableList(OUTPUT_FORMAT_LIST_KEY);
        this.mOutFormatList.setCellRenderer(new DateAndTimeWizardDlg.DateIDRenederer());
        this.mOutFormatList.setCellRenderer(new DateAndTimeWizardDlg.DateIDRenederer());
        this.mOutFormatPane = new JScrollPane(this.mOutFormatList);
        Dimension dimension = this.mOutFormatList.getMinimumSize();
        dimension.width += 80;
        dimension.height += 200;
        this.mOutFormatPane.setPreferredSize(dimension);
        if (VersionInfo.allowSyntax()) {
            this.mCreateVarRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_CDNTW2_CRT_VAR"));
            this.mPasteSyntaxRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_CDNTW2_PASTE_SYNTAX"));
            this.mButtongrp = new SpssButtonGroup();
            this.mButtongrp.add(this.mCreateVarRadio);
            this.mButtongrp.add(this.mPasteSyntaxRadio);
        }
        this.mOutFormatModel = new DefaultListModel();
        this.mOutFormatList.setModel(this.mOutFormatModel);
        this.mOutFormatList.setCellRenderer(new DateAndTimeWizardDlg.DateIDRenederer());
        this.mOutFormatList.setSelectionMode(0);
        this.mOutFormatList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    CreateDateFromStringStep2WizardPage.this.setEnabledFinish();
                }
            }
        });
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setEnabledFinish();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setEnabledFinish();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setEnabledFinish();
    }

    class InputDateFormatTextField
    extends StringTextField {
        int mDateID;

        InputDateFormatTextField(int n) {
            this(n, -1);
        }

        InputDateFormatTextField(int n, int n2) {
            super(n);
            this.mDateID = -1;
            this.setDateID(n2);
        }

        public int getDateID() {
            return this.mDateID;
        }

        public void setDateID(int n) {
            this.mDateID = n;
            String string = n >= 0 ? DateAndTimeWizardDlg.mDateKeyToLocalizedStringMap.get(n) : CreateDateFromStringStep2WizardPage.this.mWizardDialog.getResString("IDS_DNTW_DATE_OR_TIME_FORMAT");
            this.setText(string);
        }
    }

    class MyCellRenderer
    extends DefaultListCellRenderer {
        MyCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            return this;
        }
    }
}

