/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.date_time_wizard;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.cache.IDataCache;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.DateAndTimeWizardDlg;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class CreateDateFromStringStep1WizardPage
extends AbstractWizardPage
implements ListSelectionListener {
    private static final int MAX_CASES_TO_INCLUDE = 100;
    private static final String SAMPLE_VALUE_LIST_KEY = "IDS_SAMPLE_VALUE_KEY";
    private static final String PATTERN_LIST_KEY = "IDS_PATTERN_LIST_KEY";
    private SrcVariableList mVariablesList;
    private JScrollPane mVariableScrollPane;
    private SerializableList mSampleValuesList;
    private JScrollPane mSampleValuePane;
    private SerializableList mPatternsList;
    private JScrollPane mPatternScrollPane;
    private DefaultListModel mPattenModel;
    private DefaultListModel mSampleModel;
    private DialogFocusTraversalPolicy mPolicy;
    protected FocusableTextArea mInfoText;

    CreateDateFromStringStep1WizardPage(BaseWizardDialog baseWizardDialog) {
        super("CDTWSTEP1OF2", baseWizardDialog.getResString("IDS_CDNTW_TITLE"), baseWizardDialog, true);
    }

    @Override
    public void init() {
        this.initVars();
        this.setDefaults();
        this.setUpWizard();
        this.setFoucsTraversalPolicy();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_dtwz_from_string1";
    }

    @Override
    public String getNextPage() {
        return "CDTWSTEP2OF2";
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.mVariablesList)) {
            SpssVariable spssVariable = (SpssVariable)this.mVariablesList.getSelectedValue();
            this.mSampleModel.clear();
            Vector<Object> vector = this.getSampleValues(spssVariable);
            for (Object object : vector) {
                this.mSampleModel.addElement(object);
            }
        }
        this.setEnabledNext();
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    public String getInputVariable() {
        return ((SpssVariable)this.mVariablesList.getSelectedValue()).getName();
    }

    public Integer getInputFormat() {
        return (Integer)this.mPatternsList.getSelectedValue();
    }

    public String getVariableLabel() {
        return ((SpssVariable)this.mVariablesList.getSelectedValue()).getLabel();
    }

    public Integer[] getOutPutFormat() {
        Integer[] integerArray = DateAndTimeWizardDlg.PATTERNS_OUTPUT_VALUES;
        Integer n = this.getInputFormat();
        int n2 = 0;
        for (Integer n3 : integerArray) {
            if (!n3.equals(n)) continue;
            n2 = 1;
            break;
        }
        for (Integer n3 : integerArray = DateAndTimeWizardDlg.PATTERNS_OTPUT_CTYPES_VALUES) {
            if (!n3.equals(n)) continue;
            n2 = 2;
            break;
        }
        if (n2 == 1 || n2 == 2) {
            integerArray = DateAndTimeWizardDlg.PATTERNS_OUTPUT_VALUES;
            return integerArray;
        }
        integerArray = DateAndTimeWizardDlg.PATTERNS_OP_DURATION_VALUES;
        return integerArray;
    }

    @Override
    public boolean validate() {
        int n = (Integer)this.mPatternsList.getSelectedValue();
        if (n == DateAndTimeWizardDlg.DD_DASH_MMM_DASH_YY || n == DateAndTimeWizardDlg.DD_DASH_MM_DASH_YY || n == DateAndTimeWizardDlg.DD_SLASH_MM_SLASH_YY || n == DateAndTimeWizardDlg.DD_DOT_MM_DOT_YY || n == DateAndTimeWizardDlg.YYDDD || n == DateAndTimeWizardDlg.Q_Q_YY || n == DateAndTimeWizardDlg.MMM_YY || n == DateAndTimeWizardDlg.WW_WK_YY || n == DateAndTimeWizardDlg.YY_SLASH_MM_SLASH_DD || n == DateAndTimeWizardDlg.YYMMDD || n == DateAndTimeWizardDlg.DDMMYY || n == DateAndTimeWizardDlg.MMDDYY) {
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            Preferences preferences2 = preferences.node("options");
            Preferences preferences3 = preferences2.node("data");
            String string = preferences3.get("begin_year", PrefDefaults.DEF_CENTURY_RANGE_BEGIN);
            String string2 = String.format("%d", Integer.valueOf(string) + 99);
            String string3 = MessageFormat.format(this.mWizardDialog.getResString("ERR_CDNTW_WRN_MSG"), string, string2);
            int n2 = this.showMessage(string3);
            return n2 == 0;
        }
        return true;
    }

    @Override
    protected void aboutToShowPanel() {
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mPolicy.getDefaultComponent((Container)((Object)this.mWizardDialog)).requestFocusInWindow();
        if (DateAndTimeWizardDlg.mLabelPanel.getComponentCount() > 0) {
            JTextArea jTextArea = (JTextArea)DateAndTimeWizardDlg.mLabelPanel.getComponent(0);
            jTextArea.setText("");
            jTextArea.setText(this.mWizardDialog.getResString("IDS_CDNTW_CREATE"));
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jTextArea.setText(this.mWizardDialog.getResString("IDS_CDNTW_CREATE_MAC"));
            } else {
                jTextArea.setText(this.mWizardDialog.getResString("IDS_CDNTW_CREATE"));
            }
        }
        this.mVariablesList.setSelectedIndex(0);
        this.setEnabledNext();
    }

    private void setFoucsTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mVariablesList);
        vector.add(this.mSampleValuesList);
        vector.add(this.mPatternsList);
        Vector<Object> vector2 = ((DateAndTimeWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private void setDefaults() {
        Integer[] integerArray;
        this.mVariablesList.loadFromActiveDataset();
        for (Integer n : integerArray = DateAndTimeWizardDlg.PATTERNS_VALUES) {
            this.mPattenModel.addElement(n);
        }
    }

    private void setEnabledNext() {
        this.mWizardDialog.enableNext(!this.mVariablesList.isSelectionEmpty() && !this.mPatternsList.isSelectionEmpty());
    }

    private int showMessage(String string) {
        return SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
    }

    private Vector<Object> getSampleValues(SpssVariable spssVariable) {
        Vector<Object> vector = new Vector<Object>();
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            IDataCache iDataCache = iSpssDataSrc.getCacheMgr();
            int n = spssVariable.getDatasetIndex();
            long l = iSpssDataSrc.rowCount() < 100L ? iSpssDataSrc.rowCount() : 100L;
            iSpssDataSrc.getCacheMgr().getCellValue(l, 0);
            int n2 = 0;
            while ((long)n2 < l) {
                if (iDataCache != null) {
                    String string = iDataCache.getCellValue((long)n2, n).getString();
                    if (iDataCache.isCellCached((long)n2, n) && !string.equals("")) {
                        vector.add(string);
                    }
                }
                ++n2;
            }
        }
        return vector;
    }

    private void setUpWizard() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.mInfoText = new FocusableTextArea(this.mWizardDialog.getResString("IDS_CDNTW_INFO_TEXT"), null);
        JPanel jPanel = TCMUtilities.createInfoPanel(this.mInfoText);
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mWizardPage, this.setUpListPanel(), gridBagConstraints, 0, 4, 1, 1, n, insets);
    }

    private JPanel setUpListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_CDNTW_VARIABLES_DOT");
        JLabel jLabel2 = DialogUtil.createLabel(this.mWizardDialog, "IDS_CDNTW_SAMPLE_VALUE");
        JLabel jLabel3 = DialogUtil.createLabel(this.mWizardDialog, "IDS_CDNTW_PATTERNS");
        jLabel.setLabelFor(this.mVariablesList);
        jLabel2.setLabelFor(this.mSampleValuesList);
        jLabel3.setLabelFor(this.mPatternsList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap() + 50, 0, DialogUtil.getComponentGroupGap() + 10);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets = new Insets(0, DialogUtil.getComponentGroupGap() + 50, 0, DialogUtil.getComponentGroupGap() + 10);
        DialogUtil.addUsingGBL(jPanel, this.mVariableScrollPane, gridBagConstraints, 0, 1, 1, 3, n, insets);
        gridBagConstraints.fill = 2;
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap() + 70);
        DialogUtil.addUsingGBL(jPanel, this.mSampleValuePane, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap() + 70);
        DialogUtil.addUsingGBL(jPanel, this.mPatternScrollPane, gridBagConstraints, 1, 3, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        this.mVariablesList = new SrcVariableList();
        this.mVariablesList.setSelectionMode(0);
        this.mVariableScrollPane = new JScrollPane(this.mVariablesList);
        this.mVariablesList.addVarFilter(new SpssVarFilter(8, false, false));
        this.mVariableScrollPane.setPreferredSize(this.mVariablesList.getMinimumSize());
        this.mVariablesList.addListSelectionListener(this);
        this.mSampleValuesList = new SerializableList(SAMPLE_VALUE_LIST_KEY);
        this.mSampleValuesList.setSelectionMode(0);
        this.mSampleValuePane = new JScrollPane(this.mSampleValuesList);
        Dimension dimension = this.mSampleValuesList.getMinimumSize();
        dimension.width += 200;
        dimension.height += 40;
        this.mSampleValuePane.setPreferredSize(dimension);
        this.mPatternsList = new SerializableList(PATTERN_LIST_KEY);
        this.mPatternsList.setCellRenderer(new DateAndTimeWizardDlg.DateIDRenederer());
        this.mPatternsList.setSelectionMode(0);
        this.mPatternScrollPane = new JScrollPane(this.mPatternsList);
        dimension = this.mPatternsList.getMinimumSize();
        dimension.width += 200;
        dimension.height += 150;
        this.mPatternScrollPane.setPreferredSize(dimension);
        this.mPatternsList.addListSelectionListener(this);
        this.mPattenModel = new DefaultListModel();
        this.mPatternsList.setModel(this.mPattenModel);
        this.mSampleModel = new DefaultListModel();
        this.mSampleValuesList.setModel(this.mSampleModel);
    }
}

