/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.date_time_wizard;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.CalculateTheNumberPage2Of3;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.DateAndTimeWizardDlg;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CalculateTheNumberPage3Of3
extends AbstractWizardPage
implements DocumentListener,
FocusListener {
    static final String FORMAT_KEY = "F5.0";
    static final String FORMAT_RETAIN_KEY = "F8.2";
    static final String WIDTH_KEY = "5";
    static final String WIDTH_RETAIN_KEY = "8";
    static final String CREATE_KEY = "IDS_DNTW_CREATE_VARIABLE";
    static final String PASTE_KEY = "IDS_DNTW_PASTE_SYNTAX";
    static final String DNTW_CALCULATE_NUMBER_STEP_THREE_PAGEID = "DNTW_CALCULATE_NUMBER_STEP_THREE";
    private StringTextField mResultVariableText;
    private StringTextField mVariableText;
    private JRadioButton mCreateRadio;
    private JRadioButton mPasteSyntaxRadio;
    private SpssButtonGroup mGroup;
    private JLabel mUnitsResultLabel;
    private JLabel mCalculationLabel;
    private CalculateTheNumberPage2Of3 mCalculateTheNumberPage2Of3;
    private int mCheckResult;
    DialogFocusTraversalPolicy mPolicy;
    private boolean mPage2Set = false;

    public CalculateTheNumberPage3Of3(BaseWizardDialog baseWizardDialog) {
        super(DNTW_CALCULATE_NUMBER_STEP_THREE_PAGEID, baseWizardDialog.getResString("IDS_DNTW_STEP_THREE_OF_THREE_TITLE"), baseWizardDialog, true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_dtwz_calculate3b";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.setFocus();
        this.setEnabledFinish();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mResultVariableText) && this.mResultVariableText.getText().length() > 0) {
            this.showMessage();
            if (this.mCheckResult == 0) {
                this.mCheckResult = 5;
                this.mVariableText.grabFocus();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setEnabledFinish();
        this.mCheckResult = 3;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setEnabledFinish();
        this.mCheckResult = 3;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setEnabledFinish();
        this.mCheckResult = 3;
    }

    @Override
    public boolean hasNextPage() {
        return false;
    }

    @Override
    public boolean isLastPage() {
        return true;
    }

    public boolean isPasteSyntaxRadioEnabled() {
        return this.mPasteSyntaxRadio != null ? this.mPasteSyntaxRadio.isSelected() : false;
    }

    public void setPage2(CalculateTheNumberPage2Of3 calculateTheNumberPage2Of3) {
        this.mCalculateTheNumberPage2Of3 = calculateTheNumberPage2Of3;
        this.mPage2Set = true;
    }

    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("* " + this.mWizardDialog.getResString("IDS_DATE_AND_TIME_WIZARD") + ": ");
        stringBuffer.append(this.mResultVariableText.getText() + SyntaxUtil.terminateSyntax());
        if (this.mCalculateTheNumberPage2Of3.getResultTreatmentRadio() == CalculateTheNumberPage2Of3.ResultType.TRUNCATE) {
            stringBuffer.append(this.generateTruncateSyntax());
        } else if (this.mCalculateTheNumberPage2Of3.getResultTreatmentRadio() == CalculateTheNumberPage2Of3.ResultType.ROUND) {
            stringBuffer.append(this.generateRoundSyntax());
        } else if (this.mCalculateTheNumberPage2Of3.getResultTreatmentRadio() == CalculateTheNumberPage2Of3.ResultType.RETAIN) {
            stringBuffer.append(this.generateRetainSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LABELS "));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText()));
        if (this.mVariableText.getText().length() > 0) {
            stringBuffer.append(" \"" + this.mVariableText.getText() + "\"");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LEVEL "));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText()));
        stringBuffer.append(" (SCALE)");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("FORMATS "));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText() + " ("));
        if (this.mCalculateTheNumberPage2Of3.getResultTreatmentRadio() == CalculateTheNumberPage2Of3.ResultType.RETAIN) {
            stringBuffer.append("F8.2)");
        } else {
            stringBuffer.append("F5.0)");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE WIDTH "));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText() + "("));
        if (this.mCalculateTheNumberPage2Of3.getResultTreatmentRadio() == CalculateTheNumberPage2Of3.ResultType.RETAIN) {
            stringBuffer.append("8)");
        } else {
            stringBuffer.append("5)");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (SyntaxUtil.readTransformationMergePrefs()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("EXECUTE"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    protected String generateTruncateSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.insert(0, SyntaxUtil.getMainCommand("COMPUTE "));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText() + "="));
        stringBuffer.append("DATEDIF(" + this.mCalculateTheNumberPage2Of3.getDate1Name().getName() + ", ");
        stringBuffer.append(this.mCalculateTheNumberPage2Of3.getDate2Name());
        String string = this.getUnitName(this.mCalculateTheNumberPage2Of3.getUnitsIndex());
        stringBuffer.append(", \"" + string + "\")");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    protected String generateRoundSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.insert(0, SyntaxUtil.getMainCommand("COMPUTE "));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText() + "="));
        String string = "";
        if (this.mCalculateTheNumberPage2Of3.getUnitsIndex() != 6) {
            string = "(";
        }
        stringBuffer.append("RND(" + string + this.mCalculateTheNumberPage2Of3.getDate1Name().getName() + " - ");
        stringBuffer.append(this.mCalculateTheNumberPage2Of3.getDate2Name() + ") " + this.getUnitValue(this.mCalculateTheNumberPage2Of3.getUnitsIndex(), true));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    protected String getUnitValue(int n, boolean bl) {
        String string;
        switch (n) {
            case 0: {
                string = "/ (365.25 * time.days(1))";
                break;
            }
            case 1: {
                string = "/ (30.4375 * time.days(1))";
                break;
            }
            case 2: {
                string = "/ (7 * time.days(1))";
                break;
            }
            case 3: {
                string = "/ time.days(1)";
                break;
            }
            case 4: {
                string = "/ time.hms(1)";
                break;
            }
            case 5: {
                string = "/ 60";
                break;
            }
            default: {
                return "";
            }
        }
        if (bl) {
            string = string + ")";
        }
        return string;
    }

    protected String generateRetainSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.insert(0, SyntaxUtil.getMainCommand("COMPUTE "));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText() + "="));
        stringBuffer.append("(" + this.mCalculateTheNumberPage2Of3.getDate1Name().getName() + " - ");
        stringBuffer.append(this.mCalculateTheNumberPage2Of3.getDate2Name() + ") " + this.getUnitValue(this.mCalculateTheNumberPage2Of3.getUnitsIndex(), false));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void init() {
        this.initVars();
        this.setupPanel();
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    @Override
    public String getNextPage() {
        return null;
    }

    @Override
    protected void aboutToShowPanel() {
        if (!this.mPage2Set) {
            this.mCalculateTheNumberPage2Of3 = (CalculateTheNumberPage2Of3)this.mWizardDialog.getWizardModel().getPage("CalculateTheNumberPage2Of3");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.mWizardDialog.getResString("IDS_DNTW_CALCULATION_SAME_LINE_LABEL"));
        stringBuffer.append("              ");
        stringBuffer.append(this.mCalculateTheNumberPage2Of3.getDate1Name().getName());
        stringBuffer.append(" - ");
        stringBuffer.append(this.mCalculateTheNumberPage2Of3.getDate2Name());
        String string = stringBuffer.toString();
        this.mCalculationLabel.setText("");
        this.mCalculationLabel.setText(string);
        if (DateAndTimeWizardDlg.mLabelPanel.getComponentCount() > 0) {
            JTextArea jTextArea = (JTextArea)DateAndTimeWizardDlg.mLabelPanel.getComponent(0);
            jTextArea.setText("");
            jTextArea.setText(string);
        }
        this.mUnitsResultLabel.setText("");
        this.mUnitsResultLabel.setText(this.mCalculateTheNumberPage2Of3.getUnitsName());
        this.setEnabledFinish();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mPolicy.getDefaultComponent((Container)((Object)this.mWizardDialog)).requestFocusInWindow();
    }

    private String getUnitName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "years";
                break;
            }
            case 1: {
                string = "months";
                break;
            }
            case 2: {
                string = "weeks";
                break;
            }
            case 3: {
                string = "days";
                break;
            }
            case 4: {
                string = "hours";
                break;
            }
            case 5: {
                string = "minutes";
                break;
            }
            case 6: {
                string = "seconds";
            }
        }
        return string;
    }

    private void setDefaults() {
        if (this.mCreateRadio != null) {
            this.mCreateRadio.setSelected(true);
        }
        if (this.mPasteSyntaxRadio != null && CommandLine.isClementineCaller()) {
            this.mPasteSyntaxRadio.setEnabled(false);
        }
        this.mResultVariableText.requestFocus();
    }

    private void initVars() {
        this.mResultVariableText = new StringTextField(16);
        this.mResultVariableText.addFocusListener(this);
        this.mResultVariableText.getDocument().addDocumentListener(this);
        this.mVariableText = new StringTextField(55);
        this.mVariableText.addFocusListener(this);
        if (VersionInfo.allowSyntax()) {
            this.mCreateRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, CREATE_KEY));
            this.mPasteSyntaxRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, PASTE_KEY));
            this.mCreateRadio.addFocusListener(this);
            this.mPasteSyntaxRadio.addFocusListener(this);
        }
        this.mCalculationLabel = new JLabel();
        this.mUnitsResultLabel = new JLabel();
    }

    private void setupPanel() {
        this.mWizardPage = this.getPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n, 0, 0);
        int n2 = 21;
        JPanel jPanel = this.setupTextAndLabelPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 1, 0, 1, 2, n2, insets);
    }

    private JPanel setupTextAndLabelPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, 0, 0);
        int n2 = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_RESULT_VARIABLE_LABEL");
        jLabel.setLabelFor((Component)((Object)this.mResultVariableText));
        JLabel jLabel2 = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_VARIABLE_LABEL");
        jLabel2.setLabelFor((Component)((Object)this.mVariableText));
        JLabel jLabel3 = new JLabel(this.mWizardDialog.getResString("IDS_DNTW_UNITS_LABEL"));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        insets.set(0, n, 0, 0);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mResultVariableText), gridBagConstraints, 0, 1, 1, 1, n2, null);
        gridBagConstraints.weightx = 1.0;
        insets.set(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mUnitsResultLabel, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mVariableText), gridBagConstraints, 0, 3, 2, 1, n2, null);
        JPanel jPanel2 = VersionInfo.allowSyntax() ? this.setupExecutionPanel() : new JPanel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 4, 2, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupExecutionPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mCreateRadio, this.mPasteSyntaxRadio};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.xaxis, this.mWizardDialog.getResString("IDS_DNTW_EXECUTION_TITLE"));
        this.mGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private boolean setEnabledFinish() {
        String string = this.mResultVariableText.getText();
        if (string.length() > 0) {
            int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
            if (n > 0 && n != 100) {
                this.mWizardDialog.enableFinish(false);
                return false;
            }
            this.mWizardDialog.enableFinish(true);
            return true;
        }
        this.mWizardDialog.enableFinish(false);
        return false;
    }

    private void showMessage() {
        String string = this.mResultVariableText.getText();
        char[] cArray = string.toCharArray();
        if (cArray.length > 0) {
            if (!this.setEnabledFinish()) {
                SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DNTW_ILLEGAL_MSG_WARNNING_MESSAGE"), VersionInfo.getAppVersionString());
            } else if (string.equals(this.mCalculateTheNumberPage2Of3.getDate1Name().getName()) || string.equals(this.mCalculateTheNumberPage2Of3.getDate2Name())) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DNTW_SAME_VARIABLE_WARNNING_MESSAGE"), VersionInfo.getAppVersionString());
            } else if (!(this.checkDuplicateVariable() || this.mCheckResult != 1 && this.mCheckResult != 3)) {
                this.mCheckResult = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DNTW_OK_TO_REPLACE_OPTION_MESSAGE"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            }
        }
    }

    private boolean checkDuplicateVariable() {
        LocallyUniqueId locallyUniqueId = null;
        String string = this.mResultVariableText.getText();
        boolean bl = false;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.columnCount();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                String string2 = iSpssVariable.getName();
                if (!string.equals(string2)) continue;
                bl = true;
            }
        }
        if (bl) {
            this.mWizardDialog.enableFinish(false);
            return false;
        }
        return true;
    }

    private void setFocus() {
        String string = this.mResultVariableText.getText();
        char[] cArray = string.toCharArray();
        if (cArray.length > 0) {
            boolean bl;
            boolean bl2 = bl = !this.setEnabledFinish() || string.equals(this.mCalculateTheNumberPage2Of3.getDate1Name().getName()) || string.equals(this.mCalculateTheNumberPage2Of3.getDate2Name());
            if (bl || !this.checkDuplicateVariable() && this.mCheckResult != 5) {
                this.mResultVariableText.grabFocus();
                this.mResultVariableText.setSelectionStart(0);
                this.mResultVariableText.setSelectionEnd(this.mResultVariableText.getText().length());
                this.mResultVariableText.requestFocus();
            }
        }
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mResultVariableText);
        vector.add(this.mVariableText);
        if (this.mGroup != null) {
            vector.add(this.mGroup);
        }
        Vector<Object> vector2 = ((DateAndTimeWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }
}

