/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.date_time_wizard;

import com.spss.java_client.core.documents.data.dictionary.DateAndTimeVariable;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssStaticText;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.DateAndTimeSrcList;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.DateAndTimeVarListModel;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.DateAndTimeWizardDlg;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CalculateTheNumberPage2Of3
extends AbstractWizardPage
implements ListDataListener {
    private DateAndTimeSrcList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private TargetVariableList mDate1TargetList;
    private TargetVariableList mMinusDate2TargetList;
    private ArrowButton mDate1ArrowButton;
    private ArrowButton mMinusDate2ArrowButton;
    private JComboBox mUnitCombo;
    private SpssButtonGroup mGroup;
    private JRadioButton mTruncateIntRadio;
    private JRadioButton mRoundIntRadio;
    private JRadioButton mRetainFractionRadio;
    static final String TRUNCATE_TO_INT = "IDS_DNTW_TRUNC_TO_INT";
    static final String ROUND_TO_INT = "IDS_DNTW_ROUND_TO_INT";
    static final String RETAIN_FRACTION = "IDS_DNTW_RETAIN_FRACTION";
    static final String CALC_NUM_PAGE_2_OF_3_PAGEID = "CalculateTheNumberPage2Of3";
    public static final int UNITS_YEARS = 0;
    public static final int UNITS_MONTHS = 1;
    public static final int UNITS_WEEKS = 2;
    public static final int UNITS_DAYS = 3;
    public static final int UNITS_HOURS = 4;
    public static final int UNITS_MINUTES = 5;
    public static final int UNITS_SECONDS = 6;
    DialogFocusTraversalPolicy mPolicy;

    public CalculateTheNumberPage2Of3(BaseWizardDialog baseWizardDialog) {
        super(CALC_NUM_PAGE_2_OF_3_PAGEID, baseWizardDialog.getResString("IDS_DNTW_STEP_TWO_OF_THREE_TITLE"), baseWizardDialog, true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_dtwz_calculate2b";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableNext();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableNext();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableNext();
    }

    @Override
    protected void aboutToShowPanel() {
        Component component;
        if (DateAndTimeWizardDlg.mLabelPanel.getComponentCount() > 0) {
            component = (JTextArea)DateAndTimeWizardDlg.mLabelPanel.getComponent(0);
            component.setText("");
            component.setText(this.mWizardDialog.getResString("IDS_DNTW_CALCULATE_THE_NUMBER"));
        }
        if (this.mWizardDialog.getGlassPane() instanceof DragPane) {
            component = this.mWizardDialog.getGlassPane();
            DragPane dragPane = (DragPane)component;
            dragPane.getDropListeners().removeAllElements();
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mSrcVarList));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mDate1TargetList));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mMinusDate2TargetList));
        }
        this.enableNext();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mPolicy.getDefaultComponent((Container)((Object)this.mWizardDialog)).requestFocusInWindow();
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public void init() {
        this.initVars();
        this.setDefaults();
        this.setupPanel();
        this.setFocusTraversalPolicy();
    }

    public String getUnitsName() {
        return this.mUnitCombo.getModel().getSelectedItem().toString();
    }

    public int getUnitsIndex() {
        return this.mUnitCombo.getSelectedIndex();
    }

    public ISpssVariable getDate1Name() {
        return this.mDate1TargetList.getModel().getElementAt(0);
    }

    public String getDate2Name() {
        return this.mMinusDate2TargetList.getModel().getElementAt(0).getName();
    }

    public ResultType getResultTreatmentRadio() {
        ResultType resultType = ResultType.TRUNCATE;
        if (this.mRoundIntRadio.isSelected()) {
            resultType = ResultType.ROUND;
        } else if (this.mRetainFractionRadio.isSelected()) {
            resultType = ResultType.RETAIN;
        }
        return resultType;
    }

    @Override
    public String getNextPage() {
        return "DNTW_CALCULATE_NUMBER_STEP_THREE";
    }

    private void enableNext() {
        if (this.mDate1TargetList.getModel().getSize() > 0 && this.mMinusDate2TargetList.getModel().getSize() > 0) {
            this.mWizardDialog.enableNext(true);
        } else {
            this.mWizardDialog.enableNext(false);
        }
    }

    private void setDefaults() {
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void populateSrcList() {
        SpssVarFilter spssVarFilter = new SpssVarFilter(32, FormatType.TIME, true);
        spssVarFilter.allowOtherTypesToInclude(false);
        spssVarFilter.allowDayToIncludeWithTime(true);
        this.mSrcVarList.addVarFilter(spssVarFilter);
        this.mSrcVarList.loadFromActiveDataset();
        DateAndTimeVarListModel dateAndTimeVarListModel = (DateAndTimeVarListModel)this.mSrcVarList.getModel();
        DateAndTimeVariable dateAndTimeVariable = new DateAndTimeVariable(this.mWizardDialog.getResString("IDS_DNTW_TIME"), this.mWizardDialog.getResString("IDS_DNTW_CURRENT_DATE_AND_TIME"));
        dateAndTimeVariable.setFormat(new SPSS_Format(FormatType.ADATE, 10, 0));
        dateAndTimeVarListModel.addElement((ISpssVariable)dateAndTimeVariable);
    }

    private void initVars() {
        this.mSrcVarList = new DateAndTimeSrcList();
        DateAndTimeVarListModel dateAndTimeVarListModel = new DateAndTimeVarListModel(this.mSrcVarList);
        this.mSrcVarList.setModel(dateAndTimeVarListModel);
        this.populateSrcList();
        this.mSrcVarList.setSelectionMode(0);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mDate1TargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mDate1TargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDate1TargetList.getModel().addListDataListener(this);
        this.mMinusDate2TargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mMinusDate2TargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mMinusDate2TargetList.getModel().addListDataListener(this);
        this.mDate1ArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDate1ArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDate1ArrowButton.registerVariableList(this.mDate1TargetList, SpssArrowButton.ButtonOrientation.left);
        this.mMinusDate2ArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mMinusDate2ArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mMinusDate2ArrowButton.registerVariableList(this.mMinusDate2TargetList, SpssArrowButton.ButtonOrientation.left);
        this.mUnitCombo = new JComboBox<String>(this.mWizardDialog.getResStringArray("IDS_DNTW_CALCULATE_THE_NUMBER_UNITS"));
        this.mTruncateIntRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, TRUNCATE_TO_INT));
        this.mRoundIntRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, ROUND_TO_INT));
        this.mRetainFractionRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, RETAIN_FRACTION));
        this.mTruncateIntRadio.setSelected(true);
    }

    private void setupPanel() {
        this.mWizardPage = this.getPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n, 0, 0);
        int n2 = 23;
        JPanel jPanel = this.setupLists();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.setMinimumSize(new Dimension(600, 3000));
        jPanel.setPreferredSize(new Dimension(600, 3000));
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
    }

    private JPanel setupLists() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_UNIT_LABEL");
        jLabel.setLabelFor(this.mUnitCombo);
        JLabel jLabel2 = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_SOURCE_VARIABLES");
        jLabel2.setLabelFor(this.mSrcVarList);
        JLabel jLabel3 = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_DATE1_LABEL");
        jLabel3.setLabelFor(this.mDate1TargetList);
        JLabel jLabel4 = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_MINUS_DATE2_LABEL");
        jLabel4.setLabelFor(this.mMinusDate2TargetList);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 11, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 20;
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDate1ArrowButton, gridBagConstraints, 1, 0, 1, 2, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mMinusDate2ArrowButton, gridBagConstraints, 1, 2, 1, 2, n, insets2);
        gridBagConstraints.weightx = 0.5;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.fill = 2;
        insets2.set(0, 0, 0, 10 * n2);
        DialogUtil.addUsingGBL(jPanel, this.mDate1TargetList, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        insets2.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 2, 1, 1, n, insets2);
        insets2.set(0, 0, 0, 10 * n2);
        DialogUtil.addUsingGBL(jPanel, this.mMinusDate2TargetList, gridBagConstraints, 2, 3, 1, 1, n, insets2);
        insets2.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 4, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        insets2.set(0, 0, 0, 10 * n2);
        DialogUtil.addUsingGBL(jPanel, this.mUnitCombo, gridBagConstraints, 2, 5, 2, 1, n, insets2);
        JLabel jLabel5 = new JLabel(this.mWizardDialog.getResString("IDS_DNTW_TIME_LABEL"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel5, gridBagConstraints, 0, 12, 2, 1, n, null);
        JPanel jPanel2 = new JPanel(true);
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.mWizardDialog.getResString("IDS_DNTW_RESULT_TREATMENT")));
        n2 = DialogUtil.getComponentGroupGap();
        Insets insets3 = new Insets(0, 0, 0, 0);
        n = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mTruncateIntRadio, gridBagConstraints, 0, 0, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel2, this.mRoundIntRadio, gridBagConstraints, 0, 1, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel2, this.mRetainFractionRadio, gridBagConstraints, 0, 2, 1, 1, n, insets3);
        this.mGroup = DialogUtil.createButtonGroup(jPanel2);
        SpssStaticText spssStaticText = new SpssStaticText(this.mWizardDialog.getResString("IDS_DNTW_MONTH_YEAR_UNITS"));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets3.set(0, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel2, spssStaticText, gridBagConstraints, 0, 3, 2, 3, n, insets3);
        insets2.set(10, 0, 0, 10 * n2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 6, 2, 6, n, insets2);
        DialogUtil.addUsingGBL(jPanel, new JLabel("ff"), gridBagConstraints, 2, 11, 2, 1, n, insets2);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mDate1ArrowButton);
        vector.add(this.mDate1TargetList);
        vector.add(this.mMinusDate2ArrowButton);
        vector.add(this.mMinusDate2TargetList);
        vector.add(this.mUnitCombo);
        vector.add(this.mGroup);
        Vector<Object> vector2 = ((DateAndTimeWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    public static enum ResultType {
        TRUNCATE,
        ROUND,
        RETAIN;

    }
}

