/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.date_time_wizard;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.AddOrSubtractPage2Of3;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.DateAndTimeWizardDlg;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddOrSubtractPage3Of3
extends AbstractWizardPage
implements DocumentListener,
FocusListener {
    static final String CREATE_KEY = "IDS_DNTW_CREATE_VARIABLE";
    static final String PASTE_KEY = "IDS_DNTW_PASTE_SYNTAX";
    static final String DNTW_ADD_OR_SUBTRACT_STEP_THREE_PAGEID = "DNTW_ADD_OR_SUBTRACT_STEP_THREE";
    private StringTextField mResultVariableText;
    private StringTextField mVariableText;
    private JRadioButton mCreateRadio;
    private JRadioButton mPasteSyntaxRadio;
    private SpssButtonGroup mGroup;
    private AddOrSubtractPage2Of3 mAddOrSubtractPage2Of3;
    private int mCheckResult;
    private DialogFocusTraversalPolicy mPolicy;

    public AddOrSubtractPage3Of3(BaseWizardDialog baseWizardDialog) {
        super(DNTW_ADD_OR_SUBTRACT_STEP_THREE_PAGEID, baseWizardDialog.getResString("IDS_DNTW_STEP_THREE_OF_THREE_TITLE"), baseWizardDialog, true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_dtwz_calculate3a";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.setFocus();
        this.setEnabledFinish();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mResultVariableText) && this.mResultVariableText.getText().length() > 0) {
            this.showMessage();
            if (this.mCheckResult == 0) {
                this.mCheckResult = 5;
                this.mVariableText.grabFocus();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setEnabledFinish();
        this.mCheckResult = 3;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setEnabledFinish();
        this.mCheckResult = 3;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setEnabledFinish();
        this.mCheckResult = 3;
    }

    @Override
    public boolean hasNextPage() {
        return false;
    }

    @Override
    public boolean isLastPage() {
        return true;
    }

    public boolean isPasteSyntaxRadioEnabled() {
        return this.mPasteSyntaxRadio != null ? this.mPasteSyntaxRadio.isSelected() : false;
    }

    @Override
    public void init() {
        this.initVars();
        this.setDefaults();
        this.setupPanel();
        this.setFocusTraversalPolicy();
    }

    @Override
    public String getNextPage() {
        return null;
    }

    public String generateSyntax() {
        String string;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("* " + this.mWizardDialog.getResString("IDS_DATE_AND_TIME_WIZARD") + ": ");
        stringBuffer.append(this.mResultVariableText.getText() + SyntaxUtil.terminateSyntax());
        String string2 = this.mAddOrSubtractPage2Of3.getOperation();
        stringBuffer.append(SyntaxUtil.getMainCommand("COMPUTE"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText()) + "=");
        if (this.mAddOrSubtractPage2Of3.getDurationFormat()) {
            stringBuffer.append(this.mAddOrSubtractPage2Of3.getDateName().getName());
            if (string2.equals("Addition")) {
                stringBuffer.append(" + ");
            } else {
                stringBuffer.append(" - ");
            }
            stringBuffer.append(this.mAddOrSubtractPage2Of3.getDurationName());
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        } else {
            stringBuffer.append("DATESUM(");
            stringBuffer.append(this.mAddOrSubtractPage2Of3.getDateName().getName() + ", ");
            if (string2.equals("Subtraction")) {
                stringBuffer.append("-");
            }
            stringBuffer.append(this.mAddOrSubtractPage2Of3.getDurationName());
            string = this.getUnitName(this.mAddOrSubtractPage2Of3.getSelectedIndexOfUnitCombo());
            stringBuffer.append(", \"" + string + "\"" + ", " + "'closest')");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LABELS"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText()));
        if (this.mVariableText.getText().length() > 0) {
            stringBuffer.append(" \"" + this.mVariableText.getText() + "\"");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LEVEL"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText()));
        string = this.mAddOrSubtractPage2Of3.getDateName().getMeasurementLevel().toString().toUpperCase();
        String string3 = this.getFormatLabel();
        boolean bl = false;
        if (string.equals("UNKNOWN")) {
            bl = true;
        }
        if (bl) {
            stringBuffer.append("(SCALE)");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("FORMATS"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText()));
            stringBuffer.append("(DATETIME20)");
        } else {
            stringBuffer.append("(" + string + ")");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("FORMATS"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText().trim()));
            stringBuffer.append("(" + string3 + ")");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE WIDTH"));
        if (bl) {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText().trim() + "(20)"));
        } else {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResultVariableText.getText() + "(" + this.getVariableWidth(string3) + ")"));
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (SyntaxUtil.readTransformationMergePrefs()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("EXECUTE"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    protected void aboutToShowPanel() {
        this.mAddOrSubtractPage2Of3 = (AddOrSubtractPage2Of3)this.mWizardDialog.getWizardModel().getPage("AddOrSubtractPage2Of3");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.mAddOrSubtractPage2Of3.getDateName().getName());
        if (this.mAddOrSubtractPage2Of3.getOperation().equals("Addition")) {
            stringBuffer.append(" + ");
        } else {
            stringBuffer.append(" - ");
        }
        stringBuffer.append(this.mAddOrSubtractPage2Of3.getDurationName());
        stringBuffer.append(" (");
        stringBuffer.append(this.mAddOrSubtractPage2Of3.getSelectedItemOfUnitCombo());
        stringBuffer.append(")");
        String string = stringBuffer.toString();
        this.mResultVariableText.grabFocus();
        if (DateAndTimeWizardDlg.mLabelPanel.getComponentCount() > 0) {
            JTextArea jTextArea = (JTextArea)DateAndTimeWizardDlg.mLabelPanel.getComponent(0);
            jTextArea.setText("");
            jTextArea.setText(this.mWizardDialog.getResString("IDS_DNTW_ENTER_NAME_LABEL") + "\n\n" + this.mWizardDialog.getResString("IDS_DNTW_CALCULATION_LABEL") + "\n" + string);
        }
        this.setEnabledFinish();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mPolicy.getDefaultComponent((Container)((Object)this.mWizardDialog)).requestFocusInWindow();
    }

    private String getVariableWidth(String string) {
        if (string.trim().length() == 0) {
            return "";
        }
        String string2 = string.substring(string.length() - 4, string.length());
        char c = string2.charAt(0);
        if (Character.isLetter(c)) {
            string2 = string.substring(string.length() - 3, string.length());
        }
        if (Character.isLetter(c = string2.charAt(0))) {
            string2 = string.substring(string.length() - 2, string.length());
        }
        if (Character.isLetter(c = string2.charAt(0))) {
            string2 = string.substring(string.length() - 1, string.length());
        }
        if (string2.endsWith("0")) {
            Double d = new Double(string2);
            string2 = String.valueOf(d.intValue());
        } else if (string2.indexOf(".") != -1) {
            Double d = new Double(string2);
            string2 = String.valueOf(d.intValue() - 1);
        }
        return string2;
    }

    private String getUnitName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "duration";
                break;
            }
            case 1: {
                string = "years";
                break;
            }
            case 2: {
                string = "months";
                break;
            }
            case 3: {
                string = "days";
                break;
            }
            case 4: {
                string = "hours";
                break;
            }
            case 5: {
                string = "minutes";
                break;
            }
            case 6: {
                string = "seconds";
                break;
            }
            case 7: {
                string = "quarters";
                break;
            }
            case 8: {
                string = "weeks";
            }
        }
        return string;
    }

    private void setDefaults() {
        if (this.mCreateRadio != null) {
            this.mCreateRadio.setSelected(true);
        }
        if (this.mPasteSyntaxRadio != null && CommandLine.isClementineCaller()) {
            this.mPasteSyntaxRadio.setEnabled(false);
        }
        this.mResultVariableText.grabFocus();
        this.mResultVariableText.requestFocus();
    }

    private void initVars() {
        this.mResultVariableText = new StringTextField(16);
        this.mResultVariableText.getDocument().addDocumentListener(this);
        this.mResultVariableText.addFocusListener(this);
        this.mVariableText = new StringTextField(55);
        this.mVariableText.addFocusListener(this);
        if (VersionInfo.allowSyntax()) {
            this.mCreateRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, CREATE_KEY));
            this.mPasteSyntaxRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, PASTE_KEY));
            this.mCreateRadio.addFocusListener(this);
            this.mPasteSyntaxRadio.addFocusListener(this);
            this.mGroup = new SpssButtonGroup();
            this.mGroup.add(this.mCreateRadio);
            this.mGroup.add(this.mPasteSyntaxRadio);
        }
    }

    private void setupPanel() {
        this.mWizardPage = this.getPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n, 0, 0, 0);
        int n2 = 21;
        JPanel jPanel = this.setupTextAndLabelPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 1, 0, 1, 2, n2, insets);
    }

    private JPanel setupTextAndLabelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n, 0, 0, 0);
        int n2 = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_RESULT_VARIABLE_LABEL");
        jLabel.setLabelFor((Component)((Object)this.mResultVariableText));
        JLabel jLabel2 = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_VARIABLE_LABEL");
        jLabel2.setLabelFor((Component)((Object)this.mVariableText));
        gridBagConstraints.fill = 2;
        n2 = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        Insets insets2 = new Insets(0, 0, 0, 250);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mResultVariableText), gridBagConstraints, 0, 4, 1, 1, n2, insets2);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 5, 1, 1, n2, insets);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mVariableText), gridBagConstraints, 0, 6, 2, 1, n2, null);
        JPanel jPanel2 = VersionInfo.allowSyntax() ? this.setupExecutionPanel() : new JPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 7, 2, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupExecutionPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mCreateRadio, this.mPasteSyntaxRadio};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.xaxis, this.mWizardDialog.getResString("IDS_DNTW_EXECUTION_TITLE"));
        this.mGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private boolean setEnabledFinish() {
        String string = this.mResultVariableText.getText();
        if (string.length() > 0) {
            int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
            if (n > 0 && n != 100) {
                this.mWizardDialog.enableFinish(false);
                return false;
            }
            this.mWizardDialog.enableFinish(true);
            return true;
        }
        this.mWizardDialog.enableFinish(false);
        return false;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mResultVariableText);
        vector.add(this.mVariableText);
        if (VersionInfo.allowSyntax()) {
            vector.add(this.mGroup);
        }
        Vector<Object> vector2 = ((DateAndTimeWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private void showMessage() {
        String string = this.mResultVariableText.getText();
        char[] cArray = string.toCharArray();
        if (cArray.length > 0) {
            if (!this.setEnabledFinish()) {
                SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DNTW_ILLEGAL_MSG_WARNNING_MESSAGE"), VersionInfo.getAppVersionString());
            } else if (string.equals(this.mAddOrSubtractPage2Of3.getDurationName()) || string.equals(this.mAddOrSubtractPage2Of3.getDateName().getName())) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DNTW_SAME_VARIABLE_WARNNING_MESSAGE"), VersionInfo.getAppVersionString());
            } else if (!(this.checkDuplicateVariable() || this.mCheckResult != 1 && this.mCheckResult != 3)) {
                this.mCheckResult = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DNTW_OK_TO_REPLACE_OPTION_MESSAGE"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            }
        }
    }

    private boolean checkDuplicateVariable() {
        LocallyUniqueId locallyUniqueId = null;
        String string = this.mResultVariableText.getText();
        boolean bl = false;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.columnCount();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                String string2 = iSpssVariable.getName();
                if (!string.equals(string2)) continue;
                bl = true;
            }
        }
        if (bl) {
            this.mWizardDialog.enableFinish(false);
            return false;
        }
        return true;
    }

    private void setFocus() {
        String string = this.mResultVariableText.getText();
        char[] cArray = string.toCharArray();
        if (cArray.length > 0) {
            boolean bl;
            boolean bl2 = bl = !this.setEnabledFinish() || string.equals(this.mAddOrSubtractPage2Of3.getDurationName()) || string.equals(this.mAddOrSubtractPage2Of3.getDateName().getName());
            if (bl || !this.checkDuplicateVariable() && this.mCheckResult != 5) {
                this.mResultVariableText.grabFocus();
                this.mResultVariableText.setSelectionStart(0);
                this.mResultVariableText.setSelectionEnd(this.mResultVariableText.getText().length());
                this.mResultVariableText.requestFocus();
            }
        }
    }

    private String getFormatLabel() {
        SPSS_Format sPSS_Format = this.mAddOrSubtractPage2Of3.getDateName().getFormat();
        int n = sPSS_Format.asInt();
        String string = new SPSS_Format(n).toString();
        return string;
    }
}

