/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.date_time_wizard;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.DateAndTimeVariable;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.DateAndTimeSrcList;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.DateAndTimeVarListModel;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.DateAndTimeWizardDlg;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class AddOrSubtractPage2Of3
extends AbstractWizardPage
implements ListDataListener,
DocumentListener,
ListSelectionListener {
    static final String ADDTION_KEY = "IDS_DNTW_OPERATION_ADDITION";
    static final String SUBSTRACTION_KEY = "IDS_DNTW_OPERATION_SUBSTRACTION";
    static final String DURATION_CONSTANT = "IDS_DNTW_DURATION_CONSTANT";
    static final int MAX_VAL = 999999999;
    static final int MIN_VAL = 0;
    static final int NUM_OF_COL = 12;
    static final String ADD_SUB_PAGE_2_OF_3_PAGEID = "AddOrSubtractPage2Of3";
    private JScrollPane mSrcScrollPane;
    private JScrollPane mDateTargetPane;
    private JScrollPane mDurationTargetPane;
    private TargetVariableList mDateTargetList;
    private TargetVariableList mDurationTargetList;
    private IntTextField mDurationConstantText;
    private DateAndTimeSrcList mSrcVarList;
    private ArrowButton mDateArrowButton;
    private ArrowButton mDurationArrowButton;
    private JRadioButton mAdditionRadio;
    private JRadioButton mSubstractionRadio;
    private SpssButtonGroup mGroup;
    private JComboBox mUnitsCombo;
    private JPanel mOperationPanel;
    private DialogFocusTraversalPolicy mPolicy;
    private DateAndTimeVariable mDateVar;

    public AddOrSubtractPage2Of3(BaseWizardDialog baseWizardDialog) {
        super(ADD_SUB_PAGE_2_OF_3_PAGEID, baseWizardDialog.getResString("IDS_DNTW_STEP_TWO_OF_THREE_TITLE"), baseWizardDialog, true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_dtwz_calculate2a";
    }

    public int getSelectedIndexOfUnitCombo() {
        return this.mUnitsCombo.getSelectedIndex();
    }

    public String getSelectedItemOfUnitCombo() {
        return this.mUnitsCombo.getModel().getSelectedItem().toString();
    }

    public ISpssVariable getDateName() {
        return this.mDateTargetList.getModel().getElementAt(0);
    }

    public String getOperation() {
        if (this.mAdditionRadio.isSelected()) {
            return "Addition";
        }
        return "Subtraction";
    }

    public String getDurationName() {
        if (this.mDurationConstantText.getText().length() > 0) {
            return this.mDurationConstantText.getText();
        }
        return this.mDurationTargetList.getModel().getElementAt(0).getName();
    }

    public boolean getDurationFormat() {
        SPSS_Format sPSS_Format;
        FormatType formatType;
        ISpssVariable iSpssVariable;
        boolean bl = false;
        if (this.mDurationTargetList.getModel().getSize() > 0 && (iSpssVariable = this.mDurationTargetList.getModel().getElementAt(0)).getType() == 0 && (formatType = (sPSS_Format = iSpssVariable.getFormat()).getFormatType()).isDateOrTimeFormat()) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.mDurationConstantText.getText().length() > 0) {
            this.mDurationArrowButton.setEnabled(false);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.listEnable();
        this.enableNext();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.listEnable();
        this.enableNext();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.listEnable();
        this.enableNext();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.listEnable();
        this.enableNext();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.listEnable();
        this.enableNext();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableNext();
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public void init() {
        this.initVars();
        this.setDefaults();
        this.setupPanel();
    }

    @Override
    public boolean validate() {
        boolean bl = false;
        String string = this.mWizardDialog.getResStringArray("IDS_DNTW_UNITS_COMBO_VALUES")[0];
        if (this.mDurationTargetList.getModel().getSize() > 0) {
            ISpssVariable iSpssVariable = this.mDurationTargetList.getModel().getElementAt(0);
            if (iSpssVariable.getType() == 0) {
                SPSS_Format sPSS_Format = iSpssVariable.getFormat();
                FormatType formatType = sPSS_Format.getFormatType();
                if (formatType.isNumericFormat()) {
                    if (this.mUnitsCombo.getSelectedItem().equals(string)) {
                        SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DNTW_UNITS_WARNNING_MESSAGE"), VersionInfo.getAppVersionString());
                        bl = false;
                    } else {
                        bl = true;
                    }
                } else if (formatType.isDateOrTimeFormat()) {
                    if (formatType.value() >= 20 && formatType.value() <= 25 && this.mUnitsCombo.getSelectedItem().equals(string)) {
                        bl = true;
                    } else {
                        SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DNTW_UNITS_WARNNING_MESSAGE"), VersionInfo.getAppVersionString());
                        bl = false;
                    }
                }
            }
        } else if (this.mDurationConstantText.getText().length() > 0) {
            if (this.mUnitsCombo.getSelectedItem().equals(string)) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DNTW_UNITS_WARNNING_MESSAGE_FOR_CONSTANT"), VersionInfo.getAppVersionString());
                bl = false;
            } else {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public String getNextPage() {
        return "DNTW_ADD_OR_SUBTRACT_STEP_THREE";
    }

    @Override
    protected void aboutToShowPanel() {
        Component component;
        this.setFocusTraversalPolicy();
        if (DateAndTimeWizardDlg.mLabelPanel.getComponentCount() > 0) {
            component = (JTextArea)DateAndTimeWizardDlg.mLabelPanel.getComponent(0);
            ((JTextComponent)component).setText("");
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                ((JTextComponent)component).setText(this.mWizardDialog.getResString("IDS_DNTW_ADD_TO_LABEL_MAC"));
            } else {
                ((JTextComponent)component).setText(this.mWizardDialog.getResString("IDS_DNTW_ADD_TO_LABEL"));
            }
        }
        if (this.mWizardDialog.getGlassPane() instanceof DragPane) {
            component = this.mWizardDialog.getGlassPane();
            DragPane dragPane = (DragPane)component;
            dragPane.getDropListeners().removeAllElements();
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mSrcVarList));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mDateTargetList));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mDurationTargetList));
        }
        this.enableNext();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mPolicy.getDefaultComponent((Container)((Object)this.mWizardDialog)).requestFocusInWindow();
    }

    private void enableNext() {
        if (this.mDateTargetList.getModel().getSize() > 0 && (this.mDurationTargetList.getModel().getSize() > 0 || this.mDurationConstantText.getText().length() > 0)) {
            this.mWizardDialog.enableNext(true);
        } else {
            this.mWizardDialog.enableNext(false);
        }
    }

    private void setDefaults() {
        this.mSrcVarList.setSelectedIndex(0);
        this.mAdditionRadio.setSelected(true);
    }

    private void initVars() {
        this.mSrcVarList = new DateAndTimeSrcList();
        DateAndTimeVarListModel dateAndTimeVarListModel = new DateAndTimeVarListModel(this.mSrcVarList);
        this.mSrcVarList.setModel(dateAndTimeVarListModel);
        this.populateSrcList();
        this.mSrcVarList.setSelectionMode(0);
        this.mSrcVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.addListSelectionListener(this);
        this.mDateTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mDateTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        SpssVarFilter spssVarFilter = new SpssVarFilter(32, FormatType.TIME, true);
        spssVarFilter.allowDayToIncludeWithTime(true);
        this.mDateTargetList.addVarFilter(spssVarFilter);
        this.mDateTargetPane = new JScrollPane(this.mDateTargetList);
        this.mDateTargetPane.setPreferredSize(this.mDateTargetList.getMinimumSize());
        this.mDateTargetPane.setHorizontalScrollBarPolicy(31);
        this.mDateTargetPane.setVerticalScrollBarPolicy(21);
        this.mDateTargetList.getModel().addListDataListener(this);
        this.mDurationTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mDurationTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        spssVarFilter = new SpssVarFilter(32, FormatType.TIME, false);
        spssVarFilter.allowOtherTypesToInclude(true);
        spssVarFilter.allowDayToIncludeWithTime(true);
        this.mDurationTargetList.addVarFilter(spssVarFilter);
        this.mDurationTargetPane = new JScrollPane(this.mDurationTargetList);
        this.mDurationTargetPane.setPreferredSize(this.mDurationTargetList.getMinimumSize());
        this.mDurationTargetPane.setHorizontalScrollBarPolicy(31);
        this.mDurationTargetPane.setVerticalScrollBarPolicy(21);
        this.mDurationTargetList.getModel().addListDataListener(this);
        TextFieldAction textFieldAction = new TextFieldAction(this.mWizardDialog, DURATION_CONSTANT);
        this.mDurationConstantText = new IntTextField(0, 999999999, true);
        this.mDurationConstantText.setAction((Action)textFieldAction);
        this.mDurationConstantText.setColumns(12);
        this.mDurationConstantText.getDocument().addDocumentListener(this);
        this.mDateArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDateArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDateArrowButton.registerVariableList(this.mDateTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mDurationArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDurationArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDurationArrowButton.registerVariableList(this.mDurationTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mUnitsCombo = new JComboBox<String>(this.mWizardDialog.getResStringArray("IDS_DNTW_UNITS_COMBO_VALUES"));
        this.mAdditionRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, ADDTION_KEY));
        this.mSubstractionRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, SUBSTRACTION_KEY));
        this.mGroup = new SpssButtonGroup();
        this.mGroup.add(this.mAdditionRadio);
        this.mGroup.add(this.mSubstractionRadio);
    }

    private void populateSrcList() {
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mSrcVarList.loadFromActiveDataset();
        DateAndTimeVarListModel dateAndTimeVarListModel = (DateAndTimeVarListModel)this.mSrcVarList.getModel();
        this.mDateVar = new DateAndTimeVariable(this.mWizardDialog.getResString("IDS_DNTW_TIME"), this.mWizardDialog.getResString("IDS_DNTW_CURRENT_DATE_AND_TIME"));
        this.mDateVar.setFormat(new SPSS_Format(FormatType.ADATE, 10, 0));
        dateAndTimeVarListModel.addElement((ISpssVariable)this.mDateVar);
    }

    private void setupPanel() {
        this.mWizardPage = this.getPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n, 0, 0);
        int n2 = 10;
        JPanel jPanel = this.setupLists();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 1, 1, 1, 1, n2, insets);
    }

    private JPanel setupLists() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_DURATION_CONSTANT_LABEL");
        jLabel.setLabelFor((Component)this.mDurationConstantText);
        JLabel jLabel2 = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_UNITS_LABEL");
        jLabel2.setLabelFor(this.mUnitsCombo);
        JLabel jLabel3 = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_SOURCE_VARIABLES");
        jLabel3.setLabelFor(this.mSrcVarList);
        JLabel jLabel4 = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_DATE_LABEL");
        jLabel4.setLabelFor(this.mDateTargetList);
        JLabel jLabel5 = DialogUtil.createLabel(this.mWizardDialog, "IDS_DNTW_DURATION_LABEL");
        jLabel5.setLabelFor(this.mDurationTargetList);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 0, 1, 1, n2, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 6, n2, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n2 = 20;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        Insets insets3 = new Insets(0, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mDateArrowButton, gridBagConstraints, 1, 0, 1, 2, n2, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mDurationArrowButton, gridBagConstraints, 1, 2, 1, 2, n2, insets3);
        n2 = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 0, 1, 1, n2, null);
        DialogUtil.addUsingGBL(jPanel, this.mDateTargetPane, gridBagConstraints, 2, 1, 1, 1, n2, null);
        insets3.set(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel5, gridBagConstraints, 2, 2, 1, 1, n2, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mDurationTargetPane, gridBagConstraints, 2, 3, 1, 1, n2, null);
        n2 = 20;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 4, 1, 1, n2, null);
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDurationConstantText, gridBagConstraints, 2, 5, 1, 1, n2, null);
        this.mOperationPanel = this.setupOpertionPanel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        insets3.set(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mOperationPanel, gridBagConstraints, 2, 6, 1, 1, n2, insets3);
        gridBagConstraints.weightx = 1.0;
        insets3.set(0, n, 0, 0);
        n2 = 10;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 3, 3, 1, 1, n2, insets3);
        insets.set(0, n, 0, 0);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        n2 = 23;
        insets3.set(0, n, 0, 5);
        DialogUtil.addUsingGBL(jPanel, this.mUnitsCombo, gridBagConstraints, 3, 4, 2, 1, n2, insets3);
        JLabel jLabel6 = new JLabel(this.mWizardDialog.getResString("IDS_DNTW_TIME_LABEL"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets3.set(0, 0, 6 * n, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel6, gridBagConstraints, 0, 7, 2, 1, n2, insets3);
        return jPanel;
    }

    private JPanel setupOpertionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.mWizardDialog.getResString("IDS_DNTW_OPERATION_TITLE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mAdditionRadio, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mSubstractionRadio, gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    private void listEnable() {
        if (this.mDurationTargetList.getModel().getSize() == 0 && this.mDurationConstantText.getText().length() == 0) {
            this.mDurationTargetList.setEnabled(true);
            this.mDurationConstantText.setEnabled(true);
            this.mDurationConstantText.setOpaque(true);
            this.mDurationArrowButton.setEnabled(true);
        }
        if (this.mDurationTargetList.getModel().getSize() > 0) {
            this.mDurationTargetList.setEnabled(true);
            this.mDurationConstantText.setEnabled(false);
            this.mDurationConstantText.setOpaque(false);
            if (this.mDurationArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.left) {
                this.mDurationArrowButton.setEnabled(true);
            } else {
                this.mDurationArrowButton.setEnabled(false);
            }
        }
        if (this.mDurationConstantText.getText().length() > 0) {
            this.mDurationTargetList.setEnabled(false);
            this.mDurationTargetList.setOpaque(false);
            this.mDurationArrowButton.setEnabled(false);
        }
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mDateArrowButton);
        vector.add(this.mDateTargetList);
        vector.add(this.mDurationArrowButton);
        vector.add(this.mDurationTargetList);
        vector.add(this.mDurationConstantText);
        vector.add(this.mGroup);
        vector.add(this.mUnitsCombo);
        Vector<Object> vector2 = ((DateAndTimeWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }
}

